/***********************************************************************************
 File:		HwSemaphore_API.h
 Module:		Semaphore
 Purpose: 	
 Description:		
				
************************************************************************************/
#ifndef HWSEMAPHORE_API_H_
#define HWSEMAPHORE_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

/* Mutual resources: Lower MAC owns locations [0-15] and Upper MAC owns locations [16-31] */
#if defined(ENET_INC_ARCH_WAVE600)
typedef enum HwSemaphoreResourceType
{
    HW_SEMAPHORE_TEST = 0,	/* Reserved for testing */        
    HW_SEMAPHORE_TID_PARAMS_WORD_1,        
	HW_SEMAPHORE_AOCS_INFO/*reserved for statistics*/,		  
	HW_SEMAPHORE_IPC,
	HW_SEMAPHORE_4,
	HW_SEMAPHORE_5,
	HW_SEMAPHORE_6,
	HW_SEMAPHORE_7,
	HW_SEMAPHORE_8,
	HW_SEMAPHORE_9,
	HW_SEMAPHORE_10,
	HW_SEMAPHORE_11,
	HW_SEMAPHORE_12,
	HW_SEMAPHORE_13,
	HW_SEMAPHORE_14,
	HW_SEMAPHORE_15,
	HW_SEMAPHORE_16,
	HW_SEMAPHORE_17,
	HW_SEMAPHORE_18,
	HW_SEMAPHORE_20,
	HW_SEMAPHORE_21,
	HW_SEMAPHORE_22,
	HW_SEMAPHORE_23,
	HW_SEMAPHORE_24,
	HW_SEMAPHORE_25,
	HW_SEMAPHORE_26,
	HW_SEMAPHORE_27,
	HW_SEMAPHORE_28,
	HW_SEMAPHORE_29,
	HW_SEMAPHORE_30,
	HW_SEMAPHORE_31,
	HW_SEMAPHORE_32,
	HW_SEMAPHORE_33,
	HW_SEMAPHORE_34,
	HW_SEMAPHORE_35,
	HW_SEMAPHORE_36,
	HW_SEMAPHORE_37,
	HW_SEMAPHORE_38,
	HW_SEMAPHORE_39,
	HW_SEMAPHORE_40,
	HW_SEMAPHORE_41,
	HW_SEMAPHORE_42,
	HW_SEMAPHORE_43,
	HW_SEMAPHORE_44,
	HW_SEMAPHORE_45,
	HW_SEMAPHORE_46,
	HW_SEMAPHORE_47,
	HW_SEMAPHORE_48,
	HW_SEMAPHORE_49,
	HW_SEMAPHORE_50,
	HW_SEMAPHORE_51,
	HW_SEMAPHORE_52,
	HW_SEMAPHORE_53,
	HW_SEMAPHORE_54,
	HW_SEMAPHORE_55,
	HW_SEMAPHORE_56,
	HW_SEMAPHORE_57,
	HW_SEMAPHORE_58,
	HW_SEMAPHORE_59,
	HW_SEMAPHORE_60,
	HW_SEMAPHORE_61,
	HW_SEMAPHORE_62,
	HW_SEMAPHORE_63,
	MAX_NUM_OF_HW_SEMAPHORE = 0xFF   
} HwSemaphoreResourceType_e;


#else

typedef enum HwSemaphoreResourceType
{
    HW_SEMAPHORE_0_16,	/* Reserved for testing */        
    HW_SEMAPHORE_1_17_TID_PARAMS_WORD_1_LM,        
	HW_SEMAPHORE_2_18_AOCS_INFO/*reserved for statistics*/,		  
	HW_SEMAPHORE_3_19_IPC,		  
	HW_SEMAPHORE_4_20,		  
	HW_SEMAPHORE_5_21,		  
	HW_SEMAPHORE_6_22,		  
	HW_SEMAPHORE_7_23,		  
	HW_SEMAPHORE_8_24,	/* Reserved for testing */		  
	HW_SEMAPHORE_9_25,		  
	HW_SEMAPHORE_10_26,		  
	HW_SEMAPHORE_11_27,		  
	HW_SEMAPHORE_12_28,		  
	HW_SEMAPHORE_13_29,
    HW_SEMAPHORE_14_30,       
    HW_SEMAPHORE_15_31,
	HW_SEMAPHORE_16_0,	/* Reserved for testing */		  
	HW_SEMAPHORE_17_1_TID_PARAMS_WORD_1_UM,		  
	HW_SEMAPHORE_18_2_AOCS_INFO,		  
	HW_SEMAPHORE_19_3_IPC,		  
	HW_SEMAPHORE_20_4,		  
	HW_SEMAPHORE_21_5,		  
	HW_SEMAPHORE_22_6,		  
	HW_SEMAPHORE_23_7,		  
	HW_SEMAPHORE_24_8,	/* Reserved for testing */		  
	HW_SEMAPHORE_25_9,		  
	HW_SEMAPHORE_26_10, 	  
	HW_SEMAPHORE_27_11, 	  
	HW_SEMAPHORE_28_12, 	  
	HW_SEMAPHORE_29_13,
	HW_SEMAPHORE_30_14, 	  
	HW_SEMAPHORE_31_15    
} HwSemaphoreResourceType_e;

#endif //#if defined(ENET_INC_ARCH_WAVE600)

//---------------------------------------------------------------------------------
//						Static Function Declaration				
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
#define HW_SEMAPHORE_LOCK(hwSemaphoreResourceType)				HwSemaphore_Lock (hwSemaphoreResourceType)
#define HW_SEMAPHORE_FREE(hwSemaphoreResourceType)				HwSemaphore_Free (hwSemaphoreResourceType)
#define HW_SEMAPHORE_TRY_LOCK(hwSemaphoreResourceType)			HwSemaphore_TryLock (hwSemaphoreResourceType)

#if defined (HW_SEMAPHORE_DEBUG)
#define HW_SEMAPHORE_READ()										HwSemaphore_Read()
#define HW_SEMAPHORE_FREE_ALL_DEBUG()							HwSemaphore_FreeAllDebug()
#endif // HW_SEMAPHORE_DEBUG

void HwSemaphore_Lock (HwSemaphoreResourceType_e hwSemaphoreResourceType);
void HwSemaphore_Free (HwSemaphoreResourceType_e hwSemaphoreResourceType);
bool HwSemaphore_TryLock (HwSemaphoreResourceType_e hwSemaphoreResourceType);


#if defined (HW_SEMAPHORE_DEBUG)
void  lmmain_HwSemaphoreTest();
uint32 HwSemaphore_Read(void);
void HwSemaphore_FreeAllDebug(void);


#endif // HW_SEMAPHORE_DEBUG
#endif // HWSEMAPHORE_API_H_
