/***********************************************************************************
 File:			InterfererDetection_Api.h
 Module:		Interferer detection 
 Purpose: 		Detect none wifi interferers
 Description:   This file contains the API of the Interferer detection module which 
 				is responsible to detect none wifi interferers such as radar
************************************************************************************/
#ifndef INTERFERER_DETECTION_API_H_
#define INTERFERER_DETECTION_API_H_

/*---------------------------------------------------------------------------------
/						includes					
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "kccmsg.h"

/*---------------------------------------------------------------------------------
/						defines				
/----------------------------------------------------------------------------------*/
#define BT_SAMPLE_SIZE 1
#define RADAR_DETECTION_SAMPLE_SIZE (sizeof(RadarDetectionSample_t))
#define MAX_NUMBER_OF_RADAR_SAMPLES_IN_MESSAGE ((K_FAST_MSG_SIZE - 1)/ RADAR_DETECTION_SAMPLE_SIZE) /* One byte is reserved for an additional field in the message */
#define MAX_NUMBER_OF_BT_INTERFERER_SAMPLES_IN_MESSAGE ((K_FAST_MSG_SIZE - 2) / BT_SAMPLE_SIZE) /* Two bytes are reserved for 2 additional fields in the message */
/*---------------------------------------------------------------------------------
/						Macros					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data type definitions					
/----------------------------------------------------------------------------------*/
typedef struct InterfererDetectionSetChannelMessageParameters_s
{	 
	uint8 channel;
#if defined RADAR_DETECTION_ENABLED
	uint8 isRadarDetectionEnabled;
	uint8 reserved[2];
#else
	uint8 reserved[3];
#endif	
} InterfererDetectionSetChannelMessageParameters_t;

typedef struct RadarDetectionSample_s
{    
	uint32 timeStamp;
	
	uint16  pulseWidth;
	uint8   ampSubBandBitMap;
	uint8   reserved;
} RadarDetectionSample_t;

typedef struct InterfererDetectionRadarDetectionSamplesMessageParameters_s
{    
	RadarDetectionSample_t     pulses[MAX_NUMBER_OF_RADAR_SAMPLES_IN_MESSAGE];
	uint8                      numberOfSamples;
} InterfererDetectionRadarDetectionSamplesMessageParameters_t;

typedef struct InterfererDetectionBtInterfererDetectionSamplesMessageParameters_s
{    
	int8     measurements[MAX_NUMBER_OF_BT_INTERFERER_SAMPLES_IN_MESSAGE];
	uint8    numberOfSamples;
	uint8    isNotificationNeeded;
} InterfererDetectionBtInterfererDetectionSamplesMessageParameters;

typedef struct InterfererDetectionSetRadioState_s
{
	uint8	radioState;
} InterfererDetectionSetRadioState_t;

/*---------------------------------------------------------------------------------
/						Public functions declarations			
/----------------------------------------------------------------------------------*/

void InterfererDetection_Initialize(void);



#endif /* INTERFERER_DETECTION_API_H_ */

