/***********************************************************************************
 File:			ContinuousInterfererDetection.h
 Module:		Interferer detection 
 Purpose: 		Detect none wifi interferers
 Description:	This file contains all the definitions and structures of the 
 				continuous interferer detection module which is responsible to 
 				detect continuous interferers (when energy is always high)
************************************************************************************/
#ifndef CONTINUOUS_INTERFERER_DETECTION_H_
#define CONTINUOUS_INTERFERER_DETECTION_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//--------------------------------------------------------------------------------- 
#define CONTINUOUS_INTERFERER_DETECTION_NUMBER_OF_METRICS 4
#define CONTINUOUS_INTERFERER_DETECTION_METRIC_INDEX_MASK (CONTINUOUS_INTERFERER_DETECTION_NUMBER_OF_METRICS - 1) /* The number of metrics must be in the form of 2^n */
#define CONTINUOUS_INTERFERER_DETECTION_DEFAULT_VALUE (-100)
#define CONTINUOUS_INTERFERER_DETECTION_MEASUREMENT_OFFSET (-47)
#define CONTINUOUS_INTERFERER_DETECTION_METRIC_OFFSET_IN_BUFFER 8
#define CONTINUOUS_INTERFERER_DETECTION_MINIMAL_VALUE (-128)

#define CONTINUOUS_INTERFERER_DETECTION_IND_BUFFER_SIZE (32)


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct ContinuousInterfererDetectionGlobalParameters_s
{
	int8	 metricsArray[CONTINUOUS_INTERFERER_DETECTION_NUMBER_OF_METRICS];
	int8	 interferenceThreshold;
	int8     maxMeasuremenet;
	uint8    maxMeasurementIndex;
	uint8    numberOfValidSamples;
	uint8    channel;
	uint8    radioState;
	uint8	 driverResponseArrived;
	uint8    reserved;
}ContinuousInterfererDetectionGlobalParameters_t;


typedef struct ContinuousInterfererDetectionIndication_s
{
	uint32	tsf;
	int8 	maxMeasuremenet;
	uint8   channel;	
}ContinuousInterfererDetectionIndication_t;

typedef struct ContinuousInterfererDetectionIndicationBuffer_s
{
	ContinuousInterfererDetectionIndication_t	continuousInterfererDetectionIndication[CONTINUOUS_INTERFERER_DETECTION_IND_BUFFER_SIZE];
	uint8										continuousInterfererWriteIndex;
	uint8										continuousInterfererReadIndex;
	uint8										numberOfPendingIndications;
	
}ContinuousInterfererDetectionIndicationBuffer_t;




//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void ContinuousInterfererDetection_ProcessSamples(K_MSG * continuousInterfererDetectionMessage);
void ContinuousInterfererDetection_DrivrResponseArrived(void);
void ContinuousInterfererDetection_ConfigureParameters(K_MSG * continuousInterfererDetectionMessage);
void ContinuousInterfererDetection_SetChannel(uint8 channel);
void ContinuousInterfererDetection_SetRadioState(uint8 radioState);
void ContinuousInterfererDetection_Initialize(void);
int8 ContinuousInterfererDetection_GetMaxMeasuremenet(void);




#endif /* CONTINUOUS_INTERFERER_DETECTION_H_ */

