/************************************************************************************
*    
*    File:		  ipc_api.h
*    Class/Module: 
*    Description: 
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

#ifndef IPC_API_H
#define IPC_API_H


#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Tasks.h"


#if defined (ENET_INC_UMAC)	
TASK (vIPC_TaskEntry);
#else
TASK (vIPC_2_TaskEntry);
#endif
void ipc_init(void);

typedef enum IpcQueueType
{
	IPC_QUEUE_TYPE_LM0_TO_UM = 0,
	IPC_QUEUE_TYPE_UM_TO_LM0,
	IPC_QUEUE_TYPE_LM1_TO_UM,
	IPC_QUEUE_TYPE_UM_TO_LM1,
	IPC_QUEUE_TYPE_LM0_TO_LM1,
	IPC_QUEUE_TYPE_LM1_TO_LM0,
	NUM_OF_IPC_QUEUE_TYPE,
	MAX_IPC_QUEUE_TYPE = 0xFF
} IpcQueueType_e;

typedef struct IpcNewMsgFromOtherCore
{
	uint32	checkMask;
	uint8	queueType;
}IpcNewMsgFromOtherCore_t;

#if defined (ENET_INC_ARCH_WAVE600)
#if defined(ENET_INC_LMAC0)
void vTLM_IPC_TO_LM0_FROM_LM1_ISR(void);
void vTLM_IPC_TO_LM_FROM_UM_ISR(void);
#endif
#if defined(ENET_INC_LMAC1)
void vTLM_IPC_TO_LM1_FROM_UM_ISR(void);
void vTLM_IPC_TO_LM1_FROM_LM0_ISR(void);
#endif
#if defined (ENET_INC_UMAC)
void vLMI_ISR_IPC_TO_UM_FROM_LM1(void);
#endif

#else //wave500
void vTLM_IPC_TO_LM_FROM_UM_ISR(void);
#endif // ENET_INC_ARCH_WAVE600

#if defined (ENET_INC_UMAC)
void vLMI_ISR_IPC_TO_UM_FROM_LM0(void);
#endif

K_MSG * vTLM_SET_IPC_MSG(IpcQueueType_e ipcQueueType, uint32 checkMask);


#endif //IPC_API_H
