/**************************************************************************
***************************************************************************
**
** COMPONENT:        ipc.c
**
** MODULE:          
**
** VERSION:          $Revision: #10 $
**
** AUTHOR:           
**
** DESCRIPTION:      
**
***************************************************************/
//---------------------------------------------------------------------------------
//						Includes									
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "stringLibApi.h"
#include "queue_utility.h"
#include "init_ifmsg.h"
#include "shram_man_msgs.h"
#include "loggerAPI.h"
#include "Utils_Api.h"
#include "ErrorHandler_Api.h"
#include "lm_interface.h"
#include "HwSemaphore_API.h"
#include "int_gen.h"
#if defined (ENET_INC_LMAC)
#include "lm.h"
#include "lmi.h"
#endif
#if defined (ENET_INC_ARCH_WAVE600)
#include "ConfigurationManager_api.h"
#endif
#include "shram_man_queues.h"
#include "ipc_api.h"
#include "Pac_Api.h"
#include "InterruptManager_Api.h"
#include "lm_statistics.h"
#include "Debug_Trace.h"
/*************************************************************************/
/***						Local defines							   ***/
/*************************************************************************/

#define LOG_LOCAL_GID   GLOBAL_GID_IPC
#define LOG_LOCAL_FID 0
#if defined (ENET_INC_ARCH_WAVE600)
#define IPC_DEBUG 1
#else
#define IPC_DEBUG 1
#endif


#if defined (ENET_INC_ARCH_WAVE600)
#define SIZE_OF_IPC_DEBUG 	(256)
#else
#define SIZE_OF_IPC_DEBUG 	(16)
#endif

#if (IPC_DEBUG)
typedef struct ipc_Debug_t
{
	uint32 tsf;
	uint32 ipcMsg;
	uint32 size;
	K_TASKID to;
	byte	bListNoAndRefCount;
	byte	bPersistentMsg;
	bool 	fromOtherCore;
}ipc_Debug_t;

typedef struct ipc_Debug_Db_t
{
	ipc_Debug_t 	ipc_Debug[SIZE_OF_IPC_DEBUG];
	uint16 			ipcInd;
}ipc_Debug_Db_t;

ipc_Debug_Db_t ipcDb = {0};

#endif //IPC_DEBUG


typedef enum
{
	TASK_LOCATION_UM_CORE = 0,
	TASK_LOCATION_LM_1_CORE,
#if defined(ENET_INC_ARCH_WAVE600)
	TASK_LOCATION_LM_2_CORE,
	TASK_LOCATION_LM_1_LM_2_CORE,
#endif
	TASK_LOCATION_INVALID,
	NUM_OF_TASK_LOCATION_TYPE,
	MAX_TASK_LOCATION_TYPE = 0xFF
} Tasks_location_e;




typedef void (*sendMsgToOtherCore_t)(K_MSG *);

/****************************************************************************/
/* Functions Prototypes                                                     */
/****************************************************************************/

static void sendMsgToUm(K_MSG *pMsg);
static void sendMsgToLm0(K_MSG *pMsg);
#if defined(ENET_INC_ARCH_WAVE600)
static void sendMsgToLm1(K_MSG *pMsg);
static void sendMsgToLm0OrLm1(K_MSG *pMsg);
#endif
static void sendMsgAssert(K_MSG *pMsg);
#if (IPC_DEBUG)
void ipcDebug (K_MSG* ptK_MSG, uint8 fromOtherCore);
#endif

/****************************************************************************/
/* Static Data                                                              */
/****************************************************************************/

#if defined(ENET_INC_ARCH_WAVE600)	
const Tasks_location_e taskLocationTable[NUM_OF_CONFIGURATION_MODE][NUM_OF_TASKS_IN_SYSTEM]=
{
	{
		TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_TICK,
		TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_HIGH,
		TASK_LOCATION_INVALID,				//TASK_IPC_2,
		TASK_LOCATION_LM_1_CORE,			//TASK_LINK_ADAPTATION,
		TASK_LOCATION_LM_1_CORE,			//TASK_PAC_MANAGER,
		TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_MID,
		TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_LOW,
		TASK_LOCATION_UM_CORE,				//TASK_UM_IF_TASK,
		TASK_LOCATION_UM_CORE,				//TASK_BSS_MANAGE,
		TASK_LOCATION_UM_CORE,				//TASK_TS_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_QOS,
		TASK_LOCATION_UM_CORE,				//TASK_ENCRYPTION,
		TASK_LOCATION_UM_CORE,				//TASK_LOGGER,
		TASK_LOCATION_INVALID,				//TASK_IPC,
#ifdef PTA_BUILD_IN_PLAT		
		TASK_LOCATION_UM_CORE,				//TASK_PTA,
#endif
		TASK_LOCATION_LM_1_CORE,			//TASK_DUT,
		TASK_LOCATION_LM_1_CORE,			//TASK_INTERFERER_DETECTION,			
		TASK_LOCATION_LM_1_CORE,			//TASK_COC,
		TASK_LOCATION_LM_1_CORE,			//TASK_HDK,
		TASK_LOCATION_UM_CORE,				//TASK_HIM,
		TASK_LOCATION_UM_CORE,				//TASK_RX_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_TX_MANAGER,	
		TASK_LOCATION_UM_CORE,				//TASK_BSS_MANAGER,
		TASK_LOCATION_LM_1_CORE,			//TASK_CHANNEL_SWITCH_MANAGER,
#ifdef USE_AGER_EMULATOR
		TASK_LOCATION_UM_CORE, 				//TASK_AGER_EMULATOR,
#endif //USE_AGER_EMULATOR
		TASK_LOCATION_UM_CORE,				//TASK_STATISTICS_MANAGER,
		TASK_LOCATION_LM_1_CORE,			//TASK_PROCESS_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_GROUP_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_ATF,
		TASK_LOCATION_UM_CORE,				//TASK_HE_GROUP_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_PLAN_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_TWT_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_HDK_CDB_MANAGER
#ifdef HDK_CDB_SUPPORT
		TASK_LOCATION_UM_CORE				//TASK_PROCESS_MANAGER_CDB,
#endif
	},
	{
		TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_TICK,
		TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_HIGH,
		TASK_LOCATION_INVALID,				//TASK_IPC_2,
		TASK_LOCATION_LM_1_LM_2_CORE,		//TASK_LINK_ADAPTATION,
		TASK_LOCATION_LM_1_LM_2_CORE,		//TASK_PAC_MANAGER,
		TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_MID,
		TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_LOW,
		TASK_LOCATION_UM_CORE,				//TASK_UM_IF_TASK,
		TASK_LOCATION_UM_CORE,				//TASK_BSS_MANAGE,
		TASK_LOCATION_UM_CORE,				//TASK_TS_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_QOS,
		TASK_LOCATION_UM_CORE,				//TASK_ENCRYPTION,
		TASK_LOCATION_UM_CORE,				//TASK_LOGGER,
		TASK_LOCATION_INVALID,				//TASK_IPC,
#ifdef PTA_BUILD_IN_PLAT		
		TASK_LOCATION_UM_CORE,				//TASK_PTA,
#endif
		TASK_LOCATION_LM_1_LM_2_CORE,		//TASK_DUT,
		TASK_LOCATION_LM_1_LM_2_CORE,		//TASK_INTERFERER_DETECTION,			
		TASK_LOCATION_LM_1_LM_2_CORE,		//TASK_COC,
		TASK_LOCATION_LM_1_LM_2_CORE,		//TASK_HDK,
		TASK_LOCATION_UM_CORE,				//TASK_HIM,
		TASK_LOCATION_UM_CORE,				//TASK_RX_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_TX_MANAGER,	
		TASK_LOCATION_UM_CORE,				//TASK_BSS_MANAGER,
		TASK_LOCATION_LM_1_LM_2_CORE,		//TASK_CHANNEL_SWITCH_MANAGER,
#ifdef USE_AGER_EMULATOR
		TASK_LOCATION_UM_CORE,				//TASK_AGER_EMULATOR,
#endif //USE_AGER_EMULATOR
		TASK_LOCATION_UM_CORE,				//TASK_STATISTICS_MANAGER,
		TASK_LOCATION_LM_1_LM_2_CORE,		//TASK_PROCESS_MANAGER
		TASK_LOCATION_UM_CORE,				//TASK_GROUP_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_ATF,
		TASK_LOCATION_UM_CORE,				//TASK_HE_GROUP_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_PLAN_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_TWT_MANAGER,
		TASK_LOCATION_UM_CORE,				//TASK_HDK_CDB_MANAGER
#ifdef HDK_CDB_SUPPORT
		TASK_LOCATION_UM_CORE 				//TASK_PROCESS_MANAGER_CDB,
#endif
	}
};

#else // defined(ENET_INC_ARCH_WAVE600)	
const Tasks_location_e taskLocationTable[NUM_OF_TASKS_IN_SYSTEM]=
{
	TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_TICK,
	TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_HIGH,
	TASK_LOCATION_INVALID,				//TASK_IPC_2,
	TASK_LOCATION_LM_1_CORE,			//TASK_LINK_ADAPTATION,
	TASK_LOCATION_LM_1_CORE,			//TASK_PAC_MANAGER,
	TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_MID,
	TASK_LOCATION_INVALID,				//TASK_KNL_TIMER_LOW,
	TASK_LOCATION_UM_CORE,				//TASK_UM_IF_TASK,
	TASK_LOCATION_UM_CORE,				//TASK_BSS_MANAGE,
	TASK_LOCATION_UM_CORE,				//TASK_TS_MANAGER,
	TASK_LOCATION_UM_CORE,				//TASK_QOS,
	TASK_LOCATION_UM_CORE,				//TASK_ENCRYPTION,
	TASK_LOCATION_UM_CORE,				//TASK_LOGGER,
	TASK_LOCATION_INVALID,				//TASK_IPC,
#ifdef PTA_BUILD_IN_PLAT		
	TASK_LOCATION_UM_CORE,				//TASK_PTA,
#endif
	TASK_LOCATION_UM_CORE,				//TASK_DUT,
	TASK_LOCATION_UM_CORE,				//TASK_INTERFERER_DETECTION,			
	TASK_LOCATION_UM_CORE,				//TASK_COC,
	TASK_LOCATION_UM_CORE,				//TASK_HDK,
	TASK_LOCATION_UM_CORE,				//TASK_HIM,
	TASK_LOCATION_UM_CORE,				//TASK_RX_MANAGER,
	TASK_LOCATION_UM_CORE,				//TASK_TX_MANAGER,	
	TASK_LOCATION_UM_CORE,				//TASK_BSS_MANAGER,
	TASK_LOCATION_UM_CORE,				//TASK_CHANNEL_SWITCH_MANAGER,
#ifdef USE_AGER_EMULATOR
	TASK_LOCATION_UM_CORE, 				//TASK_AGER_EMULATOR,
#endif //USE_AGER_EMULATOR
	TASK_LOCATION_UM_CORE,				//TASK_STATISTICS_MANAGER,
	TASK_LOCATION_UM_CORE,				//TASK_PROCESS_MANAGER
	TASK_LOCATION_UM_CORE,				//TASK_GROUP_MANAGER,
	TASK_LOCATION_UM_CORE,				//TASK_ATF,
	TASK_LOCATION_LM_1_CORE,			//TASK_HDK_CDB_MANAGER,
#ifdef HDK_CDB_SUPPORT
	TASK_LOCATION_UM_CORE 				//TASK_PROCESS_MANAGER_CDB,
#endif
};

#endif // defined(ENET_INC_ARCH_WAVE600)	


#if defined(ENET_INC_ARCH_WAVE600)
BandConfigurationMode_e ipcConfigMode;
#endif


const sendMsgToOtherCore_t sendMsgToOtherCore[NUM_OF_TASK_LOCATION_TYPE] =  
{
	sendMsgToUm,
	sendMsgToLm0,
#if defined(ENET_INC_ARCH_WAVE600)
	sendMsgToLm1,
	sendMsgToLm0OrLm1,
#endif
	sendMsgAssert,
};

const LM_MAN_QUEUE    *pQueueType[NUM_OF_IPC_QUEUE_TYPE]=
{
	&sLM0toUMfifo,		//QUEUE_TYPE_LM0_TO_UM 
	&sUMtoLM0fifo,		//QUEUE_TYPE_UM_TO_LM0
#if defined(ENET_INC_ARCH_WAVE600)
	&sLM1toUMfifo,		//QUEUE_TYPE_LM1_TO_UM
	&sUMtoLM1fifo,		//QUEUE_TYPE_UM_TO_LM1
	&sLM0toLM1fifo,		//QUEUE_TYPE_LM0_TO_LM1
	&sLM1toLM0fifo,		//QUEUE_TYPE_LM1_TO_LM0
#endif
};


/**********************************************************************************/
/* Functions Definitions                                                    	 */
/**********************************************************************************/

/**********************************************************************************

ipcDebug


Description:
----------
Handle massages from LM to UM and LM to UM
	
**********************************************************************************/
#if (IPC_DEBUG)

void ipcDebug (K_MSG* ptK_MSG, uint8 fromOtherCore)
{
#if defined (ENET_INC_UMAC)	
	ILOG2_DD("IPC UM Debug - MSG from other core: %d : MsgType: 0x%x", fromOtherCore,ptK_MSG->header.tKMsgType);
#else
	ILOG2_DD("IPC LM Debug - MSG from other core: %d : MsgType: 0x%x", fromOtherCore,ptK_MSG->header.tKMsgType);
#endif

	ipcDb.ipc_Debug[ipcDb.ipcInd].tsf = GET_TSF_TIMER_LOW();
	ipcDb.ipc_Debug[ipcDb.ipcInd].ipcMsg =  ptK_MSG->header.tKMsgType;
	ipcDb.ipc_Debug[ipcDb.ipcInd].size = ptK_MSG->header.payloadSize;
	ipcDb.ipc_Debug[ipcDb.ipcInd].to = ptK_MSG->header.sTo.taskID;
	ipcDb.ipc_Debug[ipcDb.ipcInd].bListNoAndRefCount = ptK_MSG->header.bListNoAndRefCount;
	ipcDb.ipc_Debug[ipcDb.ipcInd].bPersistentMsg =  ptK_MSG->header.bPersistentMsg;
	ipcDb.ipc_Debug[ipcDb.ipcInd].fromOtherCore = fromOtherCore;
	ipcDb.ipcInd++;
	if (ipcDb.ipcInd == SIZE_OF_IPC_DEBUG) ipcDb.ipcInd =0;
}
#endif


/**********************************************************************************

vIPC_TaskEntry/ vIPC_2_TaskEntry

Description:
----------
Handle massages from LM to UM and LM to UM
	
**********************************************************************************/
#if defined (ENET_INC_UMAC)	
void vIPC_TaskEntry(K_MSG *psMsg)
#else
void vIPC_2_TaskEntry(K_MSG * psMsg)
#endif
{
	if (psMsg->header.tKMsgType == IPC_NEW_MSG_FROM_OTHER_CORE)
	{// message arrived from the other core
		IpcNewMsgFromOtherCore_t *ipcNewMsgFromOtherCore_p = (IpcNewMsgFromOtherCore_t *)pK_MSG_DATA( psMsg );
		K_MSG * ptK_MSGinputMsg;
		K_MSG *	kMsgLocal_p;
		LM_MAN_QUEUE    *pQueue;
		uint8 bListNoAndRefCountTemp;
		uint8 bPersistentMsgTemp;
		
		pQueue = (LM_MAN_QUEUE *)pQueueType[ipcNewMsgFromOtherCore_p->queueType];
		
#if defined (ENET_INC_LMAC)
		vClearSignalMask(ipcNewMsgFromOtherCore_p->checkMask);
#endif		
		while ((ptK_MSGinputMsg = (K_MSG *)pvGetMsgQ(pQueue)) != 0)//get a message from the relevant queue
		{
			if ((IS_ADDRESS_IN_SHRAM((uint32)(*(K_MSG **)ptK_MSGinputMsg->abData)) || IS_ADDRESS_IN_TX_RECIPES_B1((uint32)(*(K_MSG **)ptK_MSGinputMsg->abData)))&& (ptK_MSGinputMsg->header.dispBit != 1))
			{	
				//the data of the msg is in the SHRAM.
				//WLANRTSYS-11712 - When driver sends message, it is copied to B1 Tx Circular Buffer as part of secure host message.
				kMsgLocal_p = *(K_MSG **)ptK_MSGinputMsg->abData;
			}
			else
			{
				//get local msg and copy the shram msg				
				kMsgLocal_p =  OSAL_GET_MESSAGE(ptK_MSGinputMsg->header.payloadSize);			
				bListNoAndRefCountTemp = kMsgLocal_p->header.bListNoAndRefCount;
				bPersistentMsgTemp = kMsgLocal_p->header.bPersistentMsg;
				MEMCPY(kMsgLocal_p,ptK_MSGinputMsg,ptK_MSGinputMsg->header.payloadSize + sizeof(K_MSG_HEADER));
				kMsgLocal_p->header.bListNoAndRefCount = bListNoAndRefCountTemp;
				kMsgLocal_p->header.bPersistentMsg = bPersistentMsgTemp;
			}
			//start of free the shram
#if defined(ENET_INC_ARCH_WAVE600)		
			HW_SEMAPHORE_LOCK(HW_SEMAPHORE_IPC);
#else
#if defined (ENET_INC_UMAC)			
			HW_SEMAPHORE_LOCK(HW_SEMAPHORE_19_3_IPC);
#else
			HW_SEMAPHORE_LOCK(HW_SEMAPHORE_3_19_IPC);
#endif
#endif
			//reset the bListNoAndRefCount
			ptK_MSGinputMsg->header.bListNoAndRefCount = 0xe0;
			ptK_MSGinputMsg->header.psNext= NULL;
			
			if (shRamMsgQ.tail == NULL)
			{/* list is empty */
				shRamMsgQ.tail = shRamMsgQ.head = ptK_MSGinputMsg;
			}
			else
			{/* list is not empty */
				shRamMsgQ.tail->header.psNext = ptK_MSGinputMsg;
				shRamMsgQ.tail = ptK_MSGinputMsg;
			}
#if defined(ENET_INC_ARCH_WAVE600)		
			HW_SEMAPHORE_FREE(HW_SEMAPHORE_IPC);
#else
#if defined (ENET_INC_UMAC)	
			HW_SEMAPHORE_FREE(HW_SEMAPHORE_19_3_IPC);
#else
			HW_SEMAPHORE_FREE(HW_SEMAPHORE_3_19_IPC);
#endif
#endif
			//End of free the shram
#if (IPC_DEBUG)
			ipcDebug (kMsgLocal_p,1);
#endif
			//send the msg
			OSAL_SEND_MESSAGE(kMsgLocal_p->header.tKMsgType,kMsgLocal_p->header.sTo.taskID,kMsgLocal_p, VAP_ID_DO_NOT_CARE);			
		}	
	}
	else
	{// message to the other core		
		//start alloce shram msg
		K_MSG *psMsgShram = NULL;



#if defined(ENET_INC_ARCH_WAVE600)		
		HW_SEMAPHORE_LOCK(HW_SEMAPHORE_IPC);
#else
#if defined (ENET_INC_UMAC)	
		HW_SEMAPHORE_LOCK(HW_SEMAPHORE_19_3_IPC);
#else
		HW_SEMAPHORE_LOCK(HW_SEMAPHORE_3_19_IPC);
#endif
#endif

		if (shRamMsgQ.head)
		{ 
			psMsgShram = shRamMsgQ.head;

			shRamMsgQ.head = shRamMsgQ.head->header.psNext;
			if (shRamMsgQ.head == NULL)
			{
				shRamMsgQ.tail= NULL;
			}
		}
#if defined(ENET_INC_ARCH_WAVE600)		
		HW_SEMAPHORE_FREE(HW_SEMAPHORE_IPC);
#else
#if defined (ENET_INC_UMAC)	
		HW_SEMAPHORE_FREE(HW_SEMAPHORE_19_3_IPC);
#else
		HW_SEMAPHORE_FREE(HW_SEMAPHORE_3_19_IPC);
#endif
#endif
		//end alloce shram msg

		ASSERT(psMsgShram);		

		if (IS_ADDRESS_IN_SHRAM((uint32)psMsg) || IS_ADDRESS_IN_TX_RECIPES_B1((uint32)psMsg))
		{//msg on the shram
			//WLANRTSYS-11712 - When driver sends message, it is copied to B1 Tx Circular Buffer as part of secure host message.
			MEMCPY(psMsgShram, psMsg,sizeof(K_MSG_HEADER));
			MEMCPY (psMsgShram->abData,&psMsg,sizeof(K_MSG *));
			psMsgShram->header.dispBit = 0;
		}
		else
		{// copy message from local ram to shram
			MEMCPY(psMsgShram, psMsg, psMsg->header.payloadSize + sizeof(K_MSG_HEADER));
			psMsgShram->header.dispBit = 1;
		}
		//update the bListNoAndRefCount
		psMsgShram->header.bListNoAndRefCount =0xe1;

#if (IPC_DEBUG)
		ipcDebug (psMsgShram,0);
#endif

#if ((IPC_DEBUG) && (defined (ENET_INC_UMAC)) && (defined (ENET_INC_ARCH_WAVE600)))
		ASSERT((psMsg->header.vapId != INVALID_VAP))
#endif


#if defined(ENET_INC_ARCH_WAVE600)	
		sendMsgToOtherCore[taskLocationTable[ipcConfigMode][psMsgShram->header.sTo.taskID]](psMsgShram);
#else
		sendMsgToOtherCore[taskLocationTable[psMsgShram->header.sTo.taskID]](psMsgShram);
#endif
	}
}
/**********************************************************************************

sendMsgToUm

Description:
----------
Handle massages to UM 
	
**********************************************************************************/

static void sendMsgToUm(K_MSG *pMsg)
{
#if defined (ENET_INC_LMAC0)
	LM_MAN_QUEUE    *pQueue = &sLM0toUMfifo;
	//add a message to the relevant queue
	vPutMsgQ(pMsg, pQueue);
	//generates an interrupt to the other core
	vIGEN_SendToUm( IGEN_EVT_IPC_TO_UM_FROM_LM0 );
#endif

#if defined (ENET_INC_LMAC1)
	LM_MAN_QUEUE    *pQueue = &sLM1toUMfifo;
	//add a message to the relevant queue
	vPutMsgQ(pMsg, pQueue);
	//generates an interrupt to the other core
	vIGEN_SendToUm( IGEN_EVT_IPC_TO_UM_FROM_LM1 );
#endif

#if defined (ENET_INC_UMAC)
	UNUSED_PARAM(pMsg);
	FATAL("IPC - wrong msg destination");
#endif
}
/**********************************************************************************

sendMsgToLm0

Description:
----------
Handle massages to lM 0
	
**********************************************************************************/

static void sendMsgToLm0(K_MSG *pMsg)
{
#if defined (ENET_INC_UMAC)	

	LM_MAN_QUEUE	*pQueue = &sUMtoLM0fifo;
	//add a message to the relevant queue
	vPutMsgQ(pMsg, pQueue);
	//generates an interrupt to the other core
	vIGEN_SendToLm0( IGEN_EVT_IPC_TO_LM0_FROM_UM );
#endif

#if defined (ENET_INC_LMAC1)
	LM_MAN_QUEUE    *pQueue = &sLM1toLM0fifo;
	//add a message to the relevant queue
	vPutMsgQ(pMsg, pQueue);
	//generates an interrupt to the other core
	vIGEN_SendToLm0( IGEN_EVT_IPC_TO_LM0_FROM_LM1 );
#endif

#if defined (ENET_INC_LMAC0)
	UNUSED_PARAM(pMsg);
	ASSERT(0);
#endif
}

#if defined(ENET_INC_ARCH_WAVE600)
/**********************************************************************************

sendMsgToLm1

Description:
----------
Handle massages to lM 1
	
**********************************************************************************/

static void sendMsgToLm1(K_MSG *pMsg)
{
#if defined (ENET_INC_UMAC)	

	LM_MAN_QUEUE	*pQueue = &sUMtoLM1fifo;
	//add a message to the relevant queue
	vPutMsgQ(pMsg, pQueue);
	//generates an interrupt to the other core
	vIGEN_SendToLm1( IGEN_EVT_IPC_TO_LM1_FROM_UM );
#endif

#if defined (ENET_INC_LMAC0)
	LM_MAN_QUEUE    *pQueue = &sLM0toLM1fifo;
	//add a message to the relevant queue
	vPutMsgQ(pMsg, pQueue);
	//generates an interrupt to the other core
	vIGEN_SendToLm1( IGEN_EVT_IPC_TO_LM1_FROM_LM0 );
#endif

#if defined (ENET_INC_LMAC1)
	UNUSED_PARAM(pMsg);
	FATAL("IPC - wrong msg destination");
#endif
}

/**********************************************************************************

sendMsgToLm0OrLm1

Description:
----------
Handle massages to lM 0 or 1 
	
**********************************************************************************/

static void sendMsgToLm0OrLm1(K_MSG *pMsg)
{
	if (ConfigurationManager_GetBandForVap(pMsg->header.vapId) ==  CONFIGURATION_MANAGER_BAND_0) 
	{
		sendMsgToLm0(pMsg);
	}
	else
	{
		sendMsgToLm1(pMsg);
	}
}
#endif //#if defined(ENET_INC_ARCH_WAVE600)

/**********************************************************************************

sendMsgAssert

Description:
----------

	
**********************************************************************************/

static void sendMsgAssert(K_MSG *pMsg)
{
	UNUSED_PARAM(pMsg);	
	FATAL("IPC - wrong task location");
}

#if defined (ENET_INC_LMAC0)

/****************************************************************************
 **
 ** NAME:           vTLM_IPC_TO_LM0_FROM_LM1_ISR
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  void
 **
 ** DESCRIPTION:    ISR routine for LM event TLM_EVT_M_REQ_RES.
 **					Management message in queue.
 **
 ***************************************************************************/
void vTLM_IPC_TO_LM0_FROM_LM1_ISR(void)
{
	MT_LM_STAT_INC(MT_LM_STAT_EVT_UM_M_REQ_RES);
	AAA_DEBUG_LMI_MACRO(AAA_DebugLmi_vTLM_M_REQ_RES_ISR, u32SignalMask, IGEN_CHECK_MASK(vGetSignalMask(),IGEN_EVT_IPC_TO_LM0_FROM_LM1));
    if (IGEN_CHECK_MASK(vGetSignalMask(),IGEN_EVT_IPC_TO_LM0_FROM_LM1))
    {
		K_MSG *pMsg = vTLM_SET_IPC_MSG(IPC_QUEUE_TYPE_LM1_TO_LM0, IGEN_EVT_IPC_TO_LM0_FROM_LM1);
		vSetSignalMask(IGEN_EVT_IPC_TO_LM0_FROM_LM1);
		OSAL_SEND_MESSAGE(IPC_NEW_MSG_FROM_OTHER_CORE, TASK_IPC_2, pMsg, VAP_ID_DO_NOT_CARE);
    }
}
#endif // ENET_INC_LMAC0

#if defined (ENET_INC_LMAC1)

/****************************************************************************
 **
 ** NAME:           vTLM_IPC_TO_LM_FROM_UM_ISR
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  void
 **
 ** DESCRIPTION:    ISR routine for LM event TLM_EVT_M_REQ_RES.
 **					Management message in queue.
 **
 ***************************************************************************/
void vTLM_IPC_TO_LM1_FROM_UM_ISR(void)
{
	MT_LM_STAT_INC(MT_LM_STAT_EVT_UM_M_REQ_RES);
	AAA_DEBUG_LMI_MACRO(AAA_DebugLmi_vTLM_M_REQ_RES_ISR, u32SignalMask, IGEN_CHECK_MASK(vGetSignalMask(),IGEN_EVT_IPC_TO_LM1_FROM_UM));
    if (IGEN_CHECK_MASK(vGetSignalMask(),IGEN_EVT_IPC_TO_LM1_FROM_UM))
    {
		K_MSG *pMsg = vTLM_SET_IPC_MSG(IPC_QUEUE_TYPE_UM_TO_LM1, IGEN_EVT_IPC_TO_LM1_FROM_UM);
        vSetSignalMask(IGEN_EVT_IPC_TO_LM1_FROM_UM);
		OSAL_SEND_MESSAGE(IPC_NEW_MSG_FROM_OTHER_CORE, TASK_IPC_2, pMsg, VAP_ID_DO_NOT_CARE);
    }
}


/****************************************************************************
 **
 ** NAME:           vTLM_IPC_TO_LM0_FROM_LM1_ISR
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  void
 **
 ** DESCRIPTION:    ISR routine for LM event TLM_EVT_M_REQ_RES.
 **					Management message in queue.
 **
 ***************************************************************************/
void vTLM_IPC_TO_LM1_FROM_LM0_ISR(void)
{
	MT_LM_STAT_INC(MT_LM_STAT_EVT_UM_M_REQ_RES);
	AAA_DEBUG_LMI_MACRO(AAA_DebugLmi_vTLM_M_REQ_RES_ISR, u32SignalMask, IGEN_CHECK_MASK(vGetSignalMask(),IGEN_EVT_IPC_TO_LM1_FROM_LM0));
    if (IGEN_CHECK_MASK(vGetSignalMask(),IGEN_EVT_IPC_TO_LM1_FROM_LM0))
    {
		K_MSG *pMsg = vTLM_SET_IPC_MSG(IPC_QUEUE_TYPE_LM0_TO_LM1, IGEN_EVT_IPC_TO_LM1_FROM_LM0);
		vSetSignalMask(IGEN_EVT_IPC_TO_LM1_FROM_LM0);
		OSAL_SEND_MESSAGE(IPC_NEW_MSG_FROM_OTHER_CORE, TASK_IPC_2, pMsg, VAP_ID_DO_NOT_CARE);
    }
}
#endif //ENET_INC_LMAC1

/****************************************************************************
 **
 ** NAME:           vTLM_FILL_IPC_MSG
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  void
 **
 ** DESCRIPTION:    
 **
 ***************************************************************************/

K_MSG * vTLM_SET_IPC_MSG(IpcQueueType_e ipcQueueType, uint32 checkMask)
{

	IpcNewMsgFromOtherCore_t *ipcNewMsgFromOtherCore_p;
	K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(IpcNewMsgFromOtherCore_t));
	ipcNewMsgFromOtherCore_p = (IpcNewMsgFromOtherCore_t*) pK_MSG_DATA(pMsg);
	ipcNewMsgFromOtherCore_p->queueType = ipcQueueType;
	ipcNewMsgFromOtherCore_p->checkMask = checkMask;
	return pMsg;

}

#if defined (ENET_INC_LMAC0)

/****************************************************************************
 **
 ** NAME:           vTLM_IPC_TO_LM_FROM_UM_ISR
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  void
 **
 ** DESCRIPTION:    ISR routine for LM event TLM_EVT_M_REQ_RES.
 **					Management message in queue.
 **
 ***************************************************************************/
void vTLM_IPC_TO_LM_FROM_UM_ISR(void)
{
	MT_LM_STAT_INC(MT_LM_STAT_EVT_UM_M_REQ_RES);
	AAA_DEBUG_LMI_MACRO(AAA_DebugLmi_vTLM_M_REQ_RES_ISR, u32SignalMask, IGEN_CHECK_MASK(vGetSignalMask(),IGEN_EVT_IPC_TO_LM0_FROM_UM));
    if (IGEN_CHECK_MASK(vGetSignalMask(),IGEN_EVT_IPC_TO_LM0_FROM_UM))
    {
		K_MSG *pMsg = vTLM_SET_IPC_MSG(IPC_QUEUE_TYPE_UM_TO_LM0, IGEN_EVT_IPC_TO_LM0_FROM_UM);
		vSetSignalMask(IGEN_EVT_IPC_TO_LM0_FROM_UM);
		OSAL_SEND_MESSAGE(IPC_NEW_MSG_FROM_OTHER_CORE, TASK_IPC_2, pMsg, VAP_ID_DO_NOT_CARE);
    }
}
#endif



/**********************************************************************************

ipc_init

Description:
----------
	
**********************************************************************************/

#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif


void ipc_init()
{
#if defined(ENET_INC_ARCH_WAVE600)
	ipcConfigMode = ConfigurationManager_GetBandConfigurationMode();
#endif
	
#if defined (ENET_INC_UMAC)
	vInit_IFmsg(NO_SH_RAM_MSGS, sizeof(SH_RAM_PARAMS), &shRamMsgQ,(K_MSG *)asShRamMsgAlloc);
	/* Initialise Management queues */
    vInitMsgQ(&sUMtoLM0fifo);
    vInitMsgQ(&sLM0toUMfifo);
#if defined (ENET_INC_ARCH_WAVE600)
	vInitMsgQ(&sUMtoLM1fifo);	
	vInitMsgQ(&sLM0toLM1fifo);
	vInitMsgQ(&sLM1toUMfifo);
    vInitMsgQ(&sLM1toLM0fifo);
#endif //#if defined (ENET_INC_ARCH_WAVE600)
#endif	
	
}


#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif


