/* CMSynergyVer %full_filespec: kcctimer.h;2.1.3.2.1:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 **                 (c) TTPCom., 1999-2000
 **
 ****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      KCC Kernel Common Code
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/kernel/kcctimer.h $
 **
 ** DESCRIPTION:    Kernel timer include file
 **
 ** AUTHOR:         Julian Hall  
 **
 ** THIS VERSION:   $Revision: #1 $
 **   CHANGED ON:   $Date: 2003/10/27 $
 **           BY:   $Author: njk $
 **
 ****************************************************************************/

#ifndef  KCCTIMER_API_INCLUDED
#define  KCCTIMER_API_INCLUDED

#include "kernel.h"
#include "InterruptManager_Api.h"

#if defined (ENET_INC_UMAC)
/****************************************************************************
 * Kernel Timer Management
 ****************************************************************************/
//ISR_VOID   vKNLintrTimer (K_TIME wTicks);
ISR_VOID   vKNLintrTimer (void);

/* The kernel component includes a task for handling timer interrupt
 * messages. This must be referenced from the application's task table. */

/* ... and also a task for handling timer expiry at each priority level.
 * This task must also be referenced from the application's task table. */


/**********************************/
/* EVENTS for TASK_KNL_TIMER_TICK */
/**********************************/
#define KCC_TIMER_TICK            (K_MSG_TYPE) 0


/************************************************************************/
/* EVENTS for TASK_KNL_TIMER_HIGH,TASK_KNL_TIMER_MED,TASK_KNL_TIMER_LOW */
/************************************************************************/
#define KCC_TIMER_EXPIRE          (K_MSG_TYPE) 1

#endif

#if ((defined (ENET_INC_ARCH_WAVE600)) && (defined (ENET_INC_LMAC)))
/****************************************************************************
 * Kernel Timer Management
 ****************************************************************************/
ISR_VOID   vKNLintrTimer (void);
#endif

#endif //KCCTIMER_API_INCLUDED

