/************************************************************************************
*    
*    File:		  ***************
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

#ifndef KERNEL_INCLUDED
#define KERNEL_INCLUDED

//#include "enet_sw.h"
//#include "mt_osint.h"
#include "OSAL_Kmsg.h"


#if (defined (ENET_INC_ARCH_WAVE600) || defined (ENET_INC_UMAC))

/************************************************************************
** Definition of K_TIME depends on the memory constraints of the system.
** In all cases, K_TIME MUST be defined as signed. The timeout was
** defined as 0x4000 when we had a signed short, which is less than the
** actual range of
*************************************************************************/
#define KNL_MAX_TIMEOUT_POSSIBLE 0x40000000

typedef int32 K_TIME;    /* must be signed */

#endif

/****************************************************************************
 * Kernel Task Priority Definitions
 ****************************************************************************/

#define KNL_NO_OF_PRIORITIES    3
#define KNL_HIGHEST_PRIORITY    0
#define KNL_MID_PRIORITY        1
#define KNL_LOWEST_PRIORITY     (KNL_NO_OF_PRIORITIES - 1)



/****************************************************************************
 * Kernel Message Buffering
 ****************************************************************************/

/****************************************************************************
 * Kernel State Machine Action
 ****************************************************************************/



/****************************************************************************
 * Kernel State Machine Handling
 ****************************************************************************/




/****************************************************************************
 * Kernel Message Handling
 ****************************************************************************/
/* The following function prototype should really by in kccsched.h but */
/* it's needed here to avoid warnings when using the kernel timer macros */
K_TASKID     bKNLgetRunningTaskId        (void);

/*************************************************************************
 * Public Functional Interface
 *************************************************************************/
#endif
/* End of file kernel.h */
