/* CMSynergyVer %full_filespec: kccmsg.c;2.2.2.1.6:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 **                 (c) TTPCom., 1996-2000
 **
 ****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      KCC - Kernel Common Code
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/kernel/kccmsg.c $
 **
 ** DESCRIPTION:    Kernel Message Handling
 **
 ** AUTHOR:         Julian Hall
 **
 ** THIS VERSION:   $Revision: #1 $
 **   CHANGED ON:   $Date: 2003/10/27 $
 **           BY:   $Author: njk $
 **
 ****************************************************************************/

   /*************************************************************************/
   /***                        Include Files                              ***/
   /*************************************************************************/
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "Utils_Api.h"
#include "OSAL_Api.h"
#include "kernel.h"
#include "kccmsg.h"
 #include "Debug_Trace.h"
#include "kccsched.h"
#include "Pac_Api.h"
#include "enet_pas.h"
#include "HostInterface_API.h"
/******************************************/
/*        DO NOT REMOVE THIS LINE!        */
/******************************************/
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_KERNEL
#define LOG_LOCAL_FID 0


/*************************************************************************/
/***                        Local defines                              ***/
/*************************************************************************/

/* The following are masks that are applied to the bListNoAndRefCount */
/* element of the K_MSG structure.                                    */
/* Bits 7-4 are used for message pool information                     */
/* Bit  3 is reserved for trapping reference count over/underflow     */
/* Bits 2-0 are used for the reference count (0-7: 0 means 'free')    */

#define bLNARC_POOL_MASK             0xf0
#define bLNARC_POOL_OVERFLOW_BIT     0x08
#define bLNARC_REF_COUNT_MASK        0x07

/* Define a default limit on ref count. A smaller value can be specified
 * in the kernel configuration file to allow a build to specify that it is
 * only intended to use a smaller reference count. */



#define bLNARC_REF_COUNT(x)          (x)

#define bLNARC_PREALLOC_POOL         0xf0
#define bLNARC_FAST_POOL             0xe0
#define bLNARC_BUDDY_POOL(x)         (byte)((x) << 4) /* x = 0-5 */

#define bLNARC_GET_BUDDY_POOL(x)     (((x) & bLNARC_POOL_MASK) >> 4)
#define bLNARC_GET_POOL_ID(x)        ((x) & bLNARC_POOL_MASK)
#define bLNARC_GET_REF_COUNT(x)      ((x) & bLNARC_REF_COUNT_MASK)

   /*************************************************************************/
   /***               Pre-allocated message pool                          ***/
   /*************************************************************************/
#define K_NO_OF_PREALLOC_MSG (3)
#define K_PREALLOC_MSG_SPACE (64)
#define KNL_PREALLOC_POOL_SIZE (K_PREALLOC_MSG_SPACE + (K_NO_OF_PREALLOC_MSG * sizeof(K_MSG_HEADER)))





   /*************************************************************************/
   /***               Fast message pool                                   ***/
   /*************************************************************************/

typedef struct K_FAST_MSG
{
    K_MSG_HEADER    sMsgHeader;
    byte            abData[K_FAST_MSG_SIZE];
} K_FAST_MSG;


   /*************************************************************************/
   /***               Default message pool                                ***/
   /***                                                                   ***/
   /***   The default pool is divided into allocation units of 8 bytes    ***/
   /***   The padding in the K_FREE_BLOCK ensures that the allocation     ***/
   /***   unit size is the same on all CPUs.                              ***/
   /***                                                                   ***/
   /*************************************************************************/

/* Note that the type K_BLOCK_INDEX has been changed throughout to BLOCK_INDEX,
 * which is set to uint16, but could be a uint8 if there are few enough blocks. */

typedef uint16 BLOCK_INDEX;

typedef struct K_FREE_BLOCK
{
    BLOCK_INDEX   bNext;
    BLOCK_INDEX   bBlockNo;
} K_FREE_BLOCK;


//typedef union K_ALLOC_UNIT
//{
//    K_FREE_BLOCK    sFreeBlock;
//    K_MSG_HEADER    sMsgHeader;
//    uint8              minAllocSize[K_SIZE_OF_ALLOC_UNIT];
//} K_ALLOC_UNIT;

#ifdef ENET_INC_LMAC
#define K_SIZE_IN_ALLOC_UNITS(n) (1 << n)
#define K_DEFAULT_POOL_SIZE (4)
#define K_BLOCK_LIST_END    (BLOCK_INDEX)K_DEFAULT_POOL_SIZE
#endif
#if defined (ENET_INC_UMAC)
#define K_SIZE_IN_ALLOC_UNITS(n) (1 << n)
#define K_DEFAULT_POOL_SIZE (K_SIZE_IN_ALLOC_UNITS(K_LARGEST_BLOCK_SIZE) * K_NO_OF_LARGEST_BLOCKS)
#define K_BLOCK_LIST_END    (BLOCK_INDEX)K_DEFAULT_POOL_SIZE
#endif

/*************************************************************************/
/***                Static Functions                                   ***/
/*************************************************************************/




/*************************************************************************/
/***                        Static Functions                           ***/
/*************************************************************************/



/****************************************************************************
 **
 ** NAME:           vKNLanalysePool
 **
 ** PARAMETERS:
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    Creates a structure that contains summary of the current default
 **                 pool contents. For post mortem use only.
 **                 On ARM debugger use
 **                 call vKNLanalysePool() in the command window. It may be necessary
 **                 to run it twice if the first run is aborted by an interrupt.
 **                 On Windows right click the function first line & Set Next Statement
 **
 ****************************************************************************/

#if defined _DEBUG

#define ANALYSIS_SIZE 100

struct
{
    uint16     u16StartBlock;
    uint16     u16Length;
    bool    boFree;
    K_MSG*  psKmsg;
} sKNLpoolAnalysis[ANALYSIS_SIZE];


void vKNLanalysePool(void)
{
    unsigned uList;
    uint16 u16Block;   /* Alloc block index into the pool */
    uint16 u16Length;  /* length of current msg or free block */
    uint8  u8AnalysisCounter;
    uint8  u8Lnrc;     /* K_MSG's link no & ref count, if a message */
    uint16 u16NextFreeList[K_LARGEST_BLOCK_SIZE+1];
    uint16 uCurrentList;
    bool boFree;

    /* Initialise list of next free blocks on each list */

    for (uList = 0; uList <= K_LARGEST_BLOCK_SIZE; uList++)
    {
        u16NextFreeList[uList] = abKNLdefaultMsgFreeList[uList];
    }

    for (u16Block = 0, u8AnalysisCounter = 0;
        (u16Block < K_DEFAULT_POOL_SIZE) && (u8AnalysisCounter < ANALYSIS_SIZE);
        u8AnalysisCounter++)
    {
        sKNLpoolAnalysis[u8AnalysisCounter].u16StartBlock = u16Block;

        /* Is this block a message, or space (free block)? If listed in the NextFreeList it is a space */

        boFree = FALSE;
        for (uList = 0; uList <= K_LARGEST_BLOCK_SIZE; uList++)
        {
            if (u16NextFreeList[uList] == u16Block)
            {
                uCurrentList = uList;
                boFree = TRUE;
                break;
            }
        }
        sKNLpoolAnalysis[u8AnalysisCounter].boFree = boFree; /* Just records it as a check */

        /* Test for message uses message RefCount non zero. */
        u8Lnrc = ((K_MSG *) (&asKNLdefaultMsgPool[u16Block]))->header.bListNoAndRefCount;
        if ((u8Lnrc & 0x0F) > 0)
        {
            /* In use as a message. boFree should be FALSE. Length depends on the list number in MSn.
               it is 2^listNo allocation blocks long. */
            u16Length = 1<<(u8Lnrc>>4);
            sKNLpoolAnalysis[u8AnalysisCounter].psKmsg = (K_MSG *) &asKNLdefaultMsgPool[u16Block];
        }
        else
        {
            /* It is a free block. Update the running Free List with the link in this block */
            if (boFree == TRUE)
            {
                u16NextFreeList[uCurrentList] = asKNLdefaultMsgPool[u16Block].sFreeBlock.bNext;

                /* Use the list No to find the length of this free block, & hence next block */
                u16Length = 1<<uCurrentList;

                sKNLpoolAnalysis[u8AnalysisCounter].psKmsg = 0;
            }
            else
            {
                /* Shouldn't happen - non-free block is assumed to have ref count !=0 */
                break;
            }
        }

        sKNLpoolAnalysis[u8AnalysisCounter].u16Length = u16Length;
        u16Block += u16Length;
    }
}


#endif



