 /* CMSynergyVer %full_filespec: kccsched.c;8.3.1.1.4:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 **                 (c) TTPCom., 1999-2000
 **
 ****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      KCC - Kernel Common Code
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/kernel/kccsched.c $
 **
 ** DESCRIPTION:    Kernel Scheduler
 **
 ** AUTHOR:         Julian Hall
 **
 ** THIS VERSION:   $Revision: #5 $
 **   CHANGED ON:   $Date: 2004/03/24 $
 **           BY:   $Author: jh3 $
 **
 ****************************************************************************/

   /*************************************************************************/
   /***                        Include Files                              ***/
   /*************************************************************************/
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "OSAL_Api.h"
#include "kernel.h"
#include "kccsched.h"
#include "kccmsg.h"
 #include "Debug_Trace.h"
#include "kcctimer.h"
#include "stringLibApi.h"
#include "Pac_Api.h"
#include "System_Timers.h"
#include "OSAL_Tasks.h"
#include "CpuLoad_Api.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_KERNEL
#define LOG_LOCAL_FID 1



   /*************************************************************************/
   /***               Local typedefs                                      ***/
   /*************************************************************************/
//#if defined(CALCULATE_CPU_IDLE_TIME)
//
//#define SAVE_ENTER_IDLE_TIME() 	OSAL_DISABLE_INTERRUPTS(&interrupt_save);\
//	ASSERT(CalcCPUIdle_isInSleep == 0);\
//	CalcCPUIdle_enterSleepTime = sTIM.u32TSFtimerLow;\
//	CalcCPUIdle_isInSleep = 1;\
//	OSAL_ENABLE_INTERRUPTS(interrupt_save);
//
//#else
//
//#define SAVE_ENTER_IDLE_TIME() 	
//
//#endif


typedef struct RUNNING_TASK
{
    K_MSG     *psMsg;
    K_TASKREF       sTask;
} RUNNING_TASK;

typedef struct KNL_HALT
{
    bool        boEnabled;
    K_MSG_TYPE  tMsgType;
    K_TASKID    tTaskId;
    uint8 stub;

} KNL_HALT;

   /*************************************************************************/
   /***               Internally Visible Static Data                      ***/
   /*************************************************************************/

/* This variable contains one bit per task priority indicating if there */
/* are any messages pending at that priority. Bit0=highest priority     */

/* Indicates what task priority is currently running:                   */
/*  e.g. in a system with three priority levels                         */
/*   0 - high priority task running                                     */
/*   1 - mid  priority task running                                     */
/*   2 - low  priority task running                                     */
/*   3 - no tasks running                                               */
static byte             obKNLrunningTaskPriority;

/* This flag is set to indicate the interrupt scheduler is pending.     */
/* It is used to avoid "stacking" multiple calls to the scheduler in    */
/* scenarios where an ISR is interrupted before scheduling has started  */

/* Information about the current task scheduled at each priority        */
static RUNNING_TASK  asKNLrunningTasks[KNL_NO_OF_PRIORITIES];

/* Each task priority has a single message queue shared between all     */
/* tasks at the same level. The queue structure has head and tail       */
/* pointers only as each message in it has a next pointer               */

   /*************************************************************************/
   /***               Constant Lookup Tables                              ***/
   /*************************************************************************/

/* scheduling rules are set by the following lookup tables. A task          */
/* will run if its priority is higher than the current running task         */


#define KCC_SCHED_10MS_IN_TICKS		(2400000) /*assuming CPU is running @ 240Mhz*/

#define KNL_HIGH_PRIORITY_MAP      0x0001
#define KNL_MID_PRIORITY_MAP       0x0002
#define KNL_LOW_PRIORITY_MAP       0x0004


   /*************************************************************************/
   /***               Kernel Power Saving                                 ***/
   /*************************************************************************/

#if defined(PLATFORM_GORGON)
#define vKNL_CPU_HALT()         { ((AT91_PS_REGISTERS *)(AT91_PS_BASE))->u32Control = AT91_PS_CONTROL_CPU_DISABLE; }
#else
#define vKNL_CPU_HALT()
#endif


void KNL_MIPS_SLEEP(void);

/*************************************************************************/
/***               Public Functions                                    ***/
/*************************************************************************/



/****************************************************************************
 **
 ** NAME:           bKNLgetRunningTaskId
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  task identity
 **
 ** DESCRIPTION:    gets the current task's identity
 **
 ****************************************************************************/

K_TASKID bKNLgetRunningTaskId(void)
{
	if (InterruptManager_IsInInterruptContext() == TRUE)
	{
		return TASK_KNL_INTERRUPT_CONTEXT;
	}

    return asKNLrunningTasks[obKNLrunningTaskPriority].sTask.taskID;
}

/****************************************************************************
 **
 ** NAME:           bKNLgetRunningTaskInstance
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  task instance
 **
 ** DESCRIPTION:    gets the current task's instance
 **
 ****************************************************************************/


/****************************************************************************
 **
 ** NAME:           bKNLtaskPriority
 **
 ** PARAMETERS:     K_TASKID
 **
 ** RETURN VALUES:  priority
 **
 ** DESCRIPTION:    Returns the priority of the specified task
 **
 ****************************************************************************/

byte bKNLtaskPriority(K_TASKID bTaskId)
{
    if (bTaskId <= TASK_HIGH_PRIORITY_LIMIT)
    {
        return KNL_HIGHEST_PRIORITY;
    }
    else if (bTaskId <= TASK_MID_PRIORITY_LIMIT)
    {
        return KNL_MID_PRIORITY;
    }

    return KNL_LOWEST_PRIORITY;
}


