/* CMSynergyVer %full_filespec: kcctimer.c;5.1.4.1.6.2.3:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 **                 (c) TTPCom., 1999-2000
 **
 ****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      KCC - Kernel Common Code
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/kernel/kcctimer.c $
 **
 ** DESCRIPTION:    Kernel Timers
 **
 ** AUTHOR:         Julian Hall
 **
 ** THIS VERSION:   $Revision: #2 $
 **   CHANGED ON:   $Date: 2004/03/15 $
 **           BY:   $Author: prh $
 **
 ****************************************************************************/

/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/
#include "OSAL_Api.h"
#include "kernel.h"
#include "kcctimer.h"
#include "kccmsg.h"
#include "kccsched.h"
 #include "Debug_Trace.h"
#include "HostInterface_API.h"
#include "ErrorHandler_Api.h"
#include "lm.h"
#include "Pac_Api.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_MAC_HT_extensions_regs.h"
#include "MT_Emerald_Env_regs.h"
#else
#include "EmeraldEnvRegs.h"
#endif
#include "lm_statistics.h"
#include "CpuLoad_Api.h"

   /*************************************************************************/
   /***                        Local Defines                              ***/
   /*************************************************************************/
/******************************************/
/*        DO NOT REMOVE THIS LINE!        */
/******************************************/
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_KERNEL
#define LOG_LOCAL_FID 2



#if ((defined (ENET_INC_ARCH_WAVE600)) || (!defined (ENET_INC_LMAC)))
//#define BSKNL_DEBUG_TIMERS

typedef struct KNL_TIMER
{
    struct KNL_TIMER *psNext;

    K_TIME       iTimeToExpire;        /*note: this must be signed */
    K_TASKID     bTaskId;
    K_MSG_TYPE   bTimerId;
    uint8 stub;
} KNL_TIMER;

typedef struct TIMER_TASK
{
    KNL_TIMER *psRunningTimerList;
    K_TIME          wTicksSinceLastScheduled;
    bool            boMsgSent;
} TIMER_TASK;


   /*************************************************************************/
   /***               Static Functions                                    ***/
   /*************************************************************************/
#ifdef BSKNL_DEBUG_TIMERS
static void vDumpTimerInformation(KNL_TIMER * psTimer);
static void vDumpFreeTimers(void);
static void vDumpRunningTimers(void);
static void vDumpTimerPool(void);
static void vDumpMaskedTimers(void);
static void vDumpTimers(void);
#endif

   /*************************************************************************/
   /***               Static Data                                         ***/
   /*************************************************************************/
K_MSG     * psTimerTickMsg;

/* Publicly readable variable that contains the number of ticks since the
 * system was started. */

uint32 u32KNLsystemTicks;


/****************************************************************************
 **
 ** NAME:           vKNLintrTimer
 **
 ** PARAMETERS:     frame ticks passed
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    Sends number of tick periods elapsed to the Timer
 **                 Tick task
 **
 ****************************************************************************/

ISR_VOID vKNLintrTimer(void)
{
	ACCUMULATE_CPU_IDLE_TIME();

#if defined (ENET_INC_UMAC)
    /* Enable a new timer interrupt */
    InterruptManager_ClearEdgedTriggeredInterrupt(EDGED_TRIGGERED_INT_PAC_TICK_TIMER);
#endif

#if defined (CPU_MIPS)
	TxApp_TimerIsr(); 
#endif
}
/****************************************************************************
 **
 ** NAME:           vKNLreadTimer
 **
 ** PARAMETERS:     TimerId, Instance
 **
 ** RETURN VALUES:  K_TIME time to expire
 **
 ** DESCRIPTION:    Returns the time left to expire for the specified timer.
 **                 If the timer has expired then it always returns 0 (even
 **                 if the timeToExpire is <0). If the timer is not active
 **                 then it returns -1.
 **
 ****************************************************************************/

//K_TIME vKNLreadTimer(K_MSG_TYPE bTimerId, K_TASKID bCurrentTaskId)
//{
//
//    KNL_TIMER               **ppsTimer;
//    K_TIME                  iTimeToExpire;
//    K_TIME                  wTicksSinceLastScheduled;
//
//    iTimeToExpire = -1; /* assume we can't find it */
//    ppsTimer =
//        &asTimerTask[bKNLtaskPriority(bCurrentTaskId)].psRunningTimerList;
//    wTicksSinceLastScheduled =
//        asTimerTask[bKNLtaskPriority(bCurrentTaskId)].wTicksSinceLastScheduled;
//
//    while(*ppsTimer)
//    {
//        if( ((*ppsTimer)->bTaskId   == bCurrentTaskId) &&
//            ((*ppsTimer)->bTimerId  == bTimerId))
//        {
//            /* Timer found */
//            if( (*ppsTimer)->iTimeToExpire <=0)
//            {
//                iTimeToExpire = 0;
//            }
//            else
//            {
//                /* The iTimeToExpire of the timer is only updated occasionally,
//                ** and it is possible it will never be updated until it has
//                ** expired. Therefore we need to subtract the time since last
//                ** scheduled to get the real time left.
//                */
//                iTimeToExpire = (*ppsTimer)->iTimeToExpire - wTicksSinceLastScheduled;
//            }
//            break;
//        }
//        ppsTimer = &(*ppsTimer)->psNext;
//    }
//
//    return iTimeToExpire;
//}



   /*************************************************************************/
   /***               Static Functions                                    ***/
   /*************************************************************************/


/****************************************************************************
 **
 ** NAME:           vDumpRunningTimers
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    dumps the running timer list in the event of a fatal
 **                 error.
 **
 ****************************************************************************/

#ifdef BSKNL_DEBUG_TIMERS

static void vDumpTimerInformation(KNL_TIMER * psTimer)
{
	//TODO - empty function
}

static void vDumpRunningTimers(void)
{
	/* OMER TBD - flush timer queues */
}

static void vDumpFreeTimers(void)
{
    KNL_TIMER * psTimerList;

    /* Dump the Free Timers list */
    psTimerList = psFreeTimerList;
    if(psTimerList==NULL)
    {
    }
    else
    {
        while(psTimerList)
        {
            vDumpTimerInformation(psTimerList);
            psTimerList = psTimerList->psNext;
        }
    }
}

static void vDumpTimerPool(void)
{
    static KNL_TIMER         asTimerPool[TIMERS_IN_POOL];
    int32 iPoolIndex;


    for(iPoolIndex=0; iPoolIndex<TIMERS_IN_POOL; iPoolIndex++)
    {
        vDumpTimerInformation(&(asTimerPool[iPoolIndex]));
    }
}

static void vDumpMaskedTimers(void)
{
#if defined(BSKNL_TIMER_MASKING)

    int32 iMaskIndex;

    if(iNumMaskedTimers==0)
    {
    }
    else
    {
        for(iMaskIndex=0; iMaskIndex<BSKNL_MAX_MASKED_TIMERS; iMaskIndex++)
        {
        }
    }
#endif
}

static void vDumpTimers(void)
{
    /* Dump lots of debugging information about the timers */
    vDumpTimerPool();
    vDumpFreeTimers();
    vDumpRunningTimers();
    vDumpMaskedTimers();
}

#endif





   /*************************************************************************/
   /***                Power Control Functions                            ***/
   /*************************************************************************/


#endif //!defined (ENET_INC_LMAC)

/* End of file kcctimer.c */
