/***********************************************************************************
 File:			Liberator.c
 Module:		Liberator
 Purpose: 		
 Description:	This file is the implementation of the Liberator module 
				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "loggerAPI.h"
#include "RegAccess_Api.h"
#include "stringLibApi.h"
#include "MacGeneralRegs.h"
#include "HwQManager_API.h"
#include "Liberator_Api.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_HW_DRIVERS
#define LOG_LOCAL_FID 21


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/


/**********************************************************************************

Liberator_Initialize

Description:
------------
initialize internal structures and registers of the Liberator module 

Input:
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
void Liberator_Initialize(void)
{
	RegMacGeneralLibDplIdxInput_u txLiberatorDplIndexInputRegister;
	RegMacGeneralRxLibDplIdxInput_u rxLiberatorDplIndexInputRegister;
	RegMacGeneralRxLibDplIdxSource03_u rxLibDplIndexSrc03;
	RegMacGeneralRxLibDplIdxSource47_u rxLibDplIndexSrc47;
	RegMacGeneralLibDplIdxSource03_u txLibDplIdxSource03;
	RegMacGeneralLibDplIdxSource47_u txLibDplIdxSource47;
	RegMacGeneralLibHalt_u txLibHaltReg;
	RegMacGeneralRxLibHalt_u rxLibHaltReg;

	txLiberatorDplIndexInputRegister.val = 0;
	rxLiberatorDplIndexInputRegister.val = 0;
	rxLibDplIndexSrc03.val = 0;
	rxLibDplIndexSrc47.val = 0;	
	txLibDplIdxSource03.val = 0; 
	txLibDplIdxSource47.val = 0;
	txLibHaltReg.val = 0;
	rxLibHaltReg.val = 0;
	
	txLiberatorDplIndexInputRegister.bitFields.liberatorDplIdxIn = HW_Q_MANAGER_DONE_LIST_LIBERATOR;
	RegAccess_Write(REG_MAC_GENERAL_LIB_DPL_IDX_INPUT, txLiberatorDplIndexInputRegister.val);
	rxLiberatorDplIndexInputRegister.bitFields.rxLiberatorDplIdxIn = HW_Q_MANAGER_RX_LIBERATOR_INPUT_LIST;
	rxLiberatorDplIndexInputRegister.bitFields.rxLiberatorDplIdxToAdd = HW_Q_MANAGER_RX_FREE_HOST_RDS_LIST;
	RegAccess_Write(REG_MAC_GENERAL_RX_LIB_DPL_IDX_INPUT, rxLiberatorDplIndexInputRegister.val);

	rxLibDplIndexSrc03.bitFields.rxLiberatorDplIdxSource0 = HW_Q_MANAGER_RX_FREE_HOST_RDS_LIST;
	rxLibDplIndexSrc03.bitFields.rxLiberatorDplIdxSource1 = HW_Q_MANAGER_RX_FREE_FW_RDS_LIST;
    // Liberator should release RDs of source 3 (RX_DESCRIPTOR_SOURCE_FORWARD) to temp list
	rxLibDplIndexSrc03.bitFields.rxLiberatorDplIdxSource3 = HW_Q_MANAGER_RX_READY_LIST_RELEASE_FORWARD_RDS; 
	RegAccess_Write(REG_MAC_GENERAL_RX_LIB_DPL_IDX_SOURCE0_3, rxLibDplIndexSrc03.val);

	rxLibDplIndexSrc47.bitFields.rxLiberatorDplIdxSource4 = HW_Q_MANAGER_RX_FREE_MANAGEMENT_RDS_LIST;
	RegAccess_Write(REG_MAC_GENERAL_RX_LIB_DPL_IDX_SOURCE4_7, rxLibDplIndexSrc47.val);

	// configure the TX done PD source to be handled by the hostIf Acc 
#ifdef TX_DATA_CB_UM_PATH
	txLibDplIdxSource03.bitFields.liberatorDplIdxSource0 = HW_Q_MANAGER_DONE_LIST_HOST_DATA; 
#else
	txLibDplIdxSource03.bitFields.liberatorDplIdxSource0 = HW_Q_MANAGER_LOW_PR_READY_LIST_TEMP_HOST_Q; //route source0 packets to the hostif accelerator 
#endif 
	txLibDplIdxSource03.bitFields.liberatorDplIdxSource1 = HW_Q_MANAGER_DONE_LIST_ERROR; // There is no source 1.
	txLibDplIdxSource03.bitFields.liberatorDplIdxSource2 = HW_Q_MANAGER_DONE_LIST_MANAGEMENT_FROM_FW; 	
	txLibDplIdxSource03.bitFields.liberatorDplIdxSource3 = HW_Q_MANAGER_DONE_LIST_MANAGEMENT_FROM_HOST; 
	RegAccess_Write(REG_MAC_GENERAL_LIB_DPL_IDX_SOURCE0_3, txLibDplIdxSource03.val);

	txLibDplIdxSource47.bitFields.liberatorDplIdxSource4 = HW_Q_MANAGER_DONE_LIST_RELIABLE_MULTICAST; 	
	txLibDplIdxSource47.bitFields.liberatorDplIdxSource5 = HW_Q_MANAGER_DONE_LIST_PS_SETTINGS_HW; 	
#if defined (AGER_STATUS_WORKAROUND)
	txLibDplIdxSource47.bitFields.liberatorDplIdxSource6 = HW_Q_MANAGER_DONE_LIST_AGER_LIBERATOR;
#else
	txLibDplIdxSource47.bitFields.liberatorDplIdxSource6 = HW_Q_MANAGER_DONE_LIST_ERROR;
#endif
	txLibDplIdxSource47.bitFields.liberatorDplIdxSource7 = HW_Q_MANAGER_DONE_LIST_ERROR;
	RegAccess_Write(REG_MAC_GENERAL_LIB_DPL_IDX_SOURCE4_7, txLibDplIdxSource47.val);

	txLibHaltReg.bitFields.liberatorHaltWork = FALSE;
	RegAccess_Write(REG_MAC_GENERAL_LIB_HALT, txLibHaltReg.val);

	rxLibHaltReg.bitFields.rxLiberatorHaltWork = FALSE;
	RegAccess_Write(REG_MAC_GENERAL_RX_LIB_HALT, rxLibHaltReg.val);
}


