/***********************************************************************************
 File:		LinkAdaptation_Tests_api.h
 Module:		LinkAdaptation
 Purpose: 	Test module api
 Description:	This file contains all definitions and the structures of the LinkAdaptation tests api 
 				
************************************************************************************/
#ifndef LINK_ADAPTATION_TEST_API_H_
#define LINK_ADAPTATION_TEST_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "linkAdaptation_api.h"
#include "mhi_ieee_address.h"
#ifdef LINK_ADAPTATION_TEST_ENV

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef enum TestType
{
	NO_TEST,
	MODIFY_PER,
	TEST_UP_NSS,
	TEST_UP_MCS,
	TEST_LOWER_RATE,
	TEST_PER_VALIDATION,
	TEST_PROBING_TIMER,
	LA_TEST_OPTIONS
}TestType_e;
 
typedef struct LaTestEnvMsgParams
{
//	LinkAdaptationMsgType_e msgType;
	TestType_e testType;
	IEEE_ADDR	testedStaMacAddress;
	uint8 rateIndex;
	uint8 requiredPer;
}LaTestEnvMsgParams_t;

extern LaTestEnvMsgParams_t testParams;
#endif
#endif /* LINK_ADAPTATION_TEST_API_H_ */

