/***********************************************************************************
 File:		linkAdaptation_api.h
 Module:		link adaptation
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef LINK_ADAPTATION_API_H_
#define LINK_ADAPTATION_API_H_

#define REPORT_NO_PROBING_TYPE 0
#define REPORT_FAST_PROBING_TYPE 1
#define REPORT_SLOW_PROBING_YPE 2

#define MAX_TX_SEQUENCER_FIFO_SIZE (64)

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "OSAL_Kmsg.h"
#include "SharedDbTypes.h"
#include "lmi.h"
#include "LinkAdaptation_Tests_api.h"
#include "BaAnalyzer.h"
#include "PacketDescriptor.h"
#include "GroupManager_API.h"
#ifdef ENET_INC_ARCH_WAVE600
#include "CommonPlan_Descriptors.h"
#include "CommonUlReport_Descriptors.h"
#include "UserUlReport_Descriptors.h"
#endif
#ifdef ENET_INC_ARCH_WAVE600B
#include "PreAggregator.h"
#endif
#include "HwGlobalDefinitions.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
/*Configuration definition*/

//#define QAM_PLUS_ENABLE

//#ifdef QAM_PLUS_ENABLE
//#define QAM_PLUS_DEBUG
//#define QAM_PLUS_ALWAYS
//#endif

#if(defined ENET_INC_ARCH_WAVE600 && defined DEBUG_LOGGER_ENABLE)
#define LINK_ADAPTATION_LOGS
#endif
//#define LINK_ADAPTATION_TEST_ENV
//#define LINK_ADAPTATION_REGISTRATION
#define RATES_BIT_MASK_SIZE 2 //must be 2!		/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */

#ifdef ENET_INC_ARCH_WAVE600
#define LA_NUM_OF_BANDWIDTH 4 		// MAX_NUM_OF_BW - TBD , until 160 MHz will be fully supported in TPC
#define DUMMY_AID			(2046) 	// dummy AID
#else
#define LA_NUM_OF_BANDWIDTH 3 // MAX_NUM_OF_BW - TBD , until 160 MHz will be fully supported in TPC
#endif
#define MAX_POSSIBLE_NUM_OF_BW 4
#define MAX_POSSIBLE_NUM_OF_ANTENNAS 4
#define POWER_ADAPTATION_MAX_TABLE_SIZE 96

#define CDD_MAX_NUMBER_OF_PERMUTATIONS (6)
#define CDD_MIN_NUMBER_OF_ANTENNAS     (2)
#define CDD_MAX_NUMBER_OF_ANTENNAS     (4)
#define CDD_INVALID_PERMUTATION		   (0xFFFF)


#define MAX_RF_POWER 		(0x1E)

#define VHT_HE_TCR_NSS_MASK  	(0x30)
#define VHT_HE_TCR_NSS_SHIFT 	(0x4)
#define VHT_HE_TCR_MCS_MASK 	(0xF)
#define VHT_HE_TCR_DCM_MASK 	(0x80)
#define VHT_HE_TCR_DCM_SHIFT 	(0x7)

#define RATE_PARAMS_TO_TCR_VAL_VHT_HE(mcs, nss, dcm) 	(((dcm) << VHT_HE_TCR_DCM_SHIFT) + ((nss) << VHT_HE_TCR_NSS_SHIFT) + (mcs))
#define EXTRACT_NSS_FROM_VHT_HE_RATE(rate) 		(((rate) & VHT_HE_TCR_NSS_MASK) >> VHT_HE_TCR_NSS_SHIFT)
#define EXTRACT_MCS_FROM_VHT_HE_RATE(rate) 		((rate) & VHT_HE_TCR_MCS_MASK)
#define EXTRACT_DCM_FROM_VHT_HE_RATE(rate) 		(((rate) & VHT_HE_TCR_DCM_MASK) >> VHT_HE_TCR_DCM_SHIFT)


/* Time limit in microseconds for AGG size for the isolated station */
#define MAX_TRANSMISSION_TIME	5400 
#define MED_TRANSMISSION_TIME	2600 
#define MIN_TRANSMISSION_TIME	1000

#define INVALID_MU_GROUP_INDEX	0xFF
#define INVALID_MU_USP_INDEX	0xFF
#define DONT_CARE_MU_USP_INDEX	0xFE

#define LA_PSD_NUM_OF_ROWS_INDEX				 (0)
#define LA_PSD_NUM_OF_COLS_INDEX				 (1)
#define LA_PSD_TABLE_START_INDEX				 (2)

#define INVALID_GROUP_MARKS 0xFF

#define MAX_USP_IN_VHT_GROUP (4)					/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */

#define NUM_OF_EXTENTION_RSSI				(4)

//---------------------------------------------------------------------------------
//						Data Type Definition					

//---------------------------------------------------------------------------------

typedef enum LaGlobalTimersTypes
{
	FIRST_TIMER_IN_LIST,
	LINK_ADAPTATION_PROBING_TIMER = FIRST_TIMER_IN_LIST,
	LINK_ADAPTATION_AGING_TIMER,
	PROTECTION_ADAPTATION_WLAN_TIMER,
	NUMBER_OF_LINK_ADAPTATION_TIMERS
}LaGlobalTimersTypes_e;



typedef enum SlowProbingTasks
{
	SLOW_PROBING_FIRST_TASK,
	SLOW_PROBING_POWER = SLOW_PROBING_FIRST_TASK, /*This loop will not be activated most of the time, this is the reason it is first, so if loop will not be activate we will skip to next loop*/
	SLOW_PROBING_BW,
	SLOW_PROBING_CP,
	SLOW_PROBING_BF,
	SLOW_PROBING_CDD,
	SLOW_PROBING_ANT_SEL,
	SLOW_PROBING_TURBO_RATES,
	SLOW_PROBING_TASKS_NUM,
	SLOW_PROBING_LAST_TASK = SLOW_PROBING_TURBO_RATES,
	SLOW_PROBING_INVALID_TASK = MAX_UINT8
}SlowProbingTasks_e;

typedef struct RateMask
{
	uint32 raIndexMask64bit[RATES_BIT_MASK_SIZE];
}RateMask_t;

typedef enum FixedRateRequestType
{
	FIXED_RATE_INVALID,
	FIXED_RATE_FOR_STATION,
	FIXED_RATE_FOR_VAP,
} FixedRateRequestType_e;

typedef enum AntSelectionMode
{
	MODIFY_ANTENNA_MASK,
	MODIFY_CONNECTED_ANTENNA_MASK,
	MODIFY_ANTENNA_SELECTION,
	SET_SMPS,
	UNSET_SMPS
} AntSelectionMode_e;

typedef union
{
	uint32 val;
	struct
	{
		uint8 implicitBf		: 1;
		uint8 implicitPlusCdd	: 1;
		uint8 stbc1x2			: 1;
		uint8 stbc2x4			: 1;
		uint8 bfExplicit		: 1;
		uint8 explicitBfCalibrationRequired:1;
		uint8 implicitBfCalibrationRequired:1;
	} bitFields;
} BeamFormingSupportedModes_t;

typedef enum
{
	CP_MODE_SHORT_CP_SHORT_LTF,	// 0 - HT/VHT: 0.4s CP;	HE: 0.8s CP, 1x LTF
	CP_MODE_MED_CP_SHORT_LTF,	// 1 - HT/VHT: 0.8s CP;	HE: 1.6s CP, 1x LTF 
	CP_MODE_SHORT_CP_MED_LTF,	// 2 - HT/VHT: invalid;	   	HE: 0.8s CP, 2x LTF
	CP_MODE_MED_CP_MED_LTF,		// 3 - HT/VHT: invalid;		HE: 1.6s CP, 2x LTF
	CP_MODE_SHORT_CP_LONG_LTF,	// 4 - HT/VHT: invalid;		HE: 0.8s CP, 4x LTF
	CP_MODE_LONG_CP_LONG_LTF,	// 5 - HT/VHT: invalid;		HE: 3.2s CP, 4x LTF
	CP_NUM_OF_MODES,
	CP_MODE_INVALID = 0xFF
}CyclicPrefixMode_e;


typedef enum
{
	DCM_MAX_CONSTELLATION_NOT_SUPPORTED,
	DCM_MAX_CONSTELLATION_FIRST_SUPPORTED,	
	DCM_MAX_CONSTELLATION_BPSK = DCM_MAX_CONSTELLATION_FIRST_SUPPORTED,
	DCM_MAX_CONSTELLATION_QPSK,
	DCM_MAX_CONSTELLATION_16QAM,	
}DcmMaxConstellation_e;

typedef enum TxopMode
{
	TXOP_MODE_DISABLED,
	TXOP_MODE_ENABLED
}TxopMode_e;

typedef struct TxopModeMsg
{
	StaId		staId;		
	TxopMode_e	mode;
}TxopModeMsg_t;

typedef struct LaGetPhyRateParams
{
	PhyMode_e	 		phyMode; 
	uint8				nss;
	uint8				mcs;
	uint8				cp;
	Bandwidth_e			bw;
	uint16				phyRate;
} LaGetPhyRateParams_t;

typedef struct LaFixedRateParams
{
	FixedRateRequestType_e fixedRateType;
	uint8 vapId;
    uint8 rate;
	StaId stationIndex;
    PhyMode_e phyMode;
    Bandwidth_e bandwidth;
    CyclicPrefixMode_e cpMode;
	LaPacketType_e changeType;
	K_MSG_TYPE retMsg;
	K_TASKID retTask;
	bool backToAutoRate;
	bool disableTimers;
#ifdef ENET_INC_ARCH_WAVE600D2
	HeSuExtRuSize_e heExtRuSizeMng;
	HeSuExtRuSize_e heExtRuSizeData;
#endif //ENET_INC_ARCH_WAVE600D2
} LaFixedRateParams_t;

typedef struct LaFixedRateStationParams
{
    uint8 rate;
    PhyMode_e phyMode;
    Bandwidth_e bandwidth;
    CyclicPrefixMode_e cpMode;
	LaPacketType_e changeType;
	bool FixedRateRequested;
#ifdef ENET_INC_ARCH_WAVE600D2
	HeSuExtRuSize_e heExtRuSizeMng;
	HeSuExtRuSize_e heExtRuSizeData;
#endif //ENET_INC_ARCH_WAVE600D2
} LaFixedRateStationParams_t;

typedef struct LaGroupFixedRateParams
{
	bool 	fixedRateGroupsFlag;
} LaGroupFixedRateParams_t;

typedef struct _LaFixedPowerParams_t
{
	uint8 vapId;
	StaId stationId;
	uint8 powerVal;
	LaPacketType_e changeType;

	K_TASKID retTask;
	K_MSG_TYPE retMsg;
} LaFixedPowerParams_t;

typedef struct _LaFixedScpParams_t
{
	bool isAuto;
	StaId stationId;
	uint8 getSetOperation;
	CyclicPrefixMode_e cpMode;
	K_MSG* psMsg;
} LaFixedScpParams_t;

typedef struct _LaFixedCddParams_t
{
	StaId stationId;
	uint16 cddVal;
	LaPacketType_e changeType;

	K_TASKID retTask;
	K_MSG_TYPE retMsg;
} LaFixedCddParams_t;
typedef struct LaFixedCollisionDetectionParams
{
	uint8 collisionDetectionTh;
} LaFixedCollisionDetectionParams_t;

typedef struct _LaTxopDurationParams_t
{
	uint16	txopTimeThreshold;
	bool	isMu;
	uint8	reserved;
} LaTxopDurationParams_t;

typedef struct _CddGroup_t
{
	uint16 permutations[CDD_MAX_NUMBER_OF_PERMUTATIONS + 1];
} CddGroup_t;

typedef struct _CddPermutationsDb_t
{
	CddGroup_t cddMatrix[CDD_MAX_NUMBER_OF_ANTENNAS - 1];
} CddPermutationsDb_t;

typedef struct _LaProtectionParams_t
{
	uint8 configurationIndex;
	uint8 value; 
} LaProtectionParams_t;

typedef struct _LinkAdaptationFixedAntennaSelection_t
{
	uint8 vapId;
	StaId stationId;
	AntSelectionMode_e mode;
	uint8 mask;

	K_TASKID retTask;
	K_MSG_TYPE retMsg;
} LinkAdaptationFixedAntennaSelection_t;

typedef struct _ProtectionFixed
{
	uint8 vapId;
	uint8 event;
} ProtectionFixed_t;

typedef struct _LaFixedBeamformingParams_t
{
	bool staticBfEnable;
	StaId stationId;
	uint8 beamformingMode;
	bool periodicBfReq;
	uint8 maxNssNdp;
} LaFixedBeamformingParams_t;

typedef struct _LinkAdaptationEnDisSlowProbingLoops_t
{
	uint8 slowProbingEnDisMask;
} LinkAdaptationEnDisSlowProbingLoops_t;

typedef struct _LaBfCalStatusChanged_t
{
	bool calibrationPass;
} LaBfCalStatusChanged_t;

typedef struct _laBfPsdActBitmapMsgParams_t
{
	 BeamFormingSupportedModes_t activationBitmap;
} laBfPsdActBitmapMsgParams_t;

typedef struct _LaAddVap_t
{
	uint8 vapId;
	uint32 basicRateSet;
} LaAddVap_t;

typedef enum PowerAdaptationTableType
{
	POWER_OFFSET_11B_HIGH_TABLE,
	POWER_OFFSET_11AG_HIGH_TABLE,
	POWER_OFFSET_11N_HIGH_TABLE,
	POWER_OFFSET_11AC_HIGH_TABLE,
	POWER_OFFSET_11B_LOW_TABLE,
	POWER_OFFSET_11AG_LOW_TABLE,
	POWER_OFFSET_11N_LOW_TABLE,
	POWER_OFFSET_11AC_LOW_TABLE,
	
	POWER_OFFSET_11AC_MU_HIGH_TABLE,
	POWER_OFFSET_11AC_MU_LOW_TABLE,
	POWER_OFFSET_HIGH_LOW_TABLE,
	POWER_OFFSET_11AX_TABLE,
	POWER_LIMIT_TABLE,
	
	PROXIMATE_STA_BACKOFF_TABLE,
	DISTANT_STA_BACKOFF_TABLE,
	INTERNAL_POWER_LOWER_LIMIT_TABLE,
	EXTERNAL_POWER_LOWER_LIMIT_TABLE,
	INITIAL_RATE_11B_TABLE,
	INITIAL_RATE_11AG_TABLE,
	INITIAL_RATE_11NAC_TABLE,
	INITIAL_RATE_11AX_TABLE,
}PowerAdaptationTableType_e;

typedef struct PowerAdaptationPsdTables
{
	PowerAdaptationTableType_e tableType;
	K_MSG* psMsg;
	uint32* psdShramAddress;
}laSetPowerAdaptationPsdTablesMsg_t;

typedef struct LaOperatingModeNotificationMsg
{	
	uint8	channelWidth	:2;
	uint8	rxNss			:3;
	StaId	stationId;
}LaOperatingModeNotificationMsg_t;

typedef struct LaClientIsoRecoveryMsg
{
	TxPd_t	*headPd;
	StaId	staIndex[4];

	uint8	tid[4];
	uint16	isMu		:1; // SU/MU selection, 1 - MU, 0 - SU
	uint16	muGrpEntry	:7; // MU Group entry index
	uint16	uspLock 	:4; // USP lock
	uint16	muGroupLock :1; // MU group lock
	uint16	primaryUsp	:2;
	uint16	reserved	:1; 
}LaClientIsoRecoveryMsg_t;

typedef struct LaRemoveSid
{
	StaId stationIndex;
}LaRemoveSid_t;

typedef struct LaQAMplusActivateMsg
{	
    uint32 enableQAMplus;
}LaQAMplusActivateMsg_t;

typedef struct LaMsduInAmsduConfigMsg
{
	uint8 getSetOperation;
	uint8 htMsduInAmsdu;
	uint8 vhtMsduInAmsdu;
#ifdef ENET_INC_ARCH_WAVE600	
	uint8 heMsduInAmsdu;
#else
	uint8 reserved;	
#endif //ENET_INC_ARCH_WAVE600
}LaMsduInAmsduConfigMsg_t;

typedef struct LaMpduInAmpduConfigMsg
{	
	uint8 suMpduInAmpdu;
	uint8 muMpduInAmpdu;
#ifdef ENET_INC_ARCH_WAVE600	
		uint8 heSuMpduInAmpdu;
#endif //ENET_INC_ARCH_WAVE600
}LaMpduInAmpduConfigMsg_t;

/*link adaptation general message*/

typedef union LinkAdaptationGeneralMsgType_tag
{
	LA_SET_CHANNEL_DATA_t laSetChannelData;
	LaFixedRateParams_t laSetFixeRateParams;
	LaFixedPowerParams_t laSetFixedPowerParams;
	LinkAdaptationFixedAntennaSelection_t laSetFixedAntSelParams;
	LinkAdaptationEnDisSlowProbingLoops_t laEnDisSlowProbingLoops;
	LaFixedScpParams_t laFixedScpParams;
	LaProtectionParams_t laprotectedParams;
	LaFixedBeamformingParams_t laFixedBfParams;
	LaBfCalStatusChanged_t laUpdateBfCalStatus;
	laBfPsdActBitmapMsgParams_t laBfActBitmap;
	laSetPowerAdaptationPsdTablesMsg_t laPwerAdaptationTables;
	LaOperatingModeNotificationMsg_t laOperatingModeNotificationMsg;
	LaRemoveSid_t laRemoveSid;
	CddPermutationsDb_t laCddPermutationsDb;
	LaFixedCddParams_t laFixedCddParams;
	LaMsduInAmsduConfigMsg_t laMsduInAmsduConfigReq;
#ifdef LINK_ADAPTATION_TEST_ENV
	LaTestEnvMsgParams_t laTestMsgParams;
#endif
}LinkAdaptationGeneralMsgType_u;

typedef struct TcrPerBwParams
{
	int8 tcrPower;
	uint8 rateindex;
	CyclicPrefixMode_e cpMode;
	uint8 tcrBfMode;
	uint8 BfSmothing;
}TcrPerBwParams_t;

typedef struct CddValues
{
	uint8 cddAnt1;
	uint8 cddAnt2;
	uint8 cddAnt3;
}CddValues_t;

typedef struct TcrGeneralParams
{
	uint8 tcrAntSelection;
	CddValues_t cddVals;
	uint8 tcrAntboost;
	uint8 tcrStbcMode;
	uint8 ldpcMode;
}TcrGeneralParams_t;

typedef struct LaTcrModificationControlParams
{
	StaId staIndex; //if uspIndex is valid (uspIndex!=INVALID_MU_USP_INDEX) then staIndex==groupIndex
	bool changeProbingPoint;
	bool fastProbing;
	bool slowProbing;
	Bandwidth_e lastBwToUpdate;
	Bandwidth_e firstBwToUpdate;
	LaPacketType_e packetType;
	bool isVhtSta;
	bool changeToRatePlusOne;
	bool powerChanged;
	uint8 uspIndex;
#ifdef ENET_INC_ARCH_WAVE600
	bool isHeGroup;
#endif
#ifdef ENET_INC_ARCH_WAVE600D2
	bool isHeExt;
#endif
}LaTcrModificationControlParams_t;

typedef struct LaTcrModificationTcrParams
{
	TcrPerBwParams_t bwDependedTcrValsTable[MAX_POSSIBLE_NUM_OF_BW];
	TcrGeneralParams_t tcrGeneralVals;

}LaTcrModificationTcrParams_t;

typedef struct LaTcrModificationStruct
{
	LaTcrModificationTcrParams_t tcrParams;
	LaTcrModificationControlParams_t controlParams;

}LaTcrModificationStruct_t;

typedef enum LaOperationModeNotificationRxNssType
{
	RX_NSS_TYPE_MAX,
	RX_NSS_TYPE_SU_PPDU,
}LaOperationModeNotificationRxNssType_e;

/* SPEC table 8-80: Subfield values of the Operating Mode field*/
typedef enum LaOperationModeNotificationChannelWidth
{
	OMN_BW_20_MHZ,
	OMN_BW_40_MHZ,
	OMN_BW_80_MHZ,
	OMN_BW_160_OR_80_PLUS_80_MHZ,
	OMN_BW_INVALID,
}LaOperationModeNotificationChannelWidth_e;
		
typedef struct LaOperationModeNotificationAddSta
{
	uint8	channelWidth				:2;
	uint8	rxNss						:2;
	uint8	rxNssType					:1;
	uint8	omnReceivedBeforeAddSta		:1;
	uint8	reserved					:2;
}LaOperationModeNotificationAddSta_t;

#ifdef LINK_ADAPTATION_REGISTRATION

typedef enum LaRegistrationCbType
{
	SAME_CORE,
	OTHER_CORE,
}LaRegistrationCbCoreType_e;

typedef enum LaRegistrationEvent
{
	WORKING_POINT_CHANGED,
	SWITCH_11B,
	NUM_OF_REGISTRATION_EVENTS
}LaRegistrationEvent_e;

typedef struct LaRegistrationReqParams
{
	LaRegistrationCbCoreType_e	coreType;	//one or two cores
	uint16 						cbMsgId;
	LaRegistrationEvent_e 		event;
	bool 						imidiateCb;
	bool registrationSucceeded;
}LaRegistrationReqParams_t;

typedef struct LaRegCbTableParams
{
	uint16 		cbMsgId;
	K_TASKID	taskId;
	bool 		imidiateCb;
	LaRegistrationCbCoreType_e	coreType;	//one or two cores
}LaRegistrationTable_t;

typedef struct LaChangeWpCbParams
{
	uint8	StationIndex;
	uint8 	bwRateIndex[LA_NUM_OF_BANDWIDTH];;
	
}LaChangeWpCbParams_t;

typedef struct LaRgistrationGeneralCbParams
{
	uint8	StationIndex;
	uint8 	param0;
	uint8 	param1;
	uint8 	param2;
	
}LaRgistrationGeneralCbParams_t;


typedef struct LaSwitch11bCbParams
{
	uint16	StationIndex;
	bool 	bw20SwitchTo11B;
	bool 	bw40SwitchTo11B;
	bool 	bw80SwitchTo11B;
}LaSwitch11bCbParams;

typedef struct LaRegistrationTableObj
{
	LaRegistrationTable_t* pRegistrationTable;

	uint8 numOfElementInTable;
	uint8 tableMaxSize;
}LaRegistrationTableObj_t;

#endif //LINK_ADAPTATION_REGISTRATION


typedef struct _LaBfReportInd_t{
	bool status;
} LaBfReportInd_t;

typedef struct LaStartSingleUserValidationParams
{
	StaId stationIndex;
	uint8 reserved[4-SIZE_OF_STA_ID];
} LaStartSingleUserValidationParams_t;

typedef struct LaEndSingleUserValidationParams
{
	StaId stationIndex;
	uint8 reserved[4-SIZE_OF_STA_ID];
} LaEndSingleUserValidationParams_t;

typedef struct LaAddGroupParams
{
	StaId participatingStations[GROUP_MANAGER_MAX_NUMBER_OF_STATIONS_IN_GROUP];
	uint8 groupIndex;
	uint8 nssPerUsp;
	uint8 reserved[2];
} LaAddGroupParams_t;

typedef struct LaRemoveGroupParams
{
	StaId participatingStations[GROUP_MANAGER_MAX_NUMBER_OF_STATIONS_IN_GROUP];
	uint8 groupIndex;
	uint8 reserved[3];
} LaRemoveGroupParams_t;
#ifdef ENET_INC_ARCH_WAVE600

typedef struct LaAddHeGroupParams
{
	uint8 	maxNss[MAX_NUM_OF_USERS_IN_MIMO_GROUP]; //Relevant only in MU-MIMO
	uint8 	planIndex;
	uint8 	groupId; 
	bool 	isStaticGroup;
	uint8 	reserved;
} LaAddHeGroupParams_t;

typedef enum
{	
	LA_ADD_HE_GROUP_SUCCEEDED = 0,
	LA_ADD_HE_GROUP_FAILED,
} LaAddHeGroupStatus_e;

typedef struct LaAddHeGroupCfm
{
	uint8 groupId;
	LaAddHeGroupStatus_e status;
	bool isStaticGroup;
	uint8 reserved;
} LaAddHeGroupCfm_t;

typedef struct LaRemoveHeGroupParams
{
	uint8 planIndex;
	uint8 groupId; 
	uint8 reserved[2];
} LaRemoveHeGroupParams_t;

#endif
typedef struct LaSetTxopForMuMember
{
	StaId staId;
	uint8 txopMode;
}LaSetTxopForMuMember_t;

#ifdef ENET_INC_ARCH_WAVE600

typedef struct LaUlPostRxUphControl
{
	uint8 uphValid				:1;
	uint8 uph					:5;
	uint8 minTransmitPowerFlag	:1;	
	uint8 reserved				:1;	
} LaUlPostRxUphControl_t;


// the following struct is defined according to Standard version: Draft P802.11ax_D4.0 section 9.2.4.6a.2 OM Control
typedef union
{
	uint16 val;
	struct
	{
		uint16 rxNss 						 : 3;
		uint16 channelWidth 				 : 2;
		uint16 ulMuDisable 					 : 1;
		uint16 txNsts 						 : 3;
		uint16 erSuDisable 	                 : 1;		
		uint16 dlMuMimoResoundRecommendation : 1;	
		uint16 ulMuDataDisable 				 : 1;
		uint16 reserved 					 : 4;
	} bitFields;
} LaUlPostRxOmiControl_u;

typedef struct LaUlprReport
{
	CommonUlReport_t 		ulprCommonReport;
	UserUlReport_t	 		ulprUserReport;
	LaUlPostRxUphControl_t	uphControl;
	LaUlPostRxOmiControl_u  omiControl;
} LaUlprReport_t;

typedef enum LnaType
{
	LNA_TYPE_NONE,
	LNA_TYPE_LOW,
	LNA_TYPE_HIGH,
}LnaType_e;

typedef struct LaLnaTypeIndMsg
{
	StaId staId;
	LnaType_e lnaType;
} LaLnaTypeIndMsg_t;

#endif 

typedef enum  {
	LA_INACTIVE_GROUP_STATE, 
	LA_PRELIMINARY_PROBING_STATE,
	LA_ACTIVE_GROUP_STATE,
	LA_NUMBER_OF_GROUP_STATES
}LinkAdaptationGroupState_e;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void LinkAdaptation_Init(void);
void LinkAdaptation_QAMplusInit(bool QAMplusEnableFromLm);
void QAMplus_SetThresh(uint16 counterVal1, uint16 counterVal2);
void QAMplus_DebugSetSupportedThresh(StaId stationId, uint16 supportedThreshVal);
void QAMplus_Enable(bool enableFlag);
bool QAMplus_get(void);
void QAMplus_GetThresh(StaId stationId);
//#ifdef QAM_PLUS_ALWAYS
//void QAMplus_ChangeTCRparamsToVHT(StaId staionId);
//#endif
void isr_linkAdaptation_SequencerFifoNotEmpty(void);
void isr_linkAdaptation_BaaFifoNotEmpty(void);
void isr_LinkAdaptation_ProbingTimerEvent(uint32 eventParam);
void  isr_LinkAdaptation_AgingTimer(uint32 eventParam);
void LinkAdaptation_Task(K_MSG *psMsg);
uint8 AntennaSelection_GetConnectedAntennasBitmap(void);
void  isr_LinkAdaptation_InitBfReport(uint32 param);
void linkAdaptationOpertingModeNotificationSimulateActionFrameBeforeAddSta(void);
void linkAdaptationOpertingModeNotificationSimulateActionFrameAfterAddSta(uint32 channelWidth, uint32 rxNss);
uint8 linkAdaptationGetVhtUspIndex(StaId staIndex,uint16 groupId);
void linkAdaptationSetVhtUspIndex(StaId staIndex,uint8 groupId,uint8 uspIdnex);
void linkAdaptationResetVhtUspIndex(StaId staIndex,uint8 groupId);
void linkAdaptationProcessBaaReport(BaaRateAdaptiveFullFifo_t* pBaaHeReport);
void linkAdaptationSetTransmissionTimeLimit(StaId nextSid, uint16 transmissionTime);
#ifdef ENET_INC_ARCH_WAVE600
void linkAdaptationProcessUlprReport(LaUlprReport_t *ulprReport, bool isOmiReceived);
void linkAdaptationIncProbingCounterForTempDummyUser(BaaRateAdaptiveFullFifo_t* pLastBaaReport);
void linkAdaptationSetBaReportReceivedForRealUser(uint8 uspIndex);
#endif //ENET_INC_ARCH_WAVE600
#ifdef ENET_INC_ARCH_WAVE600B
void linkAdaptationProcessPreAggReport(PreAggFullReport_t* preAggReport);
bool linkAdaptationIsEtsiMode(void);
bool LinkAdaptivePdIsEtsi5GDuringPsduLimitError(bool psduLimit, TxPd_t* headPd);
#endif //ENET_INC_ARCH_WAVE600B
bool linkAdaptationIsGroupActive(uint8 groupId, bool isHeGroup);
#if defined(BSRC_ARTIFICIAL_UPDATE_FOR_UL)
void LinkAdaptation_SetBsrcCountersForStaticPlan(K_MSG* pkMsg);
void LinkAdaptation_ClearBsrcCountersForStaticPlan(void);
#endif
#endif // LINK_ADAPTATION_API_H_
