#ifndef ANTENNA_SELECTION_H_
#define ANTENNA_SELECTION_H_
/***********************************************************************************
 File:		AntennaSelection.h
 Module:		LinkAdaptation 
 Purpose: 	find the best transmission parameters for achieve best rate
 Description:	This file contains all definitions and the structures of the RateAdaptation
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define ANT_SEL_MAX_NUMBER_OF_PERMUTATIONS 	(32)
#define ANT_SEL_MAX_NUMBER_OF_ANTENNAS 		(4)
#define ANT_SEL_INVALID_PERMUTATION			(0)
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------





//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void  AntennaSelectionInit (void);
uint8 AntennaSelectionGetAntennaSelectionBitmap(StaId staIndex);
uint8 AntennaSelectionGetAntennaCount(StaId staIndex);
uint8 AntennaSelectionGetActivatedAntennasBitmap(void);
uint8 AntennaSelectionCalcAntennaCount(uint8 antennaSelctionBitmap);
void AntennaSelectionSetChannel(void);
void AntennaSelectionSetBitmapInVapTcr(uint8 vapId, uint8 antSelectionMask, LaPacketType_e packetType);
void AntennaSelectionSetBitmapInAutoReplyTcr(uint8 antSelectionMask);
void AntennaSelectionAddSta (StaId staIndex);
void AntennaSelectionSetEnabledAntMask(uint8 enabledAntennaBitmap);
void AntennaSelectionSetStaAntSelMask(StaId staIndex, uint8 antennaSelectionMask, bool chnageRateMask);
void AntennaSelectionSetVapAntSelMask(uint8 vapId, uint8 antennaSelectionMask);
uint8 AntennaSelectionConvertAntMaskToEnabledAnt(uint8 antennaMask);
void AntennaSelectionSetAntennaConnected(uint8 antennaConnectedMask);
uint8 AntennaSelectionGetLowerAntSelection(uint8 numberOfAnt);
void AntennaSelectionStaNumOfAntsChanged(StaId staIndex, uint8 antennaSelection);
uint8 AntennaSelectionGetDefaultBitmap(void);
void AntennaSelectionRateIsChanged(StaId staIndex, uint8 newRateIndex, uint8 oldRateIndex);
void AntennaSelectionProcessFeedback(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
uint8 AntennaSelectionGetActivatedAntennasCount(void);


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#endif /* ANTENNA_SELECTION_H_ */

