#ifndef BEAM_FORMING_H_
#define BEAM_FORMING_H_
/***********************************************************************************
 File:		Beamforming.h
 Module:		LinkAdaptation 
 Purpose: 	
 Description:	This fille handling the Beamforming adaptation definitions
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "linkAdaptation_api.h"
#include "StaDatabase_Api.h"
#include "LinkAdaptation.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


typedef struct BeamFormingCalibrationPass
{
	uint8 bfImplicitCalibrationPass: 1;
	uint8 bfExplicitCalibrationPass: 1;
	
} BeamFormingCalibrationPass_t;
typedef enum BfValiationOptions
{
	BF_MODE_NOT_VALID,
	BF_MODE_VALID_AT_THE_REQUIRED_RATE,
	BF_MODE_VALID_AT_HIGER_RATE
}BfValiationOptions_e;

typedef BfValiationOptions_e (*BfModeValidationCheckFunc)(StaId, uint8);


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void BeamformingInit (void);
void BeamformingAddStation(StaId staIndex, HtCapabilitiesInfo_t htCapbilities, sVHT_CAPABILITIES_INFO vhtCapabilities, HE_MAC_PHY_CAPABILITIES_INFO* pHeMacPhyCapabilities,sTransmitBfCapInfo transmitBfCapabilities);
void BeamformingPrepareNextProbingPoint(LinkAdaptationDatabaseDistributionPack_t *pDistParam, bool stayWithLastProbingPoint);
void BeamformingSetNextProbingPointInTcr(StaId staIndex);
void BeamformingProcessFeedback(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void beamFormingSetBfInTcr(StaId staIndex, bool enableRatePlusOne, bool isBfProbing, BeamformingMode_e bfState, LaPacketType_e packetType);
void BeamformingSetFixedMode(StaId staId);
bool BeamFormingCheckReadyForTransmission(StaId staIndex);
bool isBeamFormingReadyForTransmit(StaId staIndex, BeamformingMode_e bfState);
void prepareExplicitMode(StaId staIndex);
void prepareImplicitMode(StaId staIndex);
void prepareStbc1x2Mode(StaId staIndex);
void prepareStbc2x4Mode(StaId staIndex);
void prepareNoBfMode(StaId staIndex);
void handelExplicitBfReportTimerEvent(K_MSG *psMsg);
void initExplicitBfStaCapabilities(StaId staIndex, HtCapabilitiesInfo_t htCapbilities, sVHT_CAPABILITIES_INFO vhtCapabilities, HE_MAC_PHY_CAPABILITIES_INFO* pHeMacPhyCapabilities,sTransmitBfCapInfo transmitBfCapabilities);
void setBfDebugParams(LaFixedBeamformingParams_t* pBfFixedParams);
LaFixedBeamformingParams_t* getBfDebugParams(void);
void sendBfRequest(StaId staId);
void stopSendBfRequest(StaId staId);
void setNoBfMode(LaTcrModificationStruct_t* pModifcationParamsIn, LaTcrModificationStruct_t* pModifcationParamsOut);
void BeamformingRateChagedHadnling(StaId staIndex);
BfValiationOptions_e BeamformingValidCheck(StaId staIndex, uint8 rateIndex, BeamformingMode_e bfRequiredState);
void BeamformingRemoveStation(StaId staIndex);
void Beamforming_AgingEvent(StaId staIndex);
void BeamFormingUpdateCalStatus(bool bfExplicitCalPass, bool bfImplicitCalPass);
void BeamformingSetActivationBitmap(BeamFormingSupportedModes_t bfActivationBitmap);
void BeamformingStateTo(StaId staIndex);
void BeamformingSetDebugMaxNdp(StaId staIndex);
void BeamformingResetWorkingPointState(StaId staIndex);
void BeamformingResetDb(StaId staIndex);
bool isBfReportNotReceivedAfterRequest(StaId staIndex);

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/


#endif /* BEAM_FORMING_H_ */

