#ifndef BW_ADAPTATION_H_
#define BW_ADAPTATION_H_
/***********************************************************************************
 File:		BwAdaptation.h
 Module:		LinkAdaptation 
 Purpose: 	find the best transmission parameters for achieve best rate
 Description:	This file contains all definitions and the structures of the RateAdaptation
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "lmi.h"
#include "TxSequencer_Api.h"
#include "StaDatabase_Api.h"
#include "LinkAdaptation.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------





//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
 
void BwAdaptationAddSta(StaId staindex, HtCapabilitiesInfo_t htCapabilities, sVHT_CAPABILITIES_INFO vhtCapabilities, HE_MAC_PHY_CAPABILITIES_INFO* pHeMacPhyCapabilities, LaOperationModeNotificationChannelWidth_e omnChannelWidth, uint8 initRate);
void BwAdaptation_Init (void);
void BwAdaptation_Handler(StaId staIndex,uint8 uspIndex);
bool BwAdaptation_IsBwAdaptationActive(void);
void BwSetNextProbingPoint(LinkAdaptationDatabaseDistributionPack_t *pDistParam, bool stayWithLastProbingPoint);
void BwProcessFeedback(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void BwAdaptationDisableBwDependenceOnCcA(void); 
void BwAdaptation_AgingEvent(void); 
//void bwAdaptationSetStationBwLimit(StaId staId, Bandwidth_e bwLimit, bool changeWorkingPoint);
//void bwAdaptationSetBwLimit(LinkAdaptationDatabaseDistributionPack_t *pDistParam, Bandwidth_e bwLimit, bool changeWorkingPoint);
void BwAdaptationTo(LinkAdaptationDatabaseDistributionPack_t* pLaDbDistributionParameter);
void BwAdaptationRateIsChanged(StaId staIndex, uint8 oldRate, uint8 newRate);




/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

extern	AdaptiveAlphaFilterParams_t LinkAdaptationWlanEffectiveBW40;
extern	AdaptiveAlphaFilterParams_t LinkAdaptationWlanEffectiveBW80;
extern uint16 WlanEffectiveBW40DeltaTAverage;
extern uint16 WlanEffectiveBW80DeltaTAverage;
#ifdef ENET_INC_ARCH_WAVE600
extern	AdaptiveAlphaFilterParams_t LinkAdaptationWlanEffectiveBW160;
extern uint16 WlanEffectiveBW160DeltaTAverage;
#endif


#endif /* PROTECTION_ADAPTATION_H_ */



