#ifndef CDD_H_
#define CDD_H_
/***********************************************************************************
 File:		CDD.h
 Module:		LinkAdaptation 
 Purpose: 	find the best transmission parameters for achieve best rate
 Description:	This file contains all definitions and the structures of the RateAdaptation
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "linkAdaptation_api.h"
#include "LinkAdaptation.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define CDD_ANT1_MASK				   (0xF)
#define CDD_ANT2_MASK				   (0xF0)
#define CDD_ANT3_MASK				   (0xF00)
#define CDD_ANT1_SHIFT				   (0)
#define CDD_ANT2_SHIFT				   (4)
#define CDD_ANT3_SHIFT				   (8)
#define CDD_DEFAULT_INDEX			   (0)



//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------




//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void CddInit (void);
void CddAddSta(StaId staIndex);
void CddProcessFeedback(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void CddIncreaseIndexAndFillValues(CddValues_t* cddVal, uint8* cddIndex, StaId staIndex, uint8 antCount, bool allowNextCddSameAsWp);
void CddStateIsChanged(StaId staIndex, LaTcrModificationStruct_t* tcrModicationParams);
void CddStaNumOfAntsIsChanged(StaId staIndex);
void CddSetInAutoReplyTcr(CddValues_t cddVals);
void CddVapNumOfAntsIsChanged(uint8 vapId, uint8 numOfAntennas);
void CddAutoReplyNumOfAntsIsChanged(uint8 numOfAntennas);
void CddSetInVapTcr(uint8 vapId, CddValues_t *cddVals);
void CddsetFixedValuesInStaTcr(StaId staIndex, uint16 cddPermutation);
void CddSetDataFromPsd(CddPermutationsDb_t* cddPsdDb);
void CddfillCddValues(CddValues_t* cddVal, uint8 cddIndex, uint8 antCount);

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#endif /* CDD_H_ */

