#ifndef CYCLIC_PREFIX_H_
#define CYCLIC_PREFIX_H_
/***********************************************************************************
 File:		CyclicPrefix.h
 Module:		LinkAdaptation 
 Purpose: 	
 Description:	This fille handling the cyclic prefix adaptation definitions
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define CP_NUM_OF_MODES_HT_VHT 2
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum
{
	CP_SHORT_HT_VHT_HE,		// HT/VHT - 0.4 s, HE - 0.8 s
	CP_LONG_HT_VHT_MED_HE, 	// HT/VHT - 0.8 s, HE - 1.6 s
	CP_LONG_HE				// HT/VHT - invalid, HE - 3.2 s
}CyclicPrefixType_e;

typedef enum
{
	LTF_1X,	
	LTF_2X, 	
	LTF_4X	
}LtfType_e;


//---------------------------------------------------------------------------------
//						Externs						
//---------------------------------------------------------------------------------

extern CyclicPrefixType_e convertCpModeToCpType[CP_NUM_OF_MODES];


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void CyclicPrefixAdaptationInit (void);
void CyclicPrefixSetNextProbingPoint(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, bool stayWithLastProbingPoint);
void CyclicPrefixProcessFeedback(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void CyclicPrefixAddStation(StaId staIndex, HtCapabilitiesInfo_t htCapbilities, sVHT_CAPABILITIES_INFO vhtCapabilities, HE_MAC_PHY_CAPABILITIES_INFO* pHeMacPhyCapabilities);
void CyclicPrefixAddGroup(uint8 groupId);
void CyclicPrefixRemoveGroup(uint8 groupId);
void CyclicPrefixSetFixedVal(StaId staIndex, uint8 scpShortPreamble);
void cyclicPrefixWorkingPointChanged(StaId staIndex, uint8 oldRate, uint8 newRate);
void cyclicPrefixResetLoop(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, bool bUseDefaultParams);
void CyclicPrefixUpdateDbWithFixedParams(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, CyclicPrefixMode_e currentWp);

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#endif /* CYCLIC_PREFIX_H_ */

