
#ifndef DYNAMIC_TXOP_H
#define DYNAMIC_TXOP_H

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
#include "LinkAdaptation.h"
//---------------------------------------------------------------------------------
//						Type definitions						
//---------------------------------------------------------------------------------
typedef struct TxopCommonParams_
{
	TxopMode_e	configuredTxopMode;
	TxopMode_e	currentTxopMode;
	uint16		txopMaxNumStas;
}TxopCommonParams_t;
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define DYNAMIC_TXOP_PSDU_RESOLUTION_BITS_USEC_TO_32_USEC		   (5)	 // 2^5 = 32
#define DYNAMIC_TXOP_PSDU_TIME_MARGIN 		  			           (16)	 //  [32 * s] 
#define DYNAMIC_TXOP_NUMBER_OF_BAA_REPORTS_TH 			           (8)
#define DYNAMIC_TXOP_MPDU_LENGTH_FACTOR							   (30)	

#define DYNAMIC_TXOP_MAX_NUM_CONNECTED_STAS_THRESHOLD				(4)
//---------------------------------------------------------------------------------
//						Public functions						
//---------------------------------------------------------------------------------
void DynamicTxop_Init(void);

TxopMode_e DynamicTxop_GetTxopMode(void);
void DynamicTxop_SetTxopMode(StaId stationIndex, TxopMode_e mode);
void DynamicTxop_AddStation(StaId stationIndex);
void DynamicTxop_RemoveStation(StaId stationIndex);

void DynamicTxop_RateOrBwIsChanged(StaId staId, uint8 rateIndex, uint8 bw);
void DynamicTxop_UpdateEstimator(StaId staId, uint8 currentPsduTime, int16 lnBeta, uint8 constAlphaForDtAv);
void DynamicTxop_Handler(StaId staId);
void DynamicTxop_OverwriteTxopModeForMuMember(StaId staId, uint8 mode);

uint16 DynamicTxop_GetTxopDuration(void);
void DynamicTxop_SetTxopDuration(uint16 txopDuration);
uint16 DynamicTxop_GetTxopMaxNumStas(void);
void DynamicTxop_SetTxopMaxNumStas(StaId stationIndex, uint16 txopMaxNumStas);


#endif
