#ifndef ESTIMATORS_H_
#define ESTIMATORS_H_
/***********************************************************************************
 File:		Estimators.h
 Module:		LinkAdaptation 
 Purpose: 	Process estimators based in the Sequencer & BAA reports
 Description:	This file contains all definitions and the structures of the estimators
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "ShramLinkAdaptation.h"
#include "AlphaFilter.h"
#include "SharedDbTypes.h"
//#include "RateAdaptation.h"
#include "Utils_Api.h"
#include "LinkAdaptationProductAdjustment.h"
#include "MT_Math.h"
#include "TxSequencer_Api.h"
#include "LinkAdaptationCommon.h"
#include "LinkAdaptation.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define INVALID_RATE_INDEX_VAL  MAX_UINT8
#define INVALID_ESTIMATORS_DB_INDEX_VAL  MAX_UINT8



//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
#define FACTOR_TOTAL_SIZE_OF_AMPDU(s) (s*(1 << 7))

#define LOW_FRAME_RATE_CALC(T,D,F)	((T*100)/(D*F))	/*	T - totalSizeOfAllMpdus, D- diffTsf, F - factor 
															(totalSizeOfAllMpdu * 100*1000) / diffTsf * factor*1024		*/
#define ABS(x)			( (x>=0) ? (x) : (-1*(x)) )
																		
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct 
{
	AdaptiveAlphaFilterParams_t* pFilterParams;
	uint8 filterInput;
	int16 lnBeta;
	uint8 constAlphaForDtAverage;
	uint16* dTAverage;
	bool updateDtAverage;
	uint8 transactionNumber; 
	bool isValid; 
}SequencerPendingAlphaFilterParams_t;


#ifdef LA_CALC_REF_LEN
#endif
extern CurrentPacketParameters_t CurrentPacketParams;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Static Function Declaration 			
//---------------------------------------------------------------------------------

void estimatorsInit(void);
void estimatorsResetWorkingPoint(LaStationUspCommonParams_t* laStaUspCommon,LaStationGroupCommonParams_t* laStaGroupCommon);
void estimatorsRemoveStaleFilterResult(StaId stationIndex);
void estimatorsProcessSequencerReport(TxSequencerReport_t* pSequencerReport, LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void estimatorsProcessBaaReport(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, BaaRateAdaptiveFullFifo_t* pBaaReport);
void estimatorsUpdateRatesInDbForAllBws(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, uint8 newWorkingPointRateIndex, uint8 previousWpRateindex, Bandwidth_e mainBw);
void estimatorsFastProbingSearchMaxEffTp(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, FastProbingPointEstimators_t* fastProbingPointEstimators,uint8* fastProbingPointEstimatorsIndexes,FastProbingPointEstimators_t** pMaxTpFilterResultAddrOutput , uint32 maxValidTsfDiff, uint16 maxEffectiveTp, uint16 marginPercent); 
void estimatorsUpdateRatesInDb(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, uint8 newWorkingPointRateIndex, uint8 lastWpRateindex);
bool estimatorsProbingValidationCriteria(uint8* validationCounter, uint8 probingValidationTh);
void estimatorsResetDb(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void estimatorsResetRatesEstimators(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void estimatorsAgingCheck(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void estimatorsResetSlowProbingEstimators(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void estimatorsResetGroupSlowProbingEstimators(uint8 groupIndex);
void estimatorsResetFastProbingEstimators(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void estimatorsResetFastProbingFilters(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void estimatorsResetGroupFastProbingEstimators(uint8 groupIndex);
void estimatorsSetSlowProbingPointRateIndex(StaId stationIndex,uint8 uspIndex, uint8 val);
FastProbingPointEstimators_t* estimatorsGetWpPerEstimatorsPtr(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
SlowProbingPointEstimators_t* estimatorsGetSlowProbingPerEstPtr(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
uint16 estimatorsCalcEffectiveTp(uint16 Lossless,uint16 Retries);
uint8 estimatorsGetProbingPointRateIndex(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, RaFastProbingPoint_e probingpoint);
uint8 estimatorsGetWorkingPointRateIndexOfMainBw(LaStationUspCommonParams_t* laStaUspCommon);
uint8 estimatorsGetHigherProbingRateIndex(StaId staIndex);
uint8 estimatorsGetSlowProbingRatePlusOne(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void estimatorsWorkingPointDbUpdate(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, BaaRateAdaptiveFullFifo_t*pBaaReport);
void estimatorsUpdateCollisionEst(TxSequencerReport_t* pSequencerReport, LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
uint8 goodPutEstimation(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, uint8 currentPer,uint8 rateIndex,Bandwidth_e bandwidth);
void estimatorsRecheckCandidacy(StaId staIndex);
void lowFrameRateEstimation(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, uint16 totalSizeOfAllMpdus,uint16 averageDtFilterResult);
uint16 calculateTsfDiff(AdaptiveAlphaFilterParams_t* pFilterParams);
void estimatorsSlowProbingDbUpdate(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, BaaRateAdaptiveFullFifo_t*pBaaReport);
void estimatorsFastProbingDbUpdate(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, BaaRateAdaptiveFullFifo_t*pBaaReport);
void updatePsWithinAwindow(TxSequencerReport_t* pSequencerReport, LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void updateMgmtWithinAwindow(BaaRateAdaptiveFullFifo_t* pBaaReport, LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);

#endif /* ESTIMATORS_H_ */
