#ifndef GROUPS_METRICS_CALCULATION_H
#define GROUPS_METRICS_CALCULATION_H
/***********************************************************************************
 File:		Estimators.h
 Module:		LinkAdaptation 
 Purpose: 	Process estimators based in the Sequencer & BAA reports
 Description:	This file contains all definitions and the structures of the estimators
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "ShramLinkAdaptation.h"
#include "AlphaFilter.h"
#include "SharedDbTypes.h"
//#include "RateAdaptation.h"
#include "Utils_Api.h"
#include "LinkAdaptationProductAdjustment.h"
#include "MT_Math.h"
#include "TxSequencer_Api.h"
#include "LinkAdaptationCommon.h"
#include "LinkAdaptation.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
																		
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
#ifdef DYNAMIC_MU_EFFICIENCY_CALC
extern void GroupsMetricsCalculator_CalcAndUpdateDlPsduEfficiency(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter,BaaRateAdaptiveFullFifo_t* pBaaReport, uint32 lnBeta, uint8 constAlphaCoefForDtAvPower2, uint16* avDTResult);
#endif
extern uint8 GroupsMetricsCalculator_CalcUlPsduEfficiency(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter,BaaRateAdaptiveFullFifo_t* pBaaReport, uint32 lnBeta, uint8 constAlphaCoefForDtAvPower2, uint16 avDTResult);
extern void MetricsCalculator_PrepareData(void);
extern void MetricsCalculator_ResetGroupData(uint8 groupId);
extern void MetricsCalculator_ResetStaData(StaId staId);
extern void GroupsMetricsCalculator_Init(void);
//---------------------------------------------------------------------------------
//						Static Function Declaration 			
//---------------------------------------------------------------------------------

#endif /* GROUPS_METRICS_CALCULATION_H */
