#ifndef POWER_ADAPTATION_H_
#define POWER_ADAPTATION_H_
/***********************************************************************************
 File:		PowerAdaptation.h
 Module:		LinkAdaptation 
 Purpose: 	find the best power parameters
 Description:	This file contains all definitions and the structures of the Power adaptation
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "lmi.h"
#include "LinkAdaptation.h"
#include "linkAdaptation_api.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define INTERNAL_LIMIT_AUTO_VAL MAX_UINT8


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct PowerAdaptationBitMaskDb
{
	StationBitmap_t proximateStaIndication;
	StationBitmap_t distantStaIndication;
	StationBitmap_t assymetricLinkIndication;
	StationBitmap_t nextPowerStepIndication;
	StationBitmap_t powerModeIndication;
	StationBitmap_t probeWithRatePlus1;
	
}PowerAdaptationBitMaskDb_t;

typedef struct RatePowerOffset
{
	int8 powerOffset;
	int8 evmPowerBackoff;
}RatePowerOffset_t;

typedef struct PowerOffsetHighLow
{
	uint8 frequency;
	uint8 highLow;//high =1 low=0
}PowerOffsetHighLow_t;

typedef struct PowerLimit
{
	int8 muMimoLimit[LA_NUM_OF_BANDWIDTH];
	int8 beamFormingLimit[LA_NUM_OF_BANDWIDTH];
}PowerLimit_t;



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void PowerAdaptationInit (void);
void PowerAdaptationAddStation(StaId staIndex);
void PowerSetNextProbingPointAndIndications(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, bool stayWithLastProbingPoint);
void PowerAdaptationAdjustAdditionalSteps(StaId staIndex, PowerAdaptationDatabase_t* pPowerAdaptationDb, Bandwidth_e bandwidth, LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void PowerProcessFeedback(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void UpdateRatePowerOffset(uint8 freqIndex, int8 minOnLowerUpperDiffPowerTable);
void SetPowerDataFromTpc(LA_SET_CHANNEL_DATA_t* pTpcPowerData);
uint8 GetTcrDefaultPowerVal(bool isVht, uint8 rateIndex, Bandwidth_e bandwidth);
void CalcLimitsAndSetVapPower(uint8 vapIndex);
void SetVapFixedPower(uint8 vapindex, uint8 powerVal, LaPacketType_e changeType);
uint8 CalcLimitsAndGetStaTcrPowerVal(StaId staIndex, Bandwidth_e bandwidth, uint8 rateIndex, bool addAccPower, LaPacketType_e packetType, uint8 modifiedAntennaSelectionBitmap, bool useAdaptivePower,uint8 isBFExist);
void SetPowerInVapTcr(uint8 vapIndex, int8* pPowerValTable, Bandwidth_e bandwidth, Bandwidth_e lastBwToUpdate, bool changeProbingPoint, LaPacketType_e packetType);
#if 0 
void PowerAdaptationResetDiffPower(StaId staIndex);
#endif
bool PowerAdaptationCalcPowerInStaLimits(StaId staIndex, Bandwidth_e bandwidth, uint8 rateIndex, int8 inputPower, int8* outputPower);
void PowerAdaptationCalcStaLimits(StaId staIndex,Bandwidth_e bandwidth, uint8 antennaSelectionBitmap,uint8 isBFExist);
uint8 convertTcrVal2Power(Bandwidth_e bandwidth, uint8 tcrVal);
void PowerAdaptationSetLastLimitOffset(K_MSG* psMsg);
void SetPowerTablesFromPsd(uint16 tableSizeInBytes, PowerAdaptationTableType_e tableType, int8* tableScratchpad );
uint8 GetInitialRateAccordingToRssi(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, int8 rssiVal);
void CalcDefaultPowerLimits(void);
void CalculateAutoReplyPower(void);
int8 convertPower2TcrVal (Bandwidth_e bandwidth, int8 powerVal);
int8 powerAdaptationGetultimateEvm(Bandwidth_e bandwidth);
int8 getRatePowerOffsetForGroupMu(uint32 numberOfNss, uint8 rateindex);
int8 isMuPowerOffsetTableUsed(void);
int8 getMuPowerLimit(Bandwidth_e bandwidth);
int8 getBfPowerLimit(Bandwidth_e bandwidth);
int8 getRegLimitPerAnt(Bandwidth_e bandwidth);
void setFixedPowerInStaTcr(StaId staIndex);

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#endif /* POWER_ADAPTATION_H_ */

