/***********************************************************************************
 File:		LinkadaptationDriver.h
 Module:		LinkAdaptation 
 Purpose: 	
 Description:	
 				
************************************************************************************/
#ifndef LINK_ADAPTATION_PHY_DRIVER_H_
#define LINK_ADAPTATION_PHY_DRIVER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
//#include "RateAdaptation.h"
#include "SharedDbTypes.h"
#include "StaDb.h"
#include "VapDb.h"
#include "CDD.h"

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define PROTECTED_STA_DB_SIZE_WORDS 15
#define PROTECTED_VAP_DB_SIZE_WORDS 15
#define PROTECTED_GROUP_DB_SIZE_WORDS 9

#define REF_LEN_MODIFY_NUMBER_OF_WORDS_IN_STA_DB 2
#define BF_RX_PARAMS_MODIFY_NUMBER_OF_WORDS_IN_STA_DB 1
#define STA_HW_DB_DW3_OFFSET 3

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef enum bfMode
{
	TX_BF_BYPASS,
	TX_BF_BEAMFORMING,
	TX_BF_CALIBRATION,
	TX_BF_FLAT,
}bfMode_e;

typedef enum _Scp_e
{
	SCP_LONG_CP  = 0,
	SCP_SHORT_CP = 1,
	SCP_LAST,
} Scp_e;

typedef struct StaDbRateAdaptationParams
{
	/* StaDb Word 4 */
	Tcr0_t tcr020MhzData; // :24;                                  /*  */

	/* StaDb Word 5 */
	Tcr3_t		 tcr320MhzData; //:24;								   /*  */

	/* StaDb Word 6 */
	Tcr0_t tcr040MhzData; // :24;                                  /*  */

	/* StaDb Word 7 */
	Tcr3_t tcr340MhzData; // :24;                                  /*  */

	/* StaDb Word 8 */
	Tcr0_t tcr080MhzData; // :24;                                  /*  */

	/* StaDb Word 9 */
	Tcr3_t tcr380MhzData; //:24;                                  /*  */

	/* StaDb Word 10 */
	Tcr1_t tcr1Data; // :24;                                       /*  */

	/* StaDb Word 11 */
	Tcr2_t tcr2; //:24;                                           /*  */

	/* StaDb Word 12 */
	Tcr1_t tcr1Management; //:24;                                 /*  */

	/* StaDb Word 13 */
	Tcr0_t tcr020MhzManagement; //:24;                            /*  */

	/* StaDb Word 14 */
	Tcr3_t			 tcr320MhzManagement; //:24;                            /*  */

	/* StaDb Word 15 */
	Tcr0_t tcr040MhzManagement; //:24;                            /*  */

	/* StaDb Word 16 */
	Tcr3_t  tcr340MhzManagement; //:24; 						   /*  */

	/* StaDb Word 17 */
	Tcr0_t tcr080MhzManagement; //:24;                            /*  */
	
	/* StaDb Word 18 */
	Tcr3_t  tcr380MhzManagement; //:24;                            /*  */
} StaDbRateAdaptationParams_t;
typedef struct VapRateAdaptationParams
{
	/* VapDb Word 4 */
	Tcr0_t tcr020MhzData;					 /*  */

	/* VapDb Word 5 */	
	Tcr3_t tcr320MhzData;						 /*  */

	/* VapDb Word 6 */	
	Tcr0_t tcr040MhzData;					 /*  */

	/* VapDb Word 7 */
	Tcr3_t tcr340MhzData;						 /*  */

	/* VapDb Word 8 */
	Tcr0_t tcr080MhzData;					 /*  */

	/* VapDb Word 9 */
	Tcr3_t tcr380MhzData;						 /*  */

	/* VapDb Word 10 */
	Tcr1_t tcr1Data;							 /*  */

	/* VapDb Word 11 */
	Tcr2_t tcr2;								 /*  */

	/* VapDb Word 12 */
	Tcr1_t tcr180211;							 /*  */

	/* VapDb Word 13 */
	Tcr0_t tcr020MhzMgnt;			 /*  */

	/* VapDb Word 14 */
	Tcr3_t tcr320MhzMgnt;						 /*  */

	/* VapDb Word 15 */
	Tcr0_t tcr040MhzMgnt;			 /*  */

	/* VapDb Word 16 */
	Tcr3_t tcr340MhzMgnt;						 /*  */

	/* VapDb Word 17 */
	Tcr0_t tcr080MhzMgnt;			 /*  */

	/* VapDb Word 18 */
	Tcr3_t tcr380MhzMgnt;						 /*  */
} VapRateAdaptationParams_t;

typedef struct GroupDbRateAdaptationParams
{
	union //word19
	{
		uint32 word19;
		struct
		{
			uint32 tcr3TemplateFixedValues : 24;
			uint32                         : 8;
		};
		struct
		{
			uint32          : 24;
			uint32 scp20Mhz : 1;
			uint32          : 7;
		};
		struct
		{
			uint32          : 25;
			uint32 scp40Mhz : 1;
			uint32          : 6;
		};
		struct
		{
			uint32          : 26;
			uint32 scp80Mhz : 1;
			uint32          : 5;
		};
		struct
		{
			uint32             : 27;
			uint32 reserved190 : 1;
			uint32             : 4;
		};
		struct
		{
			uint32            : 28;
			uint32 wpScp20Mhz : 1;
			uint32            : 3;
		};
		struct
		{
			uint32            : 29;
			uint32 wpScp40Mhz : 1;
			uint32            : 2;
		};
		struct
		{
			uint32            : 30;
			uint32 wpScp80Mhz : 1;
			uint32            : 1;
		};
		struct
		{
			uint32             : 31;
			uint32 reserved191 : 1;
		};
	};
	union //word20
	{
		uint32 word20;
		struct
		{
			uint32 usp0Tcr3Rate20Mhz : 6;
			uint32                   : 26;
		};
		struct
		{
			uint32             : 6;
			uint32 reserved200 : 2;
			uint32             : 24;
		};
		struct
		{
			uint32                   : 8;
			uint32 usp0Tcr3Rate40Mhz : 6;
			uint32                   : 18;
		};
		struct
		{
			uint32             : 14;
			uint32 reserved201 : 2;
			uint32             : 16;
		};
		struct
		{
			uint32                   : 16;
			uint32 usp0Tcr3Rate80Mhz : 6;
			uint32                   : 10;
		};
		struct
		{
			uint32                              : 22;
			uint32 usp0AltRateReasonFastProbing : 1;
			uint32                              : 9;
		};
		struct
		{
			uint32                              : 23;
			uint32 usp0AltRateReasonSlowProbing : 1;
			uint32                              : 8;
		};
		struct
		{
			uint32             : 24;
			uint32 reserved202 : 8;
		};
	};
	union //word21
	{
		uint32 word21;
		struct
		{
			uint32 usp1Tcr3Rate20Mhz : 6;
			uint32                   : 26;
		};
		struct
		{
			uint32             : 6;
			uint32 reserved210 : 2;
			uint32             : 24;
		};
		struct
		{
			uint32                   : 8;
			uint32 usp1Tcr3Rate40Mhz : 6;
			uint32                   : 18;
		};
		struct
		{
			uint32             : 14;
			uint32 reserved211 : 2;
			uint32             : 16;
		};
		struct
		{
			uint32                   : 16;
			uint32 usp1Tcr3Rate80Mhz : 6;
			uint32                   : 10;
		};
		struct
		{
			uint32                              : 22;
			uint32 usp1AltRateReasonFastProbing : 1;
			uint32                              : 9;
		};
		struct
		{
			uint32                              : 23;
			uint32 usp1AltRateReasonSlowProbing : 1;
			uint32                              : 8;
		};
		struct
		{
			uint32             : 24;
			uint32 reserved212 : 8;
		};
	};
	union //word22
	{
		uint32 word22;
		struct
		{
			uint32 usp2Tcr3Rate20Mhz : 6;
			uint32                   : 26;
		};
		struct
		{
			uint32             : 6;
			uint32 reserved220 : 2;
			uint32             : 24;
		};
		struct
		{
			uint32                   : 8;
			uint32 usp2Tcr3Rate40Mhz : 6;
			uint32                   : 18;
		};
		struct
		{
			uint32             : 14;
			uint32 reserved221 : 2;
			uint32             : 16;
		};
		struct
		{
			uint32                   : 16;
			uint32 usp2Tcr3Rate80Mhz : 6;
			uint32                   : 10;
		};
		struct
		{
			uint32                              : 22;
			uint32 usp2AltRateReasonFastProbing : 1;
			uint32                              : 9;
		};
		struct
		{
			uint32                              : 23;
			uint32 usp2AltRateReasonSlowProbing : 1;
			uint32                              : 8;
		};
		struct
		{
			uint32             : 24;
			uint32 reserved222 : 8;
		};
	};
	union //word23
	{
		uint32 word23;
		struct
		{
			uint32 usp3Tcr3Rate20Mhz : 6;
			uint32                   : 26;
		};
		struct
		{
			uint32             : 6;
			uint32 reserved230 : 2;
			uint32             : 24;
		};
		struct
		{
			uint32                   : 8;
			uint32 usp3Tcr3Rate40Mhz : 6;
			uint32                   : 18;
		};
		struct
		{
			uint32             : 14;
			uint32 reserved231 : 2;
			uint32             : 16;
		};
		struct
		{
			uint32                   : 16;
			uint32 usp3Tcr3Rate80Mhz : 6;
			uint32                   : 10;
		};
		struct
		{
			uint32                              : 22;
			uint32 usp3AltRateReasonFastProbing : 1;
			uint32                              : 9;
		};
		struct
		{
			uint32                              : 23;
			uint32 usp3AltRateReasonSlowProbing : 1;
			uint32                              : 8;
		};
		struct
		{
			uint32             : 24;
			uint32 reserved232 : 8;
		};
	};
	union //word24
	{
		uint32 word24;
		struct
		{
			uint32 usp0WpTcr3Rate20Mhz : 6;
			uint32                     : 26;
		};
		struct
		{
			uint32             : 6;
			uint32 reserved240 : 2;
			uint32             : 24;
		};
		struct
		{
			uint32                     : 8;
			uint32 usp0WpTcr3Rate40Mhz : 6;
			uint32                     : 18;
		};
		struct
		{
			uint32             : 14;
			uint32 reserved241 : 2;
			uint32             : 16;
		};
		struct
		{
			uint32                     : 16;
			uint32 usp0WpTcr3Rate80Mhz : 6;
			uint32                     : 10;
		};
		struct
		{
			uint32             : 22;
			uint32 reserved242 : 10;
		};
	};
	union //word25
	{
		uint32 word25;
		struct
		{
			uint32 usp1WpTcr3Rate20Mhz : 6;
			uint32                     : 26;
		};
		struct
		{
			uint32             : 6;
			uint32 reserved250 : 2;
			uint32             : 24;
		};
		struct
		{
			uint32                     : 8;
			uint32 usp1WpTcr3Rate40Mhz : 6;
			uint32                     : 18;
		};
		struct
		{
			uint32             : 14;
			uint32 reserved251 : 2;
			uint32             : 16;
		};
		struct
		{
			uint32                     : 16;
			uint32 usp1WpTcr3Rate80Mhz : 6;
			uint32                     : 10;
		};
		struct
		{
			uint32             : 22;
			uint32 reserved252 : 10;
		};
	};
	union //word26
	{
		uint32 word26;
		struct
		{
			uint32 usp2WpTcr3Rate20Mhz : 6;
			uint32                     : 26;
		};
		struct
		{
			uint32             : 6;
			uint32 reserved260 : 2;
			uint32             : 24;
		};
		struct
		{
			uint32                     : 8;
			uint32 usp2WpTcr3Rate40Mhz : 6;
			uint32                     : 18;
		};
		struct
		{
			uint32             : 14;
			uint32 reserved261 : 2;
			uint32             : 16;
		};
		struct
		{
			uint32                     : 16;
			uint32 usp2WpTcr3Rate80Mhz : 6;
			uint32                     : 10;
		};
		struct
		{
			uint32             : 22;
			uint32 reserved262 : 10;
		};
	};
	union //word27
	{
		uint32 word27;
		struct
		{
			uint32 usp3WpTcr3Rate20Mhz : 6;
			uint32                     : 26;
		};
		struct
		{
			uint32             : 6;
			uint32 reserved270 : 2;
			uint32             : 24;
		};
		struct
		{
			uint32                     : 8;
			uint32 usp3WpTcr3Rate40Mhz : 6;
			uint32                     : 18;
		};
		struct
		{
			uint32             : 14;
			uint32 reserved271 : 2;
			uint32             : 16;
		};
		struct
		{
			uint32                     : 16;
			uint32 usp3WpTcr3Rate80Mhz : 6;
			uint32                     : 10;
		};
		struct
		{
			uint32             : 22;
			uint32 reserved272 : 10;
		};
	};
}GroupDbRateAdaptationParams_t; 

typedef struct ProtectedDbModFuncFastProbingParams
{
	StaId stationIndex;
	RaFastProbingPoint_e newFastProbingPoint;
 }ProtectedDbModFuncFastProbingParams_t;
typedef struct ProtectedDbModFuncRefLenParams
{
	uint8 refLenSuccess;
	uint8 refLenFail;
}ProtectedDbModFuncRefLenParams_t;

typedef struct ProtectedDbModFuncPowerParams
{
	bool changeProbingPoint;
	int8* pTcrDataPowerValTable;
	uint8 lastBwToUpdate;
	Bandwidth_e bandwidth;
	LaPacketType_e packetType;
	
}ProtectedDbModFuncPowerParams_t;
typedef struct ProtectedDbModFuncCpParams
{
	bool changeProbingPoint;
	uint8* pTcrDataCpValTable;
	uint8* pWpRateIndexTable;
	uint8 lastBwToUpdate;
	Bandwidth_e bandwidth;

}ProtectedDbModFuncCpParams_t;
typedef struct ProtectedDbModFuncAntSelectionParams
{
	bool changeProbingPoint;
	uint8 tcrAntennaSelctionMask;
	LaPacketType_e packetType;
	
}ProtectedDbModFuncAntSelectionParams_t;
typedef struct ProtectedDbModFuncCddParams
{
	CddValues_t cddVals;
	
}ProtectedDbModFuncCddParams_t;
typedef struct ProtectedDbDw3
{
	uint32 bfRxHwFwMode:1;                                    /*  */
	uint32 bfRxMode:3;                                        /*  */
	uint32 bfMinimalGrouping:2;                               /*  */
	uint32 maxNssNdp:2;                                       /*  */
	uint32 maxNssTx:2;                                        /*  */
	uint32 bfMfbUpdating:1;                                   /*  */
	uint32 bfAgingRegisterIndex:2;                            /*  */
	uint32 nonStandardImplicitBfRulesTableIndex:2;            /*  */
	uint32 bfImplicitFiller:1;								  /*  */
	uint32 bfDbValid:1;                                       /* Init by FW, updating by HW */
	uint32 bfAgingStatus:1;                                   /* Init by FW, updating by HW */
	uint32 bfHwReserved:6;                                    /* Init by FW, updating by HW */
	uint32 mcsFeedback:7;                                     /* Init by FW, updating by HW */
	uint32 mfbValid:1;                                        /* Init by FW, updating by HW */
}ProtectedDbDw3_t;
typedef struct ProtectedDbModFuncBfParams
{
	StaId staIndex;
	
}ProtectedDbModFuncBfParams_t;


extern uint8 laVhtMsduInAmsdu;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void setVapFixedRateInTcrsModificationFunc(uint32* scratchPadAddress, void* functionParams);
void updateTcrCommonTemplate1Rate(uint32 validRateSet);


#endif //LINK_ADAPTATION_PHY_DRIVER_H_
