/***********************************************************************************
 File:		LinkadaptationDriver.h
 Module:		LinkAdaptation 
 Purpose: 	
 Description:	
 				
************************************************************************************/
#ifndef LINK_ADAPTATION_PHY_DRIVER_H_
#define LINK_ADAPTATION_PHY_DRIVER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
//#include "RateAdaptation.h"
#include "SharedDbTypes.h"
#include "StaDb.h"
#include "VapDb.h"
#include "CDD.h"

#ifdef PHY_STUCK_LDPC_IS_SET_SYMBOLS_ABOVE_400
#include "LaStaProtectedZone_Descriptors.h"
#endif

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#ifdef PHY_STUCK_LDPC_IS_SET_SYMBOLS_ABOVE_400 // workaround for issue (https://jira-chd.intel.com/browse/WLANVLSIIP-3003)
#define PROTECTED_STA_DB_SIZE_WORDS 25
#else
#define PROTECTED_STA_DB_SIZE_WORDS 21
#endif
#define PROTECTED_VAP_DB_SIZE_WORDS 15
#define PROTECTED_GROUP_DB_SIZE_WORDS 19

typedef struct ProtectedDbModFuncPowerParams
{
	bool changeProbingPoint;
	int8* pTcrDataPowerValTable;
	uint8 lastBwToUpdate;
	Bandwidth_e bandwidth;
	LaPacketType_e packetType;
}ProtectedDbModFuncPowerParams_t;

typedef struct ProtectedDbModFuncAntSelectionParams
{
	bool changeProbingPoint;
	uint8 tcrAntennaSelctionMask;
	LaPacketType_e packetType;
	
}ProtectedDbModFuncAntSelectionParams_t;

extern uint8 laVhtMsduInAmsdu;
extern HeCp_e cpModeToHeCpTcrVal[CP_NUM_OF_MODES]; 
extern HeLtf_e cpModeToHeLtfTcrVal[CP_NUM_OF_MODES]; 

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void getHighestNssInMask(StaId staIndex, uint8* highestNss, Bandwidth_e bw);
void getHighestMcsForNssInMask(StaId staIndex, uint8 nss, uint8* highestMcs, PhyMode_e phyMode,Bandwidth_e bw);
void getHighestMcsInMask(StaId staIndex,uint8* highestMcs, PhyMode_e phyMode, Bandwidth_e bw);
Scp_e convertCpModeToHtVhtCpTcrVal(CyclicPrefixMode_e cpMode);
CyclicPrefixMode_e convertHeCpLtfTcrValToCpMode(HeCp_e heCp, HeLtf_e heLtf);

#ifdef PHY_STUCK_LDPC_IS_SET_SYMBOLS_ABOVE_400
void overwriteMaxPsduLengthLimitInStaDb(LaStaProtectedZone_t *pLaProtectedStruct, LaTcrModificationStruct_t *pTcrModificationParams, uint8 tcrPhyMode, uint8 tcrRate);
bool isPsduLengthLimitationNeeded(uint8 tcrRate, uint32 *newMaxPsduLength);
#endif
void updateTcrCommonTemplate1Rate(uint32 validRateSet);

#endif //LINK_ADAPTATION_PHY_DRIVER_H_
