/***********************************************************************************
 File:		ProductDefs.h
 Module:		LinkAdaptation 
 Purpose: 	
 Description:	
 				
************************************************************************************/
#ifndef PRODUCT_DEFS_H_
#define PRODUCT_DEFS_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "SharedDbTypes.h"
#include "linkAdaptation_api.h"

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define POWER_STEP_UP 2 /*1 dB */
#define POWER_STEP_DOWN 2 /*1 dB */
#define POWER_ADDITIONAL_PROBING_STEP 2 /*1 DB*/
#define POWER_MAX_ADDITIONAL_PROBING_STEP 32 /*16 dB*/

#define	SEQUENCER_REPORT_NOT_AVAILABLE_PRE_BAA_REPORTS
#define BW_ADAPTATION_ACTIVE

#define LA_RSSI_TO_DBM 65

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------



#define AVERAGE_TSF_512USEC_UNIT_LOG2 2 //average diff time 2^4 = 16*512usec = 8 msec (according to probing packet average time diff for probing packets)
#define IMLICIT_MAX_NUMBER_OF_NSS 4
#define TPC_LOW_LIMIT (-12 )

#define SLOW_PROBING_ENABLED_BITMAP  ((1<<SLOW_PROBING_POWER) | \
										(1<<SLOW_PROBING_BW) | \
										(1<<SLOW_PROBING_CP) | \
										(1<<SLOW_PROBING_BF) | \
										(1<<SLOW_PROBING_ANT_SEL) | \
										(1<<SLOW_PROBING_TURBO_RATES))


/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------

#endif //PRODUCT_DEFS_H_


