/***********************************************************************************
 File:		LinkAdaptationDriver.h
 Module:		LinkAdaptation 
 Purpose: 	
 Description:	
 				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "ProtectedDbLock_Api.h"
#include "ShramStationDatabase.h"
#include "LinkAdaptation.h"
#include "StaDatabase_Api.h"
#include "LinkAdaptationPhyDriver.h"
#include "VapDb.h"
#include "ShramVapDatabase.h"
#include "lm_VapDatabase.h"
#include "lm_StaDatabase.h"
#include "VapDatabase_Api.h"
#include "PowerAdaptation.h"
#include "mt_sysdefs.h"
#include "CyclicPrefix.h"
#include "TxSelector_Api.h"
#include "stringLibApi.h"
#include "ShramNewDeliaRecipes.h"
#include "ShramStatistics.h"
#include "HwSemaphore_API.h"
#include "RateAdaptation.h"
#include "Estimators.h"
#include "Beamforming.h"
#include "GroupDb.h"
#include "frame.h"
#include "AntennaSelection.h"
#include "ShramGroupDatabase.h"
#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND
#include "fast_mem_psd2mips.h"
#include "DurRam.h"
#endif //DYNAMIC_RTS_ISSUE_WORKAROUND
#include "TxSequencer_Api.h"
#include "AggregationBuilder_Api.h"
#include "CommonRamLinkAdaptation.h"
#include "TurboRates.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
/***************************************************************************/
/* 					Constants                                                  				     */
/***************************************************************************/
#define LOG_LOCAL_GID   GLOBAL_GID_LINK_ADAPTATION
#define LOG_LOCAL_FID 10

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
#define HW_RX_IMLICIT_BF_MODE 0x100
#define TX_SELECTOR_ACTION_SEND_BF_WITHOUT_DATA 0
#define TX_SELECTOR_ACTION_SEND_BF_WITH_DATA 	1
#define TX_SELECTOR_ACTION_SEND_BF_REQUEST 		1
#define TX_SELECTOR_ACTION_STOP_BF_REQUEST 		0

//Sequencer report definitions 
#define USER_POS_0_MASK 0x1 

#define WP_SCP_BIT_OFFSET			4
#define WORD19_SCP_BYTE_OFFSET		3
#define TWO_BYTE_OFFSET				2
#define FAST_PROBING_BIT_INDEX		6
#define SLOW_PROBING_BIT_INDEX		7


#define RF_POWER_MASK			0x000003F0 // 6 bits starting at bit4(lower) , tcr020MhzRfPower
#define ANTENNA_SELECTION_MASK	0x000FF000 // 8 bits starting at bit12(lower) , tcr020MhzRfPower
#define SCP_MASK				0x01 
#define	BF_MODE_MASK			0x00000C00// two bits,tcr020MhzBfMode

#define LDPC_MASK				0x80000000 // one bit starting at bit 20 ,

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void setRefLenModificationFunc(uint32* scratchPadAddress, void* functionParams);
static void setStaFixedRateInTcrsModificationFunc(uint32* scratchPadAddress, void* functionParams);
static void setVapFixedBwLimit(Bandwidth_e bandwidth, VapDb_t* pVapDbHwEntries);
static void setStaFixedBwLimit(StaId staIndex);
static void setPowerInVapDbModificationFunc(uint32* scratchPadAddress, void* functionParams);
static void setAntennaSelectionInVapDbModificationFunc(uint32* scratchPadAddress, void* functionParams);
static void setCddnVapDbModificationFunc(uint32* scratchPadAddress, void* functionParams);
static void setTcrsInHwStaDb(uint32* scratchPadAddress, void* functionParams);
static void setTcrsInHwGroupDb(uint32* scratchPadAddress, void* functionParams);
static void getSuTcrParamsFromHwDb(LaTcrModificationStruct_t* tcrModificationParams);
static	void getVhtMuTcrParamsFromHwDb(LaTcrModificationStruct_t* tcrModificationParams);
static	void setGroupDataBwLimit(uint8 groupIndex,Bandwidth_e bandwidth, bool changeWorkingPoint);
static Scp_e convertCpModeToHtVhtCpTcrVal(CyclicPrefixMode_e cpMode);

uint8 laHtMsduInAmsdu = 7;
uint8 laVhtMsduInAmsdu = 5;
uint8 StaDb_SuNumOfMpdusInAmpdu = SU_NUM_OF_MPDUS_IN_A_MPDU;

uint8 laPpduTxMode = STA_DB_PPDU_TX_MODE_LEGACY_ONLY;


static LinkAdaptationRtsMode_t 	LinkAdaptationRtsMode;
#ifdef TRAINING_FIRST_PHASE_POOL
uint8 numberOfStationInBw[HW_NUM_OF_VAPS][MAX_POSSIBLE_NUM_OF_BW] = {{0}}; 
#endif //TRAINING_FIRST_PHASE_POOL

#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND
extern PacDurRam_t *PacDurRam;
#endif //DYNAMIC_RTS_ISSUE_WORKAROUND

uint32 MuScratchPad[PROTECTED_GROUP_DB_SIZE_WORDS];

Scp_e cpModeToHtVhtCpTcrVal[CP_NUM_OF_MODES_HT_VHT] = 
{
	SCP_SHORT_CP,
	SCP_LONG_CP,
};

CyclicPrefixMode_e htVhtCpTcrValToCpMode[SCP_LAST] = 
{
	CP_MODE_MED_CP_SHORT_LTF,
	CP_MODE_SHORT_CP_SHORT_LTF
};

/*---------------------------------------------------------------------------------
/						Functions definitions					
/----------------------------------------------------------------------------------*/


/**********************************************************************************

decreaseStaBwLimit 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void decreaseStaBwLimit(StaId staIndex)
{
	LinkAdaptationStaDatabase_t* pLaDatabase = &LinkAdaptationStaDatabase[staIndex];
	Bandwidth_e changedBw = GetDataBwLimit(staIndex,INVALID_MU_USP_INDEX, FALSE);

	if (changedBw != BANDWIDTH_TWENTY)
	{
		LinkAdaptationSetStaDataBwLimit(staIndex,(Bandwidth_e)((uint8)changedBw-1),TRUE);
		pLaDatabase->laStaGroupCommon.bwAdaptationDb.isBwDroppedDueToRA = TRUE;
	}

}

/**********************************************************************************

initStaBwLimit 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void initStaBwLimit(StaId staIndex,uint8 rateIndex, LaOperationModeNotificationChannelWidth_e omnChannelWidth, Bandwidth_e maxBW)
{
	LinkAdaptationStaDatabase_t* pLaDatabase = &LinkAdaptationStaDatabase[staIndex];
	Bandwidth_e wlanBandwidthMax = maxBW;
	Bandwidth_e changedBwLimit;
	Bandwidth_e tempBw = BANDWIDTH_TWENTY;
	const RateObj_t* ratesTable = getRatesTable(&pLaDatabase->laStaUspCommon);
	
	if (ratesTable[rateIndex].laPhyMode != LA_PHY_MODE_HT_VHT)
	{
		/*If rate is non HT /VHT rate set BW to 20*/
		changedBwLimit = BANDWIDTH_TWENTY;
		pLaDatabase->laStaGroupCommon.bwAdaptationDb.maxSupportedBw = BANDWIDTH_TWENTY;
 		pLaDatabase->laStaGroupCommon.bwAdaptationDb.isBwDroppedDueToRA = FALSE; 
	}
	else if(pLaDatabase->laStaUspCommon.staTransmissionParams.vhtSta)
	{		
		/* Operating Mode Notification BW limitation */
		tempBw = (omnChannelWidth != OMN_BW_INVALID) ? (Bandwidth_e)omnChannelWidth : BANDWIDTH_EIGHTY;
		//("[OMN][initStaBwLimit] wlanBandwidthMax = %d tempBw = %d", wlanBandwidthMax, tempBw);
		pLaDatabase->laStaGroupCommon.bwAdaptationDb.maxSupportedBw = MIN(wlanBandwidthMax, tempBw);
		changedBwLimit = pLaDatabase->laStaGroupCommon.bwAdaptationDb.maxSupportedBw;  // To be discussed - what should be the initial limit?
	}
	else 
	{
		/*Set bw limit accordint to sta - HT */
		pLaDatabase->laStaGroupCommon.bwAdaptationDb.maxSupportedBw = MIN(wlanBandwidthMax, pLaDatabase->laStaGroupCommon.bwAdaptationDb.staSupportedBw);
  		changedBwLimit = pLaDatabase->laStaGroupCommon.bwAdaptationDb.maxSupportedBw;  // To be discussed - what should be the initial limit?
	}

	LinkAdaptationSetStaDataBwLimit(staIndex,changedBwLimit,TRUE);
	SetStaManagementBwLimit(staIndex,BANDWIDTH_TWENTY);
}
/**********************************************************************************

setRateinTcr 


Description:
------------
Write HW DB using protected DB API

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void setAllBwsTcrsParams(LaTcrModificationStruct_t* pTcrParams )
{
	uint32 protectedDBscratchPad[MAX(PROTECTED_STA_DB_SIZE_WORDS,PROTECTED_GROUP_DB_SIZE_WORDS)];

	if(pTcrParams->controlParams.uspIndex == INVALID_MU_USP_INDEX)
	{
		/*Update new working point in STA DB using protected DB*/
		ProtectedDbLock_ReadModifyWriteReq((uint32*)&(StaDbHwEntries[pTcrParams->controlParams.staIndex].common.word4/*tcr020MhzData*/), (PROTECTED_STA_DB_SIZE_WORDS), protectedDBscratchPad, setTcrsInHwStaDb,(void*)pTcrParams); 
	}
	else if (pTcrParams->controlParams.fastProbing == TRUE)
	{
		/*Update Global Scratchpad*/
		setTcrsInHwGroupDb(MuScratchPad,(void *)pTcrParams);
	}
	else
	{
		/*Update new working point in STA DB using protected DB*/
		ProtectedDbLock_ReadModifyWriteReq((uint32*)&(GroupDbHwEntries[pTcrParams->controlParams.staIndex].word19), (PROTECTED_GROUP_DB_SIZE_WORDS), protectedDBscratchPad, setTcrsInHwGroupDb,(void*)pTcrParams); 
	}

	
}

/**********************************************************************************

updateTransTimeLimit 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void updateTransTimeLimit(StaId staIndex)
{
	LaFixedRateStationParams_t *laFixedRateStationParams_p = &LinkAdaptationStaDatabase[staIndex].laStationUnique.fixedRateStationParams;
	uint8 rateIndex = convertTcr2RateIndex(laFixedRateStationParams_p->phyMode, laFixedRateStationParams_p->rate);
	uint16 transmissionTime;
	uint16 newPhyRate;
	const RateObj_t* ratesTable = getRatesTable(&LinkAdaptationStaDatabase[staIndex].laStaUspCommon);

	if (AggRateLimitMode == TRUE)
	{

		newPhyRate = ratesTable[rateIndex].rateTableBwParmas[GetDataBwLimit(staIndex,INVALID_MU_USP_INDEX, FALSE)].shortCpPhyRate;

		updateTransmissionTimeParams(staIndex, rateIndex);

		/* Set time limit */
		if (LinkAdaptationStaDatabase[staIndex].laStaUspCommon.staTransmissionParams.clientIsolationMode == FALSE)
		{
			transmissionTime = MAX_TRANSMISSION_TIME;
		}
		else
		{
			transmissionTime = (newPhyRate < LA_TIME_LIMIT_RATE_TH) ? MED_TRANSMISSION_TIME : MIN_TRANSMISSION_TIME;			
		}

		linkAdaptationSetTransmissionTimeLimit(staIndex, transmissionTime);

	}
}

/**********************************************************************************

setStaFixedRatesInHwDb 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void setStaFixedRatesInHwDb(StaId staIndex)
{
	
	uint32 protectedDBscratchPad[PROTECTED_STA_DB_SIZE_WORDS];
	StaDb_t* pStaDbHwEntries = &StaDbHwEntries[staIndex];
	LaFixedRateStationProtectedDbParams_t	protectedDbParams;
	LaStationUspCommonParams_t* pLaStaUspCommon = &LinkAdaptationStaDatabase[staIndex].laStaUspCommon;
	//Bandwidth_e bw = GetDataBwLimit(staIndex,INVALID_MU_USP_INDEX);
	uint8 workingPointEstimatorsIndex;
	uint8 oldRate, rateIndex;
	bool isRateInc = FALSE;
#ifdef LINK_ADAPTATION_LOGS
		//("setStaFixedRatesInHwDb");
#endif
	memcpy (&protectedDbParams.fixedRateStationParams, &LinkAdaptationStaDatabase[staIndex].laStationUnique.fixedRateStationParams, sizeof(LaFixedRateStationParams_t));
	protectedDbParams.staIndex = staIndex;

	workingPointEstimatorsIndex = pLaStaUspCommon->fastProbingPointEstimatorsIndexes[WORKING_POINT];
	oldRate = pLaStaUspCommon->fastProbingEstimators[workingPointEstimatorsIndex].rateIndex;	
	rateIndex = convertTcr2RateIndex(protectedDbParams.fixedRateStationParams.phyMode, protectedDbParams.fixedRateStationParams.rate);
	isRateInc = rateAdaptation_RateIsIncreased(rateIndex, oldRate, getRatesTable(pLaStaUspCommon));
	/*If Change from non 11B to 11B, first set BW and after it set rate*/
	if (protectedDbParams.fixedRateStationParams.phyMode != PHY_MODE_11B)
	{
		/*Set bandwidth*/
		setStaFixedBwLimit(staIndex);
		//ILOG0_DDD("setStaFixedRatesInHwDb 1 isRateInc = %d newRateindex= %d oldRate= %d ",isRateInc,rateIndex, oldRate);

		if (isRateInc == TRUE)
		{
			/*Set rate*/
			ProtectedDbLock_ReadModifyWriteReq((uint32*)&(pStaDbHwEntries->common.word4/*tcr020MhzData*/), (PROTECTED_STA_DB_SIZE_WORDS), protectedDBscratchPad, setStaFixedRateInTcrsModificationFunc,(void*)(&protectedDbParams)); 
			updateTransTimeLimit(staIndex);
		}
		else
		{			
			updateTransTimeLimit(staIndex);
			ProtectedDbLock_ReadModifyWriteReq((uint32*)&(pStaDbHwEntries->common.word4/*tcr020MhzData*/), (PROTECTED_STA_DB_SIZE_WORDS), protectedDBscratchPad, setStaFixedRateInTcrsModificationFunc,(void*)(&protectedDbParams)); 
		}
	}
	else
	{
		//ILOG0_DDD("setStaFixedRatesInHwDb 2 isRateInc = %d newRateindex= %d oldRate= %d ",isRateInc,rateIndex, oldRate);
		if (isRateInc == TRUE)
		{
			/*Set rate*/
			ProtectedDbLock_ReadModifyWriteReq((uint32*)&(pStaDbHwEntries->common.word4/*tcr020MhzData*/), (PROTECTED_STA_DB_SIZE_WORDS), protectedDBscratchPad, setStaFixedRateInTcrsModificationFunc,(void*)(&protectedDbParams)); 
			updateTransTimeLimit(staIndex);
		}
		else
		{			
			updateTransTimeLimit(staIndex);
			ProtectedDbLock_ReadModifyWriteReq((uint32*)&(pStaDbHwEntries->common.word4/*tcr020MhzData*/), (PROTECTED_STA_DB_SIZE_WORDS), protectedDBscratchPad, setStaFixedRateInTcrsModificationFunc,(void*)(&protectedDbParams)); 
		}
		/*Set bandwidth*/
		setStaFixedBwLimit(staIndex);
	}
	
}
/**********************************************************************************

setNewRateInStationDb 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void setStaFixedRateInTcrsModificationFunc(uint32* scratchPadAddress, void* functionParams)
{
	LaFixedRateStationProtectedDbParams_t* pFixedRateParams = (LaFixedRateStationProtectedDbParams_t*) functionParams;
	uint8 tcrWordOffset;
	Tcr0_t *pTcr0Data;
	Tcr3_t *pTcr3Data; 
	Tcr0_t *pTcr0Management;
	Tcr3_t *pTcr3Management; 
	Tcr1_t *pTcr1Data;
	StaDbRateAdaptationParams_t* raStruct = (StaDbRateAdaptationParams_t*) scratchPadAddress;
	uint32* dataTcr0SectionAddress = (uint32*)&(raStruct->tcr020MhzData);
	uint32* managemntTcr0SectionAddress = (uint32*)&(raStruct->tcr020MhzManagement);
	uint8 powerTcrDataVal;
	uint8 powerTcrManagemnentVal;
	uint8 rateIndex = convertTcr2RateIndex(pFixedRateParams->fixedRateStationParams.phyMode, pFixedRateParams->fixedRateStationParams.rate);
	uint8 updatedRateIndex = rateIndex;
	Bandwidth_e bandwidth;
	PhyMode_e phyModePerBw = pFixedRateParams->fixedRateStationParams.phyMode;
	uint8 ratePerBw = pFixedRateParams->fixedRateStationParams.rate;	
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 
	uint8 workingPointState;
	uint8 tcrBfMode = FALSE;
	RateMask_t allowdRatesMask;
	bool isVht = FALSE;
	const RateObj_t* ratesTable;
	Scp_e tcrCp = convertCpModeToHtVhtCpTcrVal(pFixedRateParams->fixedRateStationParams.cpMode);
	
	updateLaDbDistributionParam(&laDbDistributionParameter,pFixedRateParams->staIndex,INVALID_MU_USP_INDEX, FALSE);
	ratesTable = getRatesTableFixRateConfig(&(pFixedRateParams->fixedRateStationParams));
		
	for (bandwidth = BANDWIDTH_TWENTY; bandwidth < LA_NUM_OF_BANDWIDTH; bandwidth++)
	{
		tcrWordOffset = (bandwidth << 1);

		if (bandwidth < pFixedRateParams->fixedRateStationParams.bandwidth)
		{
			/*Clear allowdRatesMask before or operation*/
			memset(&allowdRatesMask, 0, sizeof(RateMask_t));
			/*Set AllowedRatesMask in local variable*/
			orOperator64Bit(allowdRatesMask.raIndexMask64bit, (uint32*)AllowedRatesMask[bandwidth].raIndexMask64bit, allowdRatesMask.raIndexMask64bit);
			/*Set turbo rates in local raMask*/
			if( (laDbDistributionParameter.laStaUspCommon != NULL)&& (FALSE == laDbDistributionParameter.laStaUspCommon->staTransmissionParams.heSta))
			{

				/*Turbo rates is not relevant for he stations or VAP*/
				TurboRatesGetBitmap(pFixedRateParams->staIndex, INVALID_MU_USP_INDEX, bandwidth, &allowdRatesMask);
			}
			SLOG0(0, 0, RateMask_t, &allowdRatesMask);
			
			/*If rate is not in BW mask decrease to rate -1*/
			if (((ratesTable[rateIndex].vhtHeMcs) != 0)&&
				(rateIndex !=0) && 
				(isBitInMask64Bit(rateIndex, (uint32*)allowdRatesMask.raIndexMask64bit)==0))
			{
				updatedRateIndex = rateIndex-1;
			}
		}
		else
		{
			updatedRateIndex = rateIndex;
		}

		if (pFixedRateParams->fixedRateStationParams.phyMode == PHY_MODE_11AC)
		{
			isVht = TRUE;
		}
		getTcrPhyModeAndRate(ratesTable, isVht, updatedRateIndex, &phyModePerBw, &ratePerBw, FALSE, NO_DCM);
		if((pFixedRateParams->fixedRateStationParams.changeType == LA_PACKET_TYPE_DATA_MANAGEMENT) || (pFixedRateParams->fixedRateStationParams.changeType == LA_PACKET_TYPE_DATA))
		{
			workingPointState = LinkAdaptationStaDatabase[pFixedRateParams->staIndex].laStationUnique.beamFormingDb.bfWorkingPointState;
			if((workingPointState == BF_STATE_EXPLICIT)|| (workingPointState == BF_STATE_IMPLICIT))
			{
				tcrBfMode = TRUE;
			}
			powerTcrDataVal = CalcLimitsAndGetStaTcrPowerVal(pFixedRateParams->staIndex, pFixedRateParams->fixedRateStationParams.bandwidth,rateIndex, FALSE, LA_PACKET_TYPE_DATA,AntennaSelectionGetAntennaSelectionBitmap(pFixedRateParams->staIndex), FALSE,tcrBfMode);

			/*Change transmitting fields in STA DB in both cases - probing and woring point modification*/
			/*Change main TCR*/
			pTcr0Data = (Tcr0_t *)&dataTcr0SectionAddress[tcrWordOffset];
			pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[tcrWordOffset + 1];

			pTcr0Data->phyMode = phyModePerBw;
			pTcr3Data->rate = ratePerBw;
			pTcr0Data->rfPower = powerTcrDataVal;
			pTcr3Data->scp = tcrCp;

			/*Change working point fields in STA DB*/
			pTcr3Data->wpScp = tcrCp;
			pTcr0Data->wpPhyMode = phyModePerBw;
			pTcr3Data->wpRate  = ratePerBw;
			pTcr0Data->wpRfPower = powerTcrDataVal;
			/* LDPC Adjustments - don't use LDPC in 11A/G/B */
			pTcr1Data = &raStruct->tcr1Data;
			pTcr1Data->ldpc = getLdpcCapability(pFixedRateParams->staIndex,ratesTable[updatedRateIndex].laPhyMode);
			
			/*Set fixed rate in estimators DB*/
			estimatorsUpdateRatesInDb(&laDbDistributionParameter, updatedRateIndex, updatedRateIndex);

		}
		if((pFixedRateParams->fixedRateStationParams.changeType == LA_PACKET_TYPE_DATA_MANAGEMENT) || (pFixedRateParams->fixedRateStationParams.changeType == LA_PACKET_TYPE_MANAGEMENT))
		{
			tcrBfMode = FALSE;
			powerTcrManagemnentVal = CalcLimitsAndGetStaTcrPowerVal(pFixedRateParams->staIndex, pFixedRateParams->fixedRateStationParams.bandwidth,rateIndex, FALSE, LA_PACKET_TYPE_MANAGEMENT,AntennaSelectionGetAntennaSelectionBitmap(pFixedRateParams->staIndex),FALSE,tcrBfMode);

			/*Change transmitting fields in STA DB in both cases - probing and woring point modifcation*/
			/*Change main TCR*/
			pTcr0Management = (Tcr0_t *)&managemntTcr0SectionAddress[tcrWordOffset];
			pTcr3Management = (Tcr3_t *)&managemntTcr0SectionAddress[tcrWordOffset + 1];
			pTcr0Management->phyMode = phyModePerBw;
			pTcr3Management->rate = ratePerBw;
			pTcr0Management->rfPower = powerTcrManagemnentVal;
			pTcr3Management->scp = tcrCp;
		}
	}
}
/**********************************************************************************

setRefLenModificationFunc 


Description:
------------
Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void setRefLenModificationFunc(uint32* scratchPadAddress, void* functionParams)
{
	ProtectedDbModFuncRefLenParams_t* pCastingParams = (ProtectedDbModFuncRefLenParams_t*) functionParams;
	Tcr1_t* tcr1Data = (Tcr1_t*)(&scratchPadAddress[0]);
	Tcr2_t* tcr2Data = (Tcr2_t*)(&scratchPadAddress[1]);

	tcr1Data->baaWeightedSuccessMduRef = pCastingParams->refLenSuccess;
	tcr2Data->baaWeightedFailMduRef = pCastingParams->refLenFail;
}
/**********************************************************************************

setRefLenInStaDb 


Description:
------------
Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void setRefLenInStaDb(StaId staIndex, uint8 refLenSuccess, uint8 refLenFail)
{
	ProtectedDbModFuncRefLenParams_t protectedDbfuncParams;
	uint32 protectedDBscratchPad[REF_LEN_MODIFY_NUMBER_OF_WORDS_IN_STA_DB];

	protectedDbfuncParams.refLenSuccess = refLenSuccess;
	protectedDbfuncParams.refLenFail= refLenFail;
	
	ProtectedDbLock_ReadModifyWriteReq((uint32*)&(StaDbHwEntries[staIndex].common.word10/*tcr1Data*/), 
										(REF_LEN_MODIFY_NUMBER_OF_WORDS_IN_STA_DB), protectedDBscratchPad, setRefLenModificationFunc, &protectedDbfuncParams);
	
}

/********************************************************************************
fillVapHwDb




Description:
----------

Input:
-----

Output:
-------

Returns:
--------

********************************************************************************/

void fillVapHwDb (uint8 vapIndex, uint8 fixedMcsVapManagement)
{
	VapDb_t* pVapDbHwEntry = &VapDbHwEntries[vapIndex];
	Tcr0_t* 	  	pTcr0Data = NULL;
	Tcr0_t* 	pTcr0Management =  NULL;
	Tcr1_t*           	pTcr1 = NULL;
	Tcr3_t*     	  	pTcr3Data = NULL;
	Tcr3_t*     	  	pTcr3Management = NULL;
	Tcr0_t *pTcr0Template;
	Tcr3_t *pTcr3Template;
	uint32	*VapDbRfPowerTemplateTcr = (uint32 *)&(pVapDbHwEntry->tcrTemplates.word16/*rfPower20MhzTemplates*/);	
	uint32* pVapBwDataTcr0 = (uint32 *)&(pVapDbHwEntry->common.word4/*tcr020MhzData*/);
	uint32* pVapBwManagementTcr0 = (uint32 *)&(pVapDbHwEntry->common.word13/*tcr020Mhz80211*/);
	VapDbRfPowerTemplate_t *pRfPowerTemplate = NULL;
	Tcr2_t	*pTcr2 = NULL; 
	LmVapDbSwInfo_t* pLmVapDataBase = &LmVapDataBase[vapIndex];
	uint8 rateIndex;
	PhyMode_e phyMode;
	uint8 tcrRateVal;
	uint8 tidIndex;
	VapDbTid_t* pVapTidEntry = NULL;
	Bandwidth_e bandwidth;
	uint8 currentBwOffset;
	RateMask_t vapBasicRateMask;
	uint8 antBoost[4];

	TX_INTERRUPT_SAVE_AREA;
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	vapBasicRateMask.raIndexMask64bit[0] = pLmVapDataBase->basicRates;
	vapBasicRateMask.raIndexMask64bit[1] = 0;
	rateIndex = getLowestRateinMask(INVALID_STA_INDEX, vapBasicRateMask,BANDWIDTH_TWENTY,0,PHY_MODE_11G_HIGHEST_SORT_RATE_INDEX); /*Get lower rate from vap basic rates*/

	/*Init the Multicast Rate Index*/
	pLmVapDataBase->mcRateIndex = rateIndex;
	getTcrPhyModeAndRate(htVhtRatesTable, 0, rateIndex, &phyMode, &tcrRateVal, FALSE, NO_DCM); 

	/*DW0 */
	/* calculate ( 2 power (13 + maxMpduLengthLimit)) -1 */

	pVapDbHwEntry->common.maxMpduLengthLimit = getMpduMaxLengthLimit(FALSE); // Should be Initialized from the driver. Hard coded for release 0.5
	pVapDbHwEntry->common.bfReportResponseFormat = DISABLED; // SAS :set to 00: selection of no BF sequence // [15:14] 
	pVapDbHwEntry->common.qosEnableCapability = DISABLED;
	pVapDbHwEntry->common.negotiatedWds = DISABLED;		  // SAS :shopuld be set to 0					   [17]  
	pVapDbHwEntry->common.dataBwLimit = BANDWIDTH_TWENTY;	// Initiate by Link adaptation
	pVapDbHwEntry->common._80211BwLimit = BANDWIDTH_TWENTY; // Initiate by Link adaptation
	pVapDbHwEntry->common.dynamicBwEnable = DISABLED;		  // SAS :set to 00:No Dynamic BW transmission (legacy/static)	 [22]
	pVapDbHwEntry->common.staticBwEnable  = DISABLED;		  // SAS :set to 00:No Static BW transmission (legacy/static)		[23]
	pVapDbHwEntry->common.maxMsduAtAmsduCount = 1; 		  // SAS : set to 1:No A-MSDU							 [31:24]

	/*DW3 */
	//This value is used in case of Training - the Nss of the phy NDP (sounding) - this means how many rows will be in the beamforming result matrix and rate in which phy NDP will be sent (in the TCR)
	pVapDbHwEntry->common.maxNssNdp = CONVERT_MAX_NUM_OF_ANTENNAS_TO_MAX_NUM_OF_NSS(AntennaSelectionGetActivatedAntennasCount()); 

	for (bandwidth = BANDWIDTH_TWENTY; bandwidth < LA_NUM_OF_BANDWIDTH; bandwidth++)
	{
		currentBwOffset = (bandwidth << 1);

		pTcr0Data = (Tcr0_t*)&pVapBwDataTcr0[currentBwOffset];
		pTcr3Data = (Tcr3_t*)&pVapBwDataTcr0 [currentBwOffset +1];

		/* DW4 - TCR0[31:0] 20 MHZ Data */
	//	pTcr0Data = &(pVapDbHwEntry->tcr020MhzData);
		pTcr0Data->phyMode = phyMode; // transmission power  0x3F max power
		pTcr0Data->bw = bandwidth;
		pTcr0Data->rfPower = GetTcrDefaultPowerVal(0, rateIndex, bandwidth); // transmission power  0x3F max power
		pTcr0Data->bfMode = TX_BF_FLAT;		  // according to req 1266 for data should be set to 01 ( beamforming)	for management set to 00 Bypass
//		pTcr0Data->antennaSelection = ANT_SELECTION_ALL;   //  choose antena to transmit from
		pTcr0Data->wpRfPower =  GetTcrDefaultPowerVal(0, rateIndex, bandwidth);	
		pTcr0Data->wpPhyMode = 	phyMode;

		/* DW5 - TCR3[23:0] 20MHz Data */
	//	pTcr3 = &(pVapDbHwEntry->tcr320MhzData);
		pTcr3Data->aggregate = DISABLED;   // specified in SAS to be 0
		pTcr3Data->notSounding = ENABLED; // specified in SAS to be 0
		pTcr3Data->bfSmoothing = ENABLED; // specified in SAS to deafult value 0.
		pTcr3Data->dynamicBw = DISABLED; // specified in SAS to deafult value 0.
		pTcr3Data->rate = tcrRateVal;
		pTcr3Data->scp = DISABLED;
		pTcr3Data->wpRate = tcrRateVal;
		pTcr3Data->wpScp = DISABLED;
		
		pTcr0Management = (Tcr0_t*)&pVapBwManagementTcr0[currentBwOffset];
		pTcr3Management = (Tcr3_t*)&pVapBwManagementTcr0[currentBwOffset + 1];
		/* DW13 - TCR0[23:0] 20Mhz 802.11 */
	//	pTcr0Management = &(pVapDbHwEntry->tcr020MhzMgnt);
		pTcr0Management->phyMode = phyMode; // transmission power  0x3F max power
		pTcr0Management->bw = bandwidth;
		pTcr0Management->rfPower = GetTcrDefaultPowerVal(0, rateIndex, bandwidth); // transmission power  0x3F max power
		pTcr0Management->bfMode = TX_BF_FLAT;		  // according to req 1266 for data should be set to 01 ( beamforming)	for management set to 00 Bypass
//		pTcr0Management->antennaSelection = ANT_SELECTION_ALL;   //  choose antena to transmit from
		pTcr0Management->wpRfPower = GetTcrDefaultPowerVal(0, rateIndex, bandwidth);	
		pTcr0Management->wpPhyMode = 	phyMode;

		/* DW14 - TCR3[23:0] 20 Mhz 802.11 */
	//	pTcr3Management = &(pVapDbHwEntry->tcr320MhzMgnt);
		pTcr3Management->aggregate = DISABLED;   // specified in SAS to be 0
		pTcr3Management->notSounding = ENABLED; // specified in SAS to be 0
		pTcr3Management->bfSmoothing = ENABLED; // specified in SAS to deafult value 0.
		pTcr3Management->dynamicBw = DISABLED; // specified in SAS to deafult value 0.
		pTcr3Management->rate = tcrRateVal;
		pTcr3Management->scp = DISABLED;
		pTcr3Management->wpRate = tcrRateVal;
		pTcr3Management->wpScp = DISABLED;
	}
	/* DW10 - TCR1[23:0] Data */
	//pTcr1 = &(pVapDbHwEntry->common.word10); 
	pVapDbHwEntry->common.ldpcData = CONVOLUTIONAL_CODING; //  Should be Initialized from the driver. Hard coded for release 0.5
	pVapDbHwEntry->common.stbcData = NOT_STBC_TRANSMISSION; //  Should be Initialized from the driver. Hard coded for release 0.5
	pVapDbHwEntry->common.partialAidData = 0;
	pVapDbHwEntry->common.txopPsNotAllowedData = TRUE;//vapDbGetTxopPsAllowed(FALSE);  // assocParams->htCapabilityInfo.lSigTxop_protection_support;
	pVapDbHwEntry->common.groupIdData = DEFAULT_MIMO_GROUP_ID;// Set to 0 for non VHT
	pVapDbHwEntry->common.tcr1NdpTrainingModeData = 0; 
	pVapDbHwEntry->common.tcr1MuTrainingData = 0; 
	pVapDbHwEntry->common.tcr1MuPhyNdpData = 0; 
	pVapDbHwEntry->common.baaWeightedSuccessMduReference = MINIMUM_REF_LEN_VAL;

	/* DW11 - TCR2[23:0]  */
	// Is this taken from ASEL Capability field in Capabilities info IE 
	//pTcr2 = &pVapDbHwEntry->tcr2;
	pVapDbHwEntry->common.tcr2BwChange = DISABLED; 
	pVapDbHwEntry->common.tcr2Ant0Boost = 0; 
	pVapDbHwEntry->common.tcr2Ant1Boost = 0; 
	pVapDbHwEntry->common.tcr2Ant2Boost = 0; 
	pVapDbHwEntry->common.tcr2Ant3Boost = 0; 
	pVapDbHwEntry->common.baaWeightedFailMduReference = REF_LEN_FAIL_DEFAULT_VAL; 

	/* DW12 - TCR1[23:0] 802.11 */
	//pTcr1 = &pVapDbHwEntry->tcr180211;
	pVapDbHwEntry->common.ldpcData = CONVOLUTIONAL_CODING; //  Should be Initialized from the driver. Hard coded for release 0.5
	pVapDbHwEntry->common.stbcData = NOT_STBC_TRANSMISSION; //  Should be Initialized from the driver. Hard coded for release 0.5
	pVapDbHwEntry->common.partialAidData = 0;
	pVapDbHwEntry->common.txopPsNotAllowedData = TRUE;//vapDbGetTxopPsAllowed(FALSE);  // assocParams->htCapabilityInfo.lSigTxop_protection_support;
	pVapDbHwEntry->common.groupIdData = DEFAULT_MIMO_GROUP_ID;// Set to 0 for non VHT
	pVapDbHwEntry->common.tcr1NdpTrainingModeData = 0; 
	pVapDbHwEntry->common.tcr1MuTrainingData = 0; 
	pVapDbHwEntry->common.tcr1MuPhyNdpData = 0; 
	pVapDbHwEntry->common.baaWeightedSuccessMduReference = MINIMUM_REF_LEN_VAL;


	AggregationBuilder_FillConfigurationDb(vapIndex,tcrRateVal,phyMode,tcrRateVal,phyMode);

	/* Template 1*/

	pTcr0Template = (Tcr0_t*)&(pVapDbHwEntry->tcrTemplates.word0);
	pTcr0Template->phyMode = phyMode;
	pTcr0Template->bw = BANDWIDTH_TWENTY;
	pTcr0Template->rfPower = 0;
	pTcr0Template->bfMode = TX_BF_FLAT;	// according to SAS set to Bypass for 802.11 frames
	pTcr0Template->antennaSelection = 0;

	pTcr1 = (Tcr1_t*)&(pVapDbHwEntry->tcrTemplates.word1);
	pTcr1->ldpc = DISABLED; // according to SAS set to 0 for 802.11 packets - no ldpc transmission
	pTcr1->stbc = DISABLED; 
	pTcr1->partialAid = ((((VapDbHwEntries[vapIndex].bssid.macAddress45 & 0xF000) >> 0xC) ^ ((VapDbHwEntries[vapIndex].bssid.macAddress45 & 0x0F00) >> 0x8)) << 0x5); //according to SAS
	pTcr1->txopPsNotAllowed = TRUE; //	according to SAS set to 0 for 802.11 packets - Txop PS not allowed
	pTcr1->groupId = DEFAULT_MIMO_GROUP_ID;// group ID default value is 0 for VAP
	pTcr1->ndpTrainingMode = 0; 
	pTcr1->muTraining = 0; 
	pTcr1->muPhyNdp = 0; 

	pTcr2 = (Tcr2_t*)&(pVapDbHwEntry->tcrTemplates.word2);
	pTcr2->bwChange = DISABLED; 
	pTcr2->ant0Boost = 0;
	pTcr2->ant1Boost = 0;
	pTcr2->ant2Boost = 0;
	pTcr2->ant3Boost = 0;

	pTcr3Template = (Tcr3_t*)&(pVapDbHwEntry->tcrTemplates.word3);
	pTcr3Template->aggregate = 0;
	pTcr3Template->notSounding = 1;
	pTcr3Template->bfSmoothing = ENABLED;
	pTcr3Template->dynamicBw = 0; 
	pTcr3Template->rate = tcrRateVal;
	pTcr3Template->scp = DISABLED;

	/* Template 2*/
	
	pTcr0Template = (Tcr0_t*)&(pVapDbHwEntry->tcrTemplates.word4);
	pTcr0Template->phyMode = PHY_MODE_11N;
	pTcr0Template->bw = 0;
	pTcr0Template->rfPower = 0;
	pTcr0Template->bfMode = TX_BF_FLAT;	// according to SAS set to Bypass for 802.11 frames
	pTcr0Template->antennaSelection = 0;

	pTcr1 = (Tcr1_t*)&(pVapDbHwEntry->tcrTemplates.word5);
	pTcr1->ldpc = DISABLED; // according to SAS set to 0 for 802.11 packets - no ldpc transmission
	pTcr1->stbc = DISABLED; // Should be Initialized from the driver. Hard coded for release 0.5
	pTcr1->partialAid = 0;
	pTcr1->txopPsNotAllowed = TRUE; //	according to SAS set to 0 for 802.11 packets - Txop PS not allowed
	pTcr1->groupId = DEFAULT_MIMO_GROUP_ID;// group ID default value is 0 for VAP
	pTcr1->ndpTrainingMode = 0; 
	pTcr1->muTraining = 0; 
	pTcr1->muPhyNdp = 0; 

	pTcr2 = (Tcr2_t*)&(pVapDbHwEntry->tcrTemplates.word6);
	pTcr2->cddAnt1 = DISABLED;
	pTcr2->cddAnt2 = DISABLED;
	pTcr2->cddAnt3 = DISABLED;
	pTcr2->bwChange = DISABLED; 


	pTcr3Template =  (Tcr3_t*)&(pVapDbHwEntry->tcrTemplates.word7);
	pTcr3Template->aggregate = 0;
	pTcr3Template->notSounding = 1;
	pTcr3Template->bfSmoothing = ENABLED;
	pTcr3Template->dynamicBw = 0; 
	pTcr3Template->rate = 0;
	pTcr3Template->scp = DISABLED;

	/* Template 3*/

	pTcr0Template =  (Tcr0_t*)&(pVapDbHwEntry->tcrTemplates.word8);
	pTcr0Template->phyMode = PHY_MODE_11N;
	pTcr0Template->bw = 0;
	pTcr0Template->rfPower = 0;
	pTcr0Template->bfMode = TX_BF_FLAT;	// according to SAS set to Bypass for 802.11 frames
	pTcr0Template->antennaSelection = 0;

	pTcr1 = (Tcr1_t*)&(pVapDbHwEntry->tcrTemplates.word9);
	pTcr1->ldpc = DISABLED; // according to SAS set to 0 for 802.11 packets - no ldpc transmission
	pTcr1->stbc = DISABLED;
	pTcr1->partialAid = 0;
	pTcr1->txopPsNotAllowed = TRUE; //	according to SAS set to 0 for 802.11 packets - Txop PS not allowed
	pTcr1->groupId = DEFAULT_MIMO_GROUP_ID;// group ID default value is 0 for VAP
	pTcr1->ndpTrainingMode = 0; 
	pTcr1->muTraining = 0; 
	pTcr1->muPhyNdp = 0; 

	pTcr2 = (Tcr2_t*)&(pVapDbHwEntry->tcrTemplates.word10);
	pTcr2->cddAnt1 = DISABLED;
	pTcr2->cddAnt2 = DISABLED;
	pTcr2->cddAnt3 = DISABLED;
	pTcr2->bwChange = DISABLED; 
	pTcr2->ant0Boost = 0;
	pTcr2->ant1Boost = 0;
	pTcr2->ant2Boost = 0;
	pTcr2->ant3Boost = 0;
	
	pTcr3Template =  (Tcr3_t*)&(pVapDbHwEntry->tcrTemplates.word11);
	pTcr3Template->aggregate = 0;
	pTcr3Template->notSounding = 0;
	pTcr3Template->bfSmoothing = ENABLED;
	pTcr3Template->dynamicBw = 0; 
	pTcr3Template->rate = 0;
	pTcr3Template->scp = DISABLED;

	/* Template 4*/
	pTcr0Template = (Tcr0_t*)&(pVapDbHwEntry->tcrTemplates.word12);
	pTcr0Template->phyMode = PHY_MODE_11AC;
	pTcr0Template->bw = 0;
	pTcr0Template->rfPower = 0;
	pTcr0Template->bfMode = TX_BF_FLAT;	// according to SAS set to Bypass for 802.11 frames
	pTcr0Template->antennaSelection = 0;

	pTcr1 =  (Tcr1_t*)&(pVapDbHwEntry->tcrTemplates.word13);
	pTcr1->ldpc = DISABLED; // according to SAS set to 0 for 802.11 packets - no ldpc transmission
	pTcr1->stbc = DISABLED;
	pTcr1->partialAid = ((((pVapDbHwEntry->bssid.macAddress45 & 0xF000) >> 0xC) ^ ((pVapDbHwEntry->bssid.macAddress45 & 0x0F00) >> 0x8)) << 0x5); //according to SAS
	pTcr1->txopPsNotAllowed = DISABLED; //	according to SAS set to 0 for 802.11 packets - Txop PS not allowed
	pTcr1->groupId = DEFAULT_MIMO_GROUP_ID;// group ID default value is 0 for VAP
	pTcr1->ndpTrainingMode = 0; 
	pTcr1->muTraining = 0; 
	pTcr1->muPhyNdp = 0;


	pTcr2 = (Tcr2_t*)&(pVapDbHwEntry->tcrTemplates.word14);
	pTcr2->cddAnt1 = DISABLED;
	pTcr2->cddAnt2 = DISABLED;
	pTcr2->cddAnt3 = DISABLED;
	pTcr2->bwChange = DISABLED; 

	pTcr3Template =  (Tcr3_t*)&(pVapDbHwEntry->tcrTemplates.word15);
	pTcr3Template->aggregate = 0;
	pTcr3Template->notSounding = 0;
	pTcr3Template->bfSmoothing = ENABLED;
	pTcr3Template->dynamicBw = 0; 
	pTcr3Template->rate = 0;
	pTcr3Template->scp = DISABLED;

	// Set templates power  for all BWs 
	for (bandwidth = BANDWIDTH_TWENTY; bandwidth < LA_NUM_OF_BANDWIDTH; bandwidth++)
	{
		pRfPowerTemplate = (VapDbRfPowerTemplate_t *)&VapDbRfPowerTemplateTcr[bandwidth];
		pRfPowerTemplate->powerTemplate1 = GetTcrDefaultPowerVal(0, rateIndex, bandwidth);
		pRfPowerTemplate->powerTemplate2 = GetTcrDefaultPowerVal(0, rateIndex, bandwidth);
		pRfPowerTemplate->powerTemplate3 = GetTcrDefaultPowerVal(0, rateIndex, bandwidth);
		pRfPowerTemplate->powerTemplate4 = GetTcrDefaultPowerVal(0, rateIndex, bandwidth);
	}
	/* INITIALIZE the TID info for all TIDs (x8) */	
	for ( tidIndex=0 ; tidIndex < NUM_OF_TIDS; tidIndex++)
	{
		pVapTidEntry = &(pVapDbHwEntry->tid[tidIndex]);

		pVapTidEntry->currentSequenceNumber = 0; /* [0:11]	*/	
		pVapTidEntry->lowSequenceNumber = 0;	 /* [27:16] */
		
		pVapTidEntry->baEnable = DISABLED;							  /* BA transmission enabled				     [0] 	   */
		pVapTidEntry->ppduTxMode = VAP_DB_PPDU_TX_MODE_LEGACY_ONLY;  /* 0-legacy only 1-legacy+MPDU 2-two level aggregation  [2:1] 	   */
		pVapTidEntry->maxPsduTransmissionTimeLimit = (MAX_PSDU_TX_TIME_LIMIT>>1); // max time resolution is 2microSec
		pVapTidEntry->currentBaWindowLimit = 0; 			  /* no limit on BA window							     [21:16] */
	}

	memcpy(antBoost,antPowerBoost, MAX_NUM_OF_ANTENNAS); 
		
 	setAntBoostInVapTcr(vapIndex, antBoost);
	
	OSAL_ENABLE_INTERRUPTS(interrupt_save);

}

/********************************************************************************
updateTcrCommonTemplate1Rate

Description: updates template1's phy mode & rate
----------

Input: valid rates to mask wanted rates from basic rate set
-----

Output:
-------

Returns:
--------

********************************************************************************/
void updateTcrCommonTemplate1Rate(uint32 validRateSet)
{
	//Wave600 only
}

/********************************************************************************
fillStaHwDb




Description:
----------

Input:
-----

Output:
-------

Returns:
--------

********************************************************************************/

void fillStaHwDb (UMI_STA_ADD *pAddSta, uint8 initialRate)
{
	StaId stationIndex = pAddSta->u16SID;
	StaDb_t*          	pStaDbHwEntry =  &StaDbHwEntries[stationIndex];
	Tcr1_t*		pTcr1Data = NULL;
	Tcr1_t*		pTcr1Management = NULL;
	Tcr3_t*		pTcr3Data = NULL;
	Tcr3_t*		pTcr3Management = NULL;
	Tcr0_t* 		pTcr0Data = NULL;
	Tcr0_t* 	pTcr0Management =  NULL;	
	uint8 tidIndex;
	AmpduParameters_t*		pAmpduParameters = (AmpduParameters_t*)&pAddSta->u8AMPDU_Param;
	uint8 DummytcrRateVal;
	bool isStaVht = LinkAdaptationStaDatabase[stationIndex].laStaUspCommon.staTransmissionParams.vhtSta;
	PhyMode_e phyMode;
	StaDbTid_t* 	  	pStaTidEntry = NULL;	
	Bandwidth_e bandwidth;
	uint8 currentBwOffset;
	uint32* pStaBwDataTcr0 =(uint32*)&(pStaDbHwEntry->common.word4);
	uint32* pStaBwManagementTcr0 = (uint32*)&(pStaDbHwEntry->common.word13);
	HtCapabilitiesInfo_t 	htCapabilities;
	sVHT_CAPABILITIES_INFO vhtCapabilities;
	LinkAdaptationPhyMode_e laPhyMode;
	uint8 isXFilterOpen = MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_8021X_FILTER_OPEN);
	const RateObj_t* ratesTable = getRatesTable(&LinkAdaptationStaDatabase[stationIndex].laStaUspCommon);
	uint8 maximumAmpdulengthExponent = 0;
		
	memcpy(&htCapabilities, &(pAddSta->u16HT_Cap_Info) , sizeof(sHT_CAPABILITIES_INFO) );
	memcpy(&vhtCapabilities, &(pAddSta->u32VHT_Cap_Info) , sizeof(sVHT_CAPABILITIES_INFO) );
	
	getTcrPhyModeAndRate(ratesTable, isStaVht,initialRate, &phyMode, &DummytcrRateVal, FALSE, NO_DCM); 

	laPhyMode = ConvertTcrPhyMode2LaPhyMode[phyMode];

	/*DW0 */
	pStaDbHwEntry->common.bfReportResponseFormat = BF_RE_FORMAT_IMMEDIATE_REPORT_EXPECTED; // StaDb_GetBfReportResponseFormat(assocParams->txBfCapabilities); // [15:14] 
	pStaDbHwEntry->common.qosEnableCapability = MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_WME); 		// [16] 	
	if ((isXFilterOpen == FALSE) && (pAddSta->u8WDS_client_type == FOUR_ADDRESSES_STATION))
	{
		pStaDbHwEntry->common.negotiatedWds = FALSE;	/*If filter is closed and 4 address STA, set WDS = 0 so EAPOL are sent in 3 address*/
	}
	else
	{
   		pStaDbHwEntry->common.negotiatedWds = MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_WDS);				// [17]   should be 0 -no WDS
	}
	pStaDbHwEntry->common.wdsClientType = pAddSta->u8WDS_client_type;
	pStaDbHwEntry->common.dynamicBwEnable = DISABLED;								// [22]
	pStaDbHwEntry->common.staticBwEnable  = DISABLED;								// [23] 	 

	pStaDbHwEntry->common.psForceOneNss = 1;

	if (MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_VHT) == TRUE)
	{
		maximumAmpdulengthExponent = vhtCapabilities.maximum_ampdu_length_exponent;

		/* calculate ( 2 power (13 + maxMpduLengthLimit)) -1 */
		pStaDbHwEntry->common.maxMpduLengthLimit = calculateMpduMaxLengthLimitVht(vhtCapabilities.max_mpdu_len); 
		
		/* Is this should be taken from 8 -123(supported channel width set in HT capabilities table
			or from 8-129 ( HT operation element STA channel width. Also only 20/40 is supported  */
		pStaDbHwEntry->common.maxMsduAtAmsduCount = laVhtMsduInAmsdu;		
		if ((vhtCapabilities.rx_stbc & STA_CAPABILITIES_VHT_STBC_SUPPORT_MASK) >= STBC_CAPABILITIES_SUPPORT_1_2_NSS)
		{
			//In order to prevent forbiden case when STBC 2x4 will be transmitted with 1NSS after aggregation builder will set 1NSS if sta in PS, we set this bit on zero if station support STBC 2X4
			pStaDbHwEntry->common.psForceOneNss = 0;
		}

		pStaDbHwEntry->common.dynamicBwEnable = LinkAdaptationRtsMode.dynamicBw;								// [22]
		pStaDbHwEntry->common.staticBwEnable  = LinkAdaptationRtsMode.staticBw;								// [23] 	 

	}
	else if (MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_HT) == TRUE)
	{
		
		maximumAmpdulengthExponent = pAmpduParameters->maximumAmpdulengthExponent;
		pStaDbHwEntry->common.maxMpduLengthLimit =  calculateMpduMaxLengthLimitHt(htCapabilities.maximalAmsduSize);
		pStaDbHwEntry->common.maxMsduAtAmsduCount = laHtMsduInAmsdu;
		if ((htCapabilities.rxStbc & STA_CAPABILITIES_HT_STBC_SUPPORT_MASK) >= STBC_CAPABILITIES_SUPPORT_1_2_NSS)
		{
			//In order to prevent forbiden case when STBC 2x4 will be transmitted with 1NSS after aggregation builder will set 1NSS if sta in PS, we set this bit on zero if station support STBC 2X4
			pStaDbHwEntry->common.psForceOneNss = 0; 
		}

	}
	else
	{
		/* This is the default value for 11A/G, for 11B the field should not be used by the aggregation builder */
		pStaDbHwEntry->common.maxMpduLengthLimit = MAX_HT_MPDU_IN_A_MPDU_LENGTH_TX;
	}
	
	pStaDbHwEntry->common.maxPsduLengthLimit = getPsduMaxLengthLimit(maximumAmpdulengthExponent); /* [19:0]  */
	/* DW1 */
	pStaDbHwEntry->common.staPhyCapabilities = phyMode;
	pStaDbHwEntry->common.noAggInPs = 1;
	pStaDbHwEntry->common.sppAmsduCapable = DISABLED;
	pStaDbHwEntry->common.maxSpLength = CALC_MAX_SP_LENGTH(pAddSta->u8Max_SP);   /* maximal service period  [10:3] 	*/
	pStaDbHwEntry->common.txPostpone = TX_POSTPONE_CTS2SELF;
	pStaDbHwEntry->common.currentPacketDensity = pAmpduParameters->minimumMpduStartSpacing; /* [27:25] */
	// Driver / HW set these ?
	pStaDbHwEntry->common.rtsCtsTxMethod = RTS_CTS_TX_METHOD_NO_RTS_CTS;		  /* [29:28] */
	pStaDbHwEntry->common.ctsToSelfTxMethod = CTS_TO_SELF_TX_METHOD_NO_CTS2SELF;	  /* [30:31] */


	/*****************************/
	/*			ZONE B (TCRs)		*/
	/*****************************/
	
	for (bandwidth = BANDWIDTH_TWENTY; bandwidth < LA_NUM_OF_BANDWIDTH; bandwidth++)
	{
		currentBwOffset = (bandwidth << 1);

		pTcr0Data = (Tcr0_t*)&pStaBwDataTcr0[currentBwOffset];
		pTcr3Data = (Tcr3_t*)&pStaBwDataTcr0 [currentBwOffset + 1];

		/* DW4 - TCR0[31:0] 20 MHZ Data */
//		pTcr0Data = &(pStaDbHwEntry->tcr020MhzData);
//		pTcr0Data->phyMode= 0; //will be changed later by dedicated function
		pTcr0Data->bw = bandwidth;
//		pTcr0Data->rfPower = MAX_RF_POWER; // transmission power  0x3F max power
//		pTcr0Data->bfMode = TX_BF_FLAT;		  // according to req 1266 for data should be set to 01 ( beamforming)	for management set to 00 Bypass
		//pTcr0Data->antennaSelection = ANT_SELECTION_ALL;   //  choose antena to transmit from
//		pTcr0Data->wpRfPower = MAX_RF_POWER;
//		pTcr0Data->wpPhyMode = 0; //will be changed later by dedicated function

		/* DW8 - TCR3[23:0] 20MHz Data */
//		pTcr3Data = &(pStaDbHwEntry->tcr320MhzData);
		pTcr3Data->aggregate = DISABLED; // specified in SAS to deafult value 0.
		pTcr3Data->notSounding = ENABLED; // specified in SAS to deafult value 0.
		pTcr3Data->bfSmoothing = ENABLED; // specified in SAS to deafult value 0.
		pTcr3Data->dynamicBw = DISABLED; // specified in SAS to deafult value 0.
//		pTcr3Data->rate = 0; //will be changed later by dedicated function
		pTcr3Data->scp = 0; //will be set later by dedicated function
//		pTcr3Data->probingAntSelection = ANT_SELECTION_WP_DEFAULT;
	//	pTcr3Data->wpScp = scpTable[bandwidth];
		pTcr0Management = (Tcr0_t*)&pStaBwManagementTcr0[currentBwOffset];
		pTcr3Management = (Tcr3_t*)&pStaBwManagementTcr0 [currentBwOffset + 1];
		
		/* DW12 - TCR0[23:0] 20Mhz 802.11 */
//		pTcr0Management = &(pStaDbHwEntry->tcr020MhzManagement);
//		pTcr0Management->phyMode = 0;//will be changed later by dedicated function
		pTcr0Management->bw = bandwidth; 			
//		pTcr0Management->rfPower = MAX_RF_POWER; 	
//		pTcr0Management->bfMode = TX_BF_FLAT;	// according to SAS set to Bypass for 802.11 frames
	//Tcr0Management->antennaSelection = ANT_SELECTION_ALL;
//		pTcr0Management->wpRfPower = MAX_RF_POWER;	
//		pTcr0Management->wpPhyMode = 0; //will be changed later by dedicated function
		
		/* DW16 - TCR3[23:0] 20 Mhz 802.11 */
//		pTcr3Management = &(pStaDbHwEntry->tcr320MhzManagement);
		pTcr3Management->aggregate = DISABLED; // specified in SAS to deafult value 0.
		pTcr3Management->notSounding = ENABLED; // specified in SAS to deafult value 0.
		pTcr3Management->bfSmoothing = ENABLED; // specified in SAS to deafult value 0.
		pTcr3Management->dynamicBw = DISABLED; // specified in SAS to deafult value 0.
//		pTcr3Management->rate = 0; //will be changed later by dedicated function
		pTcr3Management->scp = 0;
//pTcr3Management->probingAntSelection = ANT_SELECTION_WP_DEFAULT;
		pTcr3Management->wpScp = 0;//will be changed later by dedicated function
	}


	/*Those fields are relevant for all BWs*/
	
//	pStaDbHwEntry->tcr380MhzData.probingAntSelection = ANT_SELECTION_WP_DEFAULT;
	/* DW7 - TCR1[23:0] Data */
	pTcr1Data = (Tcr1_t*)&(pStaDbHwEntry->common.word10);
	pTcr1Data->ldpc = getLdpcCapability(stationIndex,laPhyMode);	
//	pTcr1Data->stbc = NOT_STBC_TRANSMISSION; //getStbcCapability(pLmStaDbSwinfo->htCapabilities.txStbc, phyMode); // or rx_stbs
	pTcr1Data->partialAid = (pAddSta->u16AID + ((((VapDbHwEntries[pAddSta->u8VapIndex].bssid.macAddress45 & 0xF000) >> 0xC) ^ ((VapDbHwEntries[pAddSta->u8VapIndex].bssid.macAddress45 & 0x0F00) >> 0x8)) << 0x5)) & 0x01FF; //according to SAS
	pTcr1Data->txopPsNotAllowed = TRUE;//staDbGetTxopPsAllowed(FALSE);   // pStaDbSwEntry->htCapabilities.lSigTxop_protection_support;
	pTcr1Data->groupId = DEFAULT_MIMO_GROUP_ID; 	// Set to 0 for non VHT
//	pTcr1Data->mimoPs = 
//	pTcr1Data->baaWeightedSuccessMduRef =0;//will be changed later by dedicated function

	

	/* DW15 - TCR1[23:0] 802.11 */
	pTcr1Management = (Tcr1_t*)&(pStaDbHwEntry->common.word11);
	pTcr1Management->ldpc = CONVOLUTIONAL_CODING;//staDbGetLdpc(MTLK_BFIELD_GET(pStaAdd->u8Flags, STA_ADD_FLAGS_LDPC), phyMode);
	pTcr1Management->stbc = NOT_STBC_TRANSMISSION; //staDbGetStbc(pStaDbSwEntry->htCapabilities.txStbc, phyMode); // or rx_stbs
	pTcr1Management->partialAid = (pAddSta->u16AID + ((((VapDbHwEntries[pAddSta->u8VapIndex].bssid.macAddress45 & 0xF000) >> 0xC) ^ ((VapDbHwEntries[pAddSta->u8VapIndex].bssid.macAddress45 & 0x0F00) >> 0x8)) << 0x5)) & 0x01FF; //according to SAS
	pTcr1Management->txopPsNotAllowed = TRUE;//staDbGetTxopPsAllowed(FALSE);   // pStaDbSwEntry->htCapabilities.lSigTxop_protection_support;
	pTcr1Management->groupId = DEFAULT_MIMO_GROUP_ID; 	// Set to 0 for non VHT
//	pTcr1Management->mimoPs = 
//	pTcr1Management->frameSync =//will be changed later by dedicated function
	pTcr1Management->altRateReasonFastProbing = 0;//will be changed later by dedicated function
	pTcr1Management->altRateReasonSlowProbing = 0;//will be changed later by dedicated function
	pTcr1Management->altRateReasonBfReportFastUpdate = 0;//will be changed later by dedicated function

	/* DW11 - TCR2[23:0]  */
	// Is this taken from ASEL Capability field in Capabilities info IE 
	pStaDbHwEntry->common.tcr2BwChange = DISABLED;
	pStaDbHwEntry->common.baaWeightedSuccessMduReference =0;//will be changed later by dedicated function

	/* INITIALIZE the TID info for all TIDs (x8) */
	for ( tidIndex = 0 ; tidIndex < NUM_OF_TIDS ; tidIndex++)
	{
		pStaTidEntry = (StaDbTid_t*)&(pStaDbHwEntry->tid[tidIndex]);
		/* DW 0 */
		pStaTidEntry->currentSequenceNumber = 0; /* [0:11]  */	
		pStaTidEntry->lowSequenceNumber = 0;     /* [27:16] */
		/* DW 1 */
		pStaTidEntry->baEnable = DISABLED;							  /* BA transmission enabled							[0] 	   */		
		pStaTidEntry->ppduTxMode = laPpduTxMode;  	// values can be seen in PpduTxMode_e		
		pStaTidEntry->currentBaWindowLimit = 0; 		      /* no limit on BA window						          [21:16]    */
		pStaTidEntry->txopMultipleDataEn = DISABLED;
		/*Relevant only for 11N (by configuration)*/
		pStaTidEntry->maxPsduTransmissionTimeLimit = (MAX_PSDU_TX_TIME_LIMIT>>1); // max time resolution is 2microSec;
	}
	
}
/**********************************************************************************

setVapFixedRatesInHwDb 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void setVapFixedRatesInHwDb(void)
{
	uint32 protectedDBscratchPad[PROTECTED_VAP_DB_SIZE_WORDS];
	uint8	vapid= FixedRateParameters.vapId;
	VapDb_t* pVapDbHwEntries = &VapDbHwEntries[vapid];
	uint32	*VapDbRfPowerTemplateTcr = (uint32 *)&(pVapDbHwEntries->tcrTemplates.word16);//rfPower20MhzTemplates
	VapDbRfPowerTemplate_t *pRfPowerTemplate = NULL;
	uint8 rateIndex;
	bool isVht = (FixedRateParameters.phyMode == PHY_MODE_11AC) ? TRUE : FALSE;
	
	/*If Change from non 11B to 11B, first set BW and after it set rate*/
	if (FixedRateParameters.phyMode != PHY_MODE_11B)
	{
		/*Set bw limit*/
		setVapFixedBwLimit(FixedRateParameters.bandwidth, pVapDbHwEntries);
		/*Set rate*/
		ProtectedDbLock_ReadModifyWriteReq((uint32*)&(pVapDbHwEntries->common.word4), (PROTECTED_VAP_DB_SIZE_WORDS), protectedDBscratchPad, setVapFixedRateInTcrsModificationFunc,(void*)&FixedRateParameters); 
		
	}
	else
	{
		/*Set rate*/
		ProtectedDbLock_ReadModifyWriteReq((uint32*)&(pVapDbHwEntries->common.word4), (PROTECTED_VAP_DB_SIZE_WORDS), protectedDBscratchPad, setVapFixedRateInTcrsModificationFunc,(void*)&FixedRateParameters); 
		/*Set bw limit*/
		setVapFixedBwLimit(FixedRateParameters.bandwidth, pVapDbHwEntries);

	}

	// Set RTS Power template for all BWs (template 1 in RF Power Template)
	
	rateIndex = convertTcr2RateIndex(FixedRateParameters.phyMode, FixedRateParameters.rate);
	pRfPowerTemplate = (VapDbRfPowerTemplate_t *)&VapDbRfPowerTemplateTcr[FixedRateParameters.bandwidth];
	pRfPowerTemplate->powerTemplate1 = GetTcrDefaultPowerVal(isVht, rateIndex, FixedRateParameters.bandwidth);
}
/**********************************************************************************

setVapFixedRateInTcrsModificationFunc 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void setVapFixedRateInTcrsModificationFunc(uint32* scratchPadAddress, void* functionParams)
{
	
	LaFixedRateParams_t* fixedRateParams = (LaFixedRateParams_t*) functionParams;
	uint8 tcrWordOffset;
	Tcr0_t *pTcr0Data;
	Tcr3_t *pTcr3Data; 
	Tcr0_t *pTcr0Management;
	Tcr3_t *pTcr3Management; 
	VapRateAdaptationParams_t* raStruct = (VapRateAdaptationParams_t*) scratchPadAddress;
	uint32* dataTcr0SectionAddress = (uint32*)&(raStruct->tcr020MhzData);
	uint32* managemntTcr0SectionAddress = (uint32*)&(raStruct->tcr020MhzMgnt);
	uint8 rateIndex = convertTcr2RateIndex(fixedRateParams->phyMode, fixedRateParams->rate);
	bool isVht = (fixedRateParams->phyMode == PHY_MODE_11AC) ? TRUE : FALSE;
	uint8 powerTcrVal;
	Scp_e tcrCp = convertCpModeToHtVhtCpTcrVal(fixedRateParams->cpMode);

	tcrWordOffset = ((fixedRateParams->bandwidth) << 1);
	powerTcrVal = GetTcrDefaultPowerVal(isVht, rateIndex, fixedRateParams->bandwidth);

	if((fixedRateParams->changeType == LA_PACKET_TYPE_DATA_MANAGEMENT) || (fixedRateParams->changeType == LA_PACKET_TYPE_DATA))
	{

		/*Change transmitting fields in VAP DB in both cases - probing and working point modifcation*/
		/*Change main TCR*/
		pTcr0Data = (Tcr0_t *)&dataTcr0SectionAddress[tcrWordOffset];
		pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[tcrWordOffset + 1];

		pTcr0Data->phyMode = fixedRateParams->phyMode;
		pTcr3Data->rate = fixedRateParams->rate;
		pTcr0Data->rfPower = powerTcrVal;
		pTcr3Data->scp = tcrCp;

		/*Change working point fields in Vap DB*/
		pTcr3Data->wpScp = tcrCp;
		pTcr0Data->wpPhyMode = fixedRateParams->phyMode;
		pTcr3Data->wpRate  = fixedRateParams->rate;
		pTcr3Data->wpScp = tcrCp;
		pTcr0Data->wpRfPower = powerTcrVal;
	}
	if((fixedRateParams->changeType == LA_PACKET_TYPE_DATA_MANAGEMENT) || (fixedRateParams->changeType == LA_PACKET_TYPE_MANAGEMENT))
	{
		/*Change transmitting fields in VAP DB in both cases - probing and working point modifcation*/
		/*Change main TCR*/
		pTcr0Management = (Tcr0_t *)&managemntTcr0SectionAddress[tcrWordOffset];
		pTcr3Management = (Tcr3_t *)&managemntTcr0SectionAddress[tcrWordOffset + 1];

		pTcr0Management->phyMode = fixedRateParams->phyMode;
		pTcr3Management->rate = fixedRateParams->rate;
		pTcr0Management->rfPower = powerTcrVal;
		pTcr3Management->scp = tcrCp;
	}
}

/********************************************************************************
setStaFixedBwLimit




Description:
----------

Input:
-----

Output:
-------

Returns:
--------

********************************************************************************/

static void setStaFixedBwLimit(StaId staIndex)
{
	LaFixedRateStationParams_t *laFixedRateStationParams_p = &LinkAdaptationStaDatabase[staIndex].laStationUnique.fixedRateStationParams;
	
	if(laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_DATA_MANAGEMENT) 
	{
		SetStaDataBwLimitInHwDb(staIndex,laFixedRateStationParams_p->bandwidth,TRUE);
		SetStaManagementBwLimit(staIndex,laFixedRateStationParams_p->bandwidth);
	}
	else if (laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_DATA)
	{
		SetStaDataBwLimitInHwDb(staIndex,laFixedRateStationParams_p->bandwidth,TRUE);
	}
	else if (laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_MANAGEMENT)
	{
		SetStaManagementBwLimit(staIndex,laFixedRateStationParams_p->bandwidth);
	}
}

/********************************************************************************
setVapFixedBwLimit




Description:
----------

Input:
-----

Output:
-------

Returns:
--------

********************************************************************************/

static void setVapFixedBwLimit(Bandwidth_e bandwidth, VapDb_t* pVapDbHwEntries)
{
	
	if(FixedRateParameters.changeType == LA_PACKET_TYPE_DATA_MANAGEMENT) 
	{
		pVapDbHwEntries->common.dataBwLimit = FixedRateParameters.bandwidth;
		pVapDbHwEntries->common._80211BwLimit = FixedRateParameters.bandwidth;

	}
	else if (FixedRateParameters.changeType == LA_PACKET_TYPE_DATA)
	{
		pVapDbHwEntries->common.dataBwLimit = FixedRateParameters.bandwidth;

	}
	else if (FixedRateParameters.changeType == LA_PACKET_TYPE_MANAGEMENT)
	{
		pVapDbHwEntries->common._80211BwLimit = FixedRateParameters.bandwidth;
	}
}
/**********************************************************************************

setPowerInStaTcr 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void SetPowerInVapTcr(uint8 vapIndex, int8* pPowerValTable, Bandwidth_e bandwidth, uint8 lastBwToUpdate, bool changeProbingPoint, LaPacketType_e packetType)
{

	ProtectedDbModFuncPowerParams_t protectedDbfuncParams;
	uint32 protectedDBscratchPad[PROTECTED_VAP_DB_SIZE_WORDS];
	uint32	*VapDbRfPowerTemplateTcr = (uint32 *)&(VapDbHwEntries[vapIndex].tcrTemplates.word16);
	VapDbRfPowerTemplate_t *pRfPowerTemplate = NULL;
	Bandwidth_e bwIndex;

	DEBUG_ASSERT((bandwidth <= (LinkAdaptationCommonConfiguration.wlanBandwidthMax)) && (lastBwToUpdate <= (LinkAdaptationCommonConfiguration.wlanBandwidthMax)));
	/*Update new working point in STA DB using protected DB*/
	protectedDbfuncParams.changeProbingPoint = changeProbingPoint;
	protectedDbfuncParams.bandwidth = bandwidth;
	protectedDbfuncParams.lastBwToUpdate = lastBwToUpdate;
	protectedDbfuncParams.pTcrDataPowerValTable = pPowerValTable;
	protectedDbfuncParams.packetType = packetType;

	ProtectedDbLock_ReadModifyWriteReq((uint32*)&(VapDbHwEntries[vapIndex].common.word4), (PROTECTED_VAP_DB_SIZE_WORDS), protectedDBscratchPad, setPowerInVapDbModificationFunc,(void*)&protectedDbfuncParams); 

	// Set RTS Power template for all BWs (template 1 in RF Power Template)

	if ((packetType == LA_PACKET_TYPE_DATA) || (packetType == LA_PACKET_TYPE_DATA_MANAGEMENT) || (packetType == LA_PACKET_TYPE_MU_DATA))
	{
		for (bwIndex = bandwidth; bwIndex <= lastBwToUpdate; bwIndex++)
		{
			pRfPowerTemplate = (VapDbRfPowerTemplate_t *)&VapDbRfPowerTemplateTcr[bwIndex];
			pRfPowerTemplate->powerTemplate1 = pPowerValTable[bwIndex];
			pRfPowerTemplate->powerTemplate2 = pPowerValTable[bwIndex];
			pRfPowerTemplate->powerTemplate3 = pPowerValTable[bwIndex];
			pRfPowerTemplate->powerTemplate4 = pPowerValTable[bwIndex];
		}
	}
}

/**********************************************************************************

setPowerInStaDbModificationFunc 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void setPowerInVapDbModificationFunc(uint32* scratchPadAddress, void* functionParams)
{
	ProtectedDbModFuncPowerParams_t* powerParams = (ProtectedDbModFuncPowerParams_t*) functionParams;
	uint8 tcrBandwidthOffset;
	Tcr0_t* pTcr0Data; 
	Tcr0_t* pTcr0Management;
	VapRateAdaptationParams_t* raStruct = (VapRateAdaptationParams_t*) scratchPadAddress;
	uint32* dataTcr0SectionAddress = (uint32*)&(raStruct->tcr020MhzData);
	uint32* managementTcr0SectionAddress = (uint32*)&(raStruct->tcr020MhzMgnt);
	Bandwidth_e bandwidth;
	
	for (bandwidth = powerParams->bandwidth; bandwidth <= powerParams->lastBwToUpdate; bandwidth++)
	{

		tcrBandwidthOffset = (bandwidth << 1);
		pTcr0Data = (Tcr0_t *)&dataTcr0SectionAddress[tcrBandwidthOffset];
		pTcr0Management = (Tcr0_t *)&managementTcr0SectionAddress[tcrBandwidthOffset];
		
		if (powerParams->packetType == LA_PACKET_TYPE_DATA)
		{
			/*Change TCR*/
			pTcr0Data->rfPower = powerParams->pTcrDataPowerValTable[bandwidth];
			
			/*Change working point*/
			pTcr0Data->wpRfPower = powerParams->pTcrDataPowerValTable[bandwidth];
		}
		else if (powerParams->packetType == LA_PACKET_TYPE_MANAGEMENT)
		{
			pTcr0Management->rfPower = powerParams->pTcrDataPowerValTable[bandwidth];;
		}
		else
		{
			/*LA_PACKET_TYPE_DATA_MANAGEMENT*/
			
			pTcr0Data->rfPower = powerParams->pTcrDataPowerValTable[bandwidth];
			pTcr0Management->rfPower = powerParams->pTcrDataPowerValTable[bandwidth];
			
			/*Change working point*/
			pTcr0Data->wpRfPower = powerParams->pTcrDataPowerValTable[bandwidth];
		}
	}

}



/**********************************************************************************

SetAntSelectionInVapTcr 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void AntennaSelectionSetBitmapInVapTcr(uint8 vapId, uint8 antSelectionMask, LaPacketType_e packetType)
{

	ProtectedDbModFuncAntSelectionParams_t protectedDbfuncParams;
	uint32 protectedDBscratchPad[PROTECTED_VAP_DB_SIZE_WORDS];

	/*Update new working point in STA DB using protected DB*/
	protectedDbfuncParams.changeProbingPoint = FALSE;
	protectedDbfuncParams.tcrAntennaSelctionMask = antSelectionMask;
	protectedDbfuncParams.packetType = packetType;

	ProtectedDbLock_ReadModifyWriteReq((uint32*)&(VapDbHwEntries[vapId].common.word4), (PROTECTED_VAP_DB_SIZE_WORDS), protectedDBscratchPad, setAntennaSelectionInVapDbModificationFunc,(void*)&protectedDbfuncParams); 
}

/**********************************************************************************

SetAntSelectionInAutoReplyTcr 


Description:
------------
	Set the antenna selection field of TCR 0 for auto response frames

Input: 
-----
	antSelectionMask - the Value of anrtenna selection field  in the TCR
	
**********************************************************************************/
void AntennaSelectionSetBitmapInAutoReplyTcr(uint8 antSelectionMask)
{
	DeliaAutoResponseTcr0.antennaSelection = antSelectionMask;	


#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND
	LinkAdaptationPhyDriver_UpdatePhyGenriscScpad();
#endif //DYNAMIC_RTS_ISSUE_WORKAROUND
}

/**********************************************************************************


CyclicPrefixSetModeInStaTcr 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void setAntennaSelectionInVapDbModificationFunc(uint32* scratchPadAddress, void* functionParams)
{
	ProtectedDbModFuncAntSelectionParams_t* antSelectionParams = (ProtectedDbModFuncAntSelectionParams_t*) functionParams;
	uint8 tcrBandwidthOffset;
	Tcr0_t* pTcr0Data; 
	Tcr0_t* pTcr0Management;
	VapRateAdaptationParams_t* raStruct = (VapRateAdaptationParams_t*) scratchPadAddress;
	uint32* dataTcr0SectionAddress = (uint32*)&(raStruct->tcr020MhzData);
	uint32* managementTcr0SectionAddress = (uint32*)&(raStruct->tcr020MhzMgnt);
	Bandwidth_e bandwidth;

	DEBUG_ASSERT(antSelectionParams->tcrAntennaSelctionMask > 0);


	for (bandwidth = BANDWIDTH_TWENTY; bandwidth < LA_NUM_OF_BANDWIDTH ;bandwidth++)
	{

		tcrBandwidthOffset = (bandwidth << 1);
		pTcr0Data = (Tcr0_t *)&dataTcr0SectionAddress[tcrBandwidthOffset];
		pTcr0Management = (Tcr0_t *)&managementTcr0SectionAddress[tcrBandwidthOffset];

		switch (antSelectionParams->packetType)
		{
			case(LA_PACKET_TYPE_DATA):
			{
				/*Change TCR*/
				pTcr0Data->antennaSelection = antSelectionParams->tcrAntennaSelctionMask;
				break;
			}
			case(LA_PACKET_TYPE_MANAGEMENT):
			{
				pTcr0Management->antennaSelection = antSelectionParams->tcrAntennaSelctionMask;
				break;
			}
			case(LA_PACKET_TYPE_DATA_MANAGEMENT):
			{
				/*LA_PACKET_TYPE_DATA_MANAGEMENT*/
				pTcr0Data->antennaSelection = antSelectionParams->tcrAntennaSelctionMask;
				pTcr0Management->antennaSelection = antSelectionParams->tcrAntennaSelctionMask;
				break;
			}
			default:
			{
				DEBUG_ASSERT(0);
				break;
			}
		}
	}

}

/***************************************************************************
**
** NAME         antennaSelectionSetMuGroupAntenna
**
** PARAMETERS   
**
** DESCRIPTION  

****************************************************************************/
void  antennaSelectionSetMuGroupAntenna(uint8 groupId, uint8 antennaSelection, bool isHeGroup)
{
	uint8 uspIndex;
	LinkAdaptationDatabaseDistributionPack_t distributionParams; 
	MuGrpDb_t* pGroupDbHwEntry = NULL;
	Tcr0_t	*pTcr0Data;
	Bandwidth_e bandwidth;
	uint8 numOfAntennas = AntennaSelectionCalcAntennaCount(antennaSelection);

	for(uspIndex = 0; uspIndex < MAX_USP_IN_VHT_GROUP; uspIndex++)
	{
		if(LinkAdaptationVhtGroupDatabase[groupId].laVhtGroupUnique.groupStationIndexes[uspIndex] != INVALID_STA_INDEX)
		{
			updateLaDbDistributionParam(&distributionParams,groupId,uspIndex, FALSE);
			/*Set rate adaptation mask according to num of antennas*/
			setMaskAccordingToMaxNumOfAntennas(&distributionParams, numOfAntennas); 
			/*Adjust rate to num of antennas*/
			rateAdaptationAdjustRateToMask(&distributionParams);
		}
	}
	pGroupDbHwEntry =  &(GroupDbHwEntries[groupId]);
	pTcr0Data =	(Tcr0_t*)&(pGroupDbHwEntry->word7); 
	for (bandwidth = BANDWIDTH_TWENTY; bandwidth <= BANDWIDTH_EIGHTY; bandwidth++)
	{
		pTcr0Data->antennaSelection = antennaSelection; 
		pTcr0Data++; 
	}
}

/**********************************************************************************

SetCDDInVapTcr 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void CddSetInVapTcr(uint8 vapId, CddValues_t *cddVals)
{

	ProtectedDbModFuncCddParams_t protectedDbfuncParams;
	uint32 protectedDBscratchPad[PROTECTED_VAP_DB_SIZE_WORDS];
	Tcr2_t* vapTcr2Tamplate1 = (Tcr2_t*)&(VapDbHwEntries[vapId].tcrTemplates.word2);
	Tcr2_t* vapTcr2Tamplate2 = (Tcr2_t*)&(VapDbHwEntries[vapId].tcrTemplates.word6);
	Tcr2_t* vapTcr2Tamplate3 = (Tcr2_t*)&(VapDbHwEntries[vapId].tcrTemplates.word10);
	Tcr2_t* vapTcr2Tamplate4 = (Tcr2_t*)&(VapDbHwEntries[vapId].tcrTemplates.word14);

	/*Update new working point in STA DB using protected DB*/
	memcpy(&(protectedDbfuncParams.cddVals), cddVals, sizeof(CddValues_t));

	ProtectedDbLock_ReadModifyWriteReq((uint32*)&(VapDbHwEntries[vapId].common.word4), (PROTECTED_VAP_DB_SIZE_WORDS), protectedDBscratchPad, setCddnVapDbModificationFunc,(void*)&protectedDbfuncParams); 

	/*Template 1*/
	vapTcr2Tamplate1->cddAnt1 = cddVals->cddAnt1;
	vapTcr2Tamplate1->cddAnt2 = cddVals->cddAnt2;
	vapTcr2Tamplate1->cddAnt3 = cddVals->cddAnt3;

	/*Template 2*/
	vapTcr2Tamplate2->cddAnt1 = cddVals->cddAnt1;
	vapTcr2Tamplate2->cddAnt2 = cddVals->cddAnt2;
	vapTcr2Tamplate2->cddAnt3 = cddVals->cddAnt3;
	/*Template 3*/
	vapTcr2Tamplate3->cddAnt1 = cddVals->cddAnt1;
	vapTcr2Tamplate3->cddAnt2 = cddVals->cddAnt2;
	vapTcr2Tamplate3->cddAnt3 = cddVals->cddAnt3;

	/*Template 4*/
	vapTcr2Tamplate4->cddAnt1 = cddVals->cddAnt1;
	vapTcr2Tamplate4->cddAnt2 = cddVals->cddAnt2;
	vapTcr2Tamplate4->cddAnt3 = cddVals->cddAnt3;



}

/**********************************************************************************

SetCddInAutoReplyTcr 


Description:
------------
	Set CDD vals of the Auto Response TCR 

Input: 
-----
	cddVals- Cdd default Values for the number of antennas configured

Returns:
--------
	void - 
	
**********************************************************************************/
void CddSetInAutoReplyTcr(CddValues_t cddVals)
{	
	/* Write to autoreply TCR and Cts Auto Reply*/
	DeliaAutoResponseTcr2.cddAnt1 = DeliaAutoResponseCtsTcr2.cddAnt1 = cddVals.cddAnt1;
	DeliaAutoResponseTcr2.cddAnt2 = DeliaAutoResponseCtsTcr2.cddAnt2 = cddVals.cddAnt2;
	DeliaAutoResponseTcr2.cddAnt3 = DeliaAutoResponseCtsTcr2.cddAnt3 = cddVals.cddAnt3;
	
}
	
/**********************************************************************************


setCddnVapDbModificationFunc 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void setCddnVapDbModificationFunc(uint32* scratchPadAddress, void* functionParams)
{
	ProtectedDbModFuncCddParams_t* cddParams = (ProtectedDbModFuncCddParams_t*) functionParams;
	VapRateAdaptationParams_t* raStruct = (VapRateAdaptationParams_t*) scratchPadAddress;
	Tcr2_t* pTcr2 = &(raStruct->tcr2);

	/*Change TCR*/
	pTcr2->cddAnt1 = cddParams->cddVals.cddAnt1;
	pTcr2->cddAnt2 = cddParams->cddVals.cddAnt2;
	pTcr2->cddAnt3 = cddParams->cddVals.cddAnt3;
}

/**********************************************************************************

GetVapRateIndex


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
uint8 GetVapRateIndex(uint8 vapId , LaPacketType_e packetType, Bandwidth_e bandwidth)
{
	VapDb_t* vapDb = &VapDbHwEntries[vapId];
	uint32* dataTcr0SectionAddress = (uint32*)&(vapDb->common.word4);
	uint32* dataTcr3SectionAddress = (uint32*)&(vapDb->common.word5);
	uint32* managementTcr0SectionAddress = (uint32*)&(vapDb->common.word13);
	uint32* managementTcr3SectionAddress = (uint32*)&(vapDb->common.word14);
	Tcr0_t* pTcr0Data; 
	Tcr0_t* pTcr0Management;
	Tcr3_t* pTcr3Data; 
	Tcr3_t* pTcr3Management;
	PhyMode_e phyMode = PHY_MODE_LAST;
	uint8 rateField = 0;
	uint8 rateIndex;

	pTcr0Data = (Tcr0_t*)&dataTcr0SectionAddress[bandwidth<<1];
	pTcr3Data = (Tcr3_t*)&dataTcr3SectionAddress[bandwidth<<1];
	pTcr0Management = (Tcr0_t*)&managementTcr0SectionAddress[bandwidth<<1];
	pTcr3Management = (Tcr3_t*)&managementTcr3SectionAddress[bandwidth<<1];

	switch(packetType)
	{
	  case LA_PACKET_TYPE_DATA:
		  phyMode = (PhyMode_e)pTcr0Data->phyMode;
		  rateField = pTcr3Data->wpRate;
		  break;
	  case LA_PACKET_TYPE_MANAGEMENT:
		  phyMode = (PhyMode_e)pTcr0Management->phyMode;
		  rateField = pTcr3Management->wpRate;
		  break;
	  default:
		DEBUG_ASSERT(0)
	}	
	rateIndex = convertTcr2RateIndex(phyMode,rateField);

	return rateIndex;

}

/**********************************************************************************

setTcrinHwDb


Description:
------------
Function called by protected DB API and write all TCR params to HW DB

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void setTcrsInHwStaDb(uint32* scratchPadAddress, void* functionParams)
{
	LaTcrModificationStruct_t* pTcrModificationParams = (LaTcrModificationStruct_t*) functionParams;
	StaDbRateAdaptationParams_t* raStruct = (StaDbRateAdaptationParams_t*) scratchPadAddress;
	uint8 tcrBandwidthOffset;
	uint32* dataTcr0SectionAddress = (uint32*)&(raStruct->tcr020MhzData);
	uint32* managemntTcr0SectionAddress = (uint32*)&(raStruct->tcr020MhzManagement);
	Tcr0_t *pTcr0Data;
	Tcr0_t *pTcr0Mangement;
	Tcr3_t* pTcr3Data; 
	Tcr3_t* pTcr3Management; 
	Tcr2_t* pTcr2 = &(raStruct->tcr2);
	Tcr1_t* pTcr1Data=  &(raStruct->tcr1Data);
	Tcr1_t* pTcr1Managemenet=  &(raStruct->tcr1Management);
	uint8 wpAntMask[4];
	Bandwidth_e bandwidth;
	uint8 tcrRate;
	uint8 tcrPhyMode;
	StaDbRaExtensionWpParams_t*	pWorkingPointParams;
	const RateObj_t* ratesTable = getRatesTable(&LinkAdaptationStaDatabase[pTcrModificationParams->controlParams.staIndex].laStaUspCommon);
	uint8 maxNumOfRatesInTable =  getMaxNumOfRatesInTable(&LinkAdaptationStaDatabase[pTcrModificationParams->controlParams.staIndex].laStaUspCommon);
	CyclicPrefixMode_e cpMode;
	uint8 tcrCp;

	DEBUG_ASSERT(pTcrModificationParams->controlParams.uspIndex == INVALID_MU_USP_INDEX);

	DEBUG_ASSERT(pTcrModificationParams->controlParams.staIndex < HW_NUM_OF_STATIONS);
	DEBUG_ASSERT(pTcrModificationParams->tcrParams.tcrGeneralVals.tcrAntSelection > 0);

	pWorkingPointParams = &(StaDbHwEntries[pTcrModificationParams->controlParams.staIndex].raExtensionWpParams);


	/*Extract antenna selection per antenna mask*/
	wpAntMask[0] = (pTcrModificationParams->tcrParams.tcrGeneralVals.tcrAntSelection) & ANT_SELECTION_ONE_ANT_MASK;
	wpAntMask[1] = (pTcrModificationParams->tcrParams.tcrGeneralVals.tcrAntSelection >> 2) & ANT_SELECTION_ONE_ANT_MASK;;
	wpAntMask[2] = (pTcrModificationParams->tcrParams.tcrGeneralVals.tcrAntSelection >> 4) & ANT_SELECTION_ONE_ANT_MASK;;
	wpAntMask[3] = (pTcrModificationParams->tcrParams.tcrGeneralVals.tcrAntSelection >> 6) & ANT_SELECTION_ONE_ANT_MASK;;
	
	for (bandwidth = pTcrModificationParams->controlParams.firstBwToUpdate; bandwidth <= pTcrModificationParams->controlParams.lastBwToUpdate; bandwidth++)
	{
		cpMode = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].cpMode;
		tcrCp = convertCpModeToHtVhtCpTcrVal(cpMode);

		DEBUG_ASSERT(pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex < maxNumOfRatesInTable);

		tcrBandwidthOffset = (bandwidth << 1);
		
		/*Get phymode and rate according to rate index*/
		getTcrPhyModeAndRate(ratesTable, pTcrModificationParams->controlParams.isVhtSta,pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex,&tcrPhyMode, &tcrRate, FALSE, NO_DCM);

		if (pTcrModificationParams->controlParams.packetType == LA_PACKET_TYPE_DATA)
		{
			/*Set data TCRs for all BWs*/
			
			/*Set TCRs for all BWs*/
			pTcr0Data = (Tcr0_t *)&dataTcr0SectionAddress[tcrBandwidthOffset];
			pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[tcrBandwidthOffset + 1];

			pTcr0Data->phyMode = tcrPhyMode;
			pTcr0Data->bfMode = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrBfMode;
			pTcr0Data->rfPower = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrPower;
			pTcr0Data->antennaSelection = pTcrModificationParams->tcrParams.tcrGeneralVals.tcrAntSelection;
			pTcr3Data->rate = tcrRate;
			if ((tcrPhyMode == PHY_MODE_11N) || (tcrPhyMode == PHY_MODE_11AC))
			{
				pTcr3Data->scp = tcrCp;
			}	
			
			pTcr3Data->bfSmoothing = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].BfSmothing;

			if (pTcrModificationParams->controlParams.changeProbingPoint == FALSE)
			{
				/*Set WP parameters for all BWs*/
				pTcr0Data->wpPhyMode = tcrPhyMode;
				pTcr0Data->wpRfPower = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrPower;
				pTcr3Data->wpRate = tcrRate;
				if ((tcrPhyMode == PHY_MODE_11N) || (tcrPhyMode == PHY_MODE_11AC))
				{
					pTcr3Data->wpScp = tcrCp;
				}

				
				/*Clear probing bits - we may be moving to working point while waiting for probing*/
				raStruct->tcr1Management.altRateReasonFastProbing = 0;
				raStruct->tcr1Management.altRateReasonSlowProbing = 0;
			}
			else 
			{
				/*Set probing bit*/
				raStruct->tcr1Management.altRateReasonFastProbing = 1;
				raStruct->tcr1Management.altRateReasonSlowProbing = 1;
			}
				
		}
		else if (pTcrModificationParams->controlParams.packetType == LA_PACKET_TYPE_MANAGEMENT)
		{
			
			/*Set management TCRs for all BWs*/
			pTcr0Mangement = (Tcr0_t*)&managemntTcr0SectionAddress[tcrBandwidthOffset];
			pTcr3Management = (Tcr3_t *)&managemntTcr0SectionAddress[tcrBandwidthOffset + 1]; 

			pTcr0Mangement->phyMode = tcrPhyMode;
			pTcr0Mangement->bfMode = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrBfMode;
			pTcr0Mangement->rfPower = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrPower;
			pTcr0Mangement->antennaSelection = pTcrModificationParams->tcrParams.tcrGeneralVals.tcrAntSelection;
			pTcr3Management->rate = tcrRate;
			pTcr3Management->scp = tcrCp;
			pTcr3Management->bfSmoothing = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].BfSmothing;

		}
		else
		{
			DEBUG_ASSERT(0);
		}
	}
	
	if (pTcrModificationParams->controlParams.packetType == LA_PACKET_TYPE_DATA)
	{
		pTcr1Data->stbc = pTcrModificationParams->tcrParams.tcrGeneralVals.tcrStbcMode;	
		pTcr1Data->ldpc = pTcrModificationParams->tcrParams.tcrGeneralVals.ldpcMode;
	}
	else
	{
		pTcr1Managemenet->stbc = pTcrModificationParams->tcrParams.tcrGeneralVals.tcrStbcMode;
	}
	
	pTcr2->cddAnt1 = pTcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt1;
	pTcr2->cddAnt2 = pTcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt2;
	pTcr2->cddAnt3 = pTcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt3;
	
	if ((pTcrModificationParams->controlParams.changeProbingPoint== FALSE) && (pTcrModificationParams->controlParams.packetType == LA_PACKET_TYPE_DATA))
	{
		/*Set antenna selection WP values*/
		pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[(BANDWIDTH_TWENTY<<1) + 1];
		pTcr3Data->probingAntSelection = wpAntMask[0];

		pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[(BANDWIDTH_FOURTY<<1) + 1];
		pTcr3Data->probingAntSelection = wpAntMask[1];
		pTcr3Data->probingAntCdd = pTcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt1;

		pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[(BANDWIDTH_EIGHTY<<1) + 1];
		pTcr3Data->probingAntSelection = wpAntMask[2];
		pTcr3Data->probingAntCdd = pTcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt2;
		
		pTcr3Management = (Tcr3_t *)&managemntTcr0SectionAddress[(BANDWIDTH_TWENTY<<1) + 1]; 
		pTcr3Management->probingAntSelection = wpAntMask[3];
		pTcr3Management->probingAntCdd = pTcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt3;

		/*Those fields are not part of the protected DB but its only change when WP change and and affetced only on probing time*/
		pWorkingPointParams->wpStbc = pTcrModificationParams->tcrParams.tcrGeneralVals.tcrStbcMode;
		pWorkingPointParams->wpBfMode20Mhz = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_TWENTY].tcrBfMode;
		pWorkingPointParams->wpBfSmoothing20Mhz = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_TWENTY].BfSmothing;

		if (pTcrModificationParams->controlParams.lastBwToUpdate >= BANDWIDTH_FOURTY)
		{
			pWorkingPointParams->wpBfMode40Mhz = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_FOURTY].tcrBfMode;
			pWorkingPointParams->wpBfSmoothing40Mhz = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_FOURTY].BfSmothing;
			
		}
		if (pTcrModificationParams->controlParams.lastBwToUpdate == BANDWIDTH_EIGHTY)
		{
			pWorkingPointParams->wpBfMode80Mhz = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_EIGHTY].tcrBfMode;
			pWorkingPointParams->wpBfSmoothing80Mhz = pTcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_EIGHTY].BfSmothing;
		}

	}
//	SLOG0(0, 0, StaDbRateAdaptationParams_t, raStruct);

}




/**********************************************************************************

setTcrsInHwGroupDb



Description:
------------
Function called by protected DB API and write all TCR params to HW DB

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void setTcrsInHwGroupDb(uint32* scratchPadAddress, void* functionParams)
{
	LaTcrModificationStruct_t* pTcrModificationParams = (LaTcrModificationStruct_t*) functionParams;
	GroupDbRateAdaptationParams_t* raStruct = (GroupDbRateAdaptationParams_t*) scratchPadAddress;
	uint32* dataUsp0Tcr3Rate20MhzSectionAddress; 
	uint8* dataTcr3Rate20MhzAddress;
	uint8* wpTcr3Rate20MhzAddress;
	uint8* dataTcr3Scp20MhzAddress;
	uint8*	pTcrData;
	uint8 tcrPhyMode;
	Bandwidth_e bandwidth;
	uint8 tcrRate;
	const RateObj_t* ratesTable =  getRatesTable(&LinkAdaptationVhtGroupDatabase[pTcrModificationParams->controlParams.staIndex].laStaUspCommon[pTcrModificationParams->controlParams.uspIndex]);
	uint8 maxNumOfRatesInTable = getMaxNumOfRatesInTable(&LinkAdaptationVhtGroupDatabase[pTcrModificationParams->controlParams.staIndex].laStaUspCommon[pTcrModificationParams->controlParams.uspIndex]);
	uint8 tcrCp;
	
	DEBUG_ASSERT(pTcrModificationParams->controlParams.uspIndex != INVALID_MU_USP_INDEX); 
	DEBUG_ASSERT(pTcrModificationParams->controlParams.packetType == LA_PACKET_TYPE_DATA); 
	DEBUG_ASSERT(pTcrModificationParams->controlParams.uspIndex < MAX_USP_IN_VHT_GROUP);

	/*set dataTcr3Scp20MhzAddress pointer to bit 24 in word19 -scp20Mhz*/
	dataTcr3Scp20MhzAddress = (((uint8*)&(raStruct->word19))+WORD19_SCP_BYTE_OFFSET);  
	/*set usp0Tcr3Rate20Mhz pointer to word20 for usp0 (usp0Tcr3Rate20Mhz), word21 for usp1 (usp1Tcr3Rate20Mhz) etc..*/
	dataUsp0Tcr3Rate20MhzSectionAddress = ((uint32*)&(raStruct->word20)) + pTcrModificationParams->controlParams.uspIndex;
	/*set  dataTcr3Rate20MhzAddress point in byte resolution to  dataUsp0Tcr3Rate20MhzSectionAddress*/ 
	dataTcr3Rate20MhzAddress = (uint8*)dataUsp0Tcr3Rate20MhzSectionAddress;
	/*set  wpTcr3Rate20MhzAddress to word 24 for usp0 (usp0WpTcr3Rate20Mhz), 25 for usp1 (usp1WpTcr3Rate20Mhz) */ 
	wpTcr3Rate20MhzAddress = (uint8*)(((uint32*)&(raStruct->word24)) + pTcrModificationParams->controlParams.uspIndex) ;

	/*Set TCRs for all BWs*/
	for (bandwidth = pTcrModificationParams->controlParams.firstBwToUpdate; bandwidth <= pTcrModificationParams->controlParams.lastBwToUpdate; bandwidth++)
	{
		tcrCp = convertCpModeToHtVhtCpTcrVal(pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].cpMode);
		DEBUG_ASSERT(pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex < maxNumOfRatesInTable);
		/*Get phymode and rate according to rate index*/
		getTcrPhyModeAndRate(ratesTable, pTcrModificationParams->controlParams.isVhtSta,pTcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex,&tcrPhyMode, &tcrRate, FALSE, NO_DCM);
		/*Set pTcrData pointer to word20/21/22/23 (according to USP), with the correspond bandwith offset*/
		pTcrData = &dataTcr3Rate20MhzAddress[bandwidth];
		/*Set 6 lower bits(rate). For example-  USP0 BW20 would set USPuint32 usp0Tcr3Rate20Mhz : 6;*/
		SET_SIX_LS_BITS(pTcrData,tcrRate); 	
		/*Set bit spc bit in word 19 according to BW - bit 24 for 20Mhz ,bit 25 for 40Mhz ,bit 26 for 80Mhz )*/ 
		SET_BIT_IN_BYTE(dataTcr3Scp20MhzAddress,bandwidth,tcrCp);
		if (pTcrModificationParams->controlParams.changeProbingPoint == FALSE)
		{
			/*Set WP parameters for all BWs*/
			SET_SIX_LS_BITS(&(wpTcr3Rate20MhzAddress[bandwidth]),tcrRate);  /*Set 6 lower bits(rate). For example-  USP0 BW20 would set USPuint32 usp0WpTcr3Rate20Mhz : 6;*/
			/*Set bit WP spc bit in word 19 according to BW - bit 28 for 20Mhz ,bit 29 for 40Mhz ,bit 30 for 80Mhz )*/
			SET_BIT_IN_BYTE(dataTcr3Scp20MhzAddress,WP_SCP_BIT_OFFSET+bandwidth,tcrCp);
		}
	}
	if (pTcrModificationParams->controlParams.fastProbing == TRUE)
	{
		/*we may be moving to working point while waiting for probing: 
			Set fast probing bit (bit 22 ) in word  word20/21/22/23 according to USP */
		pTcrData = &dataTcr3Rate20MhzAddress[TWO_BYTE_OFFSET];
		SET_BIT_IN_BYTE(pTcrData,FAST_PROBING_BIT_INDEX, 1);  
	}
	else if (pTcrModificationParams->controlParams.slowProbing == TRUE)
	{
		/*we may be moving to working point while waiting for probing: 
			Set probing bit (bit 23) in word  word20/21/22/23 according to USP */
		pTcrData = &dataTcr3Rate20MhzAddress[TWO_BYTE_OFFSET];
		SET_BIT_IN_BYTE(pTcrData,SLOW_PROBING_BIT_INDEX, 1);  
	}
	else 
	{
		/*Clear probing bits - we may be moving to working point while waiting for probing
			reset probing bits (bit 22 and 23) in word  word20/21/22/23 according to USP */
		pTcrData = &dataTcr3Rate20MhzAddress[TWO_BYTE_OFFSET];
		SET_TWO_MS_BITS(pTcrData,0x0);  	
	}
//	SLOG0(0, 0, StaDbRateAdaptationParams_t, raStruct);
}


/**********************************************************************************

getMuTcrParamsFromHwDb



Description:
------------
Functino fills tcrModificationParams accordig to HW DB

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static	void getVhtMuTcrParamsFromHwDb(LaTcrModificationStruct_t* tcrModificationParams)
{
	MuGrpDb_t*  pGroupDbHwEntry = &(GroupDbHwEntries[tcrModificationParams->controlParams.staIndex]); // [NUM_GROUP_DBASE_ENTRIES];
	uint32* pTcr020MhzData = (&(pGroupDbHwEntry->word7));
	Tcr2_t*	pTcr2 = (Tcr2_t*)&(pGroupDbHwEntry->word10);
	uint8*	pTcr3Data;
	uint32*	tcr1DataPerUsp =  &((&(pGroupDbHwEntry->word15))[tcrModificationParams->controlParams.uspIndex]);
	uint8* 	pScp20Mhz = (uint8*)(&(pGroupDbHwEntry->word19))+WORD19_SCP_BYTE_OFFSET; 
	Bandwidth_e bandwidth;
	uint8 rateIndex;

	pTcr3Data =  (uint8*)(((uint32*)(&(pGroupDbHwEntry->word20)))+tcrModificationParams->controlParams.uspIndex);
	
	for (bandwidth = BANDWIDTH_TWENTY; bandwidth <= LinkAdaptationCommonConfiguration.wlanBandwidthMax; bandwidth++)
	{
		/*Fill data TCR parameters for all BWs*/
		DEBUG_ASSERT(tcrModificationParams->controlParams.packetType == LA_PACKET_TYPE_DATA); /**/ 
		rateIndex = convertTcr2RateIndex(PHY_MODE_11AC,GET_SIX_LS_BITS(pTcr3Data[bandwidth]));   //usp0Tcr3Rate20Mhz);
		tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrPower = ((*pTcr020MhzData) & RF_POWER_MASK) >>4; 
		tcrModificationParams->tcrParams.tcrGeneralVals.tcrAntSelection = ((*pTcr020MhzData) & ANTENNA_SELECTION_MASK) >>12;
		tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].cpMode = htVhtCpTcrValToCpMode[(*pScp20Mhz) & SCP_MASK]; 
		tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex = rateIndex;
		tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrBfMode = ((*pTcr020MhzData) & BF_MODE_MASK)>>10;
	}	
	tcrModificationParams->tcrParams.tcrGeneralVals.ldpcMode = (*tcr1DataPerUsp) & LDPC_MASK;
	tcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt1 = pTcr2->cddAnt1;
	tcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt2 = pTcr2->cddAnt2; 
	tcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt3 = pTcr2->cddAnt3;
}

/**********************************************************************************

getSuTcrParamsFromHwDb



Description:
------------
Functino fills tcrModificationParams accordig to HW DB

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void getSuTcrParamsFromHwDb(LaTcrModificationStruct_t* tcrModificationParams)
{
	StaDb_t* pStaDbHwEntry =  &StaDbHwEntries[tcrModificationParams->controlParams.staIndex];
	uint8 tcrBandwidthOffset;
	uint32* dataTcr0SectionAddress = (uint32*)&(pStaDbHwEntry->common.word4);
	uint32* managemntTcr0SectionAddress = (uint32*)&(pStaDbHwEntry->common.word13);
	Tcr0_t *pTcr0Data;
	Tcr0_t *pTcr0Mangement;
	Tcr3_t *pTcr3Data; 
	Tcr3_t *pTcr3Management; 
	Tcr1_t* pTcr1Data =  (Tcr1_t*)&(pStaDbHwEntry->common.word10);
 	Tcr1_t* pTcr1Managemenet =  (Tcr1_t* )&(pStaDbHwEntry->common.word12);
	StaDbRaExtensionWpParams_t*	pWorkingPointParams;
	uint8 wpAntMask[4];
	Bandwidth_e bandwidth;
	uint8 rateIndex;

	pWorkingPointParams = &(StaDbHwEntries[tcrModificationParams->controlParams.staIndex].raExtensionWpParams);

	
	for (bandwidth = BANDWIDTH_TWENTY; bandwidth <= LinkAdaptationCommonConfiguration.wlanBandwidthMax; bandwidth++)
	{
		tcrBandwidthOffset = (bandwidth << 1);
		
		if (tcrModificationParams->controlParams.packetType == LA_PACKET_TYPE_DATA)
		{
			/*Fill data TCR parameters for all BWs*/
			pTcr0Data = (Tcr0_t *)&dataTcr0SectionAddress[tcrBandwidthOffset];
			pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[tcrBandwidthOffset + 1];

			rateIndex = convertTcr2RateIndex((PhyMode_e)pTcr0Data->wpPhyMode,pTcr3Data->wpRate);

			tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrPower = pTcr0Data->wpRfPower; 
 			tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].cpMode = htVhtCpTcrValToCpMode[pTcr3Data->wpScp];
			tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex = rateIndex;

		}
		else if (tcrModificationParams->controlParams.packetType == LA_PACKET_TYPE_MANAGEMENT)
		{
			/*Fill management TCR parameters for all BWs*/

			pTcr0Mangement = (Tcr0_t*)&managemntTcr0SectionAddress[tcrBandwidthOffset];
			pTcr3Management = (Tcr3_t *)&managemntTcr0SectionAddress[tcrBandwidthOffset + 1]; 

			rateIndex = convertTcr2RateIndex((PhyMode_e)pTcr0Mangement->phyMode,pTcr3Management->rate);

			tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrPower = pTcr0Mangement->rfPower;
			tcrModificationParams->tcrParams.tcrGeneralVals.tcrAntSelection =  pTcr0Mangement->antennaSelection;
			tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].cpMode = htVhtCpTcrValToCpMode[pTcr3Management->scp];
			tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex = rateIndex;
			tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrBfMode = pTcr0Mangement->bfMode;
			tcrModificationParams->tcrParams.tcrGeneralVals.tcrStbcMode = pTcr1Managemenet->stbc;
			tcrModificationParams->tcrParams.bwDependedTcrValsTable[bandwidth].BfSmothing = pTcr3Management->bfSmoothing;

		}
		else
		{
			DEBUG_ASSERT(0);
		}
	}
	

	if (tcrModificationParams->controlParams.packetType == LA_PACKET_TYPE_DATA)
	{
		tcrModificationParams->tcrParams.tcrGeneralVals.ldpcMode = pTcr1Data->ldpc;

		/*Set antenna selection WP values*/
		pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[(BANDWIDTH_TWENTY<<1) + 1];
		wpAntMask[0] = pTcr3Data->probingAntSelection;

		pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[(BANDWIDTH_FOURTY<<1) + 1];
		wpAntMask[1] = pTcr3Data->probingAntSelection; 

		pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[(BANDWIDTH_EIGHTY<<1) + 1];
		wpAntMask[2] = pTcr3Data->probingAntSelection;
		
		pTcr3Management = (Tcr3_t *)&managemntTcr0SectionAddress[(BANDWIDTH_TWENTY<<1) + 1]; 
		wpAntMask[3]= pTcr3Management->probingAntSelection; 

		/*set antenna selection per antenna mask*/
		tcrModificationParams->tcrParams.tcrGeneralVals.tcrAntSelection = wpAntMask[0] | (wpAntMask[1] << 2)| (wpAntMask[2] << 4) | (wpAntMask[3] << 6);

		/*Set BF, smoothing , STBC from wp fields*/
 		tcrModificationParams->tcrParams.tcrGeneralVals.tcrStbcMode = pWorkingPointParams->wpStbc;
		tcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_TWENTY].tcrBfMode = pWorkingPointParams->wpBfMode20Mhz;
		tcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_TWENTY].BfSmothing = pWorkingPointParams->wpBfSmoothing20Mhz;

		if (tcrModificationParams->controlParams.lastBwToUpdate >= BANDWIDTH_FOURTY)
		{
			tcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_FOURTY].tcrBfMode = pWorkingPointParams->wpBfMode40Mhz;
			tcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_FOURTY].BfSmothing = pWorkingPointParams->wpBfSmoothing40Mhz; 
			
			if (tcrModificationParams->controlParams.lastBwToUpdate == BANDWIDTH_EIGHTY)
			{
				tcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_EIGHTY].tcrBfMode = pWorkingPointParams->wpBfMode80Mhz;
				tcrModificationParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_EIGHTY].BfSmothing = pWorkingPointParams->wpBfSmoothing80Mhz; 
			}

		}
	}
/*CDD is common to data and management*/
	/*Set antenna selection WP values*/
	pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[(BANDWIDTH_FOURTY<<1) + 1];
	tcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt1 = pTcr3Data->probingAntCdd;
	pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[(BANDWIDTH_EIGHTY<<1) + 1];
	tcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt2 = pTcr3Data->probingAntCdd;
	
	pTcr3Management = (Tcr3_t *)&managemntTcr0SectionAddress[(BANDWIDTH_TWENTY<<1) + 1]; 
	tcrModificationParams->tcrParams.tcrGeneralVals.cddVals.cddAnt3 = pTcr3Management->probingAntCdd;

	
}

/**********************************************************************************

getSuTcrParamsFromHwDb



Description:
------------
Functino fill tcrModificationParams accordig to HW DB

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void getTcrParamsFromHwDb(LaTcrModificationStruct_t* tcrModificationParams)
{
	if(tcrModificationParams->controlParams.uspIndex == INVALID_MU_USP_INDEX)
	{
		getSuTcrParamsFromHwDb(tcrModificationParams);
	}
	else /* MU*/
	{
		getVhtMuTcrParamsFromHwDb(tcrModificationParams);
	}
}
/**********************************************************************************

GetDataBwLimit

Description:
------------

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

Bandwidth_e GetDataBwLimit(StaId staOrGroupIndex,uint8 uspIndex, bool isHeGroup)
{
	UNUSED_PARAM(isHeGroup)
	if(uspIndex == INVALID_MU_USP_INDEX)
	{
		return (Bandwidth_e)StaDbHwEntries[staOrGroupIndex].common.dataBwLimit;
	}
	else /* MU*/
	{
		
		return (Bandwidth_e)(GroupDbHwEntries[staOrGroupIndex].dataBwLimit); 
	}
}

/**********************************************************************************

GetWpDataBwLimit


Description:
------------

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
Bandwidth_e GetWpDataBwLimit(StaId staOrGroupIndex,uint8 uspIndex, bool isHeGroup)
{
	if(uspIndex == INVALID_MU_USP_INDEX)
	{
		return (Bandwidth_e)StaDbHwEntries[staOrGroupIndex].raExtensionWpParams.wpDataBwLimit;
	}
	else /* MU*/
	{
		
		return (Bandwidth_e)(GroupDbHwEntries[staOrGroupIndex].wpDataBwLimit); 
	}
}

/**********************************************************************************

LinkAdaptationSetStaDataBwLimit


Description:
------------

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void SetStaDataBwLimitInHwDb(StaId staIndex,Bandwidth_e bandwidth, bool changeWorkingPoint)
{
	if (changeWorkingPoint == TRUE)
	{
#ifdef TRAINING_FIRST_PHASE_POOL 
		numberOfStationInBw[LinkAdaptationStaDatabase[staIndex].laStationUnique.vapId][bandwidth]++; 
		if(LinkAdaptationStaDatabase[staIndex].laStaGroupCommon.linkAdaptationState != LA_STA_NOT_CONNECT_RA_BYPASS)
		{
			/* In case this function isn't being called from linkAdaptationAddStationReq context, 
			when station is being set with BW at the first time - we have no BW entry to substruct from*/
			numberOfStationInBw[LinkAdaptationStaDatabase[staIndex].laStationUnique.vapId][StaDbHwEntries[staIndex].common.dataBwLimit]--; 
		}
#endif //TRAINING_FIRST_PHASE_POOL
		
		StaDbHwEntries[staIndex].raExtensionWpParams.wpDataBwLimit = bandwidth;
		LinkAdaptationStatistics.dataBwLimit[staIndex] = bandwidth;
	}
	StaDbHwEntries[staIndex].common.dataBwLimit = bandwidth;
}
/**********************************************************************************

LinkAdaptationSetGroupDataBwLimit



Description:
------------

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void setGroupDataBwLimit(uint8 groupIndex,Bandwidth_e bandwidth, bool changeWorkingPoint)
{
	if (changeWorkingPoint == TRUE)
	{
		GroupDbHwEntries[groupIndex].wpDataBwLimit = bandwidth;
	}
	LinkAdaptationMuStatistics.dataBwLimit[groupIndex] = bandwidth;
	GroupDbHwEntries[groupIndex].dataBwLimit = bandwidth; 
}

/**********************************************************************************

SetStaManagementBwLimit



Description:
------------

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void SetStaManagementBwLimit(StaId staIndex,Bandwidth_e bandwidth)
{
	StaDbHwEntries[staIndex].common._80211BwLimit= bandwidth;
}

/**********************************************************************************

bwAdaptationSetStationBwLimit 


Description:
------------
At each station's BW limit set, we update the number of stations working on a BW
This way we can cal

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void bwAdaptationSetStationBwLimit(StaId staId, Bandwidth_e bwLimit, bool changeWorkingPoint)
{
	StaDb_t* pStaDbHwEntry = &(StaDbHwEntries[staId]);
	LinkAdaptationStaDatabase_t* laDatabase = &LinkAdaptationStaDatabase[staId];
	Bandwidth_e changedDataBw;
	Bandwidth_e currentBwLimit = GetDataBwLimit(staId,INVALID_MU_USP_INDEX, FALSE);

	if((pStaDbHwEntry->common.tcr020MhzPhyModeData == PHY_MODE_11B) || (pStaDbHwEntry->common.tcr020MhzPhyModeData == PHY_MODE_11B))
	{
		changedDataBw = BANDWIDTH_TWENTY; 
	}
	else
	{
		changedDataBw = MIN(laDatabase->laStaGroupCommon.bwAdaptationDb.maxSupportedBw, bwLimit); 
	}

	if (changedDataBw != currentBwLimit)
	{
		LinkAdaptationSetStaDataBwLimit(staId,changedDataBw,changeWorkingPoint);
	}
}

/**********************************************************************************

bwAdaptationSetBwLimit 


Description:
------------
At each station's BW limit set, we update the number of stations working on a BW
This way we can cal

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void bwAdaptationSetBwLimit(LinkAdaptationDatabaseDistributionPack_t *pDistParam, Bandwidth_e bwLimit, bool changeWorkingPoint)
{
	Bandwidth_e changedDataBw;
	Bandwidth_e currentBwLimit = GetDataBwLimit(pDistParam->stationOrGroupIndex,pDistParam->uspIndex, FALSE);

	if(pDistParam->uspIndex == INVALID_MU_USP_INDEX)
	{
		StaDb_t* pStaDbHwEntry = &(StaDbHwEntries[pDistParam->stationOrGroupIndex]);
		if((pStaDbHwEntry->common.tcr020MhzPhyModeData == PHY_MODE_11B) || (pStaDbHwEntry->common._20MhzWpPhyModeData == PHY_MODE_11B))
		{
			changedDataBw = BANDWIDTH_TWENTY; 
		}
		else
		{
			changedDataBw = MIN(pDistParam->laStaGroupCommon->bwAdaptationDb.maxSupportedBw, bwLimit); 
		}
		if (changedDataBw != currentBwLimit)
		{
			LinkAdaptationSetStaDataBwLimit(pDistParam->stationOrGroupIndex,changedDataBw,changeWorkingPoint);
		}
	}
	else /*MU*/
	{
		changedDataBw = MIN(pDistParam->laStaGroupCommon->bwAdaptationDb.maxSupportedBw, bwLimit); 
		if (changedDataBw != currentBwLimit)
		{
		
			setGroupDataBwLimit(pDistParam->stationOrGroupIndex,changedDataBw,changeWorkingPoint);
		}
	}

	ILOG0_D("bwAdaptationSetBwLimit, changedDataBw = %d", changedDataBw);
}


#ifdef TRAINING_FIRST_PHASE_POOL
/**********************************************************************************

getMaximalWorkingBW 


Description:
------------
return the current maximal BW which at least one station is working with

Input: 
-----

Returns:
--------
	Bandwidth_e -  Bw index
	
**********************************************************************************/
void getMaximalWorkingBW(Bandwidth_e* maximalWorkingBw)
{
	uint8 vapId;

	for(vapId = 0; 	vapId < HW_NUM_OF_VAPS; vapId++)
	{
		if(numberOfStationInBw[vapId][BANDWIDTH_EIGHTY])
		{
			maximalWorkingBw[vapId] = BANDWIDTH_EIGHTY;
		}
		else if(numberOfStationInBw[vapId][BANDWIDTH_FOURTY])
		{
			maximalWorkingBw[vapId] = BANDWIDTH_FOURTY;
		}
		else
		{
			maximalWorkingBw[vapId] = BANDWIDTH_TWENTY;
		}
	}
}


/**********************************************************************************

decreaseMaxBwCount 


Description:
------------
reduce the current maximal BW which a station is not working with anymore

Input: 
-----

Returns:
--------
	
	
**********************************************************************************/
void decreaseMaxBwCount(StaId staIndex, Bandwidth_e bw)
{
	uint8 vapId = LinkAdaptationStaDatabase[staIndex].laStationUnique.vapId; 
	numberOfStationInBw[vapId][bw]--;
	return; 
}

#endif //TRAINING_FIRST_PHASE_POOL

/**********************************************************************************

explicitBfHandler 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void prepareExplicitMode(StaId staId)
{
	StaDbHwEntries[staId].common.bfRxMode = BF_RX_MODE_EXPLICIT_BEAMFORMER_AND_BEAMFORMEE;
	/*Configure Tx selector to send BF report*/
	if ((LinkAdaptationStaDatabase[staId].laStaUspCommon.probingPointValidationCounter == 0)||
		(LinkAdaptationStaDatabase[staId].laStaUspCommon.probingPointValidationCounter == 4)||
		(LinkAdaptationStaDatabase[staId].laStaUspCommon.probingPointValidationCounter == 8))
	{
		sendBfRequest(staId);	
	}
}

/**********************************************************************************

sendBfRequest 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void sendBfRequest(StaId staId)
{
	TxSelectorActionParams_t txSelectorActionparams;

	/*Configure TX selectior with BF sequence type*/
	txSelectorActionparams.queueType = HW_TX_Q_TYPE_STA_TID;
	txSelectorActionparams.stationOrVapNum = staId;
	txSelectorActionparams.tidOrAc = 0;
	txSelectorActionparams.allTids = TX_SELECTOR_SINGLE_TID_UPDATE; 
#ifdef SEND_BF_REQUEST_WITH_DATA
	txSelectorActionparams.action = TX_SELECTOR_ACTION_SEND_BF_WITH_DATA;
#else
	txSelectorActionparams.action = TX_SELECTOR_ACTION_SEND_BF_WITHOUT_DATA;
#endif //SEND_BF_REQUEST_WITH_DATA
	
	TxSelector_SetBfSequenceType(&txSelectorActionparams);

	/*Configure tx selector to send BF request*/
	txSelectorActionparams.action = TX_SELECTOR_ACTION_SEND_BF_REQUEST;

	TxSelector_SetBfSequenceRequest(&txSelectorActionparams);

}
/**********************************************************************************

stopSendBfRequest 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void stopSendBfRequest(StaId staId)
{
	TxSelectorActionParams_t txSelectorActionparams;

	/*Configure TX selectior with BF sequence type*/
	txSelectorActionparams.queueType = HW_TX_Q_TYPE_STA_TID;
	txSelectorActionparams.stationOrVapNum = staId;
	txSelectorActionparams.tidOrAc = 0;
	txSelectorActionparams.allTids = TX_SELECTOR_SINGLE_TID_UPDATE; 
#ifdef SEND_BF_REQUEST_WITH_DATA
	txSelectorActionparams.action = TX_SELECTOR_ACTION_SEND_BF_WITH_DATA;
#else
	txSelectorActionparams.action = TX_SELECTOR_ACTION_SEND_BF_WITHOUT_DATA;
#endif //SEND_BF_REQUEST_WITH_DATA
	
	TxSelector_SetBfSequenceType(&txSelectorActionparams);

	/*Configure tx selector to stop sending BF request*/
	txSelectorActionparams.action = TX_SELECTOR_ACTION_STOP_BF_REQUEST;

	TxSelector_SetBfSequenceRequest(&txSelectorActionparams);

}

/**********************************************************************************

prepareImplicitMode 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void prepareImplicitMode(StaId staId)
{
	StaDbHwEntries[staId].common.bfRxMode = BF_RX_MODE_EXPLICIT_BEAMFORMEE;
}

/**********************************************************************************

prepareStbc1x2Mode 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void prepareStbc1x2Mode(StaId staId)
{
	stopSendBfRequest(staId);
}
/**********************************************************************************

prepareStbc2x4Mode 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void prepareStbc2x4Mode(StaId staId)
{
	stopSendBfRequest(staId);
}
/**********************************************************************************

prepareNoBfMode 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void prepareNoBfMode(StaId staId)
{
	stopSendBfRequest(staId);
}

/**********************************************************************************

explicitBfHandler 


Description:
------------
Check BF DB valid if EXPLICIT or IMPLICIT state

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

bool isBeamFormingReadyForTransmit(StaId staIndex, BeamformingMode_e bfState)
{
	bool retVal = FALSE;
	StaDb_t* pStaDbHwEntry = &(StaDbHwEntries[staIndex]);
	
	if ((bfState==BF_STATE_EXPLICIT)||(bfState==BF_STATE_IMPLICIT))
	{
		retVal = (pStaDbHwEntry->common.bfDbValid == TRUE);
	}
	else
	{
		retVal = TRUE;
	}
	return retVal;
}
/**********************************************************************************

initExplicitBfStaCapabilities 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void initExplicitBfStaCapabilities(StaId staIndex, HtCapabilitiesInfo_t htCapbilities, sVHT_CAPABILITIES_INFO vhtCapabilities, HE_MAC_PHY_CAPABILITIES_INFO* pHeMacPhyCapabilities, sTransmitBfCapInfo transmitBfCapabilities)
{
	uint8 higherRateindex;
	LinkAdaptationStaDatabase_t* pLinkAdaptationDb = &LinkAdaptationStaDatabase[staIndex];
	StaDb_t* pStaDbHwEntry =  &StaDbHwEntries[staIndex];
	uint8 higherNss;
	//LaFixedBeamformingParams_t* pLocalBfDebugParams = getBfDebugParams();
	bool isVhtSta = pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.vhtSta;
	uint8 activatedAntennasCount = AntennaSelectionGetActivatedAntennasCount();
	const RateObj_t* ratesTable = getRatesTable(&pLinkAdaptationDb->laStaUspCommon);
	
	
	higherRateindex = getHighestRateinMask(staIndex, pLinkAdaptationDb->laStaUspCommon.raIndexMask, BANDWIDTH_TWENTY, 0, MAX_VHT_SORT_RATE_INDEX);
	higherNss = ratesTable[higherRateindex].numberOfNss;
	/* DW3  - Beam forming parameters */
	pStaDbHwEntry->common.bfRxHwFwMode = BF_DB_UPDATE_MODE_HW;
	pStaDbHwEntry->common.bfMinimalGrouping = MINIMAL_GROUPING_1_2_4; 
	/* Remember the STA's capability in case COC increases the number of antennas */
	pStaDbHwEntry->common.maxNssNdpStaCapability = (isVhtSta) ? vhtCapabilities.beamformee_sts_capability:transmitBfCapabilities.compressed_steering_number_of_beamformer_antennas_supported;
	/* Transmit NDP cannot use more antennas than AP uses (phy gets stuck): */
	pStaDbHwEntry->common.maxNssNdp = MIN(pStaDbHwEntry->common.maxNssNdpStaCapability, activatedAntennasCount);
	pStaDbHwEntry->common.maxNssTx = higherNss;  // maximum number of Spatial streams supported by Station.		  			     [9:8] 
	pStaDbHwEntry->common.bfMfbUpdating = HW_MCS_FEEDBACK_UPDATING_ENABLED; 
	pStaDbHwEntry->common.bfAgingRegisterIndex = BF_AGING_MODE_MEDIUM_1;
	pStaDbHwEntry->common.nonStandardImplicitBfRulesTableIndex = isVhtSta ? MAC_BF_BF_NONSTANDARD_IMP_RULES_INDX_VHT_STA : MAC_BF_BF_NONSTANDARD_IMP_RULES_INDX_HT_STA;
	pStaDbHwEntry->common.bfDbValid = BF_DB_NOT_VALID; 
	pStaDbHwEntry->common.bfAgingStatus = BF_DB_AGING_STATUS_OLD;
	pStaDbHwEntry->common.mfbValid = MCS_FEEDBACK_NOT_VALID; 
	pStaDbHwEntry->common.bfRxMode = BF_RX_MODE_EXPLICIT_BEAMFORMER_AND_BEAMFORMEE;
}

/**********************************************************************************
LinkAdaptationPhyDriver_Init 


Description:
------------

	
Input: 
-----
	None
	
**********************************************************************************/
#if defined (ENET_INC_LMAC)
#pragma ghs section text=".initialization" 
#endif
void LinkAdaptationPhyDriver_Init(void)
{
	memset(&DeliaAutoResponseTcr0, 0, sizeof(Tcr0_t));
	memset(&DeliaAutoResponseTcr2, 0, sizeof(Tcr2_t));
	memset(&DeliaAutoResponseCtsTcr2, 0, sizeof(Tcr2_t));

    //This is a patch till a static table of RF power will be configured in the shram
	DeliaAutoResponseTcr0.rfPower = 32;
	DeliaAutoResponseTcr0.bfMode = HW_BF_MODE_FLAT_BEAMFORMING;

	//init RtsMode global parameter which is used each ADD_STATION to configure staDBentry
	LinkAdaptationRtsMode.dynamicBw = FALSE;
	LinkAdaptationRtsMode.staticBw = FALSE;

#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND
	LinkAdaptationPhyDriver_UpdatePhyGenriscScpad();
#endif //DYNAMIC_RTS_ISSUE_WORKAROUND	
}
#if defined (ENET_INC_LMAC)
#pragma ghs section text=default
#endif

#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND
void LinkAdaptationPhyDriver_UpdatePhyGenriscScpad()
{
	Tcr0_t* phyGenriscScpadstartaddr = (Tcr0_t*)MEM_SCR_BUF_START;
	Tcr0_t deliaAutoResponseCurrentTcr0;
	uint8 rate, bw = 0;

	//copy template to currentTcr0 in order to fill it each loop iteration with the corect parameters
	memcpy(&deliaAutoResponseCurrentTcr0, &DeliaAutoResponseTcr0, sizeof(Tcr0_t));
	//fill phy genric scpad
	//loop per bw per mcs (mcs7 is the maximal for legacy phy mode)
	for(bw = BANDWIDTH_TWENTY; bw < MAX_NUM_OF_BW; bw++)
	{
		for(rate = 0; rate < LM_PHY_11A_MAX_RATES; rate++)
		{
			deliaAutoResponseCurrentTcr0.bw = bw;
			switch (bw)
			{
				case BANDWIDTH_TWENTY:
					deliaAutoResponseCurrentTcr0.rfPower = PacDurRam->autoReplyPower[rate].bitFields.txPower11AGBw20;
					break;
				case BANDWIDTH_FOURTY:
					deliaAutoResponseCurrentTcr0.rfPower = PacDurRam->autoReplyPower[rate].bitFields.txPower11AGBw40;
					break;
				case BANDWIDTH_EIGHTY:
					deliaAutoResponseCurrentTcr0.rfPower = PacDurRam->autoReplyPower[rate].bitFields.txPower11AGBw80;
					break;
				case BANDWIDTH_ONE_HUNDRED_SIXTY:
					deliaAutoResponseCurrentTcr0.rfPower = PacDurRam->autoReplyPower[rate].bitFields.txPower11AGBw160;
					break;
				default:

					//FATAL("LinkAdaptationPhyDriver_UpdatePhyGenriscScpad");
			}
			*phyGenriscScpadstartaddr = deliaAutoResponseCurrentTcr0;			
			phyGenriscScpadstartaddr++;
		}
	}
}
#endif //DYNAMIC_RTS_ISSUE_WORKAROUND

void setMaxBytesPerRate(StaId staIndex, uint16 rateIndex)
{
}

/**********************************************************************************

setTransmissionTimeParams 


Description:
------------

	
Input: 
-----
	None
	
**********************************************************************************/
void setTransmissionTimeParams()
{
	uint8 rateIndex;
	StaId nextSid = LmStaDataBase.headIndexOfStaLinkList;
	
	if (AggRateLimitMode == TRUE)
	{
		// Client Isolation is enabled
		while (nextSid != DB_ASYNC_SID)
		{
			DEBUG_ASSERT(nextSid < HW_NUM_OF_STATIONS);
			
			rateIndex = estimatorsGetWorkingPointRateIndexOfMainBw(&(LinkAdaptationStaDatabase[nextSid].laStaUspCommon));
			updateTransmissionTimeParams(nextSid, rateIndex);
			
			nextSid = StaDbSwEntries[nextSid].nextSid;
		}
	}
}

/**********************************************************************************

convertTcrVal2Power 


Description:
------------

Input: 
-----
Returns:
--------
	
**********************************************************************************/

uint8 convertTcrVal2Power(Bandwidth_e bandwidth, uint8 tcrVal)
{
	return tcrVal;
}
/**********************************************************************************

BeamformingSetDebugMaxNdp 


Description:
------------

	
Input: 
-----
	None
	
**********************************************************************************/

void BeamformingSetDebugMaxNdp(StaId staIndex)
{
	StaDb_t* pStaDbHwEntry =  &StaDbHwEntries[staIndex];
	LaFixedBeamformingParams_t* pLocalBfDebugParams = getBfDebugParams();

	pStaDbHwEntry->common.maxNssNdp = pLocalBfDebugParams->maxNssNdp;
}
/**********************************************************************************

GetStaWpRateIndexFromHwTcr 


Description:
------------

	
Input: 
-----
	None
	
**********************************************************************************/

uint8 GetStaWpRateIndexFromHwTcr(StaId staIndex, Bandwidth_e bandwidth)
{
	StaDb_t* pStaDbHwEntry =  &StaDbHwEntries[staIndex];
	uint8 tcrBandwidthOffset;
	uint32* dataTcr0SectionAddress = (uint32*)&(pStaDbHwEntry->common.word4);
	Tcr0_t *pTcr0Data;
	Tcr3_t *pTcr3Data; 
	uint8 rateIndex;
	
	tcrBandwidthOffset = (bandwidth << 1);
	
	/*Fill data TCR parameters for all BWs*/
	pTcr0Data = (Tcr0_t *)&dataTcr0SectionAddress[tcrBandwidthOffset];
	pTcr3Data = (Tcr3_t *)&dataTcr0SectionAddress[tcrBandwidthOffset + 1];

	rateIndex = convertTcr2RateIndex((PhyMode_e)pTcr0Data->wpPhyMode,pTcr3Data->wpRate);
	return rateIndex;
}


/**********************************************************************************

isBfReportNotReceivedAfterRequest 


Description:
------------
if BF request has sent without response, return TRUE otherwize return FALSE

	
Input: 
-----
	None
	
**********************************************************************************/

bool isBfReportNotReceivedAfterRequest(StaId staIndex)
{
	bool retVal = FALSE;
	
	//if BF request has sent without response, return TRUE otherwize return FALSE
#ifdef SEND_BF_REQUEST_WITH_DATA
	/*BF request sent without PHY NDP or with data after it  => BF sequcnce failed*/
	if ((CurrentSequencerReport.executedBfReq) &&
		(((CurrentSequencerReport.executedPhyNdp)==0) ||
		((CurrentSequencerReport.executedData) == 0)))
	{
		retVal = TRUE;
	}
	else if ((CurrentSequencerReport.executedBfReq) &&
			((CurrentSequencerReport.executedPhyNdp)) &&
			((CurrentSequencerReport.executedData)))
	{
		LinkAdaptationStatistics.bfReportReceivedCounter++; //LINK_ADAPTATION_BF_REPORT_RECEIVED_COUNTER;
	}
#else // SEND_BF_REQUEST_WITHOUT_DATA
	/*BF request NDPA sent but without PHY NDP or there was  timout or other RX after it  => BF sequcnce failed*/
	if ((CurrentSequencerReport.executedBfReq) &&
		(((CurrentSequencerReport.executedPhyNdp)==0) ||
		(((CurrentSequencerReport.timeout & USER_POS_0_MASK) == USER_POS_0_MASK) && (CurrentSequencerReport.bfIteration == TX_SEQUENCER_MAX_NUM_OF_BF_ITER)) ||
		((CurrentSequencerReport.otherRx & USER_POS_0_MASK) == USER_POS_0_MASK) ||
		(((CurrentSequencerReport.timeout & USER_POS_0_MASK) == USER_POS_0_MASK) && (!(CurrentSequencerReport.cca20PFree)))))
	{
		retVal = TRUE;
	}
	else if	((CurrentSequencerReport.executedBfReq) &&
			((CurrentSequencerReport.executedPhyNdp)) &&
			(((CurrentSequencerReport.timeout & USER_POS_0_MASK) == 0) || (CurrentSequencerReport.bfIteration < TX_SEQUENCER_MAX_NUM_OF_BF_ITER)) &&
			((CurrentSequencerReport.otherRx & USER_POS_0_MASK) == 0))
	{
		LinkAdaptationStatistics.bfReportReceivedCounter++; //LINK_ADAPTATION_BF_REPORT_RECEIVED_COUNTER;
	}
#endif

	return retVal;
}


void linkAdaptationUpdateCalStatistics(K_MSG *psMsg)
{
	LinkAdaptationCalibrationStatus_t* pCalibrationStatistics = (LinkAdaptationCalibrationStatus_t*)psMsg->abData;
	uint8 ant, BFTypes;
	
	for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
	{
		LinkAdaptationStatistics.rxDc[ant]= pCalibrationStatistics->rxDc[ant];
		LinkAdaptationStatistics.txLo[ant]= pCalibrationStatistics->txLo[ant];
		LinkAdaptationStatistics.rxIq[ant]= pCalibrationStatistics->rxIq[ant];
		LinkAdaptationStatistics.txIq[ant]= pCalibrationStatistics->txIq[ant];
		//ILOG0_DDDD("Statistics rxdc:%d, txlo:%d, rxiq:%d, txiq:%d",LinkAdaptationStatistics.rxDc[ant],LinkAdaptationStatistics.txLo[ant],LinkAdaptationStatistics.rxIq[ant],LinkAdaptationStatistics.txIq[ant]);
	}
	for ( BFTypes = AFE; BFTypes < MAX_NUMBER_OF_BF_CALS; BFTypes++)
	{
		LinkAdaptationStatistics.bf[BFTypes] = pCalibrationStatistics->BF[BFTypes];
	}
	
}
/**********************************************************************************

Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void updateLaStatistics(LaTcrModificationStruct_t* pTransmissionParams)
{
	Bandwidth_e bandwidth;
	uint8 tcrRate;
	uint8 tcrPhyMode;
	uint8 tempMcs;
	uint8 tempNss;
	const RateObj_t* ratesTable;
	uint8 maxNumOfRatesInTable;
	UNUSED_PARAM(maxNumOfRatesInTable);
	
	if(pTransmissionParams->controlParams.uspIndex != INVALID_MU_USP_INDEX)
	{
		ratesTable = getRatesTable(&LinkAdaptationVhtGroupDatabase[pTransmissionParams->controlParams.staIndex].laStaUspCommon[pTransmissionParams->controlParams.uspIndex]);		
		for (bandwidth = pTransmissionParams->controlParams.firstBwToUpdate; bandwidth <= pTransmissionParams->controlParams.lastBwToUpdate; bandwidth++)
		{
			LinkAdaptationMuStatistics.scpData[pTransmissionParams->controlParams.staIndex][bandwidth] = convertCpModeToHtVhtCpTcrVal(pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].cpMode); //LINK_ADAPTATION_SCP_DATA
			LinkAdaptationMuStatistics.powerData[pTransmissionParams->controlParams.staIndex][bandwidth] = pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrPower; //LINK_ADAPTATION_POWER_DATA
		}
		tempMcs = ratesTable[pTransmissionParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_EIGHTY].rateindex].vhtHeMcs;	
		tempNss = ratesTable[pTransmissionParams->tcrParams.bwDependedTcrValsTable[BANDWIDTH_EIGHTY].rateindex].numberOfNss;
		
		LinkAdaptationMuStatistics.nssData[pTransmissionParams->controlParams.staIndex][pTransmissionParams->controlParams.uspIndex] = tempNss+1; //LINK_ADAPTATION_NSS_DATA (start from 1)
		LinkAdaptationMuStatistics.mcsData[pTransmissionParams->controlParams.staIndex][pTransmissionParams->controlParams.uspIndex] = tempMcs; //LINK_ADAPTATION_MCS_DATA
		LinkAdaptationMuStatistics.dataBwLimit[pTransmissionParams->controlParams.staIndex] = GroupDbHwEntries[pTransmissionParams->controlParams.staIndex].dataBwLimit;
	}
	else /*SU*/
	{
		DEBUG_ASSERT(pTransmissionParams->controlParams.staIndex < HW_NUM_OF_STATIONS);
		
		ratesTable = getRatesTable(&LinkAdaptationStaDatabase[pTransmissionParams->controlParams.staIndex].laStaUspCommon);
		maxNumOfRatesInTable = getMaxNumOfRatesInTable(&LinkAdaptationStaDatabase[pTransmissionParams->controlParams.staIndex].laStaUspCommon);
		for (bandwidth = pTransmissionParams->controlParams.firstBwToUpdate; bandwidth <= pTransmissionParams->controlParams.lastBwToUpdate; bandwidth++)
		{
			DEBUG_ASSERT(pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex < maxNumOfRatesInTable);
			
			/*Get phymode and rate according to rate index*/
			getTcrPhyModeAndRate(ratesTable, pTransmissionParams->controlParams.isVhtSta,pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex,&tcrPhyMode, &tcrRate, FALSE, NO_DCM);

			if (tcrPhyMode == PHY_MODE_11AC)
			{
				tempMcs = ratesTable[pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex].vhtHeMcs;		
			}
			else
			{
				tempMcs = ratesTable[pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex].htMcs;
			}
			tempNss = ratesTable[pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex].numberOfNss;

			if (pTransmissionParams->controlParams.packetType == LA_PACKET_TYPE_DATA)
			{
				/*Set Statistics Data TCRs for all BWs*/
				LinkAdaptationStatistics.DataPhyMode[pTransmissionParams->controlParams.staIndex][bandwidth] = tcrPhyMode; //LINK_ADAPTATION_DATA_PHY_MODE
				LinkAdaptationStatistics.scpData[pTransmissionParams->controlParams.staIndex][bandwidth] = convertCpModeToHtVhtCpTcrVal(pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].cpMode); //LINK_ADAPTATION_SCP_DATA
				LinkAdaptationStatistics.stbcModeData[pTransmissionParams->controlParams.staIndex] = pTransmissionParams->tcrParams.tcrGeneralVals.tcrStbcMode; //LINK_ADAPTATION_STBC_MODE_DATA 
				LinkAdaptationStatistics.bfModeData[pTransmissionParams->controlParams.staIndex] = pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrBfMode; //LINK_ADAPTATION_BF_MODE_DATA
				LinkAdaptationStatistics.powerData[pTransmissionParams->controlParams.staIndex][bandwidth] = pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrPower; //LINK_ADAPTATION_POWER_DATA
				LinkAdaptationStatistics.antennaSelectionData[pTransmissionParams->controlParams.staIndex][bandwidth] = pTransmissionParams->tcrParams.tcrGeneralVals.tcrAntSelection; //LINK_ADAPTATION_ANTENNA_SELECTION_DATA
				LinkAdaptationStatistics.nssData[pTransmissionParams->controlParams.staIndex][bandwidth] = tempNss+1; //LINK_ADAPTATION_NSS_DATA (start from 1)
				LinkAdaptationStatistics.mcsData[pTransmissionParams->controlParams.staIndex][bandwidth] = tempMcs; //LINK_ADAPTATION_MCS_DATA
				LinkAdaptationStatistics.dataBwLimit[pTransmissionParams->controlParams.staIndex] = StaDbHwEntries[pTransmissionParams->controlParams.staIndex].common.dataBwLimit; //LINK_ADAPTATION_DATA_BW_LIMIT
			}
			else if (pTransmissionParams->controlParams.packetType == LA_PACKET_TYPE_MANAGEMENT)
			{
				
				/*Set Statistics Management TCRs for all BWs*/
				LinkAdaptationStatistics.ManagementPhyMode[pTransmissionParams->controlParams.staIndex][bandwidth] = tcrPhyMode; //LINK_ADAPTATION_MANAGEMENT_PHY_MODE
				LinkAdaptationStatistics.powerManagement[pTransmissionParams->controlParams.staIndex][bandwidth] = pTransmissionParams->tcrParams.bwDependedTcrValsTable[bandwidth].tcrPower; //LINK_ADAPTATION_POWER_MANAGEMENT
				LinkAdaptationStatistics.antennaSelectionManagement[pTransmissionParams->controlParams.staIndex][bandwidth] = pTransmissionParams->tcrParams.tcrGeneralVals.tcrAntSelection; //LINK_ADAPTATION_ANTENNA_SELECTION_MANAGEMENT
				LinkAdaptationStatistics.nssManagement[pTransmissionParams->controlParams.staIndex][bandwidth] = tempNss; //LINK_ADAPTATION_NSS_MANAGEMENT
				LinkAdaptationStatistics.mcsManagement[pTransmissionParams->controlParams.staIndex][bandwidth] = tempMcs; //LINK_ADAPTATION_MCS_MANAGEMENT
			}
			else
			{
				DEBUG_ASSERT(0);
			}
		}
	
	}
}

void UpdateStationMaxSupportedNss(StaId staIndex, SpatialStreamNum_e maxNss)
{
	StaDb_t* pStaDbHwEntry =  NULL;
	uint8 activatedAntennasCount = AntennaSelectionGetActivatedAntennasCount();

	DEBUG_ASSERT(staIndex < HW_NUM_OF_STATIONS);
	
	pStaDbHwEntry = &StaDbHwEntries[staIndex];
	
	/* Training Manager MAX NSS */
	pStaDbHwEntry->common.maxSupportedNss = maxNss;

	/* Update Max NSS supported by STA */
	pStaDbHwEntry->common.maxNssTx = maxNss;

	/* Update Max NSS NDP: */
	/* Transmit NDP cannot use more antennas than AP uses (phy gets stuck): */
	pStaDbHwEntry->common.maxNssNdp = MIN(pStaDbHwEntry->common.maxNssNdpStaCapability, activatedAntennasCount);	
}

void UpdateVapMaxNssNdp(uint8 vapIdx, SpatialStreamNum_e maxNss)
{
	VapDb_t* pVapDbHwEntry =  NULL;

	DEBUG_ASSERT(vapIdx < HW_NUM_OF_VAPS);
	
	pVapDbHwEntry = &VapDbHwEntries[vapIdx];
	pVapDbHwEntry->common.maxNssNdp = maxNss;
}

void linkAdaptationSetMsduInAmsdu(K_MSG* psMsg)
{
	UMI_MSDU_IN_AMSDU_CONFIG *pLaMsduInAmsduConfigMsg = (UMI_MSDU_IN_AMSDU_CONFIG*)pK_MSG_DATA(psMsg);
	StaId nextSid = LmStaDataBase.headIndexOfStaLinkList;
	uint8 msduInAmsdu;

	if (pLaMsduInAmsduConfigMsg->getSetOperation == API_GET_OPERATION)
	{
		pLaMsduInAmsduConfigMsg->htMsduInAmsdu = laHtMsduInAmsdu;
		pLaMsduInAmsduConfigMsg->vhtMsduInAmsdu = laVhtMsduInAmsdu;
	}
	else
	{
		laHtMsduInAmsdu = pLaMsduInAmsduConfigMsg->htMsduInAmsdu;
		laVhtMsduInAmsdu = MIN(pLaMsduInAmsduConfigMsg->vhtMsduInAmsdu, VHT_MAX_MSDU_IN_AMSDU);
	}
	
	while (nextSid != DB_ASYNC_SID)
	{
		if (LinkAdaptationStaDatabase[nextSid].laStaUspCommon.staTransmissionParams.vhtSta == TRUE)
		{
			msduInAmsdu = 	laVhtMsduInAmsdu;
		}
		else
		{
			msduInAmsdu = 	laHtMsduInAmsdu;
		}
		StaDbHwEntries[nextSid].common.maxMsduAtAmsduCount = msduInAmsdu;
		nextSid = StaDbSwEntries[nextSid].nextSid;
	}
}

void linkAdaptationSetPpduTxMode(uint8 ppduTxMode)
{
	laPpduTxMode = ppduTxMode;
}



void  linkAdaptationSetRtsMode(UMI_RTS_MODE_CONFIG *pRtsModeConfigMsg)
{
	StaId nextSid = LmStaDataBase.headIndexOfStaLinkList;
	StaDb_t* pStaDbHwEntry = NULL;
	
	if (pRtsModeConfigMsg->getSetOperation == API_GET_OPERATION)
	{
		pRtsModeConfigMsg->dynamicBw = LinkAdaptationRtsMode.dynamicBw;
		pRtsModeConfigMsg->staticBw = LinkAdaptationRtsMode.staticBw;
	}
	else
	{
		ASSERT(!((pRtsModeConfigMsg->dynamicBw) && (pRtsModeConfigMsg->staticBw)));
		/*First set global flag - all new STAs will use this value*/
		LinkAdaptationRtsMode.dynamicBw = pRtsModeConfigMsg->dynamicBw;
		LinkAdaptationRtsMode.staticBw= pRtsModeConfigMsg->staticBw;
		
		/*Now loop thru connected STAs and change the value*/
		
		
		while (nextSid != DB_ASYNC_SID)
		{
			//check if station supports VHT and update DB if so
		
			if(LinkAdaptationStaDatabase[nextSid].laStaUspCommon.staTransmissionParams.vhtSta)
			{			
				pStaDbHwEntry =  &(StaDbHwEntries[nextSid]);
				pStaDbHwEntry->common.dynamicBwEnable = pRtsModeConfigMsg->dynamicBw;
				pStaDbHwEntry->common.staticBwEnable= pRtsModeConfigMsg->staticBw;	
			}
			nextSid = StaDbSwEntries[nextSid].nextSid;
		}
	}
}
void setAntBoostInStaTcr(StaId staId, uint8* antBoostTable)
{
	StaDb_t* pStaDbHwEntry = &(StaDbHwEntries[staId]);

	pStaDbHwEntry->common.tcr2Ant0Boost = antBoostTable[0];
	pStaDbHwEntry->common.tcr2Ant1Boost = antBoostTable[1];
	pStaDbHwEntry->common.tcr2Ant2Boost = antBoostTable[2];
	pStaDbHwEntry->common.tcr2Ant3Boost = antBoostTable[3];
}

void setAntBoostInVapTcr(uint8 vapId, uint8* antBoostTable)
{
	Tcr0_t* pVapDbHwEntryTcr0 = (Tcr0_t*)&(VapDbHwEntries[vapId].common.word4);
	Tcr2_t* pVapDbHwEntryTcr2 = (Tcr2_t*)&(VapDbHwEntries[vapId].common.word11);
	Tcr2_t* vapTcr2Tamplate1 = (Tcr2_t*)&(VapDbHwEntries[vapId].tcrTemplates.word2);
	Tcr0_t* vapTcr0Tamplate1 = (Tcr0_t*)&(VapDbHwEntries[vapId].tcrTemplates.word0);

	Tcr2_t* vapTcr2Tamplate2 = (Tcr2_t*)&(VapDbHwEntries[vapId].tcrTemplates.word6);
	Tcr2_t* vapTcr2Tamplate3 = (Tcr2_t*)&(VapDbHwEntries[vapId].tcrTemplates.word10);
	Tcr2_t* vapTcr2Tamplate4 = (Tcr2_t*)&(VapDbHwEntries[vapId].tcrTemplates.word14);

	if (pVapDbHwEntryTcr0->phyMode != PHY_MODE_11B)
	{
		pVapDbHwEntryTcr2->ant0Boost = antBoostTable[0];
		pVapDbHwEntryTcr2->ant1Boost = antBoostTable[1];
		pVapDbHwEntryTcr2->ant2Boost = antBoostTable[2];
		pVapDbHwEntryTcr2->ant3Boost = antBoostTable[3];
 	}
	else
	{
 		pVapDbHwEntryTcr2->ant0Boost = 0;
		pVapDbHwEntryTcr2->ant1Boost = 0;
		pVapDbHwEntryTcr2->ant2Boost = 0;
		pVapDbHwEntryTcr2->ant3Boost = 0;
	}
	if (vapTcr0Tamplate1->phyMode != PHY_MODE_11B)
	{
		/*Template 1*/
		vapTcr2Tamplate1->ant0Boost = antBoostTable[0];
		vapTcr2Tamplate1->ant1Boost = antBoostTable[1];
		vapTcr2Tamplate1->ant2Boost = antBoostTable[2];
		vapTcr2Tamplate1->ant3Boost = antBoostTable[3];
 	}
	else
	{
 		vapTcr2Tamplate1->ant0Boost = 0;
		vapTcr2Tamplate1->ant1Boost = 0;
		vapTcr2Tamplate1->ant2Boost = 0;
		vapTcr2Tamplate1->ant3Boost = 0;
	}
	/*Template 2*/
	vapTcr2Tamplate2->ant0Boost = antBoostTable[0];
	vapTcr2Tamplate2->ant1Boost = antBoostTable[1];
	vapTcr2Tamplate2->ant2Boost = antBoostTable[2];
	vapTcr2Tamplate2->ant3Boost = antBoostTable[3];
	
	/*Template 3*/
	vapTcr2Tamplate3->ant0Boost = antBoostTable[0];
	vapTcr2Tamplate3->ant1Boost = antBoostTable[1];
	vapTcr2Tamplate3->ant2Boost = antBoostTable[2];
	vapTcr2Tamplate3->ant3Boost = antBoostTable[3];

	/*Template 4*/
	vapTcr2Tamplate4->ant0Boost = antBoostTable[0];
	vapTcr2Tamplate4->ant1Boost = antBoostTable[1];
	vapTcr2Tamplate4->ant2Boost = antBoostTable[2];
	vapTcr2Tamplate4->ant3Boost = antBoostTable[3];
}

void setAntBoostInTcrs(uint8* antBoostTable)
{
	StaId nextSid = LmStaDataBase.headIndexOfStaLinkList;
	uint8 vapId;
	
	/*loop over connected STAs */
	while (nextSid != DB_ASYNC_SID)
	{
		setAntBoostInStaTcr(nextSid, antBoostTable);
		nextSid = StaDbSwEntries[nextSid].nextSid;
	}

	/*loop over Vaps */
	for (vapId = 0; vapId < HW_NUM_OF_VAPS; vapId++)
	{
		setAntBoostInVapTcr(vapId, antBoostTable);
	}
}

void linkAdaptationSetFreqJumpMode(uint8 freqJumpMode)
{
	DeliaAutoResponseCtsTcr2.bwChange = freqJumpMode; //for frequency jump usage 
}


void linkAdaptationSetMcastRateInVapDb(uint8 vapId,uint8 rate,PhyMode_e phyMode )
{
    LaFixedRateParams_t protectedDBParams;
    VapDb_t* pVapDbHwEntries = &VapDbHwEntries[vapId];
    uint32 protectedDBscratchPad[PROTECTED_VAP_DB_SIZE_WORDS];

    protectedDBParams.vapId = vapId;
    protectedDBParams.bandwidth = BANDWIDTH_TWENTY;
    protectedDBParams.changeType = LA_PACKET_TYPE_DATA;
    protectedDBParams.cpMode = CP_MODE_MED_CP_SHORT_LTF;
	protectedDBParams.rate = rate;
	protectedDBParams.phyMode = phyMode;
	ProtectedDbLock_ReadModifyWriteReq((uint32*)&(pVapDbHwEntries->common.word4), (PROTECTED_VAP_DB_SIZE_WORDS), protectedDBscratchPad, setVapFixedRateInTcrsModificationFunc,(void*)&protectedDBParams); 
}
void getStaRateMaskPerBw(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, Bandwidth_e bw, RateMask_t inputMask, RateMask_t* outputMask, bool forceAddLegacyRatesToAllowedMask)
{
	RateMask_t allowdRateMask;
	bool isWds = getIsWdsWep(laDbDistributionParameter->stationOrGroupIndex,laDbDistributionParameter->uspIndex, FALSE);
	
	ASSERT(bw< MAX_POSSIBLE_NUM_OF_BW);

	if (isWds == FALSE)
	{
		/*Copy allowd bitmask to local var*/	
		memcpy32(allowdRateMask.raIndexMask64bit, AllowedRatesMask[bw].raIndexMask64bit, RATES_BIT_MASK_SIZE);
	}
	else
	{//The STA is WDS WEP (WEP WDS can not support more then 460 Mbitsec. Need to reduce the rate).  
		/*Copy allowd bitmask to local var*/	
		memcpy32(allowdRateMask.raIndexMask64bit, AllowedWdsWepRatesMask[bw].raIndexMask64bit, RATES_BIT_MASK_SIZE);
	}
	if (forceAddLegacyRatesToAllowedMask == TRUE)
	{
		allowdRateMask.raIndexMask64bit[0] |= LM_PHY_11G_RATE_MSK;
	}
	/*Clear not allowed rates of the specific BW*/
	andOperator64Bit(inputMask.raIndexMask64bit,allowdRateMask.raIndexMask64bit,outputMask->raIndexMask64bit); 
}

static Scp_e convertCpModeToHtVhtCpTcrVal(CyclicPrefixMode_e cpMode)
{
	ASSERT(cpMode < CP_NUM_OF_MODES_HT_VHT);
	return cpModeToHtVhtCpTcrVal[cpMode];
}
void setMpduInAmpduLimit(K_MSG *psMsg)
{
	LaMpduInAmpduConfigMsg_t* pMpdusInAmpdu = ((LaMpduInAmpduConfigMsg_t *)pK_MSG_DATA(psMsg));
	StaId nextSid;

	SLOG0(0, 0, LaMpduInAmpduConfigMsg_t, pMpdusInAmpdu);

	for (nextSid = 0; nextSid< HW_NUM_OF_STATIONS; nextSid++)
	{
		StaDbHwEntries[nextSid].common.aMpduLimit = pMpdusInAmpdu->suMpduInAmpdu;;
	}

}


