
/***********************************************************************************
 File:		LinkAdaptationDriver.h
 Module:		LinkAdaptation 
 Purpose: 	
 Description:	
 				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "OSAL_Api.h"
#include "InterruptManager_Api.h"
#include "linkAdaptation_api.h"
#include "EventsManager_api.h"
#include "CalibrationsDefines.h"
#include "LinkAdaptationProductAdjustment.h"
#include "LinkAdaptation.h"
#include "ErrorHandler_Api.h"
#include "loggroups.h"
#include "LinkAdaptation.h"
#include "lm.h"
#include "shram_man_queues.h"
#include "int_gen.h"
#include "CpuLoad_Api.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
/***************************************************************************/
/* 					Constants                                                  				     */
/***************************************************************************/
#define LOG_LOCAL_GID   GLOBAL_GID_LINK_ADAPTATION
#define LOG_LOCAL_FID 17
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
extern bool QAMplusEnable;

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Functions definitions					
/----------------------------------------------------------------------------------*/
/**********************************************************************************

LinkAdaptation_QAMplusInit 


Description: 
------------
			Set QAMplusEnable according to indication of 2.4GHz from vConfigureReq

Input: 
-----
			None

Returns:
--------
			None
	
**********************************************************************************/
void LinkAdaptation_QAMplusInit(bool QAMplusEnableFromLm)
{
#ifdef QAM_PLUS_DEBUG
	ILOG0_D("[LinkAdaptation_QAMplusInit] Wave500B, QAMplusEnableFromLm = %d", QAMplusEnableFromLm);
#endif
	QAMplusEnable = QAMplusEnableFromLm;
}
	
/**********************************************************************************

isr_linkAdaptation_SequencerFifoNotEmpty 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

ISR_VOID isr_linkAdaptation_SequencerFifoNotEmpty(void)
{
	K_MSG* seqFifoNotEmpty = NULL;

	ACCUMULATE_CPU_IDLE_TIME();

	/* Mask all not empty interrupts in HW event */
	
	EventManager_TurnOffEvent(EVENT_ID_SEQUENCER_REPORTS_FIFO_NOT_EMPTY);
	seqFifoNotEmpty = OSAL_GET_MESSAGE(K_NO_DATA);	
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SEQ_FIFO_NOT_EMPTY, TASK_LINK_ADAPTATION, seqFifoNotEmpty, VAP_ID_DO_NOT_CARE);	
}


/**********************************************************************************

isr_linkAdaptation_BaaFifoNotEmpty 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void isr_linkAdaptation_BaaFifoNotEmpty(void)
{
	K_MSG* pMsgBaaFifoNotEmpty = NULL;
	ACCUMULATE_CPU_IDLE_TIME();

	/* Mask all not empty interrupts in HW event */
	
	EventManager_TurnOffEvent(EVENT_ID_BAA_REPORTS_FIFO_NOT_EMPTY);
	pMsgBaaFifoNotEmpty = OSAL_GET_MESSAGE(K_NO_DATA);	
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_BAA_FIFO_NOT_EMPTY, TASK_LINK_ADAPTATION, pMsgBaaFifoNotEmpty, VAP_ID_DO_NOT_CARE);	
}

bool validateBfTransmission(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, uint8 bfType)
{
	bool retVal = TRUE;
	BeamformingMode_e bfMode; 
	bool isBfProbingActivate;

	if(laDbDistributionParameter->uspIndex == INVALID_MU_USP_INDEX)
	{
		bfMode = laDbDistributionParameter->laStationUnique->beamFormingDb.bfProbingPointState; 

		isBfProbingActivate = (laDbDistributionParameter->laStaGroupCommon->linkAdaptationState == RA_WAIT_FOR_SLOW_PROBE_VALID)&&
			(getCurrentSlowProbingTask(laDbDistributionParameter) == SLOW_PROBING_BF);
		if (isBfProbingActivate)
		{
			/* if BF loop is activated, validate that the transmitted packet has the same Tx type as the BF state */
			if (((bfMode == BF_STATE_IMPLICIT) || (bfMode == BF_STATE_EXPLICIT)) && (bfType == 0))
			{ 
				retVal = FALSE;
			}
		}	
	}
	return retVal;
}
