#ifndef PROTECTION_ADAPTATION_H_
#define PROTECTION_ADAPTATION_H_
/***********************************************************************************
 File:		ProtectionAdaptation.h
 Module:		LinkAdaptation 
 Purpose: 	find the best transmission parameters for achieve best rate
 Description:	This file contains all definitions and the structures of the RateAdaptation
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "lmi.h"
#if defined(ENET_INC_ARCH_WAVE600)
#include "PreAggregator_Api.h"
#else
#include "AggregationBuilder_Api.h"
#endif 


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define DURATION_RATIO_FACTOR_SHIFT	1
#define NUMBER_OF_FRAMES_IN_COLLISION_BITMAPS	64


#define WALN_PROTECTION_TIMER_EVENT_VAL_USEC 1000000 //  1 sec


#define DEFAULT_PROTECTION_STA_FORCE_MODE_NEGATIVE_THRESHOLD		10
#define	DEFAULT_PROTECTION_STA_NONE_MODE_POSITIVE_THRESHOLD			16
#define	DEFAULT_PROTECTION_STA_THRESHOLD_MODE_NGATIVE_THRESHOLD		8
#define	DEFAULT_PROTECTION_STA_THRESHOLD_MODE_POSITIVE_THRESHOLD	20
#define	DEFAULT_PROTECTION_STA_BETTER_THAN_VAP_THRESHOLD			-16

#define DEFAULT_PROTECTION_VAP_BER_GAP_POSITIVE_THRESHOLD	15	
#define DEFAULT_PROTECTION_VAP_STACOLLISION_POSITIVE_THRESHOLD	3
#define DEFAULT_PROTECTION_VAP_STA_COLLISION_NEGATIVE_THRESHOLD	1
#define DEFAULT_PROTECTION_VAP_COLLISION_NO_IMPROVEMENT_TH	25


#define VAP_THRES_MODE_ITERATIONS_NO_IMPROVEMENT	200
#define STA_FORCE_MODE_NO_IMPROVEMENT_ITERATIONS	100

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef enum 
{
	PROTECTION_VAP_BER_GAP_POSITIVE_THRESHOLD_INDX = 0,
	PROTECTION_VAP_COLLISION_POSITIVE_THRESHOLD_INDX,
	PROTECTION_VAP_COLLISION_NEGATIVE_THRESHOLD_INDX,
	PROTECTION_STA_NONE_MODE_POSITIVE_THRESHOLD_INDX,
	PROTECTION_STA_THRESHOLD_MODE_POSITIVE_THRESHOLD_INDX,
	PROTECTION_STA_THRESHOLD_MODE_NGATIVE_THRESHOLD_INDX,
	PROTECTION_STA_FORCE_MODE_NEGATIVE_THRESHOLD_INDX,
} ProtectionConfigurationIndex;



typedef enum 
{
	VAP_DISABLE_PROTECTION,
	VAP_NONE_FORCED_PROTECTION,
	VAP_FORCED_PROTECTION,
	VAP_RELEASE_FORCED_PROTECTION,
	VAP_CONFIGURATION_LAST
} vapForcedProtectionConf_e;

typedef enum 
{
	VAP_DISABLE_PROTECTION_STATE,
	VAP_PROTECTION_NONE_STATE,
	VAP_PROTECTION_THRESHOLD_STATE,
	VAP_PROTECTION_FORCED_STATE,
	VAP_PROTECTION_INVALID_STATE,
	TOTAL_VAP_PROTECTIOB_STATES = VAP_PROTECTION_INVALID_STATE,
	VAP_PROTECTION_LAST
} vapProtectionStates_e;

typedef enum 
{
	PROTECTION_STA_RTS_METHOD = 0,
	PROTECTION_STA_CTS2SELF_METHOD,
} ProtectionStaDbTxMethod_e;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void ProtectionAdaptation_Init (void);  
void ProtectionAdaptation_AddVap(uint8 vapId);
void ProtectionAdaptation_RemoveVap(uint8 vapId);
void ProtectionAdaptation_VapSetBss(UMI_SET_BSS* pVapSetBss);
void ProtectionAdaptation_AddSta(StaId staId);
void ProtectionAdaptation_RemoveSta(StaId staId);
void ProtectionAdaptation_Handler(StaId staId, uint8 vapId, LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
#if defined (ENET_INC_ARCH_WAVE600)
void ProtectionAdaptation_VapSm(uint8 vapId, vapForcedProtectionConf_e forcedProtectionConf, PreAggForceProtectionMode_e protectionMethod);
#else
void ProtectionAdaptation_VapSm(uint8 vapId, vapForcedProtectionConf_e forcedProtectionConf, AggrBuilderForceProtectionMode_e protectionMethod);
#endif //ENET_INC_ARCH_WAVE600
void ProtectionAdaptation_WlanTimerISR(uint32 param);
void ProtectionAdaptation_WlanTimerEventHandler(K_MSG *psMsg);
void ProtectionAdaptation_SetConfiguration(ProtectionConfigurationIndex configurationIndex, uint8 value);
void ProtectionAdaptation_AgingEvent(void);
void ProtectionAdaptation_SetFixedMode(K_MSG *psMsg);
void protectionAdaptationAgingReset(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void ProtectionAdaptation_DisableProtectionForAllStationsInVap(uint8 vapId);
void ProtectionAdaptation_EnableProtectionForAllStationsInVap(uint8 vapId);
void ProtectionAdaptation_ResetProtectiontoAllStationsInVap(uint8 vapId);
void ProtectionAdaptation_ResetVapEstimators(uint8 vapId);
void ProtectionAdaptation_ResetStaEstimators(StaId staIndex);
vapProtectionStates_e protectionAdaptationGetVapState(uint8 vapId);
void ProtectionAdaptation_CtsEnable(uint8 vapId, ProtectionStaDbTxMethod_e ProtectionType);


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#endif /* PROTECTION_ADAPTATION_H_ */


