#ifndef QAM_PLUS_H_
#define QAM_PLUS_H_

/***********************************************************************************
 File:			QAMplus.h
 Module:		LinkAdaptation 
 Purpose: 		Allow LinkAdaptation to work in QAMplus when possible
 Description:	This file contains all definitions and the structures of the QAMplus
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "LinkAdaptation.h"

#include "LinkAdaptationCommon.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define QAM_PLUS_SUPPORTED_THRESH_NUM_STEPS	(6)
#define DELTA_RSSI_DB						(2)

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


typedef struct QAMplusConfigurationParams
{
	uint16		trialThresh;
	uint16 		inactiveTrialThresh;
}QAMplusConfigurationParams_t;



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void QAMplus_SetState(StaId stationId , QAMplusState_e newQAMplusState);
QAMplusState_e QAMplus_GetState(StaId stationId);
void QAMplus_NewBAReport(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, BaaRateAdaptiveFullFifo_t* pBaaReport);
void QAMplus_AddStationReq(StaId stationId, PhyMode_e staPhyMode);

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#endif /* QAM_PLUS_H_ */


