/***********************************************************************************
 File:		RateAdaptation.h
 Module:		LinkAdaptation 
 Purpose: 	find the best transmission parameters for achieve best rate
 Description:	This file contains all definitions and the structures of the RateAdaptation
 				
************************************************************************************/
#ifndef RATE_ADAPTATION_H_
#define RATE_ADAPTATION_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
//#include "LinkAdaptation_StateMachine.h"
#include "LinkAdaptationCommon.h"
#include "SharedDbTypes.h"
#include "linkAdaptation_api.h"
#include "LinkAdaptation.h"
#include "LinkAdaptationProductAdjustment.h"
#include "MT_Math.h"
#include "LinkAdaptationCommon.h"

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
#define EVENT_HANDLER_CALCULATE_TH(k) (1<<k)
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define EFFECTIVE_TP_INVALID_VAL MAX_UINT16

//---------------------------------------------------------------------------------
//						Data Type Definition					

//---------------------------------------------------------------------------------




//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void rateAdaptationInit(void);
void rateAdaptationResetDb(StaId stationIndex,uint8 uspIndex, bool isHeGroup);
void handleProbingPoint(StaId staIndex, bool stayWithLastProbingPoint);
void raFastProbingProcessFeedback(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void raSlowProbingProcessFeedback(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
bool rateAdaptationChangeWorkingPoint(LinkAdaptationDatabaseDistributionPack_t* pLaDbDistributionParameter, uint8 newRateIndex,uint8 previousWpRateIndex);
void rateAdaptationProbingTimerEvent(StaId stationGroupIndex, uint8 uspIndex, bool isHeGroup);
void rateAdaptationCheckStateTimeout(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
RaProbingIndication_e  rateAdaptationCountEvent(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, bool onlyFastIndications,RaEventObj_t* pEventObj, uint8 slowProbingKTh);
void rateAdaptationProbingHandler(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, bool stayWithCurrentProbingPoint);
uint8 rateAdaptationGetHigherRateIndex(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, Bandwidth_e bandwidth, uint8 rateIndex, RateMask_t rateMask, int8 numberOfRateLevelToSkip, bool forceAddLegacyRatesToAllowedMask);
uint8 rateAdaptationGetLowerRateIndex(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, Bandwidth_e bandwidth, uint8 rateIndex, RateMask_t rateMask, int8 numberOfRateLevelToSkip, bool forceAddLegacyRatesToAllowedMask);
void rateAdaptationUpdateStabilityState(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void rateAdaptationChangeStaToFixedRate(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void rateAdaptationChangeToAutoRate(StaId stationIndex);
void setRefLenInStaDb(StaId staIndex, uint8 refLenSuccess, uint8 refLenFail);
void decreaseStaBwLimit(StaId staIndex);
void initStaBwLimit(StaId staIndex,uint8 rateIndex, LaOperationModeNotificationChannelWidth_e omnChannelWidth, Bandwidth_e maxBW);
void setVapFixedRatesInHwDb(void);
void setStaFixedRatesInHwDb(StaId staIndex);
bool rateAdaptationFastDrop(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void rateAdaptationEnableDisableStaSlowLoop(StaId staId, SlowProbingTasks_e loopType, RaEnableDisableSlowLoop_e ebanleDisable);
void rateAdaptationEnableDisableGroupSlowLoop(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, SlowProbingTasks_e loopType, RaEnableDisableSlowLoop_e ebanleDisable);
#ifdef DEBUG_UM_INTERFACE
void rateAdaptationEnDisSlowProbingLoops(uint8 slowProbingMask);
#endif
void rateAdaptationResetCountersAndThresholds(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
uint8 GetVapRateIndex(uint8 vapId , LaPacketType_e packetType, Bandwidth_e bandwidth);
void rateAdaptationAdjustRateToMask(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void rateAdaptationResetThresholds(LaStationGroupCommonParams_t* laStationGroupCommonParameter);
void LinkAdaptationPhyDriver_Init(void);
void setCurrentSlowProbingTaskInDb(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, SlowProbingTasks_e currentSlowProbingTask);
bool rateAdaptation_RateIsIncreased(uint8 newRate, uint8 oldRate, const RateObj_t* ratesTable);
SlowProbingTasks_e getSlowProbingTaskFromBitmap(uint8 slowProbingCurrentTaskBitmap);
void handleSlowProbingIterationCounter(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, SlowProbingTasks_e slowProbingTask);
bool disableTaskFromCurrentCycle(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, SlowProbingTasks_e slowProbingTask);
bool updateNonEffectiveLoopCounter(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, SlowProbingTasks_e slowProbingTask);
void resetNonEffectiveLoopCounter(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, SlowProbingTasks_e slowProbingTask);
void resetSlowProbingPriorityBitmaps(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void changeTaskToDefaultPriority(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, SlowProbingTasks_e slowProbingTask);
uint8 rateAdaptationGetSlowProbingEnBitmap(void);
void resetSlowProbingHandlerCounters(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
bool checkMaxSlowProbingIterations(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void switchToHigherPriority (LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, SlowProbingTasks_e slowProbingTask);
uint8 AddManagementRateToMask(StaId stationIndex, LinkAdaptationStaDatabase_t *pLinkAdaptationDb, LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);

#endif  /* RATE_ADAPTATION_H_ */
