#ifndef TURBO_RATES_H_
#define TURBO_RATES_H_
/***********************************************************************************
 File:		TurboRates.h
 Module:		LinkAdaptation 
 Purpose: 	find the best power parameters
 Description:	This file contains all definitions and the structures of the Power adaptation
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "lmi.h"
#include "LinkAdaptation.h"
#include "linkAdaptation_api.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void TurboRatesInit (LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void TurboRatesSetNextProbingPoint(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, bool stayWithLastProbingPoint);
void TurboRatesProcessFeedback(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
uint8 TurboRatesGetValidRateBitmap(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
void TurboRatesGetBitmap(uint16 stationOrGroupIndex,uint8 uspIndex,Bandwidth_e bw, RateMask_t* raMask);

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#endif /* TURBO_RATES_H_ */

