#ifndef POWER_CONTROL_H_
#define POWER_CONTROL_H_
/***********************************************************************************
 File:		PowerControl.h
 Module:		LinkAdaptation 
 Purpose: 	find the best power uplink parameters
 Description:	This file contains all definitions and the structures of the Power Control
 				
************************************************************************************/
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "linkAdaptation_api.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define UL_NSS (0) /* Use fixed value of 1 SS for phase 0 */
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
int8 	  ULPC_calcNormalizedRssi(int8 rssi, uint8 mcs);
LnaType_e ULPC_calcLnaType(int8 rssi, uint8 mcs, uint8 ruSize);
void 	  ULPC_calcMcsAndTargetRssiHighLna(int8 normalizedRssi, uint8 ruSize, uint8* outMcs, int8* outTargetRssi);
void 	  ULPC_calcMcsAndTargetRssiLowLna(int8 normalizedRssi, uint8 ruSize, uint8* outMcs, int8* outTargetRssi);

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#endif /* POWER_CONTROL_H_ */

