/***********************************************************************************
 File:		LinkAdaptationCommon.h
 Module:		LinkAdaptation
 Purpose: 	Handle Link Adaptation
 Description:	This file contains all definitions and the structures of the LinkAdaptation  
 				
************************************************************************************/
#ifndef LINK_ADAPTATION_COMMON_H_
#define LINK_ADAPTATION_COMMON_H_

#include "AlphaFilter.h"
#include "linkAdaptation_api.h"


#define USP_ZERO	0


typedef enum
{
	LA_STA_NOT_CONNECT_RA_BYPASS,
	LA_WAIT_FOR_FILTER_OPEN,				/* Transmit EAPOLs in management rate WLANRTSYS-6070 */					
	LA_WAIT_FOR_NEXT_PROBE_CYCLE,
	LA_WAIT_FOR_FAST_PROBE_VALID,
	LA_WAIT_FOR_SLOW_PROBE_VALID,
	LA_PREPARE_SLOW_PROBING_TRNASMISSION,
	LA_SET_FIXED_RATE,
	LA_NUMBER_OF_STATES
} LinkAdaptationState_e;

typedef enum  
{
	LA_SINGLE_USER_MODE_STATE, 
	LA_SINGLE_USER_PROBING_STATE,
	LA_NUMBER_OF_SU_PROBING_STATES
} LinkAdaptationSuProbingState_e;


typedef enum  
{
	BA_TX_REPORT_RECEIVED,
	BA_PROBE_RESPONSE_RECEIVED,
	PROBING_TIMER_EVENT,
	SEQ_TX_REPORT_RECEIVED,
	SEQ_PROBE_RES_RECEIVED,
	RA_TIMER_AGER_EVENT,
	LA_OVERRIDE_PARAM_EVENT,
	LA_PROCESS_FEEDBACK_OUT_OF_SM,
	LA_NUMBER_OF_EVENTS 
		
} LinkAdaptationEvent_e;


typedef enum RaProbingIndication
{
	NO_PROBING_INDICATION,
	FAST_PROBING_INDICATION,
	SLOW_PROBING_PRIORITY0_INDICATION,
  	SLOW_PROBING_PRIORITY1_INDICATION,
	NUMBER_OF_PROBING_INDICATIONS_OPTIONS,
	MAX_SLOW_PROBING_PRIORITY_INDICATION = SLOW_PROBING_PRIORITY1_INDICATION
}RaProbingIndication_e;

typedef enum RaSlowProbingType
{
	SLOW_PROBING_PRIORITY0,
  	SLOW_PROBING_PRIORITY1,
	SLOW_PROBING_NUMBER_OF_PRIORITIES,
	MAX_SLOW_PRIORITY = SLOW_PROBING_PRIORITY1,
}RaSlowProbingPriority_e;

typedef struct RaEventsCounters
{
	uint16 	fastProbingCounter;
	uint16 	slowProbingCounter;
	uint16	slowProbingPrCounterArr[SLOW_PROBING_NUMBER_OF_PRIORITIES];
//	uint16  reserved;
}RaEventsCounters_t;

typedef struct RaEventThresholds
{
	uint8  	fastProbingThK;
	uint8 	slowProbingPriorityKThArr[SLOW_PROBING_NUMBER_OF_PRIORITIES];
}RaEventThresholds_t;

typedef struct RaEventObj
{
	RaEventsCounters_t raEventsCounters;
	RaEventThresholds_t raEventsThresholds;
} RaEventObj_t;

typedef enum RaEnableDisableSlowLoop
{
	ENABLE_LOOP = 0,
	DISABLE_LOOP =1,
}RaEnableDisableSlowLoop_e;

typedef enum  {
	RA_STA_NOT_CONNECT_RA_BYPASS,
	RA_WAIT_FOR_NEXT_PROBE_CYCLE,
	RA_WAIT_FOR_FAST_PROBE_VALID,
	RA_WAIT_FOR_SLOW_PROBE_VALID,
	RA_PREPARE_SLOW_PROBING_TRNASMISSION,
	RA_SET_FIXED_RATE,
	RA_NUMBER_OF_STATES
}RateAdaptationState_e;


typedef struct RateAdaptationEventHandler
{
	RaEventObj_t mpduEvent;
	RaEventObj_t timerEvent;
} RateAdaptationEventHandler_t;


typedef enum RaFastProbingState
{
	PROBE_RR, 	
	PROBE_UP, 	
	PROBE_DOWN,	
	NUMBER_OF_FAST_PROBING_STATES
}RaFastProbingState_e;

typedef enum RaFastProbingPoint
{
	LOWER_RATE,
	UP_MCS,
	UP_NSS,
	DOWN_NSS_UP_MCS,
	WORKING_POINT,
	TOTAL_NUMBER_OF_RATES_IN_DB,
	NUMBER_OF_FAST_PROBING_OPTIONS = DOWN_NSS_UP_MCS + 1,
	
}RaFastProbingPoint_e;

typedef struct RaProbingPointCounters
{
	uint8					nextProbingPointCounter;
	uint8 					notEffectveProbeCounter;
}RaFastProbingPointCounters_t;

typedef enum RaStabilityState
{
	RA_STABLE,
	RA_LOW_PER,
	RA_HIGH_PER,
	NUMBER_OF_STABILITY_STATES,
	RA_STABILITY_INVALID = 0xFF,
}RaStabilityState_e;


typedef enum StaBwFilterNum
{
	BW_40_ESTIMATOR = 0,
	BW_80_ESTIMATOR,
	BW_NUM_OF_ESTIMATORS,	
}StaBwFilterNum_e;


typedef enum BeamformingPolicy
{
	BF_POLICY_EXPLICIT,
	BF_POLICY_IMPLICIT,
}BeamformingPolicy;

typedef struct LinkAdaptationEventHandler
{
	RaEventObj_t mpduEvent;
	RaEventObj_t timerEvent;
} LinkAdaptationEventHandler_t;


typedef struct RateAdaptationDataBase
{
	RaFastProbingPointCounters_t	fastProbingPointCounters;
	uint8							slowProbingNotEffectveLoopCounter[SLOW_PROBING_NUMBER_OF_PRIORITIES];
	RaStabilityState_e 				stabilityState;
	bool							waitForProbeResponse;	
	uint8				 			fastProbeState 			:4; // values from RaFastProbingState_e
	uint8							currentFastProbingPoint :4; // values from RaFastProbingPoint_e
	uint8 							probingHandlerInterleavingCounter;	
}RateAdaptationDataBase_t;	


typedef struct EstimtorsIndication
{
	uint8 per :1;
	uint8 retransmissionAndCollisions :1;
	uint8 consequtiveFailure :1;
	uint8 consequtiveSuccess :1;
	uint8 failsInWindow :1;
	uint8 reserved	:3; 
}EstimtorsIndication_t;

typedef struct FastProbingPointEstimators
{
	AdaptiveAlphaFilterParams_t averagePer;
	AdaptiveAlphaFilterParams_t perVariance;
	uint16 averageDtFilterResult;
	uint8 rateIndex;
}FastProbingPointEstimators_t;

typedef struct SlowProbingPointEstimators
{
	AdaptiveAlphaFilterParams_t averagePer;
	uint16 averageDtFilterResult;
	Bandwidth_e bandwidth;
	uint8 slowProbingRatePlusOne;
}SlowProbingPointEstimators_t;

#ifdef LA_CALC_REF_LEN
typedef struct WorkingPointEstimators
{
	AdaptiveAlphaFilterParams_t refLength;
}WorkingPointEstimators_t;
#endif


typedef struct EstimatorsStaProtection
{
	uint32 staCollisionAckCtsBitmap;
	uint8 staCollisionCount;
	uint8 staForceProtectionIterationsCount; 
	uint8 staCollisionResetCounter;
}EstimatorsStaProtection_t;

typedef struct EstimatorsStaBw
{
	AdaptiveAlphaFilterParams_t effectiveBwCca;
}EstimatorsStaBw_t;

typedef struct stationEstimatorsDataBase
{
	FastProbingPointEstimators_t fastProbingEstimators[TOTAL_NUMBER_OF_RATES_IN_DB];
	uint8 fastProbingPointEstimatorsIndexes [TOTAL_NUMBER_OF_RATES_IN_DB];
	SlowProbingPointEstimators_t slowProbingEstimators;
	EstimatorsStaProtection_t staProtection;
	uint16 windowFailedPacketBitmap;
	uint8 numberOfFailedPacketInWindow;
	uint16	raEnterStateTime;
#ifdef LA_CALC_REF_LEN
	WorkingPointEstimators_t workingPointEstimators;
#endif
}stationEstimatorsDataBase_t;

typedef struct vapEstimatorsDataBase
{
	AdaptiveAlphaFilterParams_t protectedFramesBER; 
	AdaptiveAlphaFilterParams_t unprotectedFramesBER; 
	uint16 protectedFramesBERDeltaTAverage;
	uint16 unprotectedFramesBERDeltaTAverage;
	uint32 vapCollisionAckCtsBitmap;
	uint8 vapCollisionTotalRatio; 
	uint8 vapThresholdModeCounter; 
	uint8 vapCollisionResetCounter;
	uint8 vapRtsThresholdPpduSizeEnable;
	uint8 vapCtsProtectionEnable;
}vapEstimatorsDataBase_t;

typedef struct CurrentPacketParameters
{
	StaId stationIndex;
	uint8 	currentPer;
	uint8 	rateIndex;
	Bandwidth_e bandwidth;
	EstimtorsIndication_t estimatorsIndication;
	uint32 currentPacketTsf;
	uint16 currentPacketMpduCnt;
}CurrentPacketParameters_t;

typedef struct PowerAdaptationDatabase
{
	int8 	probingPowerStep[LA_NUM_OF_BANDWIDTH];
	int8 	accumulateDiff[LA_NUM_OF_BANDWIDTH];
	uint8 	isPowerChangedFromMaxEvm[LA_NUM_OF_BANDWIDTH];
	int8	staInternalLowerLimit;
	uint8	powerAdditionalStepUp;
	uint8	powerAdditionalStepDown;

}PowerAdaptationDatabase_t;

typedef struct BwStationDatabaseVars
{
	bool	isBwDroppedDueToRA;  
	Bandwidth_e maxSupportedBw;
	Bandwidth_e staSupportedBw;
}BwStationDatabaseVars_t;

typedef enum QAMplusState
{
	QAM_PLUS_STATE_NOT_ALLOWED = 0,
	QAM_PLUS_STATE_INACTIVE,
	QAM_PLUS_STATE_SUPPORTED,
	QAM_PLUS_STATE_TRIAL,
	QAM_PLUS_STATE_ACTIVE,
	QAM_PLUS_NUM_OF_STATES,
}QAMplusState_e;



typedef struct QAMplusStaDataBase
{
	uint16 			failureCounter;
	uint16 			numberTrialsCounter;
	uint16 			successHighestRateWPCounter;
	QAMplusState_e  QAMplusState;	
	uint8 			supportedThresh;
	int8 			lastRSSIdB;
	bool			laSteadyStateEnable;
	uint8			trialProbingCounter;
	uint8			reserved;
}QAMplusStaDataBase_t;

typedef struct LaBeamformingDataBase
{
	uint16 changeToNonExplicitStateTsf;
	BeamformingPolicy policy;
	BeamformingMode_e bfWorkingPointState;
	BeamformingMode_e bfProbingPointState;
	uint8 cddCounter;
	uint8 numberOfMpdusSentInCurrentState;
	uint8 maxNssNdpLessOrEqual80Mhz : 3;
	uint8 maxNssNdpGreaterThan80Mhz : 3;
	uint8 reserved                  : 2;
}LaBeamformingDataBase_t;


typedef struct ProbingIndices
{
	uint8 numOfAntennasIndex :2;
	uint8 permutationIndex:6;
}ProbingIndices_t;

typedef struct AntennaSelectionDatabase
{
	ProbingIndices_t probingIndices;
	uint8 validAntennas;
	uint8 workingPointAntennaMask;
	uint8 workingPointAntennaCount;
}AntennaSelectionDatabase_t;


typedef struct CddDatabase
{
	uint8 cddIndex;
}CddDatabase_t;


typedef struct LinkAdaptationRtsMode
{
	uint8		dynamicBw:1;
	uint8		staticBw:1;
	uint8		reserved:6;
} LinkAdaptationRtsMode_t;

typedef struct DynamicTxopDB
{
	AdaptiveAlphaFilterParams_t psduTimeFilter;
	uint16 averageDtFilterResult;
	uint8 maxPsduTime;		// In [32 * µs]
	uint8 psduTimeNumOfReportsCounter     :6;
	uint8 txopMode						  :2;
	uint8 prevTxopMode;
	bool  primaryInMuGroup;
}DynamicTxopDB_t;
typedef enum TurboRatesState
{
	TURBO_RATES_PROBING_DISABLE,
	TURBO_RATES_PROBING_ENABLE
}TurboRatesState_e;

typedef struct TurboRatesDataBase
{
	TurboRatesState_e state;
	uint8 turboRatesValidBitmap;
	uint8 probingTurboRateIndex;
	int8 lastRssi;
}TurboRatesDataBase_t;

#ifdef ENET_INC_ARCH_WAVE600

typedef struct LaHeUlPowerControlParams
{
	LnaType_e lnaType;
	int8 normalizedRssi;
} LaHeUlPowerControlParams_t;
#endif

#ifdef ENET_INC_ARCH_WAVE600D2

typedef enum
{
	DCM_CAPABILITIES_SUPPORT_1_NSS		= 1,
	DCM_CAPABILITIES_SUPPORT_1_2_NSS 	= 2,
}DcmNssSupport_e;


typedef struct LaHeExtSuParams
{
	bool heExtEnabled;
	DcmNssSupport_e dcmMaxNss; //from DCM Max NSS RX capability; means the maximum NSS we can transmit to station with DCM
	Bandwidth_e dcmMaxBw; //from DCM Max NSS BW capability; means the maximum BW we can transmit to station with DCM
} LaHeExtSuParams_t;

typedef struct LaHeSigBParams
{
	bool heSigbCompressed;
	bool heSigb16Symbols;
} LaHeSigBParams_t;

#endif //ENET_INC_ARCH_WAVE600D2

#endif /* LINK_ADAPTATION_H_ */
