/***********************************************************************************
 File:		LinkAdaptation_StateMachine.h
 Module:		LinkAdaptation 
 Purpose: 	find the best transmission parameters for achieve best rate
 Description:	This file contains all definitions and the structures of the RateAdaptation
 				
************************************************************************************/
#ifndef LA_STATE_MACHINE_H_
#define LA_STATE_MACHINE_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "BaAnalyzer.h"
#include "TxSequencer.h"
#include "LinkAdaptationCommon.h"
#include "LinkAdaptation.h"
#include "LinkAdaptation_StateMachine.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition					

//---------------------------------------------------------------------------------



/*---------------------------------------------------------------------------------
/						Function Declaration									
/----------------------------------------------------------------------------------*/
void laStateMachineInit(StaId stationIndex, uint8 uspIndex, bool isHeGroup);
void laStateMachineChangeState(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, LinkAdaptationState_e newState);
void laStateMachineEnterEvent(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter,LinkAdaptationEvent_e event);
void laStateMachineProcessBaaReport(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, BaaRateAdaptiveFullFifo_t* pCurrentBaaReport,BaaRateAdaptiveFullFifo_t* pLastBaaReport);
void laStateMachineProcessSequencerReport(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, TxSequencerReport_t* pSeqReport);
void laStateMachineUpdateCurrentSlowProbingBitMap(RaProbingIndication_e probingIndication, LaSlowProbingHandlerParams_t* pslowProbingHandlerData);

#endif  /* LA_STATE_MACHINE_H_ */


