
/***********************************************************************************
 File:		LinkAdaptation.c
 Module:		LinkAdaptation
 Purpose: 	Handle Link Adaptation
 Description:	This file contains all definitions and the structures of the LinkAdaptation  
 				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_GlobalDefinitions.h"
#include "LinkAdaptation.h"
#include "linkAdaptation_api.h"
#include "shram.h"
#include "stringLibApi.h"
#include "ShramStationDatabase.h"
#include "RegAccess_Api.h"
#include "lmtimerUtility.h"
#include "lm_StaDatabase.h"
#include "database.h"
#include "LinkAdaptation_Tests.h"
#include "LinkAdaptation_Tests_api.h"
#include "shram_man_queues.h"
#include "lm.h"
#include "int_gen.h"
#include "Pac_Api.h"
#include "OSAL_Tasks.h"
#include "EmeraldEnvRegs.h"
#include "RegAccess_Api.h"
#include "LinkAdaptationProductAdjustment.h"
#include "EventsManager_api.h"
#include "TxSequencer_Api.h"
#include "BaAnalyzer_Api.h"
#include "System_Timers.h"
#include "InterruptManager_Api.h"
#include "lm_VapDatabase.h"
#include "lm_StaDatabase.h"
#include "mt_sysrst.h"
#include "ProtectionAdaptation.h"
#include "CyclicPrefix.h"
#include "BwAdaptation.h"
#include "Beamforming.h"
#include "PacketDescriptor.h"
#include "HwGlobalDefinitions.h"
#include "CDD.h"
#include "frame.h"
#include "ShramStatistics.h"
#include "HwSemaphore_API.h" 
#include "RateAdaptation.h"
#include "Estimators.h"
#include "LinkAdaptation_StateMachine.h"
#include "PowerAdaptation.h"
#include "AntennaSelection.h"
#include "QAMplus.h"
#include "DynamicTxOP.h"
#include "queue_utility.h"
#include "TrainingManager_Api.h"
#include "LinkAdaptationPhyDriver.h"
#include "PowerAdaptation.h"
#include "GroupManager_API.h"
#include "ShramGroupDatabase.h"
#include "CommonRamLinkAdaptation.h"
#if defined(ENET_INC_ARCH_WAVE600)
#include "PreAggregator_Api.h"
#include "ulPowerControl.h"
#include "PlanManager_API.h"
#include "RficDriver_API.h"
#include "Bsrc_Api.h"
#include "PhyTestBus_API.h"
#include "HeGroupManager_API.h"
#else
#include "AggregationBuilder_Api.h"
#endif 
#include "ConfigurationManager_api.h"
#include "ShramVapDatabase.h"
#include "LinkAdaptationPhyDriver.h"
#include "ProtectedDbLock_Api.h"
#include "PhyDriver_API.h"
#include "Statistics_Api.h"
#include "TurboRates.h"
#include "HdkCdbManagerTask_api.h"
#include "GroupsMetricsCalculator.h"
#include "stringLibApi.h"
#include "RadarDetection.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_LINK_ADAPTATION
#define LOG_LOCAL_FID 9

#ifdef LINK_ADAPTATION_REGISTRATION
#define REG_CHANGE_WP_TABLE_SIZE 2
#define REG_SWITCH_11B_TABLE_SIZE  2
#define MAX_NUMBER_OF_INDICATIONS_IN_PROCESS 4
#endif
#define LA_MIN_TIMER_VAL_USEC 10

#define LA_SM_STATIC_MODE					0x0
#define LA_SM_DYNAMIC_MODE					0x1
#define LA_SM_POWER_SAVE_DISABLED			0x3

#define INVALID_TRANSACTION_NUM  0xFFFF
#define uspMaskBits	0x3

#define INVALID_MU_POWER 0x40
/*BSRC UL definitions*/
#define BSRC_DATA_COUNTERS_INIT_VAL 1024
#define BSRC_DATA_COUNTERS_RESET_COUNTERS_VAL 0

#define BSRC_DATA_COUNTERS_BE_AC_BITS 0x9
#define BSRC_DATA_COUNTERS_VOICE_AC_BITS 0xC0
#define BSRC_NUMBER_OF_STATIONS_IN_BITMAP 32
#define NUMBER_OF_STA_BITMAPS 2

#ifdef ENET_INC_ARCH_WAVE600
#define BAA_SHIFT_TO_1_MICRO_RESOLUTION		(0)
#else
/* Gen5 TX Sender provides the PSDU Time in 32[usec] due lack of space. Shift it back to 1[usec] resolution. */
#define BAA_SHIFT_TO_1_MICRO_RESOLUTION		(0x5)
#endif //ENET_INC_ARCH_WAVE600

/*This can be commented out only when we add the extra options to the interface*/
//#define EXTENDED_DMR_MODES_SUPPORTED
#define RU_SIZE_242_TO_26_TONES_RATIO 9

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

typedef struct LinkAdaptationLocalParam
{
	uint16                  numberOfElementInTxSequencerFifo;
}LinkAdaptationLocalParam_t;

#define B_PROTECTION_ONLY_FOR_B	0
#define B_PROTECTION_FOR_B_OR_G	1
#define B_PROTECTION_ALWAYS		2

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void linkAdaptationProcessSequencerReportQueue(K_MSG *psMsg);
static void linkAdaptationProcessBaaReportQueue(K_MSG *psMsg);
//static void linkadaptationStateMachine(linkAdaptationEvent_e inputEvent);
static void linkAdaptationConfigurationParamsInit(void);
static void linkAdaptationAddStationReq(K_MSG *psMsg);
static void linkAdaptationRemoveStationReq(K_MSG *psMsg);
static void linkAdaptationHandleProbingTimerEvent(K_MSG *psMsg);
static void linkAdaptationHandleAgingTimerEvent(K_MSG *psMsg);
static void  linkAdaptationSetMuGroupFixedRate(K_MSG *psMsg);
#ifndef ENET_INC_ARCH_WAVE600
static void linkAdaptationSetFixedCDD(K_MSG *psMsg);
#endif
static void linkAdaptationStaSendConfirm(StaId stationIndex);
static void setLinkAdaptationRatesMask(UMI_STA_ADD *pAddSta);
static void setHtRatesInMask(uint8* staMcsSetBitmaskVector, RateMask_t* staHtMask);
static void setVhtRatesInMask(uint16 txVhtMcsMap, RateMask_t* staHtMask);
#ifdef ENET_INC_ARCH_WAVE600
static void setHeRatesInMask(HE_MCS_SUPPORT* heMcsNss, RateMask_t* staMask);
#endif
static void linkAdaptationSetBss(K_MSG *psMsg);
static void linkAdaptationRemoveVap(K_MSG *psMsg );
static void linkAdaptationSetChannelReq(K_MSG *psMsg );
#ifndef ENET_INC_ARCH_WAVE600
static void linkAdaptationCddSetPsdDataReq(K_MSG *psMsg );
#endif
static void linkAdaptationSetProtectionThreshReq(K_MSG *psMsg );
static void linkAdaptationSetFixedPower(K_MSG *psMsg );
static void linkAdaptationSetFixedRate(K_MSG *psMsg);
#ifdef DEBUG_UM_INTERFACE
static void linkAdaptationEnDisSlowProbingLoops(K_MSG *psMsg );
#endif
static void linkAdaptationSetFixedScp(K_MSG *psMsg);
static void  linkAdaptationSetFixedPowerAtAddSta(StaId sid);
static void linkAdaptationSetAntennaSelection(K_MSG *psMsg );
static void linkAdaptationSetFixedBfMode(K_MSG *psMsg );
static void linkAdaptationSetAggRateLimit(K_MSG *psMsg );
static void linkAdaptationSetPowerLimit(K_MSG *psMsg );
static void adjustBetweenStaTcrsParams(StaId staIndex, Bandwidth_e bandwidth, LaTcrModificationStruct_t* pModificationParamsIn,  LaTcrModificationStruct_t* pModificationParamsOut);
static void linkAdaptationClearSmpsFlags(StaId stationIndex);
static void linkAdaptationRemoveSidReq(K_MSG *psMsg );
static void linkAdaptationSetOperatingModeNotificationStaConnected(LaOperatingModeNotificationMsg_t *laOmnMsg);
static void linkAdaptationClearOperatingModeNotification(StaId stationIndex);
static void linkAdaptationSetOperatingModeNotification(K_MSG *psMsg);
static bool linkAdaptaionOperatingModeNotificationCheckActivation(LaOperationModeNotificationAddSta_t *laOmnAddSta, UMI_STA_ADD *pAddSta, LinkAdaptationStaDatabase_t *pLinkAdaptationDb);
static void linkAdaptationSetBfCalStatus(K_MSG *psMsg);
static void linkAdaptationSetBfActivationBitmap(K_MSG *psMsg);
static void linkAdaptationSetPowerAdaptationPsdTables(K_MSG *psMsg);
static void linkAdaptationHandleGenericReq(K_MSG* msg);
static void linkAdaptationQAMplusActivate(K_MSG *psMsg);
static void linkAdaptationMsduInAmsduConfig(K_MSG *psMsg);
static void linkAdaptatioRtsModeConfig(K_MSG *psMsg);
static void linkAdaptatioMaxMpduConfig(K_MSG *psMsg);
static void linkAdaptaionProtectionFixed(K_MSG *psMsg );
static void  linkAdaptationSetTxopMode(K_MSG *psMsg );
static void  linkAdaptationFastDropConfig(K_MSG *psMsg );
static void  linkAdaptationDmrConfig(K_MSG *psMsg );
static void  linkAdaptationSetPpduMode(K_MSG *psMsg );
#ifdef ENET_INC_ARCH_WAVE600
static void  linkAdaptationSetRegDomainConfig(K_MSG *psMsg);
static void setTfPaddingCapability(LinkAdaptationStaDatabase_t* pLinkAdaptationDb, uint8 tfPadding);
#endif //ENET_INC_ARCH_WAVE600
static void linkAdaptationSetFilter(K_MSG *pMsg);
#ifdef LINK_ADAPTATION_REGISTRATION
static void linkAdaptationRegistrationTablesInit(void);
static void linkAdaptationEventRegistrationReq(K_MSG *psMsg);
#endif //LINK_ADAPTATION_REGISTRATION

static void  linkAdaptationSendTrainingInfo(K_MSG *psMsg );

static void linkAdaptationAddVhtGroup(K_MSG *psMsg);
static void linkAdaptationRemoveVhtGroup(K_MSG *psMsg);
#ifdef ENET_INC_ARCH_WAVE600
static void linkAdaptationAddHeGroup(K_MSG *psMsg);
static void linkAdaptationRemoveHeGroup(K_MSG *psMsg);
static LaAddHeGroupStatus_e linkAdaptationAddHeDlDataPhase(LaAddHeGroupParams_t *addHeGroupParameters, DlDataPhase_t* phasePtr, uint8 phaseEntryInPlan, bool phaseFirstOccurrence, uint8 vapId);
static LaAddHeGroupStatus_e linkAdaptationAddHeUlDataPhase(LaAddHeGroupParams_t *addHeGroupParameters, UlDataPhase_t* phasePtr, bool phaseFirstOccurrence, uint8 vapId);
static LaAddHeGroupStatus_e linkAdaptationAddHeProtectionPhase(LaAddHeGroupParams_t *addHeGroupParameters, ProtectionPhase_t* phasePtr, bool phaseFirstOccurrence, uint8 vapId);
static LaAddHeGroupStatus_e linkAdaptationAddHeSoundingPhase(LaAddHeGroupParams_t *addHeGroupParameters, SoundingPhase_t* phasePtr, bool phaseFirstOccurrence, uint8 vapId, uint8 planIndex);
static void sendLnaTypeHasChangedIndToHeGm(StaId staId, LnaType_e lnaType);
static void linkAdaptationGetPhyRate(K_MSG *psMsg);
#endif
static void linkAdaptationDmrConvertRateindexToSortedBasicRateIndex(uint8 oldRateIndex, uint8 newRateIndex, uint8 *sortOldRateIndex, uint8 *sortNewRateIndex, uint8 vapId);
static uint8 linkAdaptationDmrSeekLowestBasicRateAmongStations(uint8 *sortBasicRateNumOfStationsCounter, uint8 return_rate_not_found);
static void linkAdaptationDmrUpdateVapRate(uint8 vapId, uint8 newMcRateIndex);
static void linkAdaptatioTxopTimeLimitConfig(K_MSG *psMsg);
static void linkAdaptationStartSingleUserValidation(K_MSG * psMsg);
static void linkAdaptationEndSingleUserValidation(K_MSG * psMsg);
static void linkAdaptationSetHwGroupDb(uint8 groupId,uint8 uspIdnex,StaId stationIndex);
static void	linkAdaptationSetHwGroupDbCommon(uint8 groupId,StaId participatingStations[]);
static void	linkAdaptationGetGroupsMarks(K_MSG *psMsg );
static void linkAdaptationFillAllGroupMarks(uint8* groupMarks);
static void linkAdaptationFillGroupUspsSUMarks(uint8* uspsMarks,uint8 groupId);
static void linkAdaptationFillGroupUspsMUMarks(uint8* uspsMarks, uint8 groupId);
static void setLinkAdaptationMuUspRatesMask(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, RateMask_t* pRaIndexMask, uint8 maxNss, PreAggRuSizeMapping_e ruSize);
static void linkAdaptationSetTxopModeForMuMember(K_MSG *psMsg);
static void linkAdaptation_SetMuFixedPower(uint8 powerVal);
static void clearUnsupportedLowRatesFromHeMuUspRateMask(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
static void clearUnsupportedHighRatesFromHeMuUspRateMask(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);
#ifdef ENET_INC_ARCH_WAVE600
static void overrideRateForUnsupportedFixedRate(StaId staId);
#ifdef ENET_INC_ARCH_WAVE600B
static void setEtsiMode(bool etsiMode);
#endif //ENET_INC_ARCH_WAVE600B
#endif //ENET_INC_ARCH_WAVE600
#ifdef ENET_INC_ARCH_WAVE600D2
static void checkHeExtAndDcmWrongFixedRateConfiguration(StaId staId);
#endif //ENET_INC_ARCH_WAVE600D2
static void  linkAdaptationSetCollisionDetectionTh(K_MSG *psMsg );

extern void lmGetBcl(K_MSG * ptK_MSG);
extern void lmSetBcl(K_MSG * ptK_MSG);
#ifndef ENET_INC_ARCH_WAVE600
extern void lmLogFillMsgHdrTemplate(K_MSG * ptK_MSG);
#endif
extern void updateMgmtWithinAwindow(BaaRateAdaptiveFullFifo_t* pBaaReport, LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter);

static void linkAdaptationSetFilter(K_MSG *laMessage);

static void linkAdaptationProtectionRateConfig(K_MSG* psMsg);

void laStaManagerSendConfirm(StaId sid, uint8 vapId);
#ifdef PF6_MU_BAR_PATCH
static void overrideMinNumberOfUsersForTransmission(PreAggCommonReportFifo_t *commonReport);
#endif
extern wholePhyRxStatusDb_t phyRxStatusDb;
static void linkAdaptationUpdateProtectionRateOnAddSta(PhyMode_e phymode);
void linkAdaptationUpdateProtectionRateOnRemoveSta(PhyMode_e phymode);
bool isLowRateSta(PhyMode_e phymode);
static void linkAdaptationUpdateGroupsMetricsReq(K_MSG * psMsg);
static void linkAdaptationSendStaParamsToHeGroupManager(K_MSG* pMsg);

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
static const FunctionEntry_t afpTaskTable[TASK_LINK_ADAPTATION_END - TASK_LINK_ADAPTATION_START]=
{
	{linkAdaptationProcessSequencerReportQueue, 		DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SEQ_FIFO_NOT_EMPTY)},
	{linkAdaptationAddStationReq,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_ADD_STATION_REQ)},
	{linkAdaptationRemoveStationReq,					DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_REMOVE_STATION_REQ)},
	{linkAdaptationHandleProbingTimerEvent, 			DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_PROBING_TIMER_EVENT)},
	{linkAdaptationHandleAgingTimerEvent,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_AGING_TIMER_EVENT)},
	{ProtectionAdaptation_WlanTimerEventHandler,		DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_WLAN_PROTECTION_TIMER_EVENT)},
	{linkAdaptationSetFixedRate,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_FIXED_RATE)},
	{linkAdaptationSetMuGroupFixedRate,					DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_MU_GROUP_FIXED_RATE)},
	{linkAdaptationSetFixedPower,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_FIXED_POWER)},
#ifndef ENET_INC_ARCH_WAVE600
	{linkAdaptationSetFixedCDD, 						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_FIXED_CDD_REQ)},
#endif
	{linkAdaptationSetBss,								DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_ADD_VAP)},
	{linkAdaptationRemoveVap,							DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_REMOVE_VAP)},
	{linkAdaptationSetChannelReq,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_CHANNEL_DATA_REQ)},
#ifndef ENET_INC_ARCH_WAVE600
	{linkAdaptationCddSetPsdDataReq,					DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_CDD_SET_PSD_DATA_REQ)},
#endif
	{linkAdaptationSetProtectionThreshReq,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_PROTECTION_THRESH_REQ)},
	{linkAdaptationSetAntennaSelection, 				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_ANTENNA_SELECTION_REQ)},
	{linkAdaptationProcessBaaReportQueue,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_BAA_FIFO_NOT_EMPTY)},
	{linkAdaptationSetFixedBfMode,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_BF_MODE_REQ)},
	{linkAdaptationSetAggRateLimit,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_AGG_RATE_LIMIT_REQ)},
	{linkAdaptationSetPowerLimit,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_POWER_LIMIT_REQ)},
	{linkAdaptationRemoveSidReq,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_REMOVE_SID_REQ)},
	{linkAdaptationSetOperatingModeNotification,		DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_OPERATING_MODE_NOTIFICATION_REQ)},
	{handelExplicitBfReportTimerEvent,					DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_BF_TIMER_EVENT)},
	{linkAdaptationSetBfCalStatus,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_UPDATE_BF_CAL_STATUS_REQ)},
	{linkAdaptationSetBfActivationBitmap,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_ACT_BITMAP_PSD_REQ)},
	{linkAdaptationSetPowerAdaptationPsdTables,			DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_POWER_ADAPTATION_PSD_REQ)},
	{linkAdaptationQAMplusActivate,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_QAMPLUS_ACTIVATE_REQ)},
#if !defined (ENET_INC_ARCH_WAVE600)
	{linkAdaptationSetRecoveryTimeLimit,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_RECOVERY_TIME_LIMIT)},
#endif 
	{linkAdaptationSendTrainingInfo,					DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_GET_TRAINIG_INFO)},
	{linkAdaptationStartSingleUserValidation,			DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_START_SINGLE_USER_VALIDATION)},
	{linkAdaptationEndSingleUserValidation,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_STOP_SINGLE_USER_VALIDATION)},
	{linkAdaptationGetGroupsMarks,			            DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_GET_GROUPS_MARKS)},	
	{linkAdaptationAddVhtGroup, 						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_ADD_GROUP)},
	{linkAdaptationRemoveVhtGroup,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_REMOVE_GROUP)},
	{linkAdaptatioTxopTimeLimitConfig,					DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_TXOP_TIME_LIMIT_CONFIG_REQ)},
#ifdef LINK_ADAPTATION_TEST_ENV
	{LaTests_TestInit,									DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_RUN_TEST_REQ)},
#endif
	{linkAdaptationHandleGenericReq,					DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_GENERIC_REQ)},	
	{lmGetBcl,											DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_GET_BCL_REQ)},
	{lmSetBcl,											DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_BCL_REQ)},
#ifndef ENET_INC_ARCH_WAVE600
	{lmLogFillMsgHdrTemplate,							DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_LOG_FILL_HDR_TEMPLATE)},
#endif
	{linkAdaptationMsduInAmsduConfig,					DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_MSDU_IN_AMSDU_CONFIG_REQ)},
	{setMpduInAmpduLimit,								DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_MPDU_IN_AMPDU_LIMIT_CONFIG_REQ)},
	{linkAdaptatioRtsModeConfig,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_RTS_MODE_CONFIG_REQ)},
	{linkAdaptatioMaxMpduConfig,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_MAX_MPDU_LEN_REQ)},
	{linkAdaptationSetFreqJumpModeInCtsAutoReply,		DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_FREQ_JUMP_MODE_REQ)},
	{linkAdaptaionProtectionFixed,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_FIXED_PROTECTION_REQ)},
	{linkAdaptationSetTxopMode,							DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_TXOP_CONFIG_REQ)},
	{linkAdaptationSetTxopModeForMuMember,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_TXOP_FOR_MU_MEMBER)},
#ifdef ENET_INC_ARCH_WAVE600
	{linkAdaptationAddHeGroup, 							DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_ADD_HE_GROUP)},
	{linkAdaptationRemoveHeGroup, 						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_REMOVE_HE_GROUP)},	
	{linkAdaptationGetPhyRate,							DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_GET_PHY_RATE)},
#endif
	{linkAdaptationFastDropConfig,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_FAST_DROP_CONFIG_REQ)},
	{linkAdaptationDmrConfig,							DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_DMR_CONFIG_REQ)},
	{linkAdaptationSetPpduMode,							DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_PPDU_TX_MODE_REQ)},
    {linkAdaptationUpdateCalStatistics, 				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_CALIBRATION_STATISTICS)},
	{linkAdaptationSetCollisionDetectionTh,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_COLLISION_DETECTION_TH)},
#ifdef ENET_INC_ARCH_WAVE600
	{linkAdaptationSetRegDomainConfig,					DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_REG_DOMAIN_CONFIG_REQ)},	
#endif //ENET_INC_ARCH_WAVE600
	{linkAdaptationSetFilter,		 					DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_FILTER)},
#if defined(BSRC_ARTIFICIAL_UPDATE_FOR_UL)
    {LinkAdaptation_SetBsrcCountersForStaticPlan,       DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_BSRC_COUNTERS_FOR_STATIC_PLAN)},
#endif
#ifdef ENET_INC_ARCH_WAVE600
	{linkAdaptationProtectionRateConfig,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_RTS_RATE_CONFIG)},
	{linkAdaptationUpdateGroupsMetricsReq,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_UPDATE_GROUPS_METRICS_REQ)},
	{linkAdaptationSendStaParamsToHeGroupManager,		DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_GET_ASSOC_PARAMS_FROM_LA)},
#endif
#ifdef DEBUG_UM_INTERFACE
	{linkAdaptationEnDisSlowProbingLoops,				DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_EN_DIS_SLOW_PROBING_REQ)},
#endif
	{linkAdaptationSetFixedScp,							DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_SCP_SHORT_PREAMBLE_REQ)},
	{linkAdaptationSetRtsThreshold,						DOUBLE_CHECK_MSG_TYPE(LINK_ADAPTATION_SET_RTS_THRESHOLD_REQ)},
};

static LinkAdaptationLocalParam_t linkAdaptationLocalParam; 
uint16 linkAdaptaionActivateTimersIds[NUMBER_OF_LINK_ADAPTATION_TIMERS] = {MAX_UINT16, MAX_UINT16, MAX_UINT16};
extern bool QAMplusEnable;
extern bool QAMplusEnableFromDriver;
uint32 maxMpduLenLimit;  
uint8  linkAdaptaionBssColor = 0;
/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

TxSequencerReport_t CurrentSequencerReport;
BaaRateAdaptiveFullFifo_t CurrentBaaReport;
BaaRateAdaptiveFullFifo_t LastBaaReport;

#ifdef ENET_INC_ARCH_WAVE600
uint32 	heDlDataPhaseActiveGroupsBitmapPerBand;
#endif
uint32 	VhtGroupActiveGroupsBitmap;

uint32 muCandidateStaBitmap[SIZE_OF_STATIONS_BITMAP_IN_WORDS];
uint8  muFixedPowerVal = INVALID_MU_POWER;

#ifdef ENET_INC_ARCH_WAVE600
const RateMask_t AllowedHeRatesMask = {0xFFFFFFFF, 0x7FFFFFFF};
#endif

const RateMask_t AllowedRatesMask[MAX_POSSIBLE_NUM_OF_BW] = 
{
	{0xFEFFFFFF, 0x3FFFFB},
	{0xFFFF8000, 0x7FFFFF},
	{0xFFFF8000, 0x7FFDFF},
	{0xFFFF8000, 0x7FEFFF},
};
const RateMask_t AllowedWdsWepRatesMask[MAX_POSSIBLE_NUM_OF_BW] = 
{
	{0xFEFFFFFF, 0x3FFFFB},
	{0xFFFF8000, 0x07E7FF},					
	{0x3FFF8000, 0x00E078},
	{0x0E0F8000, 0x002018},
};

RateMask_t disableHtVhtNssMaskAccordingtoAntNum[MAX_POSSIBLE_NUM_OF_ANTENNAS] = 
{
	DISBALE_NSS_2_3_4_MASK_HT_VHT,
	DISBALE_NSS_3_4_MASK_HT_VHT,
	DISBALE_NSS_4_MASK_HT_VHT,
	ENABLE_ALL_NSS_MASK_HT_VHT,
};
RateMask_t enableHtVhtNssRatesInMask[VHT_HE_NUMBER_OF_NSS] = 
{
	ENABLE_NSS_1_MASK_HT_VHT,
	ENABLE_NSS_2_MASK_HT_VHT,
	ENABLE_NSS_3_MASK_HT_VHT,
	ENABLE_NSS_4_MASK_HT_VHT,
};

#ifdef ENET_INC_ARCH_WAVE600
RateMask_t disableHeNssMaskAccordingtoAntNum[MAX_POSSIBLE_NUM_OF_ANTENNAS] = 
{
	DISBALE_NSS_2_3_4_MASK_HE,
	DISBALE_NSS_3_4_MASK_HE,
	DISBALE_NSS_4_MASK_HE,
	ENABLE_ALL_NSS_MASK_HE,
};
RateMask_t enableHeNssRatesInMask[VHT_HE_NUMBER_OF_NSS] = 
{
	ENABLE_NSS_1_MASK_HE,
	ENABLE_NSS_2_MASK_HE,
	ENABLE_NSS_3_MASK_HE,
	ENABLE_NSS_4_MASK_HE,
};

#ifdef WORKAROUND_FOR_PHY_BUG_IN_LDPC
RateMask_t enableHeRatesSupportedByPhyInMask[PRE_AGGREGATOR_NUM_OF_RU_SIZES + 1] = 
{
	PHY_VALID_RATES_FOR_RU_SIZE_26_WITH_LDPC_MASK,
	PHY_VALID_RATES_FOR_RU_SIZE_52_WITH_LDPC_MASK,
	PHY_VALID_RATES_FOR_RU_SIZE_106_WITH_LDPC_MASK,
	PHY_VALID_RATES_FOR_RU_SIZE_242_WITH_LDPC_MASK,
	PHY_VALID_RATES_FOR_RU_SIZE_484_WITH_LDPC_MASK,
	PHY_VALID_RATES_FOR_RU_SIZE_996_WITH_LDPC_MASK,
	PHY_VALID_RATES_FOR_RU_SIZE_996X2_WITH_LDPC_MASK,
	ENABLE_ALL_HE_RATES_MASK,
};
#endif
#endif

LinkAdaptationCommonConfigParams_t LinkAdaptationCommonConfiguration;
LaFixedRateParams_t FixedRateParameters;
bool MuGroupFixedRateRequested = FALSE; 

LaFixedPowerParams_t FixedPowerParameters;
LaFixedScpParams_t fixedCpParams;

#ifdef LINK_ADAPTATION_REGISTRATION
/*Registration variables */
LaRegistrationTableObj_t RegistrationWpChangeTableObj;
LaRegistrationTableObj_t Registration11bChangeTableObj;
LaRegistrationTable_t ChangeWpCallBackTable[REG_CHANGE_WP_TABLE_SIZE ];
LaRegistrationTable_t Switch11BCallBackTable[REG_SWITCH_11B_TABLE_SIZE];
LaRegistrationTableObj_t* RegistrationEventsTableObjArr[NUM_OF_REGISTRATION_EVENTS];

#endif
LaFixedBeamformingParams_t bfDebugParams;
uint8 enableExtraLogs = 1;

uint8	AggRateLimitMode = FALSE;
uint16	AggRateLimitMaxRate = 0;
bool enableFastDrop = ENABLE_FAST_DROP;
UmiDmrMode_e dmrMode = UMI_DMR_DISABLED;		/*Dynamic Multicast Rate, allow all supported rates*/

uint8 numConnectedLowRateSta = 0;
uint8 regulatoryDomainConfig = REG_DOMAIN_DEFAULT;
uint8 protectionRateCutoff = B_PROTECTION_FOR_B_OR_G;
HeUspBitmap_t BaReportReceivedForUserIndication;

/*---------------------------------------------------------------------------------
/						Const tables									
/----------------------------------------------------------------------------------*/

const RateObj_t htVhtRatesTable[NUMBER_OF_ALL_RATES_HT_VHT]=
 /*
 																												PHY rate 		    PHY rate	    	PHY rate 	        PHY rate 		   PHY rate 		  PHY rate 			    PHY rate		   PHY rate 		   PHY rate 		   PHY rate 		   PHY rate		       PHY rate            PHY rate
		   rate index,       phy mode    ,     	numberOfNss,       	   ht MCS,          vht_HE_Mcs,      sortPhyRateSameBwIndex,  (SCP, 20 MHz),   (MCP(LCP), 20 MHz), (LCP(NOTUSE), 20 MHz), (SCP, 40 MHz),  (MCP(LCP), 40 MHz), (LCP(NOTUSE), 40 MHz), (SCP, 80 MHz),    (MCP(LCP), 80 MHz),  (LCP(NOTUSE), 80 MHz), (SCP, 160 MHz), (MCP(LCP), 160 MHz), (LCP(NOTUSE), 160 MHz), 
*/
{
	{	     /*0*/      	LA_PHY_MODE_11AG,	       0,       	       0,       	       0,       	       5,       	       6,       	       6,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*1*/      	LA_PHY_MODE_11AG,	       0,       	       1,       	       1,       	       6,       	       9,       	       9,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*2*/      	LA_PHY_MODE_11AG,	       0,       	       2,       	       2,       	       9,       	      12,       	      12,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*3*/      	LA_PHY_MODE_11AG,	       0,       	       3,       	       3,       	      10,       	      18,       	      18,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*4*/      	LA_PHY_MODE_11AG,	       0,       	       4,       	       4,       	      11,       	      24,       	      24,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*5*/      	LA_PHY_MODE_11AG,	       0,       	       5,       	       5,       	      12,       	      36,       	      36,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*6*/      	LA_PHY_MODE_11AG,	       0,       	       6,       	       6,       	      13,       	      48,       	      48,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*7*/      	LA_PHY_MODE_11AG,	       0,       	       7,       	       7,       	      14,       	      54,       	      54,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*8*/      	LA_PHY_MODE_11B,	       0,       	       1,       	       1,       	       2,       	       2,       	       2,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*9*/      	LA_PHY_MODE_11B,	       0,       	       2,       	       2,       	       4,       	       5,       	       5,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*10*/     	LA_PHY_MODE_11B,	       0,       	       3,       	       3,       	       8,       	      11,       	      11,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*11*/     	LA_PHY_MODE_11B,	       0,       	       4,       	       4,       	       0,       	       1,       	       1,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*12*/     	LA_PHY_MODE_11B,	       0,       	       5,       	       5,       	       1,       	       2,       	       2,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*13*/     	LA_PHY_MODE_11B,	       0,       	       6,       	       6,       	       3,       	       5,       	       5,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*14*/     	LA_PHY_MODE_11B,	       0,       	       7,       	       7,       	       7,       	      11,       	      11,       	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*15*/     	LA_PHY_MODE_HT_VHT,	       0,       	       0,       	       0,       	      15,       	       7,       	       6,       	  MAX_UINT16,   	      15,       	      13,       	  MAX_UINT16,   	      32,       	      29,       	  MAX_UINT16,   	      65,       	      58,       	   MAX_UINT16   },
	{	     /*16*/     	LA_PHY_MODE_HT_VHT,	       0,       	       1,       	       1,       	      16,       	      14,       	      12,       	  MAX_UINT16,   	      30,       	      27,       	  MAX_UINT16,   	      65,       	      58,       	  MAX_UINT16,   	      130,      	      117,      	   MAX_UINT16   },
	{	     /*17*/     	LA_PHY_MODE_HT_VHT,	       0,       	       2,       	       2,       	      18,       	      21,       	      19,       	  MAX_UINT16,   	      45,       	      40,       	  MAX_UINT16,   	      97,       	      87,       	  MAX_UINT16,   	      195,      	      175,      	   MAX_UINT16   },
	{	     /*18*/     	LA_PHY_MODE_HT_VHT,	       0,       	       3,       	       3,       	      20,       	      28,       	      26,       	  MAX_UINT16,   	      60,       	      54,       	  MAX_UINT16,   	      130,      	      117,      	  MAX_UINT16,   	      260,      	      234,      	   MAX_UINT16   },
	{	     /*19*/     	LA_PHY_MODE_HT_VHT,	       0,       	       4,       	       4,       	      23,       	      43,       	      38,       	  MAX_UINT16,   	      90,       	      81,       	  MAX_UINT16,   	      195,      	      175,      	  MAX_UINT16,   	      390,      	      351,      	   MAX_UINT16   },
	{	     /*20*/     	LA_PHY_MODE_HT_VHT,	       0,       	       5,       	       5,       	      26,       	      57,       	      52,       	  MAX_UINT16,   	      120,      	      108,      	  MAX_UINT16,   	      260,      	      234,      	  MAX_UINT16,   	      520,      	      468,      	   MAX_UINT16   },
	{	     /*21*/     	LA_PHY_MODE_HT_VHT,	       0,       	       6,       	       6,       	      29,       	      65,       	      58,       	  MAX_UINT16,   	      135,      	      121,      	  MAX_UINT16,   	      292,      	      262,      	  MAX_UINT16,   	      585,      	      526,      	   MAX_UINT16   },
	{	     /*22*/     	LA_PHY_MODE_HT_VHT,	       0,       	       7,       	       7,       	      31,       	      72,       	      64,       	  MAX_UINT16,   	      150,      	      135,      	  MAX_UINT16,   	      325,      	      292,      	  MAX_UINT16,   	      650,      	      585,      	   MAX_UINT16   },
	{	     /*23*/     	LA_PHY_MODE_HT_VHT,	       0,       	HT_INVALID_MCS, 	       8,       	      32,       	      86,       	      78,       	  MAX_UINT16,   	      180,      	      162,      	  MAX_UINT16,   	      390,      	      351,      	  MAX_UINT16,   	      780,      	      702,      	   MAX_UINT16   },
	{	     /*24*/     	LA_PHY_MODE_HT_VHT,	       0,       	HT_INVALID_MCS, 	       9,       	      36,       	      96,   	          87,             MAX_UINT16,             200,      	      180,      	  MAX_UINT16,   	      433,      	      389,      	  MAX_UINT16,   	      866,      	      780,      	   MAX_UINT16   },
	{	     /*25*/     	LA_PHY_MODE_HT_VHT,	       1,       	       8,       	       0,       	      17,       	      14,       	      12,       	  MAX_UINT16,   	      30,       	      27,       	  MAX_UINT16,   	      65,       	      58,       	  MAX_UINT16,   	      130,      	      117,      	   MAX_UINT16   },
	{	     /*26*/     	LA_PHY_MODE_HT_VHT,	       1,       	       9,       	       1,       	      21,       	      28,       	      26,       	  MAX_UINT16,   	      60,       	      54,       	  MAX_UINT16,   	      130,      	      117,      	  MAX_UINT16,   	      260,      	      234,      	   MAX_UINT16   },
	{	     /*27*/     	LA_PHY_MODE_HT_VHT,	       1,       	      10,       	       2,       	      24,       	      43,       	      38,       	  MAX_UINT16,   	      90,       	      81,       	  MAX_UINT16,   	      195,      	      175,      	  MAX_UINT16,   	      390,      	      351,      	   MAX_UINT16   },
	{	     /*28*/     	LA_PHY_MODE_HT_VHT,	       1,       	      11,       	       3,       	      27,       	      57,       	      52,       	  MAX_UINT16,   	      120,      	      108,      	  MAX_UINT16,   	      260,      	      234,      	  MAX_UINT16,   	      520,      	      468,      	   MAX_UINT16   },
	{	     /*29*/     	LA_PHY_MODE_HT_VHT,	       1,       	      12,       	       4,       	      33,       	      86,       	      78,       	  MAX_UINT16,   	      180,      	      162,      	  MAX_UINT16,   	      390,      	      351,      	  MAX_UINT16,   	      780,      	      702,      	   MAX_UINT16   },
	{	     /*30*/     	LA_PHY_MODE_HT_VHT,	       1,       	      13,       	       5,       	      37,       	      115,      	      104,      	  MAX_UINT16,   	      240,      	      216,      	  MAX_UINT16,   	      520,      	      468,      	  MAX_UINT16,   	     1040,      	      936,      	   MAX_UINT16   },
	{	     /*31*/     	LA_PHY_MODE_HT_VHT,	       1,       	      14,       	       6,       	      39,       	      130,      	      117,      	  MAX_UINT16,   	      270,      	      243,      	  MAX_UINT16,   	      585,      	      526,      	  MAX_UINT16,   	     1170,      	     1053,      	   MAX_UINT16   },
	{	     /*32*/     	LA_PHY_MODE_HT_VHT,	       1,       	      15,       	       7,       	      41,       	      144,      	      129,      	  MAX_UINT16,   	      300,      	      270,      	  MAX_UINT16,   	      650,      	      585,      	  MAX_UINT16,   	     1300,      	     1170,      	   MAX_UINT16   },
	{	     /*33*/     	LA_PHY_MODE_HT_VHT,	       1,       	HT_INVALID_MCS, 	       8,       	      42,       	      173,      	      155,      	  MAX_UINT16,   	      360,      	      324,      	  MAX_UINT16,   	      780,      	      702,      	  MAX_UINT16,   	     1560,      	     1404,      	   MAX_UINT16   },
	{	     /*34*/     	LA_PHY_MODE_HT_VHT,	       1,       	HT_INVALID_MCS, 	       9,       	      45,       	      193,   	          173,            MAX_UINT16,   	      400,      	      360,      	  MAX_UINT16,   	      866,      	      780,      	  MAX_UINT16,   	     1733,      	     1560,      	   MAX_UINT16   },
	{	     /*35*/     	LA_PHY_MODE_HT_VHT,	       2,       	      16,       	       0,       	      19,       	      21,       	      19,       	  MAX_UINT16,   	      45,       	      40,       	  MAX_UINT16,   	      97,       	      87,       	  MAX_UINT16,   	      195,      	      175,      	   MAX_UINT16   },
	{	     /*36*/     	LA_PHY_MODE_HT_VHT,	       2,       	      17,       	       1,       	      25,       	      43,       	      38,       	  MAX_UINT16,   	      90,       	      81,       	  MAX_UINT16,   	      195,      	      175,      	  MAX_UINT16,   	      390,      	      351,      	   MAX_UINT16   },
	{	     /*37*/     	LA_PHY_MODE_HT_VHT,	       2,       	      18,       	       2,       	      30,       	      65,       	      58,       	  MAX_UINT16,   	      135,      	      121,      	  MAX_UINT16,   	      292,      	      263,      	  MAX_UINT16,   	      585,      	      526,      	   MAX_UINT16   },
	{	     /*38*/     	LA_PHY_MODE_HT_VHT,	       2,       	      19,       	       3,       	      34,       	      86,       	      78,       	  MAX_UINT16,   	      180,      	      162,      	  MAX_UINT16,   	      390,      	      351,      	  MAX_UINT16,   	      780,      	      702,      	   MAX_UINT16   },
	{	     /*39*/     	LA_PHY_MODE_HT_VHT,	       2,       	      20,       	       4,       	      40,       	      130,      	      117,      	  MAX_UINT16,   	      270,      	      243,      	  MAX_UINT16,   	      585,      	      526,      	  MAX_UINT16,   	     1170,      	     1053,      	   MAX_UINT16   },
	{	     /*40*/     	LA_PHY_MODE_HT_VHT,	       2,       	      21,       	       5,       	      43,       	      173,      	      155,      	  MAX_UINT16,   	      360,      	      324,      	  MAX_UINT16,   	      780,      	      702,      	  MAX_UINT16,   	     1560,      	     1404,      	   MAX_UINT16   },
	{	     /*41*/     	LA_PHY_MODE_HT_VHT,	       2,       	      22,       	       6,       	      46,       	      195,      	      175,      	  MAX_UINT16,   	      405,      	      364,      	  MAX_UINT16,   	      878,   	       790,   	          MAX_UINT16,   	     1755,      	     1579,      	   MAX_UINT16   },
	{	     /*42*/     	LA_PHY_MODE_HT_VHT,	       2,       	      23,       	       7,       	      47,       	      216,      	      195,      	  MAX_UINT16,   	      450,      	      405,      	  MAX_UINT16,   	      975,      	      877,      	  MAX_UINT16,   	     1950,      	     1755,      	   MAX_UINT16   },
	{	     /*43*/     	LA_PHY_MODE_HT_VHT,	       2,       	HT_INVALID_MCS, 	       8,       	      49,       	      260,      	      234,      	  MAX_UINT16,   	      540,      	      486,      	  MAX_UINT16,   	     1170,      	     1053,      	  MAX_UINT16,   	     2340,      	     2106,      	   MAX_UINT16   },
	{	     /*44*/     	LA_PHY_MODE_HT_VHT,	       2,       	HT_INVALID_MCS, 	       9,       	      51,       	      288,      	      260,      	  MAX_UINT16,   	      600,      	      540,      	  MAX_UINT16,   	     1300,      	     1170,      	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*45*/     	LA_PHY_MODE_HT_VHT,	       3,       	      24,       	       0,       	      22,       	      28,       	      26,       	  MAX_UINT16,   	      60,       	      54,       	  MAX_UINT16,   	      130,      	      117,      	  MAX_UINT16,   	      260,      	      234,      	   MAX_UINT16   },
	{	     /*46*/     	LA_PHY_MODE_HT_VHT,	       3,       	      25,       	       1,       	      28,       	      57,       	      52,       	  MAX_UINT16,   	      120,      	      108,      	  MAX_UINT16,   	      260,      	      234,      	  MAX_UINT16,   	      520,      	      468,      	   MAX_UINT16   },
	{	     /*47*/     	LA_PHY_MODE_HT_VHT,	       3,       	      26,       	       2,       	      35,       	      86,       	      78,       	  MAX_UINT16,   	      180,      	      162,      	  MAX_UINT16,   	      390,      	      351,      	  MAX_UINT16,   	      780,      	      702,      	   MAX_UINT16   },
	{	     /*48*/     	LA_PHY_MODE_HT_VHT,	       3,       	      27,       	       3,       	      38,       	      115,      	      104,      	  MAX_UINT16,   	      240,      	      216,      	  MAX_UINT16,   	      520,      	      468,      	  MAX_UINT16,   	     1040,      	      936,      	   MAX_UINT16   },
	{	     /*49*/     	LA_PHY_MODE_HT_VHT,	       3,       	      28,       	       4,       	      44,       	      173,      	      155,      	  MAX_UINT16,   	      360,      	      324,      	  MAX_UINT16,   	      780,      	      702,      	  MAX_UINT16,   	     1560,      	     1404,      	   MAX_UINT16   },
	{	     /*50*/     	LA_PHY_MODE_HT_VHT,	       3,       	      29,       	       5,       	      48,       	      231,      	      207,      	  MAX_UINT16,   	      480,      	      432,      	  MAX_UINT16,   	     1040,      	      936,      	  MAX_UINT16,   	     2080,      	     1872,      	   MAX_UINT16   },
	{	     /*51*/     	LA_PHY_MODE_HT_VHT,	       3,       	      30,       	       6,       	      50,       	      260,      	      234,      	  MAX_UINT16,   	      540,      	      486,      	  MAX_UINT16,   	     1170,      	     1053,      	  MAX_UINT16,   	     2340,      	     2106,      	   MAX_UINT16   },
	{	     /*52*/     	LA_PHY_MODE_HT_VHT,	       3,       	      31,       	       7,       	      52,       	      288,      	      260,      	  MAX_UINT16,   	      600,      	      540,      	  MAX_UINT16,   	     1300,      	     1170,      	  MAX_UINT16,   	     2600,      	     2340,      	   MAX_UINT16   },
	{	     /*53*/     	LA_PHY_MODE_HT_VHT,	       3,       	HT_INVALID_MCS, 	       8,       	      53,       	      346,      	      312,      	  MAX_UINT16,   	      720,      	      648,      	  MAX_UINT16,   	     1560,      	     1404,      	  MAX_UINT16,   	     3120,      	     2808,      	   MAX_UINT16   },
	{	     /*54*/     	LA_PHY_MODE_HT_VHT,	       3,       	HT_INVALID_MCS, 	       9,       	      54,       	      385,   	          347,   	      MAX_UINT16,   	      800,      	      720,      	  MAX_UINT16,   	     1733,      	     1559,      	  MAX_UINT16,   	     3466,      	     3120,      	   MAX_UINT16   },
	{	     /*55*/     	LA_PHY_MODE_HT_VHT,	       0,       	      32,       	   	 0xF, 	 	  	     0x7F,      	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   }
};
const uint8 htVhtSortPhyRateToRateIndexSameBw[NUMBER_OF_ALL_RATES_HT_VHT]=
/*
		   Sort phy index,    	  Rate table index,   
*/
{
		     /*0*/      	       11   ,
		     /*1*/      	       12   ,
		     /*2*/      	       8    ,
		     /*3*/      	       13   ,
		     /*4*/      	       9    ,
		     /*5*/      	       0    ,
		     /*6*/      	       1    ,
		     /*7*/      	       14   ,
		     /*8*/      	       10   ,
		     /*9*/      	       2    ,
		     /*10*/     	       3    ,
		     /*11*/     	       4    ,
		     /*12*/     	       5    ,
		     /*13*/     	       6    ,
		     /*14*/     	       7    ,
		     /*15*/     	       15   ,
		     /*16*/     	       16   ,
		     /*17*/     	       25   ,
		     /*18*/     	       17   ,
		     /*19*/     	       35   ,
		     /*20*/     	       18   ,
		     /*21*/     	       26   ,
		     /*22*/     	       45   ,
		     /*23*/     	       19   ,
		     /*24*/     	       27   ,
		     /*25*/     	       36   ,
		     /*26*/     	       20   ,
		     /*27*/     	       28   ,
		     /*28*/     	       46   ,
		     /*29*/     	       21   ,
		     /*30*/     	       37   ,
		     /*31*/     	       22   ,
		     /*32*/     	       23   ,
		     /*33*/     	       29   ,
		     /*34*/     	       38   ,
		     /*35*/     	       47   ,
		     /*36*/     	       24   ,
		     /*37*/     	       30   ,
		     /*38*/     	       48   ,
		     /*39*/     	       31   ,
		     /*40*/     	       39   ,
		     /*41*/     	       32   ,
		     /*42*/     	       33   ,
		     /*43*/     	       40   ,
		     /*44*/     	       49   ,
		     /*45*/     	       34   ,
		     /*46*/     	       41   ,
		     /*47*/     	       42   ,
		     /*48*/     	       50   ,
		     /*49*/     	       43   ,
		     /*50*/     	       51   ,
		     /*51*/     	       44   ,
		     /*52*/     	       52   ,
		     /*53*/     	       53   ,
		     /*54*/     	       54   
};
#ifdef ENET_INC_ARCH_WAVE600
const RateObj_t heRatesTable[NUMBER_OF_ALL_RATES_HE]=
/*
																																	PHY rate			    PHY rate		PHY rate		 PHY rate			    PHY rate		          PHY rate		          PHY rate			    PHY rate			    PHY rate			    PHY rate				PHY rate			    PHY rate 
			 rate index,			phy mode,		 numberOfNss,			  ht MCS,		vht_HE_Mcs, 	 sortPhyRateSameBwIndex,(SCP, 20 MHz),		(MCP, 20 MHz),		(LCP, 20 MHz),  (SCP, 40 MHz),		(MCP, 40 MHz),		(LCP, 40 MHz),		 (SCP, 80 MHz), 		(MCP, 80 MHz),		(LCP, 80 MHz),		(SCP, 160 MHz), 		 (MCP, 160 MHz),		(LCP, 160 MHz), 
*/
{
	{	     /*0*/      	LA_PHY_MODE_11AG,	       0,       	       0,       	       0,       	       5,       	       6,       	       6,       	       6,    	  	MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*1*/      	LA_PHY_MODE_11AG,	       0,       	       1,       	       1,       	       6,       	       9,       	       9,       	       9,    	   	MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*2*/      	LA_PHY_MODE_11AG,	       0,       	       2,       	       2,       	       9,       	      12,       	      12,       	      12,    	  	MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*3*/      	LA_PHY_MODE_11AG,	       0,       	       3,       	       3,       	      10,       	      18,       	      18,       	      18,    	  	MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*4*/      	LA_PHY_MODE_11AG,	       0,       	       4,       	       4,       	      11,       	      24,       	      24,       	      24,    	  	MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*5*/      	LA_PHY_MODE_11AG,	       0,       	       5,       	       5,       	      12,       	      36,       	      36,       	      36,    	  	MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*6*/      	LA_PHY_MODE_11AG,	       0,       	       6,       	       6,       	      13,       	      48,       	      48,       	      48,    	  	MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*7*/      	LA_PHY_MODE_11AG,	       0,       	       7,       	       7,       	      14,       	      54,       	      54,       	      54,    	  	MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*8*/      	LA_PHY_MODE_11B ,	       0,       	       1,       	       1,       	       2,       	       2,       	       2,       	       2,    	   	MAX_UINT16,  	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*9*/      	LA_PHY_MODE_11B ,	       0,       	       2,       	       2,       	       4,       	       5,       	       5,       	       5,    	   	MAX_UINT16,  	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*10*/     	LA_PHY_MODE_11B ,	       0,       	       3,       	       3,       	       8,       	      11,       	      11,       	      11,    	  	MAX_UINT16,  	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*11*/     	LA_PHY_MODE_11B ,	       0,       	       4,       	       4,       	       0,       	       1,       	       1,       	       1,    	  	MAX_UINT16,  	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*12*/     	LA_PHY_MODE_11B ,	       0,       	       5,       	       5,       	       1,       	       2,       	       2,       	       2,    	   	MAX_UINT16,  	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*13*/     	LA_PHY_MODE_11B ,	       0,       	       6,       	       6,       	       3,       	       5,       	       5,       	       5,    	   	MAX_UINT16,  	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*14*/     	LA_PHY_MODE_11B ,	       0,       	       7,       	       7,       	       7,       	      11,       	      11,       	      11,    	  	MAX_UINT16,  	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	  MAX_UINT16,   	   MAX_UINT16   },
	{	     /*15*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	       0,       	      15,       	       8,       	       8,       	       7,       	      17,       	      16,       	      14,       	      36,       	      34,       	      30,       	      72,       	      68,       	       61       },
	{	     /*16*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	       1,       	      16,       	      17,       	      16,       	      14,       	      34,       	      32,       	      29,       	      72,       	      68,       	      61,       	      144,      	      136,      	      122       },
	{	     /*17*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	       2,       	      18,       	      25,       	      24,       	      22,       	      51,       	      48,       	      43,       	      108,      	      102,      	      91,       	      216,      	      204,      	      183       },
	{	     /*18*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	       3,       	      20,       	      34,       	      32,       	      29,       	      68,       	      65,       	      58,       	      144,      	      136,      	      122,      	      288,      	      272,      	      245       },
	{	     /*19*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	       4,       	      23,       	      51,       	      48,       	      43,       	      103,      	      97,       	      87,       	      216,      	      204,      	      183,      	      432,      	      408,      	      367       },
	{	     /*20*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	       5,       	      26,       	      68,       	      65,       	      58,       	      137,      	      130,      	      117,      	      288,      	      272,      	      245,      	      576,      	      544,      	      490       },
	{	     /*21*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	       6,       	      29,       	      77,       	      73,       	      65,       	      154,      	      146,      	      131,      	      324,      	      306,      	      275,      	      648,      	      612,      	      551       },
	{	     /*22*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	       7,       	      31,       	      86,       	      81,       	      73,       	      172,      	      162,      	      146,      	      360,      	      340,      	      306,      	      720,      	      680,      	      612       },
	{	     /*23*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	       8,       	      32,       	      103,      	      97,       	      87,       	      206,      	      195,      	      175,      	      432,      	      408,      	      367,      	      864,      	      816,      	      735       },
	{	     /*24*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	       9,       	      36,       	      114,      	      108,      	      97,       	      229,      	      216,      	      195,      	      480,      	      453,      	      408,      	      960,      	      907,      	      816       },
	{	     /*25*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	      10,       	      37,       	      129,      	      121,      	      109,      	      258,      	      243,      	      219,      	      540,      	      510,      	      459,      	     1080,      	     1020,      	      918       },
	{	     /*26*/     	LA_PHY_MODE_HE  ,	       0,       	       0,       	      11,       	      40,       	      143,      	      135,      	      121,      	      286,      	      270,      	      243,      	      600,      	      567,      	      510,      	     1201,      	     1134,      	      1020      },
	{	     /*27*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	       0,       	      17,       	      17,       	      16,       	      14,       	      34,       	      32,       	      29,       	      72,       	      68,       	      61,       	      144,      	      136,      	      122       },
	{	     /*28*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	       1,       	      21,       	      34,       	      32,       	      29,       	      68,       	      65,       	      58,       	      144,      	      136,      	      122,      	      288,      	      272,      	      245       },
	{	     /*29*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	       2,       	      24,       	      51,       	      48,       	      43,       	      103,      	      97,       	      87,       	      216,      	      204,      	      183,      	      432,      	      408,      	      367       },
	{	     /*30*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	       3,       	      27,       	      68,       	      65,       	      58,       	      137,      	      130,      	      117,      	      288,      	      272,      	      245,      	      576,      	      544,      	      490       },
	{	     /*31*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	       4,       	      33,       	      103,      	      97,       	      87,       	      206,      	      195,      	      175,      	      432,      	      408,      	      367,      	      864,      	      816,      	      735       },
	{	     /*32*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	       5,       	      38,       	      137,      	      130,      	      117,      	      275,      	      260,      	      234,      	      576,      	      544,      	      490,      	     1153,      	     1088,      	      980       },
	{	     /*33*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	       6,       	      41,       	      154,      	      146,      	      131,      	      309,      	      292,      	      263,      	      648,      	      612,      	      551,      	     1297,      	     1225,      	      1102      },
	{	     /*34*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	       7,       	      43,       	      172,      	      162,      	      146,      	      344,      	      325,      	      292,      	      720,      	      680,      	      612,      	     1441,      	     1361,      	      1225      },
	{	     /*35*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	       8,       	      44,       	      206,      	      195,      	      175,      	      413,      	      390,      	      351,      	      864,      	      816,      	      735,      	     1729,      	     1633,      	      1470      },
	{	     /*36*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	       9,       	      47,       	      229,      	      216,      	      195,      	      458,      	      433,      	      390,      	      960,      	      907,      	      816,      	     1921,      	     1814,      	      1633      },
	{	     /*37*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	      10,       	      49,       	      258,      	      243,      	      219,      	      516,      	      487,      	      438,      	     1080,      	     1020,      	      918,      	     2161,      	     2041,      	      1837      },
	{	     /*38*/     	LA_PHY_MODE_HE  ,	       1,       	       0,       	      11,       	      52,       	      286,      	      270,      	      243,      	      573,      	      541,      	      487,      	     1201,      	     1134,      	     1020,      	     2402,      	     2268,      	      2041      },
	{	     /*39*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	       0,       	      19,       	      25,       	      24,       	      22,       	      51,       	      48,       	      43,       	      108,      	      102,      	      91,       	      216,      	      204,      	      183       },
	{	     /*40*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	       1,       	      25,       	      51,       	      48,       	      43,       	      103,      	      97,       	      87,       	      216,      	      204,      	      183,      	      432,      	      408,      	      367       },
	{	     /*41*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	       2,       	      30,       	      77,       	      73,       	      65,       	      154,      	      146,      	      131,      	      324,      	      306,      	      275,      	      648,      	      612,      	      551       },
	{	     /*42*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	       3,       	      34,       	      103,      	      97,       	      87,       	      206,      	      195,      	      175,      	      432,      	      408,      	      367,      	      864,      	      816,      	      735       },
	{	     /*43*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	       4,       	      42,       	      154,      	      146,      	      131,      	      309,      	      292,      	      263,      	      648,      	      612,      	      551,      	     1297,      	     1225,      	      1102      },
	{	     /*44*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	       5,       	      45,       	      206,      	      195,      	      175,      	      413,      	      390,      	      351,      	      864,      	      816,      	      735,      	     1729,      	     1633,      	      1470      },
	{	     /*45*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	       6,       	      48,       	      232,      	      219,      	      197,      	      464,      	      438,      	      394,      	      972,      	      918,      	      826,      	     1945,      	     1837,      	      1653      },
	{	     /*46*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	       7,       	      50,       	      258,      	      243,      	      219,      	      516,      	      487,      	      438,      	     1080,      	     1020,      	      918,      	     2161,      	     2041,      	      1837      },
	{	     /*47*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	       8,       	      53,       	      309,      	      292,      	      263,      	      619,      	      585,      	      526,      	     1297,      	     1225,      	     1102,      	     2594,      	     2450,      	      2205      },
	{	     /*48*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	       9,       	      55,       	      344,      	      325,      	      292,      	      688,      	      650,      	      585,      	     1441,      	     1361,      	     1225,      	     2882,      	     2722,      	      2450      },
	{	     /*49*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	      10,       	      57,       	      387,      	      365,      	      329,      	      774,      	      731,      	      658,      	     1621,      	     1531,      	     1378,      	     3242,      	     3062,      	      2756      },
	{	     /*50*/     	LA_PHY_MODE_HE  ,	       2,       	       0,       	      11,       	      59,       	      430,      	      406,      	      365,      	      860,      	      812,      	      731,      	     1801,      	     1701,      	     1531,      	     3603,      	     3402,      	      3062      },
	{	     /*51*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	       0,       	      22,       	      34,       	      32,       	      29,       	      68,       	      65,       	      58,       	      144,      	      136,      	      122,      	      288,      	      272,      	      245       },
	{	     /*52*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	       1,       	      28,       	      68,       	      65,       	      58,       	      137,      	      130,      	      117,      	      288,      	      272,      	      245,      	      576,      	      544,      	      490       },
	{	     /*53*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	       2,       	      35,       	      103,      	      97,       	      87,       	      206,      	      195,      	      175,      	      432,      	      408,      	      367,      	      864,      	      816,      	      735       },
	{	     /*54*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	       3,       	      39,       	      137,      	      130,      	      117,      	      275,      	      260,      	      234,      	      576,      	      544,      	      490,      	     1153,      	     1088,      	      980       },
	{	     /*55*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	       4,       	      46,       	      206,      	      195,      	      175,      	      413,      	      390,      	      351,      	      864,      	      816,      	      735,      	     1729,      	     1633,      	      1470      },
	{	     /*56*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	       5,       	      51,       	      275,      	      260,      	      234,      	      550,      	      520,      	      468,      	     1153,      	     1088,      	      980,      	     2305,      	     2177,      	      1960      },
	{	     /*57*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	       6,       	      54,       	      309,      	      292,      	      263,      	      619,      	      585,      	      526,      	     1297,      	     1225,      	     1102,      	     2594,      	     2450,      	      2205      },
	{	     /*58*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	       7,       	      56,       	      344,      	      325,      	      292,      	      688,      	      650,      	      585,      	     1441,      	     1361,      	     1225,      	     2882,      	     2722,      	      2450      },
	{	     /*59*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	       8,       	      58,       	      413,      	      390,      	      351,      	      825,      	      780,      	      702,      	     1729,      	     1633,      	     1470,      	     3458,      	     3266,      	      2940      },
	{	     /*60*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	       9,       	      60,       	      458,      	      433,      	      390,      	      917,      	      866,      	      780,      	     1921,      	     1814,      	     1633,      	     3843,      	     3629,      	      3266      },
	{	     /*61*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	      10,       	      61,       	      516,      	      487,      	      438,      	     1032,      	      975,      	      877,      	     2161,      	     2041,      	     1837,      	     4323,      	     4083,      	      3675      },
	{	     /*62*/     	LA_PHY_MODE_HE  ,	       3,       	       0,       	      11,       	      62,       	      573,      	      541,      	      487,      	     1147,      	     1083,      	      975,      	     2402,      	     2268,      	     2041,      	     4803,      	     4537,      	      4083      }
};
const uint8 heSortPhyRateToRateIndexSameBw[NUMBER_OF_ALL_RATES_HE]=
/*
		   Sort phy index,    	  Rate table index,   
*/
{
	     /*0*/      	       11     ,
	     /*1*/      	       12     ,
	     /*2*/      	       8      ,
	     /*3*/      	       13     ,
	     /*4*/      	       9      ,
	     /*5*/      	       0      ,
	     /*6*/      	       1      ,
	     /*7*/      	       14     ,
	     /*8*/      	       10     ,
	     /*9*/      	       2      ,
	     /*10*/     	       3      ,
	     /*11*/     	       4      ,
	     /*12*/     	       5      ,
	     /*13*/     	       6      ,
	     /*14*/     	       7      ,
	     /*15*/     	       15     ,
	     /*16*/     	       16     ,
	     /*17*/     	       27     ,
	     /*18*/     	       17     ,
	     /*19*/     	       39     ,
	     /*20*/     	       18     ,
	     /*21*/     	       28     ,
	     /*22*/     	       51     ,
	     /*23*/     	       19     ,
	     /*24*/     	       29     ,
	     /*25*/     	       40     ,
	     /*26*/     	       20     ,
	     /*27*/     	       30     ,
	     /*28*/     	       52     ,
	     /*29*/     	       21     ,
	     /*30*/     	       41     ,
	     /*31*/     	       22     ,
	     /*32*/     	       23     ,
	     /*33*/     	       31     ,
	     /*34*/     	       42     ,
	     /*35*/     	       53     ,
	     /*36*/     	       24     ,
	     /*37*/     	       25     ,
	     /*38*/     	       32     ,
	     /*39*/     	       54     ,
	     /*40*/     	       26     ,
	     /*41*/     	       33     ,
	     /*42*/     	       43     ,
	     /*43*/     	       34     ,
	     /*44*/     	       35     ,
	     /*45*/     	       44     ,
	     /*46*/     	       55     ,
	     /*47*/     	       36     ,
	     /*48*/     	       45     ,
	     /*49*/     	       37     ,
	     /*50*/     	       46     ,
	     /*51*/     	       56     ,
	     /*52*/     	       38     ,
	     /*53*/     	       47     ,
	     /*54*/     	       57     ,
	     /*55*/     	       48     ,
	     /*56*/     	       58     ,
	     /*57*/     	       49     ,
	     /*58*/     	       59     ,
	     /*59*/     	       50     ,
	     /*60*/     	       60     ,
	     /*61*/     	       61     ,
	     /*62*/     	       62     
};
#endif
const uint8 htTcr2RateIndex[HT_NUMBER_OF_MCS] = 
/*
		    Ht Tcr value,     	     Rate index,      
*/
{
		     /*0*/      	       15       ,
		     /*1*/      	       16       ,
		     /*2*/      	       17       ,
		     /*3*/      	       18       ,
		     /*4*/      	       19       ,
		     /*5*/      	       20       ,
		     /*6*/      	       21       ,
		     /*7*/      	       22       ,
		     /*8*/      	       25       ,
		     /*9*/      	       26       ,
		     /*10*/     	       27       ,
		     /*11*/     	       28       ,
		     /*12*/     	       29       ,
		     /*13*/     	       30       ,
		     /*14*/     	       31       ,
		     /*15*/     	       32       ,
		     /*16*/     	       35       ,
		     /*17*/     	       36       ,
		     /*18*/     	       37       ,
		     /*19*/     	       38       ,
		     /*20*/     	       39       ,
		     /*21*/     	       40       ,
		     /*22*/     	       41       ,
		     /*23*/     	       42       ,
		     /*24*/     	       45       ,
		     /*25*/     	       46       ,
		     /*26*/     	       47       ,
		     /*27*/     	       48       ,
		     /*28*/     	       49       ,
		     /*29*/     	       50       ,
		     /*30*/     	       51       ,
		     /*31*/     	       52       ,
		     /*32*/     	       55       
};

const uint8  vhtTcr2RateIndex[VHT_NUMBER_OF_MCS][SPATIAL_STREAM_NUM] = 
/*
		      MCS/NSS,        	             NSS 1,   	             NSS 2,   	             NSS 3,   	             NSS 4,   
*/
{
	{	     /*0*/      	      15,       	      25,       	      35,       	       45       },
	{	     /*1*/      	      16,       	      26,       	      36,       	       46       },
	{	     /*2*/      	      17,       	      27,       	      37,       	       47       },
	{	     /*3*/      	      18,       	      28,       	      38,       	       48       },
	{	     /*4*/      	      19,       	      29,       	      39,       	       49       },
	{	     /*5*/      	      20,       	      30,       	      40,       	       50       },
	{	     /*6*/      	      21,       	      31,       	      41,       	       51       },
	{	     /*7*/      	      22,       	      32,       	      42,       	       52       },
	{	     /*8*/      	      23,       	      33,       	      43,       	       53       },
	{	     /*9*/      	      24,       	      34,       	      44,       	       54       }
};
#ifdef ENET_INC_ARCH_WAVE600
const uint8  heTcr2RateIndex[HE_NUMBER_OF_MCS][SPATIAL_STREAM_NUM] = 
/*
		      MCS/NSS,        	             NSS 1,   	             NSS 2,   	             NSS 3,   	             NSS 4,   
*/
{
	{	     /*0*/      	      15,       	      27,       	      39,       	       51       },
	{	     /*1*/      	      16,       	      28,       	      40,       	       52       },
	{	     /*2*/      	      17,       	      29,       	      41,       	       53       },
	{	     /*3*/      	      18,       	      30,       	      42,       	       54       },
	{	     /*4*/      	      19,       	      31,       	      43,       	       55       },
	{	     /*5*/      	      20,       	      32,       	      44,       	       56       },
	{	     /*6*/      	      21,       	      33,       	      45,       	       57       },
	{	     /*7*/      	      22,       	      34,       	      46,       	       58       },
	{	     /*8*/      	      23,       	      35,       	      47,       	       59       },
	{	     /*9*/      	      24,       	      36,       	      48,       	       60       },
	{	     /*10*/     	      25,       	      37,       	      49,       	       61       },
	{	     /*11*/     	      26,       	      38,       	      50,       	       62       }
};
#endif
LinkAdaptationPhyMode_e ConvertTcrPhyMode2LaPhyMode[PHY_MODE_LAST] = 
{
	LA_PHY_MODE_11AG,
	LA_PHY_MODE_11B,
	LA_PHY_MODE_HT_VHT,
	LA_PHY_MODE_HT_VHT,
#ifdef ENET_INC_ARCH_WAVE600
	LA_PHY_MODE_HE,
	LA_PHY_MODE_HE,
	LA_PHY_MODE_HE,
	LA_PHY_MODE_HE
#endif
};

RatesTablesDb_t htVhtRatesTablesDb = {htVhtRatesTable, htVhtSortPhyRateToRateIndexSameBw, NUMBER_OF_ALL_RATES_HT_VHT};
#ifdef ENET_INC_ARCH_WAVE600
RatesTablesDb_t heRatesTablesDb = {heRatesTable, heSortPhyRateToRateIndexSameBw, NUMBER_OF_ALL_RATES_HE};
#endif
/**********************************************************************************
linkAdaptationSetTransmissionTimeLimit




Description:
------------
Change maxPsduTransmissionTimeLimit 
HW semaphore protection required

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
void linkAdaptationSetTransmissionTimeLimit(StaId staId, uint16 transmissionTime)
{
	StaDb_t*			pStaDbHwEntries;
	uint8 				tidIndex;
	StaDbTid_t* 		pStaTidEntry;
	uint8 				numOfAllTids; 

	DEBUG_ASSERT(staId < HW_NUM_OF_STATIONS);

	pStaDbHwEntries = &StaDbHwEntries[staId];
	
	//("linkAdaptationSetTransmissionTimeLimit staId: %d transmission time: %d", staId, transmissionTime);

	/* Use HW semaphore for writing to StaDbTid_t Word 1 */
#if defined(ENET_INC_ARCH_WAVE600)
	HW_SEMAPHORE_LOCK(HW_SEMAPHORE_TID_PARAMS_WORD_1);
	numOfAllTids = NUM_OF_TOTAL_TIDS; 
#else
	HW_SEMAPHORE_LOCK(HW_SEMAPHORE_1_17_TID_PARAMS_WORD_1_LM);
	numOfAllTids = NUM_OF_TIDS; 
#endif
	
	/* Change TransmissionTime parameter in staDb */
	for (tidIndex = 0 ; tidIndex < numOfAllTids ; tidIndex++)
	{
		pStaTidEntry = (StaDbTid_t*)&(pStaDbHwEntries->tid[tidIndex]);
		pStaTidEntry->maxPsduTransmissionTimeLimit = (transmissionTime >> 1); // time resolution is 2microSec
	}
#if defined(ENET_INC_ARCH_WAVE600)
	HW_SEMAPHORE_FREE(HW_SEMAPHORE_TID_PARAMS_WORD_1);
#else
	HW_SEMAPHORE_FREE(HW_SEMAPHORE_1_17_TID_PARAMS_WORD_1_LM);
#endif
}

#ifdef ENET_INC_ARCH_WAVE600
void linkAdaptationProcessUlprReport(LaUlprReport_t *ulprReport, bool isOmiReceived)
{
	uint8 mcs; 
	uint8 ruSize;
	int8 rssi; 
	StaId staId;
	LnaType_e newLnaType;

	staId = ulprReport->ulprUserReport.staId;
	rssi = ulprReport->ulprUserReport.maxFdRssi;
	mcs = EXTRACT_MCS_FROM_VHT_HE_RATE(ulprReport->ulprUserReport.rate);
	if (ulprReport->ulprCommonReport.reportType == PHY_MODE_11AX_SU)
	{
		ruSize = CONVERT_BW_TO_RU_SIZE(ulprReport->ulprCommonReport.rcvdBw);
		newLnaType = ULPC_calcLnaType(rssi, mcs, ruSize);
		if (newLnaType != LinkAdaptationStaDatabase[staId].laStationUnique.ulPcParams.lnaType)
		{
			/* Update LNA type in STA DB */
			LinkAdaptationStaDatabase[staId].laStationUnique.ulPcParams.lnaType = newLnaType;
			sendLnaTypeHasChangedIndToHeGm(staId, newLnaType);
		}	
		/* Update Normalized RSSI in STA DB */
		LinkAdaptationStaDatabase[staId].laStationUnique.ulPcParams.normalizedRssi = ULPC_calcNormalizedRssi(rssi, mcs);
		if (isOmiReceived == TRUE)
		{
			ILOG0_V("[linkAdaptationProcessUlprReport] reportType == PHY_MODE_11AX_SU, isOmiReceived == TRUE");
			SLOG0(0, 0, LaUlPostRxOmiControl_u, &ulprReport->omiControl);
			overrideUlPhaseAfterOmiRx(ulprReport, 0, (uint8)DATA_PHASE_BIT_INDEX);
		}
	}
	else
	{
		DEBUG_ASSERT(ulprReport->ulprCommonReport.reportType == PHY_MODE_11AX_MU_TRIG);
#ifdef WORKAROUND_FOR_HW_BUG_IN_PS_SETTING_IN_TWT
        TxSelector_ResetPsRequestForTwt(staId);
#endif
		ruSize = ulprReport->ulprUserReport.ruSize;
		if (isOmiReceived == TRUE)
		{
			ILOG0_V("[linkAdaptationProcessUlprReport] reportType != PHY_MODE_11AX_SU, isOmiReceived == TRUE");
			SLOG0(0, 0, LaUlPostRxOmiControl_u, &ulprReport->omiControl);
			overrideUlPhaseAfterOmiRx(ulprReport, ulprReport->ulprCommonReport.planIndex, (uint8)(ulprReport->ulprCommonReport.phaseIndex));
		}
		// TBD - Update Normalized RSSI in STA DB in case of MU
	}
}
#endif

#ifdef ENET_INC_ARCH_WAVE600B
void linkAdaptationProcessPreAggReport(PreAggFullReport_t* preAggReport)
{	
#ifdef PF6_MU_BAR_PATCH
	overrideMinNumberOfUsersForTransmission(&preAggReport->commonReport);
#endif //PF6_MU_BAR_PATCH

#ifdef BSRC_ARTIFICIAL_UPDATE_FOR_UL
	// If fixed TF interval is used, reset the counters here to prevent from more TF to be sent, until we will reset it in linkAdaptationProcessSequencerReportQueue
	if (preAggReport->commonReport.phaseType == PHASE_TYPE_UL_DATA_PHASE)
	{
		if (Bsrc_GetTfFixedInterval() == TRUE)
		{
			LinkAdaptation_ClearBsrcCountersForStaticPlan();
		}
	}
#endif
}
#endif

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************
LinkAdaptation_Task



Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/

void LinkAdaptation_Task(K_MSG *psMsg)	
{
	vTaskDispatcher(psMsg, afpTaskTable, TASK_LINK_ADAPTATION_START, TASK_LINK_ADAPTATION_END);
}

/**********************************************************************************
LinkAdaptation_Init


Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif

void LinkAdaptation_Init(void)
{
	uint16 index;
	uint8 firstVapInBand = ConfigurationManager_GetFirstVapForMyBand();
	uint8 numOfVapsInBand = ConfigurationManager_GetNumOfVapsInMyBand();
	StaId firstSidInBand = ConfigurationManager_GetFirstSidInMyBand();
	uint16 numOfSidsInBand = ConfigurationManager_GetNumOfSupportedStationsInMyBand();


	linkAdaptationConfigurationParamsInit();
#ifdef LINK_ADAPTATION_REGISTRATION
	linkAdaptationRegistrationTablesInit();
#endif

	for (index = firstSidInBand; index < (firstSidInBand + numOfSidsInBand); index++)
	{
		memset ( &LinkAdaptationStaDatabase[index], 0, sizeof(LinkAdaptationStaDatabase_t));

		LinkAdaptationStaDatabase[index].laStaGroupCommon.pLinkAdaptationConfigurationParams = &LinkAdaptationConfigParamsFastInit;
	}
	for (index = firstVapInBand; index < (firstVapInBand + numOfVapsInBand); index++)
	{
		memset ( &LinkAdaptationVapDatabase[index], 0, sizeof(LinkAdaptationVapDatabase_t));
	}

	/*init group dataBase*/
	for (index = 0; index < TX_MU_GROUPS; index++)
	{
		memset ( &LinkAdaptationVhtGroupDatabase[index], 0, sizeof(LinkAdaptationVhtGroupDatabase_t));
		LinkAdaptationVhtGroupDatabase[index].laStaGroupCommon.pLinkAdaptationConfigurationParams = &LinkAdaptationConfigParamsFastInit;
	}	
#ifdef ENET_INC_ARCH_WAVE600
	/*initialize He Phase free bitmap to 1s, according to NUM_OF_LA_HE_MU_DB_ENTRIES */
	heDlDataPhaseActiveGroupsBitmapPerBand = 0x0;
#if defined (ENET_INC_LMAC0)
/*Common RAM should be initialized only once from LM0*/
	/*initialize He Phase dataBase*/
	for (index = 0; index < NUM_OF_LA_HE_MU_DB_ENTRIES; index++)
	{
		memset ( &LinkAdaptationHePhaseDatabase[index], 0, sizeof(LinkAdaptationHePhaseDatabase_t));
		LinkAdaptationHePhaseDatabase[index].laHeGroupUnique.planIndex = HE_GROUP_MANAGER_INVALID_PLAN_INDEX;
		LinkAdaptationHePhaseDatabase[index].laStaGroupCommon.pLinkAdaptationConfigurationParams = &LinkAdaptationConfigParamsFastInit;
	}
#endif	
#endif
	VhtGroupActiveGroupsBitmap = 0x0;
	AntennaSelectionInit();	
#ifndef ENET_INC_ARCH_WAVE600
	CddInit();
#endif
	PowerAdaptationInit();
	ProtectionAdaptation_Init(); 
	rateAdaptationInit();
	BwAdaptation_Init(); 
	estimatorsInit();
	CyclicPrefixAdaptationInit();
	LinkAdaptationPhyDriver_Init();
	BeamformingInit();

	DynamicTxop_Init();
	QAMplusEnable = FALSE;
	QAMplusEnableFromDriver = TRUE;

	linkAdaptationLocalParam.numberOfElementInTxSequencerFifo = 0x0;
//	linkAdaptationLocalParam.numberOfElementInBaaFifo = 0x0;

#ifdef LINK_ADAPTATION_TEST_ENV
	testParams.testType=NO_TEST;
#endif
	memset(&FixedRateParameters, 0, sizeof(LaFixedRateParams_t));
	memset(&FixedPowerParameters, 0, sizeof(LaFixedPowerParams_t));
	fixedCpParams.isAuto = 1;
	maxMpduLenLimit = MAX_MPDU_LENGTH_OPTION3_VHT;
    GroupsMetricsCalculator_Init();
	memset(&LastBaaReport, 0, sizeof(LastBaaReport));
	memset(&BaReportReceivedForUserIndication, 0, sizeof(BaReportReceivedForUserIndication));

}


#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default 
#endif

/**********************************************************************************
linkAdaptationProcessSequencerReportQueue

Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationProcessSequencerReportQueue(K_MSG *psMsg)
{
	StaId staIndex;
	uint8 numberOfEntriesRead = 0;
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter;
	UNUSED_PARAM(psMsg);
	bool processReport = TRUE;

	linkAdaptationLocalParam.numberOfElementInTxSequencerFifo = TxSequencer_GetFifoNumEntriesCount();
	DEBUG_ASSERT(linkAdaptationLocalParam.numberOfElementInTxSequencerFifo !=0);
	do
	{
		numberOfEntriesRead++;
		TxSequencer_GetFifoEntry(&CurrentSequencerReport);
#ifdef LINK_ADAPTATION_LOGS
		if (enableExtraLogs)
		{
			SLOG0(0, 0, TxSequencerReport_t, &CurrentSequencerReport);
		}
#endif

		//linkAdaptationLocalParam.numberOfElementInBaaFifo = CurrentSequencerReport.numberOfBaa;
		if (CurrentSequencerReport.reportType != SEQ_REPORT_TYPE_SEQUENCER_MU_MULT_USERS_TRAINING)
		{
			staIndex =	TxSequencer_GetStationIndex(&CurrentSequencerReport);
			if((staIndex < HW_NUM_OF_STATIONS) && (StaDbSwEntries[staIndex].state == STA_STATE_CONNECTED))
			{
				if (CurrentSequencerReport.reportType == SEQ_REPORT_TYPE_SEQUENCER_SU)
				{
						updateLaDbDistributionParam(&laDbDistributionParameter,staIndex, INVALID_MU_USP_INDEX, FALSE);

				}
				else if (CurrentSequencerReport.reportType == SEQ_REPORT_TYPE_SEQUENCER_VHT_MU)
				{
						updateLaDbDistributionParam(&laDbDistributionParameter,CurrentSequencerReport.vhtMuGroupIndex, CurrentSequencerReport.primaryUsp, FALSE);
				}
#ifdef ENET_INC_ARCH_WAVE600
				else if (CurrentSequencerReport.reportType == SEQ_REPORT_TYPE_SEQUENCER_HE_MU)
				{
					if (getPhaseTypeFromPlanIndex(CurrentSequencerReport.heMuPlanIndex, CurrentSequencerReport.heMuPhaseIndex) == PHASE_TYPE_DL_DATA_PHASE)
					{
						updateLaDbDistributionParam(&laDbDistributionParameter,getLaPhaseIdFromPlanIndex(CurrentSequencerReport.heMuPlanIndex, CurrentSequencerReport.heMuPhaseIndex), DONT_CARE_MU_USP_INDEX, TRUE);
					}
					else
					{
						processReport = FALSE;

					}				
#if defined(BSRC_ARTIFICIAL_UPDATE_FOR_UL)
					// after trigger frame is sent init BSRC so that next trigger frame will be sent only when timer is up
					if(CurrentSequencerReport.executedUlTf == 1)
					{
						LinkAdaptation_ClearBsrcCountersForStaticPlan();
					}
#endif // BSRC_ARTIFICIAL_UPDATE_FOR_UL
				}
#endif
				else
				{
					// we are expecting only for the supported types from SeqReportType_e
					FATAL("linkAdaptationProcessSequencerReportQueue"); 
				}
				
				if (processReport == TRUE)
				{
					/*Call estimators module for proccesing report*/
					laStateMachineProcessSequencerReport(&laDbDistributionParameter,&CurrentSequencerReport);
				}
			}
		}
#ifndef TRAINING_WAVE600_Z0		
		if (CurrentSequencerReport.reportType == SEQ_REPORT_TYPE_SEQUENCER_MU_MULT_USERS_TRAINING)
		{
			/*If we didn't send PHY_NDP, the PD won't be popped and though we will recieve several messages on one Tx trogerring, 
			what will cause illigal event in NDPA, so this check validating the pop already done*/
			if(CurrentSequencerReport.executedPhyNdp == TRUE) 
			{
				K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(LaBfReportInd_t));
				LaBfReportInd_t *bfReportInd = (LaBfReportInd_t *)pK_MSG_DATA(kMsg_p);			
			
				/*get the transaction number again - in case that the station is not connected
				- it is the first time it is updated and the while loop will break in the next 
				interation according to above logic or if it is the last report to process*/
				
				bfReportInd->status = FALSE;
				if(CurrentSequencerReport.executedTrainingFiller == TRUE)
				{
					bfReportInd->status = TRUE;
				}
				OSAL_SEND_MESSAGE(NDPA_MANAGER_LA_BF_REPORT_IND,TASK_GROUP_MANAGER,kMsg_p, CurrentSequencerReport.vapIndex);
			}
		}
#endif //TRAINING_WAVE600_Z0

		/*Go over BA reports assigned to the current sequencer report*/
		/*increment fifo entry must be after break the loop, otherwize FW will miss report*/
		TxSequencer_incrementFifoEntryPtr();

		/*Decrement one element from sequencer fifo*/
		TxSequencer_DecFifoNumEntriesCount(1);
	}while (numberOfEntriesRead < linkAdaptationLocalParam.numberOfElementInTxSequencerFifo);
	
	/*Sequencer fifo process has ended, unmask IRQ*/
	EventManager_TurnOnEvent(EVENT_ID_SEQUENCER_REPORTS_FIFO_NOT_EMPTY);
}



/**********************************************************************************
linkAdaptationResetStaDb




Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
void linkAdaptationResetStaDb(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter)
{
	SlowProbingTasks_e slowProbingTasks;

	rateAdaptationResetDb(laDbDistributionParameter->stationOrGroupIndex,INVALID_MU_USP_INDEX, FALSE);
	rateAdaptationResetCountersAndThresholds(laDbDistributionParameter);
	estimatorsResetDb(laDbDistributionParameter);
	BeamformingResetDb(laDbDistributionParameter->stationOrGroupIndex);
	
	/*Enable all slow probing loops for specific station*/
	for (slowProbingTasks = (SlowProbingTasks_e)0; slowProbingTasks < SLOW_PROBING_TASKS_NUM; slowProbingTasks++)
	{
		rateAdaptationEnableDisableStaSlowLoop(laDbDistributionParameter->stationOrGroupIndex,slowProbingTasks,ENABLE_LOOP);
	}

	Utils_ZeroBitInBitmap((uint32 *)(muCandidateStaBitmap), laDbDistributionParameter->stationOrGroupIndex);		
	AlphaFilter_Init(&(laDbDistributionParameter->laStationUnique->lowFrameRateCounter),&(laDbDistributionParameter->laStationUnique->lowFrameRateAverageDtFilterResult));
	AlphaFilter_Init(&(laDbDistributionParameter->laStaGroupCommon->wpAverageGoodPut),&(laDbDistributionParameter->laStaGroupCommon->averageGoodPutDtFilterResult));
	resetSlowProbingPriorityBitmaps(laDbDistributionParameter);
	resetSlowProbingHandlerCounters(laDbDistributionParameter);
}

/**********************************************************************************
linkAdaptationResetGroupDb





Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
void linkAdaptationResetGroupDb(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter)
{
	SlowProbingTasks_e slowProbingTasks;
	bool isHeGroup = (laDbDistributionParameter->laHeGroupUnique != NULL);
	uint8 uspIndex = laDbDistributionParameter->uspIndex;
	
	rateAdaptationResetDb(laDbDistributionParameter->stationOrGroupIndex,uspIndex, isHeGroup);
	rateAdaptationResetCountersAndThresholds(laDbDistributionParameter);
	estimatorsResetDb(laDbDistributionParameter); 
	AlphaFilter_Init(&(laDbDistributionParameter->laStaGroupCommon->wpAverageGoodPut),&(laDbDistributionParameter->laStaGroupCommon->averageGoodPutDtFilterResult));
#ifdef ENET_INC_ARCH_WAVE600
	if (isHeGroup)
	{
		AlphaFilter_Init(&(laDbDistributionParameter->laHeGroupUnique->wpAverageGoodPutPerUsp[uspIndex]),&(laDbDistributionParameter->laStaGroupCommon->averageGoodPutDtFilterResult));
	}
	else
#endif
	{		
		AlphaFilter_Init(&(laDbDistributionParameter->laVhtGroupUnique->wpAverageGoodPutPerUsp[uspIndex]),&(laDbDistributionParameter->laStaGroupCommon->averageGoodPutDtFilterResult));
	}

	/*Disable all slow probing loops for MU Group*/
   for (slowProbingTasks = (SlowProbingTasks_e)0; slowProbingTasks < SLOW_PROBING_TASKS_NUM; slowProbingTasks++)
   {
   		rateAdaptationEnableDisableGroupSlowLoop(laDbDistributionParameter, slowProbingTasks, DISABLE_LOOP);
   }
   
   resetSlowProbingPriorityBitmaps(laDbDistributionParameter);
   resetSlowProbingHandlerCounters(laDbDistributionParameter);
}


/**********************************************************************************

isr_LinkAdaptation_ProbingTimerEvent 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void  isr_LinkAdaptation_ProbingTimerEvent(uint32 eventParam)
{
	K_MSG* pProbingtimerEventMsg = NULL;
	LaTimerEventsTimerEvent_t*	pTimerExpirationTsf;
	UNUSED_PARAM(eventParam);	
	
	pProbingtimerEventMsg = OSAL_GET_MESSAGE(sizeof(LaTimerEventsTimerEvent_t));	
	pTimerExpirationTsf = (LaTimerEventsTimerEvent_t*)pK_MSG_DATA(pProbingtimerEventMsg);
	pTimerExpirationTsf->timerExpirationTsf = GET_TSF_TIMER_LOW();
	linkAdaptaionActivateTimersIds[LINK_ADAPTATION_PROBING_TIMER] = MAX_UINT16;
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_PROBING_TIMER_EVENT, TASK_LINK_ADAPTATION, pProbingtimerEventMsg, VAP_ID_DO_NOT_CARE);	
}
/**********************************************************************************

isr_LinkAdaptation_InitBfReport 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void  isr_LinkAdaptation_InitBfReport(uint32 param)
{
	K_MSG* pBfTimerExpParamEventMsg = NULL;
	LaTimerEventsTimerEvent_t*	pBfTimerExpParam;
	
	pBfTimerExpParamEventMsg = OSAL_GET_MESSAGE(sizeof(LaTimerEventsTimerEvent_t));
	pBfTimerExpParam = (LaTimerEventsTimerEvent_t*)pK_MSG_DATA(pBfTimerExpParamEventMsg);

	pBfTimerExpParam->timerExpirationTsf = GET_TSF_TIMER_LOW();
	pBfTimerExpParam->staIndex = param;

	OSAL_SEND_MESSAGE(LINK_ADAPTATION_BF_TIMER_EVENT, TASK_LINK_ADAPTATION, pBfTimerExpParamEventMsg, VAP_ID_DO_NOT_CARE);	
}


/**********************************************************************************

LinkAdaptationHandleProbingTimerEvent 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void  linkAdaptationHandleProbingTimerEvent(K_MSG *psMsg)
{
	LaTimerEventsTimerEvent_t*	pTimerExpirationTsf = (LaTimerEventsTimerEvent_t*)pK_MSG_DATA(psMsg);
	uint32	timeToGo = 0;
	StaId	nextSid = LmStaDataBase.headIndexOfStaLinkList;
	uint32	tsfLow = GET_TSF_TIMER_LOW();
	uint8 	groupIndex;
		
//	ILOG0_V("linkAdaptationHandleProbingTimerEvent");
	/*We shouldn't handle timer if no station connect*/
	if(LmStaDataBase.NumOfConnectedSta !=0 )
	{
		timeToGo = calculateTimerExpirationTime(LinkAdaptationCommonConfiguration.fastProbingTimerEventIntervalUsec,tsfLow, pTimerExpirationTsf->timerExpirationTsf );
		/*Periodic timer - set timer after the previous has expired*/
		linkAdaptaionActivateTimersIds[LINK_ADAPTATION_PROBING_TIMER]=TimerUtiltyAddEvent(timeToGo,isr_LinkAdaptation_ProbingTimerEvent, INVALID_STA_INDEX);
		/*If number of connected station != 1 nextSid must be different than DB_ASYNC_SID*/
		DEBUG_ASSERT(nextSid != DB_ASYNC_SID);
		/*Go over all connected stations*/
		while (nextSid != DB_ASYNC_SID)
		{
			DEBUG_ASSERT(nextSid < HW_NUM_OF_STATIONS);
			rateAdaptationProbingTimerEvent(nextSid,INVALID_MU_USP_INDEX, FALSE);
			nextSid = StaDbSwEntries[nextSid].nextSid;
		}
		for(groupIndex = 0; groupIndex < TX_MU_GROUPS; groupIndex++)
		{
			// VHT MU
			if(linkAdaptationIsGroupActive(groupIndex, FALSE))
			{
				rateAdaptationProbingTimerEvent(groupIndex,0x0, FALSE);
			}
		}
#ifdef ENET_INC_ARCH_WAVE600
		for(groupIndex = 0; groupIndex < NUM_OF_LA_HE_MU_DB_ENTRIES; groupIndex++)
		{
			// HE MU
			if(linkAdaptationIsGroupActive(groupIndex, TRUE))
			{
				rateAdaptationProbingTimerEvent(groupIndex,0x0, TRUE);
			}
		}
#endif
	}
}

/**********************************************************************************

calculateTimerExpirationTime 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

uint32 calculateTimerExpirationTime(uint32 timeToGo, uint32 currentTsf, uint32 timerExpirationTsf)
{
	if ((int32)(timeToGo - (currentTsf - timerExpirationTsf))<0)
	{
		return LA_MIN_TIMER_VAL_USEC;
	}
	else
	{
		return timeToGo - (currentTsf - timerExpirationTsf);
	}
}

/**********************************************************************************
linkAdaptationStaSendConfirm




Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationStaSendConfirm(StaId stationIndex)
{
	K_MSG *pMsg;
	BssManagerStaManagerCfm_t *confirmMessage;

	/*Allocate message*/
	pMsg = OSAL_GET_MESSAGE(sizeof(BssManagerStaManagerCfm_t));
	confirmMessage = (BssManagerStaManagerCfm_t*) pK_MSG_DATA(pMsg);
	/*Set Client ID to the registered ID*/
	confirmMessage->clientId = BSS_MANAGER_STA_MANAGER_LA_CLIENT;
	/*Set STA ID*/
	confirmMessage->sid = stationIndex;
	/*Send confirmation message*/
	OSAL_SEND_MESSAGE(BSS_MANAGER_STA_MANAGER_REG_CFM, TASK_BSS_MANAGER, pMsg, VAP_ID_DO_NOT_CARE);
}

/**********************************************************************************

linkAdaptationSetFixedRate 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationSetFixedRate(K_MSG *psMsg)
{
	LaFixedRateParams_t *laFixedRateParams_p = (LaFixedRateParams_t*)pK_MSG_DATA(psMsg);
	StaId staIdIterator = LmStaDataBase.headIndexOfStaLinkList;
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 
	LaFixedRateStationParams_t *laFixedRateStationParams_p;
	StaId firstSidInBand = ConfigurationManager_GetFirstSidInMyBand();
	uint16 numOfSidsInBand = ConfigurationManager_GetNumOfSupportedStationsInMyBand();


	MEMCPY(&FixedRateParameters, laFixedRateParams_p, sizeof(LaFixedRateParams_t));
	
	FixedRateParameters.bandwidth = MIN(FixedRateParameters.bandwidth, LinkAdaptationCommonConfiguration.wlanBandwidthMax);

	//SLOG0(0, 0, LaFixedRateParams_t, &FixedRateParameters);
	
	if (FixedRateParameters.fixedRateType == FIXED_RATE_FOR_STATION)
	{
		if (FixedRateParameters.backToAutoRate == FALSE)
		{
			/* Fixed rate */
			if (FixedRateParameters.stationIndex != INVALID_STA_INDEX)
			{		
				/* For a specific station */
				ASSERT(FixedRateParameters.stationIndex < HW_NUM_OF_STATIONS); //KW_FIX_FW_G
				laFixedRateStationParams_p = &LinkAdaptationStaDatabase[FixedRateParameters.stationIndex].laStationUnique.fixedRateStationParams;
				laFixedRateStationParams_p->FixedRateRequested = TRUE;
				laFixedRateStationParams_p->bandwidth = FixedRateParameters.bandwidth;
				laFixedRateStationParams_p->rate = FixedRateParameters.rate;
				laFixedRateStationParams_p->cpMode = FixedRateParameters.cpMode;
				laFixedRateStationParams_p->phyMode = FixedRateParameters.phyMode;
				laFixedRateStationParams_p->changeType = FixedRateParameters.changeType;
#ifdef ENET_INC_ARCH_WAVE600D2
				laFixedRateStationParams_p->heExtRuSizeMng = FixedRateParameters.heExtRuSizeMng;
				laFixedRateStationParams_p->heExtRuSizeData = FixedRateParameters.heExtRuSizeData;
#endif //ENET_INC_ARCH_WAVE600D2				
#ifdef ENET_INC_ARCH_WAVE600
				overrideRateForUnsupportedFixedRate(FixedRateParameters.stationIndex);
#ifdef ENET_INC_ARCH_WAVE600D2
				if((EXTRACT_DCM_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate)) || (FixedRateParameters.phyMode == PHY_MODE_11AX_SU_EXT))
				{
					checkHeExtAndDcmWrongFixedRateConfiguration(FixedRateParameters.stationIndex);
				}
#endif //ENET_INC_ARCH_WAVE600D2
#endif //ENET_INC_ARCH_WAVE600				

				updateLaDbDistributionParam(&laDbDistributionParameter, FixedRateParameters.stationIndex, INVALID_MU_USP_INDEX, FALSE);
				rateAdaptationChangeStaToFixedRate(&laDbDistributionParameter);
				QAMplus_SetState(FixedRateParameters.stationIndex, QAM_PLUS_STATE_NOT_ALLOWED);
			}
			else
			{
				for (staIdIterator = firstSidInBand; staIdIterator < (firstSidInBand + numOfSidsInBand); staIdIterator++)
				{
					/* For all stations */
					laFixedRateStationParams_p = &LinkAdaptationStaDatabase[staIdIterator].laStationUnique.fixedRateStationParams;
					laFixedRateStationParams_p->FixedRateRequested = TRUE;
					laFixedRateStationParams_p->bandwidth = FixedRateParameters.bandwidth;
					laFixedRateStationParams_p->rate = FixedRateParameters.rate;
					laFixedRateStationParams_p->cpMode = FixedRateParameters.cpMode;
					laFixedRateStationParams_p->phyMode = FixedRateParameters.phyMode;
					laFixedRateStationParams_p->changeType = FixedRateParameters.changeType;
#ifdef ENET_INC_ARCH_WAVE600D2
					laFixedRateStationParams_p->heExtRuSizeMng = FixedRateParameters.heExtRuSizeMng;
					laFixedRateStationParams_p->heExtRuSizeData = FixedRateParameters.heExtRuSizeData;
#endif //ENET_INC_ARCH_WAVE600D2
#ifdef ENET_INC_ARCH_WAVE600
					overrideRateForUnsupportedFixedRate(staIdIterator);
#ifdef ENET_INC_ARCH_WAVE600D2
					if((EXTRACT_DCM_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate)) || (FixedRateParameters.phyMode == PHY_MODE_11AX_SU_EXT))
					{
						checkHeExtAndDcmWrongFixedRateConfiguration(staIdIterator);
					}
#endif //ENET_INC_ARCH_WAVE600D2
#endif //ENET_INC_ARCH_WAVE600
					updateLaDbDistributionParam(&laDbDistributionParameter, staIdIterator, INVALID_MU_USP_INDEX, FALSE);
					rateAdaptationChangeStaToFixedRate(&laDbDistributionParameter);
					QAMplus_SetState(staIdIterator, QAM_PLUS_STATE_NOT_ALLOWED);
				}
			}	
		}
		else
		{
			/* Auto rate */
			if (FixedRateParameters.stationIndex != INVALID_STA_INDEX)
			{
				rateAdaptationChangeToAutoRate(FixedRateParameters.stationIndex);
			}
			else
			{
				for (staIdIterator = firstSidInBand; staIdIterator < (firstSidInBand + numOfSidsInBand); staIdIterator++)
				{
					rateAdaptationChangeToAutoRate(staIdIterator);
				}
			}
		}
		if (FixedRateParameters.disableTimers == TRUE)
		{
			/*Disable timer3 interrupt*/
			MT_enableDisableGpTimerIrq(MT_TIMER_3, 0);
		}
		
	}
	else if (FixedRateParameters.fixedRateType == FIXED_RATE_FOR_VAP)
	{
	
		if (FixedRateParameters.backToAutoRate == FALSE)
		{
			if (FixedRateParameters.vapId != INVALID_VAP)
			{
				setVapFixedRatesInHwDb();
			}
		}
		else
		{
			fillVapHwDb(FixedRateParameters.vapId,FIXED_MCS_VAP_MANAGEMENT_IS_NOT_VALID);
			resetSequenceNumderInVapHwDb (FixedRateParameters.vapId);
		}
	}

#ifdef LINK_ADAPTATION_LOGS
		//("Set fixed rate, sid = %d, rate = %X, phyMode = %d, bandwidth = %d, backToAutoRate = %d, disbaleTimers = %d",
//			FixedRateParameters.stationIndex, FixedRateParameters.rate, FixedRateParameters.phyMode, FixedRateParameters.bandwidth, 
//			FixedRateParameters.backToAutoRate, FixedRateParameters.disableTimers);
#endif
	/*Send confirmation*/
	OSAL_SEND_NO_DATA_MESSAGE(laFixedRateParams_p->retMsg, laFixedRateParams_p->retTask, FixedRateParameters.vapId);

}

/**********************************************************************************

linkAdaptationSetMuGroupFixedRate 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationSetMuGroupFixedRate(K_MSG *psMsg)
{
	LaGroupFixedRateParams_t*	laMuGroupFixedRateParams_p = (LaGroupFixedRateParams_t*)pK_MSG_DATA(psMsg);
#ifdef ENET_INC_ARCH_WAVE600	
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 
	uint8 groupIndex;
	uint8 uspIndex = DONT_CARE_MU_USP_INDEX;
	LinkAdaptationState_e newState = LA_WAIT_FOR_NEXT_PROBE_CYCLE;
#endif

	MuGroupFixedRateRequested = laMuGroupFixedRateParams_p->fixedRateGroupsFlag; 


#ifdef ENET_INC_ARCH_WAVE600
	if (MuGroupFixedRateRequested == TRUE)
	{
		newState = LA_STA_NOT_CONNECT_RA_BYPASS;
	}

	/* HE MU */	
	for(groupIndex = 0; groupIndex < NUM_OF_LA_HE_MU_DB_ENTRIES; groupIndex++)
	{
		updateLaDbDistributionParam(&laDbDistributionParameter, groupIndex, uspIndex, TRUE);
		laStateMachineChangeState(&laDbDistributionParameter, newState) ;
	}
#endif
	
//	ILOG0_D("MU-Group Fixed rate state, changed to == %d",MuGroupFixedRateRequested);
}

/**********************************************************************************

linkAdaptationSetFixedPower 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationSetFixedPower(K_MSG *psMsg)
{
	LaFixedPowerParams_t *laFixedPowerParams = (LaFixedPowerParams_t*)pK_MSG_DATA(psMsg);
	StaId nextSid = LmStaDataBase.headIndexOfStaLinkList;
	MEMCPY(&FixedPowerParameters, laFixedPowerParams, sizeof(LaFixedPowerParams_t));
	
	while (nextSid != DB_ASYNC_SID)
	{
		DEBUG_ASSERT(nextSid < HW_NUM_OF_STATIONS);
		
		if (FixedPowerParameters.changeType != LA_PACKET_TYPE_NONE)
		{
			if(FixedPowerParameters.changeType != LA_PACKET_TYPE_MU_DATA)
			{
				setFixedPowerInStaTcr(nextSid);
			}
			rateAdaptationEnableDisableStaSlowLoop(nextSid, SLOW_PROBING_POWER, DISABLE_LOOP);
		}
		else
		{
			rateAdaptationEnableDisableStaSlowLoop(nextSid, SLOW_PROBING_POWER, ENABLE_LOOP);
		}
		nextSid = StaDbSwEntries[nextSid].nextSid;
	}
	if (FixedPowerParameters.changeType == LA_PACKET_TYPE_MU_DATA)
	{
		linkAdaptation_SetMuFixedPower(FixedPowerParameters.powerVal);
	}

	if (laFixedPowerParams->vapId != INVALID_VAP)
	{
		SetVapFixedPower(laFixedPowerParams->vapId, FixedPowerParameters.powerVal, laFixedPowerParams->changeType);
//		ILOG0_D("linkAdaptationSetFixedPower FixedPowerParameters.powerVal : %d",FixedPowerParameters.powerVal);
	}
	
	/*Send confirmation*/
	OSAL_SEND_NO_DATA_MESSAGE(laFixedPowerParams->retMsg, laFixedPowerParams->retTask, laFixedPowerParams->vapId);
}

/**********************************************************************************

linkAdaptationSetFixedPowerAtAddSta


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationSetFixedPowerAtAddSta(StaId sid)
{				
	if(FixedPowerParameters.changeType != LA_PACKET_TYPE_MU_DATA)
	{
	    setFixedPowerInStaTcr(sid);
	}
    else
	{
		linkAdaptation_SetMuFixedPower(FixedPowerParameters.powerVal);
	}	
    rateAdaptationEnableDisableStaSlowLoop(sid, SLOW_PROBING_POWER, DISABLE_LOOP);
}

/**********************************************************************************

linkAdaptationSetFixedPower 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationSetFixedScp(K_MSG *psMsg)
{
	LaFixedScpParams_t *laFixedScpParams = (LaFixedScpParams_t*)pK_MSG_DATA(psMsg);
	StaId nextSid = LmStaDataBase.headIndexOfStaLinkList;
	K_MSG* psNewMsg = laFixedScpParams->psMsg;
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 

	if(laFixedScpParams->getSetOperation == API_GET_OPERATION)
	{
		UMI_FIXED_LTF_AND_GI_REQ_t *confirmMsg = (UMI_FIXED_LTF_AND_GI_REQ_t *)pK_MSG_DATA(psNewMsg);
		confirmMsg->isAuto = (uint8)fixedCpParams.isAuto;
		confirmMsg->ltfAndGi = (uint8)fixedCpParams.cpMode;
	}
	else //SET
	{
		MEMCPY(&fixedCpParams, laFixedScpParams, sizeof(LaFixedScpParams_t));

		if (laFixedScpParams->stationId != INVALID_STA_INDEX)
		{
			// Disable loop
			rateAdaptationEnableDisableStaSlowLoop(laFixedScpParams->stationId, SLOW_PROBING_CP, DISABLE_LOOP);
			CyclicPrefixSetFixedVal(laFixedScpParams->stationId, laFixedScpParams->cpMode);
		}
		else
		{
			while (nextSid != DB_ASYNC_SID)
			{
				DEBUG_ASSERT(nextSid < HW_NUM_OF_STATIONS);
				if (laFixedScpParams->isAuto == 1)
				{
					updateLaDbDistributionParam(&laDbDistributionParameter,nextSid,INVALID_MU_USP_INDEX, FALSE);
					cyclicPrefixResetLoop(&laDbDistributionParameter, FALSE);
				}
				else
				{

					rateAdaptationEnableDisableStaSlowLoop(nextSid, SLOW_PROBING_CP, DISABLE_LOOP);
					CyclicPrefixSetFixedVal(nextSid, laFixedScpParams->cpMode);
				}			
				nextSid = StaDbSwEntries[nextSid].nextSid;
			}
		}
	}
	
	/* Send message to UM */
	if(psNewMsg != NULL) //Protect in case we reach here from UmDbgCliReq
	{
		OSAL_SEND_MESSAGE(UMI_MC_MAN_LTF_AND_GI_CONFIG_CFM, TASK_UM_IF_TASK, psNewMsg, psNewMsg->header.vapId);
	}
}

#ifndef ENET_INC_ARCH_WAVE600
static void linkAdaptationSetFixedCDD(K_MSG *psMsg)
{
	LaFixedCddParams_t *laFixedCddParams = (LaFixedCddParams_t*)pK_MSG_DATA(psMsg);

	if (laFixedCddParams->stationId != INVALID_STA_INDEX)
	{
		// Disable loop
		rateAdaptationEnableDisableStaSlowLoop(laFixedCddParams->stationId, SLOW_PROBING_CDD, DISABLE_LOOP);
		// Set fixed value
		CddsetFixedValuesInStaTcr(laFixedCddParams->stationId, laFixedCddParams->cddVal);
	}

}
#endif

/**********************************************************************************

linkAdaptationSetBss 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationSetBss(K_MSG *psMsg )
{
	K_MSG *pVapMsg = (K_MSG *) (*((uint32 *)pK_MSG_DATA(psMsg)));
	UMI_SET_BSS* pVapSetBss = (UMI_SET_BSS*) pK_MSG_DATA(pVapMsg);
	uint8 vapIndex = pVapSetBss->vapId;
#ifdef ENET_INC_ARCH_WAVE600
	PreAgg11BPreambleMode_e preAgg11BPreambleMode = PRE_AGGREGATOR_11B_PREAMBLE_MODE_LONG;
#else
	AggrBuilder11BPreambleMode_e aggrBuilder11BPreambleMode = AGGR_BUILDER_11B_PREAMBLE_MODE_LONG;
#endif //ENET_INC_ARCH_WAVE600
	K_MSG* psNewMsg;  
	BSS_MANAGER_CONFIRM_EVENT* confirmEvent; 	

	if (pVapSetBss->useShortPreamble == TRUE)
	{
#ifdef ENET_INC_ARCH_WAVE600
	preAgg11BPreambleMode = PRE_AGGREGATOR_11B_PREAMBLE_MODE_SHORT;
#else
	aggrBuilder11BPreambleMode = AGGR_BUILDER_11B_PREAMBLE_MODE_SHORT;
#endif //ENET_INC_ARCH_WAVE600
	}
		
	if(LmVapDataBase[vapIndex].vapState == LM_VAP_STATE_FREE)
	{
		/*Set supported rates and basic rates in Lm vap database */
		LmVapDB_AddVap(pVapSetBss);
		ProtectionAdaptation_AddVap(vapIndex);
		/*Fill vap HW database*/
		fillVapHwDb(vapIndex, pVapSetBss->fixedMcsVapManagement);
		resetSequenceNumderInVapHwDb(vapIndex);

		/* Set antenna connected bitmask in Vap Hw Db*/
		AntennaSelectionSetChannel();
		/*Set protection mode*/
		ProtectionAdaptation_VapSetBss(pVapSetBss);		
	}
	else
	{
		fillVapHwDb(vapIndex, pVapSetBss->fixedMcsVapManagement);
		/*If set BSS received after VAP is conneted, configure only protection*/
		ProtectionAdaptation_VapSetBss(pVapSetBss);
	}
#ifdef ENET_INC_ARCH_WAVE600

	if (LmStaDataBase.NumOfConnectedSta == 0)
	{
		/* Add BSS color to PHY's table */
		/* changing BSS color requires sending a color switch announcement to all stas */
		PhyDrv_SetBssColor(vapIndex, pVapSetBss->u8HE_Bss_Color);
		//Store the last bss color
		linkAdaptaionBssColor = pVapSetBss->u8HE_Bss_Color;
	}
	else if (linkAdaptaionBssColor != pVapSetBss->u8HE_Bss_Color)
	{
		FATAL("We got new bss color while we have connected stations")
	}
#endif

	/*If 11B station connected to VAP, VAP will transmit always in long preamble otherwise transmit in short preamble
	The configuration is done by the aggregation builder.
	Set aggregation builder/pre agg to transmit 11B short / long preamble according to UMI_SET_BSS-> useShortPreamble parameter */
#ifdef ENET_INC_ARCH_WAVE600
	PreAggregator_Set11bPreambleMode(pVapSetBss->vapId,preAgg11BPreambleMode);
#else
	AggregationBuilder_Set11bPreambleMode(pVapSetBss->vapId,aggrBuilder11BPreambleMode);
#endif //ENET_INC_ARCH_WAVE600

	/* Send message to BSS manager - confirm on Add vap event  */
	psNewMsg = OSAL_GET_MESSAGE(sizeof(BSS_MANAGER_CONFIRM_EVENT));
	confirmEvent = ((BSS_MANAGER_CONFIRM_EVENT *)psNewMsg->abData);
	confirmEvent->vapId = vapIndex;
	confirmEvent->eventIndex = VAP_MANAGER_SET_BSS;
	confirmEvent->clientId = BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT; 
    OSAL_SEND_MESSAGE(BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM, TASK_BSS_MANAGER, psNewMsg, vapIndex);   
}
/**********************************************************************************

linkAdaptationRemoveVap 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void  linkAdaptationRemoveVap(K_MSG *psMsg )
{
	K_MSG *pVapMsg = (K_MSG *) (*((uint32 *)pK_MSG_DATA(psMsg)));
	UMI_REMOVE_VAP* pRemoveVap = (UMI_REMOVE_VAP*) pK_MSG_DATA(pVapMsg);
	uint8 vapId =  pRemoveVap->vapId;
	LmVapDbSwInfo_t* pLmVapDbSwinfo = &LmVapDataBase[vapId];
	K_MSG* psNewMsg;  
	BSS_MANAGER_CONFIRM_EVENT* confirmEvent; 		

	if (pLmVapDbSwinfo->vapState != LM_VAP_STATE_FREE)
	{
		/*Set supported rates and basic rates in Lm vap database */
		LmVapDB_RemoveVap(pRemoveVap);
		
		ProtectionAdaptation_RemoveVap(pRemoveVap->vapId);
#ifdef ENET_INC_ARCH_WAVE600	
		/* Remove BSS color from PHY's table */
		PhyDrv_SetBssColor(vapId, 0);
#endif
	}

	/* Send message to BSS manager - confirm on Remove vap event  */
	psNewMsg = OSAL_GET_MESSAGE(sizeof(BSS_MANAGER_CONFIRM_EVENT));
	confirmEvent = ((BSS_MANAGER_CONFIRM_EVENT *)psNewMsg->abData);
	confirmEvent->vapId = vapId;
	confirmEvent->eventIndex = VAP_MANAGER_REMOVE_VAP; 
	confirmEvent->clientId = BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT; 
    OSAL_SEND_MESSAGE(BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM, TASK_BSS_MANAGER, psNewMsg, vapId); 
}

/**********************************************************************************

linkAdaptationSetChannelReq 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void  linkAdaptationSetChannelReq(K_MSG *psMsg )
{
	LA_SET_CHANNEL_DATA_t* laSetChannelMsg = (LA_SET_CHANNEL_DATA_t*)pK_MSG_DATA(psMsg);
	StaId nextSid = LmStaDataBase.headIndexOfStaLinkList;
	uint8 staLowestBwRate;
	uint8 staWpRateLastMaxBw;
	StaId stationId = 0;
	StaId firstSidInBand = ConfigurationManager_GetFirstSidInMyBand();
	uint16 numOfSidsInBand = ConfigurationManager_GetNumOfSupportedStationsInMyBand();
	Bandwidth_e lastMaxBandwidth = LinkAdaptationCommonConfiguration.wlanBandwidthMax;
	Bandwidth_e maxBW = (Bandwidth_e)laSetChannelMsg->wlanBandwidthMax;
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 
	uint8 maxNumberOfRates;
	UNUSED_PARAM(maxNumberOfRates);

	ILOG0_D("[WD] linkAdaptationSetChannelReq lastMaxBandwidth = %d", lastMaxBandwidth);
	SLOG0(0, 0, LA_SET_CHANNEL_DATA_t, laSetChannelMsg);

#if defined(ENET_INC_ARCH_WAVE600)
	HW_SEMAPHORE_LOCK(HW_SEMAPHORE_AOCS_INFO);
	memset(&DynamicBwStatistics, 0, sizeof(DynamicBwStatistics_t));
	HW_SEMAPHORE_FREE(HW_SEMAPHORE_AOCS_INFO);
#else
	HW_SEMAPHORE_LOCK(HW_SEMAPHORE_2_18_AOCS_INFO);
	memset(&DynamicBwStatistics, 0, sizeof(DynamicBwStatistics_t));
	HW_SEMAPHORE_FREE(HW_SEMAPHORE_2_18_AOCS_INFO);
#endif

	/* Set channel's BW might be higher\lower than the fixed rate BW - limit it */
	if ((FixedRateParameters.fixedRateType != FIXED_RATE_INVALID) && (FixedRateParameters.backToAutoRate == FALSE))
	{
		/* Fixed rate is ON */

		/* Update Fixed Rate BW */
		FixedRateParameters.bandwidth = MIN(FixedRateParameters.bandwidth , maxBW);

		/* Limit the BW */
		maxBW = FixedRateParameters.bandwidth;
		
		/* Update all stations */
		for (stationId = firstSidInBand; stationId < (firstSidInBand + numOfSidsInBand); stationId++)
		{
			LinkAdaptationStaDatabase[stationId].laStationUnique.fixedRateStationParams.bandwidth = maxBW;		
		}		
	}


	/*Set wlan maximum BW*/
	LinkAdaptationCommonConfiguration.wlanBandwidthMax = (Bandwidth_e)laSetChannelMsg->wlanBandwidthMax;
	LinkAdaptationCommonConfiguration.band = laSetChannelMsg->band;
	/*Update Bw limit and rates for all connected stations*/
	while (nextSid != DB_ASYNC_SID)
	{
		/* New channel: reset the total TX time stats */
		LinkAdaptationStatistics.totalTxTime[nextSid] = 0;
	
		updateLaDbDistributionParam(&laDbDistributionParameter,nextSid,INVALID_MU_USP_INDEX, FALSE);
		maxNumberOfRates = getMaxNumOfRatesInTable(laDbDistributionParameter.laStaUspCommon);
		/*If new Max BW is higher than the last BW, we should update link adaptation database with the rates for new BW*/
		if (LinkAdaptationCommonConfiguration.wlanBandwidthMax > lastMaxBandwidth)
		{
			/*Take last max WP rate in order to change set rate for the new BW */
			staWpRateLastMaxBw = GetStaWpRateIndexFromHwTcr(nextSid,lastMaxBandwidth);
			DEBUG_ASSERT(staWpRateLastMaxBw < maxNumberOfRates);
			if ((FixedRateParameters.fixedRateType == FIXED_RATE_INVALID) || (FixedRateParameters.backToAutoRate == TRUE))
			{/* Fixed rate is OFF */
				laStateMachineChangeState(&laDbDistributionParameter,LA_WAIT_FOR_NEXT_PROBE_CYCLE) ;
			}
			/*Set initial rate for all BWs after update LinkAdaptationCommonConfiguration.wlanBandwidthMax*/
			rateAdaptationChangeWorkingPoint(&laDbDistributionParameter, staWpRateLastMaxBw, staWpRateLastMaxBw);
		}
		
		/*Take working point rate index according to the lowest BW (because if we are in non HT mode the relevant BW will be 20)*/
		staLowestBwRate = GetStaWpRateIndexFromHwTcr(nextSid,BANDWIDTH_TWENTY);
		DEBUG_ASSERT(staLowestBwRate < maxNumberOfRates);
		/*Set new BW limit*/
		initStaBwLimit(nextSid,staLowestBwRate, OMN_BW_INVALID, maxBW);

		nextSid = StaDbSwEntries[nextSid].nextSid;
	}

	/*Call power adaptation for set tables*/
	SetPowerDataFromTpc(laSetChannelMsg);

	//when carrier frequency is 2.4GHz call QAMplus
	if (laSetChannelMsg->band == BAND_2_4_GHZ)
	{
		LinkAdaptation_QAMplusInit(TRUE);
	}
	
	/*Update AntennaConnected var and set antenna connected bitmask*/
	AntennaSelectionSetAntennaConnected(laSetChannelMsg->antennaConnectedMask);
	
	AntennaSelectionSetChannel();

	/* The next 2 function must be in this order since CalculateAutoReplyPower is using values that were calculated by CalcDefaultPowerLimits*/
	/*Calculate default limits - not sta depandad*/
	CalcDefaultPowerLimits();
	CalculateAutoReplyPower();
	
	//set minimal time to send CF_END according to BAND
	TxSequencer_SetMinimalTimeToSendCfEnd(laSetChannelMsg->band);

	/*Send confirmation*/
	OSAL_SEND_NO_DATA_MESSAGE(HDK_LA_SET_CHANNEL_DATA_CFM, TASK_HDK, VAP_ID_DO_NOT_CARE);
}

/**********************************************************************************

linkAdaptationSetProtectionThreshReq 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
#ifndef ENET_INC_ARCH_WAVE600
static void  linkAdaptationCddSetPsdDataReq(K_MSG *psMsg )	
{
	
	CddPermutationsDb_t* pCddPsdDb = (CddPermutationsDb_t*)pK_MSG_DATA(psMsg);
	
	CddSetDataFromPsd(pCddPsdDb);
}
#endif
static void  linkAdaptationSetProtectionThreshReq(K_MSG *psMsg )
{
	LaProtectionParams_t* protectionDataMsg = (LaProtectionParams_t*)pK_MSG_DATA(psMsg);

	//("linkAdaptationSetProtectionThreshReq Index : %d, value : %d",protectionDataMsg->configurationIndex,protectionDataMsg->value);
	ProtectionAdaptation_SetConfiguration((ProtectionConfigurationIndex)(protectionDataMsg->configurationIndex), protectionDataMsg->value);

}

#ifdef DEBUG_UM_INTERFACE
/**********************************************************************************

linkAdaptationSetPowerBoost 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void linkAdaptationEnDisSlowProbingLoops(K_MSG *psMsg)
{
	UMI_DisablePowerAdapt_t *pDisablePowerAdapt = (UMI_DisablePowerAdapt_t *)pK_MSG_DATA(psMsg);

    if (pDisablePowerAdapt->getSetOperation == API_SET_OPERATION)
    {
		rateAdaptationEnDisSlowProbingLoops(pDisablePowerAdapt->slowProbingMask);		
    }
	else
	{
		pDisablePowerAdapt->slowProbingMask = rateAdaptationGetSlowProbingEnBitmap();
	}
	
	OSAL_SEND_MESSAGE(UMI_MC_SLOW_PROBING_MASK_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}
#endif

/**********************************************************************************

isr_LinkAdaptation_ProbingTimerEvent 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void  isr_LinkAdaptation_AgingTimer(uint32 eventParam)
{
	
	K_MSG* pAgingtimerEventMsg = NULL;
	LaTimerEventsTimerEvent_t*	pTimerExpirationTsf;
	UNUSED_PARAM(eventParam);	
	
	pAgingtimerEventMsg = OSAL_GET_MESSAGE(sizeof(LaTimerEventsTimerEvent_t));	
	pTimerExpirationTsf = (LaTimerEventsTimerEvent_t*)pK_MSG_DATA(pAgingtimerEventMsg);
	pTimerExpirationTsf->timerExpirationTsf = GET_TSF_TIMER_LOW();
	linkAdaptaionActivateTimersIds[LINK_ADAPTATION_AGING_TIMER] = MAX_UINT16;

	OSAL_SEND_MESSAGE(LINK_ADAPTATION_AGING_TIMER_EVENT, TASK_LINK_ADAPTATION, pAgingtimerEventMsg, VAP_ID_DO_NOT_CARE);	
}
/**********************************************************************************

linkAdaptationAgingTimer 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void  linkAdaptationHandleAgingTimerEvent(K_MSG *psMsg)

{
	LaTimerEventsTimerEvent_t* pTimerExpirationTsf = (LaTimerEventsTimerEvent_t*)pK_MSG_DATA(psMsg);
	StaId nextSid = LmStaDataBase.headIndexOfStaLinkList;
	uint32 timeToGo = 0;
	uint32 tsfLow = GET_TSF_TIMER_LOW();
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 
	uint8	groupIndex;
#ifdef LINK_ADAPTATION_LOGS
	ILOG0_V("linkAdaptationHandleAgingTimerEvent");
#endif
	uint8 uspCount;
/*We shouldn't handle timer if no station connect*/
	if(LmStaDataBase.NumOfConnectedSta !=0 )
	{
		timeToGo = calculateTimerExpirationTime(LinkAdaptationCommonConfiguration.estimatorsAgingTimeUsec,tsfLow, pTimerExpirationTsf->timerExpirationTsf );
		/*Periodic timer - set timer after the previous has expired*/
		linkAdaptaionActivateTimersIds[LINK_ADAPTATION_AGING_TIMER] = TimerUtiltyAddEvent(timeToGo,isr_LinkAdaptation_AgingTimer, INVALID_STA_INDEX);
		/*If number of connected station != 1 nextSid must be differebnt than DB_ASYNC_SID*/
		DEBUG_ASSERT(nextSid != DB_ASYNC_SID);
		/*Go over all connected stations*/
		while (nextSid != DB_ASYNC_SID)
		{
			DEBUG_ASSERT(nextSid < HW_NUM_OF_STATIONS);
			updateLaDbDistributionParam(&laDbDistributionParameter,nextSid,INVALID_MU_USP_INDEX, FALSE);
			laStateMachineEnterEvent(&laDbDistributionParameter, RA_TIMER_AGER_EVENT);
			Beamforming_AgingEvent(nextSid);
			nextSid = StaDbSwEntries[nextSid].nextSid;

		}

		for(groupIndex = 0; groupIndex < TX_MU_GROUPS; groupIndex++)
		{
			if(linkAdaptationIsGroupActive(groupIndex, FALSE))
			{
				for(uspCount = 0; uspCount < MAX_USP_IN_VHT_GROUP; uspCount++)//MU - run over all user positions;
				{
					updateLaDbDistributionParam(&laDbDistributionParameter,groupIndex,uspCount, FALSE);
					laStateMachineEnterEvent(&laDbDistributionParameter, RA_TIMER_AGER_EVENT);
				}
			}
		}
#ifdef ENET_INC_ARCH_WAVE600
		for(groupIndex = 0; groupIndex < NUM_OF_LA_HE_MU_DB_ENTRIES; groupIndex++)
		{
			if(linkAdaptationIsGroupActive(groupIndex, TRUE))
			{
				for(uspCount = 0; uspCount < MAX_USP_IN_HE_GROUP; uspCount++)//MU - run over all user positions;
				{
					updateLaDbDistributionParam(&laDbDistributionParameter,groupIndex,uspCount, TRUE);
					laStateMachineEnterEvent(&laDbDistributionParameter, RA_TIMER_AGER_EVENT);
				}
			}
		}
#endif
		ProtectionAdaptation_AgingEvent();
		BwAdaptation_AgingEvent();
	}
}

/**********************************************************************************

linkAdaptationOpertingModeNotificationSimulateActionFrameBeforeAddSta 


Description:
------------
This function is used for testing Action frame of type Operating Mode Notification:
Simulate the case that a station sent this frame before Driver sent Add STA  
Fill all STAs as we don't know the STA ID before the Association

iwpriv wlan1 sDoSimpleCLI 3 2 0 0

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void linkAdaptationOpertingModeNotificationSimulateActionFrameBeforeAddSta(void)
{
	StaId stationId;
	StaId firstSidInBand = ConfigurationManager_GetFirstSidInMyBand();
	uint16 numOfSidsInBand = ConfigurationManager_GetNumOfSupportedStationsInMyBand();
	
#ifdef LINK_ADAPTATION_LOGS

//	ILOG0_V("[OMN][linkAdaptationOpertingModeNotificationSimulateActionFrameBeforeAddSta] channelWidth = OMN_BW_20_MHZ rxNss = OMN_RX_NSS_1");
#endif
	for (stationId = firstSidInBand; stationId < (firstSidInBand + numOfSidsInBand); stationId++)
	{
		LinkAdaptationStaDatabase[stationId].laStationUnique.operatingModeNotification.channelWidth = OMN_BW_20_MHZ;
		LinkAdaptationStaDatabase[stationId].laStationUnique.operatingModeNotification.rxNss = OMN_RX_NSS_1;
		LinkAdaptationStaDatabase[stationId].laStationUnique.operatingModeNotification.isFrameReceivedBeforeAddSta = TRUE;
	}
}
/**********************************************************************************

linkAdaptationOpertingModeNotificationSimulateActionFrameAfterAddSta 


Description:
------------
This function is used for testing Action frame of type Operating Mode Notification:
Simulate the case that a station sent this frame after Driver sent Add STA  
Fill only connected STAs

iwpriv wlan1 sDoSimpleCLI 3 3 0 0

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void linkAdaptationOpertingModeNotificationSimulateActionFrameAfterAddSta(uint32 channelWidth, uint32 rxNss)
{
	StaId stationId;
	LaOperatingModeNotificationMsg_t laOmnMsg;
	StaId firstSidInBand = ConfigurationManager_GetFirstSidInMyBand();
	uint16 numOfSidsInBand = ConfigurationManager_GetNumOfSupportedStationsInMyBand();
	

	for (stationId = firstSidInBand; stationId < (firstSidInBand + numOfSidsInBand); stationId++)
	{
		if (getStaState(stationId) == STA_STATE_CONNECTED)
		{
			laOmnMsg.channelWidth = channelWidth;
			laOmnMsg.rxNss = rxNss;
			laOmnMsg.stationId = stationId;
			linkAdaptationSetOperatingModeNotificationStaConnected(&laOmnMsg);
		}			
	}
}


/**********************************************************************************
linkAdaptaionOperatingModeNotificationCheckActivation


Description:
------------
This function must be calles before reseting the LA STA DB.
Function checks if Driver sent Add STA with OMN element or if the STA sent OMN action frame before Driver sent Add STA
We support up to 4 Nss so the rxNss is limited to OMN_RX_NSS_4

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/

static bool linkAdaptaionOperatingModeNotificationCheckActivation(LaOperationModeNotificationAddSta_t *laOmnAddSta, UMI_STA_ADD *pAddSta, LinkAdaptationStaDatabase_t *pLinkAdaptationDb)
{	
	bool isAddStaIncludesOmn = MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_OPER_MODE_NOTIF_VALID);
	LaOperationModeNotificationRxNssType_e rxNssType = (LaOperationModeNotificationRxNssType_e) MTLK_BFIELD_GET(pAddSta->u8VHT_OperatingModeNotification, OPER_MODE_RX_NSS_TYPE);
	uint8 channelWidth = MTLK_BFIELD_GET(pAddSta->u8VHT_OperatingModeNotification, OPER_MODE_CHANNEL_WIDTH);
	uint8 rxNss        = MTLK_BFIELD_GET(pAddSta->u8VHT_OperatingModeNotification, OPER_MODE_RX_NSS);
	bool isOmnActive = FALSE;

	laOmnAddSta->omnReceivedBeforeAddSta = pLinkAdaptationDb->laStationUnique.operatingModeNotification.isFrameReceivedBeforeAddSta;
	if (pLinkAdaptationDb->laStationUnique.operatingModeNotification.isFrameReceivedBeforeAddSta == TRUE)
	{
		/* An Action frame of OMN was received prior to the Add STA command (the message was sent to LA since it had the "correct" Rx NSS Type) */
		/* Store Action frame info before STA's memory reset */		
		laOmnAddSta->channelWidth = pLinkAdaptationDb->laStationUnique.operatingModeNotification.channelWidth;
		laOmnAddSta->rxNss = pLinkAdaptationDb->laStationUnique.operatingModeNotification.rxNss;	
		isOmnActive = TRUE;
		//("[OMN][linkAdaptaionOperatingModeNotificationCheckActivation] Action frame received before ADD STA");
	}
	else if ((isAddStaIncludesOmn == TRUE) && (rxNssType == RX_NSS_TYPE_MAX))
	{
		/* Add STA includes the OMN element with RX NSS Type that limits BW & NSS of data TX */
		laOmnAddSta->channelWidth = channelWidth;
		laOmnAddSta->rxNss = MIN(rxNss, OMN_RX_NSS_4); // STA may send RX NSS of value greater than we support (VHT_HE_NUMBER_OF_NSS) 
		isOmnActive = TRUE;
		//("[OMN][linkAdaptaionOperatingModeNotificationCheckActivation] ADD STA has OMN element. channelWidth = %d rxNss = %d", laOmnAddSta->channelWidth, laOmnAddSta->rxNss);
	}

	return isOmnActive;
}

/**********************************************************************************

LinkAdaptationGetMaxNssInMask 


Description: 
------------
			Get max NSS supported according to rateMask given
			

Input: 
-----
			rateMask
			
Returns:
--------
			Max NSS
	
**********************************************************************************/
uint8 LinkAdaptationGetMaxNssInMask(uint32* rateMask, bool isHeSta)
{
	uint8 MaxNss = 0xFF;
	uint8 indexNss = VHT_HE_NUMBER_OF_NSS;
	uint32 localRateMask[2];
	RateMask_t* enableNssMaskArr = enableHtVhtNssRatesInMask;

#ifdef ENET_INC_ARCH_WAVE600
	if (isHeSta == TRUE)
	{
		enableNssMaskArr = enableHeNssRatesInMask;
	}
#endif
	while (indexNss > 0)
	{		
		indexNss--;
		
		andOperator64Bit(rateMask, (uint32*)enableNssMaskArr[indexNss].raIndexMask64bit, (uint32*)localRateMask);

#ifdef QAM_PLUS_DEBUG
		ILOG0_DDDD("[QAMplus_GetMaxNssInMask], MaxNss = %d, indexNss = %d, localRateMask[0] = %d, localRateMask[1] = %d", MaxNss, indexNss, localRateMask[0], localRateMask[1]);
#endif
		if ( (localRateMask[0] != 0) || (localRateMask[1] != 0) )
		{
			MaxNss = indexNss;
			break;
		}
	}

	// Assert if NSS not found
	ASSERT(MaxNss !=  0xFF);

	return(MaxNss);
}



/**********************************************************************************
linkAdaptationAddStationReq



Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationAddStationReq(K_MSG *psMsg)
{
	BssManagerStaManagerReq_t *staManagerReq = (BssManagerStaManagerReq_t *)pK_MSG_DATA(psMsg);
	K_MSG *pMsg = staManagerReq->psMsg;
	UMI_STA_ADD *pAddSta = (UMI_STA_ADD *)pK_MSG_DATA(pMsg);
	StaId stationIndex = pAddSta->u16SID;
	LinkAdaptationStaDatabase_t* pLinkAdaptationDb = &LinkAdaptationStaDatabase[stationIndex];
	uint8 initialRateIndex = 0;
	uint8 maxNumOfAntennas;
	HtCapabilitiesInfo_t 	htCapabilities;
	sVHT_CAPABILITIES_INFO vhtCapabilities;
	HE_MAC_PHY_CAPABILITIES_INFO heMacPhyCapabilities;
	sTransmitBfCapInfo transmitBfCapabilities;
	uint8 smpsRecievedBeforeAddStaFlag = pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.smpsRecievedBeforeAddStaFlag;
	uint8 smpsRecievedBeforeAddStaVal = pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.smpsRecievedBeforeAddStaVal;
	LaOperationModeNotificationAddSta_t laOmnAddSta;
	bool isOmnActive = FALSE;
	LaOperationModeNotificationChannelWidth_e omnChannelWidth;
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 
	int8 rssi;
	PhyMode_e staPHYmode; 
	uint8 maxNss = 0xFF;
	uint8 currentRate = 0;


	LaFixedRateStationParams_t fixedRateStaParams;

	updateLaDbDistributionParam(&laDbDistributionParameter,stationIndex,INVALID_MU_USP_INDEX, FALSE);
	/* Opearating Mode Notification: Store Action frame info before STA's memory reset and get element from ADD STA */
	/* Should be called before reset of STA DB */
	isOmnActive = linkAdaptaionOperatingModeNotificationCheckActivation(&laOmnAddSta, pAddSta, pLinkAdaptationDb);

	/* Store fixed rate sta params, before resetting LinkAdaptationStaDatabase */
	MEMCPY(&fixedRateStaParams, &(pLinkAdaptationDb->laStationUnique.fixedRateStationParams) , sizeof(LaFixedRateStationParams_t));
	
	memset (&LinkAdaptationStaDatabase[stationIndex], 0, sizeof(LinkAdaptationStaDatabase_t));
	
	MEMCPY(&htCapabilities, &(pAddSta->u16HT_Cap_Info) , sizeof(sHT_CAPABILITIES_INFO) );
	MEMCPY(&vhtCapabilities, &(pAddSta->u32VHT_Cap_Info) , sizeof(sVHT_CAPABILITIES_INFO) );
	MEMCPY(&heMacPhyCapabilities, &(pAddSta->u8HE_Mac_Phy_Cap_Info) , sizeof(HE_MAC_PHY_CAPABILITIES_INFO));
	MEMCPY(&transmitBfCapabilities, &(pAddSta->transmitBfCapabilities) , sizeof(sTransmitBfCapInfo) );
#ifdef LINK_ADAPTATION_LOGS
	SLOG0(0, 0, HE_MAC_PHY_CAPABILITIES_INFO, &heMacPhyCapabilities );
#endif //LINK_ADAPTATION_LOGS
	if (isOmnActive == TRUE)
	{
		pLinkAdaptationDb->laStationUnique.operatingModeNotification.channelWidth = laOmnAddSta.channelWidth;
		pLinkAdaptationDb->laStationUnique.operatingModeNotification.rxNss = laOmnAddSta.rxNss;
	}
#ifdef TRAINING_FIRST_PHASE_POOL
	LinkAdaptationStaDatabase[stationIndex].laStationUnique.vapId = pAddSta->u8VapIndex; 
#endif // TRAINING_FIRST_PHASE_POOL	

	/*Set initial BW on 20 Mhz- when BwAdaptationAddSta function will be called it will changed again according to sta capabilties and WP rate*/
	SetStaDataBwLimitInHwDb(stationIndex,BANDWIDTH_TWENTY,TRUE);

	Lm_AddStaToHeadOfList(&LmStaDataBase, stationIndex, pAddSta->u8VapIndex);

	/*Set VAP index in STA DB SW entry*/
	StaDbSwEntries[stationIndex].vapIndex = pAddSta->u8VapIndex;
	
	/*Set supported rates*/
	LM_FillStaCapabilities(pAddSta);

	/*Set configuration params for the station*/
	pLinkAdaptationDb->laStaGroupCommon.pLinkAdaptationConfigurationParams = &LinkAdaptationConfigParamsFastInit;

	//check if STA is WDS WEP 
	setIsWdsWep(pAddSta,pLinkAdaptationDb);
#ifdef ENET_INC_ARCH_WAVE600
	if (MTLK_BFIELD_GET(pAddSta->u8FlagsExt, STA_ADD_FLAGS_EXT_IS_HE) == TRUE)
	{
		/* Set TF padding capabilty (for HE STA) */
		setTfPaddingCapability(pLinkAdaptationDb, heMacPhyCapabilities.heMacCapInfo.HE_MAC_TRIGGER_FRAME_MAC_PADDING_DURATION);
	}
#ifdef ENET_INC_ARCH_WAVE600B
	/* Set OMI supported bit in Selector RAM for HE STA */
	TxSelector_SetOmiSupported(stationIndex, MTLK_BFIELD_GET(pAddSta->u8FlagsExt, STA_ADD_FLAGS_EXT_IS_HE));
#endif
#endif
	/*Set phy mode and rates mask*/
	setLinkAdaptationRatesMask(pAddSta);

	// find highest phy rate supported
	staPHYmode = ExtractHighestPhyModeFromRaMask(pLinkAdaptationDb->laStaUspCommon.raIndexMask, pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.heSta);
//    StaDbSwEntries[stationIndex].highestPhyMode = staPHYmode; // store it  
#ifdef BEEROCK_DEBUG
	ILOG2_D("[linkAdaptationAddStationReq], staPHYmode = %d", staPHYmode);
#endif
	linkAdaptationUpdateProtectionRateOnAddSta(staPHYmode);
    //call QAMplus to indicate add HT station
	QAMplus_AddStationReq(stationIndex, staPHYmode);	

	setLdpcCapability(pAddSta,pLinkAdaptationDb);

	/*Reset station DB*/
	linkAdaptationResetStaDb(&laDbDistributionParameter);
	/*Antenna selection add station*/
	AntennaSelectionAddSta(stationIndex);
	maxNumOfAntennas = AntennaSelectionGetAntennaCount(stationIndex);
	
	/* Limit number of Nss in case STA sent Operating Mode Notification (in Action frame or in ADD STA), making sure we do not surpass the actual number of active antennas*/
	maxNumOfAntennas = (isOmnActive == TRUE)? MIN((CONVERT_MAX_NUM_OF_NSS_TO_MAX_NUM_OF_ANTENNAS(laOmnAddSta.rxNss)), maxNumOfAntennas) : maxNumOfAntennas; // +1: rxNss range is 0-3 and num of antenas range is 1-4
	
	if ((MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_HT) == TRUE) && (htCapabilities.smPowerSave == LA_SM_STATIC_MODE))
	{
		if (((smpsRecievedBeforeAddStaFlag == FALSE) || (smpsRecievedBeforeAddStaVal == TRUE)) && (laOmnAddSta.omnReceivedBeforeAddSta == FALSE))
		{
			/*Sta support only 1 NSS due to smPowerSave staticmode*/
			maxNumOfAntennas = 1;
			pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.staInSmpsStaticMode = TRUE;
			pLinkAdaptationDb->laStationUnique.operatingModeNotification.staInOmn = FALSE;
		}
	}
	else
	{
		if ((smpsRecievedBeforeAddStaFlag == TRUE) && (smpsRecievedBeforeAddStaVal == TRUE))
		{
			/*Sta support only 1 NSS due to smPowerSave staticmode*/
			maxNumOfAntennas = 1;
			pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.staInSmpsStaticMode = TRUE;
			pLinkAdaptationDb->laStationUnique.operatingModeNotification.staInOmn = FALSE;
		}
	}
	setMaskAccordingToMaxNumOfAntennas(&laDbDistributionParameter, maxNumOfAntennas);

	if (staPHYmode >= PHY_MODE_11N)
	{
		LinkAdaptationDatabaseDistributionPack_t *plaDbDistributionParameter = &laDbDistributionParameter;
		/*Function not support 11A/G/B phy mode*/
		maxNss = LinkAdaptationGetMaxNssInMask(&(plaDbDistributionParameter->laStaUspCommon->raIndexMask.raIndexMask64bit[0]),
												plaDbDistributionParameter->laStaUspCommon->staTransmissionParams.heSta);		
	}
	else
	{
		maxNss = 0;
	}

	UpdateStationMaxSupportedNss(stationIndex, (SpatialStreamNum_e)maxNss);

#ifndef ENET_INC_ARCH_WAVE600
	/*CDD add station*/
	CddAddSta(stationIndex);
#endif

#ifdef ENET_INC_ARCH_WAVE600D2
	/* Store HE Extended Range capabilties */
	pLinkAdaptationDb->laStationUnique.heExtSuParams.heExtEnabled = (!pAddSta->heExtSingleUserDisable) && heMacPhyCapabilities.hePhyCapInfo.HE_PHY_HE_ER_SU_PPDU_4X_HE_LTF_0_8_US_GI;
	pLinkAdaptationDb->laStationUnique.heExtSuParams.dcmMaxNss = (DcmNssSupport_e)heMacPhyCapabilities.hePhyCapInfo.HE_PHY_DCM_MAX_NSS_RX;
	pLinkAdaptationDb->laStationUnique.heExtSuParams.dcmMaxBw = (Bandwidth_e)heMacPhyCapabilities.hePhyCapInfo.HE_PHY_DCM_MAX_BW;
	/* Store HE SigB capabilties */
	pLinkAdaptationDb->laStationUnique.heSigBParams.heSigbCompressed = heMacPhyCapabilities.hePhyCapInfo.HE_PHY_RX_FULL_BW_SU_USING_HE_MU_PPDU_WITH_COMPRESSED_SIGB;
	pLinkAdaptationDb->laStationUnique.heSigBParams.heSigb16Symbols  = heMacPhyCapabilities.hePhyCapInfo.HE_PHY_LONGER_THAN_16_HE_SIGB_OFDM_SYMBOLS_SUPPORT;
	StaDbHwEntries[stationIndex].common.supportNonCompressedSigb     = heMacPhyCapabilities.hePhyCapInfo.HE_PHY_RX_FULL_BW_SU_USING_HE_MU_PPDU_WITH_NON_COMPRESSED_SIGB;
#endif //ENET_INC_ARCH_WAVE600D2

	/*Set initial rate according to station supported rates (rates mask)*/
	rssi = MAX((int16)pAddSta->rssi - LA_RSSI_TO_DBM, -128);
	initialRateIndex = GetInitialRateAccordingToRssi(&laDbDistributionParameter, rssi);
#ifdef DYNAMIC_GROUPING_DEBUG
    ILOG0_DD("[linkAdaptationAddStationReq], rssi: %d, initial rate: %d", rssi, initialRateIndex);
#endif
	/*Fill sta data in power adaptation database*/
	PowerAdaptationAddStation(stationIndex);

	/*Fill TCRs except rates and phy mode, bw limit, ref length which will be filled later*/
	fillStaHwDb(pAddSta, initialRateIndex);
	
	ProtectionAdaptation_AddSta(stationIndex);

    linkAdaptationDmrStationEventHandler(laDbDistributionParameter.stationOrGroupIndex,
                                         initialRateIndex,
                                         initialRateIndex,
                                         DMR_ADD_STATION);

	rateAdaptationChangeWorkingPoint(&laDbDistributionParameter, initialRateIndex, initialRateIndex);

	/* Limit channel width in case Action frame or ADD STA provided OMN (Operation Mode Notification)*/
	omnChannelWidth = (isOmnActive == TRUE) ? (LaOperationModeNotificationChannelWidth_e)laOmnAddSta.channelWidth : OMN_BW_INVALID;

	/*BW adaptation add station with OMN limitation*/
	BwAdaptationAddSta(stationIndex,htCapabilities, vhtCapabilities, &heMacPhyCapabilities, omnChannelWidth, initialRateIndex);

	//("[OMN][linkAdaptationAddStationReq] dataBwLimit = %d raIndexMask64bit = %X%X", StaDbHwEntries[stationIndex].dataBwLimit, pLinkAdaptationDb->raIndexMask.raIndexMask64bit[1], pLinkAdaptationDb->raIndexMask.raIndexMask64bit[0]);
	
	/*Fill sta data in cyclic prefix module*/
	CyclicPrefixAddStation(stationIndex, htCapabilities, vhtCapabilities, &heMacPhyCapabilities);

	/*Fill Bf station capabilities*/
	BeamformingAddStation(stationIndex, htCapabilities, vhtCapabilities, &heMacPhyCapabilities, transmitBfCapabilities);

	/*Set default ref len*/
	setRefLenInStaDb(stationIndex, MINIMUM_REF_LEN_VAL, REF_LEN_FAIL_DEFAULT_VAL);

	/*When first station conncects,  set timers*/
	if(LmStaDataBase.NumOfConnectedSta == 1)
	{
		/*Set probing timer*/
		linkAdaptaionActivateTimersIds[LINK_ADAPTATION_PROBING_TIMER] = TimerUtiltyAddEvent(LinkAdaptationCommonConfiguration.fastProbingTimerEventIntervalUsec,isr_LinkAdaptation_ProbingTimerEvent, INVALID_STA_INDEX);
		/*Set aging timer*/
		linkAdaptaionActivateTimersIds[LINK_ADAPTATION_AGING_TIMER] = TimerUtiltyAddEvent(LinkAdaptationCommonConfiguration.estimatorsAgingTimeUsec,isr_LinkAdaptation_AgingTimer, INVALID_STA_INDEX);
	}
	TurboRatesInit(&laDbDistributionParameter);
	if (fixedRateStaParams.FixedRateRequested == FALSE)
	{
		LinkAdaptationState_e state = LA_WAIT_FOR_NEXT_PROBE_CYCLE;
		/*Change Rate adaptation state, if not configured as fixed rate station*/
		if(MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_8021X_FILTER_OPEN) == FALSE)
		{
			state = LA_WAIT_FOR_FILTER_OPEN;
		}
		ILOG0_D("[EAPOL] linkAdaptationAddStationReq state = %d", state);
		laStateMachineChangeState(&laDbDistributionParameter, state);
	}
	else
	{
		/*If configured as FIXED RATE sta, restore fixed rate params back to LinkAdaptationStaDatabase and change state*/
		if ((FixedRateParameters.stationIndex == INVALID_STA_INDEX) || (FixedRateParameters.stationIndex == stationIndex))
		{
			/*Use from the global FixedRateParameters structure as the params per STA might have been clipped previously*/
			pLinkAdaptationDb->laStationUnique.fixedRateStationParams.FixedRateRequested = TRUE;
			pLinkAdaptationDb->laStationUnique.fixedRateStationParams.rate = FixedRateParameters.rate;
			pLinkAdaptationDb->laStationUnique.fixedRateStationParams.phyMode = FixedRateParameters.phyMode;
			pLinkAdaptationDb->laStationUnique.fixedRateStationParams.bandwidth = FixedRateParameters.bandwidth;
			pLinkAdaptationDb->laStationUnique.fixedRateStationParams.cpMode = FixedRateParameters.cpMode;
			pLinkAdaptationDb->laStationUnique.fixedRateStationParams.changeType = FixedRateParameters.changeType;
		}
		else
		{
			/*if not, take the per sta fixed rate params*/
			MEMCPY(&(pLinkAdaptationDb->laStationUnique.fixedRateStationParams), &fixedRateStaParams, sizeof(LaFixedRateStationParams_t));
		}
		
#ifdef ENET_INC_ARCH_WAVE600
		overrideRateForUnsupportedFixedRate(stationIndex);
#endif
		laStateMachineChangeState(&laDbDistributionParameter,LA_SET_FIXED_RATE);
	}
    
    /* If configured fixed power, set fixed power */
    if (FixedPowerParameters.changeType != LA_PACKET_TYPE_NONE)
    {
        linkAdaptationSetFixedPowerAtAddSta(stationIndex);
    }
    
	/* Set TxOP mode */
	DynamicTxop_AddStation(stationIndex);
	
	/* Set Fixed CP mode */	
	if (fixedCpParams.isAuto == 0)
	{
		rateAdaptationEnableDisableStaSlowLoop(stationIndex, SLOW_PROBING_CP, DISABLE_LOOP);
		CyclicPrefixSetFixedVal(stationIndex, fixedCpParams.cpMode);
	}
	/*Send confirmation to BSS*/
	linkAdaptationStaSendConfirm(stationIndex);

#ifdef QAM_PLUS_DEBUG
	SLOG0(0, 0, RateMask_t, &LinkAdaptationStaDatabase[stationIndex].laStaUspCommon.raIndexMask);
#endif

	/* If the filter is closed EAPOL exchang shall take place. Use management rate for EAPOLs */
	if(MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_8021X_FILTER_OPEN) == FALSE)
	{
		/* Save current data rate. It will be used once the Driver sends the Open Filter message */
		LinkAdaptationStaDatabase[stationIndex].laStationUnique.initialRateIndex = initialRateIndex;

		/* Add management rate to the mask */
		currentRate = AddManagementRateToMask(stationIndex, pLinkAdaptationDb, &laDbDistributionParameter);

		/* Store the rate so that it can be removed when exiting WAIT_FOR_FILTER_OPEN via fixed rate state */
		LinkAdaptationStaDatabase[stationIndex].laStationUnique.snifferEapolWaRate = currentRate;


		/* Call change working point */
		rateAdaptationChangeWorkingPoint(&laDbDistributionParameter, currentRate, initialRateIndex);

		ILOG0_D("[EAPOL] linkAdaptationAddStationReq currentRate = %d", currentRate);
	}
	MetricsCalculator_ResetStaData(stationIndex);		
}	 

/**********************************************************************************
linkAdaptationAddGroupReq


Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationAddVhtGroup(K_MSG *psMsg)
{
	uint8	groupId;
	StaId	uspStaId;
	LaAddGroupParams_t *addGroupParameters = NULL;
	K_MSG*	groupManagerAddGroupConfirmationMessage	= NULL;
	GroupManagerAddGroupConfirmationMessage_t *addGroupConfirmationParameters = NULL;
	uint8	uspIndex = 0;
	LinkAdaptationDatabaseDistributionPack_t	laDbDistributionParameter; 
	LinkAdaptationVhtGroupDatabase_t*	pLinkAdaptationDb;
	uint32*	groupDbInitialRatePtr = NULL;
	uint8	initialTcrRate;
	uint8	initialRateIndex; 
	uint8 maxNssPerUsp; /*Should be a parameter from GM*/
	Bandwidth_e bw;

	addGroupParameters = (LaAddGroupParams_t *)pK_MSG_DATA(psMsg);
	groupId = addGroupParameters->groupIndex;
	pLinkAdaptationDb = &LinkAdaptationVhtGroupDatabase[groupId];
	linkAdaptationSetHwGroupDbCommon(groupId,addGroupParameters->participatingStations);
	memset (&LinkAdaptationVhtGroupDatabase[groupId], 0, sizeof(LinkAdaptationVhtGroupDatabase_t));
	TURN_ON_BIT(&VhtGroupActiveGroupsBitmap, groupId);					

	/*Set configuration params for the group*/
	pLinkAdaptationDb->laStaGroupCommon.pLinkAdaptationConfigurationParams = &LinkAdaptationConfigParamsSteadyState;

	for(uspIndex = 0; uspIndex < MAX_USP_IN_VHT_GROUP; uspIndex++)
	{
		LinkAdaptationVhtGroupDatabase[groupId].laVhtGroupUnique.groupStationIndexes[uspIndex] = addGroupParameters->participatingStations[uspIndex]; 
		if(addGroupParameters->participatingStations[uspIndex] != INVALID_STA_INDEX)
		{
			uspStaId = addGroupParameters->participatingStations[uspIndex]; 
			maxNssPerUsp = GROUP_MANAGER_GET_NSS_PER_USP(addGroupParameters->nssPerUsp, uspIndex);
			ASSERT(maxNssPerUsp <= SPATIAL_STREAM_2); /* We support only up to 2 nss per USP*/
			LinkAdaptationVhtGroupDatabase[groupId].laGroupUnique.groupHasFailedNotificationSent = FALSE; 
			LinkAdaptationVhtGroupDatabase[groupId].laVhtGroupUnique.probingValidationMask |= (0x1<<uspIndex); 
			linkAdaptationSetHwGroupDb(groupId,uspIndex,uspStaId);
			linkAdaptationSetVhtUspIndex(uspStaId,groupId,uspIndex);
			updateLaDbDistributionParam(&laDbDistributionParameter,groupId,uspIndex, FALSE);
			linkAdaptationResetGroupDb(&laDbDistributionParameter);			
			MEMCPY(&(laDbDistributionParameter.laStaUspCommon->staTransmissionParams),&(LinkAdaptationStaDatabase[uspStaId].laStaUspCommon.staTransmissionParams),sizeof(TransmissionParams_t));
			/*Copy turbo rates DB from single user station to group laStaUspCommon DB*/
			MEMCPY(&(laDbDistributionParameter.laStaUspCommon->turboRatesDb),&(LinkAdaptationStaDatabase[uspStaId].laStaUspCommon.turboRatesDb),sizeof(TurboRatesDataBase_t));
			bw = GetDataBwLimit(groupId, uspIndex, FALSE);
#ifdef ENET_INC_ARCH_WAVE600
			groupDbInitialRatePtr = &(GroupDbHwEntries[groupId].common.word12);

#else
			groupDbInitialRatePtr = &(GroupDbHwEntries[groupId].word20);
#endif
			groupDbInitialRatePtr += uspIndex; /* update pointer with the correspond USP entry - 
													1 word offset between consequitive USPs*/
			
			initialTcrRate = ((*groupDbInitialRatePtr) >> (bw*GROUP_DB_TCR3_BW_SHIFT_SIZE)) & GROUP_DB_RATE_MASK;
#ifdef LINK_ADAPTATION_LOGS			
			//("LA add group, GroupId ==%d, UsPIndex == %d,initialTcrRate ==%d ",groupId,uspIndex,initialTcrRate);
#endif
			initialRateIndex = convertTcr2RateIndex(PHY_MODE_11AC,initialTcrRate);

			/*Set the USP's rates mask*/
			setLinkAdaptationMuUspRatesMask(&laDbDistributionParameter,&(LinkAdaptationStaDatabase[uspStaId].laStaUspCommon.raIndexMask),maxNssPerUsp, PRE_AGGREGATOR_NUM_OF_RU_SIZES);

			setUspRatesTables(&laDbDistributionParameter, LinkAdaptationStaDatabase[uspStaId].laStaUspCommon.pRatesTablesDb);

			/* Make sure rate is in mask since training does not take into considerations the station's capabilities: Get the closest rate in mask (WLANRTSYS-9917) */
			initialRateIndex = rateAdaptationGetLowerRateIndex(&laDbDistributionParameter, bw, initialRateIndex, LinkAdaptationStaDatabase[uspStaId].laStaUspCommon.raIndexMask, 0, TRUE);

			rateAdaptationChangeWorkingPoint(&laDbDistributionParameter, initialRateIndex, initialRateIndex);
			
			/*Change Rate adaptation state, if not configured as fixed rate station*/
			laStateMachineChangeState(&laDbDistributionParameter,LA_WAIT_FOR_NEXT_PROBE_CYCLE);
			/* copy staTransmissionParams to the USP TransmissionParams*/
		}
	}


	/* Opearating Mode Notification: Store Action frame info before STA's memory reset and get element from ADD STA */
	/* Should be called before reset of STA DB */
	CyclicPrefixAddGroup(groupId);

	pLinkAdaptationDb->laGroupUnique.groupState = LA_PRELIMINARY_PROBING_STATE; 	
	/*Send confirmation to GM*/
	groupManagerAddGroupConfirmationMessage = OSAL_GET_MESSAGE(sizeof(GroupManagerAddGroupConfirmationMessage_t));
	addGroupConfirmationParameters = ((GroupManagerAddGroupConfirmationMessage_t *)pK_MSG_DATA(groupManagerAddGroupConfirmationMessage));
	addGroupConfirmationParameters->groupIndex = addGroupParameters->groupIndex;
	OSAL_SEND_MESSAGE(GROUP_MANAGER_ADD_GROUP_CONFIRMATION, TASK_GROUP_MANAGER, groupManagerAddGroupConfirmationMessage,psMsg->header.vapId);
}

/**********************************************************************************
linkAdaptationRemoveGroupReq


Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationRemoveVhtGroup(K_MSG * psMsg)
{
	K_MSG *groupManagerRemoveGroupConfirmationMessage	= NULL;  
	GroupManagerRemoveGroupConfirmationMessage_t *removeGroupConfirmationParameters = NULL;
	LaRemoveGroupParams_t *removeGroupParameters = NULL;
	uint8	uspIndex = 0;
	uint8	groupId = 0; //KW_FIX_FW_G Index for an array should be unsigned
	StaId	uspStaId;

	removeGroupParameters = (LaRemoveGroupParams_t *)pK_MSG_DATA(psMsg);
	groupId = removeGroupParameters->groupIndex;
	
	for(uspIndex = 0; uspIndex < MAX_USP_IN_VHT_GROUP; uspIndex++)
	{
		uspStaId = removeGroupParameters->participatingStations[uspIndex]; 
		if(uspStaId != INVALID_STA_INDEX)
		{
			linkAdaptationResetVhtUspIndex(uspStaId,groupId);
		}
	}
	/* Set the group state to INACTIVE_GROUP_STATE*/
	LinkAdaptationVhtGroupDatabase[groupId].laGroupUnique.groupState = LA_INACTIVE_GROUP_STATE;
	CyclicPrefixRemoveGroup(groupId);
	groupManagerRemoveGroupConfirmationMessage = OSAL_GET_MESSAGE(sizeof(GroupManagerRemoveGroupConfirmationMessage_t));
	removeGroupConfirmationParameters = ((GroupManagerRemoveGroupConfirmationMessage_t *)pK_MSG_DATA(groupManagerRemoveGroupConfirmationMessage));
	removeGroupConfirmationParameters->groupIndex = groupId;
	TURN_OFF_BIT(&VhtGroupActiveGroupsBitmap, groupId);					

	OSAL_SEND_MESSAGE(GROUP_MANAGER_REMOVE_GROUP_CONFIRMATION, TASK_GROUP_MANAGER, groupManagerRemoveGroupConfirmationMessage,psMsg->header.vapId);
}

#ifdef ENET_INC_ARCH_WAVE600
/**********************************************************************************
linkAdaptationAddHeGroup



Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationAddHeGroup(K_MSG *psMsg)
{
	CommonPlan_u* planPtr;
	DlDataPhase_t* phasePtr;
	uint32* phase0Addr;
	uint8 phaseIterator;
	LaAddHeGroupParams_t *addHeGroupParameters = NULL;
	LaAddHeGroupCfm_t* addHeGroupCfm = NULL;
	K_MSG* cfmMsg;
	bool phaseFirstOccurrence = FALSE;
	LaAddHeGroupStatus_e allocationStatus = LA_ADD_HE_GROUP_SUCCEEDED;
	
	addHeGroupParameters = (LaAddHeGroupParams_t *)pK_MSG_DATA(psMsg);
	planPtr = (CommonPlan_u *)&heMuPlansArray[addHeGroupParameters->planIndex];
	phase0Addr = (uint32 *)&planPtr->PhasePointers[COMMON_PLAN_PHASE0_POINTER_LOCATION]; //KW_FIX_FW_G

	/* 	run over all valid (and first) phases and allocate entries in LinkAdaptationHePhaseDatabase accordingly */
	for (phaseIterator = 0; phaseIterator < MAX_NUM_OF_PHASES_IN_A_PLAN; phaseIterator++)
	{
		if (GET_BIT_IN_BYTE(planPtr->tCommonPlan.phaseValid, phaseIterator) != 0)
		{
			phaseFirstOccurrence = (GET_BIT_IN_BYTE(planPtr->tCommonPlan.phaseFirstOccurrence, phaseIterator) != 0);
			phasePtr = (DlDataPhase_t*)(phase0Addr[phaseIterator]);
			switch (phasePtr->common.phaseType)
			{
				case PHASE_TYPE_PROTECTION_PHASE:
					linkAdaptationAddHeProtectionPhase(addHeGroupParameters, (ProtectionPhase_t*)phasePtr, phaseFirstOccurrence, psMsg->header.vapId);
					break;
					
				case PHASE_TYPE_SOUNDING_PHASE:
					linkAdaptationAddHeSoundingPhase(addHeGroupParameters, (SoundingPhase_t*)phasePtr, phaseFirstOccurrence, psMsg->header.vapId, addHeGroupParameters->planIndex);
					break;
					
				case PHASE_TYPE_DL_DATA_PHASE:
					allocationStatus = linkAdaptationAddHeDlDataPhase(addHeGroupParameters, (DlDataPhase_t*)phasePtr, phaseIterator, phaseFirstOccurrence, psMsg->header.vapId);
					break;
				
				case PHASE_TYPE_UL_DATA_PHASE:
					linkAdaptationAddHeUlDataPhase(addHeGroupParameters, (UlDataPhase_t*)phasePtr, phaseFirstOccurrence, psMsg->header.vapId);
					break;
					
				default:
					break;
			}
			
			if (allocationStatus == LA_ADD_HE_GROUP_FAILED)
			{
				break;
			}
		}
	}
	MetricsCalculator_ResetGroupData(addHeGroupParameters->groupId);
	/*Send confirmation to Plan manager */ 
	cfmMsg = OSAL_GET_MESSAGE(sizeof(LaAddHeGroupCfm_t));
	addHeGroupCfm = (LaAddHeGroupCfm_t *)pK_MSG_DATA(cfmMsg);
	addHeGroupCfm->groupId = addHeGroupParameters->groupId;
	addHeGroupCfm->status = allocationStatus;
	addHeGroupCfm->isStaticGroup = addHeGroupParameters->isStaticGroup;
	OSAL_SEND_MESSAGE(PLAN_MANAGER_CREATE_PLAN_LA_CFM, TASK_PLAN_MANAGER, cfmMsg, psMsg->header.vapId);
}

static LaAddHeGroupStatus_e linkAdaptationAddHeDlDataPhase(LaAddHeGroupParams_t *addHeGroupParameters, DlDataPhase_t* phasePtr, uint8 phaseEntryInPlan, bool phaseFirstOccurrence, uint8 vapId)
{
	DlDataPhase_t* mirrorPhasePtr;
	uint8 phaseDbEntry;
	uint16 userTcraStaAid;
	uint8 uspStaId;
	uint8 uspIndex;
	LinkAdaptationDatabaseDistributionPack_t	laDbDistributionParameter; 
	LinkAdaptationHePhaseDatabase_t*	pLinkAdaptationDb = NULL;
	uint8 maxNssPerUsp = SPATIAL_STREAM_4; /*Limit on top of STA capabilities. For OFDMA - 4 NSS (no limit). For MIMO - An input from Plan Manager*/
	uint8 initialTcrRate, initialRateIndex;
	uint8 numOfValidUsers;
	LaAddHeGroupStatus_e allocationStatus = LA_ADD_HE_GROUP_SUCCEEDED;
	DlMuMimo_e dlMuMimoType;
	uint32 rateInMask = 0;
#ifdef ENET_INC_ARCH_WAVE600D2
	dlMuMimoType = phasePtr->common.dataMuMimo;
#else
	dlMuMimoType = phasePtr->common.muMimo;
#endif

#ifdef PHY_STUCK_LDPC_IS_SET_SYMBOLS_ABOVE_400
	// this is done only for static group, dynamic group case is handled in another code
	if(addHeGroupParameters->isStaticGroup)
	{
		DlDataPhaseUserPhase_t *dlDataPhasePerUserPtr = &phasePtr->userPhase[0];
		uint32 newMaxPsduLength = 0;
		if((1 == dlDataPhasePerUserPtr->userTcraLdpc) && (PRE_AGGREGATOR_996X2_TONE_RU_SIZE == dlDataPhasePerUserPtr->userTcraRuSize))
		{
			// in static group check if problematic rate is set for station and limit MaxPsduLength if required
			ILOG0_V("PHY_STUCK_LDPC_IS_SET_SYMBOLS_ABOVE_400 : staticGroup");
			if(isPsduLengthLimitationNeeded(dlDataPhasePerUserPtr->userTcraPsduRate, &newMaxPsduLength))
			{
				ILOG0_DD("PHY_STUCK_LDPC_IS_SET_SYMBOLS_ABOVE_400 : staticGroup, limitation needed. CurrentLimit %d, newLimit %d", phasePtr->common.currentPsduMaxLengthLimit, newMaxPsduLength);
				originalMuMaxPsduLengthLimit[dlDataPhasePerUserPtr->staId] = phasePtr->common.currentPsduMaxLengthLimit;
				phasePtr->common.currentPsduMaxLengthLimit = MIN(newMaxPsduLength, phasePtr->common.currentPsduMaxLengthLimit);
			}
		}
	}
#endif
	if (phaseFirstOccurrence)
	{
		/* Validate that there is at least one free entry */
		if(LinkAdaptationHePhaseDatabase[addHeGroupParameters->groupId].laHeGroupUnique.planIndex == HE_GROUP_MANAGER_INVALID_PLAN_INDEX)
		{
			ILOG0_D("linkAdaptationAddHeGroup, PlanIndex = %d",addHeGroupParameters->planIndex);
			/* Allocate entry in LA DB */
			phaseDbEntry = addHeGroupParameters->groupId;
            TURN_ON_BIT(&heDlDataPhaseActiveGroupsBitmapPerBand, phaseDbEntry);	
			memset (&LinkAdaptationHePhaseDatabase[phaseDbEntry], 0, sizeof(LinkAdaptationHePhaseDatabase_t));	
			pLinkAdaptationDb = &LinkAdaptationHePhaseDatabase[phaseDbEntry];
			pLinkAdaptationDb->laHeGroupUnique.planIndex = addHeGroupParameters->planIndex;
			setWpPhaseAddress(phasePtr, phaseDbEntry);
			/* Set corresponding bit in phaseEntriesBitmap for each phase pointer in plan that points to this phase */
			TURN_ON_BIT(&pLinkAdaptationDb->laHeGroupUnique.phaseEntriesBitmap, phaseEntryInPlan);
			/* Set phase Db Entry Id in phase */
			phasePtr->common.dlPhaseId = phaseDbEntry;
			ILOG0_DD("linkAdaptationAddHeGroup, PlanIndex = %d, phaseEntryInPlan = 0X%0X", pLinkAdaptationDb->laHeGroupUnique.planIndex,pLinkAdaptationDb->laHeGroupUnique.phaseEntriesBitmap);
			/*Set configuration params for the group*/
			pLinkAdaptationDb->laStaGroupCommon.pLinkAdaptationConfigurationParams = &LinkAdaptationConfigParamsSteadyState;
			
			/* set phase TCRs */
			setDlDataPhaseParams(phasePtr, vapId, addHeGroupParameters->isStaticGroup);
			
			numOfValidUsers = getNumOfValidUspInPhase(phasePtr);
			for(uspIndex = 0; uspIndex < NUM_OF_USERS_MU_HE_PHASE; uspIndex++)
			{
				userTcraStaAid = phasePtr->userPhase[uspIndex].userTcraStaAid;
				if (uspIndex < numOfValidUsers)
				{
					// mask of bitmap indicates all valid users in group including dummy-user since it compares to bitmap which will also indicate probing valid for dummy-user
					LA_SET_BIT_IN_BITMAP(pLinkAdaptationDb->laHeGroupUnique.probingValidationMask.heUspBitmap,uspIndex, BITMAP_ARRAY_MAX_SIZE_2); //KW_FIX_FW_G Added array bound check
					if (userTcraStaAid != DUMMY_AID)
					{
						pLinkAdaptationDb->laHeGroupUnique.groupStationIndexes[uspIndex] = phasePtr->userPhase[uspIndex].staId; 
						uspStaId = pLinkAdaptationDb->laHeGroupUnique.groupStationIndexes[uspIndex]; 
						
						pLinkAdaptationDb->laGroupUnique.groupHasFailedNotificationSent = FALSE; 
						
						updateLaDbDistributionParam(&laDbDistributionParameter,phaseDbEntry,uspIndex, TRUE);
						linkAdaptationResetGroupDb(&laDbDistributionParameter); 		
						/* copy staTransmissionParams to the USP TransmissionParams*/
						MEMCPY(&(laDbDistributionParameter.laStaUspCommon->staTransmissionParams),&(LinkAdaptationStaDatabase[uspStaId].laStaUspCommon.staTransmissionParams),sizeof(TransmissionParams_t));
						initialTcrRate = phasePtr->userPhase[uspIndex].userTcraPsduRate;
						initialRateIndex = convertTcr2RateIndex(PHY_MODE_11AX_SU,initialTcrRate);
						if (dlMuMimoType == DL_MU_MIMO_MU_MIMO) //MIMO phase
						{
							DEBUG_ASSERT(uspIndex < MAX_NUM_OF_USERS_IN_MIMO_GROUP);
							maxNssPerUsp = addHeGroupParameters->maxNss[uspIndex];
							DEBUG_ASSERT(maxNssPerUsp <= SPATIAL_STREAM_2); /* We support only up to 2 nss per USP*/						
						}					
						/*Set the USP's rates mask*/
						setLinkAdaptationMuUspRatesMask(&laDbDistributionParameter,&(LinkAdaptationStaDatabase[uspStaId].laStaUspCommon.raIndexMask),maxNssPerUsp, phasePtr->userPhase[uspIndex].userTcraRuSize);
						setUspRatesTables(&laDbDistributionParameter, LinkAdaptationStaDatabase[uspStaId].laStaUspCommon.pRatesTablesDb);
						/* Adjust initialRateIndex to MU USP rates mask */
						initialRateIndex = rateAdaptationGetLowerRateIndex(&laDbDistributionParameter, LinkAdaptationCommonConfiguration.wlanBandwidthMax, initialRateIndex, laDbDistributionParameter.laStaUspCommon->raIndexMask, 0, FALSE);
						rateInMask = isBitInMask64Bit(initialRateIndex, laDbDistributionParameter.laStaUspCommon->raIndexMask.raIndexMask64bit);
						ASSERT(rateInMask != 0);
						ILOG0_D("[linkAdaptationAddHeDlDataPhase] initialRateIndex after ratemask adjustment %d", initialRateIndex);
						rateAdaptationChangeWorkingPoint(&laDbDistributionParameter, initialRateIndex, initialRateIndex);	
						/*Change Rate adaptation state, if not configured as fixed rate station*/
						laStateMachineChangeState(&laDbDistributionParameter,LA_WAIT_FOR_NEXT_PROBE_CYCLE); 			
						//CyclicPrefixAddGroup(phaseDbEntry);					
					}
				}
				else
				{
					pLinkAdaptationDb->laHeGroupUnique.groupStationIndexes[uspIndex] = INVALID_STA_INDEX; 
				}
			}	
			/* copy phase params to mirror phase */
			mirrorPhasePtr = (DlDataPhase_t*)phasePtr->common.nextOrMirrorPhasePointer;
			memcpy32(mirrorPhasePtr, phasePtr, CONVERT_BYTES_TO_WORDS(sizeof(DlDataPhase_t)));
			mirrorPhasePtr->common.nextOrMirrorPhasePointer = (uint32)phasePtr;
			mirrorPhasePtr->common.oneShotPhase = 1;
			
			/* Change group state */
			pLinkAdaptationDb->laGroupUnique.groupState = LA_ACTIVE_GROUP_STATE;	
		}
		else
		{
			ILOG0_V("linkAdaptationAddHeDlDataPhase, group creation failed");
			allocationStatus = LA_ADD_HE_GROUP_FAILED;
		}
	}
	else
	{
		/* LA DB entry should be already allocated here. Take DB entry from phase */
		phaseDbEntry = phasePtr->common.dlPhaseId;
		pLinkAdaptationDb = &LinkAdaptationHePhaseDatabase[phaseDbEntry];
		/* LA DB entry is already allocated, just set the corresponding bit in phaseEntriesBitmap */
		TURN_ON_BIT(&pLinkAdaptationDb->laHeGroupUnique.phaseEntriesBitmap, phaseEntryInPlan);
	}

	ILOG0_V("linkAdaptationAddHeDlDataPhase, Function Ends");

	return allocationStatus;
}

static LaAddHeGroupStatus_e linkAdaptationAddHeUlDataPhase(LaAddHeGroupParams_t *addHeGroupParameters, UlDataPhase_t* phasePtr, bool phaseFirstOccurrence, uint8 vapId)
{	
	LaAddHeGroupStatus_e allocationStatus = LA_ADD_HE_GROUP_SUCCEEDED;
	
	if (phaseFirstOccurrence)
	{
		/* set phase TCRs */
		setUlDataPhaseParams(phasePtr, vapId, addHeGroupParameters);
	}

	return allocationStatus;
}

static LaAddHeGroupStatus_e linkAdaptationAddHeProtectionPhase(LaAddHeGroupParams_t *addHeGroupParameters, ProtectionPhase_t* phasePtr, bool phaseFirstOccurrence, uint8 vapId)
{	
	LaAddHeGroupStatus_e allocationStatus = LA_ADD_HE_GROUP_SUCCEEDED;
	
	if (phaseFirstOccurrence)
	{
		/* set phase TCRs */
		setProtectionPhaseParams(phasePtr, vapId, addHeGroupParameters->isStaticGroup);
	}

	return allocationStatus;
}

/**********************************************************************************
linkAdaptationAddHeSoundingPhase

Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static LaAddHeGroupStatus_e linkAdaptationAddHeSoundingPhase(LaAddHeGroupParams_t *addHeGroupParameters, SoundingPhase_t* phasePtr, bool phaseFirstOccurrence, uint8 vapId, uint8 planIndex)
{
	LaAddHeGroupStatus_e allocationStatus = LA_ADD_HE_GROUP_SUCCEEDED;
		
	if (phaseFirstOccurrence)
	{
		/* set phase TCRs */
		setSoundingPhaseParams(phasePtr, vapId, addHeGroupParameters, planIndex);
	}

	return allocationStatus;
}

/**********************************************************************************
linkAdaptationRemoveHeGroup


Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationRemoveHeGroup(K_MSG * psMsg)
{
	LaRemoveHeGroupParams_t *removeHeGroupParameters = NULL;
	CommonPlan_u* planPtr;
	DlDataPhase_t* phasePtr;
	uint32* phase0Addr;
	uint8 phaseIterator;
	uint8	planIndex;
	uint8 phaseDbEntry;
	
	ILOG0_V("linkAdaptationRemoveHeGroup"); 

	removeHeGroupParameters = (LaRemoveHeGroupParams_t *)pK_MSG_DATA(psMsg);
	planIndex = removeHeGroupParameters->planIndex;
	planPtr = (CommonPlan_u*)&heMuPlansArray[planIndex];
	phase0Addr = (uint32 *)&planPtr->PhasePointers[COMMON_PLAN_PHASE0_POINTER_LOCATION]; //KW_FIX_FW_G
	
	for (phaseIterator = 0; phaseIterator < MAX_NUM_OF_PHASES_IN_A_PLAN; phaseIterator++)
	{
		if ((GET_BIT_IN_BYTE(planPtr->tCommonPlan.phaseValid, phaseIterator) != 0) && (GET_BIT_IN_BYTE(planPtr->tCommonPlan.phaseFirstOccurrence, phaseIterator) != 0))
		{
			phasePtr = (DlDataPhase_t*)(phase0Addr[phaseIterator]);
			
			switch (getPhaseTypeFromPlanIndex(planIndex, phaseIterator))
			{
				case PHASE_TYPE_PROTECTION_PHASE:
				case PHASE_TYPE_SOUNDING_PHASE:
				case PHASE_TYPE_UL_DATA_PHASE:
					break;
					
				case PHASE_TYPE_DL_DATA_PHASE:
					phaseDbEntry = getLaPhaseIdFromPlanIndex(planIndex, phaseIterator);
					/* Free LA DB entry  */
					ASSERT(LinkAdaptationHePhaseDatabase[phaseDbEntry].laHeGroupUnique.planIndex != HE_GROUP_MANAGER_INVALID_PLAN_INDEX); // entry should not be free
					LinkAdaptationHePhaseDatabase[phaseDbEntry].laHeGroupUnique.planIndex= HE_GROUP_MANAGER_INVALID_PLAN_INDEX;
                    TURN_OFF_BIT(&heDlDataPhaseActiveGroupsBitmapPerBand, phaseDbEntry);	
					/* Set the group state to INACTIVE_GROUP_STATE */
					LinkAdaptationHePhaseDatabase[phaseDbEntry].laGroupUnique.groupState = LA_INACTIVE_GROUP_STATE; 
					break;

				default:
					break;
			};
		}
	}
    
	//	CyclicPrefixRemoveGroup(groupId);
	
	/*Send confirmation to Plan manager */ 
	OSAL_SEND_MESSAGE(PLAN_MANAGER_REMOVE_PLAN_LA_CFM, TASK_PLAN_MANAGER, psMsg, psMsg->header.vapId);
}

static void sendLnaTypeHasChangedIndToHeGm(StaId staId, LnaType_e lnaType)
{
	K_MSG*	pLnaTypeMsg;
	LaLnaTypeIndMsg_t* plnaTypeMsgParams;

	// Send notification to HE Group Manager that LNA type of one of the stations has changed
	pLnaTypeMsg = OSAL_GET_MESSAGE(sizeof(LaLnaTypeIndMsg_t));
	plnaTypeMsgParams = (LaLnaTypeIndMsg_t*)pK_MSG_DATA(pLnaTypeMsg);		
	plnaTypeMsgParams->staId = staId;
	plnaTypeMsgParams->lnaType = lnaType;
	
	OSAL_SEND_MESSAGE(HE_GROUP_MANAGER_LNA_TYPE_HAS_CHANGED_IND, TASK_HE_GROUP_MANAGER, pLnaTypeMsg, GET_DEFAULT_VAP_FOR_MY_BAND());
}

static void linkAdaptationGetPhyRate(K_MSG *psMsg)
{
	LaGetPhyRateParams_t* pGetPhyRateParams = (LaGetPhyRateParams_t*)psMsg->abData;
	uint8 rateIndex;
	const RateObj_t* ratesTable = htVhtRatesTable;

	if (pGetPhyRateParams->phyMode == PHY_MODE_11AX_SU)
	{
		rateIndex = heTcr2RateIndex[pGetPhyRateParams->mcs][pGetPhyRateParams->nss];
		ratesTable = heRatesTable;
	}
	else if (pGetPhyRateParams->phyMode == PHY_MODE_11AC)
	{
		rateIndex = vhtTcr2RateIndex[pGetPhyRateParams->mcs][pGetPhyRateParams->nss];		
	}
	else if (pGetPhyRateParams->phyMode == PHY_MODE_11N)
	{
		rateIndex = htTcr2RateIndex[pGetPhyRateParams->mcs];		
	}
	else if (pGetPhyRateParams->phyMode == PHY_MODE_11B)
	{
		rateIndex = (pGetPhyRateParams->mcs + PHY11B_TCR_TO_RATE_INDEX_OFFSET) ;
	}
	else
	{
		DEBUG_ASSERT(pGetPhyRateParams->phyMode == PHY_MODE_11AG);
		rateIndex = pGetPhyRateParams->mcs;
	}
	pGetPhyRateParams->phyRate = getPhyRate(ratesTable, rateIndex,pGetPhyRateParams->bw,pGetPhyRateParams->cp);
	OSAL_SEND_MESSAGE(DUT_GET_PHY_RATE_CFM, TASK_DUT, psMsg,GET_DEFAULT_VAP_FOR_MY_BAND());
}


#endif

uint16 getPhyRate(const RateObj_t*  ratesTable, uint8 rateIndex, Bandwidth_e bandwidth, uint8 cpType)
{
	uint16 phyRate;
	
	if (cpType == CP_SHORT_HT_VHT_HE)
	{
		phyRate = ratesTable[rateIndex].rateTableBwParmas[bandwidth].shortCpPhyRate;
	}
	else if (cpType == CP_LONG_HT_VHT_MED_HE)
	{
		phyRate = ratesTable[rateIndex].rateTableBwParmas[bandwidth].mediumCpPhyRate;
	}
	else
	{	
#ifdef ENET_INC_ARCH_WAVE600	
		phyRate = ratesTable[rateIndex].rateTableBwParmas[bandwidth].longCpPhyRate;
#else
		ASSERT(0); // We don't have long CP in gen5. We shouldn't have requested for it.
#endif
	}

	ASSERT(phyRate != MAX_UINT16);
	return phyRate;
}

/**********************************************************************************
linkAdaptatioTxopTimeLimitConfig

Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptatioTxopTimeLimitConfig(K_MSG * psMsg)
{
	LaTxopDurationParams_t *txopDurationParams	= (LaTxopDurationParams_t *)pK_MSG_DATA(psMsg);
	
	if (FALSE == txopDurationParams->isMu)
	{
		/*SU txop duration*/
		TxSequencer_SetMinimalSuTxopTimeThreshold(txopDurationParams->txopTimeThreshold);
	}
	else
	{
		/*MU txop duration*/
		TxSequencer_SetMinimalVhtMuTxopTimeThreshold(txopDurationParams->txopTimeThreshold);
	}
}


/**********************************************************************************

linkAdaptationStartSingleUserValidation 


Description:
------------
Handle a request from the group manager to start single user validation on a specific 
station


Input: 
-----


Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationStartSingleUserValidation(K_MSG *psMsg )
{
	K_MSG *groupManagerMessage	= NULL;
	GroupManagerSingleUserValidationStartConfirmationMessage_t *startSingleUserValidationConfirmationParameters = NULL;
	LaStartSingleUserValidationParams_t *startSingleUserValidationParameters = NULL;
	startSingleUserValidationParameters = (LaStartSingleUserValidationParams_t *)pK_MSG_DATA(psMsg);

	LinkAdaptationStaDatabase[startSingleUserValidationParameters->stationIndex].laStationUnique.singleUserProbingState = LA_SINGLE_USER_PROBING_STATE; 
	LinkAdaptationStaDatabase[startSingleUserValidationParameters->stationIndex].laStationUnique.singleUserProbingCount = 0;
	
	groupManagerMessage = OSAL_GET_MESSAGE(sizeof(GroupManagerSingleUserValidationStartConfirmationMessage_t));
	startSingleUserValidationConfirmationParameters = ((GroupManagerSingleUserValidationStartConfirmationMessage_t *)pK_MSG_DATA(groupManagerMessage));
	startSingleUserValidationConfirmationParameters->stationIndex = startSingleUserValidationParameters->stationIndex;

	OSAL_SEND_MESSAGE(GROUP_MANAGER_SINGLE_USER_VALIDATION_START_CONFIRMATION, TASK_GROUP_MANAGER, groupManagerMessage, psMsg->header.vapId);
}

/**********************************************************************************

linkAdaptationEndSingleUserValidation 


Description:
------------
Handle a request from the group manager to end single user validation on a specific 
station


Input: 
-----


Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationEndSingleUserValidation(K_MSG *psMsg )
{
	K_MSG *groupManagerMessage	= NULL; 
	GroupManagerSingleUserValidationEndConfirmationMessage_t *endSingleUserValidationConfirmationParameters = NULL;

	LaEndSingleUserValidationParams_t *endSingleUserValidationParameters = NULL;
	endSingleUserValidationParameters = (LaEndSingleUserValidationParams_t *)pK_MSG_DATA(psMsg);
	
	LinkAdaptationStaDatabase[endSingleUserValidationParameters->stationIndex].laStationUnique.singleUserProbingState = LA_SINGLE_USER_MODE_STATE; 
	LinkAdaptationStaDatabase[endSingleUserValidationParameters->stationIndex].laStationUnique.singleUserProbingCount = 0;

	groupManagerMessage = OSAL_GET_MESSAGE(sizeof(GroupManagerSingleUserValidationEndConfirmationMessage_t));
	endSingleUserValidationConfirmationParameters = ((GroupManagerSingleUserValidationEndConfirmationMessage_t *)pK_MSG_DATA(groupManagerMessage));
	endSingleUserValidationConfirmationParameters->stationIndex = endSingleUserValidationParameters->stationIndex;

	OSAL_SEND_MESSAGE(GROUP_MANAGER_SINGLE_USER_VALIDATION_END_CONFIRMATION, TASK_GROUP_MANAGER, groupManagerMessage, psMsg->header.vapId);
}

/**********************************************************************************
linkAdaptationSuProbingHandler



Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
void linkAdaptationSuProbingHandler(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter)
{
	uint8 stationGrade; 
	K_MSG* groupManagerMessage;
	GroupManagerSingleUserResultsMessage_t* groupManagerSuProbingResultMessage; 
	
	if((LinkAdaptationSuProbingState_e)(laDbDistributionParameter->laStationUnique->singleUserProbingState) == LA_SINGLE_USER_PROBING_STATE)
	{
		if(laDbDistributionParameter->laStationUnique->singleUserProbingCount < laDbDistributionParameter->laStaGroupCommon->pLinkAdaptationConfigurationParams->suProbingValidationTh)
		{	
			laDbDistributionParameter->laStationUnique->singleUserProbingCount++; 
#ifdef LINK_ADAPTATION_LOGS
//			ILOG0_D("SINGLEUSER PROBING HANDLER - sup count == %d ",laDbDistributionParameter->laStationUnique->singleUserProbingCount); 
#endif
		}
		else
		{
			laDbDistributionParameter->laStationUnique->singleUserProbingCount = 0; 
			laDbDistributionParameter->laStationUnique->singleUserProbingState = LA_SINGLE_USER_MODE_STATE; 
			/* Get station's grade*/
			stationGrade = AlphaFilter_GetFilterResult(&(laDbDistributionParameter->laStaGroupCommon->wpAverageGoodPut));
#ifdef LINK_ADAPTATION_LOGS			
//			ILOG0_D("SINGLEUSER PROBING END - station's grade == %d",stationGrade); 
#endif
			/* Send indication to GM */
			groupManagerMessage = OSAL_GET_MESSAGE(sizeof(GroupManagerSingleUserResultsMessage_t));
			groupManagerSuProbingResultMessage = ((GroupManagerSingleUserResultsMessage_t *)pK_MSG_DATA(groupManagerMessage));
			groupManagerSuProbingResultMessage->stationIndex = laDbDistributionParameter->stationOrGroupIndex; 
			groupManagerSuProbingResultMessage->stationMark = stationGrade; 
			linkAdaptationFillAllGroupMarks(groupManagerSuProbingResultMessage->groupMarks); 
			OSAL_SEND_MESSAGE(GROUP_MANAGER_SINGLE_USER_VALIDATION_RESULTS, TASK_GROUP_MANAGER, groupManagerMessage, GET_DEFAULT_VAP_FOR_MY_BAND());
		}
	}
}

/**********************************************************************************
linkAdaptationMuPreliminaryHandler



Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
void linkAdaptationMuPreliminaryHandler(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter)
{
#ifdef LINK_ADAPTATION_LOGS	
//	uint8 groupGrade;
#endif
	uint8 uspIndex; 
	StaId staIndex; 
	K_MSG *groupManagerProbingResultsMessage	= NULL; 
	GroupManagerProbingResultsMessage_t* probingResults; 

	if(laDbDistributionParameter->laGroupUnique->groupState == LA_PRELIMINARY_PROBING_STATE)
	{
		if(laDbDistributionParameter->laGroupUnique->groupPreliminaryProbingCount < laDbDistributionParameter->laStaGroupCommon->pLinkAdaptationConfigurationParams->muPreliminaryProbingTh)
		{	
			laDbDistributionParameter->laGroupUnique->groupPreliminaryProbingCount++; 
#ifdef LINK_ADAPTATION_LOGS			
//			ILOG0_DD("linkAdaptationMuPreliminaryHandler - groupIndex = %d, probing count = %d ",laDbDistributionParameter->stationOrGroupIndex, laDbDistributionParameter->laGroupUnique->groupPreliminaryProbingCount); 
#endif
		}
		else
		{
			laDbDistributionParameter->laGroupUnique->groupPreliminaryProbingCount = 0; 
			laDbDistributionParameter->laGroupUnique->groupState= LA_ACTIVE_GROUP_STATE; 
			for(uspIndex = 0; uspIndex < GROUP_MANAGER_MAX_NUMBER_OF_STATIONS_IN_GROUP; uspIndex++)
			{
				staIndex = laDbDistributionParameter->laVhtGroupUnique->groupStationIndexes[uspIndex];
				if(staIndex != INVALID_STA_INDEX)
				{
					ASSERT(staIndex < HW_NUM_OF_STATIONS); //KW_FIX_FW_G
#ifndef ENET_INC_ARCH_WAVE600
					LinkAdaptationStaDatabase[staIndex].laStationUnique.muGroupCount++;
#endif
				}
			}
			/* Get station's grade*/
#ifdef LINK_ADAPTATION_LOGS			
//			groupGrade = AlphaFilter_GetFilterResult(&(laDbDistributionParameter->laStaGroupCommon->wpAverageGoodPut));
//			ILOG0_DD("linkAdaptationMuPreliminaryHandler,  PROBING END - groupIndex = %d, grade = %d", laDbDistributionParameter->stationOrGroupIndex, groupGrade); 
#endif
			
			/* Send indication to GM */
			groupManagerProbingResultsMessage = OSAL_GET_MESSAGE(sizeof(GroupManagerProbingResultsMessage_t));
			probingResults = ((GroupManagerProbingResultsMessage_t *)pK_MSG_DATA(groupManagerProbingResultsMessage));
			probingResults->probingGroupIndex = laDbDistributionParameter->stationOrGroupIndex; 
			linkAdaptationFillAllGroupMarks(probingResults->groupMarks); 
			linkAdaptationFillGroupUspsSUMarks(probingResults->stationSuMark,laDbDistributionParameter->stationOrGroupIndex); 
			linkAdaptationFillGroupUspsMUMarks(probingResults->stationMuMark,laDbDistributionParameter->stationOrGroupIndex);
			OSAL_SEND_MESSAGE(GROUP_MANAGER_PROBING_RESULTS, TASK_GROUP_MANAGER, groupManagerProbingResultsMessage,GET_DEFAULT_VAP_FOR_MY_BAND());

		}
	}
}

/**********************************************************************************

linkAdaptationGetGroupsMarks 


Description:
------------
Handle a request from the group manager to get all active groups' marks


Input: 
-----


Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationGetGroupsMarks(K_MSG *psMsg )
{
	K_MSG *groupManagerMessage	= NULL; 
	GroupManagerGroupsMarksMessage_t *groupMarksParameters = NULL;
	uint8 groupIndex = 0;
	bool isFilterValid = FALSE; 
	UNUSED_PARAM(psMsg);
	
	groupManagerMessage = OSAL_GET_MESSAGE(sizeof(GroupManagerGroupsMarksMessage_t));
	groupMarksParameters = ((GroupManagerGroupsMarksMessage_t *)pK_MSG_DATA(groupManagerMessage));

	memset(&(groupMarksParameters->groupMarks),INVALID_GROUP_MARKS,sizeof(GroupManagerGroupsMarksMessage_t));

	for(groupIndex = 0; groupIndex < GROUP_MANAGER_MAX_NUMBER_OF_GROUPS; groupIndex++)
	{
#ifndef ENET_INC_ARCH_WAVE600
		ASSERT(groupIndex < TX_MU_GROUPS); //KW_FIX_FW_G
#endif
		isFilterValid = AlphaFilter_isFilterResultValid(&(LinkAdaptationVhtGroupDatabase[groupIndex].laStaGroupCommon.wpAverageGoodPut), LinkAdaptationVhtGroupDatabase[groupIndex].laStaGroupCommon.pLinkAdaptationConfigurationParams->maxValidFilterTsfDiff);
		if(isFilterValid)
		{
			groupMarksParameters->groupMarks[groupIndex] = AlphaFilter_GetFilterResult(&(LinkAdaptationVhtGroupDatabase[groupIndex].laStaGroupCommon.wpAverageGoodPut));
		}
#ifdef LINK_ADAPTATION_LOGS
//		ILOG0_DD("linkAdaptationGetGroupsMarks,	groupId -%d , group's grade == %d",groupIndex, groupMarksParameters->groupMarks[groupIndex]); 
#endif
	}
	OSAL_SEND_MESSAGE(GROUP_MANAGER_GROUPS_MARKS, TASK_GROUP_MANAGER, groupManagerMessage,GET_DEFAULT_VAP_FOR_MY_BAND());
}


/**********************************************************************************
setMaskAccordingtoAntennasNum

Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/

void setMaskAccordingToMaxNumOfAntennas(LinkAdaptationDatabaseDistributionPack_t* distributionParams, uint8 antennaCount)
{
	RateMask_t* disableNssMaskArr = disableHtVhtNssMaskAccordingtoAntNum;

	DEBUG_ASSERT(antennaCount > 0);
#ifdef ENET_INC_ARCH_WAVE600
	if (distributionParams->laStaUspCommon->staTransmissionParams.heSta == TRUE)
	{
		disableNssMaskArr = disableHeNssMaskAccordingtoAntNum;
	}
#endif
	andOperator64Bit(distributionParams->laStaUspCommon->raIndexMaskOrg.raIndexMask64bit,disableNssMaskArr[antennaCount-1].raIndexMask64bit,distributionParams->laStaUspCommon->raIndexMask.raIndexMask64bit);
}

/**********************************************************************************
linkAdaptationRemoveStationReq


Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/

void linkAdaptationRemoveStationReq(K_MSG *psMsg)
{
	BssManagerStaManagerReq_t *staManagerReq = (BssManagerStaManagerReq_t *)pK_MSG_DATA(psMsg);
	K_MSG *pMsg = staManagerReq->psMsg;
	UMI_STA_REMOVE *pCloseSta = (UMI_STA_REMOVE *)pK_MSG_DATA(pMsg);
	StaId stationIndex = pCloseSta->u16SID;
	LaGlobalTimersTypes_e timerIndex;
    uint8 wpRateIndex;
    
#ifdef LINK_ADAPTATION_LOGS
	//("Lm_removeStaFromList %X", stationIndex);
#endif
	
	linkAdaptationUpdateProtectionRateOnRemoveSta((PhyMode_e)StaDbHwEntries[stationIndex].common.staPhyCapabilities);

#ifdef TRAINING_FIRST_PHASE_POOL
	decreaseMaxBwCount(stationIndex,(Bandwidth_e)(StaDbHwEntries[stationIndex].common.dataBwLimit));
#endif //TRAINING_FIRST_PHASE_POOL

    wpRateIndex = GetStaWpRateIndexFromHwTcr(stationIndex, BANDWIDTH_TWENTY);

    /*  DMR: since it can be that there is more than 1 station, that have lowest rate, set to 
        current multicast rate; We can't ensure this station is the only one and can't change 
        the rate only according to this station rate change. */
    linkAdaptationDmrStationEventHandler(stationIndex, wpRateIndex, wpRateIndex, DMR_REMOVE_STATION);

	laStateMachineInit(stationIndex,INVALID_MU_USP_INDEX, FALSE);
	ProtectionAdaptation_RemoveSta(stationIndex);
	/*Beamforming remove statioin*/
	BeamformingRemoveStation(stationIndex);

	Lm_removeStaFromList(&LmStaDataBase, stationIndex);
	/* Set TxOP mode */
	DynamicTxop_RemoveStation(stationIndex);

	/*If there is no stations connect, Remove activate timers events*/
	if (LmStaDataBase.NumOfConnectedSta == 0)
	{
		for (timerIndex = FIRST_TIMER_IN_LIST; timerIndex < NUMBER_OF_LINK_ADAPTATION_TIMERS; timerIndex++)
		{
			TimerUtiltyRemoveEvent(&linkAdaptaionActivateTimersIds[timerIndex]);
		}
	}

	/*Send confirmation to BSS manager*/
	linkAdaptationStaSendConfirm(stationIndex);
}

#ifdef LINK_ADAPTATION_REGISTRATION
/**********************************************************************************
linkAdaptationRegistrationTablesInit


Description:
------------
Initiate resgistration tables
Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationRegistrationTablesInit(void)
{
	RegistrationWpChangeTableObj.numOfElementInTable = 0;
	RegistrationWpChangeTableObj.pRegistrationTable = ChangeWpCallBackTable;
	RegistrationWpChangeTableObj.tableMaxSize = REG_CHANGE_WP_TABLE_SIZE;

	Registration11bChangeTableObj.numOfElementInTable = 0;
	Registration11bChangeTableObj.pRegistrationTable = Switch11BCallBackTable;
	Registration11bChangeTableObj.tableMaxSize = REG_SWITCH_11B_TABLE_SIZE;

	RegistrationEventsTableObjArr[WORKING_POINT_CHANGED] = &RegistrationWpChangeTableObj;
	RegistrationEventsTableObjArr[SWITCH_11B] = &Registration11bChangeTableObj;
	
	memset (ChangeWpCallBackTable, 0, REG_CHANGE_WP_TABLE_SIZE*sizeof(LaRegistrationTable_t));
	memset (ChangeWpCallBackTable, 0, REG_SWITCH_11B_TABLE_SIZE*sizeof(LaRegistrationTable_t));
}

/**********************************************************************************
linkAdaptationEventRegistrationReq



Description:
------------
Function handle the registration request.
Registration request written to the corresponding table according to the event
Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/

static void linkAdaptationEventRegistrationReq(K_MSG *psMsg)
{
	LaRegistrationReqParams_t* regsParams = (LaRegistrationReqParams_t*)pK_MSG_DATA(psMsg);
	LaRegistrationTableObj_t* pRegistrationEventTableObj = NULL;
	uint8* pNumOfElementInTable = NULL;
	uint8 registrationiTableMaxSize = 0;

	/*Get the pointer to the corresponding table according to the event*/
	pRegistrationEventTableObj = RegistrationEventsTableObjArr[regsParams->event];

	pNumOfElementInTable = &(pRegistrationEventTableObj->numOfElementInTable);
	registrationiTableMaxSize = pRegistrationEventTableObj->tableMaxSize;

	DEBUG_ASSERT((*pNumOfElementInTable) <= registrationiTableMaxSize);

	/*Write registration parameters to table*/
	pRegistrationEventTableObj->pRegistrationTable->taskId = psMsg->header.sFrom.taskID;
	pRegistrationEventTableObj->pRegistrationTable->cbMsgId = regsParams->cbMsgId;
	pRegistrationEventTableObj->pRegistrationTable->imidiateCb = regsParams->imidiateCb;
	pRegistrationEventTableObj->pRegistrationTable->coreType = regsParams->coreType;

	(*pNumOfElementInTable)++;
	
}


/**********************************************************************************
linkAdaptationEventRegistrationReq

Description:
------------
Send event indication

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/

void linkAdaptationRegistrationSendEventInd(LaRegistrationEvent_e registrationEvent, LaRgistrationGeneralCbParams_t* pGenCbParams)
{
	const LaRegistrationTableObj_t* pRegistrationEventTable = NULL;
	uint8 numOfElementsInTable;
	uint8 currentRegsEntry = 0;
	LaRegistrationTable_t* pRegistrationTable = NULL;
	LaRgistrationGeneralCbParams_t* pIndicationCbParams = NULL;
	K_MSG*	pIndMsg =  NULL;

	/*Get the pointer to the corresponding table according to the event*/
	pRegistrationEventTable = RegistrationEventsTableObjArr[registrationEvent];

	numOfElementsInTable = pRegistrationEventTable->numOfElementInTable;
	pRegistrationTable = pRegistrationEventTable->pRegistrationTable;

	//("linkAdaptationRegistrationSendEventInd :Event = %d", registrationEvent);
	//(0, 0, LaRgistrationGeneralCbParams_t, pGenCbParams);
	
	/*Run over all the elements and send indications*/
	while ((currentRegsEntry < numOfElementsInTable) )
	{	
		/*Send message */		
		pIndMsg = OSAL_GET_MESSAGE(sizeof(LaRgistrationGeneralCbParams_t));
		pIndicationCbParams = (LaRgistrationGeneralCbParams_t*)pK_MSG_DATA(pIndMsg);
		MEMCPY(pIndicationCbParams,pGenCbParams,sizeof(LaRgistrationGeneralCbParams_t));

		pIndMsg->header.tKMsgType = pRegistrationTable->cbMsgId;

		OSAL_SEND_MESSAGE(pIndMsg->header.tKMsgType,pRegistrationTable->taskId,pIndMsg, VAP_ID_DO_NOT_CARE);		
		
		currentRegsEntry++;
	}

}

#endif //LINK_ADAPTATION_REGISTRATION

/**********************************************************************************

linkAdaptationConfigurationParamsInit 


Description:
------------
Initiate Link adaptaion algorithm parameters

Input: 
-----

Returns:
--------
void - 
	
**********************************************************************************/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif
static void linkAdaptationConfigurationParamsInit(void)
{
	/*Station group parameters*/
	LinkAdaptationConfigParamsSteadyState.maxValidFilterTsfDiff = FILTER_VALIDATION_TIME;

	LinkAdaptationConfigParamsSteadyState.targetPer = TARGET_PER;
	LinkAdaptationConfigParamsSteadyState.targetPerMargin = TARGET_PER_MARGIN;
	/*Ln 2 value used for beta calculation in alpha filter the number is 16 bit with 11 bit fraction*/
	LinkAdaptationConfigParamsSteadyState.lnBeta = ADAPTIVE_FILTER_LN_BETA_VAL;
	LinkAdaptationConfigParamsSteadyState.constAlphaCoefForDtAvPower2 = CONST_ALPHA_FILTER_FOR_DT_AVERAGE;

	/*mod will be shift of ESTIMATORS_REF_LEN_CONST_SHIFT_MOD_PARAM + ESTIMATORS_REF_LEN_CONFIGURABLE_SHIFT_MOD_PARAM*/
	/*Parameter use for calculate ref len success and ref len failure*/
	LinkAdaptationConfigParamsSteadyState.refLenFactor = REF_LEN_FACTOR;

	LinkAdaptationConfigParamsSteadyState.workingPointChangeTpPercentMargin = WORKING_POINT_CHANGE_TP_PERCENT_MARGIN;
	LinkAdaptationConfigParamsSteadyState.fastProbingValidationTh = FAST_PROBING_VALIDATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingValidationTh = SLOW_PROBING_VALIDATION_TH;
	
	LinkAdaptationConfigParamsSteadyState.defaultRaStabilityState = DEFAULT_RA_STABILITY_STATE;

	/*How many tries state will be tried before increasing the K threshold*/
	LinkAdaptationConfigParamsSteadyState.fastProbingTriesBeforeChangeKTh = FAST_PROBING_TRIES_BEFORE_CHANGE_K;

	/*MPDU Tx report event default value of  fast probing k th  - threshold = 2^Kth*/
	LinkAdaptationConfigParamsSteadyState.mpduCountersThresholds.fastProbingThK = MPDU_COUNTERS_FAST_PROBING_INIT_K_TH;

	/*MPDU Tx report event default value of general slow probing k th  - threshold = 2^Kth*/
	LinkAdaptationConfigParamsSteadyState.mpduEventSlowProbingKThInit = MPDU_COUNTERS_SLOW_PROBING_INIT_K_TH;

	/*MPDU Tx report default K value for slow probing specific priority - threshold = 2^Kth*/
	LinkAdaptationConfigParamsSteadyState.mpduCountersThresholds.slowProbingPriorityKThArr[SLOW_PROBING_PRIORITY0] = MPDU_COUNTERS_SLOW_PROBING_PRIORITY0_INIT_K_TH;
	LinkAdaptationConfigParamsSteadyState.mpduCountersThresholds.slowProbingPriorityKThArr[SLOW_PROBING_PRIORITY1] = MPDU_COUNTERS_SLOW_PROBING_PRIORITY1_INIT_K_TH;

	/*Timer event default value of  fast probing k th  - threshold = 2^Kth*/
	LinkAdaptationConfigParamsSteadyState.timerEventCountersThresholds.fastProbingThK = TIMER_EVENT_COUNTERS_FAST_PROBING_INIT_K_TH;
	/*Timer event default value of general slow probing k th - threshold = 2^Kth*/
	LinkAdaptationConfigParamsSteadyState.timerEventSlowProbingKThInit = TIMER_EVENT_COUNTERS_SLOW_PROBING_INIT_K_TH;

	/*Timer event default K value for slow probing specific priority - threshold = 2^Kth*/
	LinkAdaptationConfigParamsSteadyState.timerEventCountersThresholds.slowProbingPriorityKThArr[SLOW_PROBING_PRIORITY0] = TIMER_EVENT_COUNTERS_SLOW_PROBING_PRIORITY0_INIT_K_TH;
	LinkAdaptationConfigParamsSteadyState.timerEventCountersThresholds.slowProbingPriorityKThArr[SLOW_PROBING_PRIORITY1] = TIMER_EVENT_COUNTERS_SLOW_PROBING_PRIORITY1_INIT_K_TH;

	/*LOG2(slow probing max frequency of the maximum slow probing priority) relative to MPDU tx report event*/
	//LOG2(slow probing max frequency of the maximum slow probing priority) relative to probing timer event
	LinkAdaptationConfigParamsSteadyState.managementRateOffset = MANGEMENT_RATE_OFFSET;

	LinkAdaptationConfigParamsSteadyState.powerConfigurationParams.staInternalLowerLimit = INTERNAL_LIMIT_AUTO_VAL;
	LinkAdaptationConfigParamsSteadyState.powerConfigurationParams.powerStepDown = POWER_STEP_DOWN;
	LinkAdaptationConfigParamsSteadyState.powerConfigurationParams.powerStepDownDefault = POWER_STEP_DOWN;
	LinkAdaptationConfigParamsSteadyState.powerConfigurationParams.powerStepUp = POWER_STEP_UP;
	LinkAdaptationConfigParamsSteadyState.powerConfigurationParams.powerStepUpDefault = POWER_STEP_UP;
	LinkAdaptationConfigParamsSteadyState.powerConfigurationParams.powerAdditionalPowerStep = POWER_ADDITIONAL_PROBING_STEP;
	LinkAdaptationConfigParamsSteadyState.powerConfigurationParams.powerMaxAdditionalPowerStep = POWER_MAX_ADDITIONAL_PROBING_STEP;

	LinkAdaptationConfigParamsSteadyState.averageDeltaTWorkingPoint = AVERAGE_TSF_512USEC_UNIT_LOG2;
	LinkAdaptationConfigParamsSteadyState.slowProbingWithHigherRateLowPerTh = SLOW_PROBING_WITH_HIGHER_RATE_LOW_PER_TH;
	LinkAdaptationConfigParamsSteadyState.linkAdaptationStateTo = RATE_ADAPTATION_STATE_TO;
	LinkAdaptationConfigParamsSteadyState.bfChangeExplicitToNonExplicitTo = BF_CHANGE_EXPLICIT_TO_NON_EXPLICIT_TO;
	LinkAdaptationConfigParamsSteadyState.bfNumOfPacketTransInCurrentState = BF_NUMBER_OF_PACKET_SENT_IN_NON_EXPL_STATE;
	LinkAdaptationConfigParamsSteadyState.slowProbingInterleavingLog2Val = SLOW_PROBING_INTERLEAVING_LOG2_VAL;
	LinkAdaptationConfigParamsSteadyState.powerAdaptationLowerPowerPerMargin = POWER_ADAPTATION_LOWER_POWER_PER_MARGIN; 
	LinkAdaptationConfigParamsSteadyState.higherBwOffsetRate = HIGHER_BW_OFFSET_RATE; 
	LinkAdaptationConfigParamsSteadyState.suProbingValidationTh = SU_PROBING_THR; 
	LinkAdaptationConfigParamsSteadyState.muPreliminaryProbingTh = MU_PRELIMINARY_PROBING_THR;
	LinkAdaptationConfigParamsSteadyState.collisionDetectionTh = COLLISION_DETECTION_MIN_TH;

	/* Protection configuration*/	
	LinkAdaptationConfigParamsSteadyState.protectionConf.staCollisionForceModeNegativeThreshold = DEFAULT_PROTECTION_STA_FORCE_MODE_NEGATIVE_THRESHOLD;
	LinkAdaptationConfigParamsSteadyState.protectionConf.staCollisionNoProtPositiveThreshold = DEFAULT_PROTECTION_STA_NONE_MODE_POSITIVE_THRESHOLD;
	LinkAdaptationConfigParamsSteadyState.protectionConf.staCollisionThresholdModeNegativeThreshold = DEFAULT_PROTECTION_STA_THRESHOLD_MODE_NGATIVE_THRESHOLD;
	LinkAdaptationConfigParamsSteadyState.protectionConf.staCollisionThresholdModePsotiveThreshold = DEFAULT_PROTECTION_STA_THRESHOLD_MODE_POSITIVE_THRESHOLD;
	LinkAdaptationConfigParamsSteadyState.protectionConf.staCollisionBetterThanVapThreshold = DEFAULT_PROTECTION_STA_BETTER_THAN_VAP_THRESHOLD; 

	/*Slow probing handling parameters*/
	LinkAdaptationConfigParamsSteadyState.slowProbingMaxNumOfIterations[SLOW_PROBING_POWER] = SLOW_PROBING_POWER_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingMaxNumOfIterations[SLOW_PROBING_BW] = SLOW_PROBING_BW_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingMaxNumOfIterations[SLOW_PROBING_CP] = SLOW_PROBING_CP_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingMaxNumOfIterations[SLOW_PROBING_BF] = SLOW_PROBING_BF_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingMaxNumOfIterations[SLOW_PROBING_CDD] = SLOW_PROBING_CDD_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingMaxNumOfIterations[SLOW_PROBING_ANT_SEL] = SLOW_PROBING_ANT_SEL_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingMaxNumOfIterations[SLOW_PROBING_TURBO_RATES] = SLOW_PROBING_TURBO_RATES_ITERATION_TH;

	LinkAdaptationConfigParamsSteadyState.maxSlowProbingIterationsPerCyclePr0 = MAX_SLOW_PROBING_ITERATIONS_PER_CYCLE_PR0;
	LinkAdaptationConfigParamsSteadyState.maxSlowProbingIterationsPerCyclePr1 = MAX_SLOW_PROBING_ITERATIONS_PER_CYCLE_PR1;

	LinkAdaptationConfigParamsSteadyState.slowProbingNonEffectiveLoopTh[SLOW_PROBING_POWER] =SLOW_PROBING_NON_EFFECTIVE_POWER_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingNonEffectiveLoopTh[SLOW_PROBING_BW] = SLOW_PROBING_NON_EFFECTIVE_BW_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingNonEffectiveLoopTh[SLOW_PROBING_CP] = SLOW_PROBING_NON_EFFECTIVE_CP_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingNonEffectiveLoopTh[SLOW_PROBING_BF] = SLOW_PROBING_NON_EFFECTIVE_BF_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingNonEffectiveLoopTh[SLOW_PROBING_CDD] = SLOW_PROBING_NON_EFFECTIVE_CDD_ITERATION_TH;
	LinkAdaptationConfigParamsSteadyState.slowProbingNonEffectiveLoopTh[SLOW_PROBING_TURBO_RATES] = SLOW_PROBING_NON_EFFECTIVE_TURBO_RATES_ITERATION_TH;

	/*Common conifguration*/
	LinkAdaptationCommonConfiguration.fastProbingTimerEventIntervalUsec = FAST_PROBING_TIMER_EVENT_VAL_USEC;
	LinkAdaptationCommonConfiguration.estimatorsAgingTimeUsec = LINK_ADAPTATION_FILTERS_AGING_TIME_USEC;
	LinkAdaptationCommonConfiguration.wlanBandwidthMax = BANDWIDTH_TWENTY;
	LinkAdaptationCommonConfiguration.bfRequestInterval = EXPLICIT_BF_REQUEST_INTERVAL;	
	LinkAdaptationCommonConfiguration.band = BAND_2_4_GHZ;	

	/*Set fast init stage configuration paramers*/
	MEMCPY(&LinkAdaptationConfigParamsFastInit, &LinkAdaptationConfigParamsSteadyState, sizeof(LinkAdaptationConfigurationParams_t));
 	LinkAdaptationConfigParamsFastInit.mpduCountersThresholds.fastProbingThK = MPDU_COUNTERS_FAST_PROBING_INIT_K_TH_FAST_INIT_STAGE;
	LinkAdaptationConfigParamsFastInit.fastProbingValidationTh = FAST_PROBING_VALIDATION_TH_FAST_INIT_STAGE;
 	LinkAdaptationConfigParamsFastInit.timerEventCountersThresholds.fastProbingThK = TIMER_EVENT_COUNTERS_FAST_PROBING_INIT_K_TH_FAST_INIT_STAGE;
 	LinkAdaptationConfigParamsFastInit.timerEventSlowProbingKThInit = TIMER_EVENT_COUNTERS_SLOW_PROBING_INIT_K_TH_FAST_INIT_STAGE;


	
}
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif

/**********************************************************************************

setLinkAdaptationRatesMask 


Description:
------------
Initiate Link adaptaion algorithm parameters

Input: 
-----

Returns:
--------
void - 
	
**********************************************************************************/
static void setLinkAdaptationRatesMask(UMI_STA_ADD *pAddSta)
{
	StaId stationIndex =  pAddSta->u16SID;
	uint8 physicalAntNum = 0;
	LinkAdaptationStaDatabase_t* pLinkAdaptationDb = &LinkAdaptationStaDatabase[stationIndex];
	VHTMcsNssSet_t* pVhtMcsNssSet = (VHTMcsNssSet_t*)pAddSta->u8VHT_Mcs_Nss;
	LmStaDbSwInfo_t* pLmStaDbSwinfo = &StaDbSwEntries[stationIndex];
#ifdef ENET_INC_ARCH_WAVE600
	HE_MCS_SUPPORT* pHeMcsNssSet = (HE_MCS_SUPPORT*)pAddSta->u8HE_Mcs_Nss;
#endif
	RateMask_t* disableNssMaskArr = disableHtVhtNssMaskAccordingtoAntNum;
#ifdef BEEROCK_DEBUG
	ILOG0_D("[setLinkAdaptationRatesMask], pLmStaDbSwinfo->supportedRates = %d",pLmStaDbSwinfo->supportedRates);
#endif
	pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[0] = pLmStaDbSwinfo->supportedRates;
	pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[1] = 0;

	/* Set rates table to htVht table. if it's a HE station, it will be overridden */
	LinkAdaptationStaDatabase[stationIndex].laStaUspCommon.pRatesTablesDb = &htVhtRatesTablesDb;
	
#ifdef ENET_INC_ARCH_WAVE600
	if (MTLK_BFIELD_GET(pAddSta->u8FlagsExt, STA_ADD_FLAGS_EXT_IS_HE) == TRUE)
	{		
		SLOG0(0, 0, HE_MCS_SUPPORT, pHeMcsNssSet);
		LinkAdaptationStaDatabase[stationIndex].laStaUspCommon.pRatesTablesDb = &heRatesTablesDb;
		/*Set HE rates */
		setHeRatesInMask(pHeMcsNssSet, &pLinkAdaptationDb->laStaUspCommon.raIndexMask);
		pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.heSta = TRUE;
		/*If station support N / AC we dont want to change to 11A/G rates*/
		pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[0] &= (~LM_PHY_11A_RATE_MSK);//Remove
		disableNssMaskArr = disableHeNssMaskAccordingtoAntNum;
	}
	else 
#endif
	if (MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_VHT) == TRUE) // ToDO add: && network mode support VHT
	{
		/*Set VHT rates*/
		setVhtRatesInMask(pVhtMcsNssSet->rxVhtMcsMap, &pLinkAdaptationDb->laStaUspCommon.raIndexMask);
		pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.vhtSta = TRUE;
		/*If station support N / AC we dont want to change to 11A/G rates*/
		pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[0] &= (~LM_PHY_11A_RATE_MSK);//Remove
	}
	else if(MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_HT) == TRUE)
	{
		/*Set HT rates*/
		setHtRatesInMask(&pAddSta->u8RX_MCS_Bitmask[0], &pLinkAdaptationDb->laStaUspCommon.raIndexMask);
		/*If station support 11n / ac we dont want to change to 11A/G rates*/
		pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[0] &= (~LM_PHY_11A_RATE_MSK);//Remove
	}
	
	// update original ratemask and current rate mask according to physical number of antennas
	physicalAntNum = AntennaSelectionCalcAntennaCount(AntennaSelection_GetConnectedAntennasBitmap());
	andOperator64Bit(pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit,disableNssMaskArr[physicalAntNum-1].raIndexMask64bit,pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit);
	MEMCPY(&pLinkAdaptationDb->laStaUspCommon.raIndexMaskOrg, &pLinkAdaptationDb->laStaUspCommon.raIndexMask, sizeof(RateMask_t));
#ifdef DYNAMIC_GROUPING_DEBUG
    SLOG0(0, 0, RateMask_t, &(pLinkAdaptationDb->laStaUspCommon.raIndexMask));
#endif
#ifdef BEEROCK_DEBUG
	ILOG0_D("[setLinkAdaptationRatesMask] pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[0] = 0x%x",pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[0]);
	ILOG0_D("[setLinkAdaptationRatesMask] pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[1] = 0x%x",pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[1]);
#endif
}

/**********************************************************************************

setLinkAdaptationMuGroupRatesMask 


Description:
------------
Initiate Link adaptaion algorithm parameters

Input: 
-----

Returns:
--------
void - 
	
**********************************************************************************/
static void setLinkAdaptationMuUspRatesMask(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, RateMask_t* pRaIndexMask, uint8 maxNss, PreAggRuSizeMapping_e ruSize)
{
	RateMask_t* disableNssMaskArr = disableHtVhtNssMaskAccordingtoAntNum;
	RateMask_t rateMaskZero11bRates = LA_PHY_ZERO_11B_RATES_MASK;

#ifdef ENET_INC_ARCH_WAVE600
	if (laDbDistributionParameter->laStaUspCommon->staTransmissionParams.heSta == TRUE)
	{
		disableNssMaskArr = disableHeNssMaskAccordingtoAntNum;
	}
#endif
	andOperator64Bit(pRaIndexMask->raIndexMask64bit,disableNssMaskArr[maxNss].raIndexMask64bit,laDbDistributionParameter->laStaUspCommon->raIndexMask.raIndexMask64bit);
	andOperator64Bit(pRaIndexMask->raIndexMask64bit,disableNssMaskArr[maxNss].raIndexMask64bit,laDbDistributionParameter->laStaUspCommon->raIndexMaskOrg.raIndexMask64bit);

	/*Mask out 11B rates -> it is not supported in MU groups*/
	andOperator64Bit(laDbDistributionParameter->laStaUspCommon->raIndexMask.raIndexMask64bit,rateMaskZero11bRates.raIndexMask64bit,laDbDistributionParameter->laStaUspCommon->raIndexMask.raIndexMask64bit);
	andOperator64Bit(laDbDistributionParameter->laStaUspCommon->raIndexMaskOrg.raIndexMask64bit,rateMaskZero11bRates.raIndexMask64bit,laDbDistributionParameter->laStaUspCommon->raIndexMaskOrg.raIndexMask64bit);

#ifdef WORKAROUND_FOR_PHY_BUG_IN_LDPC
	/*Mask out non valid phy rates - Due to phy bug in A0 there are some non valid combination of RU size, MCS, NSS and psdu length in LDPC transmission - WLANVLSIIP-3823*/
	andOperator64Bit(laDbDistributionParameter->laStaUspCommon->raIndexMask.raIndexMask64bit,enableHeRatesSupportedByPhyInMask[ruSize].raIndexMask64bit,laDbDistributionParameter->laStaUspCommon->raIndexMask.raIndexMask64bit);
	andOperator64Bit(laDbDistributionParameter->laStaUspCommon->raIndexMaskOrg.raIndexMask64bit,enableHeRatesSupportedByPhyInMask[ruSize].raIndexMask64bit,laDbDistributionParameter->laStaUspCommon->raIndexMaskOrg.raIndexMask64bit);
#else
    UNUSED_PARAM(ruSize);
#endif

	clearUnsupportedLowRatesFromHeMuUspRateMask(laDbDistributionParameter);
	clearUnsupportedHighRatesFromHeMuUspRateMask(laDbDistributionParameter);
}

/****************************************************************************
**
** NAME:        setHtRatesInMask
**
** Parameters:  
**
** Returns:     None
**
** Description: 
**
****************************************************************************/
 static void setHtRatesInMask(uint8* staMcsSetBitmaskVector, RateMask_t* staHtMask)
{
	uint32 tempSupportedMcsSet0 = 0;
	uint32 tempSupportedMcsSet1= 0;
	uint8 ieBitIndex = 0;
	uint8 raBitIndex = LM_PHY_11N_RATE_6_5;

	//Read MCS rates:
	MEMCPY(&tempSupportedMcsSet0, &(staMcsSetBitmaskVector[0]), sizeof(uint32));
	MEMCPY(&tempSupportedMcsSet1, &(staMcsSetBitmaskVector[4]), sizeof(uint32)); 

	while (	tempSupportedMcsSet0 != 0)
	{
		if ((1 << ieBitIndex) & tempSupportedMcsSet0)
		{
			LA_SET_BIT_IN_BITMAP(staHtMask->raIndexMask64bit,raBitIndex, RATES_BIT_MASK_SIZE); //KW_FIX_FW_G Added array bound check
			tempSupportedMcsSet0 &= (~(1<<ieBitIndex));
		}
		ieBitIndex++;

		if ((ieBitIndex & 0x7) == 0)
		{
		/*Every 8 indexes, skip 2 VHT rates in mask*/
			raBitIndex+=3;
		}
		else
		{
			raBitIndex++;
		}
	}
	/*ToDo: add MCS 32*/
}
/****************************************************************************
**
** NAME:        setVhtRatesInMask
**
** Parameters:  
**
** Returns:     None
**
** Description: 
**
****************************************************************************/
static void setVhtRatesInMask(uint16 txVhtMcsMap, RateMask_t* staHtMask)
{
	uint8 nss = 0;
	uint8 ieVhtMaxMCS = SPATIAL_STREAMS_NOT_SUPPORTED;
	uint8 rateIndex =0;
	uint8 maxMcsNssRateIndex = 0;
	uint8 minMcsNssRateIndex = 0;
	uint8 maxMcs = 0;


	for (nss = 0 ; nss < VHT_HE_NUMBER_OF_NSS ; nss++)
	{
		// Take 2 bits for this NSS
		ieVhtMaxMCS = ((txVhtMcsMap >> (MAX_VHT_MCS_FOR_SS_NUM_OF_BITS * nss)) & MAX_VHT_MCS_FOR_SS_MASK);	
		if (ieVhtMaxMCS != SPATIAL_STREAMS_NOT_SUPPORTED)
		{
			// Get MAX MCS for this NSS (0=MCS7 / 1=MCS8 / 2=MCS9)
			maxMcs = ieVhtMaxMCS + IE_MAX_VHT_MCS_TO_MCS_VALUE_OFFSET;
			
			// Get the RA INDEX of the highest and lowest MCS in this NSS
			maxMcsNssRateIndex = vhtTcr2RateIndex[maxMcs][nss]; 
			minMcsNssRateIndex = vhtTcr2RateIndex[0][nss]; 

			// set the bits for all MCSs between 0 and MaxMCS for this NSS
			for (rateIndex = minMcsNssRateIndex ; rateIndex <= maxMcsNssRateIndex ; rateIndex++)
			{
				LA_SET_BIT_IN_BITMAP(staHtMask->raIndexMask64bit,rateIndex, RATES_BIT_MASK_SIZE); //KW_FIX_FW_G Added array bound check
			}
		}
	}
}
#ifdef ENET_INC_ARCH_WAVE600
/****************************************************************************
**
** NAME:        setHeRatesInMask
**
** Parameters:  
**
** Returns:     None
**
** Description: 
**
****************************************************************************/
static void setHeRatesInMask(HE_MCS_SUPPORT* heMcsNss, RateMask_t* staMask)
{
	uint8 nss;
	uint8 ieHeMaxMCS[SPATIAL_STREAM_NUM];
	uint8 rateIndex =0;
	uint8 maxMcsNssRateIndex = 0;
	uint8 minMcsNssRateIndex = 0;
	uint8 maxMcs = 0;

	/* TBD - different mask should be defined for 160 MHz and <= 80 MHz.*/
	ieHeMaxMCS[0] = heMcsNss->rx_max_mcs_less_or_equal_80_MHz_1_NSS;	
	ieHeMaxMCS[1] = heMcsNss->rx_max_mcs_less_or_equal_80_MHz_2_NSS;
	ieHeMaxMCS[2] = heMcsNss->rx_max_mcs_less_or_equal_80_MHz_3_NSS;	
	ieHeMaxMCS[3] = heMcsNss->rx_max_mcs_less_or_equal_80_MHz_4_NSS;

	for (nss = 0; nss < SPATIAL_STREAM_NUM; nss++)
	{
		if (ieHeMaxMCS[nss] != SPATIAL_STREAMS_NOT_SUPPORTED)
		{
			// Get MAX MCS for this NSS (0=MCS7 / 1=MCS9 / 2=MCS11)
			maxMcs = (2 * ieHeMaxMCS[nss]) + IE_MAX_HE_MCS_TO_MCS_VALUE_OFFSET;
			
			// Get the RA INDEX of the highest and lowest MCS in this NSS
			maxMcsNssRateIndex = heTcr2RateIndex[maxMcs][nss]; 
			minMcsNssRateIndex = heTcr2RateIndex[MCS_0][nss]; 
		
			// set the bits for all MCSs between 0 and MaxMCS for this NSS
			for (rateIndex = minMcsNssRateIndex ; rateIndex <= maxMcsNssRateIndex ; rateIndex++)
			{
				LA_SET_BIT_IN_BITMAP(staMask->raIndexMask64bit,rateIndex, RATES_BIT_MASK_SIZE); //KW_FIX_FW_G Added array bound check
			}
		}
	}
}
#endif
/****************************************************************************
 **
 ** NAME:        andOperator64Bit
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION:
 **              
 **
 **   
 ***************************************************************************/
uint32  andOperator64Bit (uint32* inputA, uint32* inputB, uint32* result)
{
//	DBASSERT((sizeof(inputA) == sizeof(inputB)) && (sizeof(inputB)== sizeof(result)) && ((sizeof result)== (sizeInWords<<2)));
	uint32  compressedResult = 0;
	uint32 tempResult[2] = {0};

	tempResult[0] = inputA[0] & inputB[0];
	tempResult[1] = inputA[1] & inputB[1];
	result[0] = tempResult[0];
	result[1] = tempResult[1];

	compressedResult = (result[0] | result[1]);	
	//ILOG0_DD("andOperator64Bit,result=%x-%x", result[1], result[0]);
	return compressedResult;
}

/****************************************************************************
 **
 ** NAME:        xorOperator64Bit
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION:
 **              
 **
 **   
 ***************************************************************************/
void xorOperator64Bit(uint32* inputA, uint32* inputB, uint32* result)
{
		//	DBASSERT((sizeof(inputA) == sizeof(inputB)) && (sizeof(inputB)== sizeof(result)) && ((sizeof result)== (sizeInWords<<2)));
		uint32 tempResult[2] = {0};
		
		tempResult[0] = inputA[0] ^ inputB[0];
		tempResult[1] = inputA[1] ^ inputB[1];
		result[0] = tempResult[0];
		result[1] = tempResult[1];
}
/****************************************************************************
**
** NAME:        getHighestRateinMask
**
** Parameters:  
**
** Returns:     None
**
** Description: 
**
 *****************************************************************************/
uint8 getHighestRateinMask(StaId staIndex, RateMask_t rateMask, Bandwidth_e bandwidth, uint8 minRateSortIndex, uint8 maxRateSortIndex)
{
	uint8 sortRateIdx;
	uint8 rateIndex = 0;
	RateMask_t bandwidthRaMask;
	uint8 retVal = INVALID_RATE_INDEX_VAL;
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 
	const uint8* sortedRatesTable = htVhtSortPhyRateToRateIndexSameBw;
	uint8 maxNumberOfRates = NUMBER_OF_ALL_RATES_HT_VHT;

	
	if (staIndex != INVALID_STA_INDEX)
	{
#ifndef ENET_INC_ARCH_WAVE600
		ASSERT(staIndex < HW_NUM_OF_STATIONS); //KW_FIX_FW_G
#endif
		// STA (not VAP)
		sortedRatesTable = getSortedRatesTable(&LinkAdaptationStaDatabase[staIndex].laStaUspCommon);
		maxNumberOfRates =  getMaxNumOfRatesInTable(&LinkAdaptationStaDatabase[staIndex].laStaUspCommon);

	}

	updateLaDbDistributionParam(&laDbDistributionParameter,staIndex,INVALID_MU_USP_INDEX, FALSE);	

	getStaRateMaskPerBw(&laDbDistributionParameter, bandwidth, rateMask, &bandwidthRaMask, FALSE);
	/*Set turbo rates in local raMask*/
	if( (laDbDistributionParameter.laStaUspCommon != NULL)&& (FALSE == laDbDistributionParameter.laStaUspCommon->staTransmissionParams.heSta))
	{
		/*Turbo rates is not relevant for he stations or VAP*/
		TurboRatesGetBitmap(staIndex, INVALID_MU_USP_INDEX,  bandwidth,&bandwidthRaMask);
	}
	// scan rates from highest to lowest and look for the first one that is set.
    for( sortRateIdx = maxRateSortIndex; (sortRateIdx >= minRateSortIndex) && (sortRateIdx < maxNumberOfRates); sortRateIdx--)
    {
        rateIndex = sortedRatesTable[ sortRateIdx ];
		if( isBitInMask64Bit(rateIndex, bandwidthRaMask.raIndexMask64bit))
        {
			/*If bit is in bit mask of valid bw and station supported rates, break*/
        	retVal = rateIndex;
			break;
        }
    }
	ASSERT(retVal!=INVALID_RATE_INDEX_VAL);

	return retVal;
}

/****************************************************************************
**
** NAME:        getLowestRateinMask
**
** Parameters:  
**
** Returns:     None
**
** Description: 
**
 *****************************************************************************/
uint8 getLowestRateinMask(StaId staIndex, RateMask_t rateMask, Bandwidth_e bandwidth, uint8 minRateSortIndex, uint8 maxRateSortIndex)
{
	uint8 sortRateIdx;
	uint8 rateIndex = 0;
	RateMask_t bandwidthRaMask;
	uint8 retVal = INVALID_RATE_INDEX_VAL;
	const uint8* sortedRatesTable = htVhtSortPhyRateToRateIndexSameBw;
	uint8 maxNumberOfRates = NUMBER_OF_ALL_RATES_HT_VHT;
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 

	updateLaDbDistributionParam(&laDbDistributionParameter,staIndex,INVALID_MU_USP_INDEX, FALSE);	

	if (staIndex != INVALID_STA_INDEX)
	{
#ifndef ENET_INC_ARCH_WAVE600
		ASSERT(staIndex < HW_NUM_OF_STATIONS); //KW_FIX_FW_G
#endif
		// STA (not VAP)
		sortedRatesTable = getSortedRatesTable(&LinkAdaptationStaDatabase[staIndex].laStaUspCommon);
		maxNumberOfRates = getMaxNumOfRatesInTable(&LinkAdaptationStaDatabase[staIndex].laStaUspCommon);
	}

	getStaRateMaskPerBw(&laDbDistributionParameter, bandwidth, rateMask, &bandwidthRaMask, FALSE);
	/*Set turbo rates in local raMask*/
	if((laDbDistributionParameter.laStaUspCommon != NULL)&& (FALSE == laDbDistributionParameter.laStaUspCommon->staTransmissionParams.heSta))
	{
		/*Turbo rates is not relevant for he stations or VAP*/
		TurboRatesGetBitmap(staIndex, INVALID_MU_USP_INDEX,  bandwidth,&bandwidthRaMask);
	}
	// scan rates from highest to lowest and look for the first one that is set.
    for( sortRateIdx = minRateSortIndex; (sortRateIdx <= maxRateSortIndex) && (sortRateIdx < maxNumberOfRates); sortRateIdx++)
    {
        rateIndex = sortedRatesTable[ sortRateIdx ];
		if( isBitInMask64Bit(rateIndex, bandwidthRaMask.raIndexMask64bit))
        {
			/*If bit is in bit mask of valid bw and station supported rates, break*/
        	retVal = rateIndex;
			break;
        }
    }
	ASSERT(retVal!=INVALID_RATE_INDEX_VAL);

	return retVal;
}

/********************************************************************************
getTcrPhyModeAndRate



Description:
----------
Convert link adaptation rate index and phy mode to tcr rate and phy mode
State: 

Input:
-----
LinkAdaptationPhyMode_e laPhyMode
uint8 rateIndex

***input parameters to support fixed rate HE EXT and DCM, without additing it to LA adaptive mechanism (function should be modified after LA rate tables will support those components***
bool isHeExt
bool dcm


Output:
-------
PhyMode_e* outPhyMode
uint8* tcrRateVal
Bandwidth_e* bandwidth

Returns:
--------

********************************************************************************/
void getTcrPhyModeAndRate(const RateObj_t* ratesTable, bool isVhtSta, uint8 rateIndex, PhyMode_e* outPhyMode, uint8* tcrRateVal, bool isHeExt, bool dcm)
{
	LinkAdaptationPhyMode_e laPhyMode = ratesTable[rateIndex].laPhyMode;

	// When in QAMplus using rates of 256QAM in HT mode,packet will be handled as VHT when transmitted 
	if ( (ratesTable[rateIndex].vhtHeMcs == MCS8_256QAM_3_4) || (ratesTable[rateIndex].vhtHeMcs == MCS9_256QAM_5_6) )
	{
		isVhtSta = TRUE;
	}
#ifdef ENET_INC_ARCH_WAVE600
	if (laPhyMode == LA_PHY_MODE_HE)
	{
		/*HE station */

		/*For HE EXT there there is no value in table, since currently supported only from fixed rate config
		when ful feature would be supported through LA mechanism, need to remove this override logic and add all info to the rate tables*/
		if(isHeExt)
		{
			*outPhyMode = PHY_MODE_11AX_SU_EXT;
		}
		else
		{
			*outPhyMode = PHY_MODE_11AX_SU;
		}
		
		*tcrRateVal= RATE_PARAMS_TO_TCR_VAL_VHT_HE(ratesTable[rateIndex].vhtHeMcs,ratesTable[rateIndex].numberOfNss, dcm);		
	}
	else
#endif
	if ((laPhyMode == LA_PHY_MODE_HT_VHT) && (isVhtSta == TRUE))
	{
		/*VHT station HT-VHT rate*/
		*outPhyMode = PHY_MODE_11AC;
		*tcrRateVal= RATE_PARAMS_TO_TCR_VAL_VHT_HE(ratesTable[rateIndex].vhtHeMcs,ratesTable[rateIndex].numberOfNss, NO_DCM);
	}
	else if ((laPhyMode == LA_PHY_MODE_HT_VHT) && (isVhtSta == FALSE))
	{
		/*HT station */
		/*VHT station HT rate*/
		*outPhyMode = PHY_MODE_11N;
		*tcrRateVal = ratesTable[rateIndex].htMcs;
	}
	else
	{
		/*Legacy station */
		*outPhyMode = (PhyMode_e)ratesTable[rateIndex].laPhyMode;
		*tcrRateVal = ratesTable[rateIndex].htMcs;
	}
}
/**********************************************************************************
GetPsduMaxLengthLimit 

Description:
------------
Caculate the PsduMaxLengthLimit.  It is calculated by multiplying the max AMPDU size (according to HT/VHT station support)
by the max number of MPDUs in A-MPDU

Input:
-----
bool vhtStation - indicates if the station is a VHT station or not.
		
Output:
-------

Returns:
--------
	void  
	
**********************************************************************************/
uint32 getPsduMaxLengthLimit(uint8 maximumAmpdulengthExponent)
{
	uint32 length = 0x1;
	uint8  exponent = AMPDU_LENGTH_EXPONENT + maximumAmpdulengthExponent;
	
	length = (length << exponent) - 1; 

	// In HE, length must be smaller than 6,500,631
	length = MIN(length, HE_MAX_A_MPDU_SIZE);
	
	return length;
}

/**********************************************************************************
GetPsduMaxLengthLimit 

Description:
------------
Caculate the PsduMaxLengthLimit.  It is calculated by multiplying the max AMPDU size (according to HT/VHT station support)
by the max number of MPDUs in A-MPDU

Input:
-----
bool vhtStation - indicates if the station is a VHT station or not.
		
Output:
-------

Returns:
--------
	void  
	
**********************************************************************************/
uint32 getMpduMaxLengthLimit(bool vhtVap)
{
	uint32 length = 0;
	
	if (vhtVap)
	{
		length = MAX_VHT_MPDU_IN_A_MPDU_LENGTH_TX;
	}
	else
	{
		length = MAX_HT_MPDU_IN_A_MPDU_LENGTH_TX;
	}
	
	return length;
}
/**********************************************************************************
calculateMpduMaxLengthLimitVhtHe 

Description:
------------
Caculate the MPDU max length limit which is (2 ^ (13 + maximumAmpduLengthExponent) )  -1
maximumAmpduLengthExponent is an integer in the range 0 to 3.

Input:
-----
maximumAmpdulengthExponent - integer in the range 0 to 3.
		
Output:
-------

Returns:
--------
	void  
	
**********************************************************************************/
uint16 calculateMpduMaxLengthLimitVht(uint8 maxMpduSize)
{
	uint16 length = 0;

	switch (maxMpduSize)
	{
		case 0:
			length = MAX_MPDU_LENGTH_OPTION1_VHT;
			break;
		case 1:
			length = MAX_MPDU_LENGTH_OPTION2_VHT;
			break;
		case 2:
			length = MAX_MPDU_LENGTH_OPTION3_VHT;
			break;
		default:
			DEBUG_ASSERT(0);
	}

	
	length = MIN(maxMpduLenLimit, length); //  MPDU limitation might come from the driver
	return  length;
}
/**********************************************************************************
calculateMpduMaxLengthLimitHt 

Description:
------------
Caculate the MPDU max length limit which is (2 ^ (13 + maximumAmpduLengthExponent) )  -1
maximumAmpduLengthExponent is an integer in the range 0 to 3.

Input:
-----
maximumAmpdulengthExponent - integer in the range 0 to 3.
		
Output:
-------

Returns:
--------
	void  
	
**********************************************************************************/
uint16 calculateMpduMaxLengthLimitHt(uint8 maxMpduSize)
{
	uint16 length;

	if (maxMpduSize == 0)
	{
		length = MAX_MPDU_LENGTH_OPTION1_HT;
	}	
	else
	{
		length = MAX_MPDU_LENGTH_OPTION2_HT;
	}

	/* Limit MPDU size of HT station to prevent re-transmission attempt of VHT probing in HT mode (QAMPLUS feature) . Note: We do not build A-MSDU for legacy packet so this limitation will not limit us in legacy */
	length = MIN(MAX_HT_MPDU_IN_A_MPDU_LENGTH_TX, length);

	length = MIN(maxMpduLenLimit, length); // another MPDU limitation might come from the driver
	
	return  length;
}
/**********************************************************************************
setLdpcCapability 

Description:
------------
R

Input:
-----
bool           staLdpcCapability - Indicates if the station supports ldpc (taken from association data
PhyMode_e    phyMode - phy mode of the station
		
Output:
-------
Do we use ldpc or not.

Returns:
--------
	StaDbldpcConfig_e  
	
**********************************************************************************/
void setLdpcCapability(UMI_STA_ADD *pAddSta,LinkAdaptationStaDatabase_t* pLinkAdaptationDb)
{
	sHT_CAPABILITIES_INFO *htCapbilitiesInfo = (sHT_CAPABILITIES_INFO *)&pAddSta->u16HT_Cap_Info;
	sVHT_CAPABILITIES_INFO *vhtCapabilitiesInfo =(sVHT_CAPABILITIES_INFO *)&pAddSta->u32VHT_Cap_Info;
#ifdef ENET_INC_ARCH_WAVE600
	HE_MAC_PHY_CAPABILITIES_INFO *heMacPhyCapInfo = (HE_MAC_PHY_CAPABILITIES_INFO *)&pAddSta->u8HE_Mac_Phy_Cap_Info;
#endif //ENET_INC_ARCH_WAVE600

	StaDbldpcConfig_e ldpcValue;

#ifdef ENET_INC_ARCH_WAVE600
	if (MTLK_BFIELD_GET(pAddSta->u8FlagsExt, STA_ADD_FLAGS_EXT_IS_HE) == TRUE)
	{
		ldpcValue = (StaDbldpcConfig_e)heMacPhyCapInfo->hePhyCapInfo.HE_PHY_LDPC_CODING_IN_PAYLOAD;
	}
	else 
#endif //ENET_INC_ARCH_WAVE600
	if (MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_VHT) == TRUE)
	{
		ldpcValue = (StaDbldpcConfig_e)vhtCapabilitiesInfo->rx_ldpc;
	}
	else if (MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_HT) == TRUE)
	{
		ldpcValue = (StaDbldpcConfig_e)htCapbilitiesInfo->LDPC_coding_capability;
	}
	else
	{
		ldpcValue = CONVOLUTIONAL_CODING;
	}

	/* In case LDPC is not supported - disable use of MCS10-11 in bitmask to avoid potential errors */
	if(ldpcValue == CONVOLUTIONAL_CODING)
	{
		pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[0] &= (~LM_PHY_11AX_LOW_NSS_RATE_MSK);
		pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit[1] &= (~LM_PHY_11AX_HIGH_NSS_RATE_MSK);

		MEMCPY(&pLinkAdaptationDb->laStaUspCommon.raIndexMaskOrg, &pLinkAdaptationDb->laStaUspCommon.raIndexMask, sizeof(RateMask_t));
	}

	pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.staLdpcSupport = ldpcValue;
}

#ifdef ENET_INC_ARCH_WAVE600
static void setTfPaddingCapability(LinkAdaptationStaDatabase_t* pLinkAdaptationDb, uint8 tfPadding)
{
	pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.tfPadding = tfPadding;
}

uint8 getTfPaddingCapability(StaId staId)
{
	LinkAdaptationStaDatabase_t *pLinkAdaptationDb = &LinkAdaptationStaDatabase[staId];

	return pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.tfPadding;
}

#endif
/**********************************************************************************
setisWdsWep 

Description:
------------
check if STA is WDS WEP (WEP WDS can not support more then 460 Mbitsec. Need to reduce the rate).   


Input:
-----

		
Output:
-------

Returns:
--------
	StaDbldpcConfig_e  
	
**********************************************************************************/
void setIsWdsWep(UMI_STA_ADD *pAddSta,LinkAdaptationStaDatabase_t* pLinkAdaptationDb)
{
	
	//check if STA is WDS WEP (WEP WDS can not support more then 460 Mbitsec. Need to reduce the rate).   
	if ((MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_WDS) == 1) && 
		(MTLK_BFIELD_GET(pAddSta->u8Flags, STA_ADD_FLAGS_IS_8021X_FILTER_OPEN) == 0) && 
		pAddSta->u8WDS_client_type == PEER_AP)
	{		
		
		pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.isWdsWep = 1;
	}	
}

/**********************************************************************************
getisWdsWep 

Description:
------------
check if STA is WDS WEP (WEP WDS can not support more then 460 Mbitsec. Need to reduce the rate).   


Input:
-----

		
Output:
-------

Returns:
--------
	StaDbldpcConfig_e  
	
**********************************************************************************/

bool getIsWdsWep(StaId stationIndex,uint8 uspIndex, bool isHeGroup)
{
	bool isWdsWep = FALSE; 
	if(uspIndex == INVALID_MU_USP_INDEX)
	{
		
		if (stationIndex != INVALID_STA_INDEX)
		{
			LinkAdaptationStaDatabase_t* pLinkAdaptationDb;
#ifndef ENET_INC_ARCH_WAVE600
			ASSERT(stationIndex < HW_NUM_OF_STATIONS); //KW_FIX_FW_G
#endif
			pLinkAdaptationDb = &LinkAdaptationStaDatabase[stationIndex];

			isWdsWep =  pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.isWdsWep;
		}
	}
	else /*MU*/ 
	{
	 	if(linkAdaptationIsGroupActive(stationIndex,isHeGroup))
		{
#ifdef ENET_INC_ARCH_WAVE600
			if (isHeGroup)
			{
				ASSERT(uspIndex < MAX_USP_IN_HE_GROUP); //KW_FIX_FW_G
				isWdsWep = LinkAdaptationHePhaseDatabase[stationIndex].laStaUspCommon[uspIndex].staTransmissionParams.isWdsWep;
			}
			else
#endif
			{
				ASSERT(uspIndex < MAX_USP_IN_VHT_GROUP); //KW_FIX_FW_G
				isWdsWep = LinkAdaptationVhtGroupDatabase[stationIndex].laStaUspCommon[uspIndex].staTransmissionParams.isWdsWep;
			}
	 	}
	}
    //ILOG0_D("isWdsWep:%d",isWdsWep);
	return isWdsWep;
}


/**********************************************************************************
GetLdpc 

Description:
------------
Return if transmitions to the station will use ldpc according to the station phy mode and the stations association data

Input:
-----
bool           staLdpcCapability - Indicates if the station supports ldpc (taken from association data
PhyMode_e    phyMode - phy mode of the station
		
Output:
-------
Do we use ldpc or not.

Returns:
--------
	StaDbldpcConfig_e  
	
**********************************************************************************/
StaDbldpcConfig_e getLdpcCapability(StaId staIndex, LinkAdaptationPhyMode_e laPhyMode)
{
	LinkAdaptationStaDatabase_t *pLinkAdaptationDb = &LinkAdaptationStaDatabase[staIndex];
	StaDbldpcConfig_e ldpcValue;

	if ((laPhyMode != LA_PHY_MODE_11B) && (laPhyMode != LA_PHY_MODE_11AG)) 
	{
		ldpcValue = (StaDbldpcConfig_e)pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.staLdpcSupport;
	}
	else
	{
		ldpcValue = CONVOLUTIONAL_CODING;
	}

	return ldpcValue;
}
/**********************************************************************************
getStbcCapability 

Description:
------------
Return if transmitions to the station will use stbc according to the station phy mode and the stations association data

Input:
-----
bool 	   staStbcCapability- Indicates if the station supports stbc (taken from association data)
PhyMode_e    phyMode - phy mode of the station
		
Output:
-------
Do we use stbc or not.

Returns:
--------
	StaDbStbcConfig_e
	
**********************************************************************************/
StaDbStbcConfig_e getStbcCapability(bool StbcCapability, PhyMode_e phyMode)
{
	if ((phyMode == PHY_MODE_11AG) || (phyMode == PHY_MODE_11B)) 
	{
		return NOT_STBC_TRANSMISSION;
	}
	else
	{
		return (StaDbStbcConfig_e)StbcCapability; // station supports ldpc
	}
}


/********************************************************************************
convertTcr2RateIndex




Description:
----------

Input:
-----

Output:
-------

Returns:
--------

********************************************************************************/
uint8 convertTcr2RateIndex(PhyMode_e phyMode, uint8 tcrVal)
{
	uint8 rateIndex = 0;
	uint8 vhtHeNssVal;
	uint8 vhtHeMcsVal;
	uint8 htMcsVal;

	/*Extract rate index according to phy mode*/
	switch (phyMode)
	{
#ifdef ENET_INC_ARCH_WAVE600
	case 	PHY_MODE_11AX_SU:
	case	PHY_MODE_11AX_SU_EXT:
	case	PHY_MODE_11AX_MU_TRIG:
	case	PHY_MODE_11AX_MU_DL:
		vhtHeNssVal = EXTRACT_NSS_FROM_VHT_HE_RATE(tcrVal);
		vhtHeMcsVal = EXTRACT_MCS_FROM_VHT_HE_RATE(tcrVal);
		DEBUG_ASSERT((vhtHeMcsVal < HE_NUMBER_OF_MCS) && (vhtHeNssVal < VHT_HE_NUMBER_OF_NSS));
		rateIndex = heTcr2RateIndex[vhtHeMcsVal][vhtHeNssVal];
		break;
#endif
	case PHY_MODE_11AC:
		vhtHeNssVal = EXTRACT_NSS_FROM_VHT_HE_RATE(tcrVal);
		vhtHeMcsVal = EXTRACT_MCS_FROM_VHT_HE_RATE(tcrVal);
		DEBUG_ASSERT((vhtHeMcsVal < VHT_NUMBER_OF_MCS) && (vhtHeNssVal < VHT_HE_NUMBER_OF_NSS));
		rateIndex = vhtTcr2RateIndex[vhtHeMcsVal][vhtHeNssVal];
		break;
	case PHY_MODE_11N:
		htMcsVal = tcrVal;
		DEBUG_ASSERT(htMcsVal < HT_NUMBER_OF_MCS);
		rateIndex = htTcr2RateIndex[htMcsVal];
		break;
	case PHY_MODE_11B:
		if (tcrVal != PHY_11B_1M_MCS_INDEX)
		{
			tcrVal &= LA_PHY_11B_SHORT_PREAMBLE_RATE_MSK;
		}
		rateIndex = (tcrVal + PHY11B_TCR_TO_RATE_INDEX_OFFSET) ;
		break;	
	case PHY_MODE_11AG:
		rateIndex = tcrVal;
		break;	
	default:
		DEBUG_ASSERT(0);
	}

	return rateIndex;
}

/**********************************************************************************

searchMaxOverTable 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

int8 searchMaxOverTable (int8* pTable, uint8 tableLen)
{
	int8 maxValue = MIN_INT8;
	uint8 i;
	
	for(i = 0; i < tableLen; i++)
	{
		if (pTable[i] >= maxValue)
		{
			maxValue = pTable[i];
		}
	}
	
	return maxValue;
}
/**********************************************************************************

searchMaxOverTable 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

int8 searchMinOverTable (int8* pTable, uint8 tableLen)
{
	int8 minValue = MAX_INT8;
	uint8 i;

	for(i = 0; i < tableLen; i++)
	{
		if (pTable[i] <= minValue)
		{
			minValue = pTable[i];
		}
	}
	
	return minValue;
}
/**********************************************************************************

linkAdaptationSetPowerBoost 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationSetAntennaSelection(K_MSG *psMsg )
{
	LinkAdaptationFixedAntennaSelection_t* antennaSelectionParams = (LinkAdaptationFixedAntennaSelection_t*)pK_MSG_DATA(psMsg);
	uint8 enabledAntennaBitmap;
	uint8 antennaCount;
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter ;

	updateLaDbDistributionParam(&laDbDistributionParameter,antennaSelectionParams->stationId,INVALID_MU_USP_INDEX, FALSE);
	
	if (antennaSelectionParams->mode == MODIFY_CONNECTED_ANTENNA_MASK)
	{
		DEBUG_ASSERT((antennaSelectionParams->mask & 0xF0) == 0);
		enabledAntennaBitmap = AntennaSelectionConvertAntMaskToEnabledAnt(antennaSelectionParams->mask);
		AntennaSelectionSetAntennaConnected(enabledAntennaBitmap);
		AntennaSelectionSetEnabledAntMask(enabledAntennaBitmap);

	}
	else if (antennaSelectionParams->mode == MODIFY_ANTENNA_MASK)
	{
		DEBUG_ASSERT((antennaSelectionParams->mask & 0xF0) == 0);
		enabledAntennaBitmap = AntennaSelectionConvertAntMaskToEnabledAnt(antennaSelectionParams->mask);
		AntennaSelectionSetEnabledAntMask(enabledAntennaBitmap);
	}
	else if (antennaSelectionParams->mode == MODIFY_ANTENNA_SELECTION) // antennaSelectionParams->mode == MODIFY_ANTENNA_SELECTION
	{
		if (antennaSelectionParams->stationId !=INVALID_STA_INDEX)
		{
			// Disable loop
			ASSERT(antennaSelectionParams->stationId < HW_NUM_OF_STATIONS); //HW_FIX_FW_G
			rateAdaptationEnableDisableStaSlowLoop(antennaSelectionParams->stationId, SLOW_PROBING_ANT_SEL, DISABLE_LOOP);
			updateOverridePendingDb(OVERRIDE_ANTENNA_SELECTION, antennaSelectionParams->mask, &laDbDistributionParameter);
		}
		else if (antennaSelectionParams->vapId != INVALID_VAP)
		{
			AntennaSelectionSetVapAntSelMask(antennaSelectionParams->vapId, antennaSelectionParams->mask);
		}
	}
	else if (antennaSelectionParams->mode == SET_SMPS) 
	{
		ASSERT(antennaSelectionParams->stationId < HW_NUM_OF_STATIONS); //HW_FIX_FW_G
		if (StaDbSwEntries[antennaSelectionParams->stationId].state == STA_STATE_CONNECTED) 
		{
			DEBUG_ASSERT(antennaSelectionParams->stationId != INVALID_STA_INDEX);
			LinkAdaptationStaDatabase[antennaSelectionParams->stationId].laStaUspCommon.staTransmissionParams.staInSmpsStaticMode = TRUE;
			LinkAdaptationStaDatabase[antennaSelectionParams->stationId].laStationUnique.operatingModeNotification.staInOmn = FALSE;

			updateOverridePendingDb(OVERRIDE_NSS, LA_NSS_1, &laDbDistributionParameter); //set maximum 1 NSS
		}
		else
		{
			LinkAdaptationStaDatabase[antennaSelectionParams->stationId].laStaUspCommon.staTransmissionParams.smpsRecievedBeforeAddStaFlag = TRUE;
			LinkAdaptationStaDatabase[antennaSelectionParams->stationId].laStaUspCommon.staTransmissionParams.smpsRecievedBeforeAddStaVal  = TRUE;
			LinkAdaptationStaDatabase[antennaSelectionParams->stationId].laStationUnique.operatingModeNotification.isFrameReceivedBeforeAddSta = FALSE;
 		}		
	}
	else if (antennaSelectionParams->mode == UNSET_SMPS) 
	{
		ASSERT(antennaSelectionParams->stationId < HW_NUM_OF_STATIONS); //HW_FIX_FW_G
		if (StaDbSwEntries[antennaSelectionParams->stationId].state == STA_STATE_CONNECTED) 
		{
			DEBUG_ASSERT(antennaSelectionParams->stationId != INVALID_STA_INDEX);
			LinkAdaptationStaDatabase[antennaSelectionParams->stationId].laStaUspCommon.staTransmissionParams.staInSmpsStaticMode = FALSE;
			LinkAdaptationStaDatabase[antennaSelectionParams->stationId].laStationUnique.operatingModeNotification.staInOmn = FALSE;
			antennaCount = AntennaSelectionGetAntennaCount(antennaSelectionParams->stationId);
			updateOverridePendingDb(OVERRIDE_NSS, CONVERT_MAX_NUM_OF_ANTENNAS_TO_MAX_NUM_OF_NSS(antennaCount), &laDbDistributionParameter);
		}
		else
		{
			LinkAdaptationStaDatabase[antennaSelectionParams->stationId].laStaUspCommon.staTransmissionParams.smpsRecievedBeforeAddStaFlag = TRUE;
			LinkAdaptationStaDatabase[antennaSelectionParams->stationId].laStaUspCommon.staTransmissionParams.smpsRecievedBeforeAddStaVal  = FALSE;
			LinkAdaptationStaDatabase[antennaSelectionParams->stationId].laStationUnique.operatingModeNotification.isFrameReceivedBeforeAddSta = FALSE;
		}
	}		
	/*Send confirmation*/	
	OSAL_SEND_NO_DATA_MESSAGE(antennaSelectionParams->retMsg, antennaSelectionParams->retTask, antennaSelectionParams->vapId);
}

/**********************************************************************************

linkAdaptationSetFixedBfMode 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void linkAdaptationSetFixedBfMode(K_MSG *psMsg )
{
	LaFixedBeamformingParams_t* pFixedBfModeParams = (LaFixedBeamformingParams_t*)pK_MSG_DATA(psMsg);
	setBfDebugParams(pFixedBfModeParams);
	BeamformingSetFixedMode(bfDebugParams.stationId);
}

/**********************************************************************************

linkAdaptationSetAggRateLimit 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void linkAdaptationSetAggRateLimit(K_MSG *psMsg )
{
	UMI_AGG_RATE_LIMIT* pAggRateLimit = (UMI_AGG_RATE_LIMIT*)pK_MSG_DATA(psMsg);
	StaId nextSid = LmStaDataBase.headIndexOfStaLinkList;
	uint16	transmissionTime, phyRate;
	uint8	rateIndex;
	const RateObj_t* ratesTable;
		
	if (pAggRateLimit->getSetOperation == API_GET_OPERATION)
	{
		pAggRateLimit->mode = AggRateLimitMode;
		pAggRateLimit->maxRate = AggRateLimitMaxRate;
	}
	else
	{
		/* Update Client Isolation params */
		AggRateLimitMode	  = pAggRateLimit->mode;
		AggRateLimitMaxRate   = pAggRateLimit->maxRate;
#ifdef LINK_ADAPTATION_LOGS
//	ILOG0_DD("[linkAdaptationSetAggRateLimit] agg limit mode: %d agg limit max rate: %d",AggRateLimitMode,AggRateLimitMaxRate);
#endif
		/* Set transmission time params according to AggRateLimit params*/
		setTransmissionTimeParams();
		/* Set time limit */
		while(nextSid != DB_ASYNC_SID)
		{
			ASSERT(nextSid < HW_NUM_OF_STATIONS); //KW_FIX_FW_G
			rateIndex = estimatorsGetWorkingPointRateIndexOfMainBw(&(LinkAdaptationStaDatabase[nextSid].laStaUspCommon));
	
			ratesTable = getRatesTable(&LinkAdaptationStaDatabase[nextSid].laStaUspCommon);
			phyRate = ratesTable[rateIndex].rateTableBwParmas[GetDataBwLimit(nextSid,INVALID_MU_USP_INDEX, FALSE)].shortCpPhyRate;
	
			if (LinkAdaptationStaDatabase[nextSid].laStaUspCommon.staTransmissionParams.clientIsolationMode == FALSE)
			{
				transmissionTime = MAX_TRANSMISSION_TIME;
			}
			else
			{
				transmissionTime = (phyRate < LA_TIME_LIMIT_RATE_TH) ? MED_TRANSMISSION_TIME : MIN_TRANSMISSION_TIME;			
			}		
	
			linkAdaptationSetTransmissionTimeLimit(nextSid, transmissionTime);
	
			nextSid = StaDbSwEntries[nextSid].nextSid;
		}
	}
	/* Send confirmation to host*/
	OSAL_SEND_MESSAGE(UMI_MC_MAN_AGG_RATE_LIMIT_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);

}

/**********************************************************************************

linkAdaptationSetPowerLimit


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void linkAdaptationSetPowerLimit(K_MSG *psMsg )
{
	// Store Power Limit Offset
	PowerAdaptationSetLastLimitOffset(psMsg);
	
	/*Send confirmation*/
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_POWER_LIMIT_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);

}

/**********************************************************************************

linkAdaptationClearSmpsFlags



Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationClearSmpsFlags(StaId stationIndex)
{
	LinkAdaptationStaDatabase_t* pLinkAdaptationDb = NULL;	
	
	DEBUG_ASSERT(HW_NUM_OF_STATIONS > stationIndex);
	
	pLinkAdaptationDb = &LinkAdaptationStaDatabase[stationIndex];

	/* Clear SMPS flags */
	pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.smpsRecievedBeforeAddStaFlag = FALSE;
	pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.smpsRecievedBeforeAddStaVal  = FALSE;	
}
/**********************************************************************************

linkAdaptationClearOperatingModeNotification 


Description:
------------
Remove the indication of an Action frame received before ADD STA since ADD STA is canceled 

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void linkAdaptationClearOperatingModeNotification(StaId stationIndex)
{	
	LinkAdaptationStaDatabase_t* pLinkAdaptationDb = NULL; 
	//("[OMN][linkAdaptationClearOperatingModeNotification] stationIndex = %d", stationIndex);
	DEBUG_ASSERT(HW_NUM_OF_STATIONS > stationIndex);

	/* Clear Operating Mode Notification */
	pLinkAdaptationDb = &LinkAdaptationStaDatabase[stationIndex];
	pLinkAdaptationDb->laStationUnique.operatingModeNotification.isFrameReceivedBeforeAddSta = FALSE;
	
}
/**********************************************************************************

linkAdaptationRemoveSidReq 


Description:
------------
Handle vUMI_MAN_REMOVE_SID_REQ:
1. Clear SMS flags
2. Clear OMN received in an action frame before Add STA was received

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationRemoveSidReq(K_MSG *psMsg)
{
	LaRemoveSid_t *laRemoveSid = (LaRemoveSid_t *)pK_MSG_DATA(psMsg);
	
	linkAdaptationClearSmpsFlags(laRemoveSid->stationIndex);
	linkAdaptationClearOperatingModeNotification(laRemoveSid->stationIndex);
	Utils_ZeroBitInBitmap((uint32 *)(muCandidateStaBitmap), laRemoveSid->stationIndex);			
#ifdef ENET_INC_ARCH_WAVE600B
	/* Clear Omi valid bit upon STA removal */
	TxSelector_SetOmiValid(laRemoveSid->stationIndex, FALSE);
#endif
}

/**********************************************************************************

LinkAdaptationQAMplusActivate 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationQAMplusActivate(K_MSG *psMsg )
{
	UMI_QAMPLUS_ACTIVATE *pLaQAMplusActivateMsg = (UMI_QAMPLUS_ACTIVATE *)pK_MSG_DATA(psMsg);
	bool activateQAMplus = FALSE;

	if (pLaQAMplusActivateMsg->getSetOperation == API_GET_OPERATION)
	{
		pLaQAMplusActivateMsg->enableQAMplus = QAMplus_get();
	}
	else
	{
		if (pLaQAMplusActivateMsg->enableQAMplus > 0)
		{
			activateQAMplus = TRUE;
		}
		
		QAMplus_Enable(activateQAMplus);
	}

	OSAL_SEND_MESSAGE(UMI_MAN_QAMPLUS_ACTIVATE_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

/**********************************************************************************

linkAdaptationMsduInAmsduConfig 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationMsduInAmsduConfig(K_MSG *psMsg )
{
	linkAdaptationSetMsduInAmsdu(psMsg);
	
	OSAL_SEND_MESSAGE(UMI_MAN_MSDU_IN_AMSDU_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}


static void  linkAdaptationSetPpduMode(K_MSG *psMsg)
{
	UMI_TS_VAP_CONFIGURE *pTsVapConfig = (UMI_TS_VAP_CONFIGURE *)pK_MSG_DATA(psMsg);

	if (pTsVapConfig->enableBa == TRUE)
	{
		linkAdaptationSetPpduTxMode(STA_DB_PPDU_TX_MODE_LEGACY_AND_MPDU | (pTsVapConfig->amsduSupport << STATION_DATABASE_TX_MODE_AMSDU_ENABLE_SHIFT));
	}
	else
	{
		// AMPDU is turned off. We check if we still support AMSDU or not. Store it for later use when we close the BA Agreement
		linkAdaptationSetPpduTxMode(pTsVapConfig->amsduSupport << STATION_DATABASE_TX_MODE_AMSDU_ENABLE_SHIFT);
	}

	OSAL_SEND_MESSAGE(UMI_MAN_TS_VAP_CONFIGURE_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);

}

    
/***********************************************************************
* linkAdaptationSetFilter
* 
* Description:
* ------------
* Handle set filter command from Driver
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
static void linkAdaptationSetFilter(K_MSG *laMessage)
{
	BssManagerStaManagerReq_t 					*staManagerReq = (BssManagerStaManagerReq_t *)pK_MSG_DATA(laMessage);
	K_MSG 										*pMsg = staManagerReq->psMsg;
	UMI_802_1X_FILTER 							*pSetFilter = (UMI_802_1X_FILTER *)pK_MSG_DATA(pMsg);
	uint8 										currentRate = 0;
	StaId 										stationIndex = pSetFilter->u16SID;
	LinkAdaptationStaDatabase_t* 				pLinkAdaptationDb = &LinkAdaptationStaDatabase[stationIndex];
	LinkAdaptationDatabaseDistributionPack_t	laDbDistributionParameter;
	uint8										storedDataRate = LinkAdaptationStaDatabase[stationIndex].laStationUnique.initialRateIndex;
	uint8                                       rateIndex = 0;
	updateLaDbDistributionParam(&laDbDistributionParameter, stationIndex, INVALID_MU_USP_INDEX, FALSE);

	currentRate = estimatorsGetWorkingPointRateIndexOfMainBw(laDbDistributionParameter.laStaUspCommon);
	ILOG0_D("[EAPOL] linkAdaptationSetFilter currentRate = %d", currentRate);

	

	/* Remove current rate from mask in case it was changed by the sniffer WA (the current rate is the management used to send EAPOLs) */
	if (LinkAdaptationStaDatabase[stationIndex].laStationUnique.isSnifferEapolWaActive == TRUE)
	{
		/* Clear the flag */
		LinkAdaptationStaDatabase[stationIndex].laStationUnique.isSnifferEapolWaActive = FALSE;
		/* Remove rate from both masks */
		LA_CLR_BIT_IN_BITMAP(pLinkAdaptationDb->laStaUspCommon.raIndexMask.raIndexMask64bit, currentRate);
		LA_CLR_BIT_IN_BITMAP(pLinkAdaptationDb->laStaUspCommon.raIndexMaskOrg.raIndexMask64bit, currentRate);
	}

	/* Handle the case that NSS bit was modified */
	rateIndex = rateAdaptationGetLowerRateIndex(&laDbDistributionParameter, LinkAdaptationCommonConfiguration.wlanBandwidthMax, storedDataRate, laDbDistributionParameter.laStaUspCommon->raIndexMask, 0, FALSE);
	rateAdaptationChangeWorkingPoint(&laDbDistributionParameter, rateIndex, currentRate);
	/* Handle the case that BW was modified */	
	/* Handle the case that BW was modified */	
	updateOverridePendingDb(OVERRIDE_RATE_INDEX, storedDataRate, &laDbDistributionParameter);
	updateOverridePendingDb(ADJUST_RATE_TO_MASK, storedDataRate, &laDbDistributionParameter);

	executeParamOverride(&laDbDistributionParameter);

	if(laDbDistributionParameter.laStationUnique->fixedRateStationParams.FixedRateRequested == TRUE)
	{
		//move to fix rate by change state and sending an event,
		//we can not call directly to "setFixedRateStateProbeResponseEvent"
		laStateMachineChangeState(&laDbDistributionParameter,LA_SET_FIXED_RATE);
		laStateMachineEnterEvent(&laDbDistributionParameter, BA_PROBE_RESPONSE_RECEIVED);
	}

	/* Send confim to BSS Manager */
	laStaManagerSendConfirm(stationIndex, laMessage->header.vapId);
}

void laStaManagerSendConfirm(StaId sid, uint8 vapId)
{	
	K_MSG *pMsg;
	BssManagerStaManagerCfm_t *confirmMessage;

	/*Allocate message*/
	pMsg = OSAL_GET_MESSAGE(sizeof(BssManagerStaManagerCfm_t));
	confirmMessage = (BssManagerStaManagerCfm_t*) pK_MSG_DATA(pMsg);
	/*Set Client ID to the registered ID*/
	confirmMessage->clientId = 	BSS_MANAGER_STA_MANAGER_LA_CLIENT;
	/*Set STA ID*/
	confirmMessage->sid = sid;
	/*Send confirmation message*/
	OSAL_SEND_MESSAGE(BSS_MANAGER_STA_MANAGER_REG_CFM, TASK_BSS_MANAGER, pMsg, vapId);
	
	ILOG0_DD("[EAPOL] laStaManagerSendConfirmRX send confirmation, Client %d, SID %d", confirmMessage->clientId, sid);	
}


/**********************************************************************************

linkAdaptatioRtsModeConfig 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptatioRtsModeConfig(K_MSG *psMsg )
{
	UMI_RTS_MODE_CONFIG *pLaRtsModeConfigMsg = (UMI_RTS_MODE_CONFIG *)pK_MSG_DATA(psMsg);

	linkAdaptationSetRtsMode(pLaRtsModeConfigMsg);

	//send confirmation
	OSAL_SEND_MESSAGE(UMI_RTS_MODE_SETTING_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

/**********************************************************************************

linkAdaptationSetTxopMode 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationSetTxopMode(K_MSG *psMsg )
{
	UMI_SET_TXOP_CONFIG* pTxopConfig = (UMI_SET_TXOP_CONFIG*)psMsg->abData;

	if (pTxopConfig->getSetOperation == API_GET_OPERATION)
	{
		pTxopConfig->mode = DynamicTxop_GetTxopMode();
		pTxopConfig->txopDuration = DynamicTxop_GetTxopDuration();
		pTxopConfig->maxNumOfStas = DynamicTxop_GetTxopMaxNumStas();

		ILOG0_DDDD("[linkAdaptationSetTxopMode] GET staId %d mode %d txopDuration %d maxNumOfStas %d", pTxopConfig->staId, pTxopConfig->mode, pTxopConfig->txopDuration, pTxopConfig->maxNumOfStas);	
	}
	else
	{
		DynamicTxop_SetTxopMode(pTxopConfig->staId, pTxopConfig->mode);
		DynamicTxop_SetTxopDuration(pTxopConfig->txopDuration);
		DynamicTxop_SetTxopMaxNumStas(pTxopConfig->staId, pTxopConfig->maxNumOfStas);

		ILOG0_DDDD("[linkAdaptationSetTxopMode] SET staId %d mode %d txopDuration %d maxNumOfStas %d", pTxopConfig->staId, pTxopConfig->mode, pTxopConfig->txopDuration, pTxopConfig->maxNumOfStas);	
	}

	//send confirmation
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_TXOP_CONFIG_CFM, TASK_UM_IF_TASK, psMsg,GET_DEFAULT_VAP_FOR_MY_BAND());
}

/**********************************************************************************

linkAdaptatioMaxMpduConfig 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptatioMaxMpduConfig(K_MSG *psMsg )
{
	UMI_MAX_MPDU* pMpsuLen = (UMI_MAX_MPDU*)psMsg->abData;

	if (pMpsuLen->getSetOperation == API_GET_OPERATION)
	{
		pMpsuLen->maxMpduLength = maxMpduLenLimit;
	}
	else
	{
		maxMpduLenLimit = pMpsuLen->maxMpduLength;
		ASSERT(maxMpduLenLimit != 0);
	}

	//send confirmation
	OSAL_SEND_MESSAGE(UMI_MAX_MPDU_LEN_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}
/**********************************************************************************

linkAdaptatioProtectionFixed 


Description:
------------
DoSimpleCLI Fixed 11nProtection

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void  linkAdaptaionProtectionFixed(K_MSG *psMsg )
{
	ProtectionAdaptation_SetFixedMode(psMsg);		
}

/**********************************************************************************

linkAdaptationFastDropConfig 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationFastDropConfig(K_MSG *psMsg)
{
	UMI_FAST_DROP_CONFIG_REQ_t* pFastDropCfg = (UMI_FAST_DROP_CONFIG_REQ_t*)psMsg->abData;
	
	if (pFastDropCfg->getSetOperation == API_GET_OPERATION)
	{
		pFastDropCfg->enableFastDrop = enableFastDrop;
	}
	else
	{
		enableFastDrop = pFastDropCfg->enableFastDrop;
	}
	ILOG0_DD("[FAST DROP] linkAdaptationFastDropConfig enableFastDrop = %d pFastDropCfg->enableFastDrop = %d ", enableFastDrop, pFastDropCfg->enableFastDrop);
	OSAL_SEND_MESSAGE(UMI_MC_MAN_FAST_DROP_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);

}

/**********************************************************************************

linkAdaptationDmrConfig 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationDmrConfig(K_MSG *psMsg )
{
	UmiDmrConfig_t* pDmrConfig = (UmiDmrConfig_t*)psMsg->abData;
	uint8 lowestRateIndexAllStation;
    LmVapDbSwInfo_t* pLmVapDbSwInfo;
#ifdef EXTENDED_DMR_MODES_SUPPORTED
   	LmStaDbSwInfo_t* pLmStaDbSwinfo;
#endif
	RateMask_t vapBasicRateMask;
	uint8 vapId;
#ifdef EXTENDED_DMR_MODES_SUPPORTED
	StaId nextSid;
	uint8 wpRateIndex;
	uint8 sortOldRateIndex, sortNewRateIndex; 
#endif

    if (pDmrConfig->getSetOperation == API_GET_OPERATION)
    {
        pDmrConfig->dmrMode = dmrMode;
    }
	else if (dmrMode != pDmrConfig->dmrMode)
	{
		if (pDmrConfig->dmrMode == UMI_DMR_DISABLED)
		{
			/*We are moving to disable state - don't change mode yet so rate can be updated below*/
			for (vapId = 0; vapId < HW_NUM_OF_VAPS; vapId++)
			{
				pLmVapDbSwInfo = &LmVapDataBase[vapId];
				if (pLmVapDbSwInfo->vapState == LM_VAP_STATE_ADDED)
				{
					/*Set MC rate to lowest basic rate*/
					vapBasicRateMask.raIndexMask64bit[0] = pLmVapDbSwInfo->basicRates;
					vapBasicRateMask.raIndexMask64bit[1] = 0;
					lowestRateIndexAllStation = getLowestRateinMask(INVALID_STA_INDEX, vapBasicRateMask, BANDWIDTH_TWENTY,0, PHY_MODE_11G_HIGHEST_SORT_RATE_INDEX); /*Get lower rate from vap basic rates*/
					// update lowest rate if changed
					linkAdaptationDmrUpdateVapRate(vapId, lowestRateIndexAllStation);
				}
			}
			/*change state now*/
			dmrMode = (UmiDmrMode_e)pDmrConfig->dmrMode;
		}
#ifdef EXTENDED_DMR_MODES_SUPPORTED
		else if ((dmrMode == UMI_DMR_DISABLED) && (pDmrConfig->dmrMode == UMI_DMR_SUPPORTED_RATES))
#else	/*Only disable and suppported rates are supported*/
		else
#endif
		{
			/*Moving from disabled to supported rates, everything is ready*/
			/*Set new state, do it here so rate can be changed below*/
			dmrMode = (UmiDmrMode_e)pDmrConfig->dmrMode;
			for (vapId = 0; vapId < HW_NUM_OF_VAPS; vapId++)
			{
				pLmVapDbSwInfo = &LmVapDataBase[vapId];
				if (pLmVapDbSwInfo->vapState == LM_VAP_STATE_ADDED)
				{
					/*Find lowest rate - */
					lowestRateIndexAllStation = linkAdaptationDmrSeekLowestBasicRateAmongStations(pLmVapDbSwInfo->sortBasicRateNumOfStationsCounter,
																								  pLmVapDbSwInfo->mcRateIndex);
					// update lowest rate if changed
					linkAdaptationDmrUpdateVapRate(vapId, lowestRateIndexAllStation);
				}
			}
		}	
#ifdef EXTENDED_DMR_MODES_SUPPORTED
		else
		{
			/*We are moving to\from a partial state - need to recalculate the sorted basic rate number of stations counters...*/
			/*Set new state, do it here so recalculate is done according to new mode*/
			dmrMode = (UmiDmrMode_e)pDmrConfig->dmrMode;
			/*Zero the sorted basic rate number of stations counters*/
			for (vapId = 0; vapId < HW_NUM_OF_VAPS; vapId++)
			{
				pLmVapDbSwInfo = &LmVapDataBase[vapId];
				if (pLmVapDbSwInfo->vapState == LM_VAP_STATE_ADDED)
				{
                	memset(pLmVapDbSwInfo->sortBasicRateNumOfStationsCounter, 0, sizeof(pLmVapDbSwInfo->sortBasicRateNumOfStationsCounter));
				}
            }
			nextSid = LmStaDataBase.headIndexOfStaLinkList;
			/*Go over all connected stations*/
			while (nextSid != DB_ASYNC_SID)
			{
				pLmStaDbSwinfo = &StaDbSwEntries[nextSid];
				/*Get the station wp index*/
				wpRateIndex = GetStaWpRateIndexFromHwTcr(nextSid, BANDWIDTH_TWENTY);
				vapId = pLmStaDbSwinfo->vapIndex;
				linkAdaptationDmrConvertRateindexToSortedBasicRateIndex(wpRateIndex, wpRateIndex, &sortOldRateIndex, &sortNewRateIndex, vapId);
				/*Increment the counter*/
				pLmVapDbSwInfo = &LmVapDataBase[vapId];
				pLmVapDbSwInfo->sortBasicRateNumOfStationsCounter[sortNewRateIndex]++;
				nextSid = StaDbSwEntries[nextSid].nextSid;
			}
			for (vapId = 0; vapId < HW_NUM_OF_VAPS; vapId++)
			{
				pLmVapDbSwInfo = &LmVapDataBase[vapId];
				if (pLmVapDbSwInfo->vapState == LM_VAP_STATE_ADDED)
				{
					/*Find lowest rate - */
					lowestRateIndexAllStation = linkAdaptationDmrSeekLowestBasicRateAmongStations(pLmVapDbSwInfo->sortBasicRateNumOfStationsCounter,
																								  pLmVapDbSwInfo->mcRateIndex);
					// update lowest rate if changed
					linkAdaptationDmrUpdateVapRate(vapId, lowestRateIndexAllStation);
				}
			}
		}
#endif		
	}

	OSAL_SEND_MESSAGE(UMI_MC_MAN_DMR_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);

}
/**********************************************************************************

linkAdaptationSetRegDomainConfig 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
static void  linkAdaptationSetRegDomainConfig(K_MSG *psMsg)
{		
	UMI_REG_DOMAIN_CONFIG* pRegDomainConfig = (UMI_REG_DOMAIN_CONFIG*)psMsg->abData;
#ifdef ENET_INC_ARCH_WAVE600B
	bool etsiMode = FALSE;
#endif

	if (pRegDomainConfig->getSetOperation == API_GET_OPERATION)
	{
		pRegDomainConfig->regDomainConfig = regulatoryDomainConfig;
	}
	else
	{
		if (pRegDomainConfig->regDomainConfig != regulatoryDomainConfig)
		{
			regulatoryDomainConfig = pRegDomainConfig->regDomainConfig;
#ifdef ENET_INC_ARCH_WAVE600B
			if (regulatoryDomainConfig == REG_DOMAIN_ETSI)
			{
				// Enable ETSI mode				
				etsiMode = TRUE;
			}
			setEtsiMode(etsiMode);
#endif
			RadarDetection_SetRegDomainParams(regulatoryDomainConfig);
		}
	}
	OSAL_SEND_MESSAGE(UMI_MC_MAN_REG_DOMAIN_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}
#endif 

    
/***********************************************************************
* linkAdaptationIsEtsiMode
* 
* Description:
* ------------
* Are we in ETSI mode
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600B
bool linkAdaptationIsEtsiMode(void)
{
	bool etsiMode = FALSE;

	if (regulatoryDomainConfig == REG_DOMAIN_ETSI)
	{							
		etsiMode = TRUE;
	}
	return(etsiMode);
}
#endif	

/**********************************************************************************

linkAdaptationSetOperatingModeNotificationStaConnected 


Description:
------------
A STA sent Action frame of type Operating Mode Notification. Set BW and Rx NSS according to the STA's request

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationSetOperatingModeNotificationStaConnected(LaOperatingModeNotificationMsg_t *laOmnMsg)
{
	uint8 rateIndex = INVALID_ESTIMATORS_DB_INDEX_VAL;
	uint8 tempRxNss = 0;
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter;
	uint8 antennaCount;

	updateLaDbDistributionParam(&laDbDistributionParameter,laOmnMsg->stationId,INVALID_MU_USP_INDEX, FALSE);

	//("[OMN][linkAdaptationSetOperatingModeNotificationStaConnected] STA is connected rxNss = %d",laOmnMsg->rxNss);
	/* Get Working Point rate index */
	rateIndex = estimatorsGetWorkingPointRateIndexOfMainBw(&(LinkAdaptationStaDatabase[laOmnMsg->stationId].laStaUspCommon));
		
	/* Set BW for Data frames: */
	/* a. Set new BW limit to SW */
	initStaBwLimit(laOmnMsg->stationId, rateIndex, (LaOperationModeNotificationChannelWidth_e)laOmnMsg->channelWidth, LinkAdaptationCommonConfiguration.wlanBandwidthMax);
	
	/* Set NSS for Data frames */
	/* a.	set a new raIndexMask according to new NSS. rxNss cannot be higher than AP capability (4 NSS) */
	tempRxNss = MIN(laOmnMsg->rxNss, OMN_RX_NSS_4);

	LinkAdaptationStaDatabase[laOmnMsg->stationId].laStationUnique.operatingModeNotification.staInOmn = TRUE;
	LinkAdaptationStaDatabase[laOmnMsg->stationId].laStationUnique.operatingModeNotification.rxNss = tempRxNss;
	LinkAdaptationStaDatabase[laOmnMsg->stationId].laStationUnique.operatingModeNotification.channelWidth = laOmnMsg->channelWidth;

	LinkAdaptationStaDatabase[laOmnMsg->stationId].laStaUspCommon.staTransmissionParams.staInSmpsStaticMode = FALSE;

	antennaCount = AntennaSelectionGetAntennaCount(laOmnMsg->stationId);
	tempRxNss = MIN(CONVERT_MAX_NUM_OF_ANTENNAS_TO_MAX_NUM_OF_NSS(antennaCount), tempRxNss);

	updateOverridePendingDb(OVERRIDE_NSS, (tempRxNss), &laDbDistributionParameter);
	//("[OMN][linkAdaptationSetOperatingModeNotificationStaConnected] raIndexMask64bit = %X%X", LinkAdaptationStaDatabase[laOmnMsg->stationId].raIndexMask.raIndexMask64bit[1], LinkAdaptationStaDatabase[laOmnMsg->stationId].raIndexMask.raIndexMask64bit[0]);
}


/**********************************************************************************

linkAdaptationSetOperatingModeNotificationStaConnected 


Description:
------------
A STA sent Action frame of type Operating Mode Notification before the Driver sent Add STA command. Store the information until Add STA command is received.

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationSetOperatingModeNotificationStaNotConnected(LaOperatingModeNotificationMsg_t *laOmnMsg)
{
	LinkAdaptationStaDatabase_t* pLinkAdaptationDb = &LinkAdaptationStaDatabase[laOmnMsg->stationId];

	//("[OMN][linkAdaptationSetOperatingModeNotificationStaNotConnected] STA not connected rxNss = %d",laOmnMsg->rxNss);
	
	/* Driver has not sent ADD STA yet - just store the information in LA data base, it will be handled at linkAdaptationAddStationReq */
	pLinkAdaptationDb->laStationUnique.operatingModeNotification.isFrameReceivedBeforeAddSta = TRUE;
	pLinkAdaptationDb->laStationUnique.operatingModeNotification.channelWidth = laOmnMsg->channelWidth;
	pLinkAdaptationDb->laStationUnique.operatingModeNotification.rxNss = MIN(laOmnMsg->rxNss, OMN_RX_NSS_4);
	pLinkAdaptationDb->laStaUspCommon.staTransmissionParams.smpsRecievedBeforeAddStaFlag = FALSE;
}


/**********************************************************************************
linkAdaptationSetOperatingModeNotification


Description: 
------------

Action frame of type Operating Mode Notification handler. SPEC section 9.7.5.7
Change Rx Nss and BW according to STA's request or store the request until the Driver sends the Add STA command


Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationSetOperatingModeNotification(K_MSG *psMsg)
{	
	LaOperatingModeNotificationMsg_t *laOmnMsg = (LaOperatingModeNotificationMsg_t*)pK_MSG_DATA(psMsg);

	if (getStaState(laOmnMsg->stationId) == STA_STATE_CONNECTED)
	{
		/* Station is connected - make the change */
		linkAdaptationSetOperatingModeNotificationStaConnected(laOmnMsg);
	}		
	else
	{
		/* Station is not connected - store the information. The change will take effect at Add STA */
		linkAdaptationSetOperatingModeNotificationStaNotConnected(laOmnMsg);
	}

}


/**********************************************************************************

updateTransmissionTimeParams 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void updateTransmissionTimeParams(StaId staIndex, uint8 rateIndex)
{
	const RateObj_t* ratesTable = getRatesTable(&LinkAdaptationStaDatabase[staIndex].laStaUspCommon);
	uint16 phyRate = ratesTable[rateIndex].rateTableBwParmas[GetDataBwLimit(staIndex,INVALID_MU_USP_INDEX, FALSE)].shortCpPhyRate;
	LinkAdaptationPhyMode_e laPhyMode = ratesTable[rateIndex].laPhyMode;
	bool isPhyModeHtVhtHe = (laPhyMode == LA_PHY_MODE_HT_VHT) || (laPhyMode == LA_PHY_MODE_HE);
		
	if ((phyRate >  AggRateLimitMaxRate) || (!isPhyModeHtVhtHe))
	{
		ILOG2_D("[updateTransmissionTimeParams] rate is above threshold: %d", phyRate);
		LinkAdaptationStaDatabase[staIndex].laStaUspCommon.staTransmissionParams.clientIsolationMode = FALSE;
	}
	else if ((phyRate <  AggRateLimitMaxRate) && (isPhyModeHtVhtHe))
	{
		ILOG2_D("[updateTransmissionTimeParams] rate is below threshold: %d. limit transmission time", phyRate);
		LinkAdaptationStaDatabase[staIndex].laStaUspCommon.staTransmissionParams.clientIsolationMode = TRUE;
	}
}

/**********************************************************************************

clientIsolationRateIsChanged 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void clientIsolationRateIsChanged(LinkAdaptationDatabaseDistributionPack_t* pLaDbDistributionParameter, RaFastProbingPoint_e newFastProbingPoint, uint8 oldRateIndex, uint8 newRateIndex, Bandwidth_e bw)
{
	const RateObj_t* ratesTable = getRatesTable(pLaDbDistributionParameter->laStaUspCommon);
	uint16 oldPhyRate = ratesTable[oldRateIndex].rateTableBwParmas[bw].shortCpPhyRate;
	uint16 newPhyRate = ratesTable[newRateIndex].rateTableBwParmas[bw].shortCpPhyRate;
	LinkAdaptationPhyMode_e newLaPhyMode = ratesTable[newRateIndex].laPhyMode;
	LinkAdaptationPhyMode_e oldLaPhyMode = ratesTable[oldRateIndex].laPhyMode;
	uint16 transmissionTime;
	bool probing = (newFastProbingPoint != WORKING_POINT);
	bool isOldPhyModeHtVhtHe = (oldLaPhyMode == LA_PHY_MODE_HT_VHT) || (oldLaPhyMode == LA_PHY_MODE_HE);
	bool isNewPhyModeHtVhtHe = (newLaPhyMode == LA_PHY_MODE_HT_VHT) || (newLaPhyMode == LA_PHY_MODE_HE);
	
	if(pLaDbDistributionParameter->uspIndex == INVALID_MU_USP_INDEX) /* Client isolation is not relevant for MU*/
	{
		if (AggRateLimitMode == TRUE)
		{			
			ILOG2_DDDD("clientIsolationRateIsChanged oldPhyRate: %d newPhyRate: %d oldPhymode %d newPhyMode %d", oldPhyRate, newPhyRate, oldLaPhyMode, newLaPhyMode);
			if (((oldPhyRate < AggRateLimitMaxRate) && (newPhyRate > AggRateLimitMaxRate)) || ((isOldPhyModeHtVhtHe) && (!isNewPhyModeHtVhtHe)))
			{
				pLaDbDistributionParameter->laStaUspCommon->staTransmissionParams.clientIsolationMode = FALSE;
				pLaDbDistributionParameter->laStaUspCommon->staTransmissionParams.clientIsolationProbing = probing;
				/* Set time limit */
				linkAdaptationSetTransmissionTimeLimit(pLaDbDistributionParameter->stationOrGroupIndex, MAX_TRANSMISSION_TIME);
			}
			else if ((oldPhyRate > AggRateLimitMaxRate) && (newPhyRate < AggRateLimitMaxRate) && (isNewPhyModeHtVhtHe))
			{
				pLaDbDistributionParameter->laStaUspCommon->staTransmissionParams.clientIsolationMode = TRUE;			
				pLaDbDistributionParameter->laStaUspCommon->staTransmissionParams.clientIsolationProbing = probing;
				/* Set time limit */
				transmissionTime = (newPhyRate < LA_TIME_LIMIT_RATE_TH) ? MED_TRANSMISSION_TIME : MIN_TRANSMISSION_TIME;
				linkAdaptationSetTransmissionTimeLimit(pLaDbDistributionParameter->stationOrGroupIndex, transmissionTime);			
			}
			else if ((oldPhyRate == newPhyRate) && (newPhyRate < AggRateLimitMaxRate) && (isNewPhyModeHtVhtHe))
			{
				pLaDbDistributionParameter->laStaUspCommon->staTransmissionParams.clientIsolationMode = TRUE;			
				pLaDbDistributionParameter->laStaUspCommon->staTransmissionParams.clientIsolationProbing = probing;
				/* Set time limit */
				transmissionTime = ((newPhyRate < LA_TIME_LIMIT_RATE_TH) || ((probing) && (oldPhyRate < LA_TIME_LIMIT_RATE_TH))) ? MED_TRANSMISSION_TIME : MIN_TRANSMISSION_TIME;
				linkAdaptationSetTransmissionTimeLimit(pLaDbDistributionParameter->stationOrGroupIndex, transmissionTime);			
			}
		}
	}
}

/**********************************************************************************

modifyStaTcrsParamsReq 


Description:
------------
Function modify TCR params:
Get TCR params into modifyParamsOut
Call modification specific function to change pecific parameter
Set rate + 1 if required
Adjust between TCR parameters
Write all TCR parameters to HW DB 

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

bool modifyStaTcrsParamsReq(LaTcrModificationStruct_t* pModifyParamsIn, LaTcrModificationFunc modificationFunc)
{
	Bandwidth_e bandwidth; 
	LaTcrModificationStruct_t modifyParamsOut;
	uint8 newRateIndex = 0;
	bool ratePlusOneChanged = FALSE;
	StaId staIndex = pModifyParamsIn->controlParams.staIndex;

	/*Copy  params from modifyParamsIn to modifyParamsOut*/
	MEMCPY (&modifyParamsOut, pModifyParamsIn, sizeof(LaTcrModificationStruct_t));
	/*Fill modifyParamsOut tcr params from HW tcrs*/
	getTcrParamsFromHwDb(&modifyParamsOut);
/*DEBUG*/
//	SLOG0(0, 0, LaTcrModificationStruct_t, pModifyParamsIn);
//	SLOG0(0, 0, LaTcrModificationStruct_t, &modifyParamsOut);
/******/
	/*Call modification specific function to change specific parameter*/
	modificationFunc(pModifyParamsIn, &modifyParamsOut);

/*DEBUG*/
//	SLOG0(0, 0, LaTcrModificationStruct_t, &modifyParamsOut);
/******/
	if ((modifyParamsOut.controlParams.uspIndex == INVALID_MU_USP_INDEX)&&(modifyParamsOut.controlParams.changeToRatePlusOne == TRUE))
	{
		/*Set higher rate */
		newRateIndex = estimatorsGetHigherProbingRateIndex(staIndex);
		if (newRateIndex != INVALID_RATE_INDEX_VAL)
		{
			ratePlusOneChanged = TRUE;
		}
	}

	for (bandwidth = modifyParamsOut.controlParams.firstBwToUpdate; bandwidth <= modifyParamsOut.controlParams.lastBwToUpdate; bandwidth++)
	{
		ASSERT(bandwidth < MAX_POSSIBLE_NUM_OF_BW); //KW_FIX_FW_G
		if (ratePlusOneChanged == TRUE)
		{
			DEBUG_ASSERT(modifyParamsOut.controlParams.uspIndex == INVALID_MU_USP_INDEX);
			/*Up MCS is  valid, update rate index, if not stay with the WP rate index*/
			modifyParamsOut.tcrParams.bwDependedTcrValsTable[bandwidth].rateindex = newRateIndex;
		}
		/*Adjust between TCR parameters*/
		if(modifyParamsOut.controlParams.uspIndex == INVALID_MU_USP_INDEX)
		{
			adjustBetweenStaTcrsParams(staIndex, bandwidth,pModifyParamsIn, &modifyParamsOut);	
		}
	}
	
	/*Save rate index on slow probing estimators DB*/
	estimatorsSetSlowProbingPointRateIndex(staIndex,pModifyParamsIn->controlParams.uspIndex,modifyParamsOut.tcrParams.bwDependedTcrValsTable[GetDataBwLimit(pModifyParamsIn->controlParams.staIndex,pModifyParamsIn->controlParams.uspIndex, pModifyParamsIn->controlParams.isHeGroup)].rateindex);

/*DEBUG*/
//	SLOG0(0, 0, LaTcrModificationStruct_t, &modifyParamsOut);
/******/
	
	/*Write all TCR parameters to HW DB */
	setAllBwsTcrsParams(&modifyParamsOut);

#ifndef ENET_INC_ARCH_WAVE600
	if ((modifyParamsOut.controlParams.uspIndex == INVALID_MU_USP_INDEX) 
        && (modifyParamsOut.controlParams.changeProbingPoint == FALSE) 
        && (modifyParamsOut.controlParams.packetType == LA_PACKET_TYPE_DATA))
	{
		CddStateIsChanged(staIndex,&modifyParamsOut);
	}
#endif

   /* Don't update statitics when we change the probing point
      since if we take this probing point only the sender will
      change back the rate before the probing, and it is not suttable to update
      statistics in Sender (since LA statistics are many) */
   if (modifyParamsOut.controlParams.changeProbingPoint == FALSE) // rate change not for probing purpse
   {
    	/*update LA statistics*/
	    updateLaStatistics(&modifyParamsOut);
   }
	
	return ratePlusOneChanged;
}
/********************************************************************************
adjustBetweenStaTcrsParams




Description:
----------
Function adjust between TCR params: Set antenna selection and power according to NSS
State: 

Input:
-----
RaTcrProbingParameters_t* pProbingParams


Output:
-------
Returns:
--------

********************************************************************************/
static void adjustBetweenStaTcrsParams(StaId staIndex, Bandwidth_e bandwidth, LaTcrModificationStruct_t* pModificationParamsIn,  LaTcrModificationStruct_t* pModificationParamsOut)
{
	
	uint8 antennaCount;
	uint8 nss;
	int8 numOfAndToAdd;
	int8* pTcrPowerModified = &(pModificationParamsOut->tcrParams.bwDependedTcrValsTable[bandwidth].tcrPower);
	uint8 rateIndex = pModificationParamsOut->tcrParams.bwDependedTcrValsTable[bandwidth].rateindex;
	uint8* pTcrmodAntennaSelection = &(pModificationParamsOut->tcrParams.tcrGeneralVals.tcrAntSelection);
	LaPacketType_e packetType = pModificationParamsIn->controlParams.packetType;
	LaBeamformingDataBase_t* pLaBeamformingDb = &(LinkAdaptationStaDatabase[staIndex].laStationUnique.beamFormingDb);
	uint8 antennaSelectionBeforeChange = pModificationParamsOut->tcrParams.tcrGeneralVals.tcrAntSelection;
	uint8 tcrBfMode = FALSE;
	const RateObj_t* ratesTable = getRatesTable(&LinkAdaptationStaDatabase[staIndex].laStaUspCommon);
#ifdef ENET_INC_ARCH_WAVE600
	CyclicPrefixMode_e* pCpMode = &(pModificationParamsOut->tcrParams.bwDependedTcrValsTable[bandwidth].cpMode);
#endif
	
	/*Beamforming adjustment*/
	if ((BeamformingValidCheck(staIndex,rateIndex, pLaBeamformingDb->bfWorkingPointState)!= BF_MODE_VALID_AT_THE_REQUIRED_RATE) && (pModificationParamsIn->controlParams.packetType == LA_PACKET_TYPE_DATA))
	{
		/*If number of NSS not match to BF mode, chage BF mode to flat, set antennas to the maximum availabe*/
		*pTcrmodAntennaSelection = AntennaSelectionGetDefaultBitmap();
		setNoBfMode(pModificationParamsIn,pModificationParamsOut);
		if (pModificationParamsIn->controlParams.changeProbingPoint == FALSE)
		{
			/*Change BF state only when changing wp rate*/
			BeamformingResetWorkingPointState(staIndex);
		}

	}
	/*Antenna selection adjustment*/
	/* Set antenna selection according to rate - 
		if required nss higher than the current activated antenna, take the maximum available antennas*/
	antennaCount = AntennaSelectionCalcAntennaCount(*pTcrmodAntennaSelection);
	nss = ratesTable[rateIndex].numberOfNss;
	numOfAndToAdd = nss - (antennaCount - 1);
	if (numOfAndToAdd > 0)
	{
		/*If NSS grater than number of antennas, set antennas to the maximum availabe*/
		*pTcrmodAntennaSelection = AntennaSelectionGetDefaultBitmap();
	}
	/*Validate that new number of antennas macth to NSS*/
	DEBUG_ASSERT(AntennaSelectionCalcAntennaCount(*pTcrmodAntennaSelection) >= (nss + 1));
	if(antennaSelectionBeforeChange != pModificationParamsOut->tcrParams.tcrGeneralVals.tcrAntSelection)
	{
		/*Antenna selection changed at working point, update antenna selection module*/
		if (pModificationParamsIn->controlParams.changeProbingPoint == FALSE)
		{
			/*If working point changed, update antenna selection module*/
			AntennaSelectionStaNumOfAntsChanged(staIndex, *pTcrmodAntennaSelection);
		}
	}
	if(pModificationParamsIn->controlParams.powerChanged == FALSE)
	{
		tcrBfMode = FALSE;
		/*Power was not changed by power adaptation loop*/
		if(pModificationParamsOut->tcrParams.bwDependedTcrValsTable[bandwidth].tcrBfMode == TX_BF_BEAMFORMING)
		{
			tcrBfMode = TRUE;
		}
		*pTcrPowerModified = CalcLimitsAndGetStaTcrPowerVal(staIndex, bandwidth, rateIndex, TRUE, packetType, *pTcrmodAntennaSelection, TRUE,tcrBfMode);
#ifdef LINK_ADAPTATION_LOGS		
		ILOG0_D("pTcrPowerModified = %d", *pTcrPowerModified);
#endif
	}
	/* LDPC Adjustments - don't use LDPC in 11A/G/B */
	pModificationParamsOut->tcrParams.tcrGeneralVals.ldpcMode = getLdpcCapability(staIndex,ratesTable[rateIndex].laPhyMode);
	
#ifdef ENET_INC_ARCH_WAVE600
	/*  Go back to default cp mode in case of unspported cp mode for HE (1X LTF) : can be caused when rate is changed from non-HE to HE*/
	if ((ratesTable[rateIndex].laPhyMode == LA_PHY_MODE_HE) && ((*pCpMode == CP_MODE_SHORT_CP_SHORT_LTF) || (*pCpMode == CP_MODE_MED_CP_SHORT_LTF)))
	{
		/* Go back to default cp mode */
		*pCpMode = CP_MODE_SHORT_CP_MED_LTF;
	}
#endif
}

/**********************************************************************************

linkAdaptationSetChannelReq 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void  linkAdaptationSetBfCalStatus(K_MSG *psMsg )
{
	LaBfCalStatusChanged_t* calStatusMsg = (LaBfCalStatusChanged_t*)pK_MSG_DATA(psMsg);
	
	BeamFormingUpdateCalStatus(calStatusMsg->calibrationPass, calStatusMsg->calibrationPass);
	
}

	
/**********************************************************************************

linkAdaptationSetBfActivationBitmap 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void  linkAdaptationSetBfActivationBitmap(K_MSG *psMsg )
{
	laBfPsdActBitmapMsgParams_t* activationBitmapMsg = (laBfPsdActBitmapMsgParams_t*)pK_MSG_DATA(psMsg);
	
	BeamformingSetActivationBitmap(activationBitmapMsg->activationBitmap);

}


/**********************************************************************************
linkAdaptationProcessBaaReportQueue


Description:
------------

Input: 
-----
		
Output:
-------

Returns:
--------
	void - 
	
**********************************************************************************/
static void linkAdaptationProcessBaaReportQueue(K_MSG *psMsg)
{
	BAA_PROCESS_BAA_REPORT_QUEUE(psMsg);
	/*BAA fifo process has ended, unmask IRQ*/
	EventManager_TurnOnEvent(EVENT_ID_BAA_REPORTS_FIFO_NOT_EMPTY);
}

void linkAdaptationProcessBaaReport(BaaRateAdaptiveFullFifo_t* pBaaReport)
{
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 
    uint8 planIndex   = pBaaReport->commonReport.planIndex;
	StaId staIndex    = pBaaReport->userReport.txQStaId;
	uint8 uspIndex = INVALID_MU_USP_INDEX;
	bool  isHeGroup = FALSE;
	StaId staOrGroupIndex = staIndex;
	StaId staIndexFromLaGroupDb = staIndex;
	
	if (pBaaReport->commonReport.txqGroupId == HW_TX_Q_TYPE_STA_TID)
	{
#ifdef WORKAROUND_FOR_HW_BUG_IN_PS_SETTING_IN_TWT
        TxSelector_ResetPsRequestForTwt(staIndex);
#endif
		if (pBaaReport->commonReport.reportType == SEQ_REPORT_TYPE_SEQUENCER_VHT_MU)
		{
			staOrGroupIndex = planIndex; 
			uspIndex = pBaaReport->userReport.txUserId;
			staIndexFromLaGroupDb = LinkAdaptationVhtGroupDatabase[staOrGroupIndex].laVhtGroupUnique.groupStationIndexes[uspIndex];
			if(linkAdaptationIsGroupActive(staOrGroupIndex, FALSE) == FALSE) /*Ignore reports of groups which have already been removed*/ 
			{
				return;
			}
		}
#ifdef ENET_INC_ARCH_WAVE600
		else if (pBaaReport->commonReport.reportType == SEQ_REPORT_TYPE_SEQUENCER_HE_MU)
		{
			staOrGroupIndex = getLaPhaseIdFromPlanIndex(planIndex, pBaaReport->commonReport.phaseIndex);
			uspIndex = pBaaReport->userReport.txUserId;
			isHeGroup = TRUE;
			staIndexFromLaGroupDb = LinkAdaptationHePhaseDatabase[staOrGroupIndex].laHeGroupUnique.groupStationIndexes[uspIndex];			
			if(linkAdaptationIsGroupActive(staOrGroupIndex, TRUE) == FALSE) /*Ignore reports of groups which have already been removed*/ 
			{
				return;
			}
		}
#endif
		updateLaDbDistributionParam(&laDbDistributionParameter,staOrGroupIndex, uspIndex, isHeGroup);
		/*Process current BA report*/
		MEMCPY (&CurrentBaaReport,pBaaReport, sizeof(BaaRateAdaptiveFullFifo_t));
		updateMgmtWithinAwindow(pBaaReport,&laDbDistributionParameter);

		/*For now we process only data packets! mangement packet handling will be defined!!*/
		if ((pBaaReport->commonReport.pdType == PD_TYPE_DATA) || (pBaaReport->commonReport.pdType == PD_TYPE_DATA_WPA_PT))
		{			
			if(uspIndex == INVALID_MU_USP_INDEX) //pBaaReport->ReportType== BAA_REPORT_TYPE_SU)
			{
				DEBUG_ASSERT(staOrGroupIndex < HW_NUM_OF_STATIONS);
				if (StaDbSwEntries[staOrGroupIndex].state != STA_STATE_CONNECTED)
				{
					return; 
				}
				// update the TX time per station statistics
	            LinkAdaptationStatistics.totalTxTime[staOrGroupIndex] += (uint32)((pBaaReport->commonReport.duration) << BAA_SHIFT_TO_1_MICRO_RESOLUTION); //LINK_ADAPTATION_SU_TX_TIME (real)
			}
			if(staIndexFromLaGroupDb != staIndex)
			{
				return;
			}
			laStateMachineProcessBaaReport(&laDbDistributionParameter,&CurrentBaaReport, &LastBaaReport);
		}
		MEMCPY (&LastBaaReport,&CurrentBaaReport, sizeof(BaaRateAdaptiveFullFifo_t));
	}
}

/**********************************************************************************

linkAdaptationSetPowerAdaptationPsdTables 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

static void  linkAdaptationSetPowerAdaptationPsdTables(K_MSG *psMsg )
{

	laSetPowerAdaptationPsdTablesMsg_t *powerAdaptationPsdMsg = (laSetPowerAdaptationPsdTablesMsg_t *)pK_MSG_DATA(psMsg);

	uint16 rows = powerAdaptationPsdMsg->psdShramAddress[LA_PSD_NUM_OF_ROWS_INDEX];
	uint16 cols = powerAdaptationPsdMsg->psdShramAddress[LA_PSD_NUM_OF_COLS_INDEX];
	uint16 tableSize = rows*cols;
	int8 tableScratchpad[POWER_ADAPTATION_MAX_TABLE_SIZE];
	uint16 i = 0;

#ifdef LINK_ADAPTATION_LOGS	
//	ILOG0_DDD("linkAdaptationSetPowerAdaptationPsdTables, tableType = %d cols %d rows %d", powerAdaptationPsdMsg->tableType,cols,rows);
#endif
	DEBUG_ASSERT(tableSize <= POWER_ADAPTATION_MAX_TABLE_SIZE);

	//ASSERT(powerAdaptationPsdMsg->tableType !=POWER_OFFSET_HIGH_LOW_TABLE);

	for (i = 0; i < tableSize; i++)
	{
		tableScratchpad[i] = powerAdaptationPsdMsg->psdShramAddress[LA_PSD_TABLE_START_INDEX + i];
	}
	SetPowerTablesFromPsd(tableSize,powerAdaptationPsdMsg->tableType,tableScratchpad);
	
	OSAL_SEND_MESSAGE(UMI_MC_MAN_PLATFORM_TABLE_CFM, TASK_UM_IF_TASK, powerAdaptationPsdMsg->psMsg, powerAdaptationPsdMsg->psMsg->header.vapId);
}


/**********************************************************************************

linkAdaptationSendTrainingInfo 


Description:
------------
Handle a request from the Training manager to send active station bitmap that can participate in training


Input: 
-----


Returns:
--------
	void - 
	
**********************************************************************************/
static void  linkAdaptationSendTrainingInfo(K_MSG *psMsg )
{
	K_MSG *trainingManagerMessage	= NULL; 
	TrainingManagerLinkAdaptiveInfoCfm_t *trainingManagerParameters;
#ifdef TRAINING_FIRST_PHASE_POOL
	Bandwidth_e maximalWorkingBw[HW_NUM_OF_VAPS];
#endif //TRAINING_FIRST_PHASE_POOL

	trainingManagerMessage = OSAL_GET_MESSAGE(sizeof(TrainingManagerLinkAdaptiveInfoCfm_t));
	trainingManagerParameters = (TrainingManagerLinkAdaptiveInfoCfm_t *)pK_MSG_DATA(trainingManagerMessage);

	//zero staBitmap
	memset32(trainingManagerParameters, 0, CONVERT_BYTES_TO_WORDS(sizeof(TrainingManagerLinkAdaptiveInfoCfm_t)));

	memcpy32((void*)&(trainingManagerParameters->activeStaBitmap),(void*)muCandidateStaBitmap,SIZE_OF_STATIONS_BITMAP_IN_WORDS);

#ifdef TRAINING_FIRST_PHASE_POOL
	getMaximalWorkingBW(maximalWorkingBw);
	MEMCPY((void*)(trainingManagerParameters->maxWorkingBandwidth),(void*)maximalWorkingBw, sizeof(maximalWorkingBw));
#endif //TRAINING_FIRST_PHASE_POOL

	OSAL_SEND_MESSAGE(TRAINING_MANAGER_LA_INFO_CFM, TASK_GROUP_MANAGER, trainingManagerMessage, psMsg->header.vapId);
}



/***************************************************************************
**
** NAME         Lmmain_HandleGenericReq
**
** PARAMETERS   ptK_MSG      - pointer to kernel message
**
** DESCRIPTION  This routine handles the LM_GENERIC_REQ.
**
****************************************************************************/
static void linkAdaptationHandleGenericReq(K_MSG* msg)
{
	lmGenericMsgType_t* lmGenericMsgType = (lmGenericMsgType_t*)pK_MSG_DATA(msg);

	switch(lmGenericMsgType->data1)
	{
		case 1:
		{
			/* Handle HW Semaphore test */
#if defined (HW_SEMAPHORE_DEBUG)
			lmmain_HwSemaphoreTest();
#endif
			break;
		}
		case 2:
			/* Handle Action frame BEFORE Add STA */
			linkAdaptationOpertingModeNotificationSimulateActionFrameBeforeAddSta();
			break;
		case 3:
			/* Handle Action frame AFTER Add STA */
			linkAdaptationOpertingModeNotificationSimulateActionFrameAfterAddSta(lmGenericMsgType->data2, lmGenericMsgType->data3);
			break;
		case 4:
			/* Handle Action frame sent via RX Manager (see rxManagerHandleOmnFrame)*/
			/* Nothing to do */
			break;
		case 5:
			// set transmittion time to specific station
			linkAdaptationSetTransmissionTimeLimit(lmGenericMsgType->data2, lmGenericMsgType->data3);
			break;
		case 6:
			// set QAMplus counters thresholds: trialThresh, inactiveTrialThresh
			QAMplus_SetThresh((uint16)lmGenericMsgType->data2, (uint16)lmGenericMsgType->data3);
			break;
		case 7:
			// set QAMplus counter threshold: supportedThresh
			QAMplus_DebugSetSupportedThresh((uint8)lmGenericMsgType->data2, (uint16)lmGenericMsgType->data3);
			break;
		case 8:
			// get QAMplus counters thresholds
			QAMplus_GetThresh((uint8)lmGenericMsgType->data2);
			break;
		case 9:
			// enable/disable QAMplus 
			QAMplus_Enable((bool)lmGenericMsgType->data2);
			break;
		case 10:
			// enable/disable extra logs 
			enableExtraLogs = lmGenericMsgType->data2;
			break;
#ifdef ENET_INC_ARCH_WAVE600
		case 11:
			RficDriver_dumpRegs();
			break;
		case 12:
			PhyTestBus_CdbSetMode(lmGenericMsgType->data2,lmGenericMsgType->data3);
			break;
#endif
#ifdef BSRC_ARTIFICIAL_UPDATE_FOR_UL
		case 13:
			Bsrc_SetTfFixedInterval(lmGenericMsgType->data2, lmGenericMsgType->data3);
			break;
#endif
		default:
	        //FATAL("[Lmmain_HandleGenericReq] Unknown message type");
	        break;
			
	}

	
}

/**********************************************************************************

LinkAdaptationSetStaDataBwLimit 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void LinkAdaptationSetStaDataBwLimit(StaId staIndex,Bandwidth_e bandwidth, bool changeWorkingPoint)
{
	uint8 wpTcrRateIndex = GetStaWpRateIndexFromHwTcr(staIndex,bandwidth);
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter;

#ifdef LINK_ADAPTATION_LOGS		
	ILOG0_DDD("LinkAdaptationSetStaDataBwLimit. staId %d bw %d changeWp %d", staIndex, bandwidth, changeWorkingPoint);
#endif
	updateLaDbDistributionParam(&laDbDistributionParameter,staIndex,INVALID_MU_USP_INDEX, FALSE);	
	if (changeWorkingPoint == TRUE)
	{
		updateOverridePendingDb(OVERRIDE_BW, bandwidth, &laDbDistributionParameter);
		updateOverridePendingDb(OVERRIDE_RATE_INDEX, wpTcrRateIndex, &laDbDistributionParameter);		
		DynamicTxop_RateOrBwIsChanged(staIndex, wpTcrRateIndex, bandwidth);
	}
	else
	{
		SetStaDataBwLimitInHwDb(staIndex,bandwidth,changeWorkingPoint);
	}
}

/**********************************************************************************

ExtractHighestPhyModeFromRaMask 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
PhyMode_e ExtractHighestPhyModeFromRaMask(RateMask_t raMask, bool isHe)
{
	PhyMode_e returnPhyMode = PHY_MODE_LAST;
	RateMask_t dummyMask;

	RateMask_t phyModeRatesMask[PHY_MODE_LAST] =
	{
		LA_PHY_11AG_RATES_MASK,
		LA_PHY_11B_RATES_MASK,
		LA_PHY_11N_RATES_MASK,
		LA_PHY_11AC_RATES_MASK,
#ifdef ENET_INC_ARCH_WAVE600
		LA_PHY_11AX_RATES_MASK
#endif
	};
	
#ifdef ENET_INC_ARCH_WAVE600
	if (isHe)
	{
		if (andOperator64Bit(raMask.raIndexMask64bit, phyModeRatesMask[PHY_MODE_11AX_SU].raIndexMask64bit, dummyMask.raIndexMask64bit) != 0)
		{
			returnPhyMode = PHY_MODE_11AX_SU;
		}
		else if (andOperator64Bit(raMask.raIndexMask64bit, phyModeRatesMask[PHY_MODE_11AG].raIndexMask64bit, dummyMask.raIndexMask64bit) != 0)
		{
			returnPhyMode = PHY_MODE_11AG;

		}
		else if (andOperator64Bit(raMask.raIndexMask64bit, phyModeRatesMask[PHY_MODE_11B].raIndexMask64bit, dummyMask.raIndexMask64bit) != 0)
		{
			returnPhyMode = PHY_MODE_11B;
		}
		else
		{
			DEBUG_ASSERT(0); //mask is empty
		}

	}
	else
#endif
	{
		if (andOperator64Bit(raMask.raIndexMask64bit, phyModeRatesMask[PHY_MODE_11AC].raIndexMask64bit, dummyMask.raIndexMask64bit) != 0)
		{
			returnPhyMode = PHY_MODE_11AC;
		}
		else if (andOperator64Bit(raMask.raIndexMask64bit, phyModeRatesMask[PHY_MODE_11N].raIndexMask64bit, dummyMask.raIndexMask64bit) != 0)
		{
			returnPhyMode = PHY_MODE_11N;
		}
		else if (andOperator64Bit(raMask.raIndexMask64bit, phyModeRatesMask[PHY_MODE_11AG].raIndexMask64bit, dummyMask.raIndexMask64bit) != 0)
		{
			returnPhyMode = PHY_MODE_11AG;

		}
		else if (andOperator64Bit(raMask.raIndexMask64bit, phyModeRatesMask[PHY_MODE_11B].raIndexMask64bit, dummyMask.raIndexMask64bit) != 0)
		{
			returnPhyMode = PHY_MODE_11B;
		}
		else
		{
			DEBUG_ASSERT(0); //mask is empty
		}
	}

	return returnPhyMode;
}
/**********************************************************************************

ChangeStaToSteadyStateConfigurationParams 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/

void ChangeStaToSteadyStateConfigurationParams (LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, bool resetCounters)
{
	if (laDbDistributionParameter->laStaGroupCommon->pLinkAdaptationConfigurationParams != &LinkAdaptationConfigParamsSteadyState)
	{
		laDbDistributionParameter->laStaGroupCommon->pLinkAdaptationConfigurationParams = &LinkAdaptationConfigParamsSteadyState;
		laDbDistributionParameter->laStaUspCommon->probingPointValidationCounter = 0;
		if (resetCounters == TRUE)
		{
			rateAdaptationResetCountersAndThresholds(laDbDistributionParameter); 
		}
		// updated QAMplus that LA enterd Steady State
		laDbDistributionParameter->laStationUnique->QAMplusStaDb.laSteadyStateEnable = TRUE;

#ifdef QAM_PLUS_DEBUG
		ILOG0_V("[ChangeStaToSteadyStateConfigurationParams]");
#endif
	}
	
}
/**********************************************************************************

updateLaDbDistributionParam 


Description:
------------


Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
void updateLaDbDistributionParam (LinkAdaptationDatabaseDistributionPack_t *pDistParam,StaId stationOrGroupIndex,uint8 uspIndex, bool isHeGroup)
{
	pDistParam->stationOrGroupIndex = stationOrGroupIndex; 
	pDistParam->uspIndex = uspIndex;
	pDistParam->laGroupUnique = NULL; 
	pDistParam->laVhtGroupUnique = NULL; 
	pDistParam->laHeGroupUnique = NULL; 
	pDistParam->laStaGroupCommon = NULL;
	pDistParam->laStaUspCommon= NULL;
	pDistParam->laStationUnique= NULL;
	


	if (stationOrGroupIndex != INVALID_STA_INDEX)
	{
		if(uspIndex == INVALID_MU_USP_INDEX)
		{
			pDistParam->laGroupUnique = NULL; 
			pDistParam->laVhtGroupUnique = NULL; 
			pDistParam->laHeGroupUnique = NULL; 
#ifndef ENET_INC_ARCH_WAVE600
			ASSERT(stationOrGroupIndex < HW_NUM_OF_STATIONS); //KW_FIX_FW_G
#endif
			pDistParam->laStaGroupCommon = &(LinkAdaptationStaDatabase[stationOrGroupIndex].laStaGroupCommon);
			pDistParam->laStaUspCommon= &(LinkAdaptationStaDatabase[stationOrGroupIndex].laStaUspCommon);
			pDistParam->laStationUnique= &(LinkAdaptationStaDatabase[stationOrGroupIndex].laStationUnique);
		}
		else //MU
		{
#ifdef ENET_INC_ARCH_WAVE600
			if (isHeGroup)
			{
				ASSERT(stationOrGroupIndex < NUM_OF_LA_HE_MU_DB_ENTRIES);
				ASSERT((uspIndex < MAX_USP_IN_HE_GROUP) || (uspIndex == DONT_CARE_MU_USP_INDEX));
				pDistParam->laStationUnique = NULL; 
				pDistParam->laVhtGroupUnique = NULL; 
				pDistParam->laGroupUnique = &(LinkAdaptationHePhaseDatabase[stationOrGroupIndex].laGroupUnique);
				pDistParam->laStaGroupCommon = &(LinkAdaptationHePhaseDatabase[stationOrGroupIndex].laStaGroupCommon);
				pDistParam->laHeGroupUnique = &(LinkAdaptationHePhaseDatabase[stationOrGroupIndex].laHeGroupUnique); 
				if (uspIndex != DONT_CARE_MU_USP_INDEX)
				{
					pDistParam->laStaUspCommon = &(LinkAdaptationHePhaseDatabase[stationOrGroupIndex].laStaUspCommon[uspIndex]);
				}
				else
				{
					pDistParam->laStaUspCommon = NULL;
				}
			}
			else
#endif
			{			
				DEBUG_ASSERT((stationOrGroupIndex < TX_MU_GROUPS) && (uspIndex < MAX_USP_IN_VHT_GROUP)); //KW_FIX_FW_G
				pDistParam->laStationUnique = NULL; 
				pDistParam->laHeGroupUnique = NULL; 
				pDistParam->laVhtGroupUnique = &(LinkAdaptationVhtGroupDatabase[stationOrGroupIndex].laVhtGroupUnique);
			
				pDistParam->laGroupUnique = &(LinkAdaptationVhtGroupDatabase[stationOrGroupIndex].laGroupUnique);
				pDistParam->laStaGroupCommon= &(LinkAdaptationVhtGroupDatabase[stationOrGroupIndex].laStaGroupCommon);
				pDistParam->laStaUspCommon= &(LinkAdaptationVhtGroupDatabase[stationOrGroupIndex].laStaUspCommon[uspIndex]);
			}
		}
	}
}

#define MU_DEFAULT_POWER 46 // use default power of 23 dbm
static void linkAdaptationSetHwGroupDbCommon(uint8 groupId,StaId participatingStations[])
{
	uint8 uspIndex;
	Bandwidth_e currentBw;
	Bandwidth_e lowestBw = BANDWIDTH_EIGHTY;
	uint8 activatedAntennas; 
	int8 muMimoPowerLimit;
	
#ifdef ENET_INC_ARCH_WAVE600
	MuGrpDb_t* groupDbEntry = &(GroupDbHwEntries[groupId]);
#else
	Tcr2_t* pTcr2 = NULL;
	Tcr3_t* pTcr3 = NULL;
	Tcr0_t* pTcr0Data = NULL;
	CddValues_t cddValues;
	MuGrpDbCommon_t* groupDbEntry = &(GroupDbHwEntries[groupId]);
#endif
	
	activatedAntennas = AntennaSelectionGetActivatedAntennasCount();
	
	
#ifdef ENET_INC_ARCH_WAVE600
	groupDbEntry->common.rtsCtsTxMethod = RTS_CTS_TX_METHOD_NO_RTS_CTS; 
	//groupDbEntry->groupAntProbingInd = RTS_CTS_TX_METHOD_NO_RTS_CTS; 
	groupDbEntry->common.altRateReasonFastProbing = RTS_CTS_TX_METHOD_NO_RTS_CTS; 
	groupDbEntry->common.altRateReasonSlowProbing = RTS_CTS_TX_METHOD_NO_RTS_CTS; 
#else
	groupDbEntry->rtsCtsTxMethod = RTS_CTS_TX_METHOD_NO_RTS_CTS; 
	groupDbEntry->groupAntProbingInd = RTS_CTS_TX_METHOD_NO_RTS_CTS; 
	groupDbEntry->groupAltRateReasonFastProbing = RTS_CTS_TX_METHOD_NO_RTS_CTS; 
	groupDbEntry->groupAltRateReasonSlowProbing = RTS_CTS_TX_METHOD_NO_RTS_CTS; 
#endif
	
#ifdef ENET_INC_ARCH_WAVE600
	groupDbEntry->common.tcr120MhzDataScp = ENABLED;
	groupDbEntry->common.tcr140MhzDataScp = ENABLED;
	groupDbEntry->common.tcr180MhzDataScp = ENABLED;
	groupDbEntry->common.tcr1160MhzDataScp = ENABLED;
	groupDbEntry->wp.tcr120MhzDataScp = ENABLED;
	groupDbEntry->wp.tcr140MhzDataScp = ENABLED;
	groupDbEntry->wp.tcr180MhzDataScp = ENABLED;
	groupDbEntry->wp.tcr1160MhzDataScp = ENABLED;
	
#else
	groupDbEntry->scp20Mhz = ENABLED;
	groupDbEntry->scp40Mhz = ENABLED;
	groupDbEntry->scp80Mhz = ENABLED;
	groupDbEntry->wpScp20Mhz = ENABLED;
	groupDbEntry->wpScp40Mhz = ENABLED;
	groupDbEntry->wpScp80Mhz = ENABLED;
#endif
	
	
	for(uspIndex = 0; uspIndex < MAX_USP_IN_VHT_GROUP; uspIndex++)
	{
		if(participatingStations[uspIndex] != INVALID_STA_INDEX)
		{
			currentBw = GetDataBwLimit(participatingStations[uspIndex],INVALID_MU_USP_INDEX, FALSE);
			if(currentBw < lowestBw)
			{
				lowestBw = currentBw; 
			}
		}
	}
	
	//tcr0 for 20mhz	

#ifdef ENET_INC_ARCH_WAVE600
	groupDbEntry->common.dataBwLimit = lowestBw; 
	groupDbEntry->common.tcr0Data20MhzPhyMode = PHY_MODE_11AC;
	groupDbEntry->common.tcr0Data40MhzPhyMode = PHY_MODE_11AC;
	groupDbEntry->common.tcr0Data80MhzPhyMode = PHY_MODE_11AC;
	groupDbEntry->common.tcr0Data160MhzPhyMode = PHY_MODE_11AC;
	groupDbEntry->common.tcr0Data20MhzCbw = BANDWIDTH_TWENTY;
	groupDbEntry->common.tcr0Data40MhzCbw = BANDWIDTH_FOURTY;
	groupDbEntry->common.tcr0Data80MhzCbw = BANDWIDTH_EIGHTY;
	groupDbEntry->common.tcr0Data160MhzCbw = BANDWIDTH_ONE_HUNDRED_SIXTY;
	groupDbEntry->common.tcr0DataAntennaSelection = AntennaSelectionGetDefaultBitmap();
	groupDbEntry->common.tcr2DataTxbf = TX_BF_BEAMFORMING;
	groupDbEntry->common.tcr0DataAnt0Boost = 0;
	groupDbEntry->common.tcr0DataAnt1Boost = 0;
	groupDbEntry->common.tcr0DataAnt2Boost = 0;
	groupDbEntry->common.tcr0DataAnt3Boost = 0;
	groupDbEntry->common.tcr0DataAnt4Boost = 0;
	groupDbEntry->common.tcr0DataAnt5Boost = 0;
	groupDbEntry->common.tcr0DataAnt6Boost = 0;
	groupDbEntry->common.tcr0DataAnt7Boost = 0;
	groupDbEntry->common.tcr1BwChange = DISABLED;
	groupDbEntry->common.tcr120MhzDataSmoothing = DISABLED;
	groupDbEntry->common.tcr140MhzDataSmoothing = DISABLED;
	groupDbEntry->common.tcr180MhzDataSmoothing = DISABLED;
	groupDbEntry->common.tcr1160MhzDataSmoothing = DISABLED;
	groupDbEntry->common.dynamicBwEnable = DISABLED;
	groupDbEntry->common.tcr2DataTxbf = TX_BF_BEAMFORMING;
	groupDbEntry->common.tcr0Data20MhzTxLoopMode = TX_LOOP_MODE_OPEN_LOOP;	
	groupDbEntry->common.tcr0Data40MhzTxLoopMode = TX_LOOP_MODE_OPEN_LOOP;
	groupDbEntry->common.tcr0Data80MhzTxLoopMode = TX_LOOP_MODE_OPEN_LOOP;
	groupDbEntry->common.tcr0Data160MhzTxLoopMode = TX_LOOP_MODE_OPEN_LOOP;

	//set the rf power

	if(muFixedPowerVal == INVALID_MU_POWER)
	{
		muMimoPowerLimit = getMuPowerLimit(BANDWIDTH_TWENTY);
		groupDbEntry->common.tcr0Data20MhzRfPower = MIN(muMimoPowerLimit, MU_DEFAULT_POWER);

		muMimoPowerLimit = getMuPowerLimit(BANDWIDTH_FOURTY);
		groupDbEntry->common.tcr0Data40MhzRfPower = MIN(muMimoPowerLimit, MU_DEFAULT_POWER);

		muMimoPowerLimit = getMuPowerLimit(BANDWIDTH_EIGHTY);
		groupDbEntry->common.tcr0Data80MhzRfPower = MIN(muMimoPowerLimit, MU_DEFAULT_POWER);

		muMimoPowerLimit = getMuPowerLimit(BANDWIDTH_ONE_HUNDRED_SIXTY);
		groupDbEntry->common.tcr0Data160MhzRfPower = MIN(muMimoPowerLimit, MU_DEFAULT_POWER);		
	}
	else
	{
		groupDbEntry->common.tcr0Data20MhzRfPower = muFixedPowerVal; 
		groupDbEntry->common.tcr0Data40MhzRfPower = muFixedPowerVal; 
		groupDbEntry->common.tcr0Data80MhzRfPower = muFixedPowerVal; 
		groupDbEntry->common.tcr0Data160MhzRfPower = muFixedPowerVal; 
	}

	// init wp values with current values from common section
	memcpy32(&(groupDbEntry->wp.word5), &(groupDbEntry->common.word6), 2);
#else
	groupDbEntry->dataBwLimit = lowestBw;
	
	pTcr0Data = (Tcr0_t*)&(groupDbEntry->word7);
	pTcr0Data->phyMode = PHY_MODE_11AC; 
	pTcr0Data->bw = BANDWIDTH_TWENTY;
		
	if(muFixedPowerVal == INVALID_MU_POWER)
	{
		muMimoPowerLimit = getMuPowerLimit(BANDWIDTH_TWENTY);
		pTcr0Data->rfPower = MIN(muMimoPowerLimit,MU_DEFAULT_POWER);
	}
	else
	{
		pTcr0Data->rfPower = muFixedPowerVal; 
	}
	pTcr0Data->bfMode = TX_BF_BEAMFORMING;		  // according to sas
	pTcr0Data->antennaSelection = AntennaSelectionGetDefaultBitmap();

	//tcr0 for 40mhz
	
	pTcr0Data = (Tcr0_t*)&(groupDbEntry->word8);
	pTcr0Data->phyMode = PHY_MODE_11AC; 
	pTcr0Data->bw = BANDWIDTH_FOURTY;
	if(muFixedPowerVal == INVALID_MU_POWER)
	{
		muMimoPowerLimit = getMuPowerLimit(BANDWIDTH_FOURTY);
		pTcr0Data->rfPower =  MIN(muMimoPowerLimit,MU_DEFAULT_POWER);
	}
	else
	{
		pTcr0Data->rfPower = muFixedPowerVal; 
	}
	
	pTcr0Data->bfMode = TX_BF_BEAMFORMING;		  // according to sas
	pTcr0Data->antennaSelection = AntennaSelectionGetDefaultBitmap();

	//tcr0 for 80mhz	
	pTcr0Data = (Tcr0_t*)&(groupDbEntry->word9);
	pTcr0Data->phyMode = PHY_MODE_11AC; 
	pTcr0Data->bw = BANDWIDTH_EIGHTY;

	if(muFixedPowerVal == INVALID_MU_POWER)
	{
		muMimoPowerLimit = getMuPowerLimit(BANDWIDTH_EIGHTY);
		pTcr0Data->rfPower =  MIN(muMimoPowerLimit,MU_DEFAULT_POWER);
	}
	else
	{
		pTcr0Data->rfPower = muFixedPowerVal; 
	}
	
	pTcr0Data->bfMode = TX_BF_BEAMFORMING;		  // according to sas
	pTcr0Data->antennaSelection = AntennaSelectionGetDefaultBitmap();

	CddfillCddValues(&cddValues, CDD_DEFAULT_INDEX, activatedAntennas);

	/*Those fields are relevant for all BWs*/

	/* DW10 - TCR2[23:0]  */
	pTcr2 = (Tcr2_t*)&(groupDbEntry->word10);
	pTcr2->cddAnt1 = cddValues.cddAnt1;
	pTcr2->cddAnt2 = cddValues.cddAnt2;	
	pTcr2->cddAnt3 = cddValues.cddAnt3;
	pTcr2->bwChange = DISABLED; 
	pTcr2->ant0Boost = 0;
	pTcr2->ant1Boost = 0;
	pTcr2->ant2Boost = 0;
	pTcr2->ant3Boost = 0;

	/* DW19 - TCR3 fixed values */
	pTcr3 = (Tcr3_t*)&(groupDbEntry->word19);
	pTcr3->bfSmoothing = DISABLED; // specified in SAS to deafult value 0.
	pTcr3->dynamicBw = DISABLED; // specified in SAS to deafult value 0.

	/* DW11,12,13, 14 - WP TCR0[31:0] 20/40/80 MHZ Data, WP TCR2 */ 
	memcpy32(&(groupDbEntry->word11), &(groupDbEntry->word7), 4);
#endif //ENET_INC_ARCH_WAVE600
}

static void linkAdaptationSetHwGroupDb(uint8 groupId,uint8 uspIdnex,StaId stationIndex)
{

#ifndef ENET_INC_ARCH_WAVE600
	Tcr1_t* pTcr1 = NULL;
#endif

	DEBUG_ASSERT(stationIndex < HW_NUM_OF_STATIONS);

#ifdef ENET_INC_ARCH_WAVE600
	GroupDbHwEntries[groupId].common.maxNssNdp =  CONVERT_MAX_NUM_OF_ANTENNAS_TO_MAX_NUM_OF_NSS(AntennaSelectionGetActivatedAntennasCount());
	GroupDbHwEntries[groupId].common.tcr120MhzDataStbc = DISABLED;
	GroupDbHwEntries[groupId].common.tcr140MhzDataStbc = DISABLED;
	GroupDbHwEntries[groupId].common.tcr180MhzDataStbc = DISABLED;
	GroupDbHwEntries[groupId].common.tcr1160MhzDataStbc = DISABLED;
#endif

	switch(uspIdnex)
	{
		case 0:
#ifdef ENET_INC_ARCH_WAVE600
			GroupDbHwEntries[groupId].common.user0Tcr2DataLdpc = StaDbHwEntries[stationIndex].common.tcr2DataLdpc;
			GroupDbHwEntries[groupId].common.usp0MaxMsduAtAmsduCount = laVhtMsduInAmsdu;
#else
			GroupDbHwEntries[groupId].usp0MaxNssNdp =  AntennaSelectionGetActivatedAntennasCount() - 0x1;
			GroupDbHwEntries[groupId].usp0BaaWeightedFailMpduReference = 0; 
			GroupDbHwEntries[groupId].usp0BaaWeightedSuccessMpduReference = 0; 
			GroupDbHwEntries[groupId].usp0MaxMsduAtAmsduCount = laVhtMsduInAmsdu;
			/* DW15  TCR1[23:0] Data USP0 */
			pTcr1 = (Tcr1_t*)&(GroupDbHwEntries[groupId].word15);
			pTcr1->stbc = DISABLED; 
			pTcr1->ldpc = StaDbHwEntries[stationIndex].common.ldpcData;
#endif		
			break; 
			
		case 1:

#ifdef ENET_INC_ARCH_WAVE600
			GroupDbHwEntries[groupId].common.user1Tcr2DataLdpc = StaDbHwEntries[stationIndex].common.tcr2DataLdpc;
			GroupDbHwEntries[groupId].common.usp1MaxMsduAtAmsduCount = laVhtMsduInAmsdu;
#else
			GroupDbHwEntries[groupId].usp1MaxNssNdp = AntennaSelectionGetActivatedAntennasCount() - 0x1;
			GroupDbHwEntries[groupId].usp1BaaWeightedSuccessMpduReference = 0; 
			GroupDbHwEntries[groupId].usp1BaaWeightedFailMpduReference = 0;
			GroupDbHwEntries[groupId].usp1MaxMsduAtAmsduCount = laVhtMsduInAmsdu;
			/* DW16  TCR1[23:0] Data USP1 */
			pTcr1 = (Tcr1_t*)&(GroupDbHwEntries[groupId].word16);
			pTcr1->stbc = DISABLED; 
			pTcr1->ldpc = StaDbHwEntries[stationIndex].common.ldpcData;
#endif
			break;
			
		case 2: 
			
#ifdef ENET_INC_ARCH_WAVE600
			GroupDbHwEntries[groupId].common.user2Tcr2DataLdpc = StaDbHwEntries[stationIndex].common.tcr2DataLdpc;
			GroupDbHwEntries[groupId].common.usp2MaxMsduAtAmsduCount = laVhtMsduInAmsdu;

#else

			GroupDbHwEntries[groupId].usp2MaxNssNdp =  AntennaSelectionGetActivatedAntennasCount() - 0x1;;		
			GroupDbHwEntries[groupId].usp2BaaWeightedSuccessMpduReference = 0;
			GroupDbHwEntries[groupId].usp2BaaWeightedFailMpduReference = 0;
			GroupDbHwEntries[groupId].usp2MaxMsduAtAmsduCount = laVhtMsduInAmsdu;
			/* DW17  TCR1[23:0] Data USP2 */
			pTcr1 = (Tcr1_t*)&(GroupDbHwEntries[groupId].word17);
			pTcr1->stbc = DISABLED; 
			pTcr1->ldpc = StaDbHwEntries[stationIndex].common.ldpcData;
#endif
			break;
			
		case 3:

#ifdef ENET_INC_ARCH_WAVE600
			GroupDbHwEntries[groupId].common.user3Tcr2DataLdpc = StaDbHwEntries[stationIndex].common.tcr2DataLdpc;
			GroupDbHwEntries[groupId].common.usp3MaxMsduAtAmsduCount = laVhtMsduInAmsdu;

#else

			GroupDbHwEntries[groupId].usp3MaxNssNdp =  AntennaSelectionGetActivatedAntennasCount() - 0x1;;
			GroupDbHwEntries[groupId].usp3BaaWeightedSuccessMpduReference = 0;
			GroupDbHwEntries[groupId].usp3BaaWeightedFailMpduReference = 0;
			GroupDbHwEntries[groupId].usp3MaxMsduAtAmsduCount = laVhtMsduInAmsdu;
			/* DW18  TCR1[23:0] Data USP3 */
			pTcr1 = (Tcr1_t*)&(GroupDbHwEntries[groupId].word18);
			pTcr1->stbc = DISABLED; 
			pTcr1->ldpc = StaDbHwEntries[stationIndex].common.ldpcData;
#endif
			break;

	}

}

uint8 linkAdaptationGetVhtUspIndex(StaId staIndex,uint16 groupId)
{
	/*retrieve the group's USP bits, from the station database, then shift back and convert to usp index*/
	uint32 uspIndexPerGroup;
	uint8 uspIndex;

	uspIndexPerGroup = LinkAdaptationStaDatabase[staIndex].laStationUnique.uspIndexPerVhtGroup;
	uspIndex = uspIndexPerGroup >> (groupId << 1);
	uspIndex &= uspMaskBits;

	return uspIndex;
}

void linkAdaptationSetVhtUspIndex(StaId staIndex,uint8 groupId,uint8 uspIndex)
{
	/*retrive the group's USP bits, from the station database, then shift back and convert to usp index*/
	LinkAdaptationStaDatabase[staIndex].laStationUnique.uspIndexPerVhtGroup &= (~(uspMaskBits<<(groupId<<1)));
	LinkAdaptationStaDatabase[staIndex].laStationUnique.uspIndexPerVhtGroup |= (uspIndex<<(groupId<<1));
}

void linkAdaptationResetVhtUspIndex(StaId staIndex,uint8 groupId)
{
	/*retreive the group's USP bits, from the station database, then shift back and convert to usp index*/
	LinkAdaptationStaDatabase[staIndex].laStationUnique.uspIndexPerVhtGroup &= (~(uspMaskBits<<(groupId<<1)));
#ifndef ENET_INC_ARCH_WAVE600
	if(LinkAdaptationVhtGroupDatabase[groupId].laGroupUnique.groupState == LA_ACTIVE_GROUP_STATE)
	{
		DEBUG_ASSERT(LinkAdaptationStaDatabase[staIndex].laStationUnique.muGroupCount>0);
		LinkAdaptationStaDatabase[staIndex].laStationUnique.muGroupCount--;
		/*While STA was in a group the candidacy bit was always set, if STA does not belong to any more groups, recheck candidacy*/
		if (LinkAdaptationStaDatabase[staIndex].laStationUnique.muGroupCount == 0)
		{
			estimatorsRecheckCandidacy(staIndex);
		}
	}
#endif
}

bool linkAdaptationIsGroupActive(uint8 groupId, bool isHeGroup)
{
	bool isGroupActive = TRUE; 
	LinkAdaptationGroupState_e groupState = LA_INACTIVE_GROUP_STATE;

#ifdef ENET_INC_ARCH_WAVE600
	if (isHeGroup)
	{
		if (GET_BIT_IN_BYTE(heDlDataPhaseActiveGroupsBitmapPerBand,groupId) != 0) // group is active at the current band
		{
			groupState = LinkAdaptationHePhaseDatabase[groupId].laGroupUnique.groupState;
		}
	}
	else
#endif
	{
		if (GET_BIT_IN_BYTE(VhtGroupActiveGroupsBitmap,groupId) != 0) // group is active at the current band
		{
			groupState = LinkAdaptationVhtGroupDatabase[groupId].laGroupUnique.groupState;
		}
	}
	
	if (groupState == LA_INACTIVE_GROUP_STATE)
	{
		isGroupActive = FALSE; 
	}
	return isGroupActive;
}

static void linkAdaptationFillAllGroupMarks(uint8* groupMarks)
{
	uint8 groupId; 
	uint8 groupGrade;
	for(groupId = 0; groupId < GROUP_MANAGER_MAX_NUMBER_OF_GROUPS; groupId++)
	{
#ifndef ENET_INC_ARCH_WAVE600
		ASSERT(groupId < TX_MU_GROUPS); //KW_FIX_FW_G
#endif
		groupGrade = INVALID_GROUP_MARKS; 
		if(LinkAdaptationVhtGroupDatabase[groupId].laGroupUnique.groupState !=LA_INACTIVE_GROUP_STATE) 
		{
			/* Get station's grade*/
			groupGrade = AlphaFilter_GetFilterResult(&(LinkAdaptationVhtGroupDatabase[groupId].laStaGroupCommon.wpAverageGoodPut));
		}
		groupMarks[groupId] = groupGrade; 
	}
}

static void linkAdaptationFillGroupUspsSUMarks(uint8* uspsMarks,uint8 groupId)
{
	uint8 uspIndex=0; 
	uint8 stationGrade;
	StaId stationIndex;
	
	ASSERT(LinkAdaptationVhtGroupDatabase[groupId].laGroupUnique.groupState != LA_INACTIVE_GROUP_STATE) 
	for(uspIndex = 0; uspIndex < GROUP_MANAGER_MAX_NUMBER_OF_STATIONS_IN_GROUP; uspIndex++)
	{
		stationIndex = LinkAdaptationVhtGroupDatabase[groupId].laVhtGroupUnique.groupStationIndexes[uspIndex];
		if(stationIndex != INVALID_STA_INDEX)
		{
			/* Get station's grade*/
			ASSERT(stationIndex < HW_NUM_OF_STATIONS); //KW_FIX_FW_G
			stationGrade = AlphaFilter_GetFilterResult(&(LinkAdaptationStaDatabase[stationIndex].laStaGroupCommon.wpAverageGoodPut));
			uspsMarks[uspIndex] = stationGrade; 
		}
		else
		{
			uspsMarks[uspIndex] = INVALID_GROUP_MARKS; 
		}
	}
}

static void linkAdaptationFillGroupUspsMUMarks(uint8* uspsMarks, uint8 groupId)
{
	uint8 uspIndex = 0; 
	uint8 stationMuGrade = 0;
	StaId stationIndex = 0;
	uint8 stabilityGrade = 0;
	uint8 uspGoodPutGrade = 0;
	uint8 uspLowFrameRateGrade = 0;
	uint16 maxValidTsfDiff = 0;
	
	ASSERT(LinkAdaptationVhtGroupDatabase[groupId].laGroupUnique.groupState !=LA_INACTIVE_GROUP_STATE) 

	maxValidTsfDiff = LinkAdaptationVhtGroupDatabase[groupId].laStaGroupCommon.pLinkAdaptationConfigurationParams->maxValidFilterTsfDiff;
		
	for(uspIndex = 0; uspIndex < GROUP_MANAGER_MAX_NUMBER_OF_STATIONS_IN_GROUP; uspIndex++)
	{
		stationIndex = LinkAdaptationVhtGroupDatabase[groupId].laVhtGroupUnique.groupStationIndexes[uspIndex];
		if(stationIndex!=INVALID_STA_INDEX)
		{
			ASSERT(stationIndex < HW_NUM_OF_STATIONS); //KW_FIX_FW_G
			// the formula is taken from System definitions of valid MU station mark: 
			// sum of:
			// Mu station MAC average goodput - multiplied by weight factor
			// SU station low frame rate counter - multiplied by weight factor
			// SU station stabiltiy state (translated to scale between 1 and 100 with multiplication by SU_STABILITY_FACTOR) - multiplied byt weight factor
			// all 3 weight factors sum must be equal to 100
			// the sum of all 3 components must be normalized by sum of weights thats why there is a division by MU_STA_MARK_DENOMINATOR which is 100
			stabilityGrade = CONVERT_SU_STABILITY_STATE_TO_GRADE(LinkAdaptationStaDatabase[stationIndex].laStaUspCommon.rateAdaptationDataBase.stabilityState);
			
			if(AlphaFilter_isFilterResultValid(&LinkAdaptationVhtGroupDatabase[groupId].laVhtGroupUnique.wpAverageGoodPutPerUsp[uspIndex], maxValidTsfDiff))
			{
				uspGoodPutGrade = AlphaFilter_GetFilterResult(&LinkAdaptationVhtGroupDatabase[groupId].laVhtGroupUnique.wpAverageGoodPutPerUsp[uspIndex])*MU_USP_GOODPUT_WEIGHT;
			}
			
			if(AlphaFilter_isFilterResultValid(&LinkAdaptationStaDatabase[stationIndex].laStationUnique.lowFrameRateCounter, maxValidTsfDiff))
			{
				uspLowFrameRateGrade = AlphaFilter_GetFilterResult(&LinkAdaptationStaDatabase[stationIndex].laStationUnique.lowFrameRateCounter)*SU_LOW_FRAME_RATE_WEIGHT;
			}
			
			stationMuGrade = (uspGoodPutGrade + uspLowFrameRateGrade + 
								(stabilityGrade*SU_STABILITY_FACTOR*SU_STABILITY_WEIGHT)) / MU_STA_MARK_DENOMINATOR;
			
			uspsMarks[uspIndex] = stationMuGrade; 
		}
		else
		{
			uspsMarks[uspIndex] = INVALID_GROUP_MARKS;
		}
	}
			
}

static void linkAdaptationSetTxopModeForMuMember(K_MSG *psMsg)
{
	LaSetTxopForMuMember_t* pTxopConfig = (LaSetTxopForMuMember_t*)psMsg->abData;

	DynamicTxop_OverwriteTxopModeForMuMember(pTxopConfig->staId, pTxopConfig->txopMode);	
}

static void linkAdaptation_SetMuFixedPower(uint8 powerVal)
{
	uint8 groupId; 

#ifndef ENET_INC_ARCH_WAVE600
	Tcr0_t* pTcr0Data = NULL;
#endif //ENET_INC_ARCH_WAVE600
	
	muFixedPowerVal = powerVal; //Set the power value for future groups 
	
	//Set the power value for the current groups 
	for(groupId = 0; groupId < GROUP_MANAGER_MAX_NUMBER_OF_GROUPS; groupId++)
	{
#ifdef ENET_INC_ARCH_WAVE600
		MuGrpDb_t* groupDbEntry = &(GroupDbHwEntries[groupId]);

		groupDbEntry->common.tcr0Data20MhzRfPower = powerVal;
		groupDbEntry->common.tcr0Data40MhzRfPower = powerVal;
		groupDbEntry->common.tcr0Data80MhzRfPower = powerVal;
		groupDbEntry->common.tcr0Data160MhzRfPower = powerVal;
#else
		MuGrpDbCommon_t* groupDbEntry = &(GroupDbHwEntries[groupId]);

		//tcr0 for 20mhz
		pTcr0Data = (Tcr0_t*)&(groupDbEntry->word7);
		pTcr0Data->rfPower = powerVal;

		//tcr0 for 40mhz
		pTcr0Data = (Tcr0_t*)&(groupDbEntry->word8);
		pTcr0Data->rfPower = powerVal;

		//tcr0 for 80mhz
		pTcr0Data = (Tcr0_t*)&(groupDbEntry->word9);
		pTcr0Data->rfPower =  powerVal; 

#endif //ENET_INC_ARCH_WAVE600

	}
}


/********************************************************************************
getCurrentSlowProbingTask





Description:
----------

State: 

Input:
-----
stationIndex


Output:
-------
Returns:
--------

********************************************************************************/


SlowProbingTasks_e getCurrentSlowProbingTask(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter)
{
	return laDbDistributionParameter->laStaGroupCommon->slowProbingHandlerData.slowProbingCurrentTask;
}

void linkAdaptationSetFreqJumpModeInCtsAutoReply(K_MSG *psMsg)
{
	LmFreqJumpMode_t* param = (LmFreqJumpMode_t*)psMsg->abData;	
	//ILOG0_V("[FREQ JUMP] linkAdaptationSetFreqJumpModeInCtsAutoReply");
	linkAdaptationSetFreqJumpMode(param->freqJumpMode);	
}


/**********************************************************************************

linkAdaptationDmrStationEventHandler



Description:
------------
    Handling station event for the DMR feature
    
    
Input:
-----
    StaId stationId,
    uint8 newRateIndex, station new wp rate
    uint8 oldRateIndex, station old wp rate
    DmrEvent_e event: 	DMR_STATION_RATE_CHANGED,	DMR_ADD_STATION,	DMR_REMOVE_STATION,

Output:
-----
    none

**********************************************************************************/
void linkAdaptationDmrStationEventHandler(StaId stationId, uint8 newRateIndex, uint8 oldRateIndex, DmrEvent_e event)
{   
    uint8 lowestRateIndexAllStation;
    uint8 sortOldRateIndex, sortNewRateIndex;
   	LmStaDbSwInfo_t* pLmStaDbSwinfo = &StaDbSwEntries[stationId];
    uint8 vapId = pLmStaDbSwinfo->vapIndex; // Get the vap of this station
    LmVapDbSwInfo_t* pLmVapDbSwInfo = &LmVapDataBase[vapId];
	uint16 supportedRates;
	uint8 supportedRateIndex;

    // 1. If Station is added or removed we need to build the VAP mc rates bitmap again*/
    if (event != DMR_STATION_RATE_CHANGED)
	{	// event = DMR_ADD_STATION/DMR_REMOVE_STATION
		// first we update the number of STAs in the VAP
		if (event == DMR_ADD_STATION)
		{
			pLmVapDbSwInfo->numOfStations++;
		}
		else
		{
			pLmVapDbSwInfo->numOfStations--;
		}
		// now we loop thru the STA supported rates and update the VAP supported rates counters accordingly
		supportedRates = pLmStaDbSwinfo->supportedRates;
		supportedRateIndex = 0;
		while (supportedRates)
		{
			// check if STA supports this rate
        	if (supportedRates & 1)
			{
				// STA support this rate
				DEBUG_ASSERT(supportedRateIndex < BASICRATE_HIGHEST_SORT_RATE_INDEX);
				if (event == DMR_ADD_STATION)
				{
					DEBUG_ASSERT(pLmVapDbSwInfo->supportedRateNumOfStationsCounter[supportedRateIndex] < pLmVapDbSwInfo->numOfStations);
					/*Incremenent VAP supported rate cpunter*/
					pLmVapDbSwInfo->supportedRateNumOfStationsCounter[supportedRateIndex]++;
				}
				else
				{
					DEBUG_ASSERT(pLmVapDbSwInfo->supportedRateNumOfStationsCounter[supportedRateIndex] > 0);
					pLmVapDbSwInfo->supportedRateNumOfStationsCounter[supportedRateIndex]--;
				}
			}
			// increment index
			supportedRateIndex++;
			// move to next rate
			supportedRates >>= 1;
		}
		/*Now set the VAP bitmap*/
		/*First clear the bitmap*/
		pLmVapDbSwInfo->mcBasicRates = 0;
		for (supportedRateIndex = 0; supportedRateIndex < BASICRATE_HIGHEST_SORT_RATE_INDEX; supportedRateIndex++)
		{
			/*set the bit only if all STAs supprt this rate*/
			/*whena ll STAs are removed, all bits will be set which is OK as VAP DB wont be updates*/
			if (pLmVapDbSwInfo->supportedRateNumOfStationsCounter[supportedRateIndex] == pLmVapDbSwInfo->numOfStations)
			{
				pLmVapDbSwInfo->mcBasicRates |= (1 << supportedRateIndex);
			}
		}
    }
    // 2. convert station rate index to sorted rate index of basic rate
    linkAdaptationDmrConvertRateindexToSortedBasicRateIndex(oldRateIndex, newRateIndex, &sortOldRateIndex, &sortNewRateIndex, vapId);
    // 3. update counters
    if (event != DMR_ADD_STATION)
    {   // event = DMR_STATION_RATE_CHANGED/DMR_REMOVE_STATION
        pLmVapDbSwInfo->sortBasicRateNumOfStationsCounter[sortOldRateIndex]--;
    }
    if (event != DMR_REMOVE_STATION)
    {   // event = DMR_STATION_RATE_CHANGED/DMR_ADD_STATION
        pLmVapDbSwInfo->sortBasicRateNumOfStationsCounter[sortNewRateIndex]++;
    }
    
    // 4. find first non zero array index, if non found it will return current mc rate index (so rate wont be updated)
    lowestRateIndexAllStation = linkAdaptationDmrSeekLowestBasicRateAmongStations(pLmVapDbSwInfo->sortBasicRateNumOfStationsCounter, \
                                                                                  pLmVapDbSwInfo->mcRateIndex);
    // 5. update lowest rate if changed
    linkAdaptationDmrUpdateVapRate(vapId, lowestRateIndexAllStation);

}

/**********************************************************************************

linkAdaptationDmrSeekLowestBasicRateAmongStations



Description:
------------
    find the lowest basic rate among all connected stations to this vap
    
    
Input:
-----
    sorted basic rate array, each index represent basic rate by it sorted index, 
    we loop over all indexes to find the first non zero.

Output:
-----
    rate index (not sorted) that is lowest among all stations

**********************************************************************************/
static uint8 linkAdaptationDmrSeekLowestBasicRateAmongStations(uint8 *sortBasicRateNumOfStationsCounter, uint8 return_rate_not_found)
{
    uint8 sortRateIndex = 0;
    
    while(sortBasicRateNumOfStationsCounter[sortRateIndex] == 0) /* stop on first founded rate */
    {
       // try next index
       sortRateIndex++;
       
       /* stop condition if the array is empty (last station removed event) */
       if (sortRateIndex == BASICRATE_HIGHEST_SORT_RATE_INDEX)
       {
            return return_rate_not_found; // return the value when no rate found
       }
    }
   
    return htVhtSortPhyRateToRateIndexSameBw[sortRateIndex];
}

/**********************************************************************************

linkAdaptationDmrConvertRateindexToSortedBasicRateIndex



Description:
------------
    rate index represente phy rate; but rate index is not sorted by phy rate
    This function convert a rate index of specific phy rate to the closest
    phy rate in the basic rates.
    i.e 
    index       phy mode             phy rate
      15,     	LA_PHY_MODE_HT_VHT   7,
    will be converted to
      0         LA_PHY_MODE_11A_11G, 6,   

    5G -> vapBasicRates miss the B only rates so it will start from lowest a rate
    2.4G -> contain all basic rates

    SortPhyRateToRateIndexSameBw contain basic rates elements sorted by phyrate
    
Input:
-----

Output:
-----
    none

**********************************************************************************/
static void linkAdaptationDmrConvertRateindexToSortedBasicRateIndex(uint8 oldRateIndex, uint8 newRateIndex, uint8 *sortOldRateIndex, uint8 *sortNewRateIndex, uint8 vapId)
{
    uint8 sortBasicRateIndex = 0;
    uint8 basicRateIndex, basicRatePhyRate;
    uint32 newRatePhyRate, oldRatePhyRate;    
    uint32 vapBasicRates = (uint32)(LmVapDataBase[vapId].mcBasicRates); // vap all supported basic rates
    bool foundOldRateIndexBasicRate = FALSE;
	bool foundNewRateIndexBasicRate = FALSE;
	
    oldRatePhyRate = htVhtRatesTable[oldRateIndex].rateTableBwParmas[BANDWIDTH_TWENTY].shortCpPhyRate;
    newRatePhyRate = htVhtRatesTable[newRateIndex].rateTableBwParmas[BANDWIDTH_TWENTY].shortCpPhyRate;


#ifdef EXTENDED_DMR_MODES_SUPPORTED
	/*Change rates bitmask accoridng to DMR mode -do it on local variable so we dont need to modify it when changing modes*/
	if (dmrMode == UMI_DMR_BASIC_RATES_ONLY)
	{
		vapBasicRates = LmVapDataBase[vapId].basicRates;
	}
	else if (dmrMode == UMI_DMR_SUPPORTED_RATES_LIMITED)
	{
		// Remove highest rates
		vapBasicRates &= ~(LM_PHY_11A_RATE_36_MSK | LM_PHY_11A_RATE_48_MSK | LM_PHY_11A_RATE_54_MSK);
	}
#endif	

    /* run over all supported basic rate, sorted by phy rate, of this vap until we find one basic rate:
        1. lower than rate Index's phyRate
        2. as high as possible phyRate
        3. supported rate from vap basic rate
    */
    do {
        // get the rate index of RatesTable
        basicRateIndex = htVhtSortPhyRateToRateIndexSameBw[sortBasicRateIndex];
       
        // check basic rate is supported by vap
        if (LA_GET_BIT_IN_BITMAP(&vapBasicRates, basicRateIndex, BITMAP_ARRAY_MAX_SIZE_1)) //KW_FIX_FW_G Added array bound check
        {
            // each basicRatePhyRate should be higher then previous since it is taken from sorted by PhyRate array
            basicRatePhyRate = htVhtRatesTable[basicRateIndex].rateTableBwParmas[BANDWIDTH_TWENTY].shortCpPhyRate;
           
            
            // seek for closest rate under oldRateIndex
            if ((basicRatePhyRate <= oldRatePhyRate))
            {
               
                *sortOldRateIndex = sortBasicRateIndex;
            }
            else
            {
                foundOldRateIndexBasicRate = TRUE;
            }
            // seek for closest rate under newRateIndex
            if ((basicRatePhyRate <= newRatePhyRate))
            {
               
                *sortNewRateIndex = sortBasicRateIndex;
            }
            else
            {
                foundNewRateIndexBasicRate = TRUE;
            }       
        }

        // try next rate index
        sortBasicRateIndex++;
        /*  1. continue when one of the rate is still missing found
            2. force stop when there is no more basic rate to check (if one of the oldRatePhyRate/newRatePhyRate is higher than maximum basicrate phyrate)
        */
    }while (!(foundOldRateIndexBasicRate && foundNewRateIndexBasicRate) && (sortBasicRateIndex < BASICRATE_HIGHEST_SORT_RATE_INDEX)); 

}

/**********************************************************************************

linkAdaptationDmrUpdateVapRate






Description:
------------
    check old multicast data index and update if changed
    
    
Input:
-----
    vap index,
    new multicast index
    
Output:
-----
    none

**********************************************************************************/
static void linkAdaptationDmrUpdateVapRate(uint8 vapId, uint8 newMcRateIndex)
{
	LmVapDbSwInfo_t *LmVapDbSwInfo = &(LmVapDataBase[vapId]);
	PhyMode_e phyModeMc;
	uint8 tcrRateValMc;
	
	// Make the change only if something have changed and if DMR is enabled
	if ((dmrMode != UMI_DMR_DISABLED) && (LmVapDbSwInfo->mcRateIndex != newMcRateIndex))
	{
		LmVapDbSwInfo->mcRateIndex = newMcRateIndex;
		getTcrPhyModeAndRate(htVhtRatesTable, 0, newMcRateIndex, &phyModeMc, &tcrRateValMc, FALSE, NO_DCM);
		
		// Update the tcr using the protected database
		linkAdaptationSetMcastRateInVapDb(vapId , tcrRateValMc,phyModeMc);

	}
}
static void  linkAdaptationSetCollisionDetectionTh(K_MSG *psMsg )
{
	LaFixedCollisionDetectionParams_t *laCollisionDetectionTh = (LaFixedCollisionDetectionParams_t*)pK_MSG_DATA(psMsg);
	LinkAdaptationConfigParamsSteadyState.collisionDetectionTh = laCollisionDetectionTh->collisionDetectionTh;
	LinkAdaptationConfigParamsFastInit.collisionDetectionTh = laCollisionDetectionTh->collisionDetectionTh;
}
/**********************************************************************************

linkAdaptationCompareRSSI 


Description: 
------------
			This function is called when QAMplus is in INACTIVE state
			It compares current RSSI extracted from SHRAM to lastRSSI value saved when moving from 
			TRIAL state to INACTIVE state

Input: 
-----
			station ID

Returns:
--------
			currentRSSI is larger than lastRSSI

	
**********************************************************************************/
bool linkAdaptationCompareRSSI(StaId stationId, int8 lastRssi, uint8 deltaRssi)
{
	int8 maxCurrentRssidB = QAM_PLUS_MIN_RSSI_DB;

	bool newRSSILarger = FALSE;

//#ifdef QAM_PLUS_DEBUG
		ILOG0_V("[linkAdaptationCompareRSSI], start ");	
//#endif

	linkAdaptationFindMaxRssi(stationId, &maxCurrentRssidB);

	// current RSSI is larger than last RSSI by deltaRSSIdB	
	if (maxCurrentRssidB > (int16)(lastRssi + deltaRssi))
	{
		// set output as TRUE
		newRSSILarger = TRUE;
	}
//#ifdef QAM_PLUS_DEBUG
	ILOG0_DDD("[linkAdaptationCompareRSSI], end newRSSILarger = %d, pQAMplusDatabase->lastRSSIdB = %d, maxCurrentRssidB = %d", newRSSILarger, lastRssi, maxCurrentRssidB);	
//#endif

	return(newRSSILarger);
}

/**********************************************************************************

linkAdaptationFindMaxRssi 


Description: 
------------
			find max RSSI over all antennas

Input: 
-----
			station ID

Returns:
--------
			max RSSI

	
**********************************************************************************/
void linkAdaptationFindMaxRssi(StaId stationId, int8* maxCurrentRssidB)
{
	uint8 indexAnt;
	int8 maxTemp = phyRxStatusDb.staPhyRxStatus[stationId].rssi[0];

	for (indexAnt = 1; indexAnt < PHY_STATISTICS_MAX_RX_ANT; indexAnt++)
	{
		if (maxTemp < phyRxStatusDb.staPhyRxStatus[stationId].rssi[indexAnt])
		{
			maxTemp = phyRxStatusDb.staPhyRxStatus[stationId].rssi[indexAnt];
		}
	}

	(*maxCurrentRssidB) = maxTemp;

	
//#ifdef QAM_PLUS_DEBUG
	ILOG0_D("[linkAdaptationFindMaxRssi], maxCurrentRssidB = %d",(*maxCurrentRssidB));
//#endif
}

void setUspRatesTables(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter, RatesTablesDb_t* pRatesTablesDb)
{
	laDbDistributionParameter->laStaUspCommon->pRatesTablesDb = pRatesTablesDb;
}


    
/***********************************************************************
* LinkAdaptivePdIsEtsi5GDuringPsduLimitError
* 
* Description:
* ------------
* Check if the PD can be transmitted under ETSI
* 		When ETSI is enabled and in case FW gets psduLimit error interrupt in 5G:
*		-	If PD Size >1300 ignore the PD	   
*		-	If VHT MU and PD > 850 ignore the PD
*		-	If HE MU and PD > 950 ignore the PD 
*		then drop the PD (WLANRTSYS-14456) 
*		
* Input:
* ------
* psduLimit - is OTFA error of type PSDU LIMIT
* headPd - the PD OTFA failed to TX
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* psduLimitEtsiIn5G - is the error related to PSDU limit while ETSI is enabled and band is 5G 
* 
************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600B
bool LinkAdaptivePdIsEtsi5GDuringPsduLimitError(bool psduLimit, TxPd_t* headPd)
{
	bool psduLimitEtsiIn5G = TRUE;

	/* Check: is the error related to PSDU limit while ETSI is enabled and band is 5G  */
	if ((linkAdaptationIsEtsiMode() == TRUE) && (HDK_getBand() == BAND_5_2_GHZ) && (psduLimit == TRUE) && (headPd->txQTid >= IEEE802_1D_VO_1))
	{
		psduLimitEtsiIn5G = TRUE;
	}

	return(psduLimitEtsiIn5G);
}
#endif

    
/***********************************************************************
* getRatesTable
* 
* Description:
* ------------
* 
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
const RateObj_t* getRatesTable(LaStationUspCommonParams_t* pStaUspDb)
{
	return pStaUspDb->pRatesTablesDb->ratesTable;
}

const RateObj_t* getRatesTableFixRateConfig(LaFixedRateStationParams_t* params)
{
#ifdef ENET_INC_ARCH_WAVE600
	if (params->phyMode > PHY_MODE_11AC)
	{
		return heRatesTable;
	}
	else
	{
		return htVhtRatesTable;
	}
#endif

#ifndef ENET_INC_ARCH_WAVE600
	return htVhtRatesTable;
#endif
}

const uint8* getSortedRatesTable(LaStationUspCommonParams_t* pStaUspDb)
{
	return pStaUspDb->pRatesTablesDb->sortedByPhyRateTable;
}
#ifdef ENET_INC_ARCH_WAVE600
uint8 getMaxSortedTableRateIndex(bool isHe)
{
	uint8 maxSortedTableRateIndex = MAX_VHT_SORT_RATE_INDEX;
	
	if (isHe == TRUE)
	{
		maxSortedTableRateIndex = MAX_HE_SORT_RATE_INDEX;
	}

	return maxSortedTableRateIndex;
}
#endif


uint8 getMaxNumOfRatesInTable(LaStationUspCommonParams_t* pStaUspDb)
{
	return pStaUspDb->pRatesTablesDb->maxRatesInTable;
}

static void clearUnsupportedLowRatesFromHeMuUspRateMask(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter)
{
#ifdef ENET_INC_ARCH_WAVE600
	DlDataPhase_t* phasePtr;
	uint8 ruSize;
	uint16 psduTime; 					// us
	uint16 msduSize = MSDU_MAX_LENGTH;  //bytes
	uint16 phyRateMin; 					//Mb/s
	uint16 tempPhyRate;
	uint8 rateIterator = 0;
	
	if (laDbDistributionParameter->laHeGroupUnique != NULL)
	{
		// HE group
		phasePtr = getWpPhaseAddress(laDbDistributionParameter->stationOrGroupIndex);
		ruSize = phasePtr->userPhase[laDbDistributionParameter->uspIndex].userTcraRuSize;
		if (ruSize < PRE_AGGREGATOR_242_TONE_RU_SIZE)
		{
			psduTime = phasePtr->common.maxPpduTransmissionTimeLimit << 1;
			phyRateMin = CONVERT_BYTES_TO_BIT_INDEX(msduSize)/psduTime;

			for (rateIterator = 0; rateIterator < NUMBER_OF_ALL_RATES_HE; rateIterator++)
			{
				// Search for low rates that are unsupported due to the fact that Tx of one MSDU is longer that MAX PSDU time
				if (heRatesTable[rateIterator].laPhyMode == LA_PHY_MODE_HE)
				{
					tempPhyRate = heRatesTable[rateIterator].rateTableBwParmas[ruSize].shortCpPhyRate / RU_SIZE_242_TO_26_TONES_RATIO;
					if (tempPhyRate <= phyRateMin)
					{
						LA_CLR_BIT_IN_BITMAP(laDbDistributionParameter->laStaUspCommon->raIndexMask.raIndexMask64bit,rateIterator);
						LA_CLR_BIT_IN_BITMAP(laDbDistributionParameter->laStaUspCommon->raIndexMaskOrg.raIndexMask64bit,rateIterator);
					}
				}
			}
		}
	}
#endif
}

#ifdef ENET_INC_ARCH_WAVE600
static void overrideRateForUnsupportedFixedRate(StaId staId)
{
	uint8 requestedNss;
	uint8 requestedMcs;
	uint8 maxNss;
	uint8 maxMcs;
	uint8 chosenNss;
	uint8 fixedRateBefore;
	LaFixedRateStationParams_t *laFixedRateStationParams_p;	
	uint8 chosenDcm = 0;
#ifdef ENET_INC_ARCH_WAVE600D2
	PhyMode_e requestedPhyMode;
	PhyMode_e chosenPhyMode;
	StaDb_t*    pStaDbHwEntry =  &StaDbHwEntries[staId];
	HeSuExtRuSize_e chosenPartialBwData = 0;
	HeSuExtRuSize_e chosenPartialBwMgmt = 0;	
	HeSuExtRuSize_e requestedPartialBwData = 0;
	HeSuExtRuSize_e requestedPartialBwMgmt = 0;
#endif //ENET_INC_ARCH_WAVE600D2
#if (defined ENET_INC_ARCH_WAVE600D2 || defined LINK_ADAPTATION_LOGS)
	uint8 requestedDcm = 0;
#endif
	if (STA_STATE_CONNECTED == getStaState(staId))
	{
		laFixedRateStationParams_p = &LinkAdaptationStaDatabase[staId].laStationUnique.fixedRateStationParams;
		fixedRateBefore = laFixedRateStationParams_p->rate;

		getHighestNssInMask(staId, &maxNss,laFixedRateStationParams_p->bandwidth);
		
		if (laFixedRateStationParams_p->phyMode >= PHY_MODE_11AC)
		{
			requestedNss = EXTRACT_NSS_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate);	
			requestedMcs = EXTRACT_MCS_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate);	
			
			chosenNss = MIN(maxNss, requestedNss);

#ifdef ENET_INC_ARCH_WAVE600D2			
			
			requestedDcm = EXTRACT_DCM_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate);
			chosenDcm = MIN(requestedDcm, pStaDbHwEntry->common.heDcmSupport);
		
			requestedPhyMode = laFixedRateStationParams_p->phyMode;

			//validate HE ER and DCM station capabilities (should be removed later)
			DEBUG_ASSERT(chosenDcm == requestedDcm);

			if ((laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_DATA_MANAGEMENT) || (laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_DATA))
			{
				requestedPartialBwData = laFixedRateStationParams_p->heExtRuSizeData;
				chosenPartialBwData = MIN(requestedPartialBwData, pStaDbHwEntry->common.heSuErRu106Support);
				DEBUG_ASSERT(laFixedRateStationParams_p->heExtRuSizeData == chosenPartialBwData);
				laFixedRateStationParams_p->heExtRuSizeData = chosenPartialBwData;
			}

			if ((laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_DATA_MANAGEMENT) || (laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_MANAGEMENT))
			{
				requestedPartialBwMgmt = laFixedRateStationParams_p->heExtRuSizeMng;
				chosenPartialBwMgmt = MIN(requestedPartialBwMgmt, pStaDbHwEntry->common.heSuErRu106Support);
				DEBUG_ASSERT(laFixedRateStationParams_p->heExtRuSizeMng == chosenPartialBwMgmt);
				laFixedRateStationParams_p->heExtRuSizeMng = chosenPartialBwMgmt;
			}

			chosenPhyMode = requestedPhyMode;

			if((requestedPhyMode == PHY_MODE_11AX_SU_EXT) && (!LinkAdaptationStaDatabase[staId].laStationUnique.heExtSuParams.heExtEnabled))
			{
				DEBUG_FATAL("HE Extended Range is not supported");
				
				//change to HE SU
				chosenPhyMode = PHY_MODE_11AX_SU;
			}
			
			ILOG0_DDDD("[overrideRateForUnsupportedFixedRate], requestedPhyMode %d, requestedPartialBwData %d, requestedPartialBwMgmt %d, requestedBw %d", requestedPhyMode, requestedPartialBwData, requestedPartialBwMgmt, laFixedRateStationParams_p->bandwidth);	
		
			laFixedRateStationParams_p->phyMode = chosenPhyMode;			

			if(chosenDcm)
			{
				//validate NSS and BW DCM capabilities
				DEBUG_ASSERT(chosenNss <= LinkAdaptationStaDatabase[staId].laStationUnique.heExtSuParams.dcmMaxNss);
				DEBUG_ASSERT(laFixedRateStationParams_p->bandwidth <= LinkAdaptationStaDatabase[staId].laStationUnique.heExtSuParams.dcmMaxBw);
				
				chosenNss = MIN(chosenNss, LinkAdaptationStaDatabase[staId].laStationUnique.heExtSuParams.dcmMaxNss);
				laFixedRateStationParams_p->bandwidth = MIN(laFixedRateStationParams_p->bandwidth, LinkAdaptationStaDatabase[staId].laStationUnique.heExtSuParams.dcmMaxBw);
			}

			
			ILOG0_DDDD("[overrideRateForUnsupportedFixedRate], chosenPhyMode %d, chosenPartialBwData %d, chosenPartialBwMgmt %d, chosenBw %d", chosenPhyMode, chosenPartialBwData, chosenPartialBwMgmt, laFixedRateStationParams_p->bandwidth);	

#endif //ENET_INC_ARCH_WAVE600D2
			
			getHighestMcsForNssInMask(staId, chosenNss, &maxMcs, laFixedRateStationParams_p->phyMode, laFixedRateStationParams_p->bandwidth);
			ILOG0_DDD("[overrideRateForUnsupportedFixedRate], requestedNss %d, requestedMcs %d, requested DCM %d", requestedNss, requestedMcs, requestedDcm);
			
			// Override rate
			laFixedRateStationParams_p->rate = RATE_PARAMS_TO_TCR_VAL_VHT_HE(MIN(maxMcs,requestedMcs) , chosenNss, chosenDcm);
			ILOG0_DD("[overrideRateForUnsupportedFixedRate], fixedRateBefore: 0x%x, fixedRateBefore after: 0x%x",fixedRateBefore, laFixedRateStationParams_p->rate);
		}
		else
		{
			requestedMcs = laFixedRateStationParams_p->rate;
			getHighestMcsInMask(staId, &maxMcs, laFixedRateStationParams_p->phyMode,laFixedRateStationParams_p->bandwidth);
			ILOG0_D("[overrideRateForUnsupportedFixedRate], requestedMcs %d", requestedMcs);
			// Override rate
			laFixedRateStationParams_p->rate = MIN(maxMcs, requestedMcs);
			ILOG0_DD("[overrideRateForUnsupportedFixedRate], fixedRateBefore: 0x%x, fixedRateBefore after: 0x%x",fixedRateBefore, laFixedRateStationParams_p->rate);
		}
	}
	else
	{
		// Do nothing here. Will be handled when sta connect.
	}
}


#ifdef ENET_INC_ARCH_WAVE600D2
static void checkHeExtAndDcmWrongFixedRateConfiguration(StaId staId)
{
	LaFixedRateStationParams_t *laFixedRateStationParams_p = &LinkAdaptationStaDatabase[staId].laStationUnique.fixedRateStationParams;
	StaDb_t*    pStaDbHwEntry =  &StaDbHwEntries[staId];

	//check HE Ext SU restrictions
	if (laFixedRateStationParams_p->phyMode == PHY_MODE_11AX_SU_EXT)
	{
		//validate BF is disabled
		DEBUG_ASSERT((pStaDbHwEntry->common.tcr220MhzDataTxbf == TX_BF_FLAT) && (pStaDbHwEntry->common.tcr220Mhz80211Txbf == TX_BF_FLAT));

		//validate bw is 20MHZ
		DEBUG_ASSERT(laFixedRateStationParams_p->bandwidth == BANDWIDTH_TWENTY);

		//validate NSS1 is used
		DEBUG_ASSERT(EXTRACT_NSS_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate) ==  SPATIAL_STREAM_1);

		// validate that MCS isn't higher than 2
		DEBUG_ASSERT(EXTRACT_MCS_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate) <=  MCS_2);

		//validate RuSize 106 used with MCS0 only
		if ((laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_DATA_MANAGEMENT) || (laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_DATA))
		{			
			DEBUG_ASSERT(((laFixedRateStationParams_p->heExtRuSizeData) && (EXTRACT_MCS_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate) ==  MCS_0)) || (!laFixedRateStationParams_p->heExtRuSizeData));				
		}

		if ((laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_DATA_MANAGEMENT) || (laFixedRateStationParams_p->changeType == LA_PACKET_TYPE_MANAGEMENT))
		{
			DEBUG_ASSERT(((laFixedRateStationParams_p->heExtRuSizeMng) && (EXTRACT_MCS_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate) ==  MCS_0)) || (!laFixedRateStationParams_p->heExtRuSizeMng));
		}		
	}

	//check DCM restrictions (could be either in phy mode HE SU or HE SU Ext)
	if(EXTRACT_DCM_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate))
	{
		//validate phy mode
		DEBUG_ASSERT((laFixedRateStationParams_p->phyMode == PHY_MODE_11AX_SU) || (laFixedRateStationParams_p->phyMode == PHY_MODE_11AX_SU_EXT));

		//validate mcs0 and NSS1		
		DEBUG_ASSERT(EXTRACT_NSS_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate) ==  SPATIAL_STREAM_1);	
		DEBUG_ASSERT(EXTRACT_MCS_FROM_VHT_HE_RATE(laFixedRateStationParams_p->rate) ==  MCS_0);

		//validate correct CP mode - 4x LTF + 0.8us GI is not allowed for DCM (and STBC) by standard
		DEBUG_ASSERT(laFixedRateStationParams_p->cpMode != CP_MODE_SHORT_CP_LONG_LTF);
	}	
}	

#endif //ENET_INC_ARCH_WAVE600D2




#ifdef ENET_INC_ARCH_WAVE600B
static void setEtsiMode(bool etsiMode)
{
	PreAggregator_SetPpduDurationLimits(etsiMode);
	PreAggregator_SetBfSeqAirTimeDuration(etsiMode);
	TxSequencer_SetEtsiMode(etsiMode);
}
#endif //ENET_INC_ARCH_WAVE600B
#endif //ENET_INC_ARCH_WAVE600


static void clearUnsupportedHighRatesFromHeMuUspRateMask(LinkAdaptationDatabaseDistributionPack_t* laDbDistributionParameter)
{
#ifdef ENET_INC_ARCH_WAVE600
	DlDataPhase_t* phasePtr;
	uint8 ruSize;
	uint8 rateIterator = 0;
	
	if (laDbDistributionParameter->laHeGroupUnique != NULL)
	{
		// HE group
		phasePtr = getWpPhaseAddress(laDbDistributionParameter->stationOrGroupIndex);
		ruSize = phasePtr->userPhase[laDbDistributionParameter->uspIndex].userTcraRuSize;
		if (ruSize < PRE_AGGREGATOR_242_TONE_RU_SIZE)
		{
			for (rateIterator = 0; rateIterator < NUMBER_OF_ALL_RATES_HE; rateIterator++)
			{
				// Search for high rates that are unsupported in ru < 20mhz
				if (heRatesTable[rateIterator].laPhyMode == LA_PHY_MODE_HE)
				{
					if (heRatesTable[rateIterator].vhtHeMcs > 9)
					{
						LA_CLR_BIT_IN_BITMAP(laDbDistributionParameter->laStaUspCommon->raIndexMask.raIndexMask64bit,rateIterator);
						LA_CLR_BIT_IN_BITMAP(laDbDistributionParameter->laStaUspCommon->raIndexMaskOrg.raIndexMask64bit,rateIterator);
					}
				}
			}
		}
	}
#endif
}

#ifdef PF6_MU_BAR_PATCH
static void overrideMinNumberOfUsersForTransmission(PreAggCommonReportFifo_t *commonReport)
{
	CommonPlan_t* planPtr;
	DlDataPhase_t* phasePtr;
	DlDataPhase_t* phaseMirrorPtr;

	if((commonReport->phaseType == PHASE_TYPE_DL_DATA_PHASE) &&
		(PRE_AGG_RPT_TXOP_TYPE_HE_MU == commonReport->reportTxopType))
	{	
		planPtr = &heMuPlansArray[commonReport->groupPlanId];
		phasePtr = (DlDataPhase_t*)(planPtr->phase3Full32BitPointer);
		phaseMirrorPtr = (DlDataPhase_t*)(phasePtr->common.nextOrMirrorPhasePointer);
		
		if(0xF == commonReport->finalValidUserBitmapUser20User0) // 0xf = 4 bits = 4 users
		{
			phasePtr->common.minimumNumberOfUsersForTransmission = 0x4; 
			phaseMirrorPtr->common.minimumNumberOfUsersForTransmission = 0x4; 

			ILOG0_V("PF6_MU_BAR_PATCH change to 4 users");
		}
		else if((phasePtr->common.muMimo == DL_MU_MIMO_MU_MIMO) && 
			(0x3 == commonReport->finalValidUserBitmapUser20User0)) // 0x3 = 2 bits = 2 users
		{
			phasePtr->common.minimumNumberOfUsersForTransmission = HE_GROUP_MANAGER_MIN_USERS_FOR_MU_MIMO; 
			phaseMirrorPtr->common.minimumNumberOfUsersForTransmission = HE_GROUP_MANAGER_MIN_USERS_FOR_MU_MIMO; 
			ILOG0_V("PF6_MU_BAR_PATCH change to 2 users");
		}
	}
}
#endif //PF6_MU_BAR_PATCH

#if defined(BSRC_ARTIFICIAL_UPDATE_FOR_UL)
void LinkAdaptation_SetBsrcCountersForStaticPlan(K_MSG* pMsg)
{
	StaId staIndex = 0;
	uint32 uspIndex = 0;
	uint32* phase0Addr;
	UlDataPhase_t* phasePtr;
	uint32 validUsersBitMap;
	uint8 iterations;
	phase0Addr = &(heMuPlansArray[0].word2);
	phasePtr = (UlDataPhase_t*)(phase0Addr[DATA_PHASE_BIT_INDEX]);
	UNUSED_PARAM(pMsg);
	bool isFixedInterval;
	uint8 tidMask = BSRC_DATA_COUNTERS_VOICE_AC_BITS;

	if ((GET_BIT_IN_BYTE(heMuPlansArray[0].phaseValid, DATA_PHASE_BIT_INDEX) != 0) && 
		(phasePtr->common.phaseType == PHASE_TYPE_UL_DATA_PHASE))
	{
		validUsersBitMap = phasePtr->common.validUsers310;
		isFixedInterval = Bsrc_GetTfFixedInterval();
		if (isFixedInterval == TRUE)
		{
			/* in order to make sure that TF will be sent immidiatley, set BSRC for all TIDs */
			tidMask = TID_BITMAP_ALL_DATA_TIDS;
		}
		for (iterations = 0; iterations < NUMBER_OF_STA_BITMAPS; iterations++)
		{
			while (validUsersBitMap != 0)
			{
				if (validUsersBitMap & 0x1)
				{
					staIndex = phasePtr->userPhase[uspIndex].staId;
					Bsrc_Command((staIndex + BSRC_NUMBER_OF_STATIONS_IN_BITMAP*iterations),tidMask, BSRC_DATA_COUNTERS_INIT_VAL,BSRC_COMMAND_INIT); // set Bsrc counters
				}
				validUsersBitMap >>= 0x1;
				uspIndex++;
			}
			validUsersBitMap = phasePtr->common.validUsers3532; // skip to next 4 stations bitmap
		}
	}
}
void LinkAdaptation_ClearBsrcCountersForStaticPlan(void)
{
	StaId staIndex = 0;
	uint32 uspIndex = 0;
	uint32* phase0Addr;
	UlDataPhase_t* phasePtr;
	uint32 validUsersBitMap;
	uint8 iterations;
	
	phase0Addr = &(heMuPlansArray[0].word2);
	phasePtr = (UlDataPhase_t*)(phase0Addr[DATA_PHASE_BIT_INDEX]);

	if ((GET_BIT_IN_BYTE(heMuPlansArray[0].phaseValid, DATA_PHASE_BIT_INDEX) != 0) && 
		(phasePtr->common.phaseType == PHASE_TYPE_UL_DATA_PHASE))
	{
		validUsersBitMap = phasePtr->common.validUsers310;

		for (iterations = 0; iterations < NUMBER_OF_STA_BITMAPS; iterations++)
		{
			while (validUsersBitMap != 0)
			{
				if (validUsersBitMap & 0x1)
				{
					staIndex = phasePtr->userPhase[uspIndex].staId;
					Bsrc_Command((staIndex + BSRC_NUMBER_OF_STATIONS_IN_BITMAP*iterations),TID_BITMAP_ALL_DATA_TIDS,BSRC_DATA_COUNTERS_RESET_COUNTERS_VAL,BSRC_COMMAND_INIT); // reset Bsrc counters
				}
				validUsersBitMap >>= 0x1;
				uspIndex++;
			}
			validUsersBitMap = phasePtr->common.validUsers3532; // skip to next 4 stations bitmap
			staIndex = 0;
		}
	}
}
#endif
static void linkAdaptationProtectionRateConfig(K_MSG * psMsg)
{
	UMI_Protection_Rate_Config_t* param = (UMI_Protection_Rate_Config_t*)pK_MSG_DATA(psMsg);

	if (param->getSetOperation == API_GET_OPERATION)
	{
		param->cutoffPoint = protectionRateCutoff;
	}
	else
	{
		protectionRateCutoff = param->cutoffPoint;
	}
	OSAL_SEND_MESSAGE(UMI_MC_MAN_PROTECTION_RATE_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

void linkAdaptationUpdateProtectionRateOnAddSta(PhyMode_e phymode)
{
	if (isLowRateSta(phymode) == TRUE)
	{
		if (numConnectedLowRateSta == 0)
		{
			updateTcrCommonTemplate1Rate(0xFFFFFFFF);
		}
		numConnectedLowRateSta++;
	}
}

void linkAdaptationUpdateProtectionRateOnRemoveSta(PhyMode_e phymode)
{
	if (isLowRateSta(phymode) == TRUE)
	{
		ASSERT(numConnectedLowRateSta);
		numConnectedLowRateSta--;
		if (numConnectedLowRateSta == 0)
		{
			updateTcrCommonTemplate1Rate(~LM_PHY_11B_RATE_MSK);
		}
	}
}

bool isLowRateSta(PhyMode_e phymode)
{
	bool ret = FALSE;

	if (phymode == PHY_MODE_11B)
	{
		ret = TRUE;
	}
	else if ((protectionRateCutoff > B_PROTECTION_ONLY_FOR_B) && (phymode == PHY_MODE_11AG))
	{
		ret = TRUE;
	}
	else if (protectionRateCutoff == B_PROTECTION_ALWAYS)
	{
		ret = TRUE;
	}
	return ret;
}
static void linkAdaptationUpdateGroupsMetricsReq(K_MSG * psMsg)
{
	HdkCdbManagerConfigBandReq_t* pConfigSmMsgExtract;
	pConfigSmMsgExtract = (HdkCdbManagerConfigBandReq_t*)pK_MSG_DATA(psMsg);
	
	SLOG0(0, 0, HdkCdbManagerConfigBandReq_t, pConfigSmMsgExtract);
	MetricsCalculator_PrepareData();
	
	/*Send confirmation to HE_GM using HDK config SM*/
	OSAL_SEND_MESSAGE(pConfigSmMsgExtract->retMsg, pConfigSmMsgExtract->retTask, psMsg, psMsg->header.vapId); 
}
static void linkAdaptationSendStaParamsToHeGroupManager(K_MSG* pMsg)
{

	HeGroupManagerStaParamsFromLa_t* pStaParams = (HeGroupManagerStaParamsFromLa_t *)pK_MSG_DATA(pMsg);
	UMI_STA_ADD *pAddSta = (UMI_STA_ADD *)pK_MSG_DATA(pStaParams->pAddStaMsg);
	StaId staId = pAddSta->u16SID;
	BwStationDatabaseVars_t* pBwDatabase = &(LinkAdaptationStaDatabase[staId].laStaGroupCommon.bwAdaptationDb);
	LaStationUspCommonParams_t* pStaUspCommonDb = &LinkAdaptationStaDatabase[staId].laStaUspCommon;
	HE_MAC_PHY_CAPABILITIES_INFO* heMacPhyCapabilities = (HE_MAC_PHY_CAPABILITIES_INFO*)&(pAddSta->u8HE_Mac_Phy_Cap_Info);
	uint8 staMaxNss = SPATIAL_STREAM_1;
	Bandwidth_e maxBw = BANDWIDTH_TWENTY;
	bool ofdmaInBW20 = FALSE;
	
	if ((TRUE == pStaUspCommonDb->staTransmissionParams.heSta) || (TRUE == pStaUspCommonDb->staTransmissionParams.vhtSta))
	{
		/*Set NSS*/
		staMaxNss = LinkAdaptationGetMaxNssInMask(pStaUspCommonDb->raIndexMaskOrg.raIndexMask64bit,pStaUspCommonDb->staTransmissionParams.heSta);
		/*Set BW parameters*/
		maxBw = pBwDatabase->staSupportedBw;
		if (LinkAdaptationCommonConfiguration.band == BAND_2_4_GHZ)
		{
			ofdmaInBW20 = heMacPhyCapabilities->hePhyCapInfo.HE_PHY_CHANNEL_WIDTH_SET_B4;
		}
		else
		{
		 	ofdmaInBW20 = heMacPhyCapabilities->hePhyCapInfo.HE_PHY_CHANNEL_WIDTH_SET_B5;
		}
	}
	pStaParams->staMaxNss = staMaxNss;
	pStaParams->staBw = maxBw;
	pStaParams->ofdmaInBW20 = ofdmaInBW20;

	/*Send indication to HE group manager*/
	OSAL_SEND_MESSAGE(HE_GROUP_MANAGER_SET_STA_ASSOC_BW_AND_ANTS_FROM_LA, TASK_HE_GROUP_MANAGER, pMsg, pMsg->header.vapId); 
}


void linkAdaptationSetBaReportReceivedForRealUser(uint8 uspIndex)
{
	ILOG0_D("linkAdaptationSetBaReportReceivedForRealUser, uspIndex = %d", uspIndex);
	LA_SET_BIT_IN_BITMAP(BaReportReceivedForUserIndication.heUspBitmap, uspIndex, BITMAP_ARRAY_MAX_SIZE_2); //KW_FIX_FW_G Added array bound check
}


void linkAdaptationIncProbingCounterForTempDummyUser(BaaRateAdaptiveFullFifo_t* pLastBaaReport)
{
    LinkAdaptationConfigurationParams_t*        pLinkadaptaionConfigParam;
    LinkAdaptationDatabaseDistributionPack_t	laDbDistributionParameter;
    uint32                                      tempProbingValidationMask;
    uint32                                      tempBaReportRecForUserMask;
    uint8                                       i;
    uint8                                       uspIndex = 0;
    uint8                                       groupIndex;
    bool                                        isProbing = (pLastBaaReport->userReport.altRateReasonFastProbing | pLastBaaReport->userReport.altRateReasonSlowProbing);
	bool 										probeIsAlreadyValid = FALSE;
	bool                                        probeIsValid = FALSE;

	
	groupIndex = getLaPhaseIdFromPlanIndex(pLastBaaReport->commonReport.planIndex, pLastBaaReport->commonReport.phaseIndex);
    if ((isProbing)&& (LinkAdaptationHePhaseDatabase[groupIndex].laStaGroupCommon.linkAdaptationState != LA_STA_NOT_CONNECT_RA_BYPASS))
    {
        for (i = 0; i < BITMAP_ARRAY_MAX_SIZE_2; i++)
        {
            tempProbingValidationMask = LinkAdaptationHePhaseDatabase[groupIndex].laHeGroupUnique.probingValidationMask.heUspBitmap[i];
            tempBaReportRecForUserMask = BaReportReceivedForUserIndication.heUspBitmap[i];

            while (tempProbingValidationMask != 0)
            {
               pLinkadaptaionConfigParam = LinkAdaptationHePhaseDatabase[groupIndex].laStaGroupCommon.pLinkAdaptationConfigurationParams;
			   updateLaDbDistributionParam(&laDbDistributionParameter, groupIndex, uspIndex, TRUE);
			   laDbDistributionParameter.laStaUspCommon->rateAdaptationDataBase.waitForProbeResponse = 0;//When user become dummy user during probing event, the probe will not receive anymore so we should clear this bit for all users in group
			   if (((tempProbingValidationMask & 0x1) == 1) && ((tempBaReportRecForUserMask & 0x1) == 0))
               {
#ifdef DYNAMIC_GROUPING_DEBUG                    
                    ILOG0_D("[linkAdaptationIncProbingCounterForTempDummyUser], dummy user, increase counter for usp: %d", uspIndex);
#endif

					/*Increment probing validation counter for this usp*/
					probeIsAlreadyValid = LA_GET_BIT_IN_BITMAP(laDbDistributionParameter.laHeGroupUnique->probingValidationBitmap.heUspBitmap, uspIndex, BITMAP_ARRAY_MAX_SIZE_2);
					if (FALSE == probeIsAlreadyValid)
					{
						laDbDistributionParameter.laStaUspCommon[uspIndex].probingPointValidationCounter++;
						probeIsValid = estimatorsProbingValidationCriteria(&(laDbDistributionParameter.laStaUspCommon->probingPointValidationCounter),pLinkadaptaionConfigParam->fastProbingValidationTh);
						if (probeIsValid)
	                    {
#ifdef DYNAMIC_GROUPING_DEBUG  
	                        ILOG0_D("[linkAdaptationIncProbingCounterForTempDummyUser], probe is valid, set bit in bitmap for user: %d", uspIndex); 
#endif
							laStateMachineEnterEvent(&laDbDistributionParameter, LA_PROCESS_FEEDBACK_OUT_OF_SM);
							LA_SET_BIT_IN_BITMAP(laDbDistributionParameter.laHeGroupUnique->probingValidationBitmap.heUspBitmap, uspIndex, BITMAP_ARRAY_MAX_SIZE_2); //KW_FIX_FW_G Added array bound check

							if((laDbDistributionParameter.laHeGroupUnique->probingValidationBitmap.heUspBitmap[0] == laDbDistributionParameter.laHeGroupUnique->probingValidationMask.heUspBitmap[0]) && (laDbDistributionParameter.laHeGroupUnique->probingValidationBitmap.heUspBitmap[1] == laDbDistributionParameter.laHeGroupUnique->probingValidationMask.heUspBitmap[1]))
					        {
						        laDbDistributionParameter.laHeGroupUnique->probingValidationBitmap.heUspBitmap[0] = 0x0; /*reset probing validation bitmap*/
						        laDbDistributionParameter.laHeGroupUnique->probingValidationBitmap.heUspBitmap[1] = 0x0;
								laDbDistributionParameter.laStaUspCommon->probingPointValidationCounter = 0;
								/*Change state*/
				                laStateMachineChangeState(&laDbDistributionParameter, LA_WAIT_FOR_NEXT_PROBE_CYCLE);
	                            return;
					        }
	                    }
					}
               }
               tempProbingValidationMask >>= 1;
               tempBaReportRecForUserMask >>= 1;
               uspIndex++;
            }
        }
    }
}

