/***********************************************************************************
 File:		LinkAdaptation_Tests.c
 Module:		LinkAdaptation 
 Purpose: 	
 Description:	
 				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_GlobalDefinitions.h"
#include "linkAdaptation_api.h"
#include "LinkAdaptation_Tests_api.h"
#include "LinkAdaptation_Tests.h"
#include "stringLibApi.h"
#include "lm_StaDatabase.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"

#ifdef LINK_ADAPTATION_TEST_ENV
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_LINK_ADAPTATION
#define LOG_LOCAL_FID 13
	

#define END_OF_TEST_MARK 0xFF

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
typedef enum FastProbingTestState
{
	FIRST_REPORT_ARRIVED,
	WAIT_FOR_PROBE_INIT,
	WAIT_FOR_FIRST_PROBE,
	WAIT_FOR_SECOND_PROBE,
	END_OF_TEST,
}FastProbingTestState_e;

/*---------------------------------------------------------------------------------
/						Static Function Declaration 								
/----------------------------------------------------------------------------------*/

static void LaTests_SetTimerProbing(void);
static void modifyPER(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, uint8 perPrecent);
static void LaTest_EmptyFunc(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams);
static void LaTests_upNssTest(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams);
static void LaTests_upMcsTest(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams);
static void LaTests_downMcsTest(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams);
static void LaTests_PerNotValid(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams);
static void LaTests_ModifyPer( BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams);

/*---------------------------------------------------------------------------------
/						Static variables				
/----------------------------------------------------------------------------------*/
static FastProbingTestState_e FastProbingTestStateVar = END_OF_TEST;
bool LaTestEnableTimerEvent = FALSE;
uint8 requiredPer;
StaId testedStationIndex = DB_ASYNC_SID;
LaTestEnvMsgParams_t testParams;

const laTestFunctionEntry afpLaTestFunc[LA_TEST_OPTIONS] = 
{
	LaTest_EmptyFunc,
	LaTests_ModifyPer,
	LaTests_upNssTest,			
	LaTests_upMcsTest,			
	LaTests_downMcsTest,		
	LaTests_PerNotValid,
	LaTest_EmptyFunc

};
 

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/****************************************************************************
 **
 ** NAME:		 LaTests_TestInit
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION: 
 ** 
 **   
 ***************************************************************************/
 void LaTests_TestInit(K_MSG *psMsg)
{
	TX_INTERRUPT_SAVE_AREA;
	LinkAdaptationDatabaseDistributionPack_t laDbDistributionParameter; 
	
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	testParams = *((LaTestEnvMsgParams_t*)pK_MSG_DATA(psMsg));

	/*Search station index*/
	testedStationIndex = Lm_GetStaIndexByMacAddr(&LmStaDataBase, testParams.testedStaMacAddress);

	if (testedStationIndex != DB_ASYNC_SID)
	{
		/*Reset databases*/
		laStateMachineInit(testedStationIndex,INVALID_MU_USP_INDEX);		
		updateLaDbDistributionParam(&laDbDistributionParameter,stationIndex,INVALID_MU_USP_INDEX, FALSE);	
		//	estimatorsInit();
		/*Change Rate adaptation state*/
		laStateMachineChangeState(&laDbDistributionParameter,LA_WAIT_FOR_NEXT_PROBE_CYCLE);

		FastProbingTestStateVar = WAIT_FOR_FIRST_PROBE;


		DEBUG_ASSERT(testedStationIndex != DB_ASYNC_SID);
		/*Set new rate for all BWs */
		rateAdaptationChangeWorkingPoint(&laDbDistributionParameter, testParams.rateIndex,testParams.rateIndex);

		if (testParams.testType == TEST_PROBING_TIMER)
		{
			LaTests_SetTimerProbing();
		}
	}	
	OSAL_ENABLE_INTERRUPTS(interrupt_save); //free resource for others 
		
}
/****************************************************************************
 **
 ** NAME:		 LaTests_RunTest
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION: 
 ** 
 **   
 ***************************************************************************/

void LaTests_RunTest(StaId staIndex, BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams)
{
	/*Run specific testif station index is match*/
#ifdef LINK_ADAPTATION_LOGS
//	ILOG0_D("testType = %d", testParams.testType);
#endif
	if (staIndex == testedStationIndex)
	{
		afpLaTestFunc[testParams.testType](pLocalBaaTxReport, configurationParams );
	}
	
}
/****************************************************************************
 **
 ** NAME:		 LaTests_ModifyPer
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION: 
 ** 
 **   
 ***************************************************************************/

static void LaTests_ModifyPer( BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams)
{

	modifyPER(pLocalBaaTxReport, testParams.requiredPer);	
}

/****************************************************************************
 **
 ** NAME:		 LaTests_upNssTest
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION: 
 ** 
 **   
 ***************************************************************************/

static void LaTests_upNssTest(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams)
{
	uint8 targetPer = configurationParams->targetPer;
	uint8 targetPerMargin = configurationParams->targetPerMargin;
	uint8 perOffset = targetPerMargin + 15;
	RateAdaptationDataBase_t* raDatabase = &LinkAdaptationStaDatabase[testedStationIndex].laStaUspCommon.rateAdaptationDataBase;
	bool isProbing = pLocalBaaTxReport->isFastProbUsp0 || pLocalBaaTxReport->isSlowProbUsp0;

	switch (FastProbingTestStateVar)
	{
		case END_OF_TEST:
			/*Set constant PER*/
			modifyPER(pLocalBaaTxReport, targetPer);
			break;
		case WAIT_FOR_FIRST_PROBE:

			/*Not probing response*/
			modifyPER(pLocalBaaTxReport, targetPer - perOffset);
			if(isProbing)
			{
				FastProbingTestStateVar = FIRST_REPORT_ARRIVED;
				modifyPER(pLocalBaaTxReport, 0);
			}

			break;
		case FIRST_REPORT_ARRIVED:
		
			if(isProbing)
			{
				modifyPER(pLocalBaaTxReport, 0);
			}
			if(LinkAdaptationStaDatabase[testedStationIndex].laStaGroupCommon.linkAdaptationState== LA_WAIT_FOR_NEXT_PROBE_CYCLE)
			{

				FastProbingTestStateVar = WAIT_FOR_FIRST_PROBE;
				modifyPER(pLocalBaaTxReport, targetPer - perOffset);

			}
			break;
		
		default:
			DEBUG_ASSERT(0);
	}

//	ILOG0_DD("LaTests_upNssTest, FastProbingTestStateVar = %d, probingType = %d", FastProbingTestStateVar, pLocalBaaTxReport->probingType);
	
}
/****************************************************************************
 **
 ** NAME:		 LaTests_upMcsTest
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION: 
 ** 
 **   
 ***************************************************************************/

static void LaTests_upMcsTest(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams)
{
	uint8 targetPer = configurationParams->targetPer;
	uint8 targetPerMargin = configurationParams->targetPerMargin;
	uint8 constPer = targetPer;
	uint8 perOffset = targetPerMargin + 1;
	pLocalBaaTxReport->mpduCnt = configurationParams->numberOfMpduForProbingValid;
	bool isProbing = pLocalBaaTxReport->isFastProbUsp0 || pLocalBaaTxReport->isSlowProbUsp0;
	
	switch (FastProbingTestStateVar)
	{
		case END_OF_TEST:
			/*Set constant PER*/
			modifyPER(pLocalBaaTxReport, 0);
			break;

		case FIRST_REPORT_ARRIVED:
			/*Set constant PER*/
			modifyPER(pLocalBaaTxReport, constPer);
			FastProbingTestStateVar=WAIT_FOR_PROBE_INIT;
			break;
		case WAIT_FOR_PROBE_INIT:
			/*PER decreased below target -> iniitiate probe up NSS*/
			modifyPER(pLocalBaaTxReport, constPer - perOffset);
			FastProbingTestStateVar=WAIT_FOR_FIRST_PROBE;
			break;
		case WAIT_FOR_FIRST_PROBE:
			/* set constant PER */
			modifyPER(pLocalBaaTxReport, constPer);

			if(pLocalBaaTxReport->probingType != 0)
			{
				/*First probe arrived, initiate another probe*/
				modifyPER(pLocalBaaTxReport, constPer - perOffset);
				FastProbingTestStateVar = WAIT_FOR_SECOND_PROBE;
			}
			break;
		case WAIT_FOR_SECOND_PROBE:
			if(isProbing)
			{
				/*Not probing response*/
				modifyPER(pLocalBaaTxReport, constPer);
			}
			else
			{
				/* Second probe, set PER on 0 so up MCS will be chosen*/
				modifyPER(pLocalBaaTxReport, 0);
				FastProbingTestStateVar = END_OF_TEST;
			}
			break;
			
			
		default:
			DEBUG_ASSERT(0);
	}
	
	
}
/****************************************************************************
 **
 ** NAME:		 LaTests_downMcsTest
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION: 
 ** 
 **   
 ***************************************************************************/

static void LaTests_downMcsTest(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams)
{
	uint8 targetPer = configurationParams->targetPer;
	uint8 targetPerMargin = configurationParams->targetPerMargin;
	uint8 perOffset = targetPerMargin + 15;
	RateAdaptationDataBase_t* raDatabase = &LinkAdaptationStaDatabase[testedStationIndex].laStaUspCommon.rateAdaptationDataBase;
	bool isProbing = pLocalBaaTxReport->isFastProbUsp0 || pLocalBaaTxReport->isSlowProbUsp0;

	switch (FastProbingTestStateVar)
	{
		case END_OF_TEST:
			/*Set constant PER*/
			modifyPER(pLocalBaaTxReport, targetPer);
			break;
		case WAIT_FOR_FIRST_PROBE:

			/*Not probing response*/
			modifyPER(pLocalBaaTxReport, targetPer + perOffset);
			if(isProbing)
			{
				FastProbingTestStateVar = FIRST_REPORT_ARRIVED;
				modifyPER(pLocalBaaTxReport, 0);
			}

			break;
		case FIRST_REPORT_ARRIVED:
		
			if(isProbing)
			{
				modifyPER(pLocalBaaTxReport, 0);
			}
			if(LinkAdaptationStaDatabase[testedStationIndex].laStaGroupCommon.linkAdaptationState == LA_WAIT_FOR_NEXT_PROBE_CYCLE)
			{
				modifyPER(pLocalBaaTxReport, targetPer + perOffset);
				FastProbingTestStateVar = WAIT_FOR_FIRST_PROBE;
			}
			break;
		
		default:
			DEBUG_ASSERT(0);
	}
//	ILOG0_DD("LaTests_downMcsTest, FastProbingTestStateVar = %d, probingType = %d", FastProbingTestStateVar, pLocalBaaTxReport->probingType);
}
/****************************************************************************
 **
 ** NAME:		 LaTests_SetTimerProbing
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION: 
 ** 
 **   
 ***************************************************************************/

static void LaTests_SetTimerProbing(void)
{
	LaTestEnableTimerEvent = TRUE;
}
/****************************************************************************
 **
 ** NAME:		 LaTests_SetTimerProbing
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION: 
 ** 
 **   
 ***************************************************************************/

static void LaTests_PerNotValid( BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams)
{
	uint8 constPer = configurationParams->targetPer;
	/*Set Mpdu counter on half of the required, so per will be valid only after two reports*/
	pLocalBaaTxReport->mpduCnt = (configurationParams->numberOfMpduForProbingValid) << 1;

	modifyPER(pLocalBaaTxReport, constPer);


}

/****************************************************************************
 **
 ** NAME:		 modifyPER
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION: 
 ** 
 **   
 ***************************************************************************/

static void modifyPER(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, uint8 perPrecent)
{
	pLocalBaaTxReport->weightedSuccessMpdu = 12*(100-perPrecent)/100;
	pLocalBaaTxReport->weightedFailMpdu = 12-pLocalBaaTxReport->weightedSuccessMpdu;
	pLocalBaaTxReport->successMpdu = 12*(100-perPrecent)/100;
	pLocalBaaTxReport->failedMpdu= 12-pLocalBaaTxReport->successMpdu;
	pLocalBaaTxReport->mpduCnt = pLocalBaaTxReport->successMpdu + pLocalBaaTxReport->failedMpdu;
}
/****************************************************************************
 **
 ** NAME:		 LaTest_EmptyFunc
 **
 ** PARAMETERS:  
 **
 ** RETURN VALUES: 
 **
 ** DESCRIPTION: 
 ** 
 **   
 ***************************************************************************/

static void LaTest_EmptyFunc(BaaRateAdaptiveFifo_t* pLocalBaaTxReport, LinkAdaptationConfigurationParams_t* configurationParams)

{
	return;
}
#endif //LINK_ADAPTAION_TESTS_ENV

