/***********************************************************************************
 File:			Locker_Api.h
 Module:			Locker
 Purpose: 		Manage all request to Hw Locker
 Description:		Serialize and schedule all request  from FW modules to Hw Locker
 This module is the API to the Tx Selector responsible for the 
************************************************************************************/
#ifndef LOCKER_API_H_
#define LOCKER_API_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "TxSelector_Api.h"
#include "OSAL_Kmsg.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/
typedef struct RequesterLockParams
{	
	void *callerContext;
	K_MSG_TYPE	returnMsg;
	K_TASKID	returnTask;
} RequesterLockParams_t;



typedef struct LockReqCb
{	
	void *callerContext;
	TxSelectorLockStatus_e lockStatus;
	StaId stationOrVapNum;
	uint8 tid;
} LockReqCb_t;


typedef struct LockGroupReqCb
{	
	void *callerContext;
	TxSelectorLockStatus_e lockStatus;
	uint8 groupId; 
} LockGroupReqCb_t;

typedef struct LockPlanReqCb
{	
	void *callerContext;
	TxSelectorLockStatus_e lockStatus;
} LockPlanReqCb_t;

/*---------------------------------------------------------------------------------
/						Public Function Declaration						
/----------------------------------------------------------------------------------*/
void Locker_LockRequestServiced(TxSelectorLockStatus_e lockRequestStatus);
void Locker_DisableStaQueues(TxQueueType_e queueType,uint32 staOrVapId,RequesterLockParams_t *lockRequesterParams);
void Locker_EnableStaQueues(TxQueueType_e queueType,uint32 staOrVapId );
void Locker_LockGroupRequestServiced(TxSelectorLockStatus_e lockRequestStatus); 
void Locker_LockGroup(uint32 groupId,RequesterLockParams_t *lockRequesterParams);
void Locker_UnLockGroup(uint32 groupId);
void Locker_Init(void);

void Locker_UnLockAllStaQueues(TxQueueType_e queueType, StaId stationOrVapNum);
void Locker_LockAllStaQueues(TxQueueType_e queueType, StaId staOrVapId, RequesterLockParams_t *lockRequesterParams);
void Locker_LockSingleQueue(TxQueueType_e queueType, StaId staOrVapId, uint8 tid, RequesterLockParams_t *lockRequesterParams);

#ifdef ENET_INC_ARCH_WAVE600
void Locker_UnLockPerTidQueues(TxQueueType_e queueType, StaId stationOrVapNum, uint16 tidBitmap);
void Locker_LockPlan(uint8 planIndex, uint32 vapNum, RequesterLockParams_t *lockRequesterParams);
void Locker_UnLockPlan(uint8 planIndex, StaId staId);
void Locker_LockPlanRequestServiced(TxSelectorLockStatus_e lockRequestStatus); 
#else
void Locker_UnLockPerTidQueues(TxQueueType_e queueType, StaId stationOrVapNum, uint8 tidBitmap);
#endif //ENET_INC_ARCH_WAVE600

#endif //LOCKER_API_H_


