/***************************************************************
 File:		Mac2index_Api.h
 Module:	  	MAC 2 index
 Purpose: 	holds all the definitions of the MAC 2 index API functions
 Description:  This file is the API to the MAC 2 index module which is responsible
 			of converting MAC address to station id 
***************************************************************/
#ifndef MAC_2_INDEX_API_H_
#define MAC_2_INDEX_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "mhi_ieee_address.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void Mac2Index_Initialize(void);
uint16 Mac2Index_SearchStation(IEEE_ADDR * macAddress);
uint16 Mac2Index_AddStation(IEEE_ADDR * macAddress);
void Mac2Index_RemoveStationByAddress(IEEE_ADDR * macAddress);
void Mac2Index_RemoveStationById(StaId stationId);

#ifdef GENERATE_TRIGGER_FRAME_FROM_FW
uint16 Mac2Index_SearchStationForTriggerFrame(IEEE_ADDR * macAddress);
#endif


#endif /* MAC_2_INDEX_API_H_ */


