/***************************************************************
 File:		Mac2index.h
 Module:	  	MAC 2 index
 Purpose: 	holds the definions for the MAC 2 index HW module 
 Description:  This file contains the definions of the MAC 2 index module which is responsible
 			of converting MAC address to station id 
***************************************************************/
#ifndef MAC_2_INDEX_H_
#define MAC_2_INDEX_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define MAC_2_INDEX_MAC_ADDRESS_FIRST_BYTE 0
#define MAC_2_INDEX_MAC_ADDRESS_SECOND_BYTE 1
#define MAC_2_INDEX_MAC_ADDRESS_THIRD_BYTE 2
#define MAC_2_INDEX_MAC_ADDRESS_FORTH_BYTE 3
#define MAC_2_INDEX_MAC_ADDRESS_FIFTH_BYTE 4
#define MAC_2_INDEX_MAC_ADDRESS_SIXTH_BYTE 5

#define MAC_2_INDEX_MAC_ADDRESS_SECOND_BYTE_OFFSET 8
#define MAC_2_INDEX_MAC_ADDRESS_THIRD_BYTE_OFFSET 16
#define MAC_2_INDEX_MAC_ADDRESS_FORTH_BYTE_OFFSET 24
#define MAC_2_INDEX_MAC_ADDRESS_SIXTH_BYTE_OFFSET 8

#define MAC_2_INDEX_ERROR_SEARCH_OR_REMOVED_FAILED_MASK                          0x2
#define MAC_2_INDEX_ERROR_MAC_ADDRESS_ALREADY_EXIST_MASK                         0x4
#define MAC_2_INDEX_ERROR_DATABASE_FULL_MASK                                     0x8

#define MAC_2_INDEX_ERROR_INDICATION (MAC_2_INDEX_ERROR_SEARCH_OR_REMOVED_FAILED_MASK   | \
									  MAC_2_INDEX_ERROR_MAC_ADDRESS_ALREADY_EXIST_MASK  | \
									  MAC_2_INDEX_ERROR_DATABASE_FULL_MASK)

/*An interrupt or higher priority task may preempt the running task while it is waiting for the mac 2 index command to be completed
Since we do not want to disable interrupts for this we use a timeout value that shoudl also take these into consideration*/
#define MAC_2_INDEX_MAX_MICROS_WAITING_FOR_DONE 10000

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum
{
	MAC_2_INDEX_COMMAND_SEARCH = 0,
	MAC_2_INDEX_COMMAND_ADD,
	MAC_2_INDEX_COMMAND_REMOVE_BY_ADDRESS,
	MAC_2_INDEX_COMMAND_REMOVE_BY_INDEX,
	MAC_2_INDEX_COMMAND_INITIALIZE
} Mac2IndexCommands_e;



#endif /* MAC_2_INDEX_H_ */

