/***********************************************************************************
 File:			NdpaManager_Api.h
 Module:		Ndpa Manager Api
 Purpose: 		
 Description:	This file contains structures definitions of messages between NDPA 
 				manager and Training manager
************************************************************************************/
#ifndef NDPA_MANAGER_API_H_
#define NDPA_MANAGER_API_H_

#ifndef TRAINING_WAVE600_Z0
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "OSAL_Kmsg.h"
#include "PacketDescriptor.h"
#include "TrainingManager_Api.h"
#include "TxSender_TrainingApi.h"



//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define MAX_NDPA_DURATION				32000  // the value must be in micro


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct _NdpaManagerStartTxReq_t
{
	Bandwidth_e currentBw;
    StaId       trainingVector[GROUP_MANAGER_MAX_NUM_OF_STA_FOR_MU_TRAINING];
	uint8		numOfStations;
    uint8       vapId;
} NdpaManagerStartTxReq_t;


typedef struct _NdpaManagerPacketConfirmed_t
{
	TxPd_t *pd;
} NdpaManagerPacketConfirmed_t;

/* this structure is written by NDPA manager to SHRAM for Sender's use. Num of stations 
is not required provided in NDPA msg PD*/

typedef struct _TxSenderTrainingStationsDb_t
{
	TxSenderTrainingPerStaParams_t 	staInfo[GROUP_MANAGER_MAX_NUM_OF_STA_FOR_MU_TRAINING];
} TxSenderTrainingStationsDb_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void ndpaManager_Init(); // TODO: save this func for debug
void NdpaManager_StartTxReq(NdpaManagerStartTxReq_t *ndpaStartTxParams);
void NdpaManager_StopTxReq(void);
void NdpaManager_TxCfm(K_MSG *ndpaManagerMessage);
void NdpaManager_PdAllocated(K_MSG *ndpaManagerMessage);
void NdpaManager_QueueLockCfm(K_MSG *ndpaManagerMessage);
void NdpaManager_LaBfReportInd(K_MSG *ndpaManagerMessage);

#endif// TRAINING_WAVE600_Z0

#endif // NDPA_MANAGER_API_H





