/***********************************************************************************
 File:			NdpaManager.h
 Module:		Ndpa Manager 
 Purpose: 		To create NDPA message and to monitor BF sequence per specific training session
 Description:	This file contains definitions and structures of the NDPA 
 				manager 
************************************************************************************/
#ifndef NDPA_MANAGER_H_
#define NDPA_MANAGER_H_

#ifndef TRAINING_WAVE600_Z0

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "NdpaManager_Api.h"


 //---------------------------------------------------------------------------------
 // 					 Defines					 
 //---------------------------------------------------------------------------------
 // NDPA Manager events
 typedef enum
 {
 	 NDPA_MANAGER_EVENT_START_TX_REQ, 		// 0x0
 	 NDPA_MANAGER_EVENT_STOP_TX_REQ,		// 0x1
	 NDPA_MANAGER_EVENT_TX_CFM, 		 	// 0x2
	 NDPA_MANAGER_EVENT_PD_ALLOCATED,	 	// 0x3
	 NDPA_MANAGER_EVENT_LOCK_CONFIRMED,  	// 0x4
	 NDPA_MANAGER_EVENT_LA_BF_REPORT_IND,  	// 0x5
	 NDPA_MANAGER_EVENT_NUM_EVENTS,		 	// 0x6
 } NdpaManagerEvents_e;
	 
 //NDPA Manager states
 typedef enum
 {
	 NDPA_MANAGER_STATE_IDLE,						 			// 0x0
	 NDPA_MANAGER_STATE_WAIT_TRAINING_END_PD_NOT_RELEASED,		// 0x1
	 NDPA_MANAGER_STATE_WAIT_TRAINING_END_PD_RELEASED,			// 0x2
	 NDPA_MANAGER_STATE_WAIT_FOR_LOCK,	 						// 0x3
	 NDPA_MANAGER_STATE_WAIT_FOR_PD,							// 0x4
	 NDPA_MANAGER_STATE_WAIT_FOR_PD_RELEASE,					// 0x5
	 NDPA_MANAGER_STATE_WAIT_FOR_PD_PENDING_STOP, 				// 0x6
	 NDPA_MANAGER_STATE_WAIT_FOR_LOCK_PD_RELEASED,  			// 0x7
	 NDPA_MANAGER_STATE_WAIT_FOR_LOCK_TRAINING_ENDED,			// 0x8
	 NDPA_MANAGER_STATE_NUM_STATES,	 				 			// 0x9
	 NDPA_MANAGER_MAX_STATE = 0xFF,					 
 } NdpaManagerState_e;
typedef enum
{
	NDPA_SINGLE_USER = 0,
	NDPA_MULTI_USER,
}NdpaFeedbackType_e;
 typedef struct _NdpaManagerDb_t
{
#if defined(ENET_INC_ARCH_WAVE600)	
	uint32	 							ndpaPdOffset; 			// offset of received pd
#else
	uint16								ndpaPdOffset;			// offset of received pd
#endif
	uint16								pdRequestId;			//  request Id returned by Resource Manager in pending PD case
	NdpaManagerState_e 					state;        			// current state of NDPA manager
	bool	 							bfIndReceived; 			// Boolean indicates whether BF indication was received or not
	TrainingManagerNdpaCfmStatus_e 		bfReportStatus; 		// Boolean Indicates status of received BF_in report	
	bool	 							pdReleased; 			// Boolean indicates if NDPA Pd was released or not
	uint8								vapId;					// VAP ID of current group
	uint8								numOfStations;			// num of stations passed in NdpaStartTx
	Bandwidth_e							bw;						// max limit bw of stations participating in training
} NdpaManagerDb_t;

// Function pointer 
typedef void (*NdpaManager_Func)(void *parameter);


// Ndpa State Machine
typedef struct _NdpaManagerSm_t
{
	NdpaManager_Func handler[NDPA_MANAGER_EVENT_NUM_EVENTS];	
} NdpaManagerSm_t;

#endif// TRAINING_WAVE600_Z0


#endif
