/************************************************************************************
*    
*    File:		  OSAL_Api.h
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

#ifndef OSAL_API_H
#define OSAL_API_H

#include "System_GlobalDefinitions.h"
#include "OSAL_Interrupts.h"
#include "OSAL_Kmsg.h"
#include "OSAL_Tasks.h"
#include "OSAL_UpperMacMessages.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "fw_utils_queue.h"
#include "tx_application_Api.h"
#include "tx_api.h"
#include "ipc_api.h"
#include "ConfigurationManager_api.h"

#else
#if defined (ENET_INC_UMAC)

#include "fw_utils_queue.h"
#include "tx_application_Api.h"
#include "tx_api.h"
#else 
#include "TinyKernel_Api.h"
#endif
#endif //wave 600


#define OSAL_TIMERS_K_TICKS_PER_SECOND			100
#define	VAP_0									(0x0)

#if defined (ENET_INC_ARCH_WAVE600)
#define GET_DEFAULT_VAP_FOR_MY_BAND()			ConfigurationManager_GetFirstVapForMyBand()		
#else
#define GET_DEFAULT_VAP_FOR_MY_BAND()			0 //In gen5 Default vap is always 0

#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// Call desired implementation of Operating System
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
#if defined (ENET_INC_ARCH_WAVE600) || defined (ENET_INC_UMAC)

#include "kernel.h"
#include "kcctimer_Api.h"

#define OSAL_INIT_QUEUE(B)						FwUtils_InitQueue(B)
#define OSAL_DEQUEUE_MSG(B)						FWUTILS_DEQUEUE(B)
#define OSAL_IS_QUEUE_EMPTY(B)					FWUTILS_IS_QUEUE_EMPTY(B)
#define OSAL_QUEUE_MSG(B,M)						FWUTILS_ENQUEUE(B,M)
#define OSAL_SET_STATE(P,S)						(*P=S)
#define OSAL_INIT_PERSISTENT_MSG(M,L)			TxApp_InitPersistentMsg(M,L)
#define OSAL_GET_MESSAGE(L)						TxApp_GetDefaultMessage(L)
#define OSAL_FREE_MESSAGE(M,P)					TxApp_FreeMessage(M,P)
#define OSAL_SEND_MESSAGE(MT,T,M,V)				TxApp_SendMessage(MT,T,M, TX_NO_WAIT,V)
#define OSAL_SEND_MESSAGE_TO_FRONT(MT,T,M,V)	TxApp_SendFrontMessage(MT,T,M,TX_NO_WAIT,V)
#define OSAL_SEND_NO_DATA_MESSAGE(MT,T,V)		TxApp_SendNoDataFastMessage(MT, T, TX_NO_WAIT,V)
#define OSAL_SET_MESSAGE_ORIGINATOR(M)			TxApp_SetMessageOriginatorTaskId(M)
#define OSAL_GET_MESSAGE_ORIGINATOR(M,T)		TxApp_GetMessageOriginator(M,T)
#define OSAL_DEC_MSG_REF_COUNT(M)				TxApp_DecMsgRefCount(M)
#define OSAL_START_SCHEDULER()					TxApp_KernelEnter(); 
#define OSAL_GET_TIMER_TICKS()					TxApp_GetTimerTicks()
#define OSAL_SET_TIMER_EXPLICIT(M,T,TASK)		TxApp_SetTimer(M,T)
#define OSAL_RESET_TIMER_EXPLICIT(M,TASK)		TxApp_ResetTimer(M,TASK)
#define OSAL_SET_TIMER(M,T)						OSAL_SET_TIMER_EXPLICIT(M,T,bKNLgetRunningTaskId())
#define OSAL_RESET_TIMER(M)						OSAL_RESET_TIMER_EXPLICIT(M,bKNLgetRunningTaskId())


#define OSAL_CPU_SERVICE_COOPERATION()		TxApp_Thread_Relinquish()
#define OSAL_IS_THREAD_QUEUE_EMPTY(T) 		TxApp_IsThreadsQueueEmpty(T)

#define OSAL_TIMERS_MS_TO_K_TICKS(ms)			((ms*OSAL_TIMERS_K_TICKS_PER_SECOND)/1000)
#define OSAL_TIMERS_ROUNDUP_MS_TO_K_TICKS(ms)	(((ms*OSAL_TIMERS_K_TICKS_PER_SECOND)+999)/1000)



#elif defined (ENET_INC_LMAC)
#define OSAL_STATE_MACHINE(T,D,M)			TinyKernel_StateMachine(T,D,M) //TBD: remove
#define OSAL_SET_STATE(P,S)					(*P=S) //TBD: remove
#define OSAL_INIT_QUEUE(B)					TinyKernel_InitQueue(B)
#define OSAL_DEQUEUE_MSG(B)					TinyKernel_DequeueMsg(B)
#define OSAL_IS_QUEUE_EMPTY(B)				TinyKernel_IsQueueEmpty(B)
#define OSAL_QUEUE_MSG(B,M)					TinyKernel_QueueMsg(B,M)
#define OSAL_INIT_PERSISTENT_MSG(M,L)		TinyKernel_InitPersistentMsg(M,L)
#define OSAL_GET_MESSAGE(L)					TinyKernel_GetFastMessage(L)
#define OSAL_SEND_MESSAGE(MT,T,M,V)			TinyKernel_SendMessage(MT,T,M,V)
#define OSAL_SEND_NO_DATA_MESSAGE(MT,T,V)	OSAL_SEND_MESSAGE(MT,T,OSAL_GET_MESSAGE(K_NO_DATA),V)
#define OSAL_SET_MESSAGE_ORIGINATOR(M)		TinyKernel_SetMessageOriginator(M)
#define OSAL_GET_MESSAGE_ORIGINATOR(M,T)	TinyKernel_GetMessageOriginator(M,T)
#define OSAL_INC_MSG_REF_COUNT(M)			TinyKernel_IncMsgRefCount(M)
#define OSAL_DEC_MSG_REF_COUNT(M)			TinyKernel_DecMsgRefCount(M)
#define OSAL_START_SCHEDULER()				TinyKernel_StartScheduler()
#define OSAL_INIT()							{TinyKernel_InitMessages();TinyKernel_InitScheduler();}
 


#endif


#endif //OSAL_API_H
