/************************************************************************************
*	
*	File:		  OSAL_Interrupts.h
*	Class/Module: 
*	Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*	COPYRIGHT: 
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

#ifndef OSAL_INTERRUPTS_H
#define OSAL_INTERRUPTS_H
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "InterruptManager_Api.h"

/* Macros to disable and enable every interrupt */
#ifndef TX_INTERRUPT_SAVE_AREA

#define TX_INTERRUPT_SAVE_AREA      unsigned int interrupt_save

#endif /*not defined TX_INTERRUPT_SAVE_AREA*/
#if defined (ANALYZE_DISABLE_INTERRUPT)
#define OSAL_DISABLE_INTERRUPTS(pInterrupt_save)	InterruptManager_DisableAllInterrupts(pInterrupt_save, __FILE__,__LINE__)
#define OSAL_ENABLE_INTERRUPTS(Interrupt_save)		InterruptManager_EnableAllInterrupts(Interrupt_save, __FILE__,__LINE__)
#else
#define OSAL_DISABLE_INTERRUPTS(pInterrupt_save)	InterruptManager_DisableAllInterrupts(pInterrupt_save)
#define OSAL_ENABLE_INTERRUPTS(Interrupt_save)	InterruptManager_EnableAllInterrupts(Interrupt_save)
#endif	

#endif //OSAL_INTERRUPTS_H
