/************************************************************************************
*	
*	File:		  OSAL_Kmsg.h
*	Class/Module: 
*	Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*	COPYRIGHT: 
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

#ifndef OSAL_KMSG_H
#define OSAL_KMSG_H

#include "System_GlobalDefinitions.h"
#ifndef ENET_INC_LMAC
#include "tx_api.h"
#endif 
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// Kernel Generic Message
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

typedef uint16	K_MSG_TYPE;
typedef uint8	K_TASKID;

typedef struct _K_TASKREF
{
	K_TASKID	taskID;
	uint8		stub;
} K_TASKREF;

typedef uint8	K_STATE;
typedef uint16	K_LEN;

typedef struct _K_MSG K_MSG;

typedef struct _K_MSG_HEADER
{
	K_MSG			*psNext;
	byte			bListNoAndRefCount;
	byte			bPersistentMsg;
	K_MSG_TYPE		tKMsgType;
	K_TASKREF		sFrom;
	K_TASKREF		sTo;

	/* vapId is 32 bit to align to 8 bytes - as needed by MIPS  (could be 8 bytes only)*/
	uint8			vapId;  ///dest vap's namber 
	uint8			dispBit;//used by the ipc to set msg that arrived with data on the shram
	uint16			payloadSize;
} K_MSG_HEADER;

struct _K_MSG
{
	/* private for kernel only */
	K_MSG_HEADER	header;
	/* public for application */
	byte			abData[]; //no need for array size because K_MSG type is never allocated, but rather used as a cast to other structures that hold a K_MSG_HEADER
};

/****************************************************************************
 * Kernel Message Buffer
 ****************************************************************************/

#if !defined (ENET_INC_ARCH_WAVE600) 
#ifdef ENET_INC_LMAC
typedef struct 
{
	K_MSG		*head;
	K_MSG		*tail;
	uint32		maxPayload;	
} FwUtils_queue_t;


#endif

#endif


/****************************************************************************
 * Kernel State Machine Transition
 ****************************************************************************/
#if defined (ENET_INC_ARCH_WAVE600) ||  defined (ENET_INC_UMAC)
typedef void (*K_ACTION)(K_STATE*, K_MSG *);

typedef struct K_TRANS
{
    K_MSG_TYPE  tKMsgType;
    K_STATE     bNextState;
    K_ACTION    rActionFunction;
} K_TRANS;

#endif 



#define pK_MSG_DATA(P)	  (P)->abData


#endif //OSAL_KMSG_H
