/************************************************************************************
*    
*    File:		  OSAL_Tasks.h
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

#ifndef OSAL_TASKS_H
#define OSAL_TASKS_H

#include "OSAL_Kmsg.h"

#define TASK(T)   void       T(K_MSG * psMSG)

/****************************************************************************
 * Task Descriptor
 ****************************************************************************/
/* function prototype for task entry point functions */
typedef void (*RKNL)(K_MSG *);

/* structure of entries in the task table (defined by the application) */
typedef struct KNL_TD
{
    RKNL    rFunction;
} KNL_TD;


typedef enum
{
	TASK_KNL_TIMER_TICK,
	TASK_KNL_TIMER_HIGH,
	TASK_IPC_2,
	TASK_LINK_ADAPTATION,
	TASK_PAC_MANAGER,
	TASK_HIGH_PRIORITY_LIMIT = TASK_PAC_MANAGER,
	TASK_KNL_TIMER_MID,
	TASK_MID_PRIORITY_LIMIT = TASK_KNL_TIMER_MID,
	TASK_KNL_TIMER_LOW,
	TASK_UM_IF_TASK,
	TASK_BSS_MANAGE,
	TASK_TS_MANAGER,
	TASK_QOS,
	TASK_ENCRYPTION,
	TASK_LOGGER,
	TASK_IPC,
#ifdef PTA_BUILD_IN_PLAT	
	TASK_PTA,
#endif
	TASK_DUT,
	TASK_INTERFERER_DETECTION,			
	TASK_COC,
	TASK_HDK,
	TASK_HIM,
	TASK_RX_MANAGER,
	TASK_TX_MANAGER,	
	TASK_BSS_MANAGER,
	TASK_CHANNEL_SWITCH_MANAGER,
#ifdef USE_AGER_EMULATOR
	TASK_AGER_EMULATOR,
#endif //USE_AGER_EMULATOR
	TASK_STATISTICS_MANAGER,
	TASK_PROCESS_MANAGER,
	TASK_GROUP_MANAGER,
	TASK_ATF,
#if defined (ENET_INC_ARCH_WAVE600) 	
	TASK_HE_GROUP_MANAGER,
	TASK_PLAN_MANAGER,
	TASK_TWT_MANAGER,
#endif	
	TASK_HDK_CDB_MANAGER,
#ifdef HDK_CDB_SUPPORT
	TASK_PROCESS_MANAGER_CDB,
#endif
	NUM_OF_TASKS_IN_SYSTEM,
	TASK_INVALID,
	MSG_FROM_DRIVER = 66,
	THREADX_TIMER = 77,
	MSG_TO_FW = 88,
	INTERRUPT_SUB_ROUTINE = 99,	
	//special task for interrupt context
	TASK_KNL_INTERRUPT_CONTEXT = NUM_OF_TASKS_IN_SYSTEM,
} Sys_Tasks_e;






#define OSAL_IS_HIGH_PRIORITY_TASK(t)	(t <= TASK_HIGH_PRIORITY_LIMIT)
#define OSAL_IS_MID_PRIORITY_TASK(t)	(t <= TASK_MID_PRIORITY_LIMIT)

extern const KNL_TD asAPP_TaskTable[NUM_OF_TASKS_IN_SYSTEM];

#endif //OSAL_TASKS_H

