/************************************************************************************
*    
*    File:		  OSAL_UpperMacMessages.h
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/
#ifndef OSAL_UPPER_MAC_MESSAGES_H
#define OSAL_UPPER_MAC_MESSAGES_H

#include "mhi_ieee_address.h"
#include "mhi_umi_propr.h"
#include "lmi.h"

/*********** DO NOT REMOVE THE COMMENTS BESIDE THE MESSAGES NAMES ***********/

typedef enum _UpperMacMessages_e
{
	OSAL_TASK_UNUSED_MSG = 0,//do not change, msgID =0 used by the bss 

	/*Logger*/
	TASK_LOGGER_START,
	KMSG_LOGGER_LM_LOGGER_GENERAL_CFM  = TASK_LOGGER_START,
 #if (defined( ENET_INC_UMAC) || defined (ENET_INC_LMAC))
	KMSG_LOGGER_LM_LOGGER_BUFFER_IND,
#endif
	KMSG_LOGGER_UM_SEND_BUFFER, 						// LoggerBufferInfo_t
	KMSG_LOGGER_DBG_TRACE_IND,	
	TASK_LOGGER_END,

	/*DUT*/
	TASK_DUT_START,
	DUT_MSG_REQ = TASK_DUT_START,						// dutMessage_t
	DUT_ADD_VAP,										// BSS_MANAGER_CONFIRM_EVENT ???
	DUT_REMOVE_VAP,										// UMI_REMOVE_VAP
	DUT_SET_FIXED_RATE_CFM,
	DUT_SET_TX_POWER_CFM,
	DUT_SET_TX_ANT_CFM,
	DUT_START_DUT_PROCESS,
	DUT_FINALIZE_DUT_PROCESS,
	DUT_MSG_CFM,
	DUT_UPDATE_TX_RX_ANTS_FROM_COC,
	DUT_TRANSMIT_PACKET_CFM,
	DUT_OPERATION_MODE_UPDATE_RES,
	DUT_GET_RX_COUNT_CFM,
#ifdef ENET_INC_ARCH_WAVE600	
	DUT_GET_PHY_RATE_CFM,
#endif
	DUT_ACTION_PACKET_CB_HNDLR_REQ,
	TASK_DUT_END,


	// BSS Manager
	TASK_BSS_MANAGE_START,
    BSS_MANAGE_BSS_RETURN_RESOURCE = TASK_BSS_MANAGE_START,
	BSS_MANAGE_UM_NETWORK_EVENT_RES,
	BSS_MANAGE_PAC_START_CFM,
	BSS_MANAGER_LINK_ADAPTATION_REMOVE_VAP_CFM,			// UMI_REMOVE_VAP 
 	TASK_BSS_MANAGE_END,

	
	//messages for TASK_IPC
	TASK_IPC_START,	
	IPC_NEW_MSG_FROM_OTHER_CORE = TASK_IPC_START,	
	TASK_IPC_END,
	
	// ENCRYPTION
	TASK_ENCRYPTION_START,
	ENCRYPTION_ADD_STA = TASK_ENCRYPTION_START,			// BssManagerStaManagerReq_t
	ENCRYPTION_LOCK_STA,								// LockReqCb_t
	ENCRYPTION_SET_FILTER,								// BssManagerStaManagerReq_t
	ENCRYPTION_SET_KEY_STA,								// UMI_SET_KEY
	ENCRYPTION_SET_STA_INDEX,							// UMI_DEFAULT_KEY_INDEX
	ENCRYPTION_REMOVE_STA,								// BssManagerStaManagerReq_t
	ENCRYPTION_LOCK_GPHP,								// LockReqCb_t
	ENCRYPTION_ADD_VAP,									
	ENCRYPTION_LOCK_VAP,								// LockReqCb_t
	ENCRYPTION_SET_KEY_VAP,								// UMI_SET_KEY 
	ENCRYPTION_SET_VAP_INDEX,							// UMI_DEFAULT_KEY_INDEX 
	ENCRYPTION_REMOVE_VAP,								// UMI_REMOVE_VAP 
	TASK_ENCRYPTION_END,

	// INTERFERER DETECTION
	TASK_INTERFERER_DETECTION_START,
	INTERFERER_DETECTION_SET_CHANNEL = TASK_INTERFERER_DETECTION_START,		// InterfererDetectionSetChannelMessageParameters_t 
#if defined RADAR_DETECTION_ENABLED
	INTERFERER_DETECTION_RADAR_DETECTION_SAMPLES,							// InterfererDetectionRadarDetectionSamplesMessageParameters_t 
#endif
	INTERFERER_DETECTION_CONTINUOUS_INTERFERER_DETECTION_SAMPLES,			// InterfererDetectionBtInterfererDetectionSamplesMessageParameters 
	INTERFERER_DETECTION_SET_INTERFERER_DETECTION_PARAMETERS,				// UMI_INTERFERER_DETECTION_PARAMS 
	INTERFERER_DETECTION_ENABLE_RADAR_INDICATION,							// UMI_ENABLE_RADAR_INDICATION 
#if defined RADAR_DETECTION_ENABLED
	INTERFERER_DETECTION_RADAR_AGING_TIMER,
#endif
	INTERFERER_DETECTION_SET_RADIO_STATE,									// InterfererDetectionSetRadioState_t
	INTERFERER_DETECTION_CONTINUOUS_INTERFERER_RES_ARRIVED,
	TASK_INTERFERER_DETECTION_END,

	// COC
	TASK_COC_START,
	COC_SET_ANTENNAS_REQ = TASK_COC_START,				// UMI_SET_ANTENNAS
	COC_PROCESS_STARTED,								// ProcessRequestParams_t
	COC_PROCESS_ENDED,									// ProcessRequestParams_t
	COC_HDK_SET_ANTS_CFM,								// cocReq_t
	COC_LINK_ADAPTIVE_SET_ANTS_CFM, 					// LinkAdaptationFixedAntennaSelection_t
	COC_ADD_VAP,										
	COC_REMOVE_VAP, 									// UMI_REMOVE_VAP
	COC_UPDATE_ANT_CONFIG_FROM_HDK,
	COC_MULTI_USER_RESET_OPERATION_CFM,
	TASK_COC_END,
	
	// HDK
	TASK_HDK_START,
	HDK_SET_HDK_CONFIG_REQ = TASK_HDK_START,			// UMI_HDK_CONFIG 
	HDK_DOWNLOAD_PROG_MODEL_PERMISSION_REQ,
	HDK_DOWNLOAD_PROG_MODEL_REQ,						// UMI_PROG_MODEL_20_40_DIFFS_PARAMS
	HDK_DOWNLOAD_PROG_MODEL_DIFFS_REQ,					// UMI_PROG_MODEL_20_40_DIFFS_PARAMS
	HDK_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_REQ,
	HDK_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_REQ,
	HDK_PLATFORM_DATA_FIELDS_REQ,						// platformDataFields_t
	HDK_PLATFORM_TABLE_REQ, 							// platformTable_t 
	HDK_SET_CHANNEL_REQ,								// HdkSetChannelReqParams_t
	HDK_LA_SET_CHANNEL_DATA_CFM,
	HDK_CHANNEL_NOTIFICATION_CFM,
	HDK_CHUNK_DMA_COMPLETE,
	HDK_SCHED_ONLINE_CALIBRATION_REQ,
	HDK_ONLINE_CALIB_PROCESS_STARTED,					// ProcessManagerReturnParams_t
	HDK_FINISH_ONLINE_CALIBRATION_REQ,
	HDK_ONLINE_CALIB_PROCESS_ENDED,
	HDK_CALIBRATE_REQ,									// UMI_CALIBRATE_PARAMS
	HDK_CALIBRATE_PROCESS_STARTED,						// ProcessManagerReturnParams_t
	HDK_CALIBRATE_PROCESS_ENDED,
	HDK_ADD_VAP_BAND_CONFIG_REQ,
	HDK_REMOVE_VAP_BAND_CONFIG_REQ,	
	HDK_REMOVE_NON_LAST_VAP_REQ, 
	HDK_POST_ACTIVATION_VAP,							
	HDK_SET_TPC_ANT_PARAMS_REQ, 						// tpcAntParams_t
	HDK_SET_TPC_CONFIG_REQ, 							// tpcConfig_t
#if defined RADAR_DETECTION_ENABLED
	HDK_RADAR_DETECTION_TIMER,
#endif
	HDK_CONTINUOUS_INTERFERER_DETECTION_TIMER,
#if !defined (HDK_REL_2_0)	
	HDK_AFE_SET_CALIBRATION_DATA,						// afe_calibration_data_t 
	HDK_RFIC_SET_CALIBRATION_DATA,						// rfic_calibration_data_t 
	HDK_RSSI_CALIBRATION_DATA,							// rssiPathCalibrationHeaderParams_t 
#endif
	HDK_COC_SET_ANTENNAS_REQ,							// cocReq_t
	HDK_CHANGE_RADIO_STATE_REQ, 						// UMI_ENABLE_RADIO
	HDK_CHANGE_RADIO_STATE_PROCESS_STARTED, 			// ProcessManagerReturnParams_t
	HDK_CHANGE_RADIO_STATE_PROCESS_ENDED,
	HDK_USER_DEMAND_REQ,
	HDK_USER_DEMAND_PROCESS_STARTED,					// ProcessManagerReturnParams_t
	HDK_USER_DEMAND_PROCESS_ENDED,
	HDK_CCA_TH_REQ, 									// UMI_CCA_TH_t 
	HDK_SET_POWER_SELECTION,							// UMI_TX_POWER_LIMIT
	HDK_SET_11B_ANT_SEL_REQ,							// UMI_ANT_SELECTION_11B 
	HDK_GET_CCA_TH_REQ, 								// UMI_CCA_TH_t 
	HDK_FREQ_JUMP_MODE_REQ, 							// UMI_ENABLE_FREQUENCY_JUMP_t
	HDK_INDIRECT_RESET_REQ,
	HDK_RESET_PHY_REQ,
	HDK_RESET_RF_REQ,	
	HDK_RESET_RF_BAND_REQ,
	HDK_CONFIG_SM_HW_DEPENDENT_REQ,
	HDK_RUN_OFFLINE_CALIBRATION_REQ,
	HDK_RUN_OFFLINE_CALIBRATION_ON_FIRST_CHANNEL_REQ,
	HDK_RUN_OFFLINE_CALIBRATION_ON_NEXT_CHANNEL_REQ,
#if defined HDK_CDB_SUPPORT
	HDK_PAUSE_NON_CALIBRATING_BAND_REQ,
	HDK_OTHER_CORE_CALIBRATE_PROCESS_STARTED,
	HDK_RESUME_NON_CALIBRATING_BAND_REQ,
	HDK_OTHER_CORE_CALIBRATE_PROCESS_ENDED,
#endif
	HDK_RESUME_CALIBRATING_BAND_REQ,
	HDK_FINISH_OFFLINE_CALIBRATION_REQ,
	HDK_BAND_STATE_CHANGED_RES,
	HDK_SET_SSB_MODE_REQ,
	HDK_RADAR_DETECTION_RSSI_TH_CONFIG_REQ,
	HDK_SET_PROCESS_AND_DISABLE_ALL_ANTS_REQ,
	HDK_DISABLE_ALL_ANTS_REQ,
	HDK_SET_ANT_CONFIG_PROCESS_SCHED,
	HDK_SET_ANT_CONFIG_REQ,
	HDK_SET_ANT_CONFIG_NOTIFICATION_CFM,
	HDK_SET_ANT_CONFIG_PROCESS_END,
	HDK_SET_MAX_ANTS_REQ,
	HDK_SET_OPERATIONAL_ANT_CONFIG_REQ,
	HDK_SET_RX_DUTY_CYCLE_REQ,
	HDK_SET_RX_TH_REQ,
#ifndef ENET_INC_ARCH_WAVE600
	HDK_SET_MIN_RSSI_REQ,
#endif
#ifdef ENET_INC_ARCH_WAVE600
	HDK_RXDC_ANALOG_CONFIG_CLI,
	HDK_RXDC_DIGITAL_CONFIG_CLI,
#endif
	HDK_GET_PHY_STATISTICS,
	HDK_ERP_SET_REQ,									// UMI_ERP_SET
	HDK_ERP_TIMER_EXPIRED,
	HDK_ERP_PROCESS_START,
	HDK_ERP_END_PROCESS,
	HDK_ERP_STATION_ADD,
	HDK_ERP_STATION_REMOVE,
	HDK_ERP_BSS_TX,
	HDK_DUTY_CYCLE_SET_REQ,
	HDK_DUTY_CYCLE_TIMER_EXPIRED,
	HDK_DUTY_CYCLE_PROCESS_START,
	HDK_DUTY_CYCLE_END_PROCESS,
#if defined RADAR_DETECTION_ENABLED
	HDK_SET_RADAR_ADAPTIVE_SENS_PARAMS_REQ,
	HDK_RADAR_ADAPTIVE_SENS_ENABLE_SERIAL_TRACE,
#endif
	HDK_SET_TX_WINDOW_SIZE, 
	HDK_SET_ONLINE_TIMER,
#ifdef DEBUG_UM_INTERFACE
	HDK_IRE_SWITCH_B_REQ,								// UMI_CONTROL_t
#ifdef ENET_INC_ARCH_WAVE600
	HDK_TEST_BUS_EN_REQ,
#endif
#endif
	
	TASK_HDK_END,
	
	// HDK Cdb manager
	TASK_HDK_CDB_MAN_START,
	// HW dependent
	HDK_CDB_MAN_HW_DEPENDENT_CONFIG_REQ = TASK_HDK_CDB_MAN_START,
	HDK_CDB_MAN_HW_DEPENDENT_COMMON_CONFIG_DONE,
	//Add VAP messages
	HDK_CDB_MAN_ADD_VAP_REQ,
	HDK_CDB_MAN_ADD_VAP_COMMON_CONFIG_DONE,
	HDK_CDB_MAN_ADD_VAP_BAND_CONFIG_CFM,
	HDK_CDB_MAN_REMOVE_VAP_REQ,
	HDK_CDB_MAN_REMOVE_NON_LAST_VAP_BAND_CONFIG_CFM,
	HDK_CDB_MAN_REMOVE_VAP_BAND_CONFIG_CFM,
	
	//Common configuration process messages
	HDK_CDB_MAN_CONFIG_SM_CONFIG_REQ,
	HDK_CDB_MAN_CONFIG_SM_CONFIG_CFM,
	//Daul core offline calibration
	HDK_CDB_MAN_RUN_OFFLINE_CALIBRATION_REQ,
	HDK_CDB_MAN_OFFLINE_CALIBRATION_FINISHED_ON_ONE_CH,
	HDK_CDB_MAN_OFFLINE_CALIBRATION_FINISHED_ON_LAST_CH,
	HDK_CDB_MAN_NON_CALIBRATING_BAND_PAUSE_DONE,
	HDK_CDB_MAN_NON_CALIBRATING_BAND_RESUME_DONE,
	HDK_CDB_MAN_SET_MAX_ANTS_CFM,
	HDK_CDB_MAN_RESUME_CALIBRATING_BAND_CFM,
	HDK_CDB_MAN_RESUME_CALIBRATING_BAND_DONE,
	//Dual core online calibration	
	HDK_CDB_MAN_BAND_EN_DIS_ONLINE_CAL_REQ,
	HDK_CDB_MAN_BAND_ONLINE_TIMER_EXPIRED,
	HDK_CDB_MAN_BAND_SYNC_SERVICE_PROCESS_SCHEDULED_IND,
	HDK_CDB_MAN_BAND_SYNC_SERVICE_CTS_SENT_IND,
	HDK_CDB_MAN_BAND_ONLINE_CALIBRATION_ENDED,
	HDK_CDB_MAN_BAND_ONLINE_PROCESS_ENDED,
	HDK_CDB_MAN_ACTIVATE_DMA_REQ,
	HDK_CDB_MAN_CHUNK_DMA_COMPLETE_BAND0,
	HDK_CDB_MAN_CHUNK_DMA_COMPLETE_BAND1,
	/*Set main SM state*/
	HDK_CDB_MAN_BAND_STATE_CHANGED_IND,
	HDK_CDB_MAN_BAND_POST_VAP_ACTIVATION_IND,
	HDK_CDB_MAN_SEND_CAL_ERROR_MSG_TO_HOST_REQ,
	/*Set antenna configuration*/
	HDK_CDB_MAN_PREPARE_ANT_CONFIG_REQ,
	HDK_CDB_MAN_PREPARE_ANT_CONFIG_DONE,
	HDK_CDB_MAN_SET_ANT_CONFIG_REQ,
	HDK_CDB_MAN_SET_AFE_CAL_DATA,
	HDK_CDB_MAN_SET_RSSI_CAL_DATA,
	HDK_CDB_MAN_SET_ANT_CONFIG_DONE,
	HDK_CDB_MAN_SET_PSD_PM_ADDRESS_REQ,
	HDK_CDB_MAN_PVT_READ,
	HDK_RADAR_SERIAL_TRACE,
	TASK_HDK_CDB_MAN_END,

	// BSS MANAGER
	TASK_BSS_MANAGER_START,
	BSS_MANAGER_BSS_ADD_VAP_REQ = TASK_BSS_MANAGER_START,	// UMI_ADD_VAP
	BSS_MANAGER_BSS_SET_BSS_REQ,						// UMI_SET_BSS
	BSS_MANAGER_SET_WMM_REQ,							// UMI_SET_WMM_PARAMETERS
	BSS_MANAGER_BSS_REMOVE_VAP_REQ, 					// UMI_STOP_VAP_TRAFFIC 
	BSS_MANAGER_SET_BEACON_TEMPLATE_REQ,				// BssManagerSetTemplateReq_t
	BSS_MANAGER_STOP_VAP_TRAFFIC_REQ,					// UMI_STOP_VAP_TRAFFIC
	BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM,	// BSS_MANAGER_CONFIRM_EVENT
	BSS_MANAGER_DMA_TEMPLATE_DONE,	
	BSS_MANAGER_STA_MANAGER_ADD_STA,					// UMI_STA_ADD
	BSS_MANAGER_STA_MANAGER_SET_FILTER,					// UMI_802_1X_FILTER
	BSS_MANAGER_STA_MANAGER_STOP_TRAFFIC,				// UMI_STOP_TRAFFIC
	BSS_MANAGER_STA_MANAGER_CLOSE_STA,					// UMI_STA_REMOVE
	BSS_MANAGER_STA_MANAGER_REG_CFM,					// BssManagerStaManagerCfm_t
	BSS_MANAGE_BSS_START_ADD_VAP_PROCESS,				// ProcessManagerReturnParams_t
	BSS_MANAGE_BSS_FINALIZE_ADD_VAP_PROCESS,			// ProcessManagerReturnParams_t
	BSS_MANAGE_BSS_START_SET_BSS_PROCESS,				// ProcessManagerReturnParams_t
	BSS_MANAGE_BSS_FINALIZE_SET_BSS_PROCESS,			// ProcessManagerReturnParams_t
	BSS_MANAGE_BSS_START_SET_WMM_PARAMS_PROCESS,		// ProcessManagerReturnParams_t
	BSS_MANAGE_BSS_FINALIZE_SET_WMM_PARAMS_PROCESS,		// ProcessManagerReturnParams_t
	BSS_MANAGE_BSS_START_REMOVE_VAP_PROCESS,			// ProcessManagerReturnParams_t
	BSS_MANAGE_BSS_FINALIZE_REMOVE_VAP__PROCESS,		// ProcessManagerReturnParams_t
	BSS_MANAGE_BSS_START_ACTIVATE_PROCESS,				// ProcessManagerReturnParams_t
	BSS_MANAGE_BSS_FINALIZE_ACTIVATE_PROCESS,			// ProcessManagerReturnParams_t
	TASK_BSS_MANAGER_END,

	// UMI
	TASK_UMI_START,
    UMI_UM_DOWNLOAD_PROG_MODEL_CFM	= TASK_UMI_START,	
	UMI_UM_LM_STOP_CFM,
	UMI_BSS_PRE_ACTIVATE_CFM,							// ProcessManagerReturnParams_t
	UMI_BSS_ADD_VAP_CFM,								// ProcessManagerReturnParams_t 
	UMI_BSS_REMOVE_VAP_CFM,								// UMI_STOP_VAP_TRAFFIC 
	UMI_BSS_STOP_VAP_TRAFFIC_CFM,						// UMI_STOP_VAP_TRAFFIC
	UMI_BSS_SET_BSS_CFM,								// UMI_SET_BSS 
	UMI_UM_SET_ANTENNAS_CFM,
	UMI_MC_MAN_SET_BCL_CFM,								// UMI_BCL_REQUEST 
	UMI_MC_MAN_QUERY_BCL_CFM,							// UMI_BCL_REQUEST 
 	UMI_MC_MAN_GENERIC_MAC_CFM,
	UMI_MC_MAN_SW_RESET_MAC_CFM,
 	UMI_MC_MAN_SET_KEY_CFM,								// UMI_SET_KEY 
	UMI_MC_MAN_GET_CHANNEL_LOAD_CFM,					// UMI_GET_CHANNEL_LOAD_REQ 
	UMI_MC_MAN_GET_GROUP_PN_CFM,
	UMI_MC_MAN_MAC_EVENT_IND,							// UMI_MAC_EVENT
	UMI_MC_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_CFM,
	UMI_MC_DBG_LOGGER_FLUSH_BUF_CFM,					// UmiLoggerMsgFlushBuffer_t 
	UMI_MC_DBG_LOGGER_SET_MODE_CFM,
	UMI_MC_DBG_LOGGER_SET_SEVERITY_CFM,					// UmiLoggerMsgSetSeverity_t 
	UMI_MC_DBG_LOGGER_SET_FILTER_CFM,					// UmiLoggerMsgSetFilter_t 
	UMI_MC_MAN_SET_INTERFERER_DETECTION_PARAMS_CFM,		// UMI_INTERFERER_DETECTION_PARAMS
	UMI_MC_MAN_CONTINUOUS_INTERFERER_IND,
	UMI_MC_MAN_RADAR_IND,
	UMI_MC_MAN_ENABLE_RADAR_INDICATION_CFM,				// UMI_ENABLE_RADAR_INDICATION 
	UMI_KMSG_HW_DEPENDENT_CONFIG_CFM,					// UmiHwDependentConfig_t 
	UMI_MC_DBG_TRACE_IND,								// UmiDbgTraceInd_t 
	UMI_DUT_MSG_CFM,									// dutMessage_t 
	UMI_UM_SET_CHAN_CFM,								// UM_SET_CHAN_PARAMS 
	UMI_MAN_SEND_11B_SET_ANT_CFM,
	UMI_STA_ADD_CFM,									// UMI_STA_ADD 
	UMI_STA_REMOVE_CFM,									// UMI_STA_REMOVE 
	UMI_SET_BEACON_TEMPLATE_CFM,						// UMI_BEACON_SET 
	UMI_BEACON_TEMPLATE_WAS_SET_IND,					
	UMI_MC_MAN_REQUEST_SID_CFM,							// UMI_REQUEST_SID 
	UMI_MC_MAN_REMOVE_SID_CFM,							// UMI_REMOVE_SID 
	UMI_MC_MAN_STOP_TRAFFIC_CFM,						// UMI_STOP_TRAFFIC 
	UMI_MC_MAN_CLASS3_ERROR_IND,						// UMI_FRAME_CLASS_ERROR 
	UMI_MC_MAN_TKIP_MIC_FAILURE_INDICATION,				// UMI_TKIP_MIC_FAILURE 
	UMI_MC_MAN_SET_WMM_PARAMETERS_CFM,					// UMI_SET_WMM_PARAMETERS 
	UMI_MC_MAN_SET_DEFAULT_KEY_INDEX_CFM,				// UMI_DEFAULT_KEY_INDEX
	UMI_MC_MAN_SET_802_1X_FILTER_CFM,					// UMI_802_1X_FILTER
	UMI_MC_MAN_SET_TPC_ANT_PARAMS_CFM,					// tpcAntParams_t 
	UMI_MC_MAN_TPC_CONFIG_CFM,							// tpcConfig_t
	UMI_MC_MAN_HDK_CONFIG_CFM,							// UMI_HDK_CONFIG 
	UMI_MC_MAN_ADD_STREAM_CFM,							// UMI_ADD_STREAM_REQ_t 
	UMI_DBG_SET_FIXED_RATE_CFM,
	UMI_DOWNLOAD_PROG_MODEL_DIFFS_CFM,					// UMI_PROG_MODEL_20_40_DIFFS_PARAMS 
	UMI_MC_MAN_PLATFORM_DATA_FIELDS_CFM,				// platformDataFields_t 
	UMI_MC_MAN_PLATFORM_TABLE_CFM,						// platformTable 
	UMI_MC_MAN_SET_AFE_CALIBRATION_DATA_CFM,			// afe_calibration_data_t 
	UMI_MC_MAN_SET_RFIC_CALIBRATION_DATA_CFM,			// rfic_calibration_data_t 
	UMI_MC_MAN_SET_MULTICAST_MODE_CFM,					// UMI_MULTICAST_MODE 
	UMI_MC_MAN_MULTICAST_ACTION_CFM,					// UMI_MULTICAST_ACTION 
	UMI_MC_MAN_SET_RSSI_CAL_DATA_CFM,
	UMI_MC_MAN_ENABLE_RADIO_CFM,						// UMI_ENABLE_RADIO 
	UMI_MC_MAN_AGG_RATE_LIMIT_CFM,						// UMI_AGG_RATE_LIMIT 
	UMI_MC_MAN_SET_POWER_LIMIT_CFM,						// UMI_TX_POWER_LIMIT
	UMI_MC_MAN_GET_STATISTICS_CFM,						// UMI_GET_STATISTICS_DATA 
	UMI_MC_MAN_SET_RX_TH_CFM,							// UMI_RX_TH 
	UMI_MC_MAN_SET_RX_DUTY_CYCLE_CFM,					// UMI_RX_DUTY_CYCLE
	UMI_MC_MAN_UPDATE_ADMISSION_CAPACITY_CFM,			// UMI_UPDATE_ADMISSION_CAPACITY 
	UMI_MC_MAN_CALIBRATE_CFM,							// UMI_CALIBRATE_PARAMS
	UMI_MC_MAN_PMCU_FREQ_CHANGE_CFM,
	UMI_MC_MAN_HDK_USER_DEMAND_CFM,						// UMI_HDK_USER_DEMAND 
	UMI_MAN_QAMPLUS_ACTIVATE_CFM,						// UMI_QAMPLUS_ACTIVATE 
	UMI_MAN_TS_VAP_CONFIGURE_CFM,						// UMI_TS_VAP_CONFIGURE 
	UMI_MAN_MSDU_IN_AMSDU_CONFIG_CFM,					// UMI_MSDU_IN_AMSDU_CONFIG 
	UMI_MULTI_USER_OPERATION_SETTING_CFM,				// UMI_MU_OPERATION_CONFIG 
	UMI_MAN_CCA_TH_CFM,									// UMI_CCA_TH_t 
	UMI_RTS_MODE_SETTING_CFM,							// UMI_RTS_MODE_CONFIG 
	UMI_MAX_MPDU_LEN_CFM,								// UMI_MAX_MPDU 
	UMI_MC_MAN_FIXED_RATE_CONFIG_CFM,					
	UMI_DBG_IPC_TEST,
#ifdef RXH_MAILBOX_TEST	
	UMI_DBG_RXH_MAILBOX_TEST,
#endif //RXH_MAILBOX_TEST
	UMI_MC_MAN_BEACON_BLOCKING_IND,						// UMI_Beacon_Block_t 
	UMI_MC_MAN_BEACON_BLOCKING_INTERVAL_CFM,			// UMI_BeaconBlockTimerInterval_t 
	UMI_MAN_GET_CCA_TH_CFM,								// UMI_CCA_TH_t 
	UMI_MC_MAN_FREQ_JUMP_MODE_CFM,						// UMI_ENABLE_FREQUENCY_JUMP_t 
	UMI_MC_MAN_SET_TXOP_CONFIG_CFM,						// UMI_SET_TXOP_CONFIG_t 
	UMI_MC_MAN_ATF_QUOTAS_CFM,							// UMI_ATF_QUOTAS 
#ifdef ENET_INC_ARCH_WAVE600
	UM_MAN_STATIC_PLAN_CONFIG_CFM,
	UM_MAN_HE_MU_OPERATION_CONFIG_CFM,
#endif 
	UMI_MC_MAN_SSB_MODE_CFM,
	UMI_MC_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_CFM,
	UMI_MC_MAN_SET_ANT_CONFIG_CFM,
	UMI_MC_MAN_PREPARE_ANT_CONFIG_CFM,
    UMI_UM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_CFM,	
    UMI_UM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_CFM,
	UMI_MC_MAN_SET_QOS_PD_THRESH_CFM,					// QoSPdThresholdConfig_t 
	UMI_MC_MAN_SET_RESTRICTED_AC_MODE_CFM,				// UMI_SET_RESTRICTED_AC 
	UMI_MC_MAN_FAST_DROP_CONFIG_CFM,
	UMI_MC_MAN_ERP_SET_CFM,								// UMI_ERPSet_t 
	UMI_MC_MAN_DMR_CONFIG_CFM,							// UmiDmrConfig_t 
#ifdef ENET_INC_ARCH_WAVE600
	UMI_MC_MAN_HE_MU_DEBUG_IND,
#endif 
	UMI_MC_MAN_REG_DOMAIN_CONFIG_CFM,
#ifdef ENET_INC_ARCH_WAVE600
	UMI_MC_MAN_PVT_CFM,
#endif
	UMI_MC_MAN_CPU_LOAD_CFM,							// UmiCpuLoadCfm_t
	UMI_MC_MAN_PROTECTION_RATE_CONFIG_CFM,
	UMI_MC_MAN_2_4GHZ_COEX_CFM,	
	UMI_MC_MAN_DUTY_CYCLE_SET_CFM,						//UMI_DCSet_t 
	UMI_MC_SET_DYNAMIC_MU_TYPE_CFM,
	UMI_MC_SET_HE_MU_FIXED_PARAMETERS_CFM,
	UMI_MC_SET_HE_MU_DURATION_CFM,
#ifdef DEBUG_UM_INTERFACE
	UMI_IRE_SWITCH_B_CFM,								// UMI_CONTROL_t 
#endif
	UMI_MC_MAN_LTF_AND_GI_CONFIG_CFM,
#ifdef DEBUG_UM_INTERFACE
	UMI_MC_SLOW_PROBING_MASK_CFM,
#ifdef ENET_INC_ARCH_WAVE600
	UMI_MC_TEST_BUS_EN_CFM,
#endif
#endif
	UMI_MC_SET_RTS_THRESHOLD_CFM,						//UMI_SET_RTS_THRESHOLD
	UMI_MC_SET_RETRY_LIMIT_CFM,								//UMI_SET_RETRY_LIMIT
	UMI_MC_SET_AP_BEACON_INFO_CFM,
	TASK_UMI_END,

	/*HIM*/
	TASK_HIM_START,
	HIM_MC_DATA_INT = TASK_HIM_START,
	HIM_NEW_HDS_IN_HOST_RING,							// RingDoneData_t
    HIM_DESCRIPTORS_ON_DONE_LISTS,
    HIM_RINGS_DMA_DONE,
#ifndef TX_DATA_UM_PATH
	HIM_DESCRIPTORS_ON_READY_LISTS,
#endif	
	HIM_STA_ADD,										// BssManagerStaManagerReq_t 
    HIM_STA_SET_FILTER,								 	// BssManagerStaManagerReq_t 
    HIM_STA_STOP_TRAFFIC,								// BssManagerStaManagerReq_t 
    HIM_STA_REMOVE,										// BssManagerStaManagerReq_t 
    HIM_VAP_SET_BSS,									
    HIM_SET_WMM_PARAMS,									
    HIM_POST_VAP_ACTIVATION,							
    HIM_VAP_STOP_TRAFFIC,								// UMI_STOP_VAP_TRAFFIC 
    HIM_SET_MULTICAST_MODE,    							// UMI_MULTICAST_MODE 
	HIM_RINGS_ATF_AGEING,								// AtfAgeingMsg_t 
	HIM_RINGS_ATF_BUFFER_STATION,						// AtfMsg_t 
	HIM_SET_RESTRICTED_AC_MODE,							// UMI_SET_RESTRICTED_AC 
	TASK_HIM_END,

	/*Rx Manager*/
	TASK_RX_MANAGER_START,
	RX_MANAGER_RDS_LIST_NOT_EMPTY = TASK_RX_MANAGER_START,
	RX_MANAGER_FRAGMENTATION_EVENT,
	RX_MANAGER_CLASS_VIOLATION_EVENT,
	RX_MANAGER_TIMER,
	RX_MANAGER_CLASSIFIER_RESOURCE_TIMEOUT,
	RX_MANAGER_CLASSIFIER_RSSI_MODE,
	RX_MANAGER_CLASSIFIER_NORMAL_MODE,
	RX_MANAGER_CONFIG_RSSI_MODE,
	RX_MANAGER_CONFIG_NORMAL_MODE,
	RX_MANAGER_DMA_COMPLETED,
	RX_MANAGER_STA_OPEN,								// BssManagerStaManagerReq_t 
	RX_MANAGER_STA_SET_FILTER,							// BssManagerStaManagerReq_t 
	RX_MANAGER_STA_STOP_TRAFFIC,						// BssManagerStaManagerReq_t 
	RX_MANAGER_REMOVE_STATION,							// BssManagerStaManagerReq_t 
	RX_MANAGER_PS_SETTINGS_FIFO_NOT_EMPTY,
	RX_MANAGER_ADD_VAP,									
	RX_MANAGER_REMOVE_VAP,								// UMI_REMOVE_VAP
	RX_MANAGER_LA_SET_ANTS_CFM,							// UmiDbgCliReq_t
	RX_MANAGER_UPDATE_DUT_OPERATION_MODE_IND,
	RX_MANAGER_SET_DUT_RX_COUNT_REQ,
	RX_MANAGER_GET_DUT_RX_COUNT_REQ,	
	TASK_RX_MANAGER_END,
	
	/* TS MANAGER */
	TASK_TS_MANAGER_START,
	TS_MANAGER_ADD_STATION = TASK_TS_MANAGER_START,		// BssManagerStaManagerReq_t
	TS_MANAGER_SET_FILTER,								// BssManagerStaManagerReq_t
	TS_MANAGER_REMOVE_STATION,							// BssManagerStaManagerReq_t
	TS_MANAGER_ACTION_PACKET_RECEIVED,					// TsManagerPacketReceivedMessage_t
	TS_MANAGER_BAR_PACKET_RECEIVED,						// TsManagerPacketReceivedMessage_t
	TS_MANAGER_ACTION_PACKET_CONFIRMED,					// TsManagerActionPacketConfirmedMessage_t
	TS_MANAGER_ADDBA_REQUEST_CONFIRMED,					// TsManagerActionPacketConfirmedMessage_t
	TS_MANAGER_BAR_CONFIRMED,							// TsManagerBarConfirmedMessage_t
	TS_MANAGER_BAR_STATUS_RECEIVED,						// TsManagerBarStatusMessage_t
	TS_MANAGER_PACKET_DISCARDED,						// TsManagerDataPacketDiscardedMessage_t
	TS_MANAGER_PACKET_DISCARDED_BITMAP,					// TsManagerDataPacketDiscardedBitmapMessage_t
	TS_MANAGER_TIMER_EXPIRED,
	TS_MANAGER_PACKET_DESCRIPTOR_ALLOCATED,				// RmPdFreeDescResponse_t
	TS_MANAGER_ILLEGAL_PACKET,
	TS_MANAGER_CLOSE_TIDS,								// TsManagerCloseTidMessage_t
	TS_MANAGER_OPEN_TIDS,								// TsManagerOpenTidsMessage_t
	TS_MANAGER_QUEUE_IS_LOCKED,							// LockReqCb_t
	TS_MANAGER_ADD_VAP,									
	TS_MANAGER_REMOVE_VAP,								// UMI_REMOVE_VAP
	TS_MANAGER_CONFIGURE_VAP,							// UMI_TS_VAP_CONFIGURE
	TS_MANAGER_CONFIGURE_TXOP_MODE,						// TxopModeMsg_t
	TASK_TS_MANAGER_END,

	/*TX Manager*/
	TASK_TX_MANAGER_START,
	TX_MANAGER_DONE_LIST_NOT_EMPTY = TASK_TX_MANAGER_START,
#ifdef TX_DATA_THREAD_PATH
	TX_MANAGER_DATA_LIST_NOT_EMPTY,
	TX_MANAGER_STARVATION_TIMER,
#endif
	TX_MANAGER_DISABLE_LIST_NOT_EMPTY,
#ifndef ENET_INC_ARCH_WAVE600
	TX_MANAGER_VAP_GPHP_LOCK,							// LockReqCb_t
#endif	
    TX_MANAGER_STA_OPEN,								// BssManagerStaManagerReq_t
	TX_MANAGER_STA_STOP_TRAFFIC,						// BssManagerStaManagerReq_t
	TX_MANAGER_STA_POST_STOP_TRAFFIC,					// BssManagerStaManagerReq_t
	TX_MANAGER_STA_CLOSE,								// BssManagerStaManagerReq_t
	TX_MANAGER_STA_LOCK_EV,								// LockReqCb_t
	TX_MANAGER_POST_VAP_ADDITION,						
	TX_MANAGER_ENABLE_VAP,								
	TX_MANAGER_SET_WMM_PARAMETERS,						
	TX_MANAGER_DISABLE_VAP,								// UMI_STOP_VAP_TRAFFIC
	TX_MANAGER_VAP_QUEUE_DISABLED,						// LockReqCb_t
	TX_MANAGER_AGGREGATOR_ERROR_RECOVER,
	CSA_MANAGER_VAP_OPEN,								
	CSA_MANAGER_VAP_CLOSE,								// UMI_REMOVE_VAP 
	CSA_MANAGER_STA_OPEN,								// BssManagerStaManagerReq_t
	CSA_MANAGER_STA_CLOSE,								// BssManagerStaManagerReq_t
	CSA_MANAGER_START_TX,								// CsaManagerStartTxReqParams_t 
	CSA_MANAGER_STOP_TX,
	CSA_MANAGER_TX_CFM,									// CsaManagerPacketConfirmedMessage_t
	CSA_MANAGER_PD_ALLOC,								// RmPdFreeDescResponse_t
	CSA_MANAGER_VAP_GPHP_LOCK,							// LockReqCb_t
	CSA_MANAGER_STA_GPHP_LOCK,							// LockReqCb_t
#if defined CSA_REMOVE_RETRY	
	CSA_MANAGER_STA_MNG_LOCK,							// LockReqCb_t
#endif
	CSA_MANAGER_START_TX_UC_DEAUTH,						
	CSA_MANAGER_START_TX_MC_DEAUTH,
#ifdef ENET_INC_ARCH_WAVE600
	CSA_MANAGER_START_TX_UC_DEAUTH_B1,						
	CSA_MANAGER_START_TX_MC_DEAUTH_B1,
#endif

	CTS_MANAGER_VAP_OPEN,								// BSS_MANAGER_CONFIRM_EVENT 
	CTS_MANAGER_VAP_CLOSE,								// UMI_REMOVE_VAP 
	CTS_MANAGER_START_TX,								// CtsManagerTxReqMessage_t 
	CTS_MANAGER_STOP_TX,
#if defined (ENET_INC_ARCH_WAVE600)
	CTS_MANAGER_STOP_TX_B1,
#endif	
	CTS_MANAGER_TX_CFM,									// CtsManagerPacketConfirmedMessage_t 
	CTS_MANAGER_PD_ALLOC,								// RmPdFreeDescResponse_t
	CTS_MANAGER_GPHP_LOCK,
	TX_MANAGER_ADD_VAP,									
	MULTICAST_HANDLER_GROUP_ACTION,						// UMI_MULTICAST_ACTION
	MULTICAST_HANDLER_STA_STOP_TRAFFIC,					// BssManagerStaManagerReq_t
	SMPS_ADD_VAP,										// BSS_MANAGER_CONFIRM_EVENT
	SMPS_REMOVE_VAP,									// BSS_MANAGER_CONFIRM_EVENT
	SMPS_ADD_STA,										// BssManagerStaManagerReq_t
	SMPS_REMOVE_STA,									// BssManagerStaManagerReq_t
	SMPS_TX_CFM,										// SmpsManagerPacketConfirmedMessage_t
	SMPS_PD_ALLOC_CFM,									// RmPdFreeDescResponse_t
	SMPS_LOCK_CFM,										// LockReqCb_t
	SMPS_TX_START_REQ,									// SmpsManagerStartTxReqParams_t
	SMPS_CHANNEL_WIDTH, 								// cocChannelWidth_t

	DUT_TRANSMIT_PACKET_REQ,
	DUT_ACTION_PACKET_CB_HNDLR_CFM,


	TASK_TX_MANAGER_END,
	
	/*CSM*/
	TASK_CHANNEL_SWITCH_MANAGER_START,
	CHANNEL_SWITCH_MANAGER_SET_CHANNEL_REQ = TASK_CHANNEL_SWITCH_MANAGER_START,		// UM_SET_CHAN_PARAMS 
	CHANNEL_SWITCH_MANAGER_TX_PAUSE_CFM,
	CHANNEL_SWITCH_MANAGER_TX_PAUSE_SPECIFIC_VAP_CFM,
	CHANNEL_SWITCH_MANAGER_RX_PAUSE_CFM,
	CHANNEL_SWITCH_MANAGER_PROCESS_START_CFM,			// ProcessManagerReturnParams_t
	CHANNEL_SWITCH_MANAGER_PROCESS_FINISH_CFM,
	CHANNEL_SWITCH_MANAGER_TX_QUEUE_LOCK_CFM,
	CHANNEL_SWITCH_MANAGER_BEACON_START_CSA_BEACON_CFM,	// BeaconCsaStartMsg_t 
	CHANNEL_SWITCH_MANAGER_CSA_BEACON_DONE_IND,			// ChannelSwitchManager_BeaconLockNotification_t
	CHANNEL_SWITCH_MANAGER_STOP_CSA_BEACONS_CFM,
	CHANNEL_SWITCH_MANAGER_TIMER_EXPIRED,
	CHANNEL_SWITCH_MANAGER_TX_RESUME_CFM,
	CHANNEL_SWITCH_MANAGER_RX_RESUME_CFM,
	CHANNEL_SWITCH_MANAGER_SET_CHANNEL_CFM,				// HdkSetChannelCfmParams_t
	CHANNEL_SWITCH_MANAGER_SET_NOTIFY_CFM,
	CHANNEL_SWITCH_MANAGER_VAP_MANAGER_REGISTRATION_EVENT_ADD_VAP,					
	CHANNEL_SWITCH_MANAGER_VAP_MANAGER_REGISTRATION_EVENT_POST_REMOVE_VAP,			// UMI_REMOVE_VAP
	CHANNEL_SWITCH_MANAGER_CSA_MANAGER_START_TX_CFM,
	CHANNEL_SWITCH_MANAGER_CSA_MANAGER_STOP_TX_CFM,
	CHANNEL_SWITCH_MANAGER_PROCESS_INTERRUPTED_IND,
	CHANNEL_SWITCH_MANAGER_SET_RSSI_CFM,
	CHANNEL_SWITCH_MANAGER_SET_RSSI_RX_RESUME_CFM,
	CHANNEL_SWITCH_MANAGER_CHANNEL_LOAD_TIMER_EXPIRED,
	CHANNEL_SWITCH_MANAGER_GET_CHANNEL_LOAD,
#ifdef ENET_INC_ARCH_WAVE600	
	CHANNEL_SWITCH_MANAGER_CALCULATE_CHANNEL_LOAD,
#endif	
	TASK_CHANNEL_SWITCH_MANAGER_END,

	/*QOS*/
	TASK_QOS_START,
	QOS_AGER_LIST_NOT_EMPTY = TASK_QOS_START,
	QOS_NUMBER_OF_FREE_PDS_REACHED_THRESHOLD,
	QOS_ADD_STATION,									// BssManagerStaManagerReq_t
	QOS_REMOVE_STATION,									// BssManagerStaManagerReq_t
	QOS_ADD_VAP,										
	QOS_REMOVE_VAP,										// UMI_REMOVE_VAP 
	QOS_SINGLE_CHECK_DONE,
	QOS_PD_THRESOLD_TIMER,
	QOS_PD_THRESHOLD_CONFIG,							// QoSPdThresholdConfig_t
	QOS_SET_BEACON_INTERVAL,							// UMI_BEACON_INTERVAL_t
	QOS_SET_IS_ATF_STATIC,								// uint8 
	QOS_AGER_SET_RESTRICTED_PARAMS,						// UMI_SET_RESTRICTED_AC
	TASK_QOS_END,
	
	/* STATISTICS MANAGER */
	TASK_STATISTICS_MANAGER_START,
	STATISTICS_MANAGER_ADD_VAP = TASK_STATISTICS_MANAGER_START,						
	STATISTICS_MANAGER_REMOVE_VAP,
	STATISTICS_MANAGER_ADD_STA,							// BssManagerStaManagerReq_t 
	STATISTICS_MANAGER_REMOVE_STA,						// BssManagerStaManagerReq_t 
	STATISTICS_MANAGER_PHY_STAT_METRICS_FIFO_NOT_EMPTY,
	STATISTICS_MANAGER_FW_STAT_DMA_DONE,
	STATISTICS_MANAGER_GET_STATISTICS_REQ,				// UMI_GET_STATISTICS_DATA
	STATISTICS_MANAGER_SET_ANTENNAS_BITMAP,
	STATISTICS_MANAGER_CPU_LOAD_REQ,					// 
	STATISTICS_MANAGER_HDK_STATISTICS_CFM,				//
#ifndef ENET_INC_ARCH_WAVE600
	STATISTICS_MANAGER_SET_RX_TH_REQ,					// UMI_RX_TH
	STATISTICS_MANAGER_UPDATE_ADMISSION_CAPACITY,		// UMI_UPDATE_ADMISSION_CAPACITY
	STATISTICS_MANAGER_CPU_LOAD_TIMER_EXPIRY,			// 
	STATISTICS_MANAGER_CPU_LOAD_CNF,					// StatisticsCpuLoadCnf_t: Handle the confirmation sent from the LOWER MAC
#endif
#ifdef ENET_INC_ARCH_WAVE600
	STATISTICS_MANAGER_CHANNEL_LOAD_CALCULATED,
	STATISTICS_MANAGER_CHANNEL_SWITCH_NOTIFY,
	STATISTICS_MANAGER_ADD_NEW_SID,
	STATISTICS_MANAGER_REMOVE_SID,
#endif
	TASK_STATISTICS_MANAGER_END,

	/*Process Manager*/
	TASK_PROCESS_MANAGER_START,
	PROCESS_MANAGER_SCHEDULE_PROCESS_REQUEST = TASK_PROCESS_MANAGER_START,			// ProcessRequestParams_t
	PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED,			// ProcessRequestParams_t
	PROCESS_MANAGER_SERVICE_CB,							// ServiceReturnParams_t
	PROCESS_MANAGER_CTS_TX_CFM,							// CtsManagerTxCfmMessage_t
	PROCESS_MANAGER_CDB_SYNC_SERVICE_PROCESS_SCHEDULED_RES,
	PROCESS_MANAGER_CDB_SYNC_SERVICE_CTS2SELF_SENT_RES,
	TASK_PROCESS_MANAGER_END,
	/*Process Manager CDB*/
	TASK_PROCESS_MANAGER_CDB_START,
	PROCESS_MANAGER_CDB_PROCESS_REQUEST = TASK_PROCESS_MANAGER_CDB_START,
	PROCESS_MANAGER_CDB_PROCESS_ENDED,
	TASK_PROCESS_MANAGER_CDB_END,

	/*Ager Emulator*/
#ifdef USE_AGER_EMULATOR
	TASK_AGER_EMULATOR_START,
	AGER_EMULATOR_CONFIGURE_ALL_AND_ACTIVATE_PERIODIC_CHECK  = TASK_AGER_EMULATOR_START, // AgerEmulatorPeriodicCheckMessageParameters_t
	AGER_EMULATOR_CONFIGURE_PARTIALLY_AND_ACTIVATE_PERIODIC_CHECK,					// AgerEmulatorPeriodicCheckMessageParameters_t
	AGER_EMULATOR_STOP_PERIODIC_CHECK,
	AGER_EMULATOR_START_SINGLE_CHECK,					// AgerEmulatorSingleCheckMessageParameters_t
	AGER_EMULATOR_ADD_STATION,							// BssManagerStaManagerReq_t
	AGER_EMULATOR_REMOVE_STATION,						// BssManagerStaManagerReq_t
	AGER_EMULATOR_ADD_VAP,								// UMI_SET_WMM_PARAMETERS 
	AGER_EMULATOR_REMOVE_VAP,							// UMI_STOP_VAP_TRAFFIC 
	AGER_EMULATOR_PERIODIC_CHECK_TIMER,
	AGER_EMULATOR_LOCK_CONFIRMATION,					// LockReqCb_t
#if defined (SENDER_LOCK_DATA_TID_ON_ADDBA_REQ)	
	AGER_EMULATOR_TID7_LOCK_CONFIRMATION,				// LockReqCb_t
#endif
	TASK_AGER_EMULATOR_END,
#endif //USE_AGER_EMULATOR

	TASK_GROUP_MANAGER_START,
	GROUP_MANAGER_ADD_STATION = TASK_GROUP_MANAGER_START,							// BssManagerStaManagerReq_t
	GROUP_MANAGER_REMOVE_STATION,						// BssManagerStaManagerReq_t
	GROUP_MANAGER_TRAINING_TIMER_EXPIRED,
	GROUP_MANAGER_SINGLE_USER_VALIDATION_START_CONFIRMATION,						// GroupManagerSingleUserValidationStartConfirmationMessage_t
	GROUP_MANAGER_SINGLE_USER_VALIDATION_RESULTS,		// GroupManagerSingleUserResultsMessage_t
	GROUP_MANAGER_SINGLE_USER_VALIDATION_END_CONFIRMATION,							// GroupManagerSingleUserValidationEndConfirmationMessage_t
	GROUP_MANAGER_STATION_NSS_HAS_CHANGED,				// GroupManagerStationNssHasChangedMessage_t
	GROUP_MANAGER_ADD_GROUP_CONFIRMATION,				// GroupManagerAddGroupConfirmationMessage_t
	GROUP_MANAGER_PROBING_RESULTS,						// GroupManagerProbingResultsMessage_t
	GROUP_MANAGER_REMOVE_GROUP_CONFIRMATION,			// GroupManagerRemoveGroupConfirmationMessage_t
	GROUP_MANAGER_GROUPS_MARKS,							// GroupManagerGroupsMarksMessage_t
	GROUP_MANAGER_GROUP_FAILED,							// GroupManagerGroupHasFailedMessage_t
	GROUP_MANAGER_GROUP_LOCK_CONFIRM,					// LockGroupReqCb_t
	GROUP_MANAGER_SET_MULTI_USER_OPERATION,				// GroupManagerSetMultiUserOperationParameters_t
	GROUP_MANAGER_RESET_MULTI_USER_OPERATION,
	GROUP_MANAGER_SET_MULTI_USER_OPERATION_REQ,			// UMI_MU_OPERATION_CONFIG
	GROUP_MANAGER_SET_MU_GROUP_FIXED_RATE,				// GroupManagerFixedRateParams_t
#if defined (MU_MIMO_STATIC_GROUP_ENABLED)
	GROUP_MANAGER_CREATE_MU_STATIC_GROUP,				// GroupManager_CreateStaticGroup_t
	GROUP_MANAGER_DELETE_MU_STATIC_GROUP,
#endif //MU_MIMO_STATIC_GROUP_ENABLED
	GIDM_MANAGER_TX_CFM,								// GidmManagerPacketConfirmed_t
	GIDM_MANAGER_PD_ALLOCATED,							// GidmManagerPacketConfirmed_t
	GIDM_MANAGER_LOCK_CONFIRMED,						// LockReqCb_t
	/*NDPA Manager*/
	NDPA_MANAGER_TX_CFM,								// NdpaManagerPacketConfirmed_t
	NDPA_MANAGER_LOCK_CONFIRMED,						// LockReqCb_t
	NDPA_MANAGER_PD_ALLOCATED,							// RmPdFreeDescResponse_t
	NDPA_MANAGER_LA_BF_REPORT_IND,						// LaBfReportInd_t
	/*Training Manager*/	
	TRAINING_MANAGER_SET_BSS,   
	TRAINING_MANAGER_STOP_TRAFFIC,
	TRAINING_MANAGER_LA_INFO_CFM,						// TrainingManagerLinkAdaptiveInfoCfm_t
	GROUP_MANAGER_UPDATE_COC_INFO,
	TASK_GROUP_MANAGER_END,

#ifdef PTA_BUILD_IN_PLAT
	TASK_PTA_START,
	PTA_SET_2_4_G_COEX = TASK_PTA_START,				// UMI_SET_2_4_G_COEX
	PTA_STARVATION_TIMER,
	PTA_REP_CONFIG,										// PtaRepConfig_t
	PTA_REP_TIMER_EXPIRED,
	PTA_REP_PROCESS_START,
	PTA_REP_PROCESS_END,
#ifdef PTA_TEST
	PTA_TEST_GPIO_VALUE_IS_WRONG,						// PtaGpioErrorParams_t
	PTA_TEST_HW_TIMER_IS_OK,
#endif	
	TASK_PTA_END,
#endif	

	TASK_ATF_START ,
	ATF_MANAGER_START_REQ = TASK_ATF_START,				// UMI_ATF_QUOTAS
    ATF_BUFFERING_LOCK_CFM,								// LockReqCb_t
    ATF_BUFFERING_HIM_BUFFER_CFM,						// AtfMsg_t
    ATF_BUFFERING_DROP_ALL_BUFFERED,
    ATF_BUFFERING_QOS_TTL_CRITERIA,
    ATF_BUFFERING_TIMER_EXPIRED,
#ifdef ENET_INC_ARCH_WAVE600
	ATF_BUFFERING_TIMER_EXPIRED_B1,
#endif
    ATF_BUFFERING_SENDER_INDICATION_STOPTX,				// FwTxSenderMailbox0FifoOutMessage_t
    ATF_MANAGER_BSS_STOP_TRAFFIC,						// BssManagerStaManagerReq_t
    ATF_MANAGER_BSS_ADD_STA,    						// BssManagerStaManagerReq_t
    TASK_ATF_END,

	/*Link Adaptation*/
	TASK_LINK_ADAPTATION_START ,
	LINK_ADAPTATION_SEQ_FIFO_NOT_EMPTY = TASK_LINK_ADAPTATION_START,
	LINK_ADAPTATION_ADD_STATION_REQ,					// BssManagerStaManagerReq_t
	LINK_ADAPTATION_REMOVE_STATION_REQ,					// BssManagerStaManagerReq_t
	LINK_ADAPTATION_PROBING_TIMER_EVENT,				// LaTimerEventsTimerEvent_t
	LINK_ADAPTATION_AGING_TIMER_EVENT,					// LaTimerEventsTimerEvent_t
	LINK_ADAPTATION_WLAN_PROTECTION_TIMER_EVENT,		// LaTimerEventsTimerEvent_t
	LINK_ADAPTATION_SET_FIXED_RATE,						// LaFixedRateParams_t
	LINK_ADAPTATION_SET_MU_GROUP_FIXED_RATE,			// LaGroupFixedRateParams_t
	LINK_ADAPTATION_SET_FIXED_POWER,					// LaFixedPowerParams_t
#ifndef ENET_INC_ARCH_WAVE600
	LINK_ADAPTATION_SET_FIXED_CDD_REQ,					// LaFixedCddParams_t
#endif
	LINK_ADAPTATION_ADD_VAP,							
	LINK_ADAPTATION_REMOVE_VAP,							// UMI_REMOVE_VAP 
	LINK_ADAPTATION_SET_CHANNEL_DATA_REQ,				// LA_SET_CHANNEL_DATA_t
#ifndef ENET_INC_ARCH_WAVE600
	LINK_ADAPTATION_CDD_SET_PSD_DATA_REQ,				// CddPermutationsDb_t
#endif
	LINK_ADAPTATION_SET_PROTECTION_THRESH_REQ,
	LINK_ADAPTATION_SET_ANTENNA_SELECTION_REQ,			// LinkAdaptationFixedAntennaSelection_t
	LINK_ADAPTATION_BAA_FIFO_NOT_EMPTY,
	LINK_ADAPTATION_SET_BF_MODE_REQ,					// LaFixedBeamformingParams_t
	LINK_ADAPTATION_SET_AGG_RATE_LIMIT_REQ,				// UMI_AGG_RATE_LIMIT
	LINK_ADAPTATION_SET_POWER_LIMIT_REQ,				// UMI_TX_POWER_LIMIT 
	LINK_ADAPTATION_REMOVE_SID_REQ,						// LaRemoveSid_t
	LINK_ADAPTATION_SET_OPERATING_MODE_NOTIFICATION_REQ,	// LaOperatingModeNotificationMsg_t
	LINK_ADAPTATION_BF_TIMER_EVENT,						// LaTimerEventsTimerEvent_t
	LINK_ADAPTATION_UPDATE_BF_CAL_STATUS_REQ,			// LaBfCalStatusChanged_t
	LINK_ADAPTATION_SET_ACT_BITMAP_PSD_REQ,				// laBfPsdActBitmapMsgParams_t
	LINK_ADAPTATION_SET_POWER_ADAPTATION_PSD_REQ,		// laSetPowerAdaptationPsdTablesMsg_t
	LINK_ADAPTATION_QAMPLUS_ACTIVATE_REQ,				// UMI_QAMPLUS_ACTIVATE
#if !defined (ENET_INC_ARCH_WAVE600)
	LINK_ADAPTATION_SET_RECOVERY_TIME_LIMIT,
#endif
	LINK_ADAPTATION_GET_TRAINIG_INFO,
	LINK_ADAPTATION_START_SINGLE_USER_VALIDATION,		// LaStartSingleUserValidationParams_t
	LINK_ADAPTATION_STOP_SINGLE_USER_VALIDATION,		// LaEndSingleUserValidationParams_t
	LINK_ADAPTATION_GET_GROUPS_MARKS,					// GroupManagerGroupsMarksMessage_t
	LINK_ADAPTATION_ADD_GROUP,							// LaAddGroupParams_t
	LINK_ADAPTATION_REMOVE_GROUP,						// LaRemoveGroupParams_t
	LINK_ADAPTATION_TXOP_TIME_LIMIT_CONFIG_REQ,			// LaTxopDurationParams_t
#ifdef LINK_ADAPTATION_TEST_ENV
	LINK_ADAPTATION_RUN_TEST_REQ,						// LaTestEnvMsgParams_t
#endif
	LINK_ADAPTATION_GENERIC_REQ,						// lmGenericMsgType_t
	LINK_ADAPTATION_GET_BCL_REQ,						// UMI_BCL_REQUEST
	LINK_ADAPTATION_SET_BCL_REQ,						// UMI_BCL_REQUEST
#ifndef ENET_INC_ARCH_WAVE600
	LINK_ADAPTATION_LOG_FILL_HDR_TEMPLATE,				// UMI_ADD_STREAM_REQ_t
#endif
	LINK_ADAPTATION_MSDU_IN_AMSDU_CONFIG_REQ,			// UMI_MSDU_IN_AMSDU_CONFIG
	LINK_ADAPTATION_SET_MPDU_IN_AMPDU_LIMIT_CONFIG_REQ,			// uint8 
	LINK_ADAPTATION_RTS_MODE_CONFIG_REQ,				// UMI_RTS_MODE_CONFIG
	LINK_ADAPTATION_MAX_MPDU_LEN_REQ,					// UMI_MAX_MPDU
	LINK_ADAPTATION_SET_FREQ_JUMP_MODE_REQ,				// LmFreqJumpMode_t
	LINK_ADAPTATION_FIXED_PROTECTION_REQ,				// ProtectionFixed_t
	LINK_ADAPTATION_SET_TXOP_CONFIG_REQ,				// UMI_SET_TXOP_CONFIG_t
	LINK_ADAPTATION_SET_TXOP_FOR_MU_MEMBER,				// LaSetTxopForMuMember_t
#ifdef ENET_INC_ARCH_WAVE600
	LINK_ADAPTATION_ADD_HE_GROUP,						// LaAddHeGroupParams_t
	LINK_ADAPTATION_REMOVE_HE_GROUP,					// LaRemoveHeGroupParams_t
	LINK_ADAPTATION_GET_PHY_RATE,						// LaGetPhyRateParams_t
#endif
	LINK_ADAPTATION_FAST_DROP_CONFIG_REQ,				// UMI_FAST_DROP_CONFIG_REQ_t
	LINK_ADAPTATION_DMR_CONFIG_REQ,						// UmiDmrConfig_t
	LINK_ADAPTATION_SET_PPDU_TX_MODE_REQ,				// UMI_TS_VAP_CONFIGURE
	LINK_ADAPTATION_SET_CALIBRATION_STATISTICS,			// LinkAdaptationCalibrationStatus_t
	LINK_ADAPTATION_SET_COLLISION_DETECTION_TH,			// LaFixedCollisionDetectionParams_t
#ifdef ENET_INC_ARCH_WAVE600
	LINK_ADAPTATION_SET_REG_DOMAIN_CONFIG_REQ,			// UMI_REG_DOMAIN_CONFIG
#endif //ENET_INC_ARCH_WAVE600
	LINK_ADAPTATION_SET_FILTER,							// BssManagerStaManagerReq_t
#if defined(BSRC_ARTIFICIAL_UPDATE_FOR_UL)
	LINK_ADAPTATION_SET_BSRC_COUNTERS_FOR_STATIC_PLAN,
#endif
#ifdef ENET_INC_ARCH_WAVE600
	LINK_ADAPTATION_RTS_RATE_CONFIG,
	LINK_ADAPTATION_UPDATE_GROUPS_METRICS_REQ,
	LINK_ADAPTATION_GET_ASSOC_PARAMS_FROM_LA,
#endif	
#ifdef DEBUG_UM_INTERFACE
	LINK_ADAPTATION_EN_DIS_SLOW_PROBING_REQ,			// LinkAdaptationEnDisSlowProbingLoops_t
#endif
	LINK_ADAPTATION_SET_SCP_SHORT_PREAMBLE_REQ, 		// LaFixedScpParams_t
	LINK_ADAPTATION_SET_RTS_THRESHOLD_REQ,				// UMI_SET_RTS_THRESHOLD_t
	TASK_LINK_ADAPTATION_END,
	
	TASK_PAC_MANAGER_START ,
	PAC_MANAGER_START_REQ = TASK_PAC_MANAGER_START,		// PacManagerStart_t 
	PAC_MANAGER_ADD_VAP_REQ,	
	PAC_MANAGER_POST_ADD_VAP_REQ,						
	PAC_MANAGER_ACTIVATE_RSSI_REQ,						// RssiParams_t
	PAC_MANAGER_ACTIVATE_NORMAL_REQ,					// RssiParams_t
	PAC_MANAGER_SET_BSS_REQ,							
	PAC_MANAGER_POST_VAP_ACTIVATION, 					
	PAC_MANAGER_REMOVE_VAP_REQ,							// UMI_REMOVE_VAP
	PAC_MANAGER_SET_BEACON_TEMPLATE_REQ,				// BssManagerSetTemplateReq_t 
	PAC_MANAGER_BEACON_CSA_START,						// BeaconCsaStartMsg_t 
	PAC_MANAGER_BEACON_CSA_STOP,
	PAC_MANAGER_BEACON_CSA_LOCK,
	PAC_MANAGER_BEACON_CSA_PD,
	PAC_MANAGER_BEACON_QUEUE_IS_LOCKED,					// LockReqCb_t
	PAC_MANAGER_BEACON_QUEUE_IS_DISABLED,				// LockReqCb_t
	PAC_MANAGER_PS_SETTINGS_FIFO_NOT_EMPTY,
	PAC_MANAGER_REQUEST_SID_REQ,
	PAC_MANAGER_REMOVE_SID_REQ,
	PAC_MANAGER_UPDATE_VAP_TIMING_PARAMETERS,
	PAC_MANAGER_GET_AGG_WITH_NO_BA_FIFO,
	PAC_MANAGER_SET_AGG_WITH_NO_BA_FIFO,
	PAC_MANAGER_SET_MIN_RSSI_THRESHOLD,	
	PAC_MANAGER_BEACON_BLOCKING_SET,					// UMI_BeaconBlockTimerInterval_t 
	PAC_MANAGER_BEACON_BLOCKING_START,
	PAC_MANAGER_BEACON_BLOCKING_STOP,
	PAC_MANAGER_BEACON_BLOCKING_RESTART,
	PAC_MANAGER_BEACON_BLOCKING_TIMER,
	PAC_MANAGER_STATISTICS_CPU_LOAD_REQ,
#if defined (ENET_INC_ARCH_WAVE600)	
	PAC_MANAGER_ADD_STATION_REQ,
	PAC_MANAGER_REMOVE_STATION_REQ,
	PAC_MANAGER_SET_SNIFFER_UDP_HDR_REQ,
	PAC_MANAGER_LOGGER_FILL_MSG_HEADER_TEMPLATE_REQ,
	PAC_MANAGER_SET_BAND_REQ,
	PAC_MANAGER_AUTO_RESPONSE_ERROR_FIFO_NOT_EMPTY,	
	PAC_MANAGER_SET_FORCE_PROTECTION,
	PAC_MANAGER_SET_MU_TRAINING_BW_LIMIT,
	PAC_MANAGER_STATUS_FIFO_NOT_EMPTY,
	PAC_MANAGER_OTF_AGGR_FIFO_NOT_EMPTY,
	PAC_MANAGER_SET_CHANNEL_IND,
	PAC_MANAGER_ULPR_FIFO_NOT_EMPTY,
	PAC_MANAGER_PRE_AGG_FIFO_NOT_EMPTY,
#endif 	//defined (ENET_INC_ARCH_WAVE600)	
#ifdef RXH_MAILBOX_TEST
	PAC_MANAGER_RXH_MAILBOX_TEST,
#endif //RXH_MAILBOX_TEST
#if defined (ENET_INC_ARCH_WAVE600)	
	PAC_MANAGER_UPDATE_ADMISSION_CAPACITY,
#endif
#if defined (ENET_INC_ARCH_WAVE600D2) 
	PAC_MANAGER_BSRC_NDP_FEEDBACK_REPORT_FIFO_NOT_EMPTY,
#endif
	PAC_MANAGER_PRE_AGG_ETSI_PPDU_DURATION_LIMIT_REQ,
	PAC_MANAGER_TX_PD_ACC_SET_RETRY_LIMIT_REQ,			//UMI_SET_RETRY_LIMIT
	PAC_MANAGER_SET_AP_BEACON_INFO_REQ,
	TASK_PAC_MANAGER_END,
	
#if defined (ENET_INC_ARCH_WAVE600) 
	TASK_HE_GROUP_MANAGER_START,
	HE_GROUP_MANAGER_ADD_STATION = TASK_HE_GROUP_MANAGER_START,
	HE_GROUP_MANAGER_REMOVE_STATION,
	HE_GROUP_MANAGER_SET_STATIC_PLAN_REQ,
	HE_GROUP_MANAGER_REMOVE_STATIC_PLAN_REQ,
	HE_GROUP_MANAGER_CREATE_PLAN_CFM,
	HE_GROUP_MANAGER_REMOVE_PLAN_CFM,       // RemovePlanMsg_t
	HE_GROUP_MANAGER_LOCK_PLAN_CFM,         // LockPlanReqCb_t
	HE_GROUP_MANAGER_TIMER_EXPIRED,
	HE_GROUP_MANAGER_LNA_TYPE_HAS_CHANGED_IND,
	HE_GROUP_MANAGER_RECOVER_FROM_PD_TYPE_NOT_ALLOWED_REQ,
	HE_GROUP_MANAGER_UPDATE_COC_INFO,		// cocUpdateAntMaskMsg_t
	HE_GROUP_MANAGER_METERICS_CFM,
	HE_GROUP_MANAGER_SET_CHANNEL,
	HE_GROUP_MANAGER_SET_ANTENNAS,
	HE_GROUP_MANAGER_SET_STA_ASSOC_BW_AND_ANTS_FROM_LA,
	HE_GROUP_MANAGER_SET_MAX_MIN_NUM_OF_STA_IN_GROUP,
	HE_GROUP_MANAGER_ENABLE_DYNAMIC_MU,
	TASK_HE_GROUP_MANAGER_END,
	
	TASK_PLAN_MANAGER_START,
	PLAN_MANAGER_CREATE_STATIC_PLAN = TASK_PLAN_MANAGER_START,
	PLAN_MANAGER_REMOVE_STATIC_PLAN,
#ifdef OFDMA_DYNAMIC_PLAN_ON		
	PLAN_MANAGER_CREATE_PLAN,               // CreatePlanMsg_t
#endif	
	PLAN_MANAGER_REMOVE_PLAN,               // RemovePlanMsg_t
	PLAN_MANAGER_CREATE_PLAN_LA_CFM,        // LaAddHeGroupCfm_t
	PLAN_MANAGER_REMOVE_PLAN_LA_CFM,        // LaRemoveHeGroupParams_t
#ifdef ENET_INC_ARCH_WAVE600B
	PLAN_MANAGER_ADD_PHASE_TO_STATIC_PLAN,
#endif 
	TASK_PLAN_MANAGER_END,

    TASK_TWT_MANAGER_START,
	TWT_MANAGER_ADD_VAP = TASK_TWT_MANAGER_START,
	TWT_MANAGER_ADD_STA, 
	TWT_MANAGER_TWT_FRAME_RECIEVED,
	TWT_MANAGER_PD_ALLOC_CFM,
	TWT_MANAGER_TX_CFM,
	TWT_MANAGER_REMOVE_STA,
	TWT_MANAGER_SET_FILTER,
	
	TASK_TWT_MANAGER_END,
#endif 

	OSAL_TASK_LAST_MSG,	
	OSAL_TASK_MAX_MESSAGES = MAX_UINT16	
} UpperMacMessages_e;

#endif /* UM_MSGS_INCLUDED */




