/************************************************************************************
*    
*    File:		  OSAL_Tasks.c
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/


#include "OSAL_Api.h"
#include "OSAL_Tasks.h"
#include "loggerAPI.h"

#if defined (ENET_INC_LMAC)
#include "linkAdaptation_api.h"
#endif

#if defined (ENET_INC_UMAC) || defined (ENET_INC_LMAC)
#include "ipc_api.h"
#endif

/*************************************************************************/
/***                        Macros                                     ***/
/*************************************************************************/

#define DUMMY_TASK(T) 	void 	T(K_MSG *psMSG) {UNUSED_PARAM(psMSG);}
	
/*************************************************************************/
/***                        Kernel Tasks                               ***/
/*************************************************************************/

/* Kernel and environment */
TASK (vKNLtimerTick);
TASK (vHIM_Task);
TASK (vUM_IF_Task);
TASK (vBSS_Task);
TASK (TsManager_TaskEntry);
TASK (Qos_TaskEntry);
TASK (LOGGER_Task);
TASK (vENC_Task);
TASK (InterfererDetection_TaskEntry);
#ifdef USE_AGER_EMULATOR
TASK(AgerEmulator_TaskEntry);
#endif //USE_AGER_EMULATOR
TASK(BssManager_Task);
TASK(Dut_Task);
TASK(RxManager_TaskEntry);
TASK(TxManager_TaskEntry);
TASK(ChannelSwitchManager_TaskEntry);
TASK(CoC_task);
TASK(HDK_Task);
TASK(statisticsManagerTaskEntry);
TASK(ProcessManager_TaskEntry);
TASK(LinkAdaptation_Task);
TASK(PacManager_Task);
TASK(GroupManager_TaskEntry);
TASK(Atf_TaskEntry);
#ifdef PTA_BUILD_IN_PLAT
TASK(PTA_Task);
#endif
TASK(HdkCdbManager_TaskEntry);
TASK(ProcessManagerCdb_TaskEntry);
#if defined (ENET_INC_LMAC)
DUMMY_TASK (vKNLtimerTick)
DUMMY_TASK (vHIM_Task)
DUMMY_TASK (vUM_IF_Task)
DUMMY_TASK (vBSS_Task)
DUMMY_TASK (TsManager_TaskEntry)
DUMMY_TASK (Qos_TaskEntry)
DUMMY_TASK (LOGGER_Task)
#if defined (ENET_INC_UMAC)
DUMMY_TASK (vIPC_TaskEntry)
#endif
DUMMY_TASK (vENC_Task)

#ifndef ENET_INC_ARCH_WAVE600
DUMMY_TASK (InterfererDetection_TaskEntry)
DUMMY_TASK(CoC_task)
DUMMY_TASK(ProcessManager_TaskEntry)
DUMMY_TASK(ChannelSwitchManager_TaskEntry)
DUMMY_TASK(HDK_Task)
DUMMY_TASK(Dut_Task)
#endif

#ifdef USE_AGER_EMULATOR
DUMMY_TASK(AgerEmulator_TaskEntry)
#endif //USE_AGER_EMULATOR
DUMMY_TASK(BssManager_Task)
DUMMY_TASK(RxManager_TaskEntry)
DUMMY_TASK(TxManager_TaskEntry)
DUMMY_TASK(statisticsManagerTaskEntry)
DUMMY_TASK(GroupManager_TaskEntry)
DUMMY_TASK(Atf_TaskEntry)
#ifdef PTA_BUILD_IN_PLAT
DUMMY_TASK(PTA_Task)
#endif
#if defined ENET_INC_ARCH_WAVE600	
DUMMY_TASK(HdkCdbManager_TaskEntry)
#endif
#if defined(HDK_CDB_SUPPORT)
DUMMY_TASK(ProcessManagerCdb_TaskEntry)
#endif

#endif

#if defined (ENET_INC_UMAC)
DUMMY_TASK(LinkAdaptation_Task)
DUMMY_TASK(PacManager_Task)
#if !defined ENET_INC_ARCH_WAVE600	
DUMMY_TASK(HdkCdbManager_TaskEntry)
#endif
#if defined(ENET_INC_ARCH_WAVE600)
DUMMY_TASK (InterfererDetection_TaskEntry)
DUMMY_TASK(CoC_task)
DUMMY_TASK(ProcessManager_TaskEntry)
DUMMY_TASK(ChannelSwitchManager_TaskEntry)
DUMMY_TASK(HDK_Task)
DUMMY_TASK(Dut_Task)

#endif
#endif


/*************************************************************************/
/***                        Task Descriptor Table                      ***/
/*************************************************************************/
const KNL_TD asAPP_TaskTable[NUM_OF_TASKS_IN_SYSTEM] =
{
	/* High Priority Tasks   */
	{NULL},				               	/* TASK_KNL_TIMER_TICK          */
	{NULL},				               	/* TASK_KNL_TIMER_HIGH          */
#if defined (ENET_INC_UMAC)
	{vIPC_TaskEntry},				   /* TASK_IPC                   */
#else
	{vIPC_2_TaskEntry},				   	/* TASK_IPC_2                   */
#endif
	{LinkAdaptation_Task},	           	/* TASK_LINK_ADAPTATION         */
	{PacManager_Task},                 	/* PAC_MANAGER                  */
	{NULL},				               	/* TASK_KNL_TIMER_MID           */
	{NULL},				               	/* TASK_KNL_TIMER_LOW           */
	{vUM_IF_Task},					   	/* TASK_UM_IF_TASK              */
	{vBSS_Task},					   	/* TASK_BSS_MANAGE              */
	{TsManager_TaskEntry},			   	/* TASK_TS_MANAGER              */
	{Qos_TaskEntry},			       	/* TASK_QOS                     */
	{vENC_Task}, 					   	/* TASK_ENCRYPTION              */
	{LOGGER_Task},					   	/* TASK_LOGGER,                 */
#if defined (ENET_INC_UMAC)	
	{vIPC_TaskEntry},				   	/* TASK_IPC                     */
#endif	
#ifdef PTA_BUILD_IN_PLAT		
	{PTA_Task}, 					   	/* TASK_PTA						*/		
#endif	
	{Dut_Task},						   	/* TASK_DUT                     */
	{InterfererDetection_TaskEntry},   	/* TASK_INTERFERER_DETECTION    */			
	{CoC_task},						   	/* TASK_COC                     */
	{HDK_Task},						   	/* TASK_HDK                     */
	{vHIM_Task},					   	/* TASK_HIM                     */
	{RxManager_TaskEntry},			   	/* TASK_RX_MANAGER              */
	{TxManager_TaskEntry},			   	/* TASK_TX_MANAGER              */																							
	{BssManager_Task},				   	/* TASK_BSS_MANAGER             */
	{ChannelSwitchManager_TaskEntry},  	/* TASK_CHANNEL_SWITCH_MANAGER  */
#ifdef USE_AGER_EMULATOR
	{AgerEmulator_TaskEntry},		   	/* TASK_AGER_EMULATOR           */
#endif //USE_AGER_EMULATOR
	{statisticsManagerTaskEntry},	   	/* TASK_STATISTICS_MANAGER      */
	{ProcessManager_TaskEntry},		   	/* TASK_PROCESS_MANAGER		   	*/
	{GroupManager_TaskEntry},		   	/* TASK_GROUP_MANAGER		   	*/
    {Atf_TaskEntry},		           	/* TASK_ATF		               	*/
	{HdkCdbManager_TaskEntry},		   	/* TASK_HDK_CDB_MANAGER		   	*/
#if defined(HDK_CDB_SUPPORT)
	{ProcessManagerCdb_TaskEntry},		/* TASK_PROCESS_MANAGER_CDB		*/
#endif
};



