/***************************************************************
 File:		OtfAggregator_Api.h
 Module:	  	OtfAggregator
 Purpose: 	configures the OtfAggregator module in the PAC 
 Description:  This file is the API to the OtfAggregator module which is responsible for creating
 			the next transmission
***************************************************************/
#ifndef OTF_AGGREGATOR_API_H_
#define OTF_AGGREGATOR_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "Std.h"
#include "StaDb.h"
#include "mhi_umi_propr.h"
#include "PacketDescriptor.h"
#include "InterruptManager_Api.h"
#include "OSAL_Kmsg.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct _OtfAggregatorRecoverFromError_t
{
	uint8	stationIndex;
	uint8	tid;
	void*	headPd;
	void*	tailPd;	
#ifdef ENET_INC_ARCH_WAVE600B
	bool	etsi5GDuringPsduLimitError;			/* TRUE: PD is transmitted while Etsi is enabled, band is 5G and the error is Psdu Limit (WLANRTSYS-14443) */
#endif
} OtfAggregatorRecoverFromError_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void OtfAggregator_Reset(void);
void OtfAggregator_Initialize(void);
void OtfAggregator_ProcessReportQueue(void);
void OtfAggregator_ConfigureVapModeBitmap(uint8 vapId, bool vapMode);


#endif /* OTF_AGGREGATOR_API_H_ */


