/***********************************************************************************
 File:		PacExtrapolator_api.h
 Module:		PacExtrapolator
 Purpose: 	Handle PacExtrapolator 
 Description:	This file contains all definitions and the structures of the PacExtrapolator  
 				
************************************************************************************/
#ifndef PAC_EXTRA_API_
#define PAC_EXTRA_API_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "shram.h"
#include "loggerAPI.h"

//---------------------------------------------------------------------------------
//						Defines						
//--------------------------------------------------------------------------------- 
#define PAC_EXTRA_NUM_OF_PHY_WORDS_WLAN 			4
#define PAC_EXTRA_NUM_OF_LN_BETA_VALUES 			80
#define PAC_EXTRA_NUM_OF_ALPHA_FACTOR_WLAN_VALUES 	9
#define PAC_EXTRA_STA_RX_TIME_USAGE_OFFSET 			4
#define PAC_EXTRA_STA_NOISE_OFFSET 					5
#define PAC_EXTRA_ALPHA_FACTOR_VALUE 				0x100000
#define PAC_EXTRA_NUM_OF_ALPHA_FACTOR_STA_VALUES 	9*HW_NUM_OF_STATIONS
#define PAC_EXTRA_SIZE_OF_LN_BETA_VALUES 			PAC_EXTRA_NUM_OF_LN_BETA_VALUES/2

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
 
//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct pacExtrapolator_AlphaFactorWlan
{
	uint32 avgAlphaValue[PAC_EXTRA_NUM_OF_ALPHA_FACTOR_WLAN_VALUES];

} pacExtrapolator_AlphaFactorWlan_t;

typedef struct pacExtrapolator_AlphaFactorSta
{
	uint32 avgAlphaValue[PAC_EXTRA_NUM_OF_ALPHA_FACTOR_STA_VALUES];

} pacExtrapolator_AlphaFactorSta_t;

typedef struct pacExtrapolator_LnBetaValue
{
	uint16 LnBetaValue[PAC_EXTRA_NUM_OF_LN_BETA_VALUES];

} pacExtrapolator_LnBetaValue_t;




/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void pacExtrapolator_DisableModule(void);
#ifndef PAC_EXTRAPOLATOR_DISABLE_MIN_RSSI	
void pacExtrapolator_DisableMinRssiModule(void);
#endif

void pacExtrapolator_EnableModule(void);
#ifndef PAC_EXTRAPOLATOR_DISABLE_MIN_RSSI	
void pacExtrapolator_EnableMinRssiModule(void);
#endif

void pacExtrapolator_addSta(StaId staId, uint8 rssi);
void pacExtrapolator_removeSta(StaId staId);

#ifndef PAC_EXTRAPOLATOR_DISABLE_MIN_RSSI	
void pacExtrapolator_TriggerMinRssiModule(void);
#endif
void pacExtrapolator_Init(void);




#endif /* PAC_EXTRA_API_ */

