/***********************************************************************************
 File:		PacExtrapolator.c
 Module:		PacExtrapolator
 Purpose: 	 
 Description:	 
 				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Tasks.h"
#include "shram.h"
#include "PacExtrapolatorRegs.h"
#include "RegAccess_Api.h"
#include "ErrorHandler_Api.h"
#include "ShramPhyStatDb.h"
#include "loggerAPI.h"
#include "MT_Math.h"
#include "Utils_Api.h"
#include "ConfigurationManager_api.h"
#include "stringLibApi.h"
#include "Pac_Api.h"
#include "Statistics_Descriptors.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_PAC_MANAGER
#define LOG_LOCAL_FID 0


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
#define PAC_EXTRA_METHOD_BASIC_ALPHA_FILTER 0x0
#define PAC_EXTRA_METHOD_BASIC_ALPHA_BETA_FILTER 0x1
#define PAC_EXTRA_METHOD_COPY 0x2
#define PAC_EXTRA_DB_WLAN 0x1
#define PAC_EXTRA_DB_STA 0x0
#define PAC_EXTRA_GET_REGISTER_OFFSET(x) 	 HW_REG_SIZE*((x)>>5)
#define PAC_EXTRA_MODULO_32(x) 	 			 ((x)&0x1F)


/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************
pacExtrapolator_EnableModule



Description:
------------

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void pacExtrapolator_EnableModule()
{
	RegPacExtrapolatorExtrapControlCfg_u regPacExtrapolatorExtrapControlCfg;
	uint8	bandId;
	for (bandId = CONFIGURATION_MANAGER_BAND_0 ; bandId < ConfigurationManager_GetNumOfActiveBands() ; bandId++)
	{
		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_EXTRAP_CONTROL_CFG, &regPacExtrapolatorExtrapControlCfg.val, bandId);
		regPacExtrapolatorExtrapControlCfg.bitFields.extrapEn = TRUE;
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_EXTRAP_CONTROL_CFG, regPacExtrapolatorExtrapControlCfg.val, bandId);
	}	
}

#ifndef PAC_EXTRAPOLATOR_DISABLE_MIN_RSSI	
/**********************************************************************************
pacExtrapolator_Enable


Description:
------------

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void pacExtrapolator_EnableMinRssiModule()
{
	RegPacExtrapolatorMinRssiCfg_u regPacExtrapolatorMinRssiCfg;
	uint8	bandId;
	for (bandId = CONFIGURATION_MANAGER_BAND_0 ; bandId < ConfigurationManager_GetNumOfActiveBands() ; bandId++)
	{
		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_MIN_RSSI_CFG, &regPacExtrapolatorMinRssiCfg.val, bandId);
		regPacExtrapolatorMinRssiCfg.bitFields.minRssiEna = TRUE;
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_MIN_RSSI_CFG, regPacExtrapolatorMinRssiCfg.val, bandId);
	}
}
/**********************************************************************************
pacExtrapolator_Enable


Description:
------------

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void pacExtrapolator_TriggerMinRssiModule()
{
	RegPacExtrapolatorMinRssiCfg_u regPacExtrapolatorMinRssiCfg;
	uint8	bandId;
	for (bandId = CONFIGURATION_MANAGER_BAND_0 ; bandId < ConfigurationManager_GetNumOfActiveBands() ; bandId++)
	{
		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_MIN_RSSI_CFG, &regPacExtrapolatorMinRssiCfg.val, bandId);
		regPacExtrapolatorMinRssiCfg.bitFields.minRssiTrig = TRUE;
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_MIN_RSSI_CFG, regPacExtrapolatorMinRssiCfg.val, bandId);
	}
}
#endif

/**********************************************************************************
pacExtrapolator_Disable


Description:
------------

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
uint32 	tsfBefore = 0;
uint32	tsfAfter = 0;
uint8 pacExtrDumpTaken = FALSE;
uint32 pacExtrDumps [52] = {0};
void pacExtrapolator_DisableModule()
{
	RegPacExtrapolatorExtrapControlCfg_u 	regPacExtrapolatorExtrapControlCfg;
	RegPacExtrapolatorDebugExtrapSm_u		regPacExtrapolatorDebugExtrapSm;
	uint8	bandId;
	for (bandId = CONFIGURATION_MANAGER_BAND_0 ; bandId < ConfigurationManager_GetNumOfActiveBands() ; bandId++)
	{

		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_EXTRAP_CONTROL_CFG, &regPacExtrapolatorExtrapControlCfg.val, bandId);
		regPacExtrapolatorExtrapControlCfg.bitFields.extrapEn = FALSE;
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_EXTRAP_CONTROL_CFG, regPacExtrapolatorExtrapControlCfg.val, bandId);
		tsfBefore = Pac_TimGetTsfLowPerBand(bandId);
		do
		{
			//RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_EXTRAP_CONTROL_CFG, &regPacExtrapolatorExtrapControlCfg.val, bandId);

			RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_DEBUG_EXTRAP_SM, &regPacExtrapolatorDebugExtrapSm.val, bandId);
			tsfAfter = Pac_TimGetTsfLowPerBand(bandId);
			if (((tsfAfter - tsfBefore) > 5000)&& (pacExtrDumpTaken == FALSE))
			{
				pacExtrDumpTaken = TRUE;
				memcpy32(&pacExtrDumps[0],(uint32 *)(PAC_EXTRAPOLATOR_BASE_ADDRESS + (BAND1_INTERNAL_SIZE * bandId)),52);	
			
			}
			// debug for JIRA WLANRTSYS-2261: we want to know if we are stuck in this loop but if don't assert, the dump is not valid since cache was not flushed.
			if ((tsfAfter - tsfBefore) > 300000)
			{
				ASSERT(0);
			}	

		}while(regPacExtrapolatorDebugExtrapSm.bitFields.debugExtrapHwSm != 0);
		//}while(regPacExtrapolatorExtrapControlCfg.bitFields.extrapBusy == TRUE);

		ASSERT(pacExtrDumpTaken == FALSE);
	}
}

#ifndef PAC_EXTRAPOLATOR_DISABLE_MIN_RSSI	
/**********************************************************************************
pacExtrapolator_Disable


Description:
------------

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void pacExtrapolator_DisableMinRssiModule()
{
	RegPacExtrapolatorMinRssiCfg_u regPacExtrapolatorMinRssiCfg;
	uint8	bandId;
	for (bandId = CONFIGURATION_MANAGER_BAND_0 ; bandId < ConfigurationManager_GetNumOfActiveBands() ; bandId++)
	{	
		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_MIN_RSSI_CFG, &regPacExtrapolatorMinRssiCfg.val, bandId);
		regPacExtrapolatorMinRssiCfg.bitFields.minRssiEna = FALSE;
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_MIN_RSSI_CFG, regPacExtrapolatorMinRssiCfg.val, bandId);
	}
}
#endif

/**********************************************************************************
pacExtrapolator_AddSta




Description:
------------

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void pacExtrapolator_addSta(StaId staId, uint8 rssi)
{
	uint32 val;
	uint8 bandId  = ConfigurationManager_GetBandForStation(staId);

	if (staId < 128)
	{
		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_STA_EN_0_31 + PAC_EXTRA_GET_REGISTER_OFFSET(staId), &val, bandId);
		val |= 1<<(PAC_EXTRA_MODULO_32(staId));
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_STA_EN_0_31 + PAC_EXTRA_GET_REGISTER_OFFSET(staId), val, bandId);
	}
	else
	{
		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_STA_EN_128_159 + PAC_EXTRA_GET_REGISTER_OFFSET(staId-128), &val, bandId);
		val |= 1<<(PAC_EXTRA_MODULO_32(staId));
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_STA_EN_128_159 + PAC_EXTRA_GET_REGISTER_OFFSET(staId-128), val, bandId);
	}
	// convert maxRssi from dB to dBm and move it to the pac extrapolator
	pacExtrapolatorRssi.maxRssi[staId] = (int8)MAX((int16)(rssi - StatisticsHandler_returnRssiToDbmVal()), (int16)RX_THRESHOLD_DEFAULT_VALUE);
	/* Reset min rssi to current rssi */
	pacExtrapolatorRssi.minRssi[staId] = (int8)MIN((int16)(rssi - StatisticsHandler_returnRssiToDbmVal()), (int16)MAX_INT8);
}
/**********************************************************************************
pacExtrapolator_AddSta




Description:
------------

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void pacExtrapolator_removeSta(StaId staId)
{
	uint32 val;
	uint8 bandId  = ConfigurationManager_GetBandForStation(staId);

	if (staId < 128)
	{
		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_STA_EN_0_31 + PAC_EXTRA_GET_REGISTER_OFFSET(staId), &val, bandId);
		val &= ~(1<<(PAC_EXTRA_MODULO_32(staId)));
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_STA_EN_0_31 +PAC_EXTRA_GET_REGISTER_OFFSET(staId), val, bandId);
	}
	else
	{
		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_STA_EN_128_159 + PAC_EXTRA_GET_REGISTER_OFFSET(staId - 128), &val, bandId);
		val &= ~(1<<(PAC_EXTRA_MODULO_32(staId)));
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_STA_EN_128_159 + PAC_EXTRA_GET_REGISTER_OFFSET(staId - 128), val, bandId);
	}

	
	pacExtrapolatorRssi.maxRssi[staId] = (int16)RX_THRESHOLD_DEFAULT_VALUE;				
	pacExtrapolatorRssi.minRssi[staId] = (int16)MAX_INT8;
}	


/**********************************************************************************
pacExtrapolator_Init


Description:
------------
	 Initialization of phy stats
Input:
-----
	None
Output:
-------
	None
Returns:
--------
	None
**********************************************************************************/

void pacExtrapolator_Init()
{
	uint8 bandId = CONFIGURATION_MANAGER_BAND_0;
	StaId staId = 0;
	RegPacExtrapolatorExtrapControlCfg_u 			regPacExtrapolatorExtrapControlCfg;
	RegPacExtrapolatorExtrapWord07Cfg_u				regPacExtrapolatorExtrapWord07Cfg;
	RegPacExtrapolatorOffsetPhyWord07_u				regPacExtrapolatorOffsetPhyWord07;
	RegPacExtrapolatorOffsetAvgDeltaT_u				regPacExtrapolatorOffsetAvgDeltaT;
	RegPacExtrapolatorOffsetTsf_u					regPacExtrapolatorOffsetTsf;
	RegPacExtrapolatorStaEntrySize_u				regPacExtrapolatorStaEntrySize;
	RegPacExtrapolatorPhyWordsWlanDbBaseAddr_u		regPacExtrapolatorPhyWordsWlanDbBaseAddr;
	RegPacExtrapolatorAlfaFactorsWlanDbBaseAddr_u 	regPacExtrapolatorAlfaFactorsWlanDbBaseAddr;
	RegPacExtrapolatorAlfaFactorsStaDbBaseAddr_u	regPacExtrapolatorAlfaFactorsStaDbBaseAddr;
	RegPacExtrapolatorLnBetaLutBaseAddr_u			regPacExtrapolatorLnBetaLutBaseAddr;
	RegPacExtrapolatorMinRssiDbBase_u				regPacExtrapolatorMinRssiDbBase;
	RegPacExtrapolatorMinRssiCfg_u					regPacExtrapolatorMinRssiCfg;
	RegPacExtrapolatorPhyWordsStaDbBaseAddr_u		regPacExtrapolatorPhyWordsStaDbBaseAddr;

	//Noise est ant 0,1,2 and 3
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word0UpdateEn =	TRUE;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word0Db = 		PAC_EXTRA_DB_WLAN; 
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word0Method =  	PAC_EXTRA_METHOD_BASIC_ALPHA_FILTER;
	//Noise offset indicates word index at entry
	regPacExtrapolatorOffsetPhyWord07.bitFields.offsetWord0 = 	0x0;
	
	//RF Gain ant 0,1,2 and 3
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word1UpdateEn = TRUE;	
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word1Db = 		PAC_EXTRA_DB_WLAN; 			
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word1Method =  	PAC_EXTRA_METHOD_BASIC_ALPHA_FILTER;
	//RF Gain offset indicates word index at entry
	regPacExtrapolatorOffsetPhyWord07.bitFields.offsetWord1 = 	0x1 ;

	//RSSI ant 0,1,2 and 3
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word2UpdateEn = TRUE;	
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word2Db = 		PAC_EXTRA_DB_STA; 
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word2Method =  	PAC_EXTRA_METHOD_BASIC_ALPHA_FILTER;
	//RSSI offset indicates word index at entry
	regPacExtrapolatorOffsetPhyWord07.bitFields.offsetWord2 = 	0x0 ;

	//PHY rate
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word3UpdateEn = TRUE;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word3Db = 		PAC_EXTRA_DB_STA;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word3Method =  	PAC_EXTRA_METHOD_COPY;
	//PHY rate offset indicates word index at entry
	regPacExtrapolatorOffsetPhyWord07.bitFields.offsetWord3 = 	0x1 ;		

	//IRAD to WLAN
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word4UpdateEn = TRUE;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word4Db = 		PAC_EXTRA_DB_WLAN;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word4Method =  	PAC_EXTRA_METHOD_BASIC_ALPHA_FILTER;
	///IRAD offset to WLAN indicates word index at entry
	regPacExtrapolatorOffsetAvgDeltaT.bitFields.offsetAvgDeltaTWlan = 0x2;

	//IRAD to STA
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word5UpdateEn = TRUE;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word5Db = 		PAC_EXTRA_DB_STA;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word5Method =  	PAC_EXTRA_METHOD_BASIC_ALPHA_FILTER;
	//IRAD offset to Sta indicates word index at entry
	regPacExtrapolatorOffsetAvgDeltaT.bitFields.offsetAvgDeltaTSta = 0x2 ;

	//TSF to WLAN
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word6UpdateEn = TRUE;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word6Db = 		PAC_EXTRA_DB_WLAN;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word6Method =  	PAC_EXTRA_METHOD_COPY;
	//TSF to WLAN offset indicates word index at entry
	regPacExtrapolatorOffsetTsf.bitFields.offsetTsfWlan = 		0x3;

	//TSF to STA
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word7UpdateEn = TRUE;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word7Db = 		PAC_EXTRA_DB_STA;
	regPacExtrapolatorExtrapWord07Cfg.bitFields.word7Method =  	PAC_EXTRA_METHOD_COPY;
	//TSF to WLAN offset indicates word index at entry
	regPacExtrapolatorOffsetTsf.bitFields.offsetTsfSta = 		0x3;


	//STA entry size in DB
	ASSERT(CONVERT_BYTES_TO_WORDS(sizeof(stationPhyRxStatusDb_t)) < 16); // only 4 bits are used
	regPacExtrapolatorStaEntrySize.bitFields.staEntrySize = 	CONVERT_BYTES_TO_WORDS(sizeof(stationPhyRxStatusDb_t));

	// PHY words sta DB base address at SHRAM, word aligned
	regPacExtrapolatorPhyWordsStaDbBaseAddr.bitFields.wordsStaDbBaseAddr = (uint32)phyRxStatusDb.staPhyRxStatus - (uint32)SHARED_RAM_BASE_ADDR;
	
	memset32(&pacExtrapolatorAlphaFactorWlan, PAC_EXTRA_ALPHA_FACTOR_VALUE,PAC_EXTRA_NUM_OF_ALPHA_FACTOR_WLAN_VALUES);
	// Alfa factors wlan DB base address at SHRAM, word aligned 
	regPacExtrapolatorAlfaFactorsWlanDbBaseAddr.bitFields.alfaFactorsWlanDbBaseAddr = (uint32)&pacExtrapolatorAlphaFactorWlan - (uint32)SHARED_RAM_BASE_ADDR;

	memset32(&pacExtrapolatorAlphaFactorSta, PAC_EXTRA_ALPHA_FACTOR_VALUE,PAC_EXTRA_NUM_OF_ALPHA_FACTOR_STA_VALUES);
	// Alfa factors sta DB base address at SHRAM, word aligned
	regPacExtrapolatorAlfaFactorsStaDbBaseAddr.bitFields.alfaFactorsStaDbBaseAddr = (uint32)&pacExtrapolatorAlphaFactorSta - (uint32)SHARED_RAM_BASE_ADDR;

	memset (&pacExtrapolatorLnBetaValue, 0x0, sizeof(pacExtrapolator_LnBetaValue_t));
	// Ln Beta LUT base address at SHRAM, word aligned
	regPacExtrapolatorLnBetaLutBaseAddr.bitFields.lnBetaLutBaseAddr = (uint32)&pacExtrapolatorLnBetaValue - (uint32)SHARED_RAM_BASE_ADDR;

	for (staId =0;staId<HW_NUM_OF_STATIONS;staId++)
	{
		pacExtrapolatorRssi.maxRssi[staId] = RX_THRESHOLD_DEFAULT_VALUE;
		pacExtrapolatorRssi.minRssi[staId] = MAX_INT8;
	}
	// Base address of "Minimal RSSI per STA" database
	regPacExtrapolatorMinRssiDbBase.bitFields.minRssiDbBase =(uint32)&pacExtrapolatorRssi - (uint32)SHARED_RAM_BASE_ADDR;	

	// PHY words wlan DB base address at SHRAM, word aligned 
	regPacExtrapolatorPhyWordsWlanDbBaseAddr.bitFields.wordsWlanDbBaseAddr = (uint32)&phyRxStatusDb.devicePhyRxStatus[CONFIGURATION_MANAGER_BAND_0] - (uint32)SHARED_RAM_BASE_ADDR;
	RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_PHY_WORDS_WLAN_DB_BASE_ADDR,regPacExtrapolatorPhyWordsWlanDbBaseAddr.val,CONFIGURATION_MANAGER_BAND_0);



	if (ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_DUAL_BAND)
	{
		// PHY words wlan DB base address at SHRAM, word aligned 
		regPacExtrapolatorPhyWordsWlanDbBaseAddr.bitFields.wordsWlanDbBaseAddr = (uint32)&phyRxStatusDb.devicePhyRxStatus[CONFIGURATION_MANAGER_BAND_1] - (uint32)SHARED_RAM_BASE_ADDR;
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_PHY_WORDS_WLAN_DB_BASE_ADDR,regPacExtrapolatorPhyWordsWlanDbBaseAddr.val,CONFIGURATION_MANAGER_BAND_1);
	}

	for (bandId = CONFIGURATION_MANAGER_BAND_0 ; bandId < ConfigurationManager_GetNumOfActiveBands() ; bandId++)
	{
		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_EXTRAP_CONTROL_CFG,&regPacExtrapolatorExtrapControlCfg.val,bandId);
		regPacExtrapolatorExtrapControlCfg.bitFields.wlanDbUpdEn = TRUE;
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_EXTRAP_CONTROL_CFG,regPacExtrapolatorExtrapControlCfg.val,bandId);

		RegAccess_ReadPerBand(REG_PAC_EXTRAPOLATOR_MIN_RSSI_CFG,&regPacExtrapolatorMinRssiCfg.val,bandId);
		// Single Band (0) or CDB mode (1)
		if (ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_DUAL_BAND)
		{
			regPacExtrapolatorMinRssiCfg.bitFields.minRssiCdb = TRUE;
		}
		// Min RSSI treshold - value to provide to Phy when all STA's are 80h
		regPacExtrapolatorMinRssiCfg.bitFields.minRssiTrsh = 0x80;
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_MIN_RSSI_CFG,regPacExtrapolatorMinRssiCfg.val,bandId);
		
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_EXTRAP_WORD_0_7_CFG,regPacExtrapolatorExtrapWord07Cfg.val,bandId);
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_OFFSET_PHY_WORD_0_7,regPacExtrapolatorOffsetPhyWord07.val,bandId);
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_OFFSET_AVG_DELTA_T,regPacExtrapolatorOffsetAvgDeltaT.val,bandId);
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_OFFSET_TSF,regPacExtrapolatorOffsetTsf.val,bandId);
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_STA_ENTRY_SIZE,regPacExtrapolatorStaEntrySize.val,bandId);
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_ALFA_FACTORS_WLAN_DB_BASE_ADDR,regPacExtrapolatorAlfaFactorsWlanDbBaseAddr.val,bandId);
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_ALFA_FACTORS_STA_DB_BASE_ADDR,regPacExtrapolatorAlfaFactorsStaDbBaseAddr.val,bandId);
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_LN_BETA_LUT_BASE_ADDR,regPacExtrapolatorLnBetaLutBaseAddr.val,bandId);
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_MIN_RSSI_DB_BASE,regPacExtrapolatorMinRssiDbBase.val,bandId);
		RegAccess_WritePerBand(REG_PAC_EXTRAPOLATOR_PHY_WORDS_STA_DB_BASE_ADDR,regPacExtrapolatorPhyWordsStaDbBaseAddr.val,bandId);		

	}

	pacExtrapolator_EnableModule();
#ifndef PAC_EXTRAPOLATOR_DISABLE_MIN_RSSI	
	pacExtrapolator_EnableMinRssiModule();
#endif
	

}



